# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSettingsResult',
    'AwaitableGetSettingsResult',
    'get_settings',
    'get_settings_output',
]

@pulumi.output_type
class GetSettingsResult:
    """
    A collection of values returned by getSettings.
    """
    def __init__(__self__, config_id=None, id=None, key_filter_regex=None, settings=None):
        if config_id and not isinstance(config_id, str):
            raise TypeError("Expected argument 'config_id' to be a str")
        pulumi.set(__self__, "config_id", config_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_filter_regex and not isinstance(key_filter_regex, str):
            raise TypeError("Expected argument 'key_filter_regex' to be a str")
        pulumi.set(__self__, "key_filter_regex", key_filter_regex)
        if settings and not isinstance(settings, list):
            raise TypeError("Expected argument 'settings' to be a list")
        pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> str:
        """
        The ID of the Config.
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal ID of the data source. Do not use.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyFilterRegex")
    def key_filter_regex(self) -> Optional[str]:
        """
        Filter the Feature Flags or Settingss by key.
        """
        return pulumi.get(self, "key_filter_regex")

    @property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.GetSettingsSettingResult']:
        return pulumi.get(self, "settings")


class AwaitableGetSettingsResult(GetSettingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSettingsResult(
            config_id=self.config_id,
            id=self.id,
            key_filter_regex=self.key_filter_regex,
            settings=self.settings)


def get_settings(config_id: Optional[str] = None,
                 key_filter_regex: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSettingsResult:
    """
    Use this data source to access information about existing **Feature Flags or Settings**. [What is a Feature Flag or Setting in ConfigCat?](https://configcat.com/docs/main-concepts)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_configcat as configcat

    config = pulumi.Config()
    config_id = config.require("configId")
    settings = configcat.get_settings(config_id=config_id,
        key_filter_regex="isAwesomeFeatureEnabled")
    pulumi.export("settingId", settings.settings[0].setting_id)
    ```


    :param str config_id: The ID of the Config.
    :param str key_filter_regex: Filter the Feature Flags or Settingss by key.
    """
    __args__ = dict()
    __args__['configId'] = config_id
    __args__['keyFilterRegex'] = key_filter_regex
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('configcat:index/getSettings:getSettings', __args__, opts=opts, typ=GetSettingsResult).value

    return AwaitableGetSettingsResult(
        config_id=pulumi.get(__ret__, 'config_id'),
        id=pulumi.get(__ret__, 'id'),
        key_filter_regex=pulumi.get(__ret__, 'key_filter_regex'),
        settings=pulumi.get(__ret__, 'settings'))
def get_settings_output(config_id: Optional[pulumi.Input[str]] = None,
                        key_filter_regex: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSettingsResult]:
    """
    Use this data source to access information about existing **Feature Flags or Settings**. [What is a Feature Flag or Setting in ConfigCat?](https://configcat.com/docs/main-concepts)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_configcat as configcat

    config = pulumi.Config()
    config_id = config.require("configId")
    settings = configcat.get_settings(config_id=config_id,
        key_filter_regex="isAwesomeFeatureEnabled")
    pulumi.export("settingId", settings.settings[0].setting_id)
    ```


    :param str config_id: The ID of the Config.
    :param str key_filter_regex: Filter the Feature Flags or Settingss by key.
    """
    __args__ = dict()
    __args__['configId'] = config_id
    __args__['keyFilterRegex'] = key_filter_regex
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('configcat:index/getSettings:getSettings', __args__, opts=opts, typ=GetSettingsResult)
    return __ret__.apply(lambda __response__: GetSettingsResult(
        config_id=pulumi.get(__response__, 'config_id'),
        id=pulumi.get(__response__, 'id'),
        key_filter_regex=pulumi.get(__response__, 'key_filter_regex'),
        settings=pulumi.get(__response__, 'settings')))
