# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetWebhookSigningKeysResult',
    'AwaitableGetWebhookSigningKeysResult',
    'get_webhook_signing_keys',
    'get_webhook_signing_keys_output',
]

@pulumi.output_type
class GetWebhookSigningKeysResult:
    """
    A collection of values returned by getWebhookSigningKeys.
    """
    def __init__(__self__, id=None, key1=None, key2=None, webhook_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key1 and not isinstance(key1, str):
            raise TypeError("Expected argument 'key1' to be a str")
        pulumi.set(__self__, "key1", key1)
        if key2 and not isinstance(key2, str):
            raise TypeError("Expected argument 'key2' to be a str")
        pulumi.set(__self__, "key2", key2)
        if webhook_id and not isinstance(webhook_id, int):
            raise TypeError("Expected argument 'webhook_id' to be a int")
        pulumi.set(__self__, "webhook_id", webhook_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Internal ID of the data source. Do not use.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key1(self) -> str:
        """
        The first signing key.
        """
        return pulumi.get(self, "key1")

    @property
    @pulumi.getter
    def key2(self) -> str:
        """
        The second signing key.
        """
        return pulumi.get(self, "key2")

    @property
    @pulumi.getter(name="webhookId")
    def webhook_id(self) -> int:
        """
        The ID of the Webhook.
        """
        return pulumi.get(self, "webhook_id")


class AwaitableGetWebhookSigningKeysResult(GetWebhookSigningKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWebhookSigningKeysResult(
            id=self.id,
            key1=self.key1,
            key2=self.key2,
            webhook_id=self.webhook_id)


def get_webhook_signing_keys(webhook_id: Optional[int] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWebhookSigningKeysResult:
    """
    Use this data source to access information about **Webhook Signing Keys**. [What is a Webhook in ConfigCat?](https://configcat.com/docs/advanced/notifications-webhooks/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_configcat as configcat

    config = pulumi.Config()
    webhook_id = config.require_float("webhookId")
    test = configcat.get_webhook_signing_keys(webhook_id=webhook_id)
    pulumi.export("key1", test.key1)
    pulumi.export("key2", test.key2)
    ```


    :param int webhook_id: The ID of the Webhook.
    """
    __args__ = dict()
    __args__['webhookId'] = webhook_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('configcat:index/getWebhookSigningKeys:getWebhookSigningKeys', __args__, opts=opts, typ=GetWebhookSigningKeysResult).value

    return AwaitableGetWebhookSigningKeysResult(
        id=pulumi.get(__ret__, 'id'),
        key1=pulumi.get(__ret__, 'key1'),
        key2=pulumi.get(__ret__, 'key2'),
        webhook_id=pulumi.get(__ret__, 'webhook_id'))
def get_webhook_signing_keys_output(webhook_id: Optional[pulumi.Input[int]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWebhookSigningKeysResult]:
    """
    Use this data source to access information about **Webhook Signing Keys**. [What is a Webhook in ConfigCat?](https://configcat.com/docs/advanced/notifications-webhooks/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_configcat as configcat

    config = pulumi.Config()
    webhook_id = config.require_float("webhookId")
    test = configcat.get_webhook_signing_keys(webhook_id=webhook_id)
    pulumi.export("key1", test.key1)
    pulumi.export("key2", test.key2)
    ```


    :param int webhook_id: The ID of the Webhook.
    """
    __args__ = dict()
    __args__['webhookId'] = webhook_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('configcat:index/getWebhookSigningKeys:getWebhookSigningKeys', __args__, opts=opts, typ=GetWebhookSigningKeysResult)
    return __ret__.apply(lambda __response__: GetWebhookSigningKeysResult(
        id=pulumi.get(__response__, 'id'),
        key1=pulumi.get(__response__, 'key1'),
        key2=pulumi.get(__response__, 'key2'),
        webhook_id=pulumi.get(__response__, 'webhook_id')))
