# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'SettingValuePercentageItem',
    'SettingValueRolloutRule',
    'SettingValueV2TargetingRule',
    'SettingValueV2TargetingRuleCondition',
    'SettingValueV2TargetingRuleConditionPrerequisiteFlagCondition',
    'SettingValueV2TargetingRuleConditionPrerequisiteFlagConditionComparisonValue',
    'SettingValueV2TargetingRuleConditionSegmentCondition',
    'SettingValueV2TargetingRuleConditionUserCondition',
    'SettingValueV2TargetingRuleConditionUserConditionComparisonValue',
    'SettingValueV2TargetingRuleConditionUserConditionComparisonValueListValue',
    'SettingValueV2TargetingRulePercentageOption',
    'SettingValueV2TargetingRulePercentageOptionValue',
    'SettingValueV2TargetingRuleValue',
    'SettingValueV2Value',
    'WebhookSecureWebhookHeader',
    'WebhookWebhookHeader',
    'GetConfigurationsConfigResult',
    'GetEnvironmentsEnvironmentResult',
    'GetOrganizationsOrganizationResult',
    'GetPermissionGroupsPermissionGroupResult',
    'GetProductsProductResult',
    'GetSegmentsSegmentResult',
    'GetSettingsSettingResult',
    'GetTagsTagResult',
]

@pulumi.output_type
class SettingValuePercentageItem(dict):
    def __init__(__self__, *,
                 percentage: str,
                 value: str):
        """
        :param str percentage: Any [number](https://configcat.com/docs/advanced/targeting/#-value) between 0 and 100 that represents a randomly allocated fraction of your users.
        :param str value: The exact [value](https://configcat.com/docs/advanced/targeting/#served-value-1) that will be served to the users that fall into that fraction. Type: `string`. It must be compatible with the `setting_type`.
        """
        pulumi.set(__self__, "percentage", percentage)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def percentage(self) -> str:
        """
        Any [number](https://configcat.com/docs/advanced/targeting/#-value) between 0 and 100 that represents a randomly allocated fraction of your users.
        """
        return pulumi.get(self, "percentage")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The exact [value](https://configcat.com/docs/advanced/targeting/#served-value-1) that will be served to the users that fall into that fraction. Type: `string`. It must be compatible with the `setting_type`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SettingValueRolloutRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "comparisonAttribute":
            suggest = "comparison_attribute"
        elif key == "comparisonValue":
            suggest = "comparison_value"
        elif key == "segmentComparator":
            suggest = "segment_comparator"
        elif key == "segmentId":
            suggest = "segment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingValueRolloutRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingValueRolloutRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingValueRolloutRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: str,
                 comparator: Optional[str] = None,
                 comparison_attribute: Optional[str] = None,
                 comparison_value: Optional[str] = None,
                 segment_comparator: Optional[str] = None,
                 segment_id: Optional[str] = None):
        """
        :param str value: The exact [value](https://configcat.com/docs/advanced/targeting/#served-value) that will be served to the users who match the targeting rule. Type: `string`. It must be compatible with the `setting_type`.
        :param str comparator: The [comparator](https://configcat.com/docs/advanced/targeting/#comparator).
        :param str comparison_attribute: The [comparison attribute](https://configcat.com/docs/advanced/targeting/#comparison-attribute).
        :param str comparison_value: The [comparison value](https://configcat.com/docs/advanced/targeting/#comparison-value).
        :param str segment_comparator: The segment_comparator. Possible values: isIn, isNotIn.
        :param str segment_id: The [Segment's](https://configcat.com/docs/advanced/segments) unique identifier.
        """
        pulumi.set(__self__, "value", value)
        if comparator is not None:
            pulumi.set(__self__, "comparator", comparator)
        if comparison_attribute is not None:
            pulumi.set(__self__, "comparison_attribute", comparison_attribute)
        if comparison_value is not None:
            pulumi.set(__self__, "comparison_value", comparison_value)
        if segment_comparator is not None:
            pulumi.set(__self__, "segment_comparator", segment_comparator)
        if segment_id is not None:
            pulumi.set(__self__, "segment_id", segment_id)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The exact [value](https://configcat.com/docs/advanced/targeting/#served-value) that will be served to the users who match the targeting rule. Type: `string`. It must be compatible with the `setting_type`.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def comparator(self) -> Optional[str]:
        """
        The [comparator](https://configcat.com/docs/advanced/targeting/#comparator).
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter(name="comparisonAttribute")
    def comparison_attribute(self) -> Optional[str]:
        """
        The [comparison attribute](https://configcat.com/docs/advanced/targeting/#comparison-attribute).
        """
        return pulumi.get(self, "comparison_attribute")

    @property
    @pulumi.getter(name="comparisonValue")
    def comparison_value(self) -> Optional[str]:
        """
        The [comparison value](https://configcat.com/docs/advanced/targeting/#comparison-value).
        """
        return pulumi.get(self, "comparison_value")

    @property
    @pulumi.getter(name="segmentComparator")
    def segment_comparator(self) -> Optional[str]:
        """
        The segment_comparator. Possible values: isIn, isNotIn.
        """
        return pulumi.get(self, "segment_comparator")

    @property
    @pulumi.getter(name="segmentId")
    def segment_id(self) -> Optional[str]:
        """
        The [Segment's](https://configcat.com/docs/advanced/segments) unique identifier.
        """
        return pulumi.get(self, "segment_id")


@pulumi.output_type
class SettingValueV2TargetingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "percentageOptions":
            suggest = "percentage_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingValueV2TargetingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingValueV2TargetingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingValueV2TargetingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.SettingValueV2TargetingRuleCondition']] = None,
                 percentage_options: Optional[Sequence['outputs.SettingValueV2TargetingRulePercentageOption']] = None,
                 value: Optional['outputs.SettingValueV2TargetingRuleValue'] = None):
        """
        :param Sequence['SettingValueV2TargetingRuleConditionArgs'] conditions: The conditions that are combined with the AND logical operator.
        :param Sequence['SettingValueV2TargetingRulePercentageOptionArgs'] percentage_options: The percentage options from where the evaluation process will choose a value based on the flag's percentage evaluation attribute.
        :param 'SettingValueV2TargetingRuleValueArgs' value: Represents the value of a Feature Flag or Setting.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if percentage_options is not None:
            pulumi.set(__self__, "percentage_options", percentage_options)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.SettingValueV2TargetingRuleCondition']]:
        """
        The conditions that are combined with the AND logical operator.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="percentageOptions")
    def percentage_options(self) -> Optional[Sequence['outputs.SettingValueV2TargetingRulePercentageOption']]:
        """
        The percentage options from where the evaluation process will choose a value based on the flag's percentage evaluation attribute.
        """
        return pulumi.get(self, "percentage_options")

    @property
    @pulumi.getter
    def value(self) -> Optional['outputs.SettingValueV2TargetingRuleValue']:
        """
        Represents the value of a Feature Flag or Setting.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SettingValueV2TargetingRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prerequisiteFlagCondition":
            suggest = "prerequisite_flag_condition"
        elif key == "segmentCondition":
            suggest = "segment_condition"
        elif key == "userCondition":
            suggest = "user_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingValueV2TargetingRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingValueV2TargetingRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingValueV2TargetingRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prerequisite_flag_condition: Optional['outputs.SettingValueV2TargetingRuleConditionPrerequisiteFlagCondition'] = None,
                 segment_condition: Optional['outputs.SettingValueV2TargetingRuleConditionSegmentCondition'] = None,
                 user_condition: Optional['outputs.SettingValueV2TargetingRuleConditionUserCondition'] = None):
        """
        :param 'SettingValueV2TargetingRuleConditionPrerequisiteFlagConditionArgs' prerequisite_flag_condition: Describes a condition that is based on a prerequisite flag.
        :param 'SettingValueV2TargetingRuleConditionSegmentConditionArgs' segment_condition: Describes a condition that is based on a segment.
        :param 'SettingValueV2TargetingRuleConditionUserConditionArgs' user_condition: Describes a condition that is based on user attributes.
        """
        if prerequisite_flag_condition is not None:
            pulumi.set(__self__, "prerequisite_flag_condition", prerequisite_flag_condition)
        if segment_condition is not None:
            pulumi.set(__self__, "segment_condition", segment_condition)
        if user_condition is not None:
            pulumi.set(__self__, "user_condition", user_condition)

    @property
    @pulumi.getter(name="prerequisiteFlagCondition")
    def prerequisite_flag_condition(self) -> Optional['outputs.SettingValueV2TargetingRuleConditionPrerequisiteFlagCondition']:
        """
        Describes a condition that is based on a prerequisite flag.
        """
        return pulumi.get(self, "prerequisite_flag_condition")

    @property
    @pulumi.getter(name="segmentCondition")
    def segment_condition(self) -> Optional['outputs.SettingValueV2TargetingRuleConditionSegmentCondition']:
        """
        Describes a condition that is based on a segment.
        """
        return pulumi.get(self, "segment_condition")

    @property
    @pulumi.getter(name="userCondition")
    def user_condition(self) -> Optional['outputs.SettingValueV2TargetingRuleConditionUserCondition']:
        """
        Describes a condition that is based on user attributes.
        """
        return pulumi.get(self, "user_condition")


@pulumi.output_type
class SettingValueV2TargetingRuleConditionPrerequisiteFlagCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "comparisonValue":
            suggest = "comparison_value"
        elif key == "prerequisiteSettingId":
            suggest = "prerequisite_setting_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingValueV2TargetingRuleConditionPrerequisiteFlagCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingValueV2TargetingRuleConditionPrerequisiteFlagCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingValueV2TargetingRuleConditionPrerequisiteFlagCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparator: str,
                 comparison_value: 'outputs.SettingValueV2TargetingRuleConditionPrerequisiteFlagConditionComparisonValue',
                 prerequisite_setting_id: str):
        """
        :param str comparator: Prerequisite flag comparison operator used during the evaluation process. Possible values: `equals`,`doesNotEqual`
        :param 'SettingValueV2TargetingRuleConditionPrerequisiteFlagConditionComparisonValueArgs' comparison_value: Represents the value of a Feature Flag or Setting.
        :param str prerequisite_setting_id: The prerequisite flag's identifier.
        """
        pulumi.set(__self__, "comparator", comparator)
        pulumi.set(__self__, "comparison_value", comparison_value)
        pulumi.set(__self__, "prerequisite_setting_id", prerequisite_setting_id)

    @property
    @pulumi.getter
    def comparator(self) -> str:
        """
        Prerequisite flag comparison operator used during the evaluation process. Possible values: `equals`,`doesNotEqual`
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter(name="comparisonValue")
    def comparison_value(self) -> 'outputs.SettingValueV2TargetingRuleConditionPrerequisiteFlagConditionComparisonValue':
        """
        Represents the value of a Feature Flag or Setting.
        """
        return pulumi.get(self, "comparison_value")

    @property
    @pulumi.getter(name="prerequisiteSettingId")
    def prerequisite_setting_id(self) -> str:
        """
        The prerequisite flag's identifier.
        """
        return pulumi.get(self, "prerequisite_setting_id")


@pulumi.output_type
class SettingValueV2TargetingRuleConditionPrerequisiteFlagConditionComparisonValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boolValue":
            suggest = "bool_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "intValue":
            suggest = "int_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingValueV2TargetingRuleConditionPrerequisiteFlagConditionComparisonValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingValueV2TargetingRuleConditionPrerequisiteFlagConditionComparisonValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingValueV2TargetingRuleConditionPrerequisiteFlagConditionComparisonValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bool_value: Optional[bool] = None,
                 double_value: Optional[float] = None,
                 int_value: Optional[int] = None,
                 string_value: Optional[str] = None):
        """
        :param bool bool_value: The boolean representation of the value.
        :param float double_value: The decimal number representation of the value.
        :param int int_value: The whole number representation of the value.
        :param str string_value: The string representation of the value.
        """
        if bool_value is not None:
            pulumi.set(__self__, "bool_value", bool_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if int_value is not None:
            pulumi.set(__self__, "int_value", int_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="boolValue")
    def bool_value(self) -> Optional[bool]:
        """
        The boolean representation of the value.
        """
        return pulumi.get(self, "bool_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[float]:
        """
        The decimal number representation of the value.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="intValue")
    def int_value(self) -> Optional[int]:
        """
        The whole number representation of the value.
        """
        return pulumi.get(self, "int_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[str]:
        """
        The string representation of the value.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class SettingValueV2TargetingRuleConditionSegmentCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "segmentId":
            suggest = "segment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingValueV2TargetingRuleConditionSegmentCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingValueV2TargetingRuleConditionSegmentCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingValueV2TargetingRuleConditionSegmentCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparator: str,
                 segment_id: str):
        """
        :param str comparator: The segment comparison operator used during the evaluation process. Possible values: `isIn`,`isNotIn`
        :param str segment_id: The segment's identifier.
        """
        pulumi.set(__self__, "comparator", comparator)
        pulumi.set(__self__, "segment_id", segment_id)

    @property
    @pulumi.getter
    def comparator(self) -> str:
        """
        The segment comparison operator used during the evaluation process. Possible values: `isIn`,`isNotIn`
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter(name="segmentId")
    def segment_id(self) -> str:
        """
        The segment's identifier.
        """
        return pulumi.get(self, "segment_id")


@pulumi.output_type
class SettingValueV2TargetingRuleConditionUserCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "comparisonAttribute":
            suggest = "comparison_attribute"
        elif key == "comparisonValue":
            suggest = "comparison_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingValueV2TargetingRuleConditionUserCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingValueV2TargetingRuleConditionUserCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingValueV2TargetingRuleConditionUserCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparator: str,
                 comparison_attribute: str,
                 comparison_value: 'outputs.SettingValueV2TargetingRuleConditionUserConditionComparisonValue'):
        """
        :param str comparator: The comparison operator which defines the relation between the comparison attribute and the comparison value. For possible values check the [documentation](https://api.configcat.com/docs/index.html#tag/Feature-Flag-and-Setting-values-V2/operation/replace-setting-value-v2).
        :param str comparison_attribute: The User Object attribute that the condition is based on.
        :param 'SettingValueV2TargetingRuleConditionUserConditionComparisonValueArgs' comparison_value: The value that the user object's attribute is compared to.
        """
        pulumi.set(__self__, "comparator", comparator)
        pulumi.set(__self__, "comparison_attribute", comparison_attribute)
        pulumi.set(__self__, "comparison_value", comparison_value)

    @property
    @pulumi.getter
    def comparator(self) -> str:
        """
        The comparison operator which defines the relation between the comparison attribute and the comparison value. For possible values check the [documentation](https://api.configcat.com/docs/index.html#tag/Feature-Flag-and-Setting-values-V2/operation/replace-setting-value-v2).
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter(name="comparisonAttribute")
    def comparison_attribute(self) -> str:
        """
        The User Object attribute that the condition is based on.
        """
        return pulumi.get(self, "comparison_attribute")

    @property
    @pulumi.getter(name="comparisonValue")
    def comparison_value(self) -> 'outputs.SettingValueV2TargetingRuleConditionUserConditionComparisonValue':
        """
        The value that the user object's attribute is compared to.
        """
        return pulumi.get(self, "comparison_value")


@pulumi.output_type
class SettingValueV2TargetingRuleConditionUserConditionComparisonValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "doubleValue":
            suggest = "double_value"
        elif key == "listValues":
            suggest = "list_values"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingValueV2TargetingRuleConditionUserConditionComparisonValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingValueV2TargetingRuleConditionUserConditionComparisonValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingValueV2TargetingRuleConditionUserConditionComparisonValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 double_value: Optional[float] = None,
                 list_values: Optional[Sequence['outputs.SettingValueV2TargetingRuleConditionUserConditionComparisonValueListValue']] = None,
                 string_value: Optional[str] = None):
        """
        :param float double_value: The number representation of the comparison value.
        :param Sequence['SettingValueV2TargetingRuleConditionUserConditionComparisonValueListValueArgs'] list_values: The list representation of the comparison value.
        :param str string_value: The string representation of the comparison value.
        """
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if list_values is not None:
            pulumi.set(__self__, "list_values", list_values)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[float]:
        """
        The number representation of the comparison value.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="listValues")
    def list_values(self) -> Optional[Sequence['outputs.SettingValueV2TargetingRuleConditionUserConditionComparisonValueListValue']]:
        """
        The list representation of the comparison value.
        """
        return pulumi.get(self, "list_values")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[str]:
        """
        The string representation of the comparison value.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class SettingValueV2TargetingRuleConditionUserConditionComparisonValueListValue(dict):
    def __init__(__self__, *,
                 value: str,
                 hint: Optional[str] = None):
        """
        :param str value: The actual comparison value.
        :param str hint: An optional hint for the comparison value.
        """
        pulumi.set(__self__, "value", value)
        if hint is not None:
            pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The actual comparison value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def hint(self) -> Optional[str]:
        """
        An optional hint for the comparison value.
        """
        return pulumi.get(self, "hint")


@pulumi.output_type
class SettingValueV2TargetingRulePercentageOption(dict):
    def __init__(__self__, *,
                 percentage: int,
                 value: 'outputs.SettingValueV2TargetingRulePercentageOptionValue'):
        """
        :param int percentage: A number between 0 and 100 that represents a randomly allocated fraction of the users.
        :param 'SettingValueV2TargetingRulePercentageOptionValueArgs' value: Represents the value of a Feature Flag or Setting.
        """
        pulumi.set(__self__, "percentage", percentage)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def percentage(self) -> int:
        """
        A number between 0 and 100 that represents a randomly allocated fraction of the users.
        """
        return pulumi.get(self, "percentage")

    @property
    @pulumi.getter
    def value(self) -> 'outputs.SettingValueV2TargetingRulePercentageOptionValue':
        """
        Represents the value of a Feature Flag or Setting.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SettingValueV2TargetingRulePercentageOptionValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boolValue":
            suggest = "bool_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "intValue":
            suggest = "int_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingValueV2TargetingRulePercentageOptionValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingValueV2TargetingRulePercentageOptionValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingValueV2TargetingRulePercentageOptionValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bool_value: Optional[bool] = None,
                 double_value: Optional[float] = None,
                 int_value: Optional[int] = None,
                 string_value: Optional[str] = None):
        """
        :param bool bool_value: The boolean representation of the value.
        :param float double_value: The decimal number representation of the value.
        :param int int_value: The whole number representation of the value.
        :param str string_value: The string representation of the value.
        """
        if bool_value is not None:
            pulumi.set(__self__, "bool_value", bool_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if int_value is not None:
            pulumi.set(__self__, "int_value", int_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="boolValue")
    def bool_value(self) -> Optional[bool]:
        """
        The boolean representation of the value.
        """
        return pulumi.get(self, "bool_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[float]:
        """
        The decimal number representation of the value.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="intValue")
    def int_value(self) -> Optional[int]:
        """
        The whole number representation of the value.
        """
        return pulumi.get(self, "int_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[str]:
        """
        The string representation of the value.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class SettingValueV2TargetingRuleValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boolValue":
            suggest = "bool_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "intValue":
            suggest = "int_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingValueV2TargetingRuleValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingValueV2TargetingRuleValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingValueV2TargetingRuleValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bool_value: Optional[bool] = None,
                 double_value: Optional[float] = None,
                 int_value: Optional[int] = None,
                 string_value: Optional[str] = None):
        """
        :param bool bool_value: The boolean representation of the value.
        :param float double_value: The decimal number representation of the value.
        :param int int_value: The whole number representation of the value.
        :param str string_value: The string representation of the value.
        """
        if bool_value is not None:
            pulumi.set(__self__, "bool_value", bool_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if int_value is not None:
            pulumi.set(__self__, "int_value", int_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="boolValue")
    def bool_value(self) -> Optional[bool]:
        """
        The boolean representation of the value.
        """
        return pulumi.get(self, "bool_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[float]:
        """
        The decimal number representation of the value.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="intValue")
    def int_value(self) -> Optional[int]:
        """
        The whole number representation of the value.
        """
        return pulumi.get(self, "int_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[str]:
        """
        The string representation of the value.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class SettingValueV2Value(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boolValue":
            suggest = "bool_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "intValue":
            suggest = "int_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingValueV2Value. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingValueV2Value.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingValueV2Value.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bool_value: Optional[bool] = None,
                 double_value: Optional[float] = None,
                 int_value: Optional[int] = None,
                 string_value: Optional[str] = None):
        """
        :param bool bool_value: The boolean representation of the value.
        :param float double_value: The decimal number representation of the value.
        :param int int_value: The whole number representation of the value.
        :param str string_value: The string representation of the value.
        """
        if bool_value is not None:
            pulumi.set(__self__, "bool_value", bool_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if int_value is not None:
            pulumi.set(__self__, "int_value", int_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="boolValue")
    def bool_value(self) -> Optional[bool]:
        """
        The boolean representation of the value.
        """
        return pulumi.get(self, "bool_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[float]:
        """
        The decimal number representation of the value.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="intValue")
    def int_value(self) -> Optional[int]:
        """
        The whole number representation of the value.
        """
        return pulumi.get(self, "int_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[str]:
        """
        The string representation of the value.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class WebhookSecureWebhookHeader(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The HTTP header key.
        :param str value: The HTTP header value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The HTTP header key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The HTTP header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WebhookWebhookHeader(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The HTTP header key.
        :param str value: The HTTP header value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The HTTP header key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The HTTP header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetConfigurationsConfigResult(dict):
    def __init__(__self__, *,
                 config_id: str,
                 description: str,
                 evaluation_version: str,
                 name: str,
                 order: int):
        """
        :param str config_id: The unique Config ID.
        :param str description: The description of the Config.
        :param str evaluation_version: The evaluation version of the Config. Possible values: `v1`|`v2`
        :param str name: The name of the Config.
        :param int order: The order of the Config within a Product (zero-based).
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "evaluation_version", evaluation_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> str:
        """
        The unique Config ID.
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Config.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="evaluationVersion")
    def evaluation_version(self) -> str:
        """
        The evaluation version of the Config. Possible values: `v1`|`v2`
        """
        return pulumi.get(self, "evaluation_version")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def order(self) -> int:
        """
        The order of the Config within a Product (zero-based).
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class GetEnvironmentsEnvironmentResult(dict):
    def __init__(__self__, *,
                 color: str,
                 description: str,
                 environment_id: str,
                 name: str,
                 order: int):
        """
        :param str color: The color of the Environment.
        :param str description: The description of the Environment.
        :param str environment_id: The unique Environment ID.
        :param str name: The name of the Environment.
        :param int order: The order of the Environment within a Product (zero-based).
        """
        pulumi.set(__self__, "color", color)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter
    def color(self) -> str:
        """
        The color of the Environment.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Environment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> str:
        """
        The unique Environment ID.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def order(self) -> int:
        """
        The order of the Environment within a Product (zero-based).
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class GetOrganizationsOrganizationResult(dict):
    def __init__(__self__, *,
                 name: str,
                 organization_id: str):
        """
        :param str name: The name of the Organization.
        :param str organization_id: The unique Organization ID.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The unique Organization ID.
        """
        return pulumi.get(self, "organization_id")


@pulumi.output_type
class GetPermissionGroupsPermissionGroupResult(dict):
    def __init__(__self__, *,
                 accesstype: str,
                 can_createorupdate_config: bool,
                 can_createorupdate_environment: bool,
                 can_createorupdate_segment: bool,
                 can_createorupdate_setting: bool,
                 can_createorupdate_tag: bool,
                 can_delete_config: bool,
                 can_delete_environment: bool,
                 can_delete_segment: bool,
                 can_delete_setting: bool,
                 can_delete_tag: bool,
                 can_disable2fa: bool,
                 can_manage_integrations: bool,
                 can_manage_members: bool,
                 can_manage_product_preferences: bool,
                 can_manage_webhook: bool,
                 can_rotate_sdkkey: bool,
                 can_tag_setting: bool,
                 can_use_exportimport: bool,
                 can_view_product_auditlog: bool,
                 can_view_product_statistics: bool,
                 can_view_sdkkey: bool,
                 environment_accesses: Mapping[str, str],
                 name: str,
                 new_environment_accesstype: str,
                 permission_group_id: int):
        """
        :param str accesstype: Represent the Feature Management permission. Possible values: readOnly, full, custom
        :param bool can_createorupdate_config: Group members can create/update Configs.
        :param bool can_createorupdate_environment: Group members can create/update Environments.
        :param bool can_createorupdate_segment: Group members can create/update Segments.
        :param bool can_createorupdate_setting: Group members can create/update Feature Flags and Settings.
        :param bool can_createorupdate_tag: Group members can create/update Tags.
        :param bool can_delete_config: Group members can delete Configs.
        :param bool can_delete_environment: Group members can delete Environments.
        :param bool can_delete_segment: Group members can delete Segments.
        :param bool can_delete_setting: Group members can delete Feature Flags and Settings.
        :param bool can_delete_tag: Group members can delete Tags.
        :param bool can_disable2fa: Group members can disable two-factor authentication for other members.
        :param bool can_manage_integrations: Group members can add and configure integrations.
        :param bool can_manage_members: Group members can manage team members.
        :param bool can_manage_product_preferences: Group members can update Product preferences.
        :param bool can_manage_webhook: Group members can create/update/delete Webhooks.
        :param bool can_rotate_sdkkey: Group members can rotate SDK keys.
        :param bool can_tag_setting: Group members can attach/detach Tags to Feature Flags and Settings.
        :param bool can_use_exportimport: Group members can use the export/import feature.
        :param bool can_view_product_auditlog: Group members has access to audit logs.
        :param bool can_view_product_statistics: Group members has access to product statistics.
        :param bool can_view_sdkkey: Group members has access to SDK keys.
        :param Mapping[str, str] environment_accesses: The environment specific permissions map block. Keys are the Environment IDs and the values represent the environment specific Feature Management permission. Possible values: full, readOnly
        :param str name: The name of the Permission Group.
        :param str new_environment_accesstype: Represent the environment specific Feature Management permission for new Environments. Possible values: full, readOnly, none
        :param int permission_group_id: The unique Permission Group ID.
        """
        pulumi.set(__self__, "accesstype", accesstype)
        pulumi.set(__self__, "can_createorupdate_config", can_createorupdate_config)
        pulumi.set(__self__, "can_createorupdate_environment", can_createorupdate_environment)
        pulumi.set(__self__, "can_createorupdate_segment", can_createorupdate_segment)
        pulumi.set(__self__, "can_createorupdate_setting", can_createorupdate_setting)
        pulumi.set(__self__, "can_createorupdate_tag", can_createorupdate_tag)
        pulumi.set(__self__, "can_delete_config", can_delete_config)
        pulumi.set(__self__, "can_delete_environment", can_delete_environment)
        pulumi.set(__self__, "can_delete_segment", can_delete_segment)
        pulumi.set(__self__, "can_delete_setting", can_delete_setting)
        pulumi.set(__self__, "can_delete_tag", can_delete_tag)
        pulumi.set(__self__, "can_disable2fa", can_disable2fa)
        pulumi.set(__self__, "can_manage_integrations", can_manage_integrations)
        pulumi.set(__self__, "can_manage_members", can_manage_members)
        pulumi.set(__self__, "can_manage_product_preferences", can_manage_product_preferences)
        pulumi.set(__self__, "can_manage_webhook", can_manage_webhook)
        pulumi.set(__self__, "can_rotate_sdkkey", can_rotate_sdkkey)
        pulumi.set(__self__, "can_tag_setting", can_tag_setting)
        pulumi.set(__self__, "can_use_exportimport", can_use_exportimport)
        pulumi.set(__self__, "can_view_product_auditlog", can_view_product_auditlog)
        pulumi.set(__self__, "can_view_product_statistics", can_view_product_statistics)
        pulumi.set(__self__, "can_view_sdkkey", can_view_sdkkey)
        pulumi.set(__self__, "environment_accesses", environment_accesses)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "new_environment_accesstype", new_environment_accesstype)
        pulumi.set(__self__, "permission_group_id", permission_group_id)

    @property
    @pulumi.getter
    def accesstype(self) -> str:
        """
        Represent the Feature Management permission. Possible values: readOnly, full, custom
        """
        return pulumi.get(self, "accesstype")

    @property
    @pulumi.getter(name="canCreateorupdateConfig")
    def can_createorupdate_config(self) -> bool:
        """
        Group members can create/update Configs.
        """
        return pulumi.get(self, "can_createorupdate_config")

    @property
    @pulumi.getter(name="canCreateorupdateEnvironment")
    def can_createorupdate_environment(self) -> bool:
        """
        Group members can create/update Environments.
        """
        return pulumi.get(self, "can_createorupdate_environment")

    @property
    @pulumi.getter(name="canCreateorupdateSegment")
    def can_createorupdate_segment(self) -> bool:
        """
        Group members can create/update Segments.
        """
        return pulumi.get(self, "can_createorupdate_segment")

    @property
    @pulumi.getter(name="canCreateorupdateSetting")
    def can_createorupdate_setting(self) -> bool:
        """
        Group members can create/update Feature Flags and Settings.
        """
        return pulumi.get(self, "can_createorupdate_setting")

    @property
    @pulumi.getter(name="canCreateorupdateTag")
    def can_createorupdate_tag(self) -> bool:
        """
        Group members can create/update Tags.
        """
        return pulumi.get(self, "can_createorupdate_tag")

    @property
    @pulumi.getter(name="canDeleteConfig")
    def can_delete_config(self) -> bool:
        """
        Group members can delete Configs.
        """
        return pulumi.get(self, "can_delete_config")

    @property
    @pulumi.getter(name="canDeleteEnvironment")
    def can_delete_environment(self) -> bool:
        """
        Group members can delete Environments.
        """
        return pulumi.get(self, "can_delete_environment")

    @property
    @pulumi.getter(name="canDeleteSegment")
    def can_delete_segment(self) -> bool:
        """
        Group members can delete Segments.
        """
        return pulumi.get(self, "can_delete_segment")

    @property
    @pulumi.getter(name="canDeleteSetting")
    def can_delete_setting(self) -> bool:
        """
        Group members can delete Feature Flags and Settings.
        """
        return pulumi.get(self, "can_delete_setting")

    @property
    @pulumi.getter(name="canDeleteTag")
    def can_delete_tag(self) -> bool:
        """
        Group members can delete Tags.
        """
        return pulumi.get(self, "can_delete_tag")

    @property
    @pulumi.getter(name="canDisable2fa")
    def can_disable2fa(self) -> bool:
        """
        Group members can disable two-factor authentication for other members.
        """
        return pulumi.get(self, "can_disable2fa")

    @property
    @pulumi.getter(name="canManageIntegrations")
    def can_manage_integrations(self) -> bool:
        """
        Group members can add and configure integrations.
        """
        return pulumi.get(self, "can_manage_integrations")

    @property
    @pulumi.getter(name="canManageMembers")
    def can_manage_members(self) -> bool:
        """
        Group members can manage team members.
        """
        return pulumi.get(self, "can_manage_members")

    @property
    @pulumi.getter(name="canManageProductPreferences")
    def can_manage_product_preferences(self) -> bool:
        """
        Group members can update Product preferences.
        """
        return pulumi.get(self, "can_manage_product_preferences")

    @property
    @pulumi.getter(name="canManageWebhook")
    def can_manage_webhook(self) -> bool:
        """
        Group members can create/update/delete Webhooks.
        """
        return pulumi.get(self, "can_manage_webhook")

    @property
    @pulumi.getter(name="canRotateSdkkey")
    def can_rotate_sdkkey(self) -> bool:
        """
        Group members can rotate SDK keys.
        """
        return pulumi.get(self, "can_rotate_sdkkey")

    @property
    @pulumi.getter(name="canTagSetting")
    def can_tag_setting(self) -> bool:
        """
        Group members can attach/detach Tags to Feature Flags and Settings.
        """
        return pulumi.get(self, "can_tag_setting")

    @property
    @pulumi.getter(name="canUseExportimport")
    def can_use_exportimport(self) -> bool:
        """
        Group members can use the export/import feature.
        """
        return pulumi.get(self, "can_use_exportimport")

    @property
    @pulumi.getter(name="canViewProductAuditlog")
    def can_view_product_auditlog(self) -> bool:
        """
        Group members has access to audit logs.
        """
        return pulumi.get(self, "can_view_product_auditlog")

    @property
    @pulumi.getter(name="canViewProductStatistics")
    def can_view_product_statistics(self) -> bool:
        """
        Group members has access to product statistics.
        """
        return pulumi.get(self, "can_view_product_statistics")

    @property
    @pulumi.getter(name="canViewSdkkey")
    def can_view_sdkkey(self) -> bool:
        """
        Group members has access to SDK keys.
        """
        return pulumi.get(self, "can_view_sdkkey")

    @property
    @pulumi.getter(name="environmentAccesses")
    def environment_accesses(self) -> Mapping[str, str]:
        """
        The environment specific permissions map block. Keys are the Environment IDs and the values represent the environment specific Feature Management permission. Possible values: full, readOnly
        """
        return pulumi.get(self, "environment_accesses")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Permission Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newEnvironmentAccesstype")
    def new_environment_accesstype(self) -> str:
        """
        Represent the environment specific Feature Management permission for new Environments. Possible values: full, readOnly, none
        """
        return pulumi.get(self, "new_environment_accesstype")

    @property
    @pulumi.getter(name="permissionGroupId")
    def permission_group_id(self) -> int:
        """
        The unique Permission Group ID.
        """
        return pulumi.get(self, "permission_group_id")


@pulumi.output_type
class GetProductsProductResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 order: int,
                 product_id: str):
        """
        :param str description: The description of the Product.
        :param str name: The name of the Product.
        :param int order: The order of the Product within a Product (zero-based).
        :param str product_id: The unique Product ID.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "product_id", product_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Product.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Product.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def order(self) -> int:
        """
        The order of the Product within a Product (zero-based).
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> str:
        """
        The unique Product ID.
        """
        return pulumi.get(self, "product_id")


@pulumi.output_type
class GetSegmentsSegmentResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 segment_id: str):
        """
        :param str description: The description of the Segment.
        :param str name: The name of the Segment.
        :param str segment_id: The unique Segment ID.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "segment_id", segment_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Segment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Segment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="segmentId")
    def segment_id(self) -> str:
        """
        The unique Segment ID.
        """
        return pulumi.get(self, "segment_id")


@pulumi.output_type
class GetSettingsSettingResult(dict):
    def __init__(__self__, *,
                 hint: str,
                 key: str,
                 name: str,
                 order: int,
                 setting_id: str,
                 setting_type: str):
        """
        :param str hint: The hint of the Feature Flag or Setting.
        :param str key: The key of the Feature Flag or Setting.
        :param str name: The name of the Feature Flag or Setting.
        :param int order: The order of the Feature Flag or Setting within a Config (zero-based).
        :param str setting_id: The unique Feature Flag or Setting ID.
        :param str setting_type: The Feature Flag or Setting's type. Available values: `boolean`|`string`|`int`|`double`.
        """
        pulumi.set(__self__, "hint", hint)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "setting_id", setting_id)
        pulumi.set(__self__, "setting_type", setting_type)

    @property
    @pulumi.getter
    def hint(self) -> str:
        """
        The hint of the Feature Flag or Setting.
        """
        return pulumi.get(self, "hint")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the Feature Flag or Setting.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Feature Flag or Setting.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def order(self) -> int:
        """
        The order of the Feature Flag or Setting within a Config (zero-based).
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> str:
        """
        The unique Feature Flag or Setting ID.
        """
        return pulumi.get(self, "setting_id")

    @property
    @pulumi.getter(name="settingType")
    def setting_type(self) -> str:
        """
        The Feature Flag or Setting's type. Available values: `boolean`|`string`|`int`|`double`.
        """
        return pulumi.get(self, "setting_type")


@pulumi.output_type
class GetTagsTagResult(dict):
    def __init__(__self__, *,
                 color: str,
                 name: str,
                 tag_id: str):
        """
        :param str color: The color of the Tag.
        :param str name: The name of the Tag.
        :param str tag_id: The unique Tag ID.
        """
        pulumi.set(__self__, "color", color)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tag_id", tag_id)

    @property
    @pulumi.getter
    def color(self) -> str:
        """
        The color of the Tag.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Tag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tagId")
    def tag_id(self) -> str:
        """
        The unique Tag ID.
        """
        return pulumi.get(self, "tag_id")


