# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProductPreferencesArgs', 'ProductPreferences']

@pulumi.input_type
class ProductPreferencesArgs:
    def __init__(__self__, *,
                 product_id: pulumi.Input[str],
                 key_generation_mode: Optional[pulumi.Input[str]] = None,
                 mandatory_setting_hint: Optional[pulumi.Input[bool]] = None,
                 reason_required: Optional[pulumi.Input[bool]] = None,
                 reason_required_environments: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 show_variation_id: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ProductPreferences resource.
        :param pulumi.Input[str] product_id: The ID of the Product.
        :param pulumi.Input[str] key_generation_mode: Determines the Feature Flag key generation mode. Available values: `camelCase`|`upperCase`|`lowerCase`|`pascalCase`|`kebabCase`. Default: `camelCase`.
        :param pulumi.Input[bool] mandatory_setting_hint: Indicates whether Feature flags and Settings must have a hint. Default: false.
        :param pulumi.Input[bool] reason_required: Indicates that a mandatory note is required for saving and publishing. Default: false.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] reason_required_environments: The environment specific mandatory note map block. Keys are the Environment IDs and the values indicate that a mandatory note is required for saving and publishing.
        :param pulumi.Input[bool] show_variation_id: Indicates whether variation IDs must be shown on the ConfigCat Dashboard. Default: false.
        """
        pulumi.set(__self__, "product_id", product_id)
        if key_generation_mode is not None:
            pulumi.set(__self__, "key_generation_mode", key_generation_mode)
        if mandatory_setting_hint is not None:
            pulumi.set(__self__, "mandatory_setting_hint", mandatory_setting_hint)
        if reason_required is not None:
            pulumi.set(__self__, "reason_required", reason_required)
        if reason_required_environments is not None:
            pulumi.set(__self__, "reason_required_environments", reason_required_environments)
        if show_variation_id is not None:
            pulumi.set(__self__, "show_variation_id", show_variation_id)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[str]:
        """
        The ID of the Product.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="keyGenerationMode")
    def key_generation_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Determines the Feature Flag key generation mode. Available values: `camelCase`|`upperCase`|`lowerCase`|`pascalCase`|`kebabCase`. Default: `camelCase`.
        """
        return pulumi.get(self, "key_generation_mode")

    @key_generation_mode.setter
    def key_generation_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_generation_mode", value)

    @property
    @pulumi.getter(name="mandatorySettingHint")
    def mandatory_setting_hint(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether Feature flags and Settings must have a hint. Default: false.
        """
        return pulumi.get(self, "mandatory_setting_hint")

    @mandatory_setting_hint.setter
    def mandatory_setting_hint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mandatory_setting_hint", value)

    @property
    @pulumi.getter(name="reasonRequired")
    def reason_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that a mandatory note is required for saving and publishing. Default: false.
        """
        return pulumi.get(self, "reason_required")

    @reason_required.setter
    def reason_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reason_required", value)

    @property
    @pulumi.getter(name="reasonRequiredEnvironments")
    def reason_required_environments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]:
        """
        The environment specific mandatory note map block. Keys are the Environment IDs and the values indicate that a mandatory note is required for saving and publishing.
        """
        return pulumi.get(self, "reason_required_environments")

    @reason_required_environments.setter
    def reason_required_environments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]):
        pulumi.set(self, "reason_required_environments", value)

    @property
    @pulumi.getter(name="showVariationId")
    def show_variation_id(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether variation IDs must be shown on the ConfigCat Dashboard. Default: false.
        """
        return pulumi.get(self, "show_variation_id")

    @show_variation_id.setter
    def show_variation_id(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "show_variation_id", value)


@pulumi.input_type
class _ProductPreferencesState:
    def __init__(__self__, *,
                 key_generation_mode: Optional[pulumi.Input[str]] = None,
                 mandatory_setting_hint: Optional[pulumi.Input[bool]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 reason_required: Optional[pulumi.Input[bool]] = None,
                 reason_required_environments: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 show_variation_id: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ProductPreferences resources.
        :param pulumi.Input[str] key_generation_mode: Determines the Feature Flag key generation mode. Available values: `camelCase`|`upperCase`|`lowerCase`|`pascalCase`|`kebabCase`. Default: `camelCase`.
        :param pulumi.Input[bool] mandatory_setting_hint: Indicates whether Feature flags and Settings must have a hint. Default: false.
        :param pulumi.Input[str] product_id: The ID of the Product.
        :param pulumi.Input[bool] reason_required: Indicates that a mandatory note is required for saving and publishing. Default: false.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] reason_required_environments: The environment specific mandatory note map block. Keys are the Environment IDs and the values indicate that a mandatory note is required for saving and publishing.
        :param pulumi.Input[bool] show_variation_id: Indicates whether variation IDs must be shown on the ConfigCat Dashboard. Default: false.
        """
        if key_generation_mode is not None:
            pulumi.set(__self__, "key_generation_mode", key_generation_mode)
        if mandatory_setting_hint is not None:
            pulumi.set(__self__, "mandatory_setting_hint", mandatory_setting_hint)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if reason_required is not None:
            pulumi.set(__self__, "reason_required", reason_required)
        if reason_required_environments is not None:
            pulumi.set(__self__, "reason_required_environments", reason_required_environments)
        if show_variation_id is not None:
            pulumi.set(__self__, "show_variation_id", show_variation_id)

    @property
    @pulumi.getter(name="keyGenerationMode")
    def key_generation_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Determines the Feature Flag key generation mode. Available values: `camelCase`|`upperCase`|`lowerCase`|`pascalCase`|`kebabCase`. Default: `camelCase`.
        """
        return pulumi.get(self, "key_generation_mode")

    @key_generation_mode.setter
    def key_generation_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_generation_mode", value)

    @property
    @pulumi.getter(name="mandatorySettingHint")
    def mandatory_setting_hint(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether Feature flags and Settings must have a hint. Default: false.
        """
        return pulumi.get(self, "mandatory_setting_hint")

    @mandatory_setting_hint.setter
    def mandatory_setting_hint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mandatory_setting_hint", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Product.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="reasonRequired")
    def reason_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that a mandatory note is required for saving and publishing. Default: false.
        """
        return pulumi.get(self, "reason_required")

    @reason_required.setter
    def reason_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reason_required", value)

    @property
    @pulumi.getter(name="reasonRequiredEnvironments")
    def reason_required_environments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]:
        """
        The environment specific mandatory note map block. Keys are the Environment IDs and the values indicate that a mandatory note is required for saving and publishing.
        """
        return pulumi.get(self, "reason_required_environments")

    @reason_required_environments.setter
    def reason_required_environments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]):
        pulumi.set(self, "reason_required_environments", value)

    @property
    @pulumi.getter(name="showVariationId")
    def show_variation_id(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether variation IDs must be shown on the ConfigCat Dashboard. Default: false.
        """
        return pulumi.get(self, "show_variation_id")

    @show_variation_id.setter
    def show_variation_id(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "show_variation_id", value)


class ProductPreferences(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_generation_mode: Optional[pulumi.Input[str]] = None,
                 mandatory_setting_hint: Optional[pulumi.Input[bool]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 reason_required: Optional[pulumi.Input[bool]] = None,
                 reason_required_environments: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 show_variation_id: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Manages the **Product Preferences**.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_configcat as configcat

        config = pulumi.Config()
        organization_id = config.require("organizationId")
        product = configcat.Product("product",
            organization_id=organization_id,
            name="My product",
            order=0)
        test = configcat.Environment("test",
            product_id=product.id,
            name="Test",
            order=0)
        production = configcat.Environment("production",
            product_id=product.id,
            name="Production",
            order=1)
        preferences = configcat.ProductPreferences("preferences",
            product_id=product.id,
            key_generation_mode="kebabCase",
            mandatory_setting_hint=True,
            show_variation_id=False,
            reason_required=False,
            reason_required_environments=pulumi.Output.all(
                testId=test.id,
                productionId=production.id
        ).apply(lambda resolved_outputs: {
                resolved_outputs['testId']: False,
                resolved_outputs['productionId']: True,
            })
        )
        ```

        ## Import

        Product preferences can be imported using the ProductId. Get the ProductId using the [List Products API](https://api.configcat.com/docs/#tag/Products/operation/get-products) for example.

        ```sh
        $ pulumi import configcat:index/productPreferences:ProductPreferences example 08d86d63-2726-47cd-8bfc-59608ecb91e2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key_generation_mode: Determines the Feature Flag key generation mode. Available values: `camelCase`|`upperCase`|`lowerCase`|`pascalCase`|`kebabCase`. Default: `camelCase`.
        :param pulumi.Input[bool] mandatory_setting_hint: Indicates whether Feature flags and Settings must have a hint. Default: false.
        :param pulumi.Input[str] product_id: The ID of the Product.
        :param pulumi.Input[bool] reason_required: Indicates that a mandatory note is required for saving and publishing. Default: false.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] reason_required_environments: The environment specific mandatory note map block. Keys are the Environment IDs and the values indicate that a mandatory note is required for saving and publishing.
        :param pulumi.Input[bool] show_variation_id: Indicates whether variation IDs must be shown on the ConfigCat Dashboard. Default: false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProductPreferencesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the **Product Preferences**.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_configcat as configcat

        config = pulumi.Config()
        organization_id = config.require("organizationId")
        product = configcat.Product("product",
            organization_id=organization_id,
            name="My product",
            order=0)
        test = configcat.Environment("test",
            product_id=product.id,
            name="Test",
            order=0)
        production = configcat.Environment("production",
            product_id=product.id,
            name="Production",
            order=1)
        preferences = configcat.ProductPreferences("preferences",
            product_id=product.id,
            key_generation_mode="kebabCase",
            mandatory_setting_hint=True,
            show_variation_id=False,
            reason_required=False,
            reason_required_environments=pulumi.Output.all(
                testId=test.id,
                productionId=production.id
        ).apply(lambda resolved_outputs: {
                resolved_outputs['testId']: False,
                resolved_outputs['productionId']: True,
            })
        )
        ```

        ## Import

        Product preferences can be imported using the ProductId. Get the ProductId using the [List Products API](https://api.configcat.com/docs/#tag/Products/operation/get-products) for example.

        ```sh
        $ pulumi import configcat:index/productPreferences:ProductPreferences example 08d86d63-2726-47cd-8bfc-59608ecb91e2
        ```

        :param str resource_name: The name of the resource.
        :param ProductPreferencesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProductPreferencesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_generation_mode: Optional[pulumi.Input[str]] = None,
                 mandatory_setting_hint: Optional[pulumi.Input[bool]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 reason_required: Optional[pulumi.Input[bool]] = None,
                 reason_required_environments: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 show_variation_id: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProductPreferencesArgs.__new__(ProductPreferencesArgs)

            __props__.__dict__["key_generation_mode"] = key_generation_mode
            __props__.__dict__["mandatory_setting_hint"] = mandatory_setting_hint
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["reason_required"] = reason_required
            __props__.__dict__["reason_required_environments"] = reason_required_environments
            __props__.__dict__["show_variation_id"] = show_variation_id
        super(ProductPreferences, __self__).__init__(
            'configcat:index/productPreferences:ProductPreferences',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key_generation_mode: Optional[pulumi.Input[str]] = None,
            mandatory_setting_hint: Optional[pulumi.Input[bool]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            reason_required: Optional[pulumi.Input[bool]] = None,
            reason_required_environments: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
            show_variation_id: Optional[pulumi.Input[bool]] = None) -> 'ProductPreferences':
        """
        Get an existing ProductPreferences resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key_generation_mode: Determines the Feature Flag key generation mode. Available values: `camelCase`|`upperCase`|`lowerCase`|`pascalCase`|`kebabCase`. Default: `camelCase`.
        :param pulumi.Input[bool] mandatory_setting_hint: Indicates whether Feature flags and Settings must have a hint. Default: false.
        :param pulumi.Input[str] product_id: The ID of the Product.
        :param pulumi.Input[bool] reason_required: Indicates that a mandatory note is required for saving and publishing. Default: false.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] reason_required_environments: The environment specific mandatory note map block. Keys are the Environment IDs and the values indicate that a mandatory note is required for saving and publishing.
        :param pulumi.Input[bool] show_variation_id: Indicates whether variation IDs must be shown on the ConfigCat Dashboard. Default: false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProductPreferencesState.__new__(_ProductPreferencesState)

        __props__.__dict__["key_generation_mode"] = key_generation_mode
        __props__.__dict__["mandatory_setting_hint"] = mandatory_setting_hint
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["reason_required"] = reason_required
        __props__.__dict__["reason_required_environments"] = reason_required_environments
        __props__.__dict__["show_variation_id"] = show_variation_id
        return ProductPreferences(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="keyGenerationMode")
    def key_generation_mode(self) -> pulumi.Output[str]:
        """
        Determines the Feature Flag key generation mode. Available values: `camelCase`|`upperCase`|`lowerCase`|`pascalCase`|`kebabCase`. Default: `camelCase`.
        """
        return pulumi.get(self, "key_generation_mode")

    @property
    @pulumi.getter(name="mandatorySettingHint")
    def mandatory_setting_hint(self) -> pulumi.Output[bool]:
        """
        Indicates whether Feature flags and Settings must have a hint. Default: false.
        """
        return pulumi.get(self, "mandatory_setting_hint")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        """
        The ID of the Product.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="reasonRequired")
    def reason_required(self) -> pulumi.Output[bool]:
        """
        Indicates that a mandatory note is required for saving and publishing. Default: false.
        """
        return pulumi.get(self, "reason_required")

    @property
    @pulumi.getter(name="reasonRequiredEnvironments")
    def reason_required_environments(self) -> pulumi.Output[Mapping[str, bool]]:
        """
        The environment specific mandatory note map block. Keys are the Environment IDs and the values indicate that a mandatory note is required for saving and publishing.
        """
        return pulumi.get(self, "reason_required_environments")

    @property
    @pulumi.getter(name="showVariationId")
    def show_variation_id(self) -> pulumi.Output[bool]:
        """
        Indicates whether variation IDs must be shown on the ConfigCat Dashboard. Default: false.
        """
        return pulumi.get(self, "show_variation_id")

