# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SettingValueV2Args', 'SettingValueV2']

@pulumi.input_type
class SettingValueV2Args:
    def __init__(__self__, *,
                 environment_id: pulumi.Input[str],
                 setting_id: pulumi.Input[str],
                 value: pulumi.Input['SettingValueV2ValueArgs'],
                 init_only: Optional[pulumi.Input[bool]] = None,
                 mandatory_notes: Optional[pulumi.Input[str]] = None,
                 percentage_evaluation_attribute: Optional[pulumi.Input[str]] = None,
                 targeting_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SettingValueV2TargetingRuleArgs']]]] = None):
        """
        The set of arguments for constructing a SettingValueV2 resource.
        :param pulumi.Input[str] environment_id: The ID of the Environment.
        :param pulumi.Input[str] setting_id: The ID of the Feature Flag or Setting.
        :param pulumi.Input['SettingValueV2ValueArgs'] value: Represents the value of a Feature Flag or Setting.
        :param pulumi.Input[str] mandatory_notes: If the Product's "Mandatory notes" preference is turned on for the Environment the Mandatory note must be passed.
        :param pulumi.Input[str] percentage_evaluation_attribute: The user attribute used for percentage evaluation. If not set, it defaults to the Identifier user object attribute.
        :param pulumi.Input[Sequence[pulumi.Input['SettingValueV2TargetingRuleArgs']]] targeting_rules: The targeting rules of the Feature Flag or Setting
        """
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "setting_id", setting_id)
        pulumi.set(__self__, "value", value)
        if init_only is not None:
            pulumi.set(__self__, "init_only", init_only)
        if mandatory_notes is not None:
            pulumi.set(__self__, "mandatory_notes", mandatory_notes)
        if percentage_evaluation_attribute is not None:
            pulumi.set(__self__, "percentage_evaluation_attribute", percentage_evaluation_attribute)
        if targeting_rules is not None:
            pulumi.set(__self__, "targeting_rules", targeting_rules)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        The ID of the Environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> pulumi.Input[str]:
        """
        The ID of the Feature Flag or Setting.
        """
        return pulumi.get(self, "setting_id")

    @setting_id.setter
    def setting_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "setting_id", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input['SettingValueV2ValueArgs']:
        """
        Represents the value of a Feature Flag or Setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input['SettingValueV2ValueArgs']):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="initOnly")
    def init_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "init_only")

    @init_only.setter
    def init_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "init_only", value)

    @property
    @pulumi.getter(name="mandatoryNotes")
    def mandatory_notes(self) -> Optional[pulumi.Input[str]]:
        """
        If the Product's "Mandatory notes" preference is turned on for the Environment the Mandatory note must be passed.
        """
        return pulumi.get(self, "mandatory_notes")

    @mandatory_notes.setter
    def mandatory_notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mandatory_notes", value)

    @property
    @pulumi.getter(name="percentageEvaluationAttribute")
    def percentage_evaluation_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The user attribute used for percentage evaluation. If not set, it defaults to the Identifier user object attribute.
        """
        return pulumi.get(self, "percentage_evaluation_attribute")

    @percentage_evaluation_attribute.setter
    def percentage_evaluation_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "percentage_evaluation_attribute", value)

    @property
    @pulumi.getter(name="targetingRules")
    def targeting_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SettingValueV2TargetingRuleArgs']]]]:
        """
        The targeting rules of the Feature Flag or Setting
        """
        return pulumi.get(self, "targeting_rules")

    @targeting_rules.setter
    def targeting_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SettingValueV2TargetingRuleArgs']]]]):
        pulumi.set(self, "targeting_rules", value)


@pulumi.input_type
class _SettingValueV2State:
    def __init__(__self__, *,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 init_only: Optional[pulumi.Input[bool]] = None,
                 mandatory_notes: Optional[pulumi.Input[str]] = None,
                 percentage_evaluation_attribute: Optional[pulumi.Input[str]] = None,
                 setting_id: Optional[pulumi.Input[str]] = None,
                 setting_type: Optional[pulumi.Input[str]] = None,
                 targeting_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SettingValueV2TargetingRuleArgs']]]] = None,
                 value: Optional[pulumi.Input['SettingValueV2ValueArgs']] = None):
        """
        Input properties used for looking up and filtering SettingValueV2 resources.
        :param pulumi.Input[str] environment_id: The ID of the Environment.
        :param pulumi.Input[str] mandatory_notes: If the Product's "Mandatory notes" preference is turned on for the Environment the Mandatory note must be passed.
        :param pulumi.Input[str] percentage_evaluation_attribute: The user attribute used for percentage evaluation. If not set, it defaults to the Identifier user object attribute.
        :param pulumi.Input[str] setting_id: The ID of the Feature Flag or Setting.
        :param pulumi.Input[str] setting_type: The type of the Feature Flag or Setting. Available values: `boolean`|`string`|`int`|`double`.
        :param pulumi.Input[Sequence[pulumi.Input['SettingValueV2TargetingRuleArgs']]] targeting_rules: The targeting rules of the Feature Flag or Setting
        :param pulumi.Input['SettingValueV2ValueArgs'] value: Represents the value of a Feature Flag or Setting.
        """
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if init_only is not None:
            pulumi.set(__self__, "init_only", init_only)
        if mandatory_notes is not None:
            pulumi.set(__self__, "mandatory_notes", mandatory_notes)
        if percentage_evaluation_attribute is not None:
            pulumi.set(__self__, "percentage_evaluation_attribute", percentage_evaluation_attribute)
        if setting_id is not None:
            pulumi.set(__self__, "setting_id", setting_id)
        if setting_type is not None:
            pulumi.set(__self__, "setting_type", setting_type)
        if targeting_rules is not None:
            pulumi.set(__self__, "targeting_rules", targeting_rules)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="initOnly")
    def init_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "init_only")

    @init_only.setter
    def init_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "init_only", value)

    @property
    @pulumi.getter(name="mandatoryNotes")
    def mandatory_notes(self) -> Optional[pulumi.Input[str]]:
        """
        If the Product's "Mandatory notes" preference is turned on for the Environment the Mandatory note must be passed.
        """
        return pulumi.get(self, "mandatory_notes")

    @mandatory_notes.setter
    def mandatory_notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mandatory_notes", value)

    @property
    @pulumi.getter(name="percentageEvaluationAttribute")
    def percentage_evaluation_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        The user attribute used for percentage evaluation. If not set, it defaults to the Identifier user object attribute.
        """
        return pulumi.get(self, "percentage_evaluation_attribute")

    @percentage_evaluation_attribute.setter
    def percentage_evaluation_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "percentage_evaluation_attribute", value)

    @property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Feature Flag or Setting.
        """
        return pulumi.get(self, "setting_id")

    @setting_id.setter
    def setting_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "setting_id", value)

    @property
    @pulumi.getter(name="settingType")
    def setting_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Feature Flag or Setting. Available values: `boolean`|`string`|`int`|`double`.
        """
        return pulumi.get(self, "setting_type")

    @setting_type.setter
    def setting_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "setting_type", value)

    @property
    @pulumi.getter(name="targetingRules")
    def targeting_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SettingValueV2TargetingRuleArgs']]]]:
        """
        The targeting rules of the Feature Flag or Setting
        """
        return pulumi.get(self, "targeting_rules")

    @targeting_rules.setter
    def targeting_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SettingValueV2TargetingRuleArgs']]]]):
        pulumi.set(self, "targeting_rules", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input['SettingValueV2ValueArgs']]:
        """
        Represents the value of a Feature Flag or Setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input['SettingValueV2ValueArgs']]):
        pulumi.set(self, "value", value)


class SettingValueV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 init_only: Optional[pulumi.Input[bool]] = None,
                 mandatory_notes: Optional[pulumi.Input[str]] = None,
                 percentage_evaluation_attribute: Optional[pulumi.Input[str]] = None,
                 setting_id: Optional[pulumi.Input[str]] = None,
                 targeting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SettingValueV2TargetingRuleArgs', 'SettingValueV2TargetingRuleArgsDict']]]]] = None,
                 value: Optional[pulumi.Input[Union['SettingValueV2ValueArgs', 'SettingValueV2ValueArgsDict']]] = None,
                 __props__=None):
        """
        Initializes and updates **Feature Flag or Setting** values for V2 configs. [Read more about the anatomy of a Feature Flag or Setting.](https://configcat.com/docs/main-concepts)

        ## Import

        Feature Flag/Setting values (V2) can be imported using a combined EnvironmentID:SettingId ID.

        Get the EnvironmentId using e.g. the [List Environments API](https://api.configcat.com/docs/#tag/Environments/operation/get-environments).

        Get the SettingId using e.g. the [List Flags API](https://api.configcat.com/docs/#tag/Feature-Flags-and-Settings/operation/get-settings).

        ```sh
        $ pulumi import configcat:index/settingValueV2:SettingValueV2 example 08d86d63-2726-47cd-8bfc-59608ecb91e2:1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] environment_id: The ID of the Environment.
        :param pulumi.Input[str] mandatory_notes: If the Product's "Mandatory notes" preference is turned on for the Environment the Mandatory note must be passed.
        :param pulumi.Input[str] percentage_evaluation_attribute: The user attribute used for percentage evaluation. If not set, it defaults to the Identifier user object attribute.
        :param pulumi.Input[str] setting_id: The ID of the Feature Flag or Setting.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SettingValueV2TargetingRuleArgs', 'SettingValueV2TargetingRuleArgsDict']]]] targeting_rules: The targeting rules of the Feature Flag or Setting
        :param pulumi.Input[Union['SettingValueV2ValueArgs', 'SettingValueV2ValueArgsDict']] value: Represents the value of a Feature Flag or Setting.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SettingValueV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Initializes and updates **Feature Flag or Setting** values for V2 configs. [Read more about the anatomy of a Feature Flag or Setting.](https://configcat.com/docs/main-concepts)

        ## Import

        Feature Flag/Setting values (V2) can be imported using a combined EnvironmentID:SettingId ID.

        Get the EnvironmentId using e.g. the [List Environments API](https://api.configcat.com/docs/#tag/Environments/operation/get-environments).

        Get the SettingId using e.g. the [List Flags API](https://api.configcat.com/docs/#tag/Feature-Flags-and-Settings/operation/get-settings).

        ```sh
        $ pulumi import configcat:index/settingValueV2:SettingValueV2 example 08d86d63-2726-47cd-8bfc-59608ecb91e2:1234
        ```

        :param str resource_name: The name of the resource.
        :param SettingValueV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SettingValueV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 init_only: Optional[pulumi.Input[bool]] = None,
                 mandatory_notes: Optional[pulumi.Input[str]] = None,
                 percentage_evaluation_attribute: Optional[pulumi.Input[str]] = None,
                 setting_id: Optional[pulumi.Input[str]] = None,
                 targeting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SettingValueV2TargetingRuleArgs', 'SettingValueV2TargetingRuleArgsDict']]]]] = None,
                 value: Optional[pulumi.Input[Union['SettingValueV2ValueArgs', 'SettingValueV2ValueArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SettingValueV2Args.__new__(SettingValueV2Args)

            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["init_only"] = init_only
            __props__.__dict__["mandatory_notes"] = mandatory_notes
            __props__.__dict__["percentage_evaluation_attribute"] = percentage_evaluation_attribute
            if setting_id is None and not opts.urn:
                raise TypeError("Missing required property 'setting_id'")
            __props__.__dict__["setting_id"] = setting_id
            __props__.__dict__["targeting_rules"] = targeting_rules
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            __props__.__dict__["setting_type"] = None
        super(SettingValueV2, __self__).__init__(
            'configcat:index/settingValueV2:SettingValueV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            init_only: Optional[pulumi.Input[bool]] = None,
            mandatory_notes: Optional[pulumi.Input[str]] = None,
            percentage_evaluation_attribute: Optional[pulumi.Input[str]] = None,
            setting_id: Optional[pulumi.Input[str]] = None,
            setting_type: Optional[pulumi.Input[str]] = None,
            targeting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SettingValueV2TargetingRuleArgs', 'SettingValueV2TargetingRuleArgsDict']]]]] = None,
            value: Optional[pulumi.Input[Union['SettingValueV2ValueArgs', 'SettingValueV2ValueArgsDict']]] = None) -> 'SettingValueV2':
        """
        Get an existing SettingValueV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] environment_id: The ID of the Environment.
        :param pulumi.Input[str] mandatory_notes: If the Product's "Mandatory notes" preference is turned on for the Environment the Mandatory note must be passed.
        :param pulumi.Input[str] percentage_evaluation_attribute: The user attribute used for percentage evaluation. If not set, it defaults to the Identifier user object attribute.
        :param pulumi.Input[str] setting_id: The ID of the Feature Flag or Setting.
        :param pulumi.Input[str] setting_type: The type of the Feature Flag or Setting. Available values: `boolean`|`string`|`int`|`double`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SettingValueV2TargetingRuleArgs', 'SettingValueV2TargetingRuleArgsDict']]]] targeting_rules: The targeting rules of the Feature Flag or Setting
        :param pulumi.Input[Union['SettingValueV2ValueArgs', 'SettingValueV2ValueArgsDict']] value: Represents the value of a Feature Flag or Setting.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SettingValueV2State.__new__(_SettingValueV2State)

        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["init_only"] = init_only
        __props__.__dict__["mandatory_notes"] = mandatory_notes
        __props__.__dict__["percentage_evaluation_attribute"] = percentage_evaluation_attribute
        __props__.__dict__["setting_id"] = setting_id
        __props__.__dict__["setting_type"] = setting_type
        __props__.__dict__["targeting_rules"] = targeting_rules
        __props__.__dict__["value"] = value
        return SettingValueV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        The ID of the Environment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="initOnly")
    def init_only(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "init_only")

    @property
    @pulumi.getter(name="mandatoryNotes")
    def mandatory_notes(self) -> pulumi.Output[Optional[str]]:
        """
        If the Product's "Mandatory notes" preference is turned on for the Environment the Mandatory note must be passed.
        """
        return pulumi.get(self, "mandatory_notes")

    @property
    @pulumi.getter(name="percentageEvaluationAttribute")
    def percentage_evaluation_attribute(self) -> pulumi.Output[Optional[str]]:
        """
        The user attribute used for percentage evaluation. If not set, it defaults to the Identifier user object attribute.
        """
        return pulumi.get(self, "percentage_evaluation_attribute")

    @property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> pulumi.Output[str]:
        """
        The ID of the Feature Flag or Setting.
        """
        return pulumi.get(self, "setting_id")

    @property
    @pulumi.getter(name="settingType")
    def setting_type(self) -> pulumi.Output[str]:
        """
        The type of the Feature Flag or Setting. Available values: `boolean`|`string`|`int`|`double`.
        """
        return pulumi.get(self, "setting_type")

    @property
    @pulumi.getter(name="targetingRules")
    def targeting_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SettingValueV2TargetingRule']]]:
        """
        The targeting rules of the Feature Flag or Setting
        """
        return pulumi.get(self, "targeting_rules")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output['outputs.SettingValueV2Value']:
        """
        Represents the value of a Feature Flag or Setting.
        """
        return pulumi.get(self, "value")

