# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WebhookArgs', 'Webhook']

@pulumi.input_type
class WebhookArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[str],
                 environment_id: pulumi.Input[str],
                 url: pulumi.Input[str],
                 content: Optional[pulumi.Input[str]] = None,
                 http_method: Optional[pulumi.Input[str]] = None,
                 secure_webhook_headers: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookSecureWebhookHeaderArgs']]]] = None,
                 webhook_headers: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookWebhookHeaderArgs']]]] = None):
        """
        The set of arguments for constructing a Webhook resource.
        :param pulumi.Input[str] config_id: The ID of the Config.
        :param pulumi.Input[str] environment_id: The ID of the Environment.
        :param pulumi.Input[str] url: The URL of the Webhook.
        :param pulumi.Input[str] content: The HTTP body content.
        :param pulumi.Input[str] http_method: The HTTP method. Available values: `get`|`post`. Default: `get`
        :param pulumi.Input[Sequence[pulumi.Input['WebhookWebhookHeaderArgs']]] webhook_headers: List of plain text HTTP headers. The value of a plain text header is always visible for everyone. It also appears in audit logs and on the webhook test UI.
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "url", url)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if secure_webhook_headers is not None:
            pulumi.set(__self__, "secure_webhook_headers", secure_webhook_headers)
        if webhook_headers is not None:
            pulumi.set(__self__, "webhook_headers", webhook_headers)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[str]:
        """
        The ID of the Config.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        The ID of the Environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL of the Webhook.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP body content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP method. Available values: `get`|`post`. Default: `get`
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter(name="secureWebhookHeaders")
    def secure_webhook_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebhookSecureWebhookHeaderArgs']]]]:
        return pulumi.get(self, "secure_webhook_headers")

    @secure_webhook_headers.setter
    def secure_webhook_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookSecureWebhookHeaderArgs']]]]):
        pulumi.set(self, "secure_webhook_headers", value)

    @property
    @pulumi.getter(name="webhookHeaders")
    def webhook_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebhookWebhookHeaderArgs']]]]:
        """
        List of plain text HTTP headers. The value of a plain text header is always visible for everyone. It also appears in audit logs and on the webhook test UI.
        """
        return pulumi.get(self, "webhook_headers")

    @webhook_headers.setter
    def webhook_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookWebhookHeaderArgs']]]]):
        pulumi.set(self, "webhook_headers", value)


@pulumi.input_type
class _WebhookState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 http_method: Optional[pulumi.Input[str]] = None,
                 secure_webhook_headers: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookSecureWebhookHeaderArgs']]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 webhook_headers: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookWebhookHeaderArgs']]]] = None):
        """
        Input properties used for looking up and filtering Webhook resources.
        :param pulumi.Input[str] config_id: The ID of the Config.
        :param pulumi.Input[str] content: The HTTP body content.
        :param pulumi.Input[str] environment_id: The ID of the Environment.
        :param pulumi.Input[str] http_method: The HTTP method. Available values: `get`|`post`. Default: `get`
        :param pulumi.Input[str] url: The URL of the Webhook.
        :param pulumi.Input[Sequence[pulumi.Input['WebhookWebhookHeaderArgs']]] webhook_headers: List of plain text HTTP headers. The value of a plain text header is always visible for everyone. It also appears in audit logs and on the webhook test UI.
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if secure_webhook_headers is not None:
            pulumi.set(__self__, "secure_webhook_headers", secure_webhook_headers)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if webhook_headers is not None:
            pulumi.set(__self__, "webhook_headers", webhook_headers)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Config.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP body content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP method. Available values: `get`|`post`. Default: `get`
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter(name="secureWebhookHeaders")
    def secure_webhook_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebhookSecureWebhookHeaderArgs']]]]:
        return pulumi.get(self, "secure_webhook_headers")

    @secure_webhook_headers.setter
    def secure_webhook_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookSecureWebhookHeaderArgs']]]]):
        pulumi.set(self, "secure_webhook_headers", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Webhook.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="webhookHeaders")
    def webhook_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebhookWebhookHeaderArgs']]]]:
        """
        List of plain text HTTP headers. The value of a plain text header is always visible for everyone. It also appears in audit logs and on the webhook test UI.
        """
        return pulumi.get(self, "webhook_headers")

    @webhook_headers.setter
    def webhook_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookWebhookHeaderArgs']]]]):
        pulumi.set(self, "webhook_headers", value)


class Webhook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 http_method: Optional[pulumi.Input[str]] = None,
                 secure_webhook_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebhookSecureWebhookHeaderArgs', 'WebhookSecureWebhookHeaderArgsDict']]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 webhook_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebhookWebhookHeaderArgs', 'WebhookWebhookHeaderArgsDict']]]]] = None,
                 __props__=None):
        """
        Creates and manages a **Webhook**. [What is a Webhook in ConfigCat?](https://configcat.com/docs/advanced/notifications-webhooks/)

        ## Import

        Webhooks can be imported using the WebhookId. Get the WebhookId using the [List Webhooks API](https://api.configcat.com/docs/index.html#tag/Webhooks/operation/get-webhooks) for example.

        It is important to note that webhooks containing secure webhook headers cannot be imported via `pulumi import`.

        If you want to manage your webhooks that already contain secure webhook headers, you should create brand new configcat_webhook resources in Terraform without importing them. After they are created successfully and managed by Terraform, you can safely delete the old, non Terraform managed webhook from the ConfigCat Dashboard.

        ```sh
        $ pulumi import configcat:index/webhook:Webhook example 1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_id: The ID of the Config.
        :param pulumi.Input[str] content: The HTTP body content.
        :param pulumi.Input[str] environment_id: The ID of the Environment.
        :param pulumi.Input[str] http_method: The HTTP method. Available values: `get`|`post`. Default: `get`
        :param pulumi.Input[str] url: The URL of the Webhook.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WebhookWebhookHeaderArgs', 'WebhookWebhookHeaderArgsDict']]]] webhook_headers: List of plain text HTTP headers. The value of a plain text header is always visible for everyone. It also appears in audit logs and on the webhook test UI.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebhookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages a **Webhook**. [What is a Webhook in ConfigCat?](https://configcat.com/docs/advanced/notifications-webhooks/)

        ## Import

        Webhooks can be imported using the WebhookId. Get the WebhookId using the [List Webhooks API](https://api.configcat.com/docs/index.html#tag/Webhooks/operation/get-webhooks) for example.

        It is important to note that webhooks containing secure webhook headers cannot be imported via `pulumi import`.

        If you want to manage your webhooks that already contain secure webhook headers, you should create brand new configcat_webhook resources in Terraform without importing them. After they are created successfully and managed by Terraform, you can safely delete the old, non Terraform managed webhook from the ConfigCat Dashboard.

        ```sh
        $ pulumi import configcat:index/webhook:Webhook example 1234
        ```

        :param str resource_name: The name of the resource.
        :param WebhookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebhookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 http_method: Optional[pulumi.Input[str]] = None,
                 secure_webhook_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebhookSecureWebhookHeaderArgs', 'WebhookSecureWebhookHeaderArgsDict']]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 webhook_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebhookWebhookHeaderArgs', 'WebhookWebhookHeaderArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebhookArgs.__new__(WebhookArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            __props__.__dict__["content"] = content
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["http_method"] = http_method
            __props__.__dict__["secure_webhook_headers"] = secure_webhook_headers
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["webhook_headers"] = webhook_headers
        super(Webhook, __self__).__init__(
            'configcat:index/webhook:Webhook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[str]] = None,
            content: Optional[pulumi.Input[str]] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            http_method: Optional[pulumi.Input[str]] = None,
            secure_webhook_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebhookSecureWebhookHeaderArgs', 'WebhookSecureWebhookHeaderArgsDict']]]]] = None,
            url: Optional[pulumi.Input[str]] = None,
            webhook_headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WebhookWebhookHeaderArgs', 'WebhookWebhookHeaderArgsDict']]]]] = None) -> 'Webhook':
        """
        Get an existing Webhook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_id: The ID of the Config.
        :param pulumi.Input[str] content: The HTTP body content.
        :param pulumi.Input[str] environment_id: The ID of the Environment.
        :param pulumi.Input[str] http_method: The HTTP method. Available values: `get`|`post`. Default: `get`
        :param pulumi.Input[str] url: The URL of the Webhook.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WebhookWebhookHeaderArgs', 'WebhookWebhookHeaderArgsDict']]]] webhook_headers: List of plain text HTTP headers. The value of a plain text header is always visible for everyone. It also appears in audit logs and on the webhook test UI.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebhookState.__new__(_WebhookState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["content"] = content
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["http_method"] = http_method
        __props__.__dict__["secure_webhook_headers"] = secure_webhook_headers
        __props__.__dict__["url"] = url
        __props__.__dict__["webhook_headers"] = webhook_headers
        return Webhook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[str]:
        """
        The ID of the Config.
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[str]]:
        """
        The HTTP body content.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        The ID of the Environment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> pulumi.Output[str]:
        """
        The HTTP method. Available values: `get`|`post`. Default: `get`
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="secureWebhookHeaders")
    def secure_webhook_headers(self) -> pulumi.Output[Optional[Sequence['outputs.WebhookSecureWebhookHeader']]]:
        return pulumi.get(self, "secure_webhook_headers")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL of the Webhook.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="webhookHeaders")
    def webhook_headers(self) -> pulumi.Output[Optional[Sequence['outputs.WebhookWebhookHeader']]]:
        """
        List of plain text HTTP headers. The value of a plain text header is always visible for everyone. It also appears in audit logs and on the webhook test UI.
        """
        return pulumi.get(self, "webhook_headers")

