# Copyright 2024 Marimo. All rights reserved.
from __future__ import annotations


# Mapping from a module name to the corresponding package name
# on PyPI
def module_name_to_pypi_name() -> dict[str, str]:
    return {
        "AFQ": "pyAFQ",
        "AG_fft_tools": "agpy",
        "Adafruit": "Adafruit-Libraries",
        "Asterisk": "py-Asterisk",
        "BB_jekyll_hook": "bitbucket-jekyll-hook",
        "Banzai": "Banzai-NGS",
        "BeautifulSoupTests": "BeautifulSoup",
        "BioSQL": "biopython",
        "BuildbotStatusShields": "BuildbotEightStatusShields",
        "Crypto": "pycryptodome",
        "Cryptodome": "pycryptodomex",
        "FiftyOneDegrees": "51degrees-mobile-detector-v3-wrapper",
        "GeoBases": "GeoBasesDev",
        "IPython": "ipython",
        "Kittens": "astro-kittens",
        "Levenshtein": "python-Levenshtein",
        "MethodObject": "ExtensionClass",
        "MySQLdb": "MySQL-python",
        "OpenGL": "PyOpenGL",
        "OpenSSL": "pyOpenSSL",
        "PIL": "Pillow",
        "PyWCSTools": "astLib",
        "Pyxides": "astro-pyxis",
        "S3": "s3cmd",
        "SCons": "pystick",
        "Stemmer": "PyStemmer",
        "TopZooTools": "topzootools",
        "TreeDisplay": "DocumentTemplate",
        "WorkingWithDocumentConversion": "aspose-pdf-java-for-python",
        "aadb": "auto-adjust-display-brightness",
        "abakaffe": "abakaffe-cli",
        "abiosgaming": "abiosgaming.py",
        "abiquo": "abiquo-api",
        "abl": "abl.vpath",
        "abo": "abo-generator",
        "abris_transform": "abris",
        "abstract": "abstract.jwrotator",
        "abu": "abu.admin",
        "ac_flask": "AC-Flask-HipChat",
        "acg": "anikom15",
        "acme": "acme.hello",
        "acted": "acted.projects",
        "action": "ActionServer",
        "actionbar": "actionbar.panel",
        "activehomed": "afn",
        "activepapers": "ActivePapers.Py",
        "address_book": "address-book-lansry",
        "adi": "adi.trash",
        "adict": "aDict2",
        "aditam": "aditam.core",
        "adiumsh": "adium-sh",
        "adjector": "AdjectorTracPlugin",
        "adkit": "Banner-Ad-Toolkit",
        "admin_tools": "django-admin-tools",
        "adminishcategories": "adminish-categories",
        "adminsortable": "django-admin-sortable",
        "adspygoogle": "adspygoogle.adwords",
        "advancedcaching": "agtl",
        "adytum": "Adytum-PyMonitor",
        "affinitic": "affinitic.zamqp",
        "afpy": "afpy.xap",
        "agatesql": "agate-sql",
        "ageliaco": "ageliaco.recipe.csvconfig",
        "agent_http": "agent.http",
        "agents": "openai-agents",
        "agora": "Agora-Service-Provider",
        "agoraplex": "agoraplex.themes.sphinx",
        "agsci": "agsci.blognewsletter",
        "agx": "agx.transform.xmi2uml",
        "aimes": "aimes.skeleton",
        "aio": "aio.signals",
        "aiohs2": "aio-hs2",
        "aioroutes": "aio-routes",
        "aios3": "aio-s3",
        "airbrake": "airbrake-flask",
        "airship": "airship-steamcloud",
        "akamai": "edgegrid-python",
        "alation": "alation-api",
        "alba_client": "alba-client-python",
        "alburnum": "alburnum-maas-client",
        "alchemist": "alchemist.ui",
        "alchemyapi": "alchemyapi-python",
        "alerta": "alerta-server",
        "alexandria_upload": "Alexandria-Upload-Utils",
        "alibaba": "alibaba-python-sdk",
        "aliyun": "aliyun-python-sdk",
        "aliyuncli": "alicloudcli",
        "aliyunsdkacs": "aliyun-python-sdk-acs",
        "aliyunsdkbatchcompute": "aliyun-python-sdk-batchcompute",
        "aliyunsdkbsn": "aliyun-python-sdk-bsn",
        "aliyunsdkbss": "aliyun-python-sdk-bss",
        "aliyunsdkcdn": "aliyun-python-sdk-cdn",
        "aliyunsdkcms": "aliyun-python-sdk-cms",
        "aliyunsdkcore": "aliyun-python-sdk-core",
        "aliyunsdkcrm": "aliyun-python-sdk-crm",
        "aliyunsdkcs": "aliyun-python-sdk-cs",
        "aliyunsdkdrds": "aliyun-python-sdk-drds",
        "aliyunsdkecs": "aliyun-python-sdk-ecs",
        "aliyunsdkess": "aliyun-python-sdk-ess",
        "aliyunsdkft": "aliyun-python-sdk-ft",
        "aliyunsdkmts": "aliyun-python-sdk-mts",
        "aliyunsdkocs": "aliyun-python-sdk-ocs",
        "aliyunsdkoms": "aliyun-python-sdk-oms",
        "aliyunsdkossadmin": "aliyun-python-sdk-ossadmin",
        "aliyunsdkr-kvstore": "aliyun-python-sdk-r-kvstore",
        "aliyunsdkram": "aliyun-python-sdk-ram",
        "aliyunsdkrds": "aliyun-python-sdk-rds",
        "aliyunsdkrisk": "aliyun-python-sdk-risk",
        "aliyunsdkros": "aliyun-python-sdk-ros",
        "aliyunsdkslb": "aliyun-python-sdk-slb",
        "aliyunsdksts": "aliyun-python-sdk-sts",
        "aliyunsdkubsms": "aliyun-python-sdk-ubsms",
        "aliyunsdkyundun": "aliyun-python-sdk-yundun",
        "allattachments": "AllAttachmentsMacro",
        "allocine": "allocine-wrapper",
        "allowedsites": "django-allowedsites",
        "alm": "alm.solrindex",
        "aloft": "aloft.py",
        "alpacalib": "alpaca",
        "alphabetic": "alphabetic-simple",
        "alphasms": "alphasms-client",
        "altered": "altered.states",
        "alterootheme": "alterootheme.lazydays",
        "alurinium": "alurinium-image-processing",
        "alxlib": "alx",
        "amara3": "amara3-xml",
        "amazon": "python-amazon-simple-product-api",
        "ambikesh1349-1": "ambikesh1349-1",
        "ambilight": "AmbilightParty",
        "amifs": "amifs-core",
        "amiorganizer": "ami-organizer",
        "amitu": "amitu-zutils",
        "amltlearn": "AMLT-learn",
        "amocrm": "amocrm-api",
        "amqpdispatcher": "amqp-dispatcher",
        "amqpstorm": "AMQP-Storm",
        "analytics": "analytics-python",
        "analyzedir": "AnalyzeDirectory",
        "ancientsolutions": "ancientsolutions-crypttools",
        "anderson_paginator": "anderson.paginator",
        "android_clean_app": "android-resource-remover",
        "anel_power_control": "AnelPowerControl",
        "angus": "angus-sdk-python",
        "annalist_root": "Annalist",
        "annogesiclib": "ANNOgesic",
        "ansible-role-apply": "ansible-role-apply",
        "ansibledebugger": "ansible-playbook-debugger",
        "ansibledocgen": "ansible-docgen",
        "ansibleflow": "ansible-flow",
        "ansibleinventorygrapher": "ansible-inventory-grapher",
        "ansiblelint": "ansible-lint",
        "ansiblerolesgraph": "ansible-roles-graph",
        "ansibletools": "ansible-tools",
        "anthill": "anthill.tal.macrorenderer",
        "anthrax": "AnthraxImage",
        "antisphinx": "antiweb",
        "antispoofing": "antispoofing.evaluation",
        "antlr4": "antlr4-python-alt",
        "anybox": "anybox.scripts.odoo",
        "apitools": "google-apitools",
        "apm": "arpm",
        "app_data": "django-appdata",
        "appconf": "django-appconf",
        "appd": "AppDynamicsREST",
        "appdynamics_bindeps": "appdynamics-bindeps-osx-x64",
        "appdynamics_proxysupport": "appdynamics-proxysupport-osx-x64",
        "appium": "Appium-Python-Client",
        "appliapps": "applibase",
        "appserver": "broadwick",
        "archetypes": "archetypes.schemaextender",
        "arm": "ansible-role-manager",
        "armor": "armor-api",
        "armstrong": "armstrong.utils.celery",
        "arstecnica": "arstecnica.sqlalchemy.async",
        "article-downloader": "article-downloader",
        "artifactcli": "artifact-cli",
        "arvados": "arvados-python-client",
        "arvados_cwl": "arvados-cwl-runner",
        "arvnodeman": "arvados-node-manager",
        "asana_to_github": "AsanaToGithub",
        "asciibinary": "AsciiBinaryConverter",
        "asd": "AdvancedSearchDiscovery",
        "askbot": "askbot-tuanpa",
        "asnhistory": "asnhistory-redis",
        "aspen_jinja2_renderer": "aspen-jinja2",
        "aspen_tornado_engine": "aspen-tornado",
        "asprise_ocr_api": "asprise-ocr-sdk-python-api",
        "aspy": "aspy.yaml",
        "asterisk": "asterisk-ami",
        "asts": "add-asts",
        "asymmetricbase": "asymmetricbase.utils",
        "asyncirc": "asyncio-irc",
        "asyncmongoorm": "asyncmongoorm-je",
        "asyncssh": "asyncssh-unofficial",
        "athletelist": "athletelistyy",
        "atm": "automium",
        "atmosphere": "atmosphere-python-client",
        "atom": "gdata",
        "atomic": "AtomicWrite",
        "atomisator": "atomisator.readers",
        "atreal": "atreal.usersinout",
        "atsim": "atsim.potentials",
        "attractsdk": "attract-sdk",
        "audio": "audio.wave",
        "aufrefer": "auf-refer",
        "auslfe": "auslfe.formonline.content",
        "auspost": "auspost-apis",
        "auth0": "auth0-python",
        "auth_server_client": "AuthServerClient",
        "authorize": "AuthorizeSauce",
        "authzpolicy": "AuthzPolicyPlugin",
        "autobahn": "autobahn-rce",
        "avatar": "geonode-avatar",
        "awebview": "android-webview",
        "azure": "azure-storage",
        "b2gcommands": "b2g-commands",
        "b2gperf": "b2gperf-v2.2",
        "b2gpopulate": "b2gpopulate-v2.2",
        "b3j0f": "b3j0f.utils",
        "babel": "Babel",
        "babelglade": "BabelGladeExtractor",
        "backplane": "backplane2-pyclient",
        "backport_abcoll": "backport-collections",
        "backports": "backports.statistics",
        "badgekit": "badgekit-api-client",
        "badlinks": "BadLinksPlugin",
        "bael": "bael.project",
        "baidu": "baidupy",
        "balrog": "buildtools",
        "baluhn": "baluhn-redux",
        "bamboo": "bamboo-server",
        "bambu": "bambu-sites",
        "banana": "banana.maya",
        "bang": "bangtext",
        "barcode": "barcode-generator",
        "bark": "bark-ssg",
        "barking_owl": "BarkingOwl",
        "bart": "bart-py",
        "basalt": "basalt-tasks",
        "base62": "base-62",
        "basemap": "basemap-Jim",
        "bash": "bash-toolbelt",
        "bashutils": "Python-Bash-Utils",
        "basic_http": "BasicHttp",
        "basil": "basil-daq",
        "batchapps": "azure-batch-apps",
        "bcrypt": "python-bcrypt",
        "beaker": "Beaker",
        "beetsplug": "beets",
        "begin": "begins",
        "benchit": "bench-it",
        "beproud": "beproud.utils",
        "bfillings": "burrito-fillings",
        "bigquery": "google-cloud-bigquery",
        "billboard": "billboard.py",
        "binstar_build_client": "anaconda-build",
        "binstar_client": "anaconda-client",
        "biocommons": "biocommons.dev",
        "birdhousebuilder": "birdhousebuilder.recipe.supervisor",
        "blender26-meshio": "pymeshio",
        "borg": "borg.localrole",
        "bow": "bagofwords",
        "bpdb": "bpython",
        "bqapi": "bisque-api",
        "braces": "django-braces",
        "briefscaster": "briefs-caster",
        "brisa_media_server/plugins": "brisa-media-server-plugins",
        "brkt_requests": "brkt-sdk",
        "broadcastlogging": "broadcast-logging",
        "brocadetool": "brocade-tool",
        "bronto": "bronto-python",
        "brownie": "Brownie",
        "browsermobproxy": "browsermob-proxy",
        "brubeckmysql": "brubeck-mysql",
        "brubeckoauth": "brubeck-oauth",
        "brubeckservice": "brubeck-service",
        "brubeckuploader": "brubeck-uploader",
        "bs4": "beautifulsoup4",
        "bst": "bst.pygasus.wsgi",
        "btable": "btable-py",
        "btapi": "bananatag-api",
        "btceapi": "btce-api",
        "btcebot": "btce-bot",
        "btsync": "btsync.py",
        "buck": "buck.pprint",
        "bud": "bud.nospam",
        "budy": "budy-api",
        "buffer": "buffer-alpaca",
        "buggd": "bug.gd",
        "bugle": "bugle-sites",
        "bugspots": "bug-spots",
        "bugzilla": "python-bugzilla",
        "bugzscout": "bugzscout-py",
        "buildTools": "ajk-ios-buildTools",
        "buildnotifylib": "BuildNotify",
        "buildout": "buildout.variables",
        "buildslave": "buildbot-slave",
        "bumper": "bumper-lib",
        "bumple": "bumple-downloader",
        "bundesliga": "bundesliga-cli",
        "bundlemaker": "bundlemanager",
        "burpui": "burp-ui",
        "busyflow": "busyflow.pivotal",
        "buttercms-django": "buttercms-django",
        "buzz": "buzz-python-client",
        "bvc": "buildout-versions-checker",
        "bvggrabber": "bvg-grabber",
        "byond": "BYONDTools",
        "bzETL": "Bugzilla-ETL",
        "bzlib": "bugzillatools",
        "bzrlib": "bzr-pqm",
        "c2c": "c2c.versions",
        "c2c_recipe_facts": "c2c.recipe.facts",
        "cabalgata": "cabalgata-zookeeper",
        "cache_utils": "django-cache-utils",
        "captcha": "django-recaptcha",
        "carbon3d": "carbon3d-client",
        "cartridge": "Cartridge",
        "cassandra": "cassandra-driver",
        "cassandralauncher": "CassandraLauncher",
        "cc42": "42qucc",
        "cerberus": "Cerberus",
        "cfnlint": "cfn-lint",
        "chalk": "chalk-diagrams",
        "chameleon": "Chameleon",
        "charmtools": "charm-tools",
        "chef": "PyChef",
        "chip8": "c8d",
        "cjson": "python-cjson",
        "classytags": "django-classy-tags",
        "cloghandler": "ConcurrentLogHandler",
        "clonevirtualenv": "virtualenv-clone",
        "cloud-insight": "al-cloudinsight",
        "cloud_admin": "adminapi",
        "cloudservers": "python-cloudservers",
        "cms": "django-cms",
        "colander": "ba-colander",
        "colors": "ansicolors",
        "compile": "bf-lc3",
        "compose": "docker-compose",
        "compressor": "django-compressor",
        "concurrent": "futures",
        "configargparse": "ConfigArgParse",
        "contracts": "PyContracts",
        "couchapp": "Couchapp",
        "couchdb": "CouchDB",
        "couchdbcurl": "couchdb-python-curl",
        "courseradownloader": "coursera-dl",
        "cow": "cow-framework",
        "creole": "python-creole",
        "creoleparser": "Creoleparser",
        "crispy_forms": "django-crispy-forms",
        "crontab": "python-crontab",
        "ctff": "tff",
        "cups": "pycups",
        "curator": "elasticsearch-curator",
        "curl": "pycurl",
        "cv2": "opencv-python",
        "daemon": "python-daemon",
        "dagger": "dagger-io",
        "dare": "DARE",
        "dateutil": "python-dateutil",
        "dawg": "DAWG",
        "debian": "python-debian",
        "decouple": "python-decouple",
        "demo": "webunit",
        "deployer": "juju-deployer",
        "depot": "filedepot",
        "dgis": "2gis",
        "dhtmlparser": "pyDHTMLParser",
        "digitalocean": "python-digitalocean",
        "discord": "discord.py",
        "distribute_setup": "ez-setup",
        "distutils2": "Distutils2",
        "django": "Django",
        "django_hstore": "amitu-hstore",
        "djangobower": "django-bower",
        "djcelery": "django-celery",
        "djkombu": "django-kombu",
        "djorm_pgarray": "djorm-ext-pgarray",
        "dns": "dnspython",
        "docgen": "ansible-docgenerator",
        "docker": "docker-py",
        "docx": "python-docx",
        "dogpile": "dogpile.core",
        "dogshell": "dogapi",
        "dot_parser": "pydot3k",
        "dotenv": "python-dotenv",
        "dpkt": "dpkt-fix",
        "durationfield": "django-durationfield",
        "dzclient": "datazilla",
        "easybuild": "easybuild-framework",
        "editor": "python-editor",
        "elasticluster": "azure-elasticluster-current",
        "elftools": "pyelftools",
        "elixir": "Elixir",
        "ell": "ell-ai",
        "emlib": "empy",
        "enchant": "pyenchant",
        "encutils": "cssutils",
        "engineio": "python-engineio",
        "enum": "enum34",
        "ephem": "pyephem",
        "errorreporter": "abl.errorreporter",
        "esplot": "beaker-es-plot",
        "example": "adrest",
        "examples": "tweepy",
        "ez_setup": "pycassa",
        "fabric": "Fabric",
        "faker": "Faker",
        "fasthtml": "python-fasthtml",
        "fedora": "python-fedora",
        "ffmpeg": "ffmpeg-python",
        "fias": "ailove-django-fias",
        "fiftyone_degrees": "51degrees-mobile-detector",
        "five": "five.pt",
        "flasher": "android-flasher",
        "flask": "Flask",
        "flask_frozen": "Frozen-Flask",
        "flask_redis": "Flask-And-Redis",
        "flaskext": "Flask-Bcrypt",
        "flvscreen": "vnc2flv",
        "followit": "django-followit",
        "forge": "pyforge",
        "formencode": "FormEncode",
        "formtools": "django-formtools",
        "fourch": "4ch",
        "franz": "allegrordf",
        "freetype": "freetype-py",
        "frontmatter": "python-frontmatter",
        "ftpcloudfs": "ftp-cloudfs",
        "functional": "pyfunctional",
        "funtests": "librabbitmq",
        "fuse": "fusepy",
        "fuzzy": "Fuzzy",
        "gabbi": "tiddlyweb",
        "gen_3dwallet": "3d-wallet-generator",
        "gendimen": "android-gendimen",
        "genshi": "Genshi",
        "geonode": "GeoNode",
        "geoserver": "gsconfig",
        "geraldo": "Geraldo",
        "getenv": "django-getenv",
        "geventwebsocket": "gevent-websocket",
        "gflags": "python-gflags",
        "git": "GitPython",
        "github": "PyGithub",
        "github3": "github3.py",
        "gitpy": "git-py",
        "globusonline": "globusonline-transfer-api-client",
        "google": "protobuf",
        "googleapiclient": "google-api-python-client",
        "grace-dizmo": "grace-dizmo",
        "grammar": "anovelmous-grammar",
        "grapheneapi": "graphenelib",
        "greplin": "scales",
        "gridfs": "pymongo",
        "grokcore": "grokcore.component",
        "gslib": "gsutil",
        "hamcrest": "PyHamcrest",
        "harpy": "HARPy",
        "hawk": "PyHawk-with-a-single-extra-commit",
        "haystack": "django-haystack",
        "hgext": "mercurial",
        "hggit": "hg-git",
        "hglib": "python-hglib",
        "hola": "amarokHola",
        "hoover": "Hoover",
        "hostlist": "python-hostlist",
        "htmloutput": "nosehtmloutput",
        "hulearn": "human-learn",
        "hvad": "django-hvad",
        "hydra": "hydra-core",
        "i99fix": "199Fix",
        "ibis": "ibis-framework[duckdb]",
        "igraph": "python-igraph",
        "imdb": "IMDbPY",
        "impala": "impyla",
        "inmemorystorage": "ambition-inmemorystorage",
        "ipaddress": "backport-ipaddress",
        "jaraco": "jaraco.util",
        "jinja2": "Jinja2",
        "jiracli": "jira-cli",
        "johnny": "johnny-cache",
        "jpypex": "JPype1",
        "jsonfield": "django-jsonfield",
        "jstools": "aino-jstools",
        "jupyterpip": "jupyter-pip",
        "jwt": "PyJWT",
        "kazoo": "asana-kazoo",
        "kernprof": "line-profiler",
        "keyczar": "python-keyczar",
        "keyedcache": "django-keyedcache",
        "keystoneclient": "python-keystoneclient",
        "kickstarter": "kickstart",
        "krbv": "krbV",
        "kss": "kss.core",
        "kuyruk": "Kuyruk",
        "langconv": "AdvancedLangConv",
        "lava": "lava-utils-interface",
        "lazr": "lazr.uri",
        "ldaplib": "adpasswd",
        "ldif": "python-ldap",
        "lib2or3": "2or3",
        "lib3to2": "3to2",
        "libaito": "Aito",
        "libbe": "bugs-everywhere",
        "libbucket": "bucket",
        "libcloud": "apache-libcloud",
        "libgenerateDS": "generateDS",
        "libmproxy": "mitmproxy",
        "libsvm": "7lk-ocr-deploy",
        "lilypad": "lilypad-sdk",
        "lisa": "lisa-server",
        "loadingandsaving": "aspose-words-java-for-python",
        "locust": "locustio",
        "logbook": "Logbook",
        "logentries": "buildbot-status-logentries",
        "logilab": "logilab-mtconverter",
        "magic": "python-magic",
        "mako": "Mako",
        "manifestparser": "ManifestDestiny",
        "marionette": "marionette-client",
        "markdown": "Markdown",
        "marks": "pytest-marks",
        "markupsafe": "MarkupSafe",
        "mavnative": "pymavlink",
        "memcache": "python-memcached",
        "metacomm": "AllPairs",
        "metaphone": "Metafone",
        "metlog": "metlog-py",
        "mezzanine": "Mezzanine",
        "migrate": "sqlalchemy-migrate",
        "mimeparse": "python-mimeparse",
        "minitage": "minitage.recipe.common",
        "missingdrawables": "android-missingdrawables",
        "mkrst_themes": "2lazy2rest",
        "mockredis": "mockredispy",
        "modargs": "python-modargs",
        "model_utils": "django-model-utils",
        "models": "asposestorage",
        "moksha": "moksha.wsgi",
        "moneyed": "py-moneyed",
        "mongoalchemy": "MongoAlchemy",
        "monthdelta": "MonthDelta",
        "mopidy": "Mopidy",
        "mopytools": "MoPyTools",
        "mptt": "django-mptt",
        "mpv": "python-mpv",
        "mrbob": "mr.bob",
        "msgpack": "msgpack-python",
        "mutations": "aino-mutations",
        "mws": "amazon-mws",
        "mysql": "mysql-connector-repackaged",
        "native_tags": "django-native-tags",
        "ndg": "ndg-httpsclient",
        "nereid": "trytond-nereid",
        "nested": "baojinhuan",
        "nester": "bssm-pythonSig",
        "novaclient": "python-novaclient",
        "oauth2_provider": "alauda-django-oauth",
        "oauth2client": "oauth2client",
        "odf": "odfpy",
        "ometa": "Parsley",
        "openid": "python-openid",
        "opensearchsdk": "ali-opensearch",
        "oslo_i18n": "oslo.i18n",
        "oslo_serialization": "oslo.serialization",
        "oslo_utils": "oslo.utils",
        "oss": "aliyunoss",
        "output": "cashew",
        "owslib": "OWSLib",
        "paho": "paho-mqtt",
        "paintstore": "django-paintstore",
        "parler": "django-parler",
        "paste": "PasteScript",
        "path": "path.py",
        "patricia": "patricia-trie",
        "paver": "Paver",
        "pdfminer": "pdfminer.six",
        "peak": "ProxyTypes",
        "picasso": "anderson.picasso",
        "picklefield": "django-picklefield",
        "pilot": "BigJob",
        "pivotal": "pivotal-py",
        "plivoxml": "plivo",
        "plone": "plone.z3cform",
        "plonetheme": "plonetheme.barceloneta",
        "png": "pypng",
        "polymorphic": "django-polymorphic",
        "postmark": "python-postmark",
        "powerprompt": "bash-powerprompt",
        "prefetch": "django-prefetch",
        "printList": "AndrewList",
        "progressbar": "progressbar33",
        "provider": "django-oauth2-provider",
        "psycopg2": "psycopg2-binary",
        "puresasl": "pure-sasl",
        "pwiz": "peewee",
        "py7zlib": "pylzma",
        "pyAMI": "pyAMI-core",
        "pyarsespyder": "arsespyder",
        "pyasdf": "asdf",
        "pyaspell": "aspell-python-ctypes",
        "pybb": "pybbm",
        "pybloomfilter": "pybloomfiltermmap",
        "pyccuracy": "Pyccuracy",
        "pyck": "PyCK",
        "pycrfsuite": "python-crfsuite",
        "pydispatch": "PyDispatcher",
        "pygeolib": "pygeocoder",
        "pygments": "Pygments",
        "pygraph": "python-graph-core",
        "pyjon": "pyjon.utils",
        "pyjsonrpc": "python-jsonrpc",
        "pykka": "Pykka",
        "pylogo": "PyLogo",
        "pylons": "adhocracy-Pylons",
        "pymagic": "libmagic",
        "pymycraawler": "Amalwebcrawler",
        "pynma": "AbakaffeNotifier",
        "pyphen": "Pyphen",
        "pyrimaa": "AEI",
        "pysideuic": "PySide",
        "pysqlite2": "pysqlite",
        "pysynth_samp": "PySynth",
        "pythongettext": "python-gettext",
        "pythonjsonlogger": "python-json-logger",
        "pyutilib": "PyUtilib",
        "pyximport": "Cython",
        "qs": "qserve",
        "quadtree": "python-geohash",
        "quaternion": "numpy-quaternion",
        "quickapi": "django-quickapi",
        "quickunit": "nose-quickunit",
        "rackdiag": "nwdiag",
        "radical": "radical.utils",
        "readability": "readability-lxml",
        "readline": "gnureadline",
        "recaptcha_works": "django-recaptcha-works",
        "relstorage": "RelStorage",
        "reportapi": "django-reportapi",
        "requests": "Requests",
        "requirements": "requirements-parser",
        "rest_framework": "djangorestframework",
        "restclient": "py-restclient",
        "retrial": "async-retrial",
        "reversion": "django-reversion",
        "rhaptos2": "rhaptos2.common",
        "robot": "robotframework",
        "robots": "django-robots",
        "rosdep2": "rosdep",
        "rsbackends": "RSFile",
        "ruamel": "ruamel.base",
        "saga": "saga-python",
        "samtranslator": "aws-sam-translator",
        "sassutils": "libsass",
        "sayhi": "alex-sayhi",
        "scalrtools": "scalr",
        "scikits": "scikits.talkbox",
        "scratch": "scratchpy",
        "screen": "pexpect",
        "scss": "pyScss",
        "sdict": "dict.sorted",
        "sdk_updater": "android-sdk-updater",
        "sekizai": "django-sekizai",
        "sendfile": "pysendfile",
        "serial": "pyserial",
        "setuputils": "astor",
        "shapefile": "pyshp",
        "shapely": "Shapely",
        "shopify": "ShopifyAPI",
        "sika": "ahonya-sika",
        "singleton": "pysingleton",
        "skbio": "scikit-bio",
        "skimage": "scikit-image",
        "sklearn": "scikit-learn",
        "sklego": "scikit-lego",
        "skvideo": "scikit-video",
        "slack": "slackclient",
        "slugify": "unicode-slugify",
        "smarkets": "smk-python-sdk",
        "snappy": "ctypes-snappy",
        "snowflake": "snowflake-connector-python",
        "socketio": "gevent-socketio",
        "sockjs": "sockjs-tornado",
        "socks": "SocksiPy-branch",
        "solr": "solrpy",
        "solution": "Solution",
        "sorl": "sorl-thumbnail",
        "south": "South",
        "sphinx": "Sphinx",
        "sphinx_pypi_upload": "ATD-document",
        "sphinxcontrib": "sphinxcontrib-programoutput",
        "sqlalchemy": "SQLAlchemy",
        "src": "auto-mix-prep",
        "stats_toolkit": "bw-stats-toolkit",
        "statsd": "dogstatsd-python",
        "stdnum": "python-stdnum",
        "stoneagehtml": "StoneageHTML",
        "storages": "django-storages",
        "stubout": "mox",
        "suds": "suds-jurko",
        "swiftclient": "python-swiftclient",
        "sx": "pisa",
        "taggit": "django-taggit",
        "tasksitter": "cerebrod",
        "tastypie": "django-tastypie",
        "teamcity": "teamcity-messages",
        "telebot": "pyTelegramBotAPI",
        "telegram": "python-telegram-bot",
        "tempita": "Tempita",
        "tenjin": "Tenjin",
        "termstyle": "python-termstyle",
        "test": "pytabix",
        "thclient": "treeherder-client",
        "threaded_multihost": "django-threaded-multihost",
        "threecolor": "3color-Press",
        "tidylib": "pytidylib",
        "tlw": "3lwg",
        "toredis": "toredis-fork",
        "tornadoredis": "tornado-redis",
        "tower_cli": "ansible-tower-cli",
        "tracopt": "Trac",
        "translation_helper": "android-localization-helper",
        "treebeard": "django-treebeard",
        "trytond": "trytond-stock",
        "tsuru": "tsuru-circus",
        "tvrage": "python-tvrage",
        "tw2": "tw2.sqla",
        "twisted": "Twisted",
        "twitter": "python-twitter",
        "txclib": "transifex-client",
        "u115": "115wangpan",
        "umap": "umap-learn",
        "unidecode": "Unidecode",
        "universe": "ansible-universe",
        "usb": "pyusb",
        "useless": "useless.pipes",
        "userpass": "auth-userpass",
        "utilities": "automakesetup.py",
        "utkik": "aino-utkik",
        "uwsgidecorators": "uWSGI",
        "valentine": "ab",
        "validate": "configobj",
        "version": "chartio",
        "virtualenvapi": "ar-virtualenv-api",
        "vyatta": "brocade-plugins",
        "webdav": "Zope2",
        "weblogolib": "weblogo",
        "webob": "WebOb",
        "websocket": "websocket-client",
        "webtest": "WebTest",
        "werkzeug": "Werkzeug",
        "wheezy": "wheezy.http",
        "whisper": "openai-whisper",
        "wikklytext": "tiddlywebwiki",
        "winreg": "future",
        "winrm": "pywinrm",
        "workflow": "Alfred-Workflow",
        "wsmeext": "WSME",
        "wtforms": "WTForms",
        "wtfpeewee": "wtf-peewee",
        "xdg": "pyxdg",
        "xdist": "pytest-xdist",
        "xmlenc": "pysaml2",
        "xmlrpc": "pies2overrides",
        "xmpp": "xmpppy",
        "xstatic": "XStatic-jquery-ui",
        "yaml": "PyYAML",
        "z3c": "z3c.zcmlhook",
        "zmq": "pyzmq",
        "zopyx": "zopyx.textindexng3",
    }
