# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...types.paginated_slim_integration_auth_config_read_list import PaginatedSlimIntegrationAuthConfigReadList


class RawIntegrationAuthConfigsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_integration_auth_configs(
        self,
        *,
        expand: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        integration_name: typing.Optional[str] = None,
        integration_provider: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedSlimIntegrationAuthConfigReadList]:
        """
        List Integration Auth Configs

        Parameters
        ----------
        expand : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The response fields to expand for more information.
            - 'integration_credentials' expands the list of integration credentials that the authenticated entity has access to for the auth config.

        integration_name : typing.Optional[str]

        integration_provider : typing.Optional[str]

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        search : typing.Optional[str]
            A search term.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedSlimIntegrationAuthConfigReadList]

        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/integration-auth-configs",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "expand": expand,
                "integration_name": integration_name,
                "integration_provider": integration_provider,
                "limit": limit,
                "offset": offset,
                "ordering": ordering,
                "search": search,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedSlimIntegrationAuthConfigReadList,
                    parse_obj_as(
                        type_=PaginatedSlimIntegrationAuthConfigReadList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawIntegrationAuthConfigsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_integration_auth_configs(
        self,
        *,
        expand: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        integration_name: typing.Optional[str] = None,
        integration_provider: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedSlimIntegrationAuthConfigReadList]:
        """
        List Integration Auth Configs

        Parameters
        ----------
        expand : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The response fields to expand for more information.
            - 'integration_credentials' expands the list of integration credentials that the authenticated entity has access to for the auth config.

        integration_name : typing.Optional[str]

        integration_provider : typing.Optional[str]

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        search : typing.Optional[str]
            A search term.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedSlimIntegrationAuthConfigReadList]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/integration-auth-configs",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "expand": expand,
                "integration_name": integration_name,
                "integration_provider": integration_provider,
                "limit": limit,
                "offset": offset,
                "ordering": ordering,
                "search": search,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedSlimIntegrationAuthConfigReadList,
                    parse_obj_as(
                        type_=PaginatedSlimIntegrationAuthConfigReadList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
