# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.named_test_case_variable_value_request import NamedTestCaseVariableValueRequest
from ...types.paginated_test_suite_test_case_list import PaginatedTestSuiteTestCaseList
from ...types.test_suite_test_case import TestSuiteTestCase
from ...types.test_suite_test_case_bulk_operation_request import TestSuiteTestCaseBulkOperationRequest
from ...types.test_suite_test_case_bulk_result import TestSuiteTestCaseBulkResult
from .raw_client import AsyncRawTestSuitesClient, RawTestSuitesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TestSuitesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTestSuitesClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawTestSuitesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTestSuitesClient
        """
        return self._raw_client

    def list_test_suite_test_cases(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedTestSuiteTestCaseList:
        """
        List the Test Cases associated with a Test Suite

        Parameters
        ----------
        id : str
            Either the Test Suites' ID or its unique name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedTestSuiteTestCaseList


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.test_suites.list_test_suite_test_cases(
            id="id",
        )
        """
        _response = self._raw_client.list_test_suite_test_cases(
            id, limit=limit, offset=offset, request_options=request_options
        )
        return _response.data

    def upsert_test_suite_test_case(
        self,
        id_: str,
        *,
        input_values: typing.Sequence[NamedTestCaseVariableValueRequest],
        evaluation_values: typing.Sequence[NamedTestCaseVariableValueRequest],
        id: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        label: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TestSuiteTestCase:
        """
        Upserts a new test case for a test suite, keying off of the optionally provided test case id.

        If an id is provided and has a match, the test case will be updated. If no id is provided or no match
        is found, a new test case will be appended to the end.

        Note that a full replacement of the test case is performed, so any fields not provided will be removed
        or overwritten with default values.

        Parameters
        ----------
        id_ : str
            Either the Test Suites' ID or its unique name

        input_values : typing.Sequence[NamedTestCaseVariableValueRequest]
            Values for each of the Test Case's input variables

        evaluation_values : typing.Sequence[NamedTestCaseVariableValueRequest]
            Values for each of the Test Case's evaluation variables

        id : typing.Optional[str]
            The Vellum-generated ID of an existing Test Case whose data you'd like to replace. If specified and no Test Case exists with this ID, a 404 will be returned.

        external_id : typing.Optional[str]
            An ID external to Vellum that uniquely identifies the Test Case that you'd like to create/update. If there's a match on a Test Case that was previously created with the same external_id, it will be updated. Otherwise, a new Test Case will be created with this value as its external_id. If no external_id is specified, then a new Test Case will always be created.

        label : typing.Optional[str]
            A human-readable label used to convey the intention of this Test Case

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TestSuiteTestCase


        Examples
        --------
        from vellum import NamedTestCaseStringVariableValueRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.test_suites.upsert_test_suite_test_case(
            id_="id",
            input_values=[
                NamedTestCaseStringVariableValueRequest(
                    name="x",
                ),
                NamedTestCaseStringVariableValueRequest(
                    name="x",
                ),
            ],
            evaluation_values=[
                NamedTestCaseStringVariableValueRequest(
                    name="x",
                ),
                NamedTestCaseStringVariableValueRequest(
                    name="x",
                ),
            ],
        )
        """
        _response = self._raw_client.upsert_test_suite_test_case(
            id_,
            input_values=input_values,
            evaluation_values=evaluation_values,
            id=id,
            external_id=external_id,
            label=label,
            request_options=request_options,
        )
        return _response.data

    def test_suite_test_cases_bulk(
        self,
        id: str,
        *,
        request: typing.Sequence[TestSuiteTestCaseBulkOperationRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[typing.List[TestSuiteTestCaseBulkResult]]:
        """
        Created, replace, and delete Test Cases within the specified Test Suite in bulk

        Parameters
        ----------
        id : str
            Either the Test Suites' ID or its unique name

        request : typing.Sequence[TestSuiteTestCaseBulkOperationRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[typing.List[TestSuiteTestCaseBulkResult]]


        Examples
        --------
        from vellum import (
            CreateTestSuiteTestCaseRequest,
            NamedTestCaseStringVariableValueRequest,
            TestSuiteTestCaseCreateBulkOperationRequest,
            Vellum,
        )

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        response = client.test_suites.test_suite_test_cases_bulk(
            id="id",
            request=[
                TestSuiteTestCaseCreateBulkOperationRequest(
                    id="id",
                    data=CreateTestSuiteTestCaseRequest(
                        input_values=[
                            NamedTestCaseStringVariableValueRequest(
                                name="x",
                            ),
                            NamedTestCaseStringVariableValueRequest(
                                name="x",
                            ),
                        ],
                        evaluation_values=[
                            NamedTestCaseStringVariableValueRequest(
                                name="x",
                            ),
                            NamedTestCaseStringVariableValueRequest(
                                name="x",
                            ),
                        ],
                    ),
                ),
                TestSuiteTestCaseCreateBulkOperationRequest(
                    id="id",
                    data=CreateTestSuiteTestCaseRequest(
                        input_values=[
                            NamedTestCaseStringVariableValueRequest(
                                name="x",
                            ),
                            NamedTestCaseStringVariableValueRequest(
                                name="x",
                            ),
                        ],
                        evaluation_values=[
                            NamedTestCaseStringVariableValueRequest(
                                name="x",
                            ),
                            NamedTestCaseStringVariableValueRequest(
                                name="x",
                            ),
                        ],
                    ),
                ),
            ],
        )
        for chunk in response:
            yield chunk
        """
        with self._raw_client.test_suite_test_cases_bulk(id, request=request, request_options=request_options) as r:
            yield from r.data

    def delete_test_suite_test_case(
        self, id: str, test_case_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes an existing test case for a test suite, keying off of the test case id.

        Parameters
        ----------
        id : str
            Either the Test Suites' ID or its unique name

        test_case_id : str
            An id identifying the test case that you'd like to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.test_suites.delete_test_suite_test_case(
            id="id",
            test_case_id="test_case_id",
        )
        """
        _response = self._raw_client.delete_test_suite_test_case(id, test_case_id, request_options=request_options)
        return _response.data


class AsyncTestSuitesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTestSuitesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTestSuitesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTestSuitesClient
        """
        return self._raw_client

    async def list_test_suite_test_cases(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedTestSuiteTestCaseList:
        """
        List the Test Cases associated with a Test Suite

        Parameters
        ----------
        id : str
            Either the Test Suites' ID or its unique name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedTestSuiteTestCaseList


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.test_suites.list_test_suite_test_cases(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_test_suite_test_cases(
            id, limit=limit, offset=offset, request_options=request_options
        )
        return _response.data

    async def upsert_test_suite_test_case(
        self,
        id_: str,
        *,
        input_values: typing.Sequence[NamedTestCaseVariableValueRequest],
        evaluation_values: typing.Sequence[NamedTestCaseVariableValueRequest],
        id: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        label: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TestSuiteTestCase:
        """
        Upserts a new test case for a test suite, keying off of the optionally provided test case id.

        If an id is provided and has a match, the test case will be updated. If no id is provided or no match
        is found, a new test case will be appended to the end.

        Note that a full replacement of the test case is performed, so any fields not provided will be removed
        or overwritten with default values.

        Parameters
        ----------
        id_ : str
            Either the Test Suites' ID or its unique name

        input_values : typing.Sequence[NamedTestCaseVariableValueRequest]
            Values for each of the Test Case's input variables

        evaluation_values : typing.Sequence[NamedTestCaseVariableValueRequest]
            Values for each of the Test Case's evaluation variables

        id : typing.Optional[str]
            The Vellum-generated ID of an existing Test Case whose data you'd like to replace. If specified and no Test Case exists with this ID, a 404 will be returned.

        external_id : typing.Optional[str]
            An ID external to Vellum that uniquely identifies the Test Case that you'd like to create/update. If there's a match on a Test Case that was previously created with the same external_id, it will be updated. Otherwise, a new Test Case will be created with this value as its external_id. If no external_id is specified, then a new Test Case will always be created.

        label : typing.Optional[str]
            A human-readable label used to convey the intention of this Test Case

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TestSuiteTestCase


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, NamedTestCaseStringVariableValueRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.test_suites.upsert_test_suite_test_case(
                id_="id",
                input_values=[
                    NamedTestCaseStringVariableValueRequest(
                        name="x",
                    ),
                    NamedTestCaseStringVariableValueRequest(
                        name="x",
                    ),
                ],
                evaluation_values=[
                    NamedTestCaseStringVariableValueRequest(
                        name="x",
                    ),
                    NamedTestCaseStringVariableValueRequest(
                        name="x",
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upsert_test_suite_test_case(
            id_,
            input_values=input_values,
            evaluation_values=evaluation_values,
            id=id,
            external_id=external_id,
            label=label,
            request_options=request_options,
        )
        return _response.data

    async def test_suite_test_cases_bulk(
        self,
        id: str,
        *,
        request: typing.Sequence[TestSuiteTestCaseBulkOperationRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[typing.List[TestSuiteTestCaseBulkResult]]:
        """
        Created, replace, and delete Test Cases within the specified Test Suite in bulk

        Parameters
        ----------
        id : str
            Either the Test Suites' ID or its unique name

        request : typing.Sequence[TestSuiteTestCaseBulkOperationRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[typing.List[TestSuiteTestCaseBulkResult]]


        Examples
        --------
        import asyncio

        from vellum import (
            AsyncVellum,
            CreateTestSuiteTestCaseRequest,
            NamedTestCaseStringVariableValueRequest,
            TestSuiteTestCaseCreateBulkOperationRequest,
        )

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.test_suites.test_suite_test_cases_bulk(
                id="id",
                request=[
                    TestSuiteTestCaseCreateBulkOperationRequest(
                        id="id",
                        data=CreateTestSuiteTestCaseRequest(
                            input_values=[
                                NamedTestCaseStringVariableValueRequest(
                                    name="x",
                                ),
                                NamedTestCaseStringVariableValueRequest(
                                    name="x",
                                ),
                            ],
                            evaluation_values=[
                                NamedTestCaseStringVariableValueRequest(
                                    name="x",
                                ),
                                NamedTestCaseStringVariableValueRequest(
                                    name="x",
                                ),
                            ],
                        ),
                    ),
                    TestSuiteTestCaseCreateBulkOperationRequest(
                        id="id",
                        data=CreateTestSuiteTestCaseRequest(
                            input_values=[
                                NamedTestCaseStringVariableValueRequest(
                                    name="x",
                                ),
                                NamedTestCaseStringVariableValueRequest(
                                    name="x",
                                ),
                            ],
                            evaluation_values=[
                                NamedTestCaseStringVariableValueRequest(
                                    name="x",
                                ),
                                NamedTestCaseStringVariableValueRequest(
                                    name="x",
                                ),
                            ],
                        ),
                    ),
                ],
            )
            async for chunk in response:
                yield chunk


        asyncio.run(main())
        """
        async with self._raw_client.test_suite_test_cases_bulk(
            id, request=request, request_options=request_options
        ) as r:
            async for _chunk in r.data:
                yield _chunk

    async def delete_test_suite_test_case(
        self, id: str, test_case_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes an existing test case for a test suite, keying off of the test case id.

        Parameters
        ----------
        id : str
            Either the Test Suites' ID or its unique name

        test_case_id : str
            An id identifying the test case that you'd like to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.test_suites.delete_test_suite_test_case(
                id="id",
                test_case_id="test_case_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_test_suite_test_case(
            id, test_case_id, request_options=request_options
        )
        return _response.data
