# This file was auto-generated by Fern from our API Definition.

import typing

from ... import core
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.uploaded_file_read import UploadedFileRead
from .raw_client import AsyncRawUploadedFilesClient, RawUploadedFilesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UploadedFilesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUploadedFilesClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawUploadedFilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUploadedFilesClient
        """
        return self._raw_client

    def create(self, *, file: core.File, request_options: typing.Optional[RequestOptions] = None) -> UploadedFileRead:
        """
        Upload a file to be used in the Workspace

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadedFileRead

        """
        _response = self._raw_client.create(file=file, request_options=request_options)
        return _response.data

    def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> UploadedFileRead:
        """
        Retrieve a previously uploaded file by its ID

        Parameters
        ----------
        id : str
            A UUID string identifying this uploaded file.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadedFileRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.uploaded_files.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(id, request_options=request_options)
        return _response.data


class AsyncUploadedFilesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUploadedFilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUploadedFilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUploadedFilesClient
        """
        return self._raw_client

    async def create(
        self, *, file: core.File, request_options: typing.Optional[RequestOptions] = None
    ) -> UploadedFileRead:
        """
        Upload a file to be used in the Workspace

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadedFileRead

        """
        _response = await self._raw_client.create(file=file, request_options=request_options)
        return _response.data

    async def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> UploadedFileRead:
        """
        Retrieve a previously uploaded file by its ID

        Parameters
        ----------
        id : str
            A UUID string identifying this uploaded file.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadedFileRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.uploaded_files.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(id, request_options=request_options)
        return _response.data
