# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .document_document_to_document_index import DocumentDocumentToDocumentIndex
from .document_processing_state import DocumentProcessingState
from .document_status import DocumentStatus


class DocumentRead(UniversalBaseModel):
    id: str
    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique id of this document as it exists in the user's system.
    """

    last_uploaded_at: dt.datetime
    label: str = pydantic.Field()
    """
    A human-readable label for the document. Defaults to the originally uploaded file's file name.
    """

    processing_state: DocumentProcessingState
    status: typing.Optional[DocumentStatus] = pydantic.Field(default=None)
    """
    The current status of the document
    
    * `ACTIVE` - Active
    """

    keywords: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of keywords that'll be associated with the document. Used as part of keyword search.
    """

    original_file_url: typing.Optional[str] = None
    document_to_document_indexes: typing.List[DocumentDocumentToDocumentIndex]
    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    A previously supplied JSON object containing metadata that can be filtered on when searching.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
