# Custom client utilities
# This file is not generated by Fern and can be freely edited

from uuid import UUID
from typing import Optional
from pydantic import SerializationInfo


def convert_input_variable_to_uuid(value: str, info: Optional[SerializationInfo] = None) -> str:
    """Convert input_variable to UUID using executable_id from context."""
    # Check if value is already a valid UUID
    try:
        UUID(value)
        return value  # Already a UUID, return as-is
    except ValueError:
        pass  # Not a UUID, continue with conversion logic

    if info and hasattr(info, "context") and info.context:
        executable_id = info.context.get("executable_id")
        if executable_id:
            from vellum.workflows.utils.uuids import uuid4_from_hash  # avoid circular import

            return str(uuid4_from_hash(f"{executable_id}|{value}"))
    return value
