# Generated by Django 3.2.11 on 2022-01-17 03:13

import uuid

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import djstripe.enums
import djstripe.fields
import djstripe.models.api
import djstripe.models.webhooks

DJSTRIPE_SUBSCRIBER_MODEL: str = getattr(
    settings, "DJSTRIPE_SUBSCRIBER_MODEL", settings.AUTH_USER_MODEL
)  # type: ignore

# Needed here for external apps that have added the DJSTRIPE_SUBSCRIBER_MODEL
# *not* in the '__first__' migration of the app, which results in:
# ValueError: Related model 'DJSTRIPE_SUBSCRIBER_MODEL' cannot be resolved
# Context: https://github.com/dj-stripe/dj-stripe/issues/707
DJSTRIPE_SUBSCRIBER_MODEL_MIGRATION_DEPENDENCY = getattr(
    settings, "DJSTRIPE_SUBSCRIBER_MODEL_MIGRATION_DEPENDENCY", "__first__"
)

DJSTRIPE_SUBSCRIBER_MODEL_DEPENDENCY = migrations.swappable_dependency(
    DJSTRIPE_SUBSCRIBER_MODEL
)

if DJSTRIPE_SUBSCRIBER_MODEL != settings.AUTH_USER_MODEL:
    DJSTRIPE_SUBSCRIBER_MODEL_DEPENDENCY = migrations.migration.SwappableTuple(
        (
            DJSTRIPE_SUBSCRIBER_MODEL.split(".", 1)[0],
            DJSTRIPE_SUBSCRIBER_MODEL_MIGRATION_DEPENDENCY,
        ),
        DJSTRIPE_SUBSCRIBER_MODEL,
    )


class Migration(migrations.Migration):

    initial = True

    dependencies = [DJSTRIPE_SUBSCRIBER_MODEL_DEPENDENCY]

    operations = [
        migrations.CreateModel(
            name="Account",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                ("business_profile", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "business_type",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.BusinessType,
                        max_length=10,
                    ),
                ),
                (
                    "charges_enabled",
                    models.BooleanField(
                        help_text="Whether the account can create live charges"
                    ),
                ),
                (
                    "country",
                    models.CharField(
                        help_text="The country of the account", max_length=2
                    ),
                ),
                ("company", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "default_currency",
                    djstripe.fields.StripeCurrencyCodeField(max_length=3),
                ),
                (
                    "details_submitted",
                    models.BooleanField(
                        help_text="Whether account details have been submitted. Standard accounts cannot receive payouts before this is true."
                    ),
                ),
                (
                    "email",
                    models.CharField(
                        help_text="The primary user's email address.", max_length=255
                    ),
                ),
                ("individual", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "payouts_enabled",
                    models.BooleanField(
                        help_text="Whether Stripe can send payouts to this account",
                        null=True,
                    ),
                ),
                (
                    "product_description",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Internal-only description of the product sold or service provided by the business. It's used by Stripe for risk and underwriting purposes.",
                        max_length=255,
                    ),
                ),
                ("requirements", djstripe.fields.JSONField(blank=True, null=True)),
                ("settings", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.AccountType, max_length=8
                    ),
                ),
                ("tos_acceptance", djstripe.fields.JSONField(blank=True, null=True)),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="Charge",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "amount",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11
                    ),
                ),
                (
                    "amount_refunded",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11
                    ),
                ),
                (
                    "captured",
                    models.BooleanField(
                        default=False,
                        help_text="If the charge was created without capturing, this boolean represents whether or not it is still uncaptured or has since been captured.",
                    ),
                ),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "failure_code",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.ApiErrorCode,
                        max_length=42,
                    ),
                ),
                (
                    "failure_message",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Message to user further explaining reason for charge failure if available.",
                        max_length=5000,
                    ),
                ),
                ("fraud_details", djstripe.fields.JSONField(blank=True, null=True)),
                ("outcome", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "paid",
                    models.BooleanField(
                        default=False,
                        help_text="True if the charge succeeded, or was successfully authorized for later capture, False otherwise.",
                    ),
                ),
                (
                    "payment_method_details",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
                (
                    "receipt_email",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="The email address that the receipt for this charge was sent to.",
                        max_length=800,
                    ),
                ),
                (
                    "receipt_number",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The transaction number that appears on email receipts sent for this charge.",
                        max_length=14,
                    ),
                ),
                (
                    "receipt_url",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="This is the URL to view the receipt for this charge. The receipt is kept up-to-date to the latest state of the charge, including any refunds. If the charge is for an Invoice, the receipt will be stylized as an Invoice receipt.",
                        max_length=5000,
                    ),
                ),
                (
                    "refunded",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not the charge has been fully refunded. If the charge is only partially refunded, this attribute will still be false.",
                    ),
                ),
                ("shipping", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "statement_descriptor",
                    models.CharField(
                        blank=True,
                        help_text="For card charges, use statement_descriptor_suffix instead. Otherwise, you can use this value as the complete description of a charge on your customers' statements. Must contain at least one letter, maximum 22 characters.",
                        max_length=22,
                        null=True,
                    ),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.ChargeStatus, max_length=9
                    ),
                ),
                (
                    "transfer_group",
                    models.CharField(
                        blank=True,
                        help_text="A string that identifies this transaction as part of a group.",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "on_behalf_of",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="charges",
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "amount_captured",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "application",
                    models.CharField(
                        blank=True,
                        help_text="ID of the Connect application that created the charge.",
                        max_length=255,
                    ),
                ),
                (
                    "application_fee_amount",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "billing_details",
                    djstripe.fields.JSONField(null=True),
                ),
                (
                    "calculated_statement_descriptor",
                    models.CharField(
                        default="",
                        help_text="The full statement descriptor that is passed to card networks, and that is displayed on your customers' credit card and bank statements. Allows you to see what the statement descriptor looks like after the static and dynamic portions are combined.",
                        max_length=22,
                    ),
                ),
                (
                    "disputed",
                    models.BooleanField(
                        default=False, help_text="Whether the charge has been disputed."
                    ),
                ),
                (
                    "statement_descriptor_suffix",
                    models.CharField(
                        blank=True,
                        help_text="Provides information about the charge that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that's set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.",
                        max_length=22,
                        null=True,
                    ),
                ),
                (
                    "transfer_data",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="Coupon",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                ("id", djstripe.fields.StripeIdField(max_length=500)),
                (
                    "amount_off",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "currency",
                    djstripe.fields.StripeCurrencyCodeField(
                        blank=True, max_length=3, null=True
                    ),
                ),
                (
                    "duration",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.CouponDuration, max_length=9
                    ),
                ),
                (
                    "duration_in_months",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="If `duration` is `repeating`, the number of months the coupon applies.",
                        null=True,
                    ),
                ),
                (
                    "max_redemptions",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="Maximum number of times this coupon can be redeemed, in total, before it is no longer valid.",
                        null=True,
                    ),
                ),
                (
                    "percent_off",
                    djstripe.fields.StripePercentField(
                        blank=True,
                        decimal_places=2,
                        max_digits=5,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(100),
                        ],
                    ),
                ),
                (
                    "redeem_by",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "times_redeemed",
                    models.PositiveIntegerField(
                        default=0,
                        editable=False,
                        help_text="Number of times this coupon has been applied to a customer.",
                    ),
                ),
                (
                    "name",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Name of the coupon displayed to customers on for instance invoices or receipts.",
                        max_length=5000,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"unique_together": {("id", "livemode")}},
        ),
        migrations.CreateModel(
            name="PaymentMethod",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                ("billing_details", djstripe.fields.JSONField()),
                ("card", djstripe.fields.JSONField(blank=True, null=True)),
                ("card_present", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.PaymentMethodType, max_length=15
                    ),
                ),
                ("alipay", djstripe.fields.JSONField(blank=True, null=True)),
                ("au_becs_debit", djstripe.fields.JSONField(blank=True, null=True)),
                ("bacs_debit", djstripe.fields.JSONField(blank=True, null=True)),
                ("bancontact", djstripe.fields.JSONField(blank=True, null=True)),
                ("eps", djstripe.fields.JSONField(blank=True, null=True)),
                ("fpx", djstripe.fields.JSONField(blank=True, null=True)),
                ("giropay", djstripe.fields.JSONField(blank=True, null=True)),
                ("ideal", djstripe.fields.JSONField(blank=True, null=True)),
                ("interac_present", djstripe.fields.JSONField(blank=True, null=True)),
                ("oxxo", djstripe.fields.JSONField(blank=True, null=True)),
                ("p24", djstripe.fields.JSONField(blank=True, null=True)),
                ("sepa_debit", djstripe.fields.JSONField(blank=True, null=True)),
                ("sofort", djstripe.fields.JSONField(blank=True, null=True)),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="Customer",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "balance",
                    djstripe.fields.StripeQuantumCurrencyAmountField(default=0),
                ),
                (
                    "currency",
                    djstripe.fields.StripeCurrencyCodeField(
                        blank=True, default="", max_length=3
                    ),
                ),
                (
                    "delinquent",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not the latest charge for the customer's latest invoice has failed.",
                    ),
                ),
                (
                    "coupon_start",
                    djstripe.fields.StripeDateTimeField(
                        blank=True, editable=False, null=True
                    ),
                ),
                (
                    "coupon_end",
                    djstripe.fields.StripeDateTimeField(
                        blank=True, editable=False, null=True
                    ),
                ),
                ("email", models.TextField(blank=True, default="", max_length=5000)),
                ("shipping", djstripe.fields.JSONField(blank=True, null=True)),
                ("date_purged", models.DateTimeField(editable=False, null=True)),
                (
                    "coupon",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.coupon",
                    ),
                ),
                (
                    "default_source",
                    djstripe.fields.PaymentMethodForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="customers",
                        to="djstripe.paymentmethod",
                    ),
                ),
                (
                    "subscriber",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="djstripe_customers",
                        to=DJSTRIPE_SUBSCRIBER_MODEL,
                    ),
                ),
                ("address", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "invoice_prefix",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The prefix for the customer used to generate unique invoice numbers.",
                        max_length=255,
                    ),
                ),
                ("invoice_settings", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "name",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="The customer's full name or business name.",
                        max_length=5000,
                    ),
                ),
                (
                    "phone",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="The customer's phone number.",
                        max_length=5000,
                    ),
                ),
                ("preferred_locales", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "tax_exempt",
                    djstripe.fields.StripeEnumField(
                        default="", enum=djstripe.enums.CustomerTaxExempt, max_length=7
                    ),
                ),
                (
                    "default_payment_method",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="djstripe.paymentmethod",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={
                "unique_together": {
                    ("subscriber", "livemode", "djstripe_owner_account")
                }
            },
        ),
        migrations.CreateModel(
            name="Dispute",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                ("amount", djstripe.fields.StripeQuantumCurrencyAmountField()),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                ("evidence", djstripe.fields.JSONField()),
                ("evidence_details", djstripe.fields.JSONField()),
                (
                    "is_charge_refundable",
                    models.BooleanField(
                        help_text="If true, it is still possible to refund the disputed payment. Once the payment has been fully refunded, no further funds will be withdrawn from your Stripe account as a result of this dispute."
                    ),
                ),
                (
                    "reason",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.DisputeReason, max_length=25
                    ),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.DisputeStatus, max_length=22
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "api_version",
                    models.CharField(
                        blank=True,
                        help_text="the API version at which the event data was rendered. Blank for old entries only, all new entries will have this value",
                        max_length=15,
                    ),
                ),
                ("data", djstripe.fields.JSONField()),
                (
                    "request_id",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Information about the request that triggered this event, for traceability purposes. If empty string then this is an old entry without that data. If Null then this is not an old entry, but a Stripe 'automated' event with no associated request.",
                        max_length=50,
                    ),
                ),
                ("idempotency_key", models.TextField(blank=True, default="")),
                (
                    "type",
                    models.CharField(
                        help_text="Stripe's event description code", max_length=250
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="FileUpload",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "filename",
                    models.CharField(
                        help_text="A filename for the file, suitable for saving to a filesystem.",
                        max_length=255,
                    ),
                ),
                (
                    "purpose",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.FilePurpose, max_length=35
                    ),
                ),
                (
                    "size",
                    models.IntegerField(
                        help_text="The size in bytes of the file upload object."
                    ),
                ),
                (
                    "type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.FileType, max_length=4
                    ),
                ),
                (
                    "url",
                    models.CharField(
                        help_text="A read-only URL where the uploaded file can be accessed.",
                        max_length=200,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="DjstripePaymentMethod",
            fields=[
                (
                    "id",
                    models.CharField(max_length=255, primary_key=True, serialize=False),
                ),
                ("type", models.CharField(db_index=True, max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name="Plan",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "active",
                    models.BooleanField(
                        help_text="Whether the plan can be used for new purchases."
                    ),
                ),
                (
                    "aggregate_usage",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.PlanAggregateUsage,
                        max_length=18,
                    ),
                ),
                (
                    "amount",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "amount_decimal",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=12, max_digits=19, null=True
                    ),
                ),
                (
                    "billing_scheme",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.BillingScheme,
                        max_length=8,
                    ),
                ),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "interval",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.PlanInterval, max_length=5
                    ),
                ),
                (
                    "interval_count",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="The number of intervals (specified in the interval property) between each subscription billing.",
                        null=True,
                    ),
                ),
                (
                    "nickname",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="A brief description of the plan, hidden from customers.",
                        max_length=5000,
                    ),
                ),
                ("tiers", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "tiers_mode",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        enum=djstripe.enums.PriceTiersMode,
                        max_length=9,
                        null=True,
                    ),
                ),
                ("transform_usage", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "trial_period_days",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of trial period days granted when subscribing a customer to this plan. Null if the plan has no trial period.",
                        null=True,
                    ),
                ),
                (
                    "usage_type",
                    djstripe.fields.StripeEnumField(
                        default="licensed",
                        enum=djstripe.enums.PriceUsageType,
                        max_length=8,
                    ),
                ),
            ],
            options={"ordering": ["amount"]},
        ),
        migrations.CreateModel(
            name="Product",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.TextField(
                        help_text="The product's name, meant to be displayable to the customer. Applicable to both `service` and `good` types.",
                        max_length=5000,
                    ),
                ),
                (
                    "type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.ProductType, max_length=7
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        help_text="Whether the product is currently available for purchase. Only applicable to products of `type=good`.",
                        null=True,
                    ),
                ),
                ("attributes", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "caption",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="A short one-line description of the product, meant to be displayableto the customer. Only applicable to products of `type=good`.",
                        max_length=5000,
                    ),
                ),
                ("deactivate_on", djstripe.fields.JSONField(blank=True, null=True)),
                ("images", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "package_dimensions",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
                (
                    "shippable",
                    models.BooleanField(
                        blank=True,
                        help_text="Whether this product is a shipped good. Only applicable to products of `type=good`.",
                        null=True,
                    ),
                ),
                (
                    "url",
                    models.CharField(
                        blank=True,
                        help_text="A URL of a publicly-accessible webpage for this product. Only applicable to products of `type=good`.",
                        max_length=799,
                        null=True,
                    ),
                ),
                (
                    "statement_descriptor",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Extra information about a product which will appear on your customer's credit card statement. In the case that multiple products are billed at once, the first statement descriptor will be used. Only available on products of type=`service`.",
                        max_length=22,
                    ),
                ),
                ("unit_label", models.CharField(blank=True, default="", max_length=12)),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="Subscription",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "application_fee_percent",
                    djstripe.fields.StripePercentField(
                        blank=True,
                        decimal_places=2,
                        max_digits=5,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(100.0),
                        ],
                    ),
                ),
                (
                    "collection_method",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.InvoiceCollectionMethod, max_length=20
                    ),
                ),
                (
                    "billing_cycle_anchor",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "cancel_at_period_end",
                    models.BooleanField(
                        default=False,
                        help_text="If the subscription has been canceled with the ``at_period_end`` flag set to true, ``cancel_at_period_end`` on the subscription will be true. You can use this attribute to determine whether a subscription that has a status of active is scheduled to be canceled at the end of the current period.",
                    ),
                ),
                (
                    "canceled_at",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                ("current_period_end", djstripe.fields.StripeDateTimeField()),
                ("current_period_start", djstripe.fields.StripeDateTimeField()),
                (
                    "days_until_due",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of days a customer has to pay invoices generated by this subscription. This value will be `null` for subscriptions where `billing=charge_automatically`.",
                        null=True,
                    ),
                ),
                ("discount", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "ended_at",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "next_pending_invoice_item_invoice",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "pending_invoice_item_interval",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
                ("pending_update", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "quantity",
                    models.IntegerField(
                        blank=True,
                        help_text="The quantity applied to this subscription. This value will be `null` for multi-plan subscriptions",
                        null=True,
                    ),
                ),
                (
                    "start_date",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.SubscriptionStatus, max_length=18
                    ),
                ),
                (
                    "tax_percent",
                    djstripe.fields.StripePercentField(
                        blank=True,
                        decimal_places=2,
                        max_digits=5,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(100.0),
                        ],
                    ),
                ),
                (
                    "trial_end",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "trial_start",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "customer",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subscriptions",
                        to="djstripe.customer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "plan",
                    models.ForeignKey(
                        blank=True,
                        help_text="The plan associated with this subscription. This value will be `null` for multi-plan subscriptions",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subscriptions",
                        to="djstripe.plan",
                    ),
                ),
                (
                    "billing_thresholds",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
                (
                    "cancel_at",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="Transfer",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "amount",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11
                    ),
                ),
                (
                    "amount_reversed",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=2, max_digits=11, null=True
                    ),
                ),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                ("destination", djstripe.fields.StripeIdField(max_length=255)),
                (
                    "destination_payment",
                    djstripe.fields.StripeIdField(
                        blank=True, max_length=255, null=True
                    ),
                ),
                (
                    "reversed",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not the transfer has been fully reversed. If the transfer is only partially reversed, this attribute will still be false.",
                    ),
                ),
                (
                    "source_transaction",
                    djstripe.fields.StripeIdField(max_length=255, null=True),
                ),
                (
                    "source_type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.LegacySourceType, max_length=16
                    ),
                ),
                (
                    "transfer_group",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="A string that identifies this transaction as part of a group.",
                        max_length=255,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="WebhookEventTrigger",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "remote_ip",
                    models.GenericIPAddressField(
                        help_text="IP address of the request client."
                    ),
                ),
                ("headers", djstripe.fields.JSONField()),
                ("body", models.TextField(blank=True)),
                (
                    "valid",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not the webhook event has passed validation",
                    ),
                ),
                (
                    "processed",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not the webhook event has been successfully processed",
                    ),
                ),
                ("exception", models.CharField(blank=True, max_length=128)),
                (
                    "traceback",
                    models.TextField(
                        blank=True,
                        help_text="Traceback if an exception was thrown during processing",
                    ),
                ),
                (
                    "djstripe_version",
                    models.CharField(
                        default=djstripe.models.webhooks._get_version,
                        help_text="The version of dj-stripe when the webhook was received",
                        max_length=32,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "event",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.event",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="paymentmethod",
            name="customer",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="payment_methods",
                to="djstripe.customer",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="plan",
            name="product",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="djstripe.product",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.CreateModel(
            name="Invoice",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "amount_due",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11
                    ),
                ),
                (
                    "amount_paid",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "amount_remaining",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "application_fee_amount",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "attempt_count",
                    models.IntegerField(
                        help_text="Number of payment attempts made for this invoice, from the perspective of the payment retry schedule. Any payment attempt counts as the first attempt, and subsequently only automatic retries increment the attempt count. In other words, manual payment attempts after the first attempt do not affect the retry schedule."
                    ),
                ),
                (
                    "attempted",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not an attempt has been made to pay the invoice. An invoice is not attempted until 1 hour after the ``invoice.created`` webhook, for example, so you might not want to display that invoice as unpaid to your users.",
                    ),
                ),
                (
                    "collection_method",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.InvoiceCollectionMethod,
                        max_length=20,
                        null=True,
                    ),
                ),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "due_date",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "ending_balance",
                    djstripe.fields.StripeQuantumCurrencyAmountField(null=True),
                ),
                (
                    "hosted_invoice_url",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="The URL for the hosted invoice page, which allows customers to view and pay an invoice. If the invoice has not been frozen yet, this will be null.",
                        max_length=799,
                    ),
                ),
                (
                    "invoice_pdf",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="The link to download the PDF for the invoice. If the invoice has not been frozen yet, this will be null.",
                        max_length=799,
                    ),
                ),
                (
                    "next_payment_attempt",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "number",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="A unique, identifying string that appears on emails sent to the customer for this invoice. This starts with the customer's unique invoice_prefix if it is specified.",
                        max_length=64,
                    ),
                ),
                (
                    "paid",
                    models.BooleanField(
                        default=False,
                        help_text="Whether payment was successfully collected for this invoice. An invoice can be paid (most commonly) with a charge or with credit from the customer's account balance.",
                    ),
                ),
                ("period_end", djstripe.fields.StripeDateTimeField()),
                ("period_start", djstripe.fields.StripeDateTimeField()),
                (
                    "receipt_number",
                    models.CharField(
                        blank=True,
                        help_text="This is the transaction number that appears on email receipts sent for this invoice.",
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "starting_balance",
                    djstripe.fields.StripeQuantumCurrencyAmountField(),
                ),
                (
                    "statement_descriptor",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="An arbitrary string to be displayed on your customer's credit card statement. The statement description may not include <>\"' characters, and will appear on your customer's statement in capital letters. Non-ASCII characters are automatically stripped. While most banks display this information consistently, some may display it incorrectly or not at all.",
                        max_length=22,
                    ),
                ),
                (
                    "subscription_proration_date",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "subtotal",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11
                    ),
                ),
                (
                    "tax",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "tax_percent",
                    djstripe.fields.StripePercentField(
                        blank=True,
                        decimal_places=2,
                        max_digits=5,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(100.0),
                        ],
                    ),
                ),
                (
                    "total",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2,
                        max_digits=11,
                        verbose_name="Total (as decimal) after discount.",
                    ),
                ),
                (
                    "webhooks_delivered_at",
                    djstripe.fields.StripeDateTimeField(null=True),
                ),
                (
                    "charge",
                    models.OneToOneField(
                        help_text="The latest charge generated for this invoice, if any.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="latest_invoice",
                        to="djstripe.charge",
                    ),
                ),
                (
                    "customer",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="invoices",
                        to="djstripe.customer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "subscription",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="invoices",
                        to="djstripe.subscription",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "auto_advance",
                    models.BooleanField(
                        help_text="Controls whether Stripe will perform automatic collection of the invoice. When false, the invoice's state will not automatically advance without an explicit action.",
                        null=True,
                    ),
                ),
                (
                    "status_transitions",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
                (
                    "account_country",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The country of the business associated with this invoice, most often the business creating the invoice.",
                        max_length=2,
                    ),
                ),
                (
                    "account_name",
                    models.TextField(
                        blank=True,
                        help_text="The public name of the business associated with this invoice, most often the business creating the invoice.",
                        max_length=5000,
                    ),
                ),
                (
                    "billing_reason",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.InvoiceBillingReason,
                        max_length=22,
                    ),
                ),
                (
                    "customer_address",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
                (
                    "customer_email",
                    models.TextField(
                        blank=True,
                        help_text="The customer's email. Until the invoice is finalized, this field will equal customer.email. Once the invoice is finalized, this field will no longer be updated.",
                        max_length=5000,
                    ),
                ),
                (
                    "customer_name",
                    models.TextField(
                        blank=True,
                        help_text="The customer's name. Until the invoice is finalized, this field will equal customer.name. Once the invoice is finalized, this field will no longer be updated.",
                        max_length=5000,
                    ),
                ),
                (
                    "customer_phone",
                    models.TextField(
                        blank=True,
                        help_text="The customer's phone number. Until the invoice is finalized, this field will equal customer.phone. Once the invoice is finalized, this field will no longer be updated.",
                        max_length=5000,
                    ),
                ),
                (
                    "customer_shipping",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
                (
                    "customer_tax_exempt",
                    djstripe.fields.StripeEnumField(
                        default="", enum=djstripe.enums.CustomerTaxExempt, max_length=7
                    ),
                ),
                (
                    "footer",
                    models.TextField(
                        blank=True,
                        help_text="Footer displayed on the invoice.",
                        max_length=5000,
                    ),
                ),
                (
                    "post_payment_credit_notes_amount",
                    djstripe.fields.StripeQuantumCurrencyAmountField(
                        blank=True, null=True
                    ),
                ),
                (
                    "pre_payment_credit_notes_amount",
                    djstripe.fields.StripeQuantumCurrencyAmountField(
                        blank=True, null=True
                    ),
                ),
                (
                    "threshold_reason",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.InvoiceStatus,
                        max_length=13,
                    ),
                ),
                (
                    "discount",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
            ],
            options={"ordering": ["-created"]},
        ),
        migrations.CreateModel(
            name="IdempotencyKey",
            fields=[
                (
                    "uuid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("action", models.CharField(max_length=100)),
                (
                    "livemode",
                    models.BooleanField(
                        help_text="Whether the key was used in live or test mode."
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
            options={"unique_together": {("action", "livemode")}},
        ),
        migrations.AddField(
            model_name="charge",
            name="customer",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="charges",
                to="djstripe.customer",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="charge",
            name="dispute",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="charges",
                to="djstripe.dispute",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="charge",
            name="invoice",
            field=djstripe.fields.StripeForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="charges",
                to="djstripe.invoice",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="charge",
            name="source",
            field=djstripe.fields.PaymentMethodForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="charges",
                to="djstripe.paymentmethod",
            ),
        ),
        migrations.AddField(
            model_name="charge",
            name="transfer",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="djstripe.transfer",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.CreateModel(
            name="BankAccount",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "account_holder_name",
                    models.TextField(
                        blank=True,
                        help_text="The name of the person or business that owns the bank account.",
                        max_length=5000,
                    ),
                ),
                (
                    "account_holder_type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.BankAccountHolderType, max_length=10
                    ),
                ),
                (
                    "bank_name",
                    models.CharField(
                        help_text="Name of the bank associated with the routing number (e.g., `WELLS FARGO`).",
                        max_length=255,
                    ),
                ),
                (
                    "country",
                    models.CharField(
                        help_text="Two-letter ISO code representing the country the bank account is located in.",
                        max_length=2,
                    ),
                ),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "default_for_currency",
                    models.BooleanField(
                        help_text="Whether this external account is the default account for its currency.",
                        null=True,
                    ),
                ),
                (
                    "fingerprint",
                    models.CharField(
                        help_text="Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.",
                        max_length=16,
                    ),
                ),
                ("last4", models.CharField(max_length=4)),
                (
                    "routing_number",
                    models.CharField(
                        help_text="The routing transit number for the bank account.",
                        max_length=255,
                    ),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.BankAccountStatus, max_length=19
                    ),
                ),
                (
                    "account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="bank_account",
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "customer",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="bank_account",
                        to="djstripe.customer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="BalanceTransaction",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                ("amount", djstripe.fields.StripeQuantumCurrencyAmountField()),
                ("available_on", djstripe.fields.StripeDateTimeField()),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "exchange_rate",
                    models.DecimalField(decimal_places=6, max_digits=8, null=True),
                ),
                ("fee", djstripe.fields.StripeQuantumCurrencyAmountField()),
                ("fee_details", djstripe.fields.JSONField()),
                ("net", djstripe.fields.StripeQuantumCurrencyAmountField()),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.BalanceTransactionStatus, max_length=9
                    ),
                ),
                (
                    "type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.BalanceTransactionType, max_length=29
                    ),
                ),
                (
                    "reporting_category",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.BalanceTransactionReportingCategory,
                        max_length=29,
                    ),
                ),
                ("source", djstripe.fields.StripeIdField(max_length=255)),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="ApplicationFee",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                ("amount", djstripe.fields.StripeQuantumCurrencyAmountField()),
                ("amount_refunded", djstripe.fields.StripeQuantumCurrencyAmountField()),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "refunded",
                    models.BooleanField(
                        help_text="Whether the fee has been fully refunded. If the fee is only partially refunded, this attribute will still be false."
                    ),
                ),
                (
                    "balance_transaction",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.balancetransaction",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "charge",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.charge",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.AddField(
            model_name="charge",
            name="balance_transaction",
            field=djstripe.fields.StripeForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="djstripe.balancetransaction",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="transfer",
            name="balance_transaction",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="djstripe.balancetransaction",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.CreateModel(
            name="SetupIntent",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "application",
                    models.CharField(
                        blank=True,
                        help_text="ID of the Connect application that created the SetupIntent.",
                        max_length=255,
                    ),
                ),
                (
                    "cancellation_reason",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        enum=djstripe.enums.SetupIntentCancellationReason,
                        max_length=21,
                    ),
                ),
                (
                    "client_secret",
                    models.TextField(
                        blank=True,
                        help_text="The client secret of this SetupIntent. Used for client-side retrieval using a publishable key.",
                        max_length=5000,
                    ),
                ),
                ("last_setup_error", djstripe.fields.JSONField(blank=True, null=True)),
                ("next_action", djstripe.fields.JSONField(blank=True, null=True)),
                ("payment_method_types", djstripe.fields.JSONField()),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.SetupIntentStatus, max_length=23
                    ),
                ),
                (
                    "usage",
                    djstripe.fields.StripeEnumField(
                        default="off_session",
                        enum=djstripe.enums.IntentUsage,
                        max_length=11,
                    ),
                ),
                (
                    "customer",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.customer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "on_behalf_of",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="setup_intents",
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "payment_method",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.paymentmethod",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="PaymentIntent",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                ("amount", djstripe.fields.StripeQuantumCurrencyAmountField()),
                (
                    "amount_capturable",
                    djstripe.fields.StripeQuantumCurrencyAmountField(),
                ),
                ("amount_received", djstripe.fields.StripeQuantumCurrencyAmountField()),
                (
                    "canceled_at",
                    djstripe.fields.StripeDateTimeField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "cancellation_reason",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        enum=djstripe.enums.PaymentIntentCancellationReason,
                        max_length=21,
                    ),
                ),
                (
                    "capture_method",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.CaptureMethod, max_length=9
                    ),
                ),
                (
                    "client_secret",
                    models.TextField(
                        help_text="The client secret of this PaymentIntent. Used for client-side retrieval using a publishable key.",
                        max_length=5000,
                    ),
                ),
                (
                    "confirmation_method",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.ConfirmationMethod, max_length=9
                    ),
                ),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="An arbitrary string attached to the object. Often useful for displaying to users.",
                        max_length=1000,
                    ),
                ),
                (
                    "last_payment_error",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
                ("next_action", djstripe.fields.JSONField(blank=True, null=True)),
                ("payment_method_types", djstripe.fields.JSONField()),
                (
                    "receipt_email",
                    models.CharField(
                        blank=True,
                        help_text="Email address that the receipt for the resulting payment will be sent to.",
                        max_length=255,
                    ),
                ),
                (
                    "setup_future_usage",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        enum=djstripe.enums.IntentUsage,
                        max_length=11,
                        null=True,
                    ),
                ),
                ("shipping", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "statement_descriptor",
                    models.CharField(
                        blank=True,
                        help_text="For non-card charges, you can use this value as the complete description that appears on your customers' statements. Must contain at least one letter, maximum 22 characters.",
                        max_length=22,
                    ),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.PaymentIntentStatus, max_length=23
                    ),
                ),
                ("transfer_data", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "transfer_group",
                    models.CharField(
                        blank=True,
                        help_text="A string that identifies the resulting payment as part of a group. See the PaymentIntents Connect usage guide for details.",
                        max_length=255,
                    ),
                ),
                (
                    "customer",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.customer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "on_behalf_of",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="payment_intents",
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "payment_method",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.paymentmethod",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.AddField(
            model_name="charge",
            name="payment_intent",
            field=djstripe.fields.StripeForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="charges",
                to="djstripe.paymentintent",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="invoice",
            name="payment_intent",
            field=models.OneToOneField(
                help_text="The PaymentIntent associated with this invoice. The PaymentIntent is generated when the invoice is finalized, and can then be used to pay the invoice.Note that voiding an invoice will cancel the PaymentIntent",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="djstripe.paymentintent",
            ),
        ),
        migrations.AddField(
            model_name="subscription",
            name="pending_setup_intent",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="setup_intents",
                to="djstripe.setupintent",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="charge",
            name="payment_method",
            field=djstripe.fields.StripeForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="charges",
                to="djstripe.paymentmethod",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="invoice",
            name="default_payment_method",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="djstripe.paymentmethod",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.CreateModel(
            name="UpcomingInvoice",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "account_country",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The country of the business associated with this invoice, most often the business creating the invoice.",
                        max_length=2,
                    ),
                ),
                (
                    "account_name",
                    models.TextField(
                        blank=True,
                        help_text="The public name of the business associated with this invoice, most often the business creating the invoice.",
                        max_length=5000,
                    ),
                ),
                (
                    "amount_due",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11
                    ),
                ),
                (
                    "amount_paid",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "amount_remaining",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "application_fee_amount",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "attempt_count",
                    models.IntegerField(
                        help_text="Number of payment attempts made for this invoice, from the perspective of the payment retry schedule. Any payment attempt counts as the first attempt, and subsequently only automatic retries increment the attempt count. In other words, manual payment attempts after the first attempt do not affect the retry schedule."
                    ),
                ),
                (
                    "attempted",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not an attempt has been made to pay the invoice. An invoice is not attempted until 1 hour after the ``invoice.created`` webhook, for example, so you might not want to display that invoice as unpaid to your users.",
                    ),
                ),
                (
                    "auto_advance",
                    models.BooleanField(
                        help_text="Controls whether Stripe will perform automatic collection of the invoice. When false, the invoice's state will not automatically advance without an explicit action.",
                        null=True,
                    ),
                ),
                (
                    "billing_reason",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.InvoiceBillingReason,
                        max_length=22,
                    ),
                ),
                (
                    "collection_method",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.InvoiceCollectionMethod,
                        max_length=20,
                        null=True,
                    ),
                ),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                ("customer_address", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "customer_email",
                    models.TextField(
                        blank=True,
                        help_text="The customer's email. Until the invoice is finalized, this field will equal customer.email. Once the invoice is finalized, this field will no longer be updated.",
                        max_length=5000,
                    ),
                ),
                (
                    "customer_name",
                    models.TextField(
                        blank=True,
                        help_text="The customer's name. Until the invoice is finalized, this field will equal customer.name. Once the invoice is finalized, this field will no longer be updated.",
                        max_length=5000,
                    ),
                ),
                (
                    "customer_phone",
                    models.TextField(
                        blank=True,
                        help_text="The customer's phone number. Until the invoice is finalized, this field will equal customer.phone. Once the invoice is finalized, this field will no longer be updated.",
                        max_length=5000,
                    ),
                ),
                ("customer_shipping", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "customer_tax_exempt",
                    djstripe.fields.StripeEnumField(
                        default="", enum=djstripe.enums.CustomerTaxExempt, max_length=7
                    ),
                ),
                (
                    "due_date",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "ending_balance",
                    djstripe.fields.StripeQuantumCurrencyAmountField(null=True),
                ),
                (
                    "footer",
                    models.TextField(
                        blank=True,
                        help_text="Footer displayed on the invoice.",
                        max_length=5000,
                    ),
                ),
                (
                    "hosted_invoice_url",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="The URL for the hosted invoice page, which allows customers to view and pay an invoice. If the invoice has not been frozen yet, this will be null.",
                        max_length=799,
                    ),
                ),
                (
                    "invoice_pdf",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="The link to download the PDF for the invoice. If the invoice has not been frozen yet, this will be null.",
                        max_length=799,
                    ),
                ),
                (
                    "next_payment_attempt",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "number",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="A unique, identifying string that appears on emails sent to the customer for this invoice. This starts with the customer's unique invoice_prefix if it is specified.",
                        max_length=64,
                    ),
                ),
                (
                    "paid",
                    models.BooleanField(
                        default=False,
                        help_text="Whether payment was successfully collected for this invoice. An invoice can be paid (most commonly) with a charge or with credit from the customer's account balance.",
                    ),
                ),
                ("period_end", djstripe.fields.StripeDateTimeField()),
                ("period_start", djstripe.fields.StripeDateTimeField()),
                (
                    "post_payment_credit_notes_amount",
                    djstripe.fields.StripeQuantumCurrencyAmountField(
                        blank=True, null=True
                    ),
                ),
                (
                    "pre_payment_credit_notes_amount",
                    djstripe.fields.StripeQuantumCurrencyAmountField(
                        blank=True, null=True
                    ),
                ),
                (
                    "receipt_number",
                    models.CharField(
                        blank=True,
                        help_text="This is the transaction number that appears on email receipts sent for this invoice.",
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "starting_balance",
                    djstripe.fields.StripeQuantumCurrencyAmountField(),
                ),
                (
                    "statement_descriptor",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="An arbitrary string to be displayed on your customer's credit card statement. The statement description may not include <>\"' characters, and will appear on your customer's statement in capital letters. Non-ASCII characters are automatically stripped. While most banks display this information consistently, some may display it incorrectly or not at all.",
                        max_length=22,
                    ),
                ),
                (
                    "status_transitions",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
                (
                    "subscription_proration_date",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "subtotal",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11
                    ),
                ),
                (
                    "tax",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "tax_percent",
                    djstripe.fields.StripePercentField(
                        blank=True,
                        decimal_places=2,
                        max_digits=5,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(100),
                        ],
                    ),
                ),
                ("threshold_reason", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "total",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2,
                        max_digits=11,
                        verbose_name="Total (as decimal) after discount.",
                    ),
                ),
                (
                    "webhooks_delivered_at",
                    djstripe.fields.StripeDateTimeField(null=True),
                ),
                (
                    "charge",
                    models.OneToOneField(
                        help_text="The latest charge generated for this invoice, if any.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="latest_upcominginvoice",
                        to="djstripe.charge",
                    ),
                ),
                (
                    "customer",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="upcominginvoices",
                        to="djstripe.customer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "default_payment_method",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="djstripe.paymentmethod",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "payment_intent",
                    models.OneToOneField(
                        help_text="The PaymentIntent associated with this invoice. The PaymentIntent is generated when the invoice is finalized, and can then be used to pay the invoice.Note that voiding an invoice will cancel the PaymentIntent",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.paymentintent",
                    ),
                ),
                (
                    "subscription",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="upcominginvoices",
                        to="djstripe.subscription",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.InvoiceStatus,
                        max_length=13,
                    ),
                ),
                (
                    "default_source",
                    djstripe.fields.PaymentMethodForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="upcoming_invoices",
                        to="djstripe.djstripepaymentmethod",
                    ),
                ),
                ("discount", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "ordering": ["-created"]},
        ),
        migrations.CreateModel(
            name="TaxRate",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Defaults to true. When set to false, this tax rate cannot be applied to objects in the API, but will still be applied to subscriptions and invoices that already have it set.",
                    ),
                ),
                (
                    "display_name",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The display name of the tax rates as it will appear to your customer on their receipt email, PDF, and the hosted invoice page.",
                        max_length=50,
                    ),
                ),
                (
                    "inclusive",
                    models.BooleanField(
                        help_text="This specifies if the tax rate is inclusive or exclusive."
                    ),
                ),
                (
                    "jurisdiction",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The jurisdiction for the tax rate.",
                        max_length=50,
                    ),
                ),
                (
                    "percentage",
                    djstripe.fields.StripePercentField(
                        decimal_places=2,
                        max_digits=5,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(100),
                        ],
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.AddField(
            model_name="invoice",
            name="default_tax_rates",
            field=models.ManyToManyField(
                blank=True,
                db_table="djstripe_djstripeinvoicedefaulttaxrate",
                help_text="The tax rates applied to this invoice, if any.",
                related_name="_invoice_default_tax_rates_+",
                to="djstripe.TaxRate",
            ),
        ),
        migrations.AddField(
            model_name="subscription",
            name="default_tax_rates",
            field=models.ManyToManyField(
                blank=True,
                db_table="djstripe_djstripesubscriptiondefaulttaxrate",
                help_text="The tax rates that will apply to any subscription item that does not have tax_rates set. Invoices created will have their default_tax_rates populated from the subscription.",
                related_name="_subscription_default_tax_rates_+",
                to="djstripe.TaxRate",
            ),
        ),
        migrations.CreateModel(
            name="DjstripeUpcomingInvoiceTotalTaxAmount",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", djstripe.fields.StripeQuantumCurrencyAmountField()),
                (
                    "inclusive",
                    models.BooleanField(
                        help_text="Whether this tax amount is inclusive or exclusive."
                    ),
                ),
                (
                    "invoice",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="djstripe.upcominginvoice",
                    ),
                ),
                (
                    "tax_rate",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.taxrate",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"unique_together": {("invoice", "tax_rate")}},
        ),
        migrations.CreateModel(
            name="DjstripeInvoiceTotalTaxAmount",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", djstripe.fields.StripeQuantumCurrencyAmountField()),
                (
                    "inclusive",
                    models.BooleanField(
                        help_text="Whether this tax amount is inclusive or exclusive."
                    ),
                ),
                (
                    "invoice",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="total_tax_amounts",
                        to="djstripe.invoice",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "tax_rate",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.taxrate",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"unique_together": {("invoice", "tax_rate")}},
        ),
        migrations.AddField(
            model_name="subscription",
            name="default_payment_method",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="djstripe.paymentmethod",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="invoice",
            name="default_source",
            field=djstripe.fields.PaymentMethodForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="invoices",
                to="djstripe.djstripepaymentmethod",
            ),
        ),
        migrations.AddField(
            model_name="subscription",
            name="default_source",
            field=djstripe.fields.PaymentMethodForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="subscriptions",
                to="djstripe.djstripepaymentmethod",
            ),
        ),
        migrations.CreateModel(
            name="ApplicationFeeRefund",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                ("amount", djstripe.fields.StripeQuantumCurrencyAmountField()),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "balance_transaction",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.balancetransaction",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "fee",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="refunds",
                        to="djstripe.applicationfee",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="Card",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "address_city",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="City/District/Suburb/Town/Village.",
                        max_length=5000,
                    ),
                ),
                (
                    "address_country",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Billing address country.",
                        max_length=5000,
                    ),
                ),
                (
                    "address_line1",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Street address/PO Box/Company name.",
                        max_length=5000,
                    ),
                ),
                (
                    "address_line1_check",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.CardCheckResult,
                        max_length=11,
                    ),
                ),
                (
                    "address_line2",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Apartment/Suite/Unit/Building.",
                        max_length=5000,
                    ),
                ),
                (
                    "address_state",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="State/County/Province/Region.",
                        max_length=5000,
                    ),
                ),
                (
                    "address_zip",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="ZIP or postal code.",
                        max_length=5000,
                    ),
                ),
                (
                    "address_zip_check",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.CardCheckResult,
                        max_length=11,
                    ),
                ),
                (
                    "brand",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.CardBrand, max_length=16
                    ),
                ),
                (
                    "country",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Two-letter ISO code representing the country of the card.",
                        max_length=2,
                    ),
                ),
                (
                    "cvc_check",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.CardCheckResult,
                        max_length=11,
                    ),
                ),
                (
                    "dynamic_last4",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="(For tokenized numbers only.) The last four digits of the device account number.",
                        max_length=4,
                    ),
                ),
                ("exp_month", models.IntegerField(help_text="Card expiration month.")),
                ("exp_year", models.IntegerField(help_text="Card expiration year.")),
                (
                    "fingerprint",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Uniquely identifies this particular card number.",
                        max_length=16,
                    ),
                ),
                (
                    "funding",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.CardFundingType, max_length=7
                    ),
                ),
                (
                    "last4",
                    models.CharField(
                        help_text="Last four digits of Card number.", max_length=4
                    ),
                ),
                (
                    "name",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Cardholder name.",
                        max_length=5000,
                    ),
                ),
                (
                    "tokenization_method",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.CardTokenizationMethod,
                        max_length=11,
                    ),
                ),
                (
                    "customer",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="legacy_cards",
                        to="djstripe.customer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.AddField(
            model_name="charge",
            name="djstripe_owner_account",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="djstripe.account",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.CreateModel(
            name="CountrySpec",
            fields=[
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "id",
                    models.CharField(max_length=2, primary_key=True, serialize=False),
                ),
                (
                    "default_currency",
                    djstripe.fields.StripeCurrencyCodeField(max_length=3),
                ),
                ("supported_bank_account_currencies", djstripe.fields.JSONField()),
                ("supported_payment_currencies", djstripe.fields.JSONField()),
                ("supported_payment_methods", djstripe.fields.JSONField()),
                ("supported_transfer_countries", djstripe.fields.JSONField()),
                ("verification_fields", djstripe.fields.JSONField()),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False},
        ),
        migrations.AddField(
            model_name="invoice",
            name="djstripe_owner_account",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="djstripe.account",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="paymentmethod",
            name="djstripe_owner_account",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="djstripe.account",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="plan",
            name="djstripe_owner_account",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="djstripe.account",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.CreateModel(
            name="Refund",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                ("amount", djstripe.fields.StripeQuantumCurrencyAmountField()),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "failure_reason",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.RefundFailureReason,
                        max_length=24,
                    ),
                ),
                (
                    "reason",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.RefundReason,
                        max_length=25,
                    ),
                ),
                (
                    "receipt_number",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The transaction number that appears on email receipts sent for this charge.",
                        max_length=9,
                    ),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        blank=True, enum=djstripe.enums.RefundStatus, max_length=9
                    ),
                ),
                (
                    "charge",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="refunds",
                        to="djstripe.charge",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "balance_transaction",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.balancetransaction",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "failure_balance_transaction",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="failure_refunds",
                        to="djstripe.balancetransaction",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="ScheduledQueryRun",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                ("data_load_time", djstripe.fields.StripeDateTimeField()),
                ("error", djstripe.fields.JSONField(blank=True, null=True)),
                ("result_available_until", djstripe.fields.StripeDateTimeField()),
                (
                    "sql",
                    models.TextField(help_text="SQL for the query.", max_length=5000),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.ScheduledQueryRunStatus, max_length=9
                    ),
                ),
                (
                    "title",
                    models.TextField(help_text="Title of the query.", max_length=5000),
                ),
                (
                    "file",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.fileupload",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="Session",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "billing_address_collection",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        enum=djstripe.enums.SessionBillingAddressCollection,
                        max_length=8,
                    ),
                ),
                (
                    "cancel_url",
                    models.TextField(
                        blank=True,
                        help_text="The URL the customer will be directed to if theydecide to cancel payment and return to your website.",
                        max_length=5000,
                    ),
                ),
                (
                    "client_reference_id",
                    models.TextField(
                        blank=True,
                        help_text="A unique string to reference the Checkout Session.This can be a customer ID, a cart ID, or similar, andcan be used to reconcile the session with your internal systems.",
                        max_length=5000,
                    ),
                ),
                (
                    "customer_email",
                    models.CharField(
                        blank=True,
                        help_text="If provided, this value will be used when the Customer object is created.",
                        max_length=255,
                    ),
                ),
                ("display_items", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "locale",
                    models.CharField(
                        blank=True,
                        help_text="The IETF language tag of the locale Checkout is displayed in.If blank or auto, the browser's locale is used.",
                        max_length=255,
                    ),
                ),
                ("payment_method_types", djstripe.fields.JSONField()),
                (
                    "submit_type",
                    djstripe.fields.StripeEnumField(
                        blank=True, enum=djstripe.enums.SubmitTypeStatus, max_length=6
                    ),
                ),
                (
                    "success_url",
                    models.TextField(
                        blank=True,
                        help_text="The URL the customer will be directed to after the payment or subscriptioncreation is successful.",
                        max_length=5000,
                    ),
                ),
                (
                    "customer",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.customer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "payment_intent",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.paymentintent",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "subscription",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.subscription",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "mode",
                    djstripe.fields.StripeEnumField(
                        blank=True, enum=djstripe.enums.SessionMode, max_length=12
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="Source",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "amount",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=2, max_digits=11, null=True
                    ),
                ),
                (
                    "client_secret",
                    models.CharField(
                        help_text="The client secret of the source. Used for client-side retrieval using a publishable key.",
                        max_length=255,
                    ),
                ),
                (
                    "currency",
                    djstripe.fields.StripeCurrencyCodeField(
                        blank=True, default="", max_length=3
                    ),
                ),
                (
                    "flow",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.SourceFlow, max_length=17
                    ),
                ),
                ("owner", djstripe.fields.JSONField()),
                (
                    "statement_descriptor",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Extra information about a source. This will appear on your customer's statement every time you charge the source.",
                        max_length=255,
                    ),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.SourceStatus, max_length=10
                    ),
                ),
                (
                    "type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.SourceType, max_length=20
                    ),
                ),
                (
                    "usage",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.SourceUsage, max_length=10
                    ),
                ),
                ("code_verification", djstripe.fields.JSONField(blank=True, null=True)),
                ("receiver", djstripe.fields.JSONField(blank=True, null=True)),
                ("redirect", djstripe.fields.JSONField(blank=True, null=True)),
                ("source_data", djstripe.fields.JSONField()),
                (
                    "customer",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="sources",
                        to="djstripe.customer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.AddField(
            model_name="subscription",
            name="djstripe_owner_account",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="djstripe.account",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.CreateModel(
            name="SubscriptionItem",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "quantity",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="The quantity of the plan to which the customer should be subscribed.",
                        null=True,
                    ),
                ),
                (
                    "plan",
                    models.ForeignKey(
                        help_text="The plan the customer is subscribed to.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subscription_items",
                        to="djstripe.plan",
                    ),
                ),
                (
                    "subscription",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="items",
                        to="djstripe.subscription",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "tax_rates",
                    models.ManyToManyField(
                        blank=True,
                        db_table="djstripe_djstripesubscriptionitemtaxrate",
                        help_text="The tax rates which apply to this subscription_item. When set, the default_tax_rates on the subscription do not apply to this subscription_item.",
                        related_name="_subscriptionitem_tax_rates_+",
                        to="djstripe.TaxRate",
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "billing_thresholds",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.AddField(
            model_name="transfer",
            name="djstripe_owner_account",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="djstripe.account",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.CreateModel(
            name="TransferReversal",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                ("amount", djstripe.fields.StripeQuantumCurrencyAmountField()),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "balance_transaction",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="transfer_reversals",
                        to="djstripe.balancetransaction",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "transfer",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="reversals",
                        to="djstripe.transfer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="UsageRecord",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "quantity",
                    models.PositiveIntegerField(
                        help_text="The quantity of the plan to which the customer should be subscribed."
                    ),
                ),
                (
                    "subscription_item",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="usage_records",
                        to="djstripe.subscriptionitem",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="Price",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "active",
                    models.BooleanField(
                        help_text="Whether the price can be used for new purchases."
                    ),
                ),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "nickname",
                    models.CharField(
                        blank=True,
                        help_text="A brief description of the plan, hidden from customers.",
                        max_length=250,
                    ),
                ),
                (
                    "recurring",
                    djstripe.fields.JSONField(blank=True, default=None, null=True),
                ),
                (
                    "type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.PriceType, max_length=9
                    ),
                ),
                (
                    "unit_amount",
                    djstripe.fields.StripeQuantumCurrencyAmountField(
                        blank=True, null=True
                    ),
                ),
                (
                    "unit_amount_decimal",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=12, max_digits=19, null=True
                    ),
                ),
                (
                    "billing_scheme",
                    djstripe.fields.StripeEnumField(
                        blank=True, enum=djstripe.enums.BillingScheme, max_length=8
                    ),
                ),
                ("tiers", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "tiers_mode",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        enum=djstripe.enums.PriceTiersMode,
                        max_length=9,
                        null=True,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "product",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="prices",
                        to="djstripe.product",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "lookup_key",
                    models.CharField(
                        blank=True,
                        help_text="A lookup key used to retrieve prices dynamically from a static string.",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "transform_quantity",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
            ],
            options={"abstract": False, "ordering": ["unit_amount"]},
        ),
        migrations.AddField(
            model_name="subscriptionitem",
            name="price",
            field=models.ForeignKey(
                blank=True,
                help_text="The price the customer is subscribed to.",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="subscription_items",
                to="djstripe.price",
            ),
        ),
        migrations.CreateModel(
            name="TaxId",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "country",
                    models.CharField(
                        help_text="Two-letter ISO code representing the country of the tax ID.",
                        max_length=2,
                    ),
                ),
                (
                    "type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.TaxIdType, max_length=7
                    ),
                ),
                (
                    "value",
                    models.CharField(help_text="Value of the tax ID.", max_length=50),
                ),
                ("verification", djstripe.fields.JSONField()),
                (
                    "customer",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tax_ids",
                        to="djstripe.customer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"verbose_name": "Tax ID", "verbose_name_plural": "Tax IDs"},
        ),
        migrations.CreateModel(
            name="InvoiceItem",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "amount",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11
                    ),
                ),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                ("date", djstripe.fields.StripeDateTimeField()),
                (
                    "discountable",
                    models.BooleanField(
                        default=False,
                        help_text="If True, discounts will apply to this invoice item. Always False for prorations.",
                    ),
                ),
                ("period", djstripe.fields.JSONField()),
                ("period_end", djstripe.fields.StripeDateTimeField()),
                ("period_start", djstripe.fields.StripeDateTimeField()),
                (
                    "proration",
                    models.BooleanField(
                        default=False,
                        help_text="Whether or not the invoice item was created automatically as a proration adjustment when the customer switched plans.",
                    ),
                ),
                (
                    "quantity",
                    models.IntegerField(
                        blank=True,
                        help_text="If the invoice item is a proration, the quantity of the subscription for which the proration was computed.",
                        null=True,
                    ),
                ),
                (
                    "customer",
                    djstripe.fields.StripeForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="invoiceitems",
                        to="djstripe.customer",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "invoice",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="invoiceitems",
                        to="djstripe.invoice",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "plan",
                    models.ForeignKey(
                        help_text="If the invoice item is a proration, the plan of the subscription for which the proration was computed.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.plan",
                    ),
                ),
                (
                    "subscription",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="invoiceitems",
                        to="djstripe.subscription",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "tax_rates",
                    models.ManyToManyField(
                        blank=True,
                        db_table="djstripe_djstripeinvoiceitemtaxrate",
                        help_text="The tax rates which apply to this invoice item. When set, the default_tax_rates on the invoice do not apply to this invoice item.",
                        related_name="_invoiceitem_tax_rates_+",
                        to="djstripe.TaxRate",
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "unit_amount",
                    djstripe.fields.StripeQuantumCurrencyAmountField(
                        blank=True, null=True
                    ),
                ),
                (
                    "unit_amount_decimal",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        blank=True, decimal_places=12, max_digits=19, null=True
                    ),
                ),
                (
                    "price",
                    models.ForeignKey(
                        help_text="If the invoice item is a proration, the price of the subscription for which the proration was computed.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="invoiceitems",
                        to="djstripe.price",
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.CreateModel(
            name="SubscriptionSchedule",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "canceled_at",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "completed_at",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                ("current_phase", djstripe.fields.JSONField(blank=True, null=True)),
                ("default_settings", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "end_behavior",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.SubscriptionScheduleEndBehavior,
                        max_length=7,
                    ),
                ),
                ("phases", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "released_at",
                    djstripe.fields.StripeDateTimeField(blank=True, null=True),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.SubscriptionScheduleStatus, max_length=11
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        help_text="The customer who owns the subscription schedule.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="schedules",
                        to="djstripe.customer",
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "released_subscription",
                    models.ForeignKey(
                        blank=True,
                        help_text="The subscription once managed by this subscription schedule (if it is released).",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="released_schedules",
                        to="djstripe.subscription",
                    ),
                ),
                (
                    "billing_thresholds",
                    djstripe.fields.JSONField(blank=True, null=True),
                ),
            ],
            options={"get_latest_by": "created", "abstract": False},
        ),
        migrations.AddField(
            model_name="subscription",
            name="schedule",
            field=models.ForeignKey(
                blank=True,
                help_text="The schedule associated with this subscription.",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="subscriptions",
                to="djstripe.subscriptionschedule",
            ),
        ),
        migrations.CreateModel(
            name="Payout",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("id", djstripe.fields.StripeIdField(max_length=255, unique=True)),
                (
                    "livemode",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.",
                        null=True,
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("metadata", djstripe.fields.JSONField(blank=True, null=True)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="A description of this object.", null=True
                    ),
                ),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "amount",
                    djstripe.fields.StripeDecimalCurrencyAmountField(
                        decimal_places=2, max_digits=11
                    ),
                ),
                ("arrival_date", djstripe.fields.StripeDateTimeField()),
                ("currency", djstripe.fields.StripeCurrencyCodeField(max_length=3)),
                (
                    "failure_code",
                    djstripe.fields.StripeEnumField(
                        blank=True,
                        default="",
                        enum=djstripe.enums.PayoutFailureCode,
                        max_length=23,
                    ),
                ),
                (
                    "failure_message",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Message to user further explaining reason for payout failure if available.",
                    ),
                ),
                (
                    "method",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.PayoutMethod, max_length=8
                    ),
                ),
                (
                    "statement_descriptor",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Extra information about a payout to be displayed on the user's bank statement.",
                        max_length=255,
                    ),
                ),
                (
                    "status",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.PayoutStatus, max_length=10
                    ),
                ),
                (
                    "type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.PayoutType, max_length=12
                    ),
                ),
                (
                    "destination",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="djstripe.bankaccount",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "balance_transaction",
                    djstripe.fields.StripeForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="djstripe.balancetransaction",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "failure_balance_transaction",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="failure_payouts",
                        to="djstripe.balancetransaction",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
                (
                    "automatic",
                    models.BooleanField(
                        help_text="`true` if the payout was created by an automated payout schedule, and `false` if it was requested manually.",
                    ),
                ),
                (
                    "source_type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.PayoutSourceType,
                        max_length=12,
                    ),
                ),
            ],
            options={"abstract": False, "get_latest_by": "created"},
        ),
        migrations.AddField(
            model_name="charge",
            name="source_transfer",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="djstripe.transfer",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.AddField(
            model_name="charge",
            name="application_fee",
            field=djstripe.fields.StripeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="fee_for_charge",
                to="djstripe.applicationfee",
                to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
            ),
        ),
        migrations.CreateModel(
            name="APIKey",
            fields=[
                (
                    "djstripe_id",
                    models.BigAutoField(
                        primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "livemode",
                    models.BooleanField(
                        help_text="Whether the key is valid for live or test mode."
                    ),
                ),
                ("created", djstripe.fields.StripeDateTimeField(blank=True, null=True)),
                ("djstripe_created", models.DateTimeField(auto_now_add=True)),
                ("djstripe_updated", models.DateTimeField(auto_now=True)),
                (
                    "id",
                    models.CharField(
                        default=djstripe.models.api.generate_api_key_id,
                        editable=False,
                        max_length=255,
                    ),
                ),
                (
                    "type",
                    djstripe.fields.StripeEnumField(
                        enum=djstripe.enums.APIKeyType, max_length=11
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        help_text="An optional name to identify the key.",
                        max_length=100,
                        verbose_name="Key name",
                    ),
                ),
                (
                    "secret",
                    models.CharField(
                        help_text="The value of the key.",
                        max_length=128,
                        unique=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                regex="^(pk|sk|rk)_(test|live)_([a-zA-Z0-9]{24,99})"
                            )
                        ],
                    ),
                ),
                (
                    "djstripe_owner_account",
                    djstripe.fields.StripeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="djstripe.account",
                        to_field=settings.DJSTRIPE_FOREIGN_KEY_TO_FIELD,
                    ),
                ),
            ],
            options={"get_latest_by": "created", "abstract": False},
        ),
    ]
