# coding: utf-8
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudtower.api_client import ApiClient
from cloudtower.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MetricsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_cluster_metrics(self, get_cluster_metric_input, **kwargs):  # noqa: E501
        """get_cluster_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cluster_metrics(get_cluster_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_cluster_metric_input: (required)
        :type get_cluster_metric_input: GetClusterMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_cluster_metrics_with_http_info(get_cluster_metric_input, **kwargs)  # noqa: E501

    def get_cluster_metrics_with_http_info(self, get_cluster_metric_input, **kwargs):  # noqa: E501
        """get_cluster_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cluster_metrics_with_http_info(get_cluster_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_cluster_metric_input: (required)
        :type get_cluster_metric_input: GetClusterMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_cluster_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_cluster_metric_input' is set
        if self.api_client.client_side_validation and ('get_cluster_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_cluster_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_cluster_metric_input` when calling `get_cluster_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_cluster_metric_input' in local_var_params:
            body_params = local_var_params['get_cluster_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-cluster-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_disk_metrics(self, get_disk_metric_input, **kwargs):  # noqa: E501
        """get_disk_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_disk_metrics(get_disk_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_disk_metric_input: (required)
        :type get_disk_metric_input: GetDiskMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_disk_metrics_with_http_info(get_disk_metric_input, **kwargs)  # noqa: E501

    def get_disk_metrics_with_http_info(self, get_disk_metric_input, **kwargs):  # noqa: E501
        """get_disk_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_disk_metrics_with_http_info(get_disk_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_disk_metric_input: (required)
        :type get_disk_metric_input: GetDiskMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_disk_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_disk_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_disk_metric_input' is set
        if self.api_client.client_side_validation and ('get_disk_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_disk_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_disk_metric_input` when calling `get_disk_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_disk_metric_input' in local_var_params:
            body_params = local_var_params['get_disk_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-disk-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_host_metrics(self, get_host_metric_input, **kwargs):  # noqa: E501
        """get_host_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_metrics(get_host_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_host_metric_input: (required)
        :type get_host_metric_input: GetHostMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_host_metrics_with_http_info(get_host_metric_input, **kwargs)  # noqa: E501

    def get_host_metrics_with_http_info(self, get_host_metric_input, **kwargs):  # noqa: E501
        """get_host_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_metrics_with_http_info(get_host_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_host_metric_input: (required)
        :type get_host_metric_input: GetHostMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_host_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_host_metric_input' is set
        if self.api_client.client_side_validation and ('get_host_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_host_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_host_metric_input` when calling `get_host_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_host_metric_input' in local_var_params:
            body_params = local_var_params['get_host_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-host-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_host_network_metrics(self, get_host_network_metric_input, **kwargs):  # noqa: E501
        """get_host_network_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_network_metrics(get_host_network_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_host_network_metric_input: (required)
        :type get_host_network_metric_input: GetHostNetworkMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_host_network_metrics_with_http_info(get_host_network_metric_input, **kwargs)  # noqa: E501

    def get_host_network_metrics_with_http_info(self, get_host_network_metric_input, **kwargs):  # noqa: E501
        """get_host_network_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_network_metrics_with_http_info(get_host_network_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_host_network_metric_input: (required)
        :type get_host_network_metric_input: GetHostNetworkMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_host_network_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_network_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_host_network_metric_input' is set
        if self.api_client.client_side_validation and ('get_host_network_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_host_network_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_host_network_metric_input` when calling `get_host_network_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_host_network_metric_input' in local_var_params:
            body_params = local_var_params['get_host_network_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-host-network-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_host_servicek_metrics(self, get_host_service_metric_input, **kwargs):  # noqa: E501
        """get_host_servicek_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_servicek_metrics(get_host_service_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_host_service_metric_input: (required)
        :type get_host_service_metric_input: GetHostServiceMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_host_servicek_metrics_with_http_info(get_host_service_metric_input, **kwargs)  # noqa: E501

    def get_host_servicek_metrics_with_http_info(self, get_host_service_metric_input, **kwargs):  # noqa: E501
        """get_host_servicek_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_servicek_metrics_with_http_info(get_host_service_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_host_service_metric_input: (required)
        :type get_host_service_metric_input: GetHostServiceMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_host_service_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_servicek_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_host_service_metric_input' is set
        if self.api_client.client_side_validation and ('get_host_service_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_host_service_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_host_service_metric_input` when calling `get_host_servicek_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_host_service_metric_input' in local_var_params:
            body_params = local_var_params['get_host_service_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-host-service-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_lun_metrics(self, get_lun_metric_input, **kwargs):  # noqa: E501
        """get_lun_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lun_metrics(get_lun_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_lun_metric_input: (required)
        :type get_lun_metric_input: GetLunMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_lun_metrics_with_http_info(get_lun_metric_input, **kwargs)  # noqa: E501

    def get_lun_metrics_with_http_info(self, get_lun_metric_input, **kwargs):  # noqa: E501
        """get_lun_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lun_metrics_with_http_info(get_lun_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_lun_metric_input: (required)
        :type get_lun_metric_input: GetLunMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_lun_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lun_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_lun_metric_input' is set
        if self.api_client.client_side_validation and ('get_lun_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_lun_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_lun_metric_input` when calling `get_lun_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_lun_metric_input' in local_var_params:
            body_params = local_var_params['get_lun_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-lun-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_nvmf_namespace_metrics(self, get_nvmf_namespace_metric_input, **kwargs):  # noqa: E501
        """get_nvmf_namespace_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_nvmf_namespace_metrics(get_nvmf_namespace_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_nvmf_namespace_metric_input: (required)
        :type get_nvmf_namespace_metric_input: GetNvmfNamespaceMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_nvmf_namespace_metrics_with_http_info(get_nvmf_namespace_metric_input, **kwargs)  # noqa: E501

    def get_nvmf_namespace_metrics_with_http_info(self, get_nvmf_namespace_metric_input, **kwargs):  # noqa: E501
        """get_nvmf_namespace_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_nvmf_namespace_metrics_with_http_info(get_nvmf_namespace_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_nvmf_namespace_metric_input: (required)
        :type get_nvmf_namespace_metric_input: GetNvmfNamespaceMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_nvmf_namespace_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nvmf_namespace_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_nvmf_namespace_metric_input' is set
        if self.api_client.client_side_validation and ('get_nvmf_namespace_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_nvmf_namespace_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_nvmf_namespace_metric_input` when calling `get_nvmf_namespace_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_nvmf_namespace_metric_input' in local_var_params:
            body_params = local_var_params['get_nvmf_namespace_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-nvmf-namespace-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_scvm_disk_metrics(self, get_scvm_disk_metric_input, **kwargs):  # noqa: E501
        """get_scvm_disk_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scvm_disk_metrics(get_scvm_disk_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_scvm_disk_metric_input: (required)
        :type get_scvm_disk_metric_input: GetSCVMDiskMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_scvm_disk_metrics_with_http_info(get_scvm_disk_metric_input, **kwargs)  # noqa: E501

    def get_scvm_disk_metrics_with_http_info(self, get_scvm_disk_metric_input, **kwargs):  # noqa: E501
        """get_scvm_disk_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scvm_disk_metrics_with_http_info(get_scvm_disk_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_scvm_disk_metric_input: (required)
        :type get_scvm_disk_metric_input: GetSCVMDiskMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_scvm_disk_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scvm_disk_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_scvm_disk_metric_input' is set
        if self.api_client.client_side_validation and ('get_scvm_disk_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_scvm_disk_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_scvm_disk_metric_input` when calling `get_scvm_disk_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_scvm_disk_metric_input' in local_var_params:
            body_params = local_var_params['get_scvm_disk_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-scvm-disk-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_scvm_metrics(self, get_scvm_metric_input, **kwargs):  # noqa: E501
        """get_scvm_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scvm_metrics(get_scvm_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_scvm_metric_input: (required)
        :type get_scvm_metric_input: GetScvmMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_scvm_metrics_with_http_info(get_scvm_metric_input, **kwargs)  # noqa: E501

    def get_scvm_metrics_with_http_info(self, get_scvm_metric_input, **kwargs):  # noqa: E501
        """get_scvm_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scvm_metrics_with_http_info(get_scvm_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_scvm_metric_input: (required)
        :type get_scvm_metric_input: GetScvmMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_scvm_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scvm_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_scvm_metric_input' is set
        if self.api_client.client_side_validation and ('get_scvm_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_scvm_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_scvm_metric_input` when calling `get_scvm_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_scvm_metric_input' in local_var_params:
            body_params = local_var_params['get_scvm_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-scvm-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_scvm_network_metrics(self, get_scvm_network_input, **kwargs):  # noqa: E501
        """get_scvm_network_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scvm_network_metrics(get_scvm_network_input, async_req=True)
        >>> result = thread.get()

        :param get_scvm_network_input: (required)
        :type get_scvm_network_input: GetScvmNetworkInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_scvm_network_metrics_with_http_info(get_scvm_network_input, **kwargs)  # noqa: E501

    def get_scvm_network_metrics_with_http_info(self, get_scvm_network_input, **kwargs):  # noqa: E501
        """get_scvm_network_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scvm_network_metrics_with_http_info(get_scvm_network_input, async_req=True)
        >>> result = thread.get()

        :param get_scvm_network_input: (required)
        :type get_scvm_network_input: GetScvmNetworkInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_scvm_network_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scvm_network_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_scvm_network_input' is set
        if self.api_client.client_side_validation and ('get_scvm_network_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_scvm_network_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_scvm_network_input` when calling `get_scvm_network_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_scvm_network_input' in local_var_params:
            body_params = local_var_params['get_scvm_network_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-scvm-network-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_scvm_servicek_metrics(self, get_scvm_service_metric_input, **kwargs):  # noqa: E501
        """get_scvm_servicek_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scvm_servicek_metrics(get_scvm_service_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_scvm_service_metric_input: (required)
        :type get_scvm_service_metric_input: GetScvmServiceMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_scvm_servicek_metrics_with_http_info(get_scvm_service_metric_input, **kwargs)  # noqa: E501

    def get_scvm_servicek_metrics_with_http_info(self, get_scvm_service_metric_input, **kwargs):  # noqa: E501
        """get_scvm_servicek_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_scvm_servicek_metrics_with_http_info(get_scvm_service_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_scvm_service_metric_input: (required)
        :type get_scvm_service_metric_input: GetScvmServiceMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_scvm_service_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scvm_servicek_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_scvm_service_metric_input' is set
        if self.api_client.client_side_validation and ('get_scvm_service_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_scvm_service_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_scvm_service_metric_input` when calling `get_scvm_servicek_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_scvm_service_metric_input' in local_var_params:
            body_params = local_var_params['get_scvm_service_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-scvm-service-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_top_nvm_volume_metrics(self, get_top_n_metric_input, **kwargs):  # noqa: E501
        """get_top_nvm_volume_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_top_nvm_volume_metrics(get_top_n_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_top_n_metric_input: (required)
        :type get_top_n_metric_input: GetTopNMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_top_nvm_volume_metrics_with_http_info(get_top_n_metric_input, **kwargs)  # noqa: E501

    def get_top_nvm_volume_metrics_with_http_info(self, get_top_n_metric_input, **kwargs):  # noqa: E501
        """get_top_nvm_volume_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_top_nvm_volume_metrics_with_http_info(get_top_n_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_top_n_metric_input: (required)
        :type get_top_n_metric_input: GetTopNMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_top_n_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_top_nvm_volume_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_top_n_metric_input' is set
        if self.api_client.client_side_validation and ('get_top_n_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_top_n_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_top_n_metric_input` when calling `get_top_nvm_volume_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_top_n_metric_input' in local_var_params:
            body_params = local_var_params['get_top_n_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-top-n-metrics-in-clusters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_vm_metrics(self, get_vm_metric_input, **kwargs):  # noqa: E501
        """get_vm_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_metrics(get_vm_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_vm_metric_input: (required)
        :type get_vm_metric_input: GetVmMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vm_metrics_with_http_info(get_vm_metric_input, **kwargs)  # noqa: E501

    def get_vm_metrics_with_http_info(self, get_vm_metric_input, **kwargs):  # noqa: E501
        """get_vm_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_metrics_with_http_info(get_vm_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_vm_metric_input: (required)
        :type get_vm_metric_input: GetVmMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_vm_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vm_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_vm_metric_input' is set
        if self.api_client.client_side_validation and ('get_vm_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_vm_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_vm_metric_input` when calling `get_vm_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_vm_metric_input' in local_var_params:
            body_params = local_var_params['get_vm_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-vm-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_vm_net_work_metrics(self, get_vm_net_work_metric_input, **kwargs):  # noqa: E501
        """get_vm_net_work_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_net_work_metrics(get_vm_net_work_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_vm_net_work_metric_input: (required)
        :type get_vm_net_work_metric_input: GetVmNetWorkMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vm_net_work_metrics_with_http_info(get_vm_net_work_metric_input, **kwargs)  # noqa: E501

    def get_vm_net_work_metrics_with_http_info(self, get_vm_net_work_metric_input, **kwargs):  # noqa: E501
        """get_vm_net_work_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_net_work_metrics_with_http_info(get_vm_net_work_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_vm_net_work_metric_input: (required)
        :type get_vm_net_work_metric_input: GetVmNetWorkMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_vm_net_work_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vm_net_work_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_vm_net_work_metric_input' is set
        if self.api_client.client_side_validation and ('get_vm_net_work_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_vm_net_work_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_vm_net_work_metric_input` when calling `get_vm_net_work_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_vm_net_work_metric_input' in local_var_params:
            body_params = local_var_params['get_vm_net_work_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-vm-network-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_vm_volume_metrics(self, get_vm_volume_metric_input, **kwargs):  # noqa: E501
        """get_vm_volume_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_volume_metrics(get_vm_volume_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_vm_volume_metric_input: (required)
        :type get_vm_volume_metric_input: GetVmVolumeMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vm_volume_metrics_with_http_info(get_vm_volume_metric_input, **kwargs)  # noqa: E501

    def get_vm_volume_metrics_with_http_info(self, get_vm_volume_metric_input, **kwargs):  # noqa: E501
        """get_vm_volume_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_volume_metrics_with_http_info(get_vm_volume_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_vm_volume_metric_input: (required)
        :type get_vm_volume_metric_input: GetVmVolumeMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_vm_volume_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vm_volume_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_vm_volume_metric_input' is set
        if self.api_client.client_side_validation and ('get_vm_volume_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_vm_volume_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_vm_volume_metric_input` when calling `get_vm_volume_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_vm_volume_metric_input' in local_var_params:
            body_params = local_var_params['get_vm_volume_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-vm-volume-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_witness_metrics(self, get_witness_metric_input, **kwargs):  # noqa: E501
        """get_witness_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_witness_metrics(get_witness_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_witness_metric_input: (required)
        :type get_witness_metric_input: GetWitnessMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_witness_metrics_with_http_info(get_witness_metric_input, **kwargs)  # noqa: E501

    def get_witness_metrics_with_http_info(self, get_witness_metric_input, **kwargs):  # noqa: E501
        """get_witness_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_witness_metrics_with_http_info(get_witness_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_witness_metric_input: (required)
        :type get_witness_metric_input: GetWitnessMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_witness_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_witness_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_witness_metric_input' is set
        if self.api_client.client_side_validation and ('get_witness_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_witness_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_witness_metric_input` when calling `get_witness_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_witness_metric_input' in local_var_params:
            body_params = local_var_params['get_witness_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-witness-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_zone_metrics(self, get_zone_metric_input, **kwargs):  # noqa: E501
        """get_zone_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_zone_metrics(get_zone_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_zone_metric_input: (required)
        :type get_zone_metric_input: GetZoneMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskMetric]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_zone_metrics_with_http_info(get_zone_metric_input, **kwargs)  # noqa: E501

    def get_zone_metrics_with_http_info(self, get_zone_metric_input, **kwargs):  # noqa: E501
        """get_zone_metrics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_zone_metrics_with_http_info(get_zone_metric_input, async_req=True)
        >>> result = thread.get()

        :param get_zone_metric_input: (required)
        :type get_zone_metric_input: GetZoneMetricInput
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskMetric], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_zone_metric_input',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_zone_metrics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_zone_metric_input' is set
        if self.api_client.client_side_validation and ('get_zone_metric_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_zone_metric_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_zone_metric_input` when calling `get_zone_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_zone_metric_input' in local_var_params:
            body_params = local_var_params['get_zone_metric_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskMetric]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-zone-metrics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
