# coding: utf-8
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudtower.api_client import ApiClient
from cloudtower.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class VmApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def abort_migrate_vm_across_cluster(self, abort_migrate_vm_across_cluster_params, **kwargs):  # noqa: E501
        """abort_migrate_vm_across_cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.abort_migrate_vm_across_cluster(abort_migrate_vm_across_cluster_params, async_req=True)
        >>> result = thread.get()

        :param abort_migrate_vm_across_cluster_params: (required)
        :type abort_migrate_vm_across_cluster_params: AbortMigrateVmAcrossClusterParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Task]
        """
        kwargs['_return_http_data_only'] = True
        return self.abort_migrate_vm_across_cluster_with_http_info(abort_migrate_vm_across_cluster_params, **kwargs)  # noqa: E501

    def abort_migrate_vm_across_cluster_with_http_info(self, abort_migrate_vm_across_cluster_params, **kwargs):  # noqa: E501
        """abort_migrate_vm_across_cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.abort_migrate_vm_across_cluster_with_http_info(abort_migrate_vm_across_cluster_params, async_req=True)
        >>> result = thread.get()

        :param abort_migrate_vm_across_cluster_params: (required)
        :type abort_migrate_vm_across_cluster_params: AbortMigrateVmAcrossClusterParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Task], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'abort_migrate_vm_across_cluster_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method abort_migrate_vm_across_cluster" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'abort_migrate_vm_across_cluster_params' is set
        if self.api_client.client_side_validation and ('abort_migrate_vm_across_cluster_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['abort_migrate_vm_across_cluster_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `abort_migrate_vm_across_cluster_params` when calling `abort_migrate_vm_across_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'abort_migrate_vm_across_cluster_params' in local_var_params:
            body_params = local_var_params['abort_migrate_vm_across_cluster_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[Task]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/abort-migrate-vm-across-cluster', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_vm_cd_rom(self, vm_add_cd_rom_params, **kwargs):  # noqa: E501
        """add_vm_cd_rom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_cd_rom(vm_add_cd_rom_params, async_req=True)
        >>> result = thread.get()

        :param vm_add_cd_rom_params: (required)
        :type vm_add_cd_rom_params: VmAddCdRomParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.add_vm_cd_rom_with_http_info(vm_add_cd_rom_params, **kwargs)  # noqa: E501

    def add_vm_cd_rom_with_http_info(self, vm_add_cd_rom_params, **kwargs):  # noqa: E501
        """add_vm_cd_rom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_cd_rom_with_http_info(vm_add_cd_rom_params, async_req=True)
        >>> result = thread.get()

        :param vm_add_cd_rom_params: (required)
        :type vm_add_cd_rom_params: VmAddCdRomParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_add_cd_rom_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_vm_cd_rom" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_add_cd_rom_params' is set
        if self.api_client.client_side_validation and ('vm_add_cd_rom_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_add_cd_rom_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_add_cd_rom_params` when calling `add_vm_cd_rom`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_add_cd_rom_params' in local_var_params:
            body_params = local_var_params['vm_add_cd_rom_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/add-vm-cd-rom', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_vm_disk(self, vm_add_disk_params, **kwargs):  # noqa: E501
        """add_vm_disk  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_disk(vm_add_disk_params, async_req=True)
        >>> result = thread.get()

        :param vm_add_disk_params: (required)
        :type vm_add_disk_params: VmAddDiskParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.add_vm_disk_with_http_info(vm_add_disk_params, **kwargs)  # noqa: E501

    def add_vm_disk_with_http_info(self, vm_add_disk_params, **kwargs):  # noqa: E501
        """add_vm_disk  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_disk_with_http_info(vm_add_disk_params, async_req=True)
        >>> result = thread.get()

        :param vm_add_disk_params: (required)
        :type vm_add_disk_params: VmAddDiskParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_add_disk_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_vm_disk" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_add_disk_params' is set
        if self.api_client.client_side_validation and ('vm_add_disk_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_add_disk_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_add_disk_params` when calling `add_vm_disk`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_add_disk_params' in local_var_params:
            body_params = local_var_params['vm_add_disk_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/add-vm-disk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_vm_gpu_device(self, vm_add_gpu_device_params, **kwargs):  # noqa: E501
        """add_vm_gpu_device  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_gpu_device(vm_add_gpu_device_params, async_req=True)
        >>> result = thread.get()

        :param vm_add_gpu_device_params: (required)
        :type vm_add_gpu_device_params: VmAddGpuDeviceParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.add_vm_gpu_device_with_http_info(vm_add_gpu_device_params, **kwargs)  # noqa: E501

    def add_vm_gpu_device_with_http_info(self, vm_add_gpu_device_params, **kwargs):  # noqa: E501
        """add_vm_gpu_device  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_gpu_device_with_http_info(vm_add_gpu_device_params, async_req=True)
        >>> result = thread.get()

        :param vm_add_gpu_device_params: (required)
        :type vm_add_gpu_device_params: VmAddGpuDeviceParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_add_gpu_device_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_vm_gpu_device" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_add_gpu_device_params' is set
        if self.api_client.client_side_validation and ('vm_add_gpu_device_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_add_gpu_device_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_add_gpu_device_params` when calling `add_vm_gpu_device`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_add_gpu_device_params' in local_var_params:
            body_params = local_var_params['vm_add_gpu_device_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/add-vm-gpu-device', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_vm_nic(self, vm_add_nic_params, **kwargs):  # noqa: E501
        """add_vm_nic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_nic(vm_add_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_add_nic_params: (required)
        :type vm_add_nic_params: VmAddNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.add_vm_nic_with_http_info(vm_add_nic_params, **kwargs)  # noqa: E501

    def add_vm_nic_with_http_info(self, vm_add_nic_params, **kwargs):  # noqa: E501
        """add_vm_nic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_nic_with_http_info(vm_add_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_add_nic_params: (required)
        :type vm_add_nic_params: VmAddNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_add_nic_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_vm_nic" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_add_nic_params' is set
        if self.api_client.client_side_validation and ('vm_add_nic_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_add_nic_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_add_nic_params` when calling `add_vm_nic`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_add_nic_params' in local_var_params:
            body_params = local_var_params['vm_add_nic_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/add-vm-nic', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_vm_pci_nic(self, vm_operate_pci_nic_params, **kwargs):  # noqa: E501
        """add_vm_pci_nic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_pci_nic(vm_operate_pci_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_pci_nic_params: (required)
        :type vm_operate_pci_nic_params: VmOperatePciNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.add_vm_pci_nic_with_http_info(vm_operate_pci_nic_params, **kwargs)  # noqa: E501

    def add_vm_pci_nic_with_http_info(self, vm_operate_pci_nic_params, **kwargs):  # noqa: E501
        """add_vm_pci_nic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_pci_nic_with_http_info(vm_operate_pci_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_pci_nic_params: (required)
        :type vm_operate_pci_nic_params: VmOperatePciNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_operate_pci_nic_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_vm_pci_nic" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_operate_pci_nic_params' is set
        if self.api_client.client_side_validation and ('vm_operate_pci_nic_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_operate_pci_nic_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_operate_pci_nic_params` when calling `add_vm_pci_nic`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_operate_pci_nic_params' in local_var_params:
            body_params = local_var_params['vm_operate_pci_nic_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/add-vm-pci-nic', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_vm_to_folder(self, vm_add_folder_params, **kwargs):  # noqa: E501
        """add_vm_to_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_to_folder(vm_add_folder_params, async_req=True)
        >>> result = thread.get()

        :param vm_add_folder_params: (required)
        :type vm_add_folder_params: VmAddFolderParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.add_vm_to_folder_with_http_info(vm_add_folder_params, **kwargs)  # noqa: E501

    def add_vm_to_folder_with_http_info(self, vm_add_folder_params, **kwargs):  # noqa: E501
        """add_vm_to_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_vm_to_folder_with_http_info(vm_add_folder_params, async_req=True)
        >>> result = thread.get()

        :param vm_add_folder_params: (required)
        :type vm_add_folder_params: VmAddFolderParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_add_folder_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_vm_to_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_add_folder_params' is set
        if self.api_client.client_side_validation and ('vm_add_folder_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_add_folder_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_add_folder_params` when calling `add_vm_to_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_add_folder_params' in local_var_params:
            body_params = local_var_params['vm_add_folder_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/add-vm-to-folder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def clone_vm(self, vm_clone_params, **kwargs):  # noqa: E501
        """clone_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.clone_vm(vm_clone_params, async_req=True)
        >>> result = thread.get()

        :param vm_clone_params: (required)
        :type vm_clone_params: list[VmCloneParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.clone_vm_with_http_info(vm_clone_params, **kwargs)  # noqa: E501

    def clone_vm_with_http_info(self, vm_clone_params, **kwargs):  # noqa: E501
        """clone_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.clone_vm_with_http_info(vm_clone_params, async_req=True)
        >>> result = thread.get()

        :param vm_clone_params: (required)
        :type vm_clone_params: list[VmCloneParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_clone_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_clone_params' is set
        if self.api_client.client_side_validation and ('vm_clone_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_clone_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_clone_params` when calling `clone_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_clone_params' in local_var_params:
            body_params = local_var_params['vm_clone_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/clone-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def convert_vm_template_to_vm(self, convert_vm_template_to_vm_params, **kwargs):  # noqa: E501
        """convert_vm_template_to_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.convert_vm_template_to_vm(convert_vm_template_to_vm_params, async_req=True)
        >>> result = thread.get()

        :param convert_vm_template_to_vm_params: (required)
        :type convert_vm_template_to_vm_params: list[ConvertVmTemplateToVmParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.convert_vm_template_to_vm_with_http_info(convert_vm_template_to_vm_params, **kwargs)  # noqa: E501

    def convert_vm_template_to_vm_with_http_info(self, convert_vm_template_to_vm_params, **kwargs):  # noqa: E501
        """convert_vm_template_to_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.convert_vm_template_to_vm_with_http_info(convert_vm_template_to_vm_params, async_req=True)
        >>> result = thread.get()

        :param convert_vm_template_to_vm_params: (required)
        :type convert_vm_template_to_vm_params: list[ConvertVmTemplateToVmParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'convert_vm_template_to_vm_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method convert_vm_template_to_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'convert_vm_template_to_vm_params' is set
        if self.api_client.client_side_validation and ('convert_vm_template_to_vm_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['convert_vm_template_to_vm_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `convert_vm_template_to_vm_params` when calling `convert_vm_template_to_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'convert_vm_template_to_vm_params' in local_var_params:
            body_params = local_var_params['convert_vm_template_to_vm_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/convert-vm-template-to-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_vm(self, vm_creation_params, **kwargs):  # noqa: E501
        """create_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm(vm_creation_params, async_req=True)
        >>> result = thread.get()

        :param vm_creation_params: (required)
        :type vm_creation_params: list[VmCreationParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_vm_with_http_info(vm_creation_params, **kwargs)  # noqa: E501

    def create_vm_with_http_info(self, vm_creation_params, **kwargs):  # noqa: E501
        """create_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm_with_http_info(vm_creation_params, async_req=True)
        >>> result = thread.get()

        :param vm_creation_params: (required)
        :type vm_creation_params: list[VmCreationParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_creation_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_creation_params' is set
        if self.api_client.client_side_validation and ('vm_creation_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_creation_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_creation_params` when calling `create_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_creation_params' in local_var_params:
            body_params = local_var_params['vm_creation_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/create-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_vm_from_content_library_template(self, vm_create_vm_from_content_library_template_params, **kwargs):  # noqa: E501
        """create_vm_from_content_library_template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm_from_content_library_template(vm_create_vm_from_content_library_template_params, async_req=True)
        >>> result = thread.get()

        :param vm_create_vm_from_content_library_template_params: (required)
        :type vm_create_vm_from_content_library_template_params: list[VmCreateVmFromContentLibraryTemplateParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_vm_from_content_library_template_with_http_info(vm_create_vm_from_content_library_template_params, **kwargs)  # noqa: E501

    def create_vm_from_content_library_template_with_http_info(self, vm_create_vm_from_content_library_template_params, **kwargs):  # noqa: E501
        """create_vm_from_content_library_template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm_from_content_library_template_with_http_info(vm_create_vm_from_content_library_template_params, async_req=True)
        >>> result = thread.get()

        :param vm_create_vm_from_content_library_template_params: (required)
        :type vm_create_vm_from_content_library_template_params: list[VmCreateVmFromContentLibraryTemplateParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_create_vm_from_content_library_template_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_vm_from_content_library_template" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_create_vm_from_content_library_template_params' is set
        if self.api_client.client_side_validation and ('vm_create_vm_from_content_library_template_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_create_vm_from_content_library_template_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_create_vm_from_content_library_template_params` when calling `create_vm_from_content_library_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_create_vm_from_content_library_template_params' in local_var_params:
            body_params = local_var_params['vm_create_vm_from_content_library_template_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/create-vm-from-content-library-template', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_vm_from_content_library_template_batch(self, vm_create_vm_from_content_library_template_batch_params, **kwargs):  # noqa: E501
        """create_vm_from_content_library_template_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm_from_content_library_template_batch(vm_create_vm_from_content_library_template_batch_params, async_req=True)
        >>> result = thread.get()

        :param vm_create_vm_from_content_library_template_batch_params: (required)
        :type vm_create_vm_from_content_library_template_batch_params: VmCreateVmFromContentLibraryTemplateBatchParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WithTaskVmArray
        """
        kwargs['_return_http_data_only'] = True
        return self.create_vm_from_content_library_template_batch_with_http_info(vm_create_vm_from_content_library_template_batch_params, **kwargs)  # noqa: E501

    def create_vm_from_content_library_template_batch_with_http_info(self, vm_create_vm_from_content_library_template_batch_params, **kwargs):  # noqa: E501
        """create_vm_from_content_library_template_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm_from_content_library_template_batch_with_http_info(vm_create_vm_from_content_library_template_batch_params, async_req=True)
        >>> result = thread.get()

        :param vm_create_vm_from_content_library_template_batch_params: (required)
        :type vm_create_vm_from_content_library_template_batch_params: VmCreateVmFromContentLibraryTemplateBatchParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WithTaskVmArray, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_create_vm_from_content_library_template_batch_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_vm_from_content_library_template_batch" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_create_vm_from_content_library_template_batch_params' is set
        if self.api_client.client_side_validation and ('vm_create_vm_from_content_library_template_batch_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_create_vm_from_content_library_template_batch_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_create_vm_from_content_library_template_batch_params` when calling `create_vm_from_content_library_template_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_create_vm_from_content_library_template_batch_params' in local_var_params:
            body_params = local_var_params['vm_create_vm_from_content_library_template_batch_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "WithTaskVmArray",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/create-vm-from-content-library-template-batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_vm_from_template(self, vm_create_vm_from_template_params, **kwargs):  # noqa: E501
        """create_vm_from_template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm_from_template(vm_create_vm_from_template_params, async_req=True)
        >>> result = thread.get()

        :param vm_create_vm_from_template_params: (required)
        :type vm_create_vm_from_template_params: list[VmCreateVmFromTemplateParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_vm_from_template_with_http_info(vm_create_vm_from_template_params, **kwargs)  # noqa: E501

    def create_vm_from_template_with_http_info(self, vm_create_vm_from_template_params, **kwargs):  # noqa: E501
        """create_vm_from_template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm_from_template_with_http_info(vm_create_vm_from_template_params, async_req=True)
        >>> result = thread.get()

        :param vm_create_vm_from_template_params: (required)
        :type vm_create_vm_from_template_params: list[VmCreateVmFromTemplateParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_create_vm_from_template_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_vm_from_template" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_create_vm_from_template_params' is set
        if self.api_client.client_side_validation and ('vm_create_vm_from_template_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_create_vm_from_template_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_create_vm_from_template_params` when calling `create_vm_from_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_create_vm_from_template_params' in local_var_params:
            body_params = local_var_params['vm_create_vm_from_template_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/create-vm-from-template', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_vm(self, vm_delete_params, **kwargs):  # noqa: E501
        """delete_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_vm(vm_delete_params, async_req=True)
        >>> result = thread.get()

        :param vm_delete_params: (required)
        :type vm_delete_params: VmDeleteParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskDeleteVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_vm_with_http_info(vm_delete_params, **kwargs)  # noqa: E501

    def delete_vm_with_http_info(self, vm_delete_params, **kwargs):  # noqa: E501
        """delete_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_vm_with_http_info(vm_delete_params, async_req=True)
        >>> result = thread.get()

        :param vm_delete_params: (required)
        :type vm_delete_params: VmDeleteParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskDeleteVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_delete_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_delete_params' is set
        if self.api_client.client_side_validation and ('vm_delete_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_delete_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_delete_params` when calling `delete_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_delete_params' in local_var_params:
            body_params = local_var_params['vm_delete_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskDeleteVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/delete-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def eject_iso_from_vm_cd_rom(self, vm_eject_cd_rom_params, **kwargs):  # noqa: E501
        """eject_iso_from_vm_cd_rom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.eject_iso_from_vm_cd_rom(vm_eject_cd_rom_params, async_req=True)
        >>> result = thread.get()

        :param vm_eject_cd_rom_params: (required)
        :type vm_eject_cd_rom_params: VmEjectCdRomParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.eject_iso_from_vm_cd_rom_with_http_info(vm_eject_cd_rom_params, **kwargs)  # noqa: E501

    def eject_iso_from_vm_cd_rom_with_http_info(self, vm_eject_cd_rom_params, **kwargs):  # noqa: E501
        """eject_iso_from_vm_cd_rom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.eject_iso_from_vm_cd_rom_with_http_info(vm_eject_cd_rom_params, async_req=True)
        >>> result = thread.get()

        :param vm_eject_cd_rom_params: (required)
        :type vm_eject_cd_rom_params: VmEjectCdRomParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_eject_cd_rom_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method eject_iso_from_vm_cd_rom" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_eject_cd_rom_params' is set
        if self.api_client.client_side_validation and ('vm_eject_cd_rom_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_eject_cd_rom_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_eject_cd_rom_params` when calling `eject_iso_from_vm_cd_rom`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_eject_cd_rom_params' in local_var_params:
            body_params = local_var_params['vm_eject_cd_rom_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/eject-iso-from-vm-cd-rom', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def expand_vm_disk(self, vm_expand_vm_disk_params, **kwargs):  # noqa: E501
        """expand_vm_disk  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.expand_vm_disk(vm_expand_vm_disk_params, async_req=True)
        >>> result = thread.get()

        :param vm_expand_vm_disk_params: (required)
        :type vm_expand_vm_disk_params: VmExpandVmDiskParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.expand_vm_disk_with_http_info(vm_expand_vm_disk_params, **kwargs)  # noqa: E501

    def expand_vm_disk_with_http_info(self, vm_expand_vm_disk_params, **kwargs):  # noqa: E501
        """expand_vm_disk  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.expand_vm_disk_with_http_info(vm_expand_vm_disk_params, async_req=True)
        >>> result = thread.get()

        :param vm_expand_vm_disk_params: (required)
        :type vm_expand_vm_disk_params: VmExpandVmDiskParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_expand_vm_disk_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method expand_vm_disk" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_expand_vm_disk_params' is set
        if self.api_client.client_side_validation and ('vm_expand_vm_disk_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_expand_vm_disk_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_expand_vm_disk_params` when calling `expand_vm_disk`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_expand_vm_disk_params' in local_var_params:
            body_params = local_var_params['vm_expand_vm_disk_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/expand-vm-disk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def export_vm(self, vm_export_params, **kwargs):  # noqa: E501
        """export_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_vm(vm_export_params, async_req=True)
        >>> result = thread.get()

        :param vm_export_params: (required)
        :type vm_export_params: VmExportParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVmExportFile]
        """
        kwargs['_return_http_data_only'] = True
        return self.export_vm_with_http_info(vm_export_params, **kwargs)  # noqa: E501

    def export_vm_with_http_info(self, vm_export_params, **kwargs):  # noqa: E501
        """export_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_vm_with_http_info(vm_export_params, async_req=True)
        >>> result = thread.get()

        :param vm_export_params: (required)
        :type vm_export_params: VmExportParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVmExportFile], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_export_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_export_params' is set
        if self.api_client.client_side_validation and ('vm_export_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_export_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_export_params` when calling `export_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_export_params' in local_var_params:
            body_params = local_var_params['vm_export_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVmExportFile]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/export-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def force_restart_vm(self, vm_operate_params, **kwargs):  # noqa: E501
        """force_restart_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.force_restart_vm(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.force_restart_vm_with_http_info(vm_operate_params, **kwargs)  # noqa: E501

    def force_restart_vm_with_http_info(self, vm_operate_params, **kwargs):  # noqa: E501
        """force_restart_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.force_restart_vm_with_http_info(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_operate_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method force_restart_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_operate_params' is set
        if self.api_client.client_side_validation and ('vm_operate_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_operate_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_operate_params` when calling `force_restart_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_operate_params' in local_var_params:
            body_params = local_var_params['vm_operate_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/force-restart-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_vm_gpu_device_info(self, get_vms_request_body, **kwargs):  # noqa: E501
        """get_vm_gpu_device_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_gpu_device_info(get_vms_request_body, async_req=True)
        >>> result = thread.get()

        :param get_vms_request_body: (required)
        :type get_vms_request_body: GetVmsRequestBody
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[VmGpuInfo]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vm_gpu_device_info_with_http_info(get_vms_request_body, **kwargs)  # noqa: E501

    def get_vm_gpu_device_info_with_http_info(self, get_vms_request_body, **kwargs):  # noqa: E501
        """get_vm_gpu_device_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_gpu_device_info_with_http_info(get_vms_request_body, async_req=True)
        >>> result = thread.get()

        :param get_vms_request_body: (required)
        :type get_vms_request_body: GetVmsRequestBody
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[VmGpuInfo], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_vms_request_body',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vm_gpu_device_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_vms_request_body' is set
        if self.api_client.client_side_validation and ('get_vms_request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_vms_request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_vms_request_body` when calling `get_vm_gpu_device_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_vms_request_body' in local_var_params:
            body_params = local_var_params['get_vms_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[VmGpuInfo]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-vm-gpu-device-info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_vm_vnc_info(self, get_vm_vnc_info_params, **kwargs):  # noqa: E501
        """get_vm_vnc_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_vnc_info(get_vm_vnc_info_params, async_req=True)
        >>> result = thread.get()

        :param get_vm_vnc_info_params: (required)
        :type get_vm_vnc_info_params: GetVmVncInfoParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VmVncInfo
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vm_vnc_info_with_http_info(get_vm_vnc_info_params, **kwargs)  # noqa: E501

    def get_vm_vnc_info_with_http_info(self, get_vm_vnc_info_params, **kwargs):  # noqa: E501
        """get_vm_vnc_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_vnc_info_with_http_info(get_vm_vnc_info_params, async_req=True)
        >>> result = thread.get()

        :param get_vm_vnc_info_params: (required)
        :type get_vm_vnc_info_params: GetVmVncInfoParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VmVncInfo, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_vm_vnc_info_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vm_vnc_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_vm_vnc_info_params' is set
        if self.api_client.client_side_validation and ('get_vm_vnc_info_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_vm_vnc_info_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_vm_vnc_info_params` when calling `get_vm_vnc_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_vm_vnc_info_params' in local_var_params:
            body_params = local_var_params['get_vm_vnc_info_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "VmVncInfo",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-vm-vnc-info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_vms(self, get_vms_request_body, **kwargs):  # noqa: E501
        """get_vms  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vms(get_vms_request_body, async_req=True)
        >>> result = thread.get()

        :param get_vms_request_body: (required)
        :type get_vms_request_body: GetVmsRequestBody
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Vm]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vms_with_http_info(get_vms_request_body, **kwargs)  # noqa: E501

    def get_vms_with_http_info(self, get_vms_request_body, **kwargs):  # noqa: E501
        """get_vms  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vms_with_http_info(get_vms_request_body, async_req=True)
        >>> result = thread.get()

        :param get_vms_request_body: (required)
        :type get_vms_request_body: GetVmsRequestBody
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Vm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_vms_request_body',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vms" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_vms_request_body' is set
        if self.api_client.client_side_validation and ('get_vms_request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_vms_request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_vms_request_body` when calling `get_vms`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_vms_request_body' in local_var_params:
            body_params = local_var_params['get_vms_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[Vm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-vms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_vms_connection(self, get_vms_connection_request_body, **kwargs):  # noqa: E501
        """get_vms_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vms_connection(get_vms_connection_request_body, async_req=True)
        >>> result = thread.get()

        :param get_vms_connection_request_body: (required)
        :type get_vms_connection_request_body: GetVmsConnectionRequestBody
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VmConnection
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vms_connection_with_http_info(get_vms_connection_request_body, **kwargs)  # noqa: E501

    def get_vms_connection_with_http_info(self, get_vms_connection_request_body, **kwargs):  # noqa: E501
        """get_vms_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vms_connection_with_http_info(get_vms_connection_request_body, async_req=True)
        >>> result = thread.get()

        :param get_vms_connection_request_body: (required)
        :type get_vms_connection_request_body: GetVmsConnectionRequestBody
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VmConnection, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_vms_connection_request_body',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vms_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_vms_connection_request_body' is set
        if self.api_client.client_side_validation and ('get_vms_connection_request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_vms_connection_request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_vms_connection_request_body` when calling `get_vms_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_vms_connection_request_body' in local_var_params:
            body_params = local_var_params['get_vms_connection_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "VmConnection",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-vms-connection', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def import_vm(self, vm_import_params, **kwargs):  # noqa: E501
        """import_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_vm(vm_import_params, async_req=True)
        >>> result = thread.get()

        :param vm_import_params: (required)
        :type vm_import_params: list[VmImportParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.import_vm_with_http_info(vm_import_params, **kwargs)  # noqa: E501

    def import_vm_with_http_info(self, vm_import_params, **kwargs):  # noqa: E501
        """import_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_vm_with_http_info(vm_import_params, async_req=True)
        >>> result = thread.get()

        :param vm_import_params: (required)
        :type vm_import_params: list[VmImportParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_import_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_import_params' is set
        if self.api_client.client_side_validation and ('vm_import_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_import_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_import_params` when calling `import_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_import_params' in local_var_params:
            body_params = local_var_params['vm_import_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/import-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def install_vmtools(self, install_vmtools_params, **kwargs):  # noqa: E501
        """install_vmtools  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.install_vmtools(install_vmtools_params, async_req=True)
        >>> result = thread.get()

        :param install_vmtools_params: (required)
        :type install_vmtools_params: InstallVmtoolsParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.install_vmtools_with_http_info(install_vmtools_params, **kwargs)  # noqa: E501

    def install_vmtools_with_http_info(self, install_vmtools_params, **kwargs):  # noqa: E501
        """install_vmtools  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.install_vmtools_with_http_info(install_vmtools_params, async_req=True)
        >>> result = thread.get()

        :param install_vmtools_params: (required)
        :type install_vmtools_params: InstallVmtoolsParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'install_vmtools_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method install_vmtools" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'install_vmtools_params' is set
        if self.api_client.client_side_validation and ('install_vmtools_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['install_vmtools_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `install_vmtools_params` when calling `install_vmtools`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'install_vmtools_params' in local_var_params:
            body_params = local_var_params['install_vmtools_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/install-vmtools', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def migrate_vm(self, vm_migrate_params, **kwargs):  # noqa: E501
        """migrate_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.migrate_vm(vm_migrate_params, async_req=True)
        >>> result = thread.get()

        :param vm_migrate_params: (required)
        :type vm_migrate_params: VmMigrateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.migrate_vm_with_http_info(vm_migrate_params, **kwargs)  # noqa: E501

    def migrate_vm_with_http_info(self, vm_migrate_params, **kwargs):  # noqa: E501
        """migrate_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.migrate_vm_with_http_info(vm_migrate_params, async_req=True)
        >>> result = thread.get()

        :param vm_migrate_params: (required)
        :type vm_migrate_params: VmMigrateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_migrate_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method migrate_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_migrate_params' is set
        if self.api_client.client_side_validation and ('vm_migrate_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_migrate_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_migrate_params` when calling `migrate_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_migrate_params' in local_var_params:
            body_params = local_var_params['vm_migrate_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/migrate-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def migrate_vm_across_cluster(self, vm_migrate_across_cluster_params, **kwargs):  # noqa: E501
        """migrate_vm_across_cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.migrate_vm_across_cluster(vm_migrate_across_cluster_params, async_req=True)
        >>> result = thread.get()

        :param vm_migrate_across_cluster_params: (required)
        :type vm_migrate_across_cluster_params: VmMigrateAcrossClusterParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.migrate_vm_across_cluster_with_http_info(vm_migrate_across_cluster_params, **kwargs)  # noqa: E501

    def migrate_vm_across_cluster_with_http_info(self, vm_migrate_across_cluster_params, **kwargs):  # noqa: E501
        """migrate_vm_across_cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.migrate_vm_across_cluster_with_http_info(vm_migrate_across_cluster_params, async_req=True)
        >>> result = thread.get()

        :param vm_migrate_across_cluster_params: (required)
        :type vm_migrate_across_cluster_params: VmMigrateAcrossClusterParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_migrate_across_cluster_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method migrate_vm_across_cluster" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_migrate_across_cluster_params' is set
        if self.api_client.client_side_validation and ('vm_migrate_across_cluster_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_migrate_across_cluster_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_migrate_across_cluster_params` when calling `migrate_vm_across_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_migrate_across_cluster_params' in local_var_params:
            body_params = local_var_params['vm_migrate_across_cluster_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/migrate-vm-across-cluster', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def move_vm_to_recycle_bin(self, vm_operate_params, **kwargs):  # noqa: E501
        """move_vm_to_recycle_bin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.move_vm_to_recycle_bin(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskDeleteVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.move_vm_to_recycle_bin_with_http_info(vm_operate_params, **kwargs)  # noqa: E501

    def move_vm_to_recycle_bin_with_http_info(self, vm_operate_params, **kwargs):  # noqa: E501
        """move_vm_to_recycle_bin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.move_vm_to_recycle_bin_with_http_info(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskDeleteVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_operate_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_vm_to_recycle_bin" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_operate_params' is set
        if self.api_client.client_side_validation and ('vm_operate_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_operate_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_operate_params` when calling `move_vm_to_recycle_bin`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_operate_params' in local_var_params:
            body_params = local_var_params['vm_operate_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskDeleteVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/move-vm-to-recycle', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def poweroff_vm(self, vm_operate_params, **kwargs):  # noqa: E501
        """poweroff_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.poweroff_vm(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.poweroff_vm_with_http_info(vm_operate_params, **kwargs)  # noqa: E501

    def poweroff_vm_with_http_info(self, vm_operate_params, **kwargs):  # noqa: E501
        """poweroff_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.poweroff_vm_with_http_info(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_operate_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method poweroff_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_operate_params' is set
        if self.api_client.client_side_validation and ('vm_operate_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_operate_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_operate_params` when calling `poweroff_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_operate_params' in local_var_params:
            body_params = local_var_params['vm_operate_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/poweroff-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def rebuild_vm(self, vm_rebuild_params, **kwargs):  # noqa: E501
        """rebuild_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rebuild_vm(vm_rebuild_params, async_req=True)
        >>> result = thread.get()

        :param vm_rebuild_params: (required)
        :type vm_rebuild_params: list[VmRebuildParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.rebuild_vm_with_http_info(vm_rebuild_params, **kwargs)  # noqa: E501

    def rebuild_vm_with_http_info(self, vm_rebuild_params, **kwargs):  # noqa: E501
        """rebuild_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rebuild_vm_with_http_info(vm_rebuild_params, async_req=True)
        >>> result = thread.get()

        :param vm_rebuild_params: (required)
        :type vm_rebuild_params: list[VmRebuildParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_rebuild_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rebuild_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_rebuild_params' is set
        if self.api_client.client_side_validation and ('vm_rebuild_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_rebuild_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_rebuild_params` when calling `rebuild_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_rebuild_params' in local_var_params:
            body_params = local_var_params['vm_rebuild_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/rebuild-vm-from-snapshot', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def recover_vm_from_recycle_bin(self, vm_operate_params, **kwargs):  # noqa: E501
        """recover_vm_from_recycle_bin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recover_vm_from_recycle_bin(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskDeleteVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.recover_vm_from_recycle_bin_with_http_info(vm_operate_params, **kwargs)  # noqa: E501

    def recover_vm_from_recycle_bin_with_http_info(self, vm_operate_params, **kwargs):  # noqa: E501
        """recover_vm_from_recycle_bin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recover_vm_from_recycle_bin_with_http_info(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskDeleteVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_operate_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recover_vm_from_recycle_bin" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_operate_params' is set
        if self.api_client.client_side_validation and ('vm_operate_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_operate_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_operate_params` when calling `recover_vm_from_recycle_bin`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_operate_params' in local_var_params:
            body_params = local_var_params['vm_operate_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskDeleteVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/recover-vm-from-recycle', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def remove_vm_cd_rom(self, vm_remove_cd_rom_params, **kwargs):  # noqa: E501
        """remove_vm_cd_rom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_cd_rom(vm_remove_cd_rom_params, async_req=True)
        >>> result = thread.get()

        :param vm_remove_cd_rom_params: (required)
        :type vm_remove_cd_rom_params: VmRemoveCdRomParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_vm_cd_rom_with_http_info(vm_remove_cd_rom_params, **kwargs)  # noqa: E501

    def remove_vm_cd_rom_with_http_info(self, vm_remove_cd_rom_params, **kwargs):  # noqa: E501
        """remove_vm_cd_rom  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_cd_rom_with_http_info(vm_remove_cd_rom_params, async_req=True)
        >>> result = thread.get()

        :param vm_remove_cd_rom_params: (required)
        :type vm_remove_cd_rom_params: VmRemoveCdRomParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_remove_cd_rom_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_vm_cd_rom" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_remove_cd_rom_params' is set
        if self.api_client.client_side_validation and ('vm_remove_cd_rom_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_remove_cd_rom_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_remove_cd_rom_params` when calling `remove_vm_cd_rom`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_remove_cd_rom_params' in local_var_params:
            body_params = local_var_params['vm_remove_cd_rom_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/remove-vm-cd-rom', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def remove_vm_disk(self, vm_remove_disk_params, **kwargs):  # noqa: E501
        """remove_vm_disk  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_disk(vm_remove_disk_params, async_req=True)
        >>> result = thread.get()

        :param vm_remove_disk_params: (required)
        :type vm_remove_disk_params: VmRemoveDiskParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_vm_disk_with_http_info(vm_remove_disk_params, **kwargs)  # noqa: E501

    def remove_vm_disk_with_http_info(self, vm_remove_disk_params, **kwargs):  # noqa: E501
        """remove_vm_disk  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_disk_with_http_info(vm_remove_disk_params, async_req=True)
        >>> result = thread.get()

        :param vm_remove_disk_params: (required)
        :type vm_remove_disk_params: VmRemoveDiskParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_remove_disk_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_vm_disk" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_remove_disk_params' is set
        if self.api_client.client_side_validation and ('vm_remove_disk_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_remove_disk_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_remove_disk_params` when calling `remove_vm_disk`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_remove_disk_params' in local_var_params:
            body_params = local_var_params['vm_remove_disk_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/remove-vm-disk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def remove_vm_gpu_device(self, vm_remove_gpu_device_params, **kwargs):  # noqa: E501
        """remove_vm_gpu_device  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_gpu_device(vm_remove_gpu_device_params, async_req=True)
        >>> result = thread.get()

        :param vm_remove_gpu_device_params: (required)
        :type vm_remove_gpu_device_params: VmRemoveGpuDeviceParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_vm_gpu_device_with_http_info(vm_remove_gpu_device_params, **kwargs)  # noqa: E501

    def remove_vm_gpu_device_with_http_info(self, vm_remove_gpu_device_params, **kwargs):  # noqa: E501
        """remove_vm_gpu_device  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_gpu_device_with_http_info(vm_remove_gpu_device_params, async_req=True)
        >>> result = thread.get()

        :param vm_remove_gpu_device_params: (required)
        :type vm_remove_gpu_device_params: VmRemoveGpuDeviceParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_remove_gpu_device_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_vm_gpu_device" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_remove_gpu_device_params' is set
        if self.api_client.client_side_validation and ('vm_remove_gpu_device_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_remove_gpu_device_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_remove_gpu_device_params` when calling `remove_vm_gpu_device`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_remove_gpu_device_params' in local_var_params:
            body_params = local_var_params['vm_remove_gpu_device_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/remove-vm-gpu-device', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def remove_vm_nic(self, vm_remove_nic_params, **kwargs):  # noqa: E501
        """remove_vm_nic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_nic(vm_remove_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_remove_nic_params: (required)
        :type vm_remove_nic_params: VmRemoveNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_vm_nic_with_http_info(vm_remove_nic_params, **kwargs)  # noqa: E501

    def remove_vm_nic_with_http_info(self, vm_remove_nic_params, **kwargs):  # noqa: E501
        """remove_vm_nic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_nic_with_http_info(vm_remove_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_remove_nic_params: (required)
        :type vm_remove_nic_params: VmRemoveNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_remove_nic_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_vm_nic" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_remove_nic_params' is set
        if self.api_client.client_side_validation and ('vm_remove_nic_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_remove_nic_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_remove_nic_params` when calling `remove_vm_nic`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_remove_nic_params' in local_var_params:
            body_params = local_var_params['vm_remove_nic_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/remove-vm-nic', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def remove_vm_nic_by_where(self, vm_remove_nic_by_where_params, **kwargs):  # noqa: E501
        """remove_vm_nic_by_where  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_nic_by_where(vm_remove_nic_by_where_params, async_req=True)
        >>> result = thread.get()

        :param vm_remove_nic_by_where_params: (required)
        :type vm_remove_nic_by_where_params: VmRemoveNicByWhereParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_vm_nic_by_where_with_http_info(vm_remove_nic_by_where_params, **kwargs)  # noqa: E501

    def remove_vm_nic_by_where_with_http_info(self, vm_remove_nic_by_where_params, **kwargs):  # noqa: E501
        """remove_vm_nic_by_where  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_nic_by_where_with_http_info(vm_remove_nic_by_where_params, async_req=True)
        >>> result = thread.get()

        :param vm_remove_nic_by_where_params: (required)
        :type vm_remove_nic_by_where_params: VmRemoveNicByWhereParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_remove_nic_by_where_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_vm_nic_by_where" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_remove_nic_by_where_params' is set
        if self.api_client.client_side_validation and ('vm_remove_nic_by_where_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_remove_nic_by_where_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_remove_nic_by_where_params` when calling `remove_vm_nic_by_where`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_remove_nic_by_where_params' in local_var_params:
            body_params = local_var_params['vm_remove_nic_by_where_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/remove-vm-nic-by-where', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def remove_vm_pci_nic(self, vm_operate_pci_nic_params, **kwargs):  # noqa: E501
        """remove_vm_pci_nic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_pci_nic(vm_operate_pci_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_pci_nic_params: (required)
        :type vm_operate_pci_nic_params: VmOperatePciNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_vm_pci_nic_with_http_info(vm_operate_pci_nic_params, **kwargs)  # noqa: E501

    def remove_vm_pci_nic_with_http_info(self, vm_operate_pci_nic_params, **kwargs):  # noqa: E501
        """remove_vm_pci_nic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_pci_nic_with_http_info(vm_operate_pci_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_pci_nic_params: (required)
        :type vm_operate_pci_nic_params: VmOperatePciNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_operate_pci_nic_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_vm_pci_nic" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_operate_pci_nic_params' is set
        if self.api_client.client_side_validation and ('vm_operate_pci_nic_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_operate_pci_nic_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_operate_pci_nic_params` when calling `remove_vm_pci_nic`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_operate_pci_nic_params' in local_var_params:
            body_params = local_var_params['vm_operate_pci_nic_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/remove-vm-pci-nic', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def remove_vm_to_folder(self, vm_operate_params, **kwargs):  # noqa: E501
        """remove_vm_to_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_to_folder(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_vm_to_folder_with_http_info(vm_operate_params, **kwargs)  # noqa: E501

    def remove_vm_to_folder_with_http_info(self, vm_operate_params, **kwargs):  # noqa: E501
        """remove_vm_to_folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_vm_to_folder_with_http_info(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_operate_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_vm_to_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_operate_params' is set
        if self.api_client.client_side_validation and ('vm_operate_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_operate_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_operate_params` when calling `remove_vm_to_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_operate_params' in local_var_params:
            body_params = local_var_params['vm_operate_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/remove-vm-from-folder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def reset_vm_guest_os_password(self, vm_reset_guest_os_password_params, **kwargs):  # noqa: E501
        """reset_vm_guest_os_password  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reset_vm_guest_os_password(vm_reset_guest_os_password_params, async_req=True)
        >>> result = thread.get()

        :param vm_reset_guest_os_password_params: (required)
        :type vm_reset_guest_os_password_params: VmResetGuestOsPasswordParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.reset_vm_guest_os_password_with_http_info(vm_reset_guest_os_password_params, **kwargs)  # noqa: E501

    def reset_vm_guest_os_password_with_http_info(self, vm_reset_guest_os_password_params, **kwargs):  # noqa: E501
        """reset_vm_guest_os_password  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reset_vm_guest_os_password_with_http_info(vm_reset_guest_os_password_params, async_req=True)
        >>> result = thread.get()

        :param vm_reset_guest_os_password_params: (required)
        :type vm_reset_guest_os_password_params: VmResetGuestOsPasswordParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_reset_guest_os_password_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_vm_guest_os_password" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_reset_guest_os_password_params' is set
        if self.api_client.client_side_validation and ('vm_reset_guest_os_password_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_reset_guest_os_password_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_reset_guest_os_password_params` when calling `reset_vm_guest_os_password`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_reset_guest_os_password_params' in local_var_params:
            body_params = local_var_params['vm_reset_guest_os_password_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/reset-vm-guest-os-password', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def restart_vm(self, vm_operate_params, **kwargs):  # noqa: E501
        """restart_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.restart_vm(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.restart_vm_with_http_info(vm_operate_params, **kwargs)  # noqa: E501

    def restart_vm_with_http_info(self, vm_operate_params, **kwargs):  # noqa: E501
        """restart_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.restart_vm_with_http_info(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_operate_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restart_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_operate_params' is set
        if self.api_client.client_side_validation and ('vm_operate_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_operate_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_operate_params` when calling `restart_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_operate_params' in local_var_params:
            body_params = local_var_params['vm_operate_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/restart-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def resume_vm(self, vm_operate_params, **kwargs):  # noqa: E501
        """resume_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.resume_vm(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.resume_vm_with_http_info(vm_operate_params, **kwargs)  # noqa: E501

    def resume_vm_with_http_info(self, vm_operate_params, **kwargs):  # noqa: E501
        """resume_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.resume_vm_with_http_info(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_operate_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resume_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_operate_params' is set
        if self.api_client.client_side_validation and ('vm_operate_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_operate_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_operate_params` when calling `resume_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_operate_params' in local_var_params:
            body_params = local_var_params['vm_operate_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/resume-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def rollback_vm(self, vm_rollback_params, **kwargs):  # noqa: E501
        """rollback_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rollback_vm(vm_rollback_params, async_req=True)
        >>> result = thread.get()

        :param vm_rollback_params: (required)
        :type vm_rollback_params: VmRollbackParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.rollback_vm_with_http_info(vm_rollback_params, **kwargs)  # noqa: E501

    def rollback_vm_with_http_info(self, vm_rollback_params, **kwargs):  # noqa: E501
        """rollback_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rollback_vm_with_http_info(vm_rollback_params, async_req=True)
        >>> result = thread.get()

        :param vm_rollback_params: (required)
        :type vm_rollback_params: VmRollbackParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_rollback_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rollback_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_rollback_params' is set
        if self.api_client.client_side_validation and ('vm_rollback_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_rollback_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_rollback_params` when calling `rollback_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_rollback_params' in local_var_params:
            body_params = local_var_params['vm_rollback_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/rollback-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def set_vm_disk_resident_in_cache(self, vm_set_vm_disk_resident_in_cache_params, **kwargs):  # noqa: E501
        """set_vm_disk_resident_in_cache  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_vm_disk_resident_in_cache(vm_set_vm_disk_resident_in_cache_params, async_req=True)
        >>> result = thread.get()

        :param vm_set_vm_disk_resident_in_cache_params: (required)
        :type vm_set_vm_disk_resident_in_cache_params: VmSetVmDiskResidentInCacheParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.set_vm_disk_resident_in_cache_with_http_info(vm_set_vm_disk_resident_in_cache_params, **kwargs)  # noqa: E501

    def set_vm_disk_resident_in_cache_with_http_info(self, vm_set_vm_disk_resident_in_cache_params, **kwargs):  # noqa: E501
        """set_vm_disk_resident_in_cache  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_vm_disk_resident_in_cache_with_http_info(vm_set_vm_disk_resident_in_cache_params, async_req=True)
        >>> result = thread.get()

        :param vm_set_vm_disk_resident_in_cache_params: (required)
        :type vm_set_vm_disk_resident_in_cache_params: VmSetVmDiskResidentInCacheParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_set_vm_disk_resident_in_cache_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_vm_disk_resident_in_cache" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_set_vm_disk_resident_in_cache_params' is set
        if self.api_client.client_side_validation and ('vm_set_vm_disk_resident_in_cache_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_set_vm_disk_resident_in_cache_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_set_vm_disk_resident_in_cache_params` when calling `set_vm_disk_resident_in_cache`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_set_vm_disk_resident_in_cache_params' in local_var_params:
            body_params = local_var_params['vm_set_vm_disk_resident_in_cache_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/set-vm-disk-resident-in-cache', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def shut_down_vm(self, vm_operate_params, **kwargs):  # noqa: E501
        """shut_down_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shut_down_vm(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.shut_down_vm_with_http_info(vm_operate_params, **kwargs)  # noqa: E501

    def shut_down_vm_with_http_info(self, vm_operate_params, **kwargs):  # noqa: E501
        """shut_down_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shut_down_vm_with_http_info(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_operate_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method shut_down_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_operate_params' is set
        if self.api_client.client_side_validation and ('vm_operate_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_operate_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_operate_params` when calling `shut_down_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_operate_params' in local_var_params:
            body_params = local_var_params['vm_operate_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/shutdown-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def start_vm(self, vm_start_params, **kwargs):  # noqa: E501
        """start_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.start_vm(vm_start_params, async_req=True)
        >>> result = thread.get()

        :param vm_start_params: (required)
        :type vm_start_params: VmStartParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.start_vm_with_http_info(vm_start_params, **kwargs)  # noqa: E501

    def start_vm_with_http_info(self, vm_start_params, **kwargs):  # noqa: E501
        """start_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.start_vm_with_http_info(vm_start_params, async_req=True)
        >>> result = thread.get()

        :param vm_start_params: (required)
        :type vm_start_params: VmStartParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_start_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_start_params' is set
        if self.api_client.client_side_validation and ('vm_start_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_start_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_start_params` when calling `start_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_start_params' in local_var_params:
            body_params = local_var_params['vm_start_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/start-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def stop_vm_in_cutover_migration(self, stop_vm_in_cutover_migration_params, **kwargs):  # noqa: E501
        """stop_vm_in_cutover_migration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stop_vm_in_cutover_migration(stop_vm_in_cutover_migration_params, async_req=True)
        >>> result = thread.get()

        :param stop_vm_in_cutover_migration_params: (required)
        :type stop_vm_in_cutover_migration_params: StopVmInCutoverMigrationParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.stop_vm_in_cutover_migration_with_http_info(stop_vm_in_cutover_migration_params, **kwargs)  # noqa: E501

    def stop_vm_in_cutover_migration_with_http_info(self, stop_vm_in_cutover_migration_params, **kwargs):  # noqa: E501
        """stop_vm_in_cutover_migration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stop_vm_in_cutover_migration_with_http_info(stop_vm_in_cutover_migration_params, async_req=True)
        >>> result = thread.get()

        :param stop_vm_in_cutover_migration_params: (required)
        :type stop_vm_in_cutover_migration_params: StopVmInCutoverMigrationParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'stop_vm_in_cutover_migration_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_vm_in_cutover_migration" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stop_vm_in_cutover_migration_params' is set
        if self.api_client.client_side_validation and ('stop_vm_in_cutover_migration_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['stop_vm_in_cutover_migration_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stop_vm_in_cutover_migration_params` when calling `stop_vm_in_cutover_migration`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stop_vm_in_cutover_migration_params' in local_var_params:
            body_params = local_var_params['stop_vm_in_cutover_migration_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/stop-vm-in-cutover-migration', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def suspend_vm(self, vm_operate_params, **kwargs):  # noqa: E501
        """suspend_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.suspend_vm(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.suspend_vm_with_http_info(vm_operate_params, **kwargs)  # noqa: E501

    def suspend_vm_with_http_info(self, vm_operate_params, **kwargs):  # noqa: E501
        """suspend_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.suspend_vm_with_http_info(vm_operate_params, async_req=True)
        >>> result = thread.get()

        :param vm_operate_params: (required)
        :type vm_operate_params: VmOperateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_operate_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method suspend_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_operate_params' is set
        if self.api_client.client_side_validation and ('vm_operate_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_operate_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_operate_params` when calling `suspend_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_operate_params' in local_var_params:
            body_params = local_var_params['vm_operate_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/suspend-vm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def toggle_vm_cd_rom_disable(self, vm_toggle_cd_rom_disable_params, **kwargs):  # noqa: E501
        """toggle_vm_cd_rom_disable  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.toggle_vm_cd_rom_disable(vm_toggle_cd_rom_disable_params, async_req=True)
        >>> result = thread.get()

        :param vm_toggle_cd_rom_disable_params: (required)
        :type vm_toggle_cd_rom_disable_params: VmToggleCdRomDisableParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.toggle_vm_cd_rom_disable_with_http_info(vm_toggle_cd_rom_disable_params, **kwargs)  # noqa: E501

    def toggle_vm_cd_rom_disable_with_http_info(self, vm_toggle_cd_rom_disable_params, **kwargs):  # noqa: E501
        """toggle_vm_cd_rom_disable  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.toggle_vm_cd_rom_disable_with_http_info(vm_toggle_cd_rom_disable_params, async_req=True)
        >>> result = thread.get()

        :param vm_toggle_cd_rom_disable_params: (required)
        :type vm_toggle_cd_rom_disable_params: VmToggleCdRomDisableParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_toggle_cd_rom_disable_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method toggle_vm_cd_rom_disable" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_toggle_cd_rom_disable_params' is set
        if self.api_client.client_side_validation and ('vm_toggle_cd_rom_disable_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_toggle_cd_rom_disable_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_toggle_cd_rom_disable_params` when calling `toggle_vm_cd_rom_disable`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_toggle_cd_rom_disable_params' in local_var_params:
            body_params = local_var_params['vm_toggle_cd_rom_disable_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/toggle-vm-cd-rom-disable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm(self, vm_update_params, **kwargs):  # noqa: E501
        """update_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm(vm_update_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_params: (required)
        :type vm_update_params: VmUpdateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_with_http_info(vm_update_params, **kwargs)  # noqa: E501

    def update_vm_with_http_info(self, vm_update_params, **kwargs):  # noqa: E501
        """update_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_with_http_info(vm_update_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_params: (required)
        :type vm_update_params: VmUpdateParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_update_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_update_params' is set
        if self.api_client.client_side_validation and ('vm_update_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_update_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_update_params` when calling `update_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_update_params' in local_var_params:
            body_params = local_var_params['vm_update_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-basic-info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm_advanced_options(self, vm_update_advanced_options_params, **kwargs):  # noqa: E501
        """update_vm_advanced_options  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_advanced_options(vm_update_advanced_options_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_advanced_options_params: (required)
        :type vm_update_advanced_options_params: VmUpdateAdvancedOptionsParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_advanced_options_with_http_info(vm_update_advanced_options_params, **kwargs)  # noqa: E501

    def update_vm_advanced_options_with_http_info(self, vm_update_advanced_options_params, **kwargs):  # noqa: E501
        """update_vm_advanced_options  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_advanced_options_with_http_info(vm_update_advanced_options_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_advanced_options_params: (required)
        :type vm_update_advanced_options_params: VmUpdateAdvancedOptionsParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_update_advanced_options_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_advanced_options" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_update_advanced_options_params' is set
        if self.api_client.client_side_validation and ('vm_update_advanced_options_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_update_advanced_options_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_update_advanced_options_params` when calling `update_vm_advanced_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_update_advanced_options_params' in local_var_params:
            body_params = local_var_params['vm_update_advanced_options_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-advanced-options', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm_disk(self, vm_update_disk_params, **kwargs):  # noqa: E501
        """update_vm_disk  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_disk(vm_update_disk_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_disk_params: (required)
        :type vm_update_disk_params: VmUpdateDiskParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_disk_with_http_info(vm_update_disk_params, **kwargs)  # noqa: E501

    def update_vm_disk_with_http_info(self, vm_update_disk_params, **kwargs):  # noqa: E501
        """update_vm_disk  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_disk_with_http_info(vm_update_disk_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_disk_params: (required)
        :type vm_update_disk_params: VmUpdateDiskParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_update_disk_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_disk" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_update_disk_params' is set
        if self.api_client.client_side_validation and ('vm_update_disk_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_update_disk_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_update_disk_params` when calling `update_vm_disk`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_update_disk_params' in local_var_params:
            body_params = local_var_params['vm_update_disk_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-disk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm_host_options(self, vm_update_host_options_params, **kwargs):  # noqa: E501
        """update_vm_host_options  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_host_options(vm_update_host_options_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_host_options_params: (required)
        :type vm_update_host_options_params: VmUpdateHostOptionsParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_host_options_with_http_info(vm_update_host_options_params, **kwargs)  # noqa: E501

    def update_vm_host_options_with_http_info(self, vm_update_host_options_params, **kwargs):  # noqa: E501
        """update_vm_host_options  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_host_options_with_http_info(vm_update_host_options_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_host_options_params: (required)
        :type vm_update_host_options_params: VmUpdateHostOptionsParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_update_host_options_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_host_options" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_update_host_options_params' is set
        if self.api_client.client_side_validation and ('vm_update_host_options_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_update_host_options_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_update_host_options_params` when calling `update_vm_host_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_update_host_options_params' in local_var_params:
            body_params = local_var_params['vm_update_host_options_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-host-options', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm_io_policy(self, vm_update_io_policy_params, **kwargs):  # noqa: E501
        """update_vm_io_policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_io_policy(vm_update_io_policy_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_io_policy_params: (required)
        :type vm_update_io_policy_params: VmUpdateIoPolicyParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_io_policy_with_http_info(vm_update_io_policy_params, **kwargs)  # noqa: E501

    def update_vm_io_policy_with_http_info(self, vm_update_io_policy_params, **kwargs):  # noqa: E501
        """update_vm_io_policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_io_policy_with_http_info(vm_update_io_policy_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_io_policy_params: (required)
        :type vm_update_io_policy_params: VmUpdateIoPolicyParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_update_io_policy_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_io_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_update_io_policy_params' is set
        if self.api_client.client_side_validation and ('vm_update_io_policy_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_update_io_policy_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_update_io_policy_params` when calling `update_vm_io_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_update_io_policy_params' in local_var_params:
            body_params = local_var_params['vm_update_io_policy_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-io-policy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm_nic(self, vm_update_nic_params, **kwargs):  # noqa: E501
        """update_vm_nic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_nic(vm_update_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_nic_params: (required)
        :type vm_update_nic_params: VmUpdateNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_nic_with_http_info(vm_update_nic_params, **kwargs)  # noqa: E501

    def update_vm_nic_with_http_info(self, vm_update_nic_params, **kwargs):  # noqa: E501
        """update_vm_nic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_nic_with_http_info(vm_update_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_nic_params: (required)
        :type vm_update_nic_params: VmUpdateNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_update_nic_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_nic" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_update_nic_params' is set
        if self.api_client.client_side_validation and ('vm_update_nic_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_update_nic_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_update_nic_params` when calling `update_vm_nic`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_update_nic_params' in local_var_params:
            body_params = local_var_params['vm_update_nic_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-nic', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm_nic_advance_info(self, vm_update_nic_advance_info_params, **kwargs):  # noqa: E501
        """update_vm_nic_advance_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_nic_advance_info(vm_update_nic_advance_info_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_nic_advance_info_params: (required)
        :type vm_update_nic_advance_info_params: VmUpdateNicAdvanceInfoParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_nic_advance_info_with_http_info(vm_update_nic_advance_info_params, **kwargs)  # noqa: E501

    def update_vm_nic_advance_info_with_http_info(self, vm_update_nic_advance_info_params, **kwargs):  # noqa: E501
        """update_vm_nic_advance_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_nic_advance_info_with_http_info(vm_update_nic_advance_info_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_nic_advance_info_params: (required)
        :type vm_update_nic_advance_info_params: VmUpdateNicAdvanceInfoParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_update_nic_advance_info_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_nic_advance_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_update_nic_advance_info_params' is set
        if self.api_client.client_side_validation and ('vm_update_nic_advance_info_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_update_nic_advance_info_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_update_nic_advance_info_params` when calling `update_vm_nic_advance_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_update_nic_advance_info_params' in local_var_params:
            body_params = local_var_params['vm_update_nic_advance_info_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-nic-advance-info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm_nic_basic_info(self, vm_update_nic_basic_info_params, **kwargs):  # noqa: E501
        """update_vm_nic_basic_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_nic_basic_info(vm_update_nic_basic_info_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_nic_basic_info_params: (required)
        :type vm_update_nic_basic_info_params: VmUpdateNicBasicInfoParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_nic_basic_info_with_http_info(vm_update_nic_basic_info_params, **kwargs)  # noqa: E501

    def update_vm_nic_basic_info_with_http_info(self, vm_update_nic_basic_info_params, **kwargs):  # noqa: E501
        """update_vm_nic_basic_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_nic_basic_info_with_http_info(vm_update_nic_basic_info_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_nic_basic_info_params: (required)
        :type vm_update_nic_basic_info_params: VmUpdateNicBasicInfoParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_update_nic_basic_info_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_nic_basic_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_update_nic_basic_info_params' is set
        if self.api_client.client_side_validation and ('vm_update_nic_basic_info_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_update_nic_basic_info_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_update_nic_basic_info_params` when calling `update_vm_nic_basic_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_update_nic_basic_info_params' in local_var_params:
            body_params = local_var_params['vm_update_nic_basic_info_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-nic-basic-info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm_nic_qos_option(self, vm_update_nic_qos_options_params, **kwargs):  # noqa: E501
        """update_vm_nic_qos_option  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_nic_qos_option(vm_update_nic_qos_options_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_nic_qos_options_params: (required)
        :type vm_update_nic_qos_options_params: VmUpdateNicQosOptionsParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_nic_qos_option_with_http_info(vm_update_nic_qos_options_params, **kwargs)  # noqa: E501

    def update_vm_nic_qos_option_with_http_info(self, vm_update_nic_qos_options_params, **kwargs):  # noqa: E501
        """update_vm_nic_qos_option  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_nic_qos_option_with_http_info(vm_update_nic_qos_options_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_nic_qos_options_params: (required)
        :type vm_update_nic_qos_options_params: VmUpdateNicQosOptionsParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_update_nic_qos_options_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_nic_qos_option" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_update_nic_qos_options_params' is set
        if self.api_client.client_side_validation and ('vm_update_nic_qos_options_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_update_nic_qos_options_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_update_nic_qos_options_params` when calling `update_vm_nic_qos_option`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_update_nic_qos_options_params' in local_var_params:
            body_params = local_var_params['vm_update_nic_qos_options_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-nic-qos-option', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm_nic_vpc_info(self, vm_update_vpc_nic_params, **kwargs):  # noqa: E501
        """update_vm_nic_vpc_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_nic_vpc_info(vm_update_vpc_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_vpc_nic_params: (required)
        :type vm_update_vpc_nic_params: VmUpdateVpcNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_nic_vpc_info_with_http_info(vm_update_vpc_nic_params, **kwargs)  # noqa: E501

    def update_vm_nic_vpc_info_with_http_info(self, vm_update_vpc_nic_params, **kwargs):  # noqa: E501
        """update_vm_nic_vpc_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_nic_vpc_info_with_http_info(vm_update_vpc_nic_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_vpc_nic_params: (required)
        :type vm_update_vpc_nic_params: VmUpdateVpcNicParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_update_vpc_nic_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_nic_vpc_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_update_vpc_nic_params' is set
        if self.api_client.client_side_validation and ('vm_update_vpc_nic_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_update_vpc_nic_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_update_vpc_nic_params` when calling `update_vm_nic_vpc_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_update_vpc_nic_params' in local_var_params:
            body_params = local_var_params['vm_update_vpc_nic_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-vpc-nic', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm_owner(self, vm_update_owner_params, **kwargs):  # noqa: E501
        """update_vm_owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_owner(vm_update_owner_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_owner_params: (required)
        :type vm_update_owner_params: VmUpdateOwnerParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVm]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_owner_with_http_info(vm_update_owner_params, **kwargs)  # noqa: E501

    def update_vm_owner_with_http_info(self, vm_update_owner_params, **kwargs):  # noqa: E501
        """update_vm_owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_owner_with_http_info(vm_update_owner_params, async_req=True)
        >>> result = thread.get()

        :param vm_update_owner_params: (required)
        :type vm_update_owner_params: VmUpdateOwnerParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_update_owner_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_owner" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_update_owner_params' is set
        if self.api_client.client_side_validation and ('vm_update_owner_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_update_owner_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_update_owner_params` when calling `update_vm_owner`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_update_owner_params' in local_var_params:
            body_params = local_var_params['vm_update_owner_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVm]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-owner', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
