# coding: utf-8
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudtower.api_client import ApiClient
from cloudtower.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class VmVolumeApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def clone_vm_volume(self, clone_vm_volume_params, **kwargs):  # noqa: E501
        """clone_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.clone_vm_volume(clone_vm_volume_params, async_req=True)
        >>> result = thread.get()

        :param clone_vm_volume_params: (required)
        :type clone_vm_volume_params: list[CloneVmVolumeParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVmVolume]
        """
        kwargs['_return_http_data_only'] = True
        return self.clone_vm_volume_with_http_info(clone_vm_volume_params, **kwargs)  # noqa: E501

    def clone_vm_volume_with_http_info(self, clone_vm_volume_params, **kwargs):  # noqa: E501
        """clone_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.clone_vm_volume_with_http_info(clone_vm_volume_params, async_req=True)
        >>> result = thread.get()

        :param clone_vm_volume_params: (required)
        :type clone_vm_volume_params: list[CloneVmVolumeParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVmVolume], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'clone_vm_volume_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_vm_volume" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'clone_vm_volume_params' is set
        if self.api_client.client_side_validation and ('clone_vm_volume_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['clone_vm_volume_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `clone_vm_volume_params` when calling `clone_vm_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'clone_vm_volume_params' in local_var_params:
            body_params = local_var_params['clone_vm_volume_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVmVolume]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/clone-vm-volume', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_vm_volume(self, vm_volume_creation_params, **kwargs):  # noqa: E501
        """create_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm_volume(vm_volume_creation_params, async_req=True)
        >>> result = thread.get()

        :param vm_volume_creation_params: (required)
        :type vm_volume_creation_params: list[VmVolumeCreationParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVmVolume]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_vm_volume_with_http_info(vm_volume_creation_params, **kwargs)  # noqa: E501

    def create_vm_volume_with_http_info(self, vm_volume_creation_params, **kwargs):  # noqa: E501
        """create_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm_volume_with_http_info(vm_volume_creation_params, async_req=True)
        >>> result = thread.get()

        :param vm_volume_creation_params: (required)
        :type vm_volume_creation_params: list[VmVolumeCreationParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVmVolume], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_volume_creation_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_vm_volume" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_volume_creation_params' is set
        if self.api_client.client_side_validation and ('vm_volume_creation_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_volume_creation_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_volume_creation_params` when calling `create_vm_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_volume_creation_params' in local_var_params:
            body_params = local_var_params['vm_volume_creation_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVmVolume]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/create-vm-volume', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_vm_volume_from_vm(self, vm_volume_deletion_params, **kwargs):  # noqa: E501
        """delete_vm_volume_from_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_vm_volume_from_vm(vm_volume_deletion_params, async_req=True)
        >>> result = thread.get()

        :param vm_volume_deletion_params: (required)
        :type vm_volume_deletion_params: VmVolumeDeletionParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskDeleteVmVolume]
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_vm_volume_from_vm_with_http_info(vm_volume_deletion_params, **kwargs)  # noqa: E501

    def delete_vm_volume_from_vm_with_http_info(self, vm_volume_deletion_params, **kwargs):  # noqa: E501
        """delete_vm_volume_from_vm  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_vm_volume_from_vm_with_http_info(vm_volume_deletion_params, async_req=True)
        >>> result = thread.get()

        :param vm_volume_deletion_params: (required)
        :type vm_volume_deletion_params: VmVolumeDeletionParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskDeleteVmVolume], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_volume_deletion_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_vm_volume_from_vm" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_volume_deletion_params' is set
        if self.api_client.client_side_validation and ('vm_volume_deletion_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_volume_deletion_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_volume_deletion_params` when calling `delete_vm_volume_from_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_volume_deletion_params' in local_var_params:
            body_params = local_var_params['vm_volume_deletion_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskDeleteVmVolume]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/delete-vm-volume', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def export_vm_volume(self, export_vm_volume_params, **kwargs):  # noqa: E501
        """export_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_vm_volume(export_vm_volume_params, async_req=True)
        >>> result = thread.get()

        :param export_vm_volume_params: (required)
        :type export_vm_volume_params: ExportVmVolumeParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVmExportFile]
        """
        kwargs['_return_http_data_only'] = True
        return self.export_vm_volume_with_http_info(export_vm_volume_params, **kwargs)  # noqa: E501

    def export_vm_volume_with_http_info(self, export_vm_volume_params, **kwargs):  # noqa: E501
        """export_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_vm_volume_with_http_info(export_vm_volume_params, async_req=True)
        >>> result = thread.get()

        :param export_vm_volume_params: (required)
        :type export_vm_volume_params: ExportVmVolumeParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVmExportFile], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'export_vm_volume_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_vm_volume" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'export_vm_volume_params' is set
        if self.api_client.client_side_validation and ('export_vm_volume_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['export_vm_volume_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `export_vm_volume_params` when calling `export_vm_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'export_vm_volume_params' in local_var_params:
            body_params = local_var_params['export_vm_volume_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVmExportFile]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/export-vm-volume', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_vm_volumes(self, get_vm_volumes_request_body, **kwargs):  # noqa: E501
        """get_vm_volumes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_volumes(get_vm_volumes_request_body, async_req=True)
        >>> result = thread.get()

        :param get_vm_volumes_request_body: (required)
        :type get_vm_volumes_request_body: GetVmVolumesRequestBody
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[VmVolume]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vm_volumes_with_http_info(get_vm_volumes_request_body, **kwargs)  # noqa: E501

    def get_vm_volumes_with_http_info(self, get_vm_volumes_request_body, **kwargs):  # noqa: E501
        """get_vm_volumes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_volumes_with_http_info(get_vm_volumes_request_body, async_req=True)
        >>> result = thread.get()

        :param get_vm_volumes_request_body: (required)
        :type get_vm_volumes_request_body: GetVmVolumesRequestBody
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[VmVolume], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_vm_volumes_request_body',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vm_volumes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_vm_volumes_request_body' is set
        if self.api_client.client_side_validation and ('get_vm_volumes_request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_vm_volumes_request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_vm_volumes_request_body` when calling `get_vm_volumes`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_vm_volumes_request_body' in local_var_params:
            body_params = local_var_params['get_vm_volumes_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[VmVolume]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-vm-volumes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_vm_volumes_connection(self, get_vm_volumes_connection_request_body, **kwargs):  # noqa: E501
        """get_vm_volumes_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_volumes_connection(get_vm_volumes_connection_request_body, async_req=True)
        >>> result = thread.get()

        :param get_vm_volumes_connection_request_body: (required)
        :type get_vm_volumes_connection_request_body: GetVmVolumesConnectionRequestBody
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VmVolumeConnection
        """
        kwargs['_return_http_data_only'] = True
        return self.get_vm_volumes_connection_with_http_info(get_vm_volumes_connection_request_body, **kwargs)  # noqa: E501

    def get_vm_volumes_connection_with_http_info(self, get_vm_volumes_connection_request_body, **kwargs):  # noqa: E501
        """get_vm_volumes_connection  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_volumes_connection_with_http_info(get_vm_volumes_connection_request_body, async_req=True)
        >>> result = thread.get()

        :param get_vm_volumes_connection_request_body: (required)
        :type get_vm_volumes_connection_request_body: GetVmVolumesConnectionRequestBody
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VmVolumeConnection, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'get_vm_volumes_connection_request_body',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vm_volumes_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'get_vm_volumes_connection_request_body' is set
        if self.api_client.client_side_validation and ('get_vm_volumes_connection_request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['get_vm_volumes_connection_request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `get_vm_volumes_connection_request_body` when calling `get_vm_volumes_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'get_vm_volumes_connection_request_body' in local_var_params:
            body_params = local_var_params['get_vm_volumes_connection_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "VmVolumeConnection",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/get-vm-volumes-connection', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def import_vm_volume(self, import_vm_volume_params, **kwargs):  # noqa: E501
        """import_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_vm_volume(import_vm_volume_params, async_req=True)
        >>> result = thread.get()

        :param import_vm_volume_params: (required)
        :type import_vm_volume_params: list[ImportVmVolumeParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVmVolume]
        """
        kwargs['_return_http_data_only'] = True
        return self.import_vm_volume_with_http_info(import_vm_volume_params, **kwargs)  # noqa: E501

    def import_vm_volume_with_http_info(self, import_vm_volume_params, **kwargs):  # noqa: E501
        """import_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_vm_volume_with_http_info(import_vm_volume_params, async_req=True)
        >>> result = thread.get()

        :param import_vm_volume_params: (required)
        :type import_vm_volume_params: list[ImportVmVolumeParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVmVolume], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'import_vm_volume_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_vm_volume" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'import_vm_volume_params' is set
        if self.api_client.client_side_validation and ('import_vm_volume_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['import_vm_volume_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `import_vm_volume_params` when calling `import_vm_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'import_vm_volume_params' in local_var_params:
            body_params = local_var_params['import_vm_volume_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVmVolume]",
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/import-vm-volume', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def rebuild_vm_volume(self, vm_volume_rebuild_params, **kwargs):  # noqa: E501
        """rebuild_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rebuild_vm_volume(vm_volume_rebuild_params, async_req=True)
        >>> result = thread.get()

        :param vm_volume_rebuild_params: (required)
        :type vm_volume_rebuild_params: list[VmVolumeRebuildParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVmVolume]
        """
        kwargs['_return_http_data_only'] = True
        return self.rebuild_vm_volume_with_http_info(vm_volume_rebuild_params, **kwargs)  # noqa: E501

    def rebuild_vm_volume_with_http_info(self, vm_volume_rebuild_params, **kwargs):  # noqa: E501
        """rebuild_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rebuild_vm_volume_with_http_info(vm_volume_rebuild_params, async_req=True)
        >>> result = thread.get()

        :param vm_volume_rebuild_params: (required)
        :type vm_volume_rebuild_params: list[VmVolumeRebuildParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVmVolume], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_volume_rebuild_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rebuild_vm_volume" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_volume_rebuild_params' is set
        if self.api_client.client_side_validation and ('vm_volume_rebuild_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_volume_rebuild_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_volume_rebuild_params` when calling `rebuild_vm_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_volume_rebuild_params' in local_var_params:
            body_params = local_var_params['vm_volume_rebuild_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVmVolume]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/rebuild-vm-volume', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def rollback_vm_volume(self, vm_volume_rollback_params, **kwargs):  # noqa: E501
        """rollback_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rollback_vm_volume(vm_volume_rollback_params, async_req=True)
        >>> result = thread.get()

        :param vm_volume_rollback_params: (required)
        :type vm_volume_rollback_params: list[VmVolumeRollbackParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVmVolume]
        """
        kwargs['_return_http_data_only'] = True
        return self.rollback_vm_volume_with_http_info(vm_volume_rollback_params, **kwargs)  # noqa: E501

    def rollback_vm_volume_with_http_info(self, vm_volume_rollback_params, **kwargs):  # noqa: E501
        """rollback_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rollback_vm_volume_with_http_info(vm_volume_rollback_params, async_req=True)
        >>> result = thread.get()

        :param vm_volume_rollback_params: (required)
        :type vm_volume_rollback_params: list[VmVolumeRollbackParams]
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVmVolume], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'vm_volume_rollback_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rollback_vm_volume" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'vm_volume_rollback_params' is set
        if self.api_client.client_side_validation and ('vm_volume_rollback_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['vm_volume_rollback_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `vm_volume_rollback_params` when calling `rollback_vm_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vm_volume_rollback_params' in local_var_params:
            body_params = local_var_params['vm_volume_rollback_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVmVolume]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/rollback-vm-volume', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_vm_volume(self, update_vm_volume_params, **kwargs):  # noqa: E501
        """update_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_volume(update_vm_volume_params, async_req=True)
        >>> result = thread.get()

        :param update_vm_volume_params: (required)
        :type update_vm_volume_params: UpdateVmVolumeParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[WithTaskVmVolume]
        """
        kwargs['_return_http_data_only'] = True
        return self.update_vm_volume_with_http_info(update_vm_volume_params, **kwargs)  # noqa: E501

    def update_vm_volume_with_http_info(self, update_vm_volume_params, **kwargs):  # noqa: E501
        """update_vm_volume  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_volume_with_http_info(update_vm_volume_params, async_req=True)
        >>> result = thread.get()

        :param update_vm_volume_params: (required)
        :type update_vm_volume_params: UpdateVmVolumeParams
        :param content_language:
        :type content_language: ContentLanguage
        :param external_cloudtower_id:
        :type external_cloudtower_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[WithTaskVmVolume], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'update_vm_volume_params',
            'content_language',
            'external_cloudtower_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_volume" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'update_vm_volume_params' is set
        if self.api_client.client_side_validation and ('update_vm_volume_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_vm_volume_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_vm_volume_params` when calling `update_vm_volume`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))
        if 'content_language' in local_var_params:
            header_params['content-language'] = local_var_params['content_language']  # noqa: E501
        if 'external_cloudtower_id' in local_var_params:
            header_params['external-cloudtower-id'] = local_var_params['external_cloudtower_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_vm_volume_params' in local_var_params:
            body_params = local_var_params['update_vm_volume_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        response_types_map = {
            200: "list[WithTaskVmVolume]",
            304: None,
            400: "ErrorBody",
            404: "ErrorBody",
            500: "ErrorBody",
        }

        return self.api_client.call_api(
            '/update-vm-volume', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
