# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class AlertRuleThresholds(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'value': 'int',
        'severity': 'SeverityEnum'
    }

    attribute_map = {
        'value': 'value',
        'severity': 'severity'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """AlertRuleThresholds - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._value = None
        self._severity = None
        self.discriminator = None

        if "value" in kwargs:
            self.value = kwargs["value"]
        if "severity" in kwargs:
            self.severity = kwargs["severity"]

    @property
    def value(self):
        """Gets the value of this AlertRuleThresholds.  # noqa: E501


        :return: The value of this AlertRuleThresholds.  # noqa: E501
        :rtype: int
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this AlertRuleThresholds.


        :param value: The value of this AlertRuleThresholds.  # noqa: E501
        :type value: int
        """
        if self.local_vars_configuration.client_side_validation and value is None:  # noqa: E501
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501

        self._value = value

    @property
    def severity(self):
        """Gets the severity of this AlertRuleThresholds.  # noqa: E501


        :return: The severity of this AlertRuleThresholds.  # noqa: E501
        :rtype: SeverityEnum
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this AlertRuleThresholds.


        :param severity: The severity of this AlertRuleThresholds.  # noqa: E501
        :type severity: SeverityEnum
        """
        if self.local_vars_configuration.client_side_validation and severity is None:  # noqa: E501
            raise ValueError("Invalid value for `severity`, must not be `None`")  # noqa: E501

        self._severity = severity

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AlertRuleThresholds):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AlertRuleThresholds):
            return True

        return self.to_dict() != other.to_dict()
