# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class AllocatableEcStorageCapacity(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'capacity': 'float',
        'm': 'int',
        'k': 'int'
    }

    attribute_map = {
        'capacity': 'capacity',
        'm': 'm',
        'k': 'k'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """AllocatableEcStorageCapacity - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._capacity = None
        self._m = None
        self._k = None
        self.discriminator = None

        if "capacity" in kwargs:
            self.capacity = kwargs["capacity"]
        if "m" in kwargs:
            self.m = kwargs["m"]
        if "k" in kwargs:
            self.k = kwargs["k"]

    @property
    def capacity(self):
        """Gets the capacity of this AllocatableEcStorageCapacity.  # noqa: E501


        :return: The capacity of this AllocatableEcStorageCapacity.  # noqa: E501
        :rtype: float
        """
        return self._capacity

    @capacity.setter
    def capacity(self, capacity):
        """Sets the capacity of this AllocatableEcStorageCapacity.


        :param capacity: The capacity of this AllocatableEcStorageCapacity.  # noqa: E501
        :type capacity: float
        """
        if self.local_vars_configuration.client_side_validation and capacity is None:  # noqa: E501
            raise ValueError("Invalid value for `capacity`, must not be `None`")  # noqa: E501

        self._capacity = capacity

    @property
    def m(self):
        """Gets the m of this AllocatableEcStorageCapacity.  # noqa: E501


        :return: The m of this AllocatableEcStorageCapacity.  # noqa: E501
        :rtype: int
        """
        return self._m

    @m.setter
    def m(self, m):
        """Sets the m of this AllocatableEcStorageCapacity.


        :param m: The m of this AllocatableEcStorageCapacity.  # noqa: E501
        :type m: int
        """
        if self.local_vars_configuration.client_side_validation and m is None:  # noqa: E501
            raise ValueError("Invalid value for `m`, must not be `None`")  # noqa: E501

        self._m = m

    @property
    def k(self):
        """Gets the k of this AllocatableEcStorageCapacity.  # noqa: E501


        :return: The k of this AllocatableEcStorageCapacity.  # noqa: E501
        :rtype: int
        """
        return self._k

    @k.setter
    def k(self, k):
        """Sets the k of this AllocatableEcStorageCapacity.


        :param k: The k of this AllocatableEcStorageCapacity.  # noqa: E501
        :type k: int
        """
        if self.local_vars_configuration.client_side_validation and k is None:  # noqa: E501
            raise ValueError("Invalid value for `k`, must not be `None`")  # noqa: E501

        self._k = k

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AllocatableEcStorageCapacity):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AllocatableEcStorageCapacity):
            return True

        return self.to_dict() != other.to_dict()
