# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class Application(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'NestedCluster',
        'error_message': 'str',
        'id': 'str',
        'image_name': 'str',
        'local_id': 'str',
        'memory': 'int',
        'state': 'ApplicationState',
        'storage_ip': 'str',
        'type': 'ApplicationType',
        'update_time': 'str',
        'vcpu': 'int',
        'version': 'str',
        'vm': 'NestedVm',
        'volume_size': 'int'
    }

    attribute_map = {
        'cluster': 'cluster',
        'error_message': 'error_message',
        'id': 'id',
        'image_name': 'image_name',
        'local_id': 'local_id',
        'memory': 'memory',
        'state': 'state',
        'storage_ip': 'storage_ip',
        'type': 'type',
        'update_time': 'update_time',
        'vcpu': 'vcpu',
        'version': 'version',
        'vm': 'vm',
        'volume_size': 'volume_size'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """Application - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster = None
        self._error_message = None
        self._id = None
        self._image_name = None
        self._local_id = None
        self._memory = None
        self._state = None
        self._storage_ip = None
        self._type = None
        self._update_time = None
        self._vcpu = None
        self._version = None
        self._vm = None
        self._volume_size = None
        self.discriminator = None

        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        self.error_message = kwargs.get("error_message", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.image_name = kwargs.get("image_name", None)
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "memory" in kwargs:
            self.memory = kwargs["memory"]
        if "state" in kwargs:
            self.state = kwargs["state"]
        if "storage_ip" in kwargs:
            self.storage_ip = kwargs["storage_ip"]
        if "type" in kwargs:
            self.type = kwargs["type"]
        self.update_time = kwargs.get("update_time", None)
        if "vcpu" in kwargs:
            self.vcpu = kwargs["vcpu"]
        if "version" in kwargs:
            self.version = kwargs["version"]
        self.vm = kwargs.get("vm", None)
        if "volume_size" in kwargs:
            self.volume_size = kwargs["volume_size"]

    @property
    def cluster(self):
        """Gets the cluster of this Application.  # noqa: E501


        :return: The cluster of this Application.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this Application.


        :param cluster: The cluster of this Application.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def error_message(self):
        """Gets the error_message of this Application.  # noqa: E501


        :return: The error_message of this Application.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """Sets the error_message of this Application.


        :param error_message: The error_message of this Application.  # noqa: E501
        :type error_message: str
        """

        self._error_message = error_message

    @property
    def id(self):
        """Gets the id of this Application.  # noqa: E501


        :return: The id of this Application.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Application.


        :param id: The id of this Application.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def image_name(self):
        """Gets the image_name of this Application.  # noqa: E501


        :return: The image_name of this Application.  # noqa: E501
        :rtype: str
        """
        return self._image_name

    @image_name.setter
    def image_name(self, image_name):
        """Sets the image_name of this Application.


        :param image_name: The image_name of this Application.  # noqa: E501
        :type image_name: str
        """

        self._image_name = image_name

    @property
    def local_id(self):
        """Gets the local_id of this Application.  # noqa: E501


        :return: The local_id of this Application.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this Application.


        :param local_id: The local_id of this Application.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def memory(self):
        """Gets the memory of this Application.  # noqa: E501


        :return: The memory of this Application.  # noqa: E501
        :rtype: int
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """Sets the memory of this Application.


        :param memory: The memory of this Application.  # noqa: E501
        :type memory: int
        """
        if self.local_vars_configuration.client_side_validation and memory is None:  # noqa: E501
            raise ValueError("Invalid value for `memory`, must not be `None`")  # noqa: E501

        self._memory = memory

    @property
    def state(self):
        """Gets the state of this Application.  # noqa: E501


        :return: The state of this Application.  # noqa: E501
        :rtype: ApplicationState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Application.


        :param state: The state of this Application.  # noqa: E501
        :type state: ApplicationState
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def storage_ip(self):
        """Gets the storage_ip of this Application.  # noqa: E501


        :return: The storage_ip of this Application.  # noqa: E501
        :rtype: str
        """
        return self._storage_ip

    @storage_ip.setter
    def storage_ip(self, storage_ip):
        """Sets the storage_ip of this Application.


        :param storage_ip: The storage_ip of this Application.  # noqa: E501
        :type storage_ip: str
        """
        if self.local_vars_configuration.client_side_validation and storage_ip is None:  # noqa: E501
            raise ValueError("Invalid value for `storage_ip`, must not be `None`")  # noqa: E501

        self._storage_ip = storage_ip

    @property
    def type(self):
        """Gets the type of this Application.  # noqa: E501


        :return: The type of this Application.  # noqa: E501
        :rtype: ApplicationType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Application.


        :param type: The type of this Application.  # noqa: E501
        :type type: ApplicationType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def update_time(self):
        """Gets the update_time of this Application.  # noqa: E501


        :return: The update_time of this Application.  # noqa: E501
        :rtype: str
        """
        return self._update_time

    @update_time.setter
    def update_time(self, update_time):
        """Sets the update_time of this Application.


        :param update_time: The update_time of this Application.  # noqa: E501
        :type update_time: str
        """

        self._update_time = update_time

    @property
    def vcpu(self):
        """Gets the vcpu of this Application.  # noqa: E501


        :return: The vcpu of this Application.  # noqa: E501
        :rtype: int
        """
        return self._vcpu

    @vcpu.setter
    def vcpu(self, vcpu):
        """Sets the vcpu of this Application.


        :param vcpu: The vcpu of this Application.  # noqa: E501
        :type vcpu: int
        """
        if self.local_vars_configuration.client_side_validation and vcpu is None:  # noqa: E501
            raise ValueError("Invalid value for `vcpu`, must not be `None`")  # noqa: E501

        self._vcpu = vcpu

    @property
    def version(self):
        """Gets the version of this Application.  # noqa: E501


        :return: The version of this Application.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Application.


        :param version: The version of this Application.  # noqa: E501
        :type version: str
        """
        if self.local_vars_configuration.client_side_validation and version is None:  # noqa: E501
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    @property
    def vm(self):
        """Gets the vm of this Application.  # noqa: E501


        :return: The vm of this Application.  # noqa: E501
        :rtype: NestedVm
        """
        return self._vm

    @vm.setter
    def vm(self, vm):
        """Sets the vm of this Application.


        :param vm: The vm of this Application.  # noqa: E501
        :type vm: NestedVm
        """

        self._vm = vm

    @property
    def volume_size(self):
        """Gets the volume_size of this Application.  # noqa: E501


        :return: The volume_size of this Application.  # noqa: E501
        :rtype: int
        """
        return self._volume_size

    @volume_size.setter
    def volume_size(self, volume_size):
        """Sets the volume_size of this Application.


        :param volume_size: The volume_size of this Application.  # noqa: E501
        :type volume_size: int
        """
        if self.local_vars_configuration.client_side_validation and volume_size is None:  # noqa: E501
            raise ValueError("Invalid value for `volume_size`, must not be `None`")  # noqa: E501

        self._volume_size = volume_size

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Application):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Application):
            return True

        return self.to_dict() != other.to_dict()
