# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ApplicationVmSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vm_usage': 'VmUsage',
        'storages': 'list[ApplicationVmSpecStorage]',
        'status': 'ApplicationVmSpecStatus',
        'public_keys': 'list[str]',
        'network': 'ApplicationVmSpecNetwork',
        'name': 'str',
        'memory_unit': 'ByteUnit',
        'memory': 'int',
        'internal': 'bool',
        'image': 'str',
        'host': 'str',
        'env': 'list[ApplicationVmSpecEnv]',
        'cpu': 'int',
        'cluster': 'str',
        'cloud_init_user_data': 'str'
    }

    attribute_map = {
        'vm_usage': 'vmUsage',
        'storages': 'storages',
        'status': 'status',
        'public_keys': 'publicKeys',
        'network': 'network',
        'name': 'name',
        'memory_unit': 'memory_unit',
        'memory': 'memory',
        'internal': 'internal',
        'image': 'image',
        'host': 'host',
        'env': 'env',
        'cpu': 'cpu',
        'cluster': 'cluster',
        'cloud_init_user_data': 'cloudInitUserData'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ApplicationVmSpec - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vm_usage = None
        self._storages = None
        self._status = None
        self._public_keys = None
        self._network = None
        self._name = None
        self._memory_unit = None
        self._memory = None
        self._internal = None
        self._image = None
        self._host = None
        self._env = None
        self._cpu = None
        self._cluster = None
        self._cloud_init_user_data = None
        self.discriminator = None

        if "vm_usage" in kwargs:
            self.vm_usage = kwargs["vm_usage"]
        if "storages" in kwargs:
            self.storages = kwargs["storages"]
        if "status" in kwargs:
            self.status = kwargs["status"]
        if "public_keys" in kwargs:
            self.public_keys = kwargs["public_keys"]
        if "network" in kwargs:
            self.network = kwargs["network"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "memory_unit" in kwargs:
            self.memory_unit = kwargs["memory_unit"]
        if "memory" in kwargs:
            self.memory = kwargs["memory"]
        if "internal" in kwargs:
            self.internal = kwargs["internal"]
        if "image" in kwargs:
            self.image = kwargs["image"]
        if "host" in kwargs:
            self.host = kwargs["host"]
        if "env" in kwargs:
            self.env = kwargs["env"]
        if "cpu" in kwargs:
            self.cpu = kwargs["cpu"]
        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        if "cloud_init_user_data" in kwargs:
            self.cloud_init_user_data = kwargs["cloud_init_user_data"]

    @property
    def vm_usage(self):
        """Gets the vm_usage of this ApplicationVmSpec.  # noqa: E501


        :return: The vm_usage of this ApplicationVmSpec.  # noqa: E501
        :rtype: VmUsage
        """
        return self._vm_usage

    @vm_usage.setter
    def vm_usage(self, vm_usage):
        """Sets the vm_usage of this ApplicationVmSpec.


        :param vm_usage: The vm_usage of this ApplicationVmSpec.  # noqa: E501
        :type vm_usage: VmUsage
        """

        self._vm_usage = vm_usage

    @property
    def storages(self):
        """Gets the storages of this ApplicationVmSpec.  # noqa: E501


        :return: The storages of this ApplicationVmSpec.  # noqa: E501
        :rtype: list[ApplicationVmSpecStorage]
        """
        return self._storages

    @storages.setter
    def storages(self, storages):
        """Sets the storages of this ApplicationVmSpec.


        :param storages: The storages of this ApplicationVmSpec.  # noqa: E501
        :type storages: list[ApplicationVmSpecStorage]
        """

        self._storages = storages

    @property
    def status(self):
        """Gets the status of this ApplicationVmSpec.  # noqa: E501


        :return: The status of this ApplicationVmSpec.  # noqa: E501
        :rtype: ApplicationVmSpecStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ApplicationVmSpec.


        :param status: The status of this ApplicationVmSpec.  # noqa: E501
        :type status: ApplicationVmSpecStatus
        """

        self._status = status

    @property
    def public_keys(self):
        """Gets the public_keys of this ApplicationVmSpec.  # noqa: E501


        :return: The public_keys of this ApplicationVmSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._public_keys

    @public_keys.setter
    def public_keys(self, public_keys):
        """Sets the public_keys of this ApplicationVmSpec.


        :param public_keys: The public_keys of this ApplicationVmSpec.  # noqa: E501
        :type public_keys: list[str]
        """

        self._public_keys = public_keys

    @property
    def network(self):
        """Gets the network of this ApplicationVmSpec.  # noqa: E501


        :return: The network of this ApplicationVmSpec.  # noqa: E501
        :rtype: ApplicationVmSpecNetwork
        """
        return self._network

    @network.setter
    def network(self, network):
        """Sets the network of this ApplicationVmSpec.


        :param network: The network of this ApplicationVmSpec.  # noqa: E501
        :type network: ApplicationVmSpecNetwork
        """

        self._network = network

    @property
    def name(self):
        """Gets the name of this ApplicationVmSpec.  # noqa: E501


        :return: The name of this ApplicationVmSpec.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ApplicationVmSpec.


        :param name: The name of this ApplicationVmSpec.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def memory_unit(self):
        """Gets the memory_unit of this ApplicationVmSpec.  # noqa: E501


        :return: The memory_unit of this ApplicationVmSpec.  # noqa: E501
        :rtype: ByteUnit
        """
        return self._memory_unit

    @memory_unit.setter
    def memory_unit(self, memory_unit):
        """Sets the memory_unit of this ApplicationVmSpec.


        :param memory_unit: The memory_unit of this ApplicationVmSpec.  # noqa: E501
        :type memory_unit: ByteUnit
        """

        self._memory_unit = memory_unit

    @property
    def memory(self):
        """Gets the memory of this ApplicationVmSpec.  # noqa: E501


        :return: The memory of this ApplicationVmSpec.  # noqa: E501
        :rtype: int
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """Sets the memory of this ApplicationVmSpec.


        :param memory: The memory of this ApplicationVmSpec.  # noqa: E501
        :type memory: int
        """

        self._memory = memory

    @property
    def internal(self):
        """Gets the internal of this ApplicationVmSpec.  # noqa: E501


        :return: The internal of this ApplicationVmSpec.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this ApplicationVmSpec.


        :param internal: The internal of this ApplicationVmSpec.  # noqa: E501
        :type internal: bool
        """

        self._internal = internal

    @property
    def image(self):
        """Gets the image of this ApplicationVmSpec.  # noqa: E501


        :return: The image of this ApplicationVmSpec.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this ApplicationVmSpec.


        :param image: The image of this ApplicationVmSpec.  # noqa: E501
        :type image: str
        """

        self._image = image

    @property
    def host(self):
        """Gets the host of this ApplicationVmSpec.  # noqa: E501


        :return: The host of this ApplicationVmSpec.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this ApplicationVmSpec.


        :param host: The host of this ApplicationVmSpec.  # noqa: E501
        :type host: str
        """

        self._host = host

    @property
    def env(self):
        """Gets the env of this ApplicationVmSpec.  # noqa: E501


        :return: The env of this ApplicationVmSpec.  # noqa: E501
        :rtype: list[ApplicationVmSpecEnv]
        """
        return self._env

    @env.setter
    def env(self, env):
        """Sets the env of this ApplicationVmSpec.


        :param env: The env of this ApplicationVmSpec.  # noqa: E501
        :type env: list[ApplicationVmSpecEnv]
        """

        self._env = env

    @property
    def cpu(self):
        """Gets the cpu of this ApplicationVmSpec.  # noqa: E501


        :return: The cpu of this ApplicationVmSpec.  # noqa: E501
        :rtype: int
        """
        return self._cpu

    @cpu.setter
    def cpu(self, cpu):
        """Sets the cpu of this ApplicationVmSpec.


        :param cpu: The cpu of this ApplicationVmSpec.  # noqa: E501
        :type cpu: int
        """

        self._cpu = cpu

    @property
    def cluster(self):
        """Gets the cluster of this ApplicationVmSpec.  # noqa: E501


        :return: The cluster of this ApplicationVmSpec.  # noqa: E501
        :rtype: str
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this ApplicationVmSpec.


        :param cluster: The cluster of this ApplicationVmSpec.  # noqa: E501
        :type cluster: str
        """

        self._cluster = cluster

    @property
    def cloud_init_user_data(self):
        """Gets the cloud_init_user_data of this ApplicationVmSpec.  # noqa: E501


        :return: The cloud_init_user_data of this ApplicationVmSpec.  # noqa: E501
        :rtype: str
        """
        return self._cloud_init_user_data

    @cloud_init_user_data.setter
    def cloud_init_user_data(self, cloud_init_user_data):
        """Sets the cloud_init_user_data of this ApplicationVmSpec.


        :param cloud_init_user_data: The cloud_init_user_data of this ApplicationVmSpec.  # noqa: E501
        :type cloud_init_user_data: str
        """

        self._cloud_init_user_data = cloud_init_user_data

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApplicationVmSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApplicationVmSpec):
            return True

        return self.to_dict() != other.to_dict()
