# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ApplicationVmSpecDefinition(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vm_affinity': 'ApplicationVmSpecAffinityPolicy',
        'placement': 'ApplicationVmSpecPlacement',
        'name': 'str',
        'group': 'str',
        'template': 'ApplicationVmSpec',
        'instances': 'list[ApplicationVmSpec]'
    }

    attribute_map = {
        'vm_affinity': 'vmAffinity',
        'placement': 'placement',
        'name': 'name',
        'group': 'group',
        'template': 'template',
        'instances': 'instances'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ApplicationVmSpecDefinition - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vm_affinity = None
        self._placement = None
        self._name = None
        self._group = None
        self._template = None
        self._instances = None
        self.discriminator = None

        if "vm_affinity" in kwargs:
            self.vm_affinity = kwargs["vm_affinity"]
        if "placement" in kwargs:
            self.placement = kwargs["placement"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "group" in kwargs:
            self.group = kwargs["group"]
        if "template" in kwargs:
            self.template = kwargs["template"]
        if "instances" in kwargs:
            self.instances = kwargs["instances"]

    @property
    def vm_affinity(self):
        """Gets the vm_affinity of this ApplicationVmSpecDefinition.  # noqa: E501


        :return: The vm_affinity of this ApplicationVmSpecDefinition.  # noqa: E501
        :rtype: ApplicationVmSpecAffinityPolicy
        """
        return self._vm_affinity

    @vm_affinity.setter
    def vm_affinity(self, vm_affinity):
        """Sets the vm_affinity of this ApplicationVmSpecDefinition.


        :param vm_affinity: The vm_affinity of this ApplicationVmSpecDefinition.  # noqa: E501
        :type vm_affinity: ApplicationVmSpecAffinityPolicy
        """

        self._vm_affinity = vm_affinity

    @property
    def placement(self):
        """Gets the placement of this ApplicationVmSpecDefinition.  # noqa: E501


        :return: The placement of this ApplicationVmSpecDefinition.  # noqa: E501
        :rtype: ApplicationVmSpecPlacement
        """
        return self._placement

    @placement.setter
    def placement(self, placement):
        """Sets the placement of this ApplicationVmSpecDefinition.


        :param placement: The placement of this ApplicationVmSpecDefinition.  # noqa: E501
        :type placement: ApplicationVmSpecPlacement
        """

        self._placement = placement

    @property
    def name(self):
        """Gets the name of this ApplicationVmSpecDefinition.  # noqa: E501


        :return: The name of this ApplicationVmSpecDefinition.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ApplicationVmSpecDefinition.


        :param name: The name of this ApplicationVmSpecDefinition.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def group(self):
        """Gets the group of this ApplicationVmSpecDefinition.  # noqa: E501


        :return: The group of this ApplicationVmSpecDefinition.  # noqa: E501
        :rtype: str
        """
        return self._group

    @group.setter
    def group(self, group):
        """Sets the group of this ApplicationVmSpecDefinition.


        :param group: The group of this ApplicationVmSpecDefinition.  # noqa: E501
        :type group: str
        """

        self._group = group

    @property
    def template(self):
        """Gets the template of this ApplicationVmSpecDefinition.  # noqa: E501


        :return: The template of this ApplicationVmSpecDefinition.  # noqa: E501
        :rtype: ApplicationVmSpec
        """
        return self._template

    @template.setter
    def template(self, template):
        """Sets the template of this ApplicationVmSpecDefinition.


        :param template: The template of this ApplicationVmSpecDefinition.  # noqa: E501
        :type template: ApplicationVmSpec
        """

        self._template = template

    @property
    def instances(self):
        """Gets the instances of this ApplicationVmSpecDefinition.  # noqa: E501


        :return: The instances of this ApplicationVmSpecDefinition.  # noqa: E501
        :rtype: list[ApplicationVmSpec]
        """
        return self._instances

    @instances.setter
    def instances(self, instances):
        """Sets the instances of this ApplicationVmSpecDefinition.


        :param instances: The instances of this ApplicationVmSpecDefinition.  # noqa: E501
        :type instances: list[ApplicationVmSpec]
        """

        self._instances = instances

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApplicationVmSpecDefinition):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApplicationVmSpecDefinition):
            return True

        return self.to_dict() != other.to_dict()
