# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ApplicationVmSpecNic(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vlan_id': 'str',
        'mask': 'str',
        'ip': 'str',
        'gateway': 'str',
        'dhcp': 'bool'
    }

    attribute_map = {
        'vlan_id': 'vlanId',
        'mask': 'mask',
        'ip': 'ip',
        'gateway': 'gateway',
        'dhcp': 'dhcp'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ApplicationVmSpecNic - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vlan_id = None
        self._mask = None
        self._ip = None
        self._gateway = None
        self._dhcp = None
        self.discriminator = None

        if "vlan_id" in kwargs:
            self.vlan_id = kwargs["vlan_id"]
        if "mask" in kwargs:
            self.mask = kwargs["mask"]
        if "ip" in kwargs:
            self.ip = kwargs["ip"]
        if "gateway" in kwargs:
            self.gateway = kwargs["gateway"]
        if "dhcp" in kwargs:
            self.dhcp = kwargs["dhcp"]

    @property
    def vlan_id(self):
        """Gets the vlan_id of this ApplicationVmSpecNic.  # noqa: E501


        :return: The vlan_id of this ApplicationVmSpecNic.  # noqa: E501
        :rtype: str
        """
        return self._vlan_id

    @vlan_id.setter
    def vlan_id(self, vlan_id):
        """Sets the vlan_id of this ApplicationVmSpecNic.


        :param vlan_id: The vlan_id of this ApplicationVmSpecNic.  # noqa: E501
        :type vlan_id: str
        """

        self._vlan_id = vlan_id

    @property
    def mask(self):
        """Gets the mask of this ApplicationVmSpecNic.  # noqa: E501


        :return: The mask of this ApplicationVmSpecNic.  # noqa: E501
        :rtype: str
        """
        return self._mask

    @mask.setter
    def mask(self, mask):
        """Sets the mask of this ApplicationVmSpecNic.


        :param mask: The mask of this ApplicationVmSpecNic.  # noqa: E501
        :type mask: str
        """

        self._mask = mask

    @property
    def ip(self):
        """Gets the ip of this ApplicationVmSpecNic.  # noqa: E501


        :return: The ip of this ApplicationVmSpecNic.  # noqa: E501
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """Sets the ip of this ApplicationVmSpecNic.


        :param ip: The ip of this ApplicationVmSpecNic.  # noqa: E501
        :type ip: str
        """

        self._ip = ip

    @property
    def gateway(self):
        """Gets the gateway of this ApplicationVmSpecNic.  # noqa: E501


        :return: The gateway of this ApplicationVmSpecNic.  # noqa: E501
        :rtype: str
        """
        return self._gateway

    @gateway.setter
    def gateway(self, gateway):
        """Sets the gateway of this ApplicationVmSpecNic.


        :param gateway: The gateway of this ApplicationVmSpecNic.  # noqa: E501
        :type gateway: str
        """

        self._gateway = gateway

    @property
    def dhcp(self):
        """Gets the dhcp of this ApplicationVmSpecNic.  # noqa: E501


        :return: The dhcp of this ApplicationVmSpecNic.  # noqa: E501
        :rtype: bool
        """
        return self._dhcp

    @dhcp.setter
    def dhcp(self, dhcp):
        """Sets the dhcp of this ApplicationVmSpecNic.


        :param dhcp: The dhcp of this ApplicationVmSpecNic.  # noqa: E501
        :type dhcp: bool
        """

        self._dhcp = dhcp

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApplicationVmSpecNic):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApplicationVmSpecNic):
            return True

        return self.to_dict() != other.to_dict()
