# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ApplicationVmSpecStatus(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vm_ips': 'list[str]',
        'message': 'VmStatus'
    }

    attribute_map = {
        'vm_ips': 'vmIps',
        'message': 'message'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ApplicationVmSpecStatus - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vm_ips = None
        self._message = None
        self.discriminator = None

        if "vm_ips" in kwargs:
            self.vm_ips = kwargs["vm_ips"]
        if "message" in kwargs:
            self.message = kwargs["message"]

    @property
    def vm_ips(self):
        """Gets the vm_ips of this ApplicationVmSpecStatus.  # noqa: E501


        :return: The vm_ips of this ApplicationVmSpecStatus.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_ips

    @vm_ips.setter
    def vm_ips(self, vm_ips):
        """Sets the vm_ips of this ApplicationVmSpecStatus.


        :param vm_ips: The vm_ips of this ApplicationVmSpecStatus.  # noqa: E501
        :type vm_ips: list[str]
        """

        self._vm_ips = vm_ips

    @property
    def message(self):
        """Gets the message of this ApplicationVmSpecStatus.  # noqa: E501


        :return: The message of this ApplicationVmSpecStatus.  # noqa: E501
        :rtype: VmStatus
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this ApplicationVmSpecStatus.


        :param message: The message of this ApplicationVmSpecStatus.  # noqa: E501
        :type message: VmStatus
        """

        self._message = message

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApplicationVmSpecStatus):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApplicationVmSpecStatus):
            return True

        return self.to_dict() != other.to_dict()
