# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupPlan(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'backup_delay_option': 'BackupPlanDelayOption',
        'backup_plan_executions': 'list[NestedBackupPlanExecution]',
        'backup_restore_point_count': 'int',
        'backup_restore_points': 'list[NestedBackupRestorePoint]',
        'backup_service': 'NestedBackupService',
        'backup_store_repository': 'NestedBackupStoreRepository',
        'backup_total_size': 'int',
        'compression': 'bool',
        'compression_ratio': 'float',
        'created_at': 'str',
        'delete_strategy': 'BackupPlanDeleteStrategy',
        'description': 'str',
        'enable_window': 'bool',
        'entity_async_status': 'EntityAsyncStatus',
        'full_interval': 'int',
        'full_period': 'BackupPlanPeriod',
        'full_time_point': 'NestedBackupPlanTimePoint',
        'id': 'str',
        'incremental_interval': 'int',
        'incremental_period': 'BackupPlanPeriod',
        'incremental_time_points': 'list[NestedBackupPlanTimePoint]',
        'incremental_weekdays': 'list[WeekdayTypeEnum]',
        'keep_policy': 'BackupPlanKeepPolicy',
        'keep_policy_value': 'int',
        'last_execute_status': 'BackupPlanExecutionStatus',
        'last_execute_status_message': 'str',
        'last_execute_success_job_count': 'int',
        'last_execute_total_job_count': 'int',
        'last_executed_at': 'str',
        'last_manual_execute_status': 'BackupPlanExecutionStatus',
        'last_manual_execute_status_message': 'str',
        'last_manual_execute_success_job_count': 'int',
        'last_manual_execute_total_job_count': 'int',
        'last_manual_executed_at': 'str',
        'logical_size': 'int',
        'name': 'str',
        'next_execute_time': 'str',
        'phase': 'BackupPlanPhase',
        'physical_size': 'int',
        'snapshot_consistent_type': 'ConsistentType',
        'status': 'BackupPlanStatus',
        'valid_size_of_backup_object': 'int',
        'valid_size_of_restore_point': 'int',
        'vms': 'list[NestedVm]',
        'window_end': 'str',
        'window_start': 'str'
    }

    attribute_map = {
        'backup_delay_option': 'backup_delay_option',
        'backup_plan_executions': 'backup_plan_executions',
        'backup_restore_point_count': 'backup_restore_point_count',
        'backup_restore_points': 'backup_restore_points',
        'backup_service': 'backup_service',
        'backup_store_repository': 'backup_store_repository',
        'backup_total_size': 'backup_total_size',
        'compression': 'compression',
        'compression_ratio': 'compression_ratio',
        'created_at': 'createdAt',
        'delete_strategy': 'delete_strategy',
        'description': 'description',
        'enable_window': 'enable_window',
        'entity_async_status': 'entityAsyncStatus',
        'full_interval': 'full_interval',
        'full_period': 'full_period',
        'full_time_point': 'full_time_point',
        'id': 'id',
        'incremental_interval': 'incremental_interval',
        'incremental_period': 'incremental_period',
        'incremental_time_points': 'incremental_time_points',
        'incremental_weekdays': 'incremental_weekdays',
        'keep_policy': 'keep_policy',
        'keep_policy_value': 'keep_policy_value',
        'last_execute_status': 'last_execute_status',
        'last_execute_status_message': 'last_execute_status_message',
        'last_execute_success_job_count': 'last_execute_success_job_count',
        'last_execute_total_job_count': 'last_execute_total_job_count',
        'last_executed_at': 'last_executed_at',
        'last_manual_execute_status': 'last_manual_execute_status',
        'last_manual_execute_status_message': 'last_manual_execute_status_message',
        'last_manual_execute_success_job_count': 'last_manual_execute_success_job_count',
        'last_manual_execute_total_job_count': 'last_manual_execute_total_job_count',
        'last_manual_executed_at': 'last_manual_executed_at',
        'logical_size': 'logical_size',
        'name': 'name',
        'next_execute_time': 'next_execute_time',
        'phase': 'phase',
        'physical_size': 'physical_size',
        'snapshot_consistent_type': 'snapshot_consistent_type',
        'status': 'status',
        'valid_size_of_backup_object': 'valid_size_of_backup_object',
        'valid_size_of_restore_point': 'valid_size_of_restore_point',
        'vms': 'vms',
        'window_end': 'window_end',
        'window_start': 'window_start'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupPlan - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._backup_delay_option = None
        self._backup_plan_executions = None
        self._backup_restore_point_count = None
        self._backup_restore_points = None
        self._backup_service = None
        self._backup_store_repository = None
        self._backup_total_size = None
        self._compression = None
        self._compression_ratio = None
        self._created_at = None
        self._delete_strategy = None
        self._description = None
        self._enable_window = None
        self._entity_async_status = None
        self._full_interval = None
        self._full_period = None
        self._full_time_point = None
        self._id = None
        self._incremental_interval = None
        self._incremental_period = None
        self._incremental_time_points = None
        self._incremental_weekdays = None
        self._keep_policy = None
        self._keep_policy_value = None
        self._last_execute_status = None
        self._last_execute_status_message = None
        self._last_execute_success_job_count = None
        self._last_execute_total_job_count = None
        self._last_executed_at = None
        self._last_manual_execute_status = None
        self._last_manual_execute_status_message = None
        self._last_manual_execute_success_job_count = None
        self._last_manual_execute_total_job_count = None
        self._last_manual_executed_at = None
        self._logical_size = None
        self._name = None
        self._next_execute_time = None
        self._phase = None
        self._physical_size = None
        self._snapshot_consistent_type = None
        self._status = None
        self._valid_size_of_backup_object = None
        self._valid_size_of_restore_point = None
        self._vms = None
        self._window_end = None
        self._window_start = None
        self.discriminator = None

        self.backup_delay_option = kwargs.get("backup_delay_option", None)
        self.backup_plan_executions = kwargs.get("backup_plan_executions", None)
        self.backup_restore_point_count = kwargs.get("backup_restore_point_count", None)
        self.backup_restore_points = kwargs.get("backup_restore_points", None)
        if "backup_service" in kwargs:
            self.backup_service = kwargs["backup_service"]
        if "backup_store_repository" in kwargs:
            self.backup_store_repository = kwargs["backup_store_repository"]
        self.backup_total_size = kwargs.get("backup_total_size", None)
        self.compression = kwargs.get("compression", None)
        self.compression_ratio = kwargs.get("compression_ratio", None)
        if "created_at" in kwargs:
            self.created_at = kwargs["created_at"]
        self.delete_strategy = kwargs.get("delete_strategy", None)
        self.description = kwargs.get("description", None)
        if "enable_window" in kwargs:
            self.enable_window = kwargs["enable_window"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "full_interval" in kwargs:
            self.full_interval = kwargs["full_interval"]
        if "full_period" in kwargs:
            self.full_period = kwargs["full_period"]
        if "full_time_point" in kwargs:
            self.full_time_point = kwargs["full_time_point"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.incremental_interval = kwargs.get("incremental_interval", None)
        if "incremental_period" in kwargs:
            self.incremental_period = kwargs["incremental_period"]
        if "incremental_time_points" in kwargs:
            self.incremental_time_points = kwargs["incremental_time_points"]
        self.incremental_weekdays = kwargs.get("incremental_weekdays", None)
        self.keep_policy = kwargs.get("keep_policy", None)
        self.keep_policy_value = kwargs.get("keep_policy_value", None)
        if "last_execute_status" in kwargs:
            self.last_execute_status = kwargs["last_execute_status"]
        self.last_execute_status_message = kwargs.get("last_execute_status_message", None)
        self.last_execute_success_job_count = kwargs.get("last_execute_success_job_count", None)
        self.last_execute_total_job_count = kwargs.get("last_execute_total_job_count", None)
        self.last_executed_at = kwargs.get("last_executed_at", None)
        if "last_manual_execute_status" in kwargs:
            self.last_manual_execute_status = kwargs["last_manual_execute_status"]
        self.last_manual_execute_status_message = kwargs.get("last_manual_execute_status_message", None)
        self.last_manual_execute_success_job_count = kwargs.get("last_manual_execute_success_job_count", None)
        self.last_manual_execute_total_job_count = kwargs.get("last_manual_execute_total_job_count", None)
        self.last_manual_executed_at = kwargs.get("last_manual_executed_at", None)
        if "logical_size" in kwargs:
            self.logical_size = kwargs["logical_size"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.next_execute_time = kwargs.get("next_execute_time", None)
        self.phase = kwargs.get("phase", None)
        if "physical_size" in kwargs:
            self.physical_size = kwargs["physical_size"]
        self.snapshot_consistent_type = kwargs.get("snapshot_consistent_type", None)
        if "status" in kwargs:
            self.status = kwargs["status"]
        if "valid_size_of_backup_object" in kwargs:
            self.valid_size_of_backup_object = kwargs["valid_size_of_backup_object"]
        if "valid_size_of_restore_point" in kwargs:
            self.valid_size_of_restore_point = kwargs["valid_size_of_restore_point"]
        self.vms = kwargs.get("vms", None)
        self.window_end = kwargs.get("window_end", None)
        self.window_start = kwargs.get("window_start", None)

    @property
    def backup_delay_option(self):
        """Gets the backup_delay_option of this BackupPlan.  # noqa: E501


        :return: The backup_delay_option of this BackupPlan.  # noqa: E501
        :rtype: BackupPlanDelayOption
        """
        return self._backup_delay_option

    @backup_delay_option.setter
    def backup_delay_option(self, backup_delay_option):
        """Sets the backup_delay_option of this BackupPlan.


        :param backup_delay_option: The backup_delay_option of this BackupPlan.  # noqa: E501
        :type backup_delay_option: BackupPlanDelayOption
        """

        self._backup_delay_option = backup_delay_option

    @property
    def backup_plan_executions(self):
        """Gets the backup_plan_executions of this BackupPlan.  # noqa: E501


        :return: The backup_plan_executions of this BackupPlan.  # noqa: E501
        :rtype: list[NestedBackupPlanExecution]
        """
        return self._backup_plan_executions

    @backup_plan_executions.setter
    def backup_plan_executions(self, backup_plan_executions):
        """Sets the backup_plan_executions of this BackupPlan.


        :param backup_plan_executions: The backup_plan_executions of this BackupPlan.  # noqa: E501
        :type backup_plan_executions: list[NestedBackupPlanExecution]
        """

        self._backup_plan_executions = backup_plan_executions

    @property
    def backup_restore_point_count(self):
        """Gets the backup_restore_point_count of this BackupPlan.  # noqa: E501


        :return: The backup_restore_point_count of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._backup_restore_point_count

    @backup_restore_point_count.setter
    def backup_restore_point_count(self, backup_restore_point_count):
        """Sets the backup_restore_point_count of this BackupPlan.


        :param backup_restore_point_count: The backup_restore_point_count of this BackupPlan.  # noqa: E501
        :type backup_restore_point_count: int
        """

        self._backup_restore_point_count = backup_restore_point_count

    @property
    def backup_restore_points(self):
        """Gets the backup_restore_points of this BackupPlan.  # noqa: E501


        :return: The backup_restore_points of this BackupPlan.  # noqa: E501
        :rtype: list[NestedBackupRestorePoint]
        """
        return self._backup_restore_points

    @backup_restore_points.setter
    def backup_restore_points(self, backup_restore_points):
        """Sets the backup_restore_points of this BackupPlan.


        :param backup_restore_points: The backup_restore_points of this BackupPlan.  # noqa: E501
        :type backup_restore_points: list[NestedBackupRestorePoint]
        """

        self._backup_restore_points = backup_restore_points

    @property
    def backup_service(self):
        """Gets the backup_service of this BackupPlan.  # noqa: E501


        :return: The backup_service of this BackupPlan.  # noqa: E501
        :rtype: NestedBackupService
        """
        return self._backup_service

    @backup_service.setter
    def backup_service(self, backup_service):
        """Sets the backup_service of this BackupPlan.


        :param backup_service: The backup_service of this BackupPlan.  # noqa: E501
        :type backup_service: NestedBackupService
        """
        if self.local_vars_configuration.client_side_validation and backup_service is None:  # noqa: E501
            raise ValueError("Invalid value for `backup_service`, must not be `None`")  # noqa: E501

        self._backup_service = backup_service

    @property
    def backup_store_repository(self):
        """Gets the backup_store_repository of this BackupPlan.  # noqa: E501


        :return: The backup_store_repository of this BackupPlan.  # noqa: E501
        :rtype: NestedBackupStoreRepository
        """
        return self._backup_store_repository

    @backup_store_repository.setter
    def backup_store_repository(self, backup_store_repository):
        """Sets the backup_store_repository of this BackupPlan.


        :param backup_store_repository: The backup_store_repository of this BackupPlan.  # noqa: E501
        :type backup_store_repository: NestedBackupStoreRepository
        """
        if self.local_vars_configuration.client_side_validation and backup_store_repository is None:  # noqa: E501
            raise ValueError("Invalid value for `backup_store_repository`, must not be `None`")  # noqa: E501

        self._backup_store_repository = backup_store_repository

    @property
    def backup_total_size(self):
        """Gets the backup_total_size of this BackupPlan.  # noqa: E501


        :return: The backup_total_size of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._backup_total_size

    @backup_total_size.setter
    def backup_total_size(self, backup_total_size):
        """Sets the backup_total_size of this BackupPlan.


        :param backup_total_size: The backup_total_size of this BackupPlan.  # noqa: E501
        :type backup_total_size: int
        """

        self._backup_total_size = backup_total_size

    @property
    def compression(self):
        """Gets the compression of this BackupPlan.  # noqa: E501


        :return: The compression of this BackupPlan.  # noqa: E501
        :rtype: bool
        """
        return self._compression

    @compression.setter
    def compression(self, compression):
        """Sets the compression of this BackupPlan.


        :param compression: The compression of this BackupPlan.  # noqa: E501
        :type compression: bool
        """

        self._compression = compression

    @property
    def compression_ratio(self):
        """Gets the compression_ratio of this BackupPlan.  # noqa: E501


        :return: The compression_ratio of this BackupPlan.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio

    @compression_ratio.setter
    def compression_ratio(self, compression_ratio):
        """Sets the compression_ratio of this BackupPlan.


        :param compression_ratio: The compression_ratio of this BackupPlan.  # noqa: E501
        :type compression_ratio: float
        """

        self._compression_ratio = compression_ratio

    @property
    def created_at(self):
        """Gets the created_at of this BackupPlan.  # noqa: E501


        :return: The created_at of this BackupPlan.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this BackupPlan.


        :param created_at: The created_at of this BackupPlan.  # noqa: E501
        :type created_at: str
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def delete_strategy(self):
        """Gets the delete_strategy of this BackupPlan.  # noqa: E501


        :return: The delete_strategy of this BackupPlan.  # noqa: E501
        :rtype: BackupPlanDeleteStrategy
        """
        return self._delete_strategy

    @delete_strategy.setter
    def delete_strategy(self, delete_strategy):
        """Sets the delete_strategy of this BackupPlan.


        :param delete_strategy: The delete_strategy of this BackupPlan.  # noqa: E501
        :type delete_strategy: BackupPlanDeleteStrategy
        """

        self._delete_strategy = delete_strategy

    @property
    def description(self):
        """Gets the description of this BackupPlan.  # noqa: E501


        :return: The description of this BackupPlan.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BackupPlan.


        :param description: The description of this BackupPlan.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def enable_window(self):
        """Gets the enable_window of this BackupPlan.  # noqa: E501


        :return: The enable_window of this BackupPlan.  # noqa: E501
        :rtype: bool
        """
        return self._enable_window

    @enable_window.setter
    def enable_window(self, enable_window):
        """Sets the enable_window of this BackupPlan.


        :param enable_window: The enable_window of this BackupPlan.  # noqa: E501
        :type enable_window: bool
        """
        if self.local_vars_configuration.client_side_validation and enable_window is None:  # noqa: E501
            raise ValueError("Invalid value for `enable_window`, must not be `None`")  # noqa: E501

        self._enable_window = enable_window

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this BackupPlan.  # noqa: E501


        :return: The entity_async_status of this BackupPlan.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this BackupPlan.


        :param entity_async_status: The entity_async_status of this BackupPlan.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def full_interval(self):
        """Gets the full_interval of this BackupPlan.  # noqa: E501


        :return: The full_interval of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._full_interval

    @full_interval.setter
    def full_interval(self, full_interval):
        """Sets the full_interval of this BackupPlan.


        :param full_interval: The full_interval of this BackupPlan.  # noqa: E501
        :type full_interval: int
        """
        if self.local_vars_configuration.client_side_validation and full_interval is None:  # noqa: E501
            raise ValueError("Invalid value for `full_interval`, must not be `None`")  # noqa: E501

        self._full_interval = full_interval

    @property
    def full_period(self):
        """Gets the full_period of this BackupPlan.  # noqa: E501


        :return: The full_period of this BackupPlan.  # noqa: E501
        :rtype: BackupPlanPeriod
        """
        return self._full_period

    @full_period.setter
    def full_period(self, full_period):
        """Sets the full_period of this BackupPlan.


        :param full_period: The full_period of this BackupPlan.  # noqa: E501
        :type full_period: BackupPlanPeriod
        """
        if self.local_vars_configuration.client_side_validation and full_period is None:  # noqa: E501
            raise ValueError("Invalid value for `full_period`, must not be `None`")  # noqa: E501

        self._full_period = full_period

    @property
    def full_time_point(self):
        """Gets the full_time_point of this BackupPlan.  # noqa: E501


        :return: The full_time_point of this BackupPlan.  # noqa: E501
        :rtype: NestedBackupPlanTimePoint
        """
        return self._full_time_point

    @full_time_point.setter
    def full_time_point(self, full_time_point):
        """Sets the full_time_point of this BackupPlan.


        :param full_time_point: The full_time_point of this BackupPlan.  # noqa: E501
        :type full_time_point: NestedBackupPlanTimePoint
        """
        if self.local_vars_configuration.client_side_validation and full_time_point is None:  # noqa: E501
            raise ValueError("Invalid value for `full_time_point`, must not be `None`")  # noqa: E501

        self._full_time_point = full_time_point

    @property
    def id(self):
        """Gets the id of this BackupPlan.  # noqa: E501


        :return: The id of this BackupPlan.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BackupPlan.


        :param id: The id of this BackupPlan.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def incremental_interval(self):
        """Gets the incremental_interval of this BackupPlan.  # noqa: E501


        :return: The incremental_interval of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._incremental_interval

    @incremental_interval.setter
    def incremental_interval(self, incremental_interval):
        """Sets the incremental_interval of this BackupPlan.


        :param incremental_interval: The incremental_interval of this BackupPlan.  # noqa: E501
        :type incremental_interval: int
        """

        self._incremental_interval = incremental_interval

    @property
    def incremental_period(self):
        """Gets the incremental_period of this BackupPlan.  # noqa: E501


        :return: The incremental_period of this BackupPlan.  # noqa: E501
        :rtype: BackupPlanPeriod
        """
        return self._incremental_period

    @incremental_period.setter
    def incremental_period(self, incremental_period):
        """Sets the incremental_period of this BackupPlan.


        :param incremental_period: The incremental_period of this BackupPlan.  # noqa: E501
        :type incremental_period: BackupPlanPeriod
        """
        if self.local_vars_configuration.client_side_validation and incremental_period is None:  # noqa: E501
            raise ValueError("Invalid value for `incremental_period`, must not be `None`")  # noqa: E501

        self._incremental_period = incremental_period

    @property
    def incremental_time_points(self):
        """Gets the incremental_time_points of this BackupPlan.  # noqa: E501


        :return: The incremental_time_points of this BackupPlan.  # noqa: E501
        :rtype: list[NestedBackupPlanTimePoint]
        """
        return self._incremental_time_points

    @incremental_time_points.setter
    def incremental_time_points(self, incremental_time_points):
        """Sets the incremental_time_points of this BackupPlan.


        :param incremental_time_points: The incremental_time_points of this BackupPlan.  # noqa: E501
        :type incremental_time_points: list[NestedBackupPlanTimePoint]
        """
        if self.local_vars_configuration.client_side_validation and incremental_time_points is None:  # noqa: E501
            raise ValueError("Invalid value for `incremental_time_points`, must not be `None`")  # noqa: E501

        self._incremental_time_points = incremental_time_points

    @property
    def incremental_weekdays(self):
        """Gets the incremental_weekdays of this BackupPlan.  # noqa: E501


        :return: The incremental_weekdays of this BackupPlan.  # noqa: E501
        :rtype: list[WeekdayTypeEnum]
        """
        return self._incremental_weekdays

    @incremental_weekdays.setter
    def incremental_weekdays(self, incremental_weekdays):
        """Sets the incremental_weekdays of this BackupPlan.


        :param incremental_weekdays: The incremental_weekdays of this BackupPlan.  # noqa: E501
        :type incremental_weekdays: list[WeekdayTypeEnum]
        """

        self._incremental_weekdays = incremental_weekdays

    @property
    def keep_policy(self):
        """Gets the keep_policy of this BackupPlan.  # noqa: E501


        :return: The keep_policy of this BackupPlan.  # noqa: E501
        :rtype: BackupPlanKeepPolicy
        """
        return self._keep_policy

    @keep_policy.setter
    def keep_policy(self, keep_policy):
        """Sets the keep_policy of this BackupPlan.


        :param keep_policy: The keep_policy of this BackupPlan.  # noqa: E501
        :type keep_policy: BackupPlanKeepPolicy
        """

        self._keep_policy = keep_policy

    @property
    def keep_policy_value(self):
        """Gets the keep_policy_value of this BackupPlan.  # noqa: E501


        :return: The keep_policy_value of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value

    @keep_policy_value.setter
    def keep_policy_value(self, keep_policy_value):
        """Sets the keep_policy_value of this BackupPlan.


        :param keep_policy_value: The keep_policy_value of this BackupPlan.  # noqa: E501
        :type keep_policy_value: int
        """

        self._keep_policy_value = keep_policy_value

    @property
    def last_execute_status(self):
        """Gets the last_execute_status of this BackupPlan.  # noqa: E501


        :return: The last_execute_status of this BackupPlan.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_execute_status

    @last_execute_status.setter
    def last_execute_status(self, last_execute_status):
        """Sets the last_execute_status of this BackupPlan.


        :param last_execute_status: The last_execute_status of this BackupPlan.  # noqa: E501
        :type last_execute_status: BackupPlanExecutionStatus
        """
        if self.local_vars_configuration.client_side_validation and last_execute_status is None:  # noqa: E501
            raise ValueError("Invalid value for `last_execute_status`, must not be `None`")  # noqa: E501

        self._last_execute_status = last_execute_status

    @property
    def last_execute_status_message(self):
        """Gets the last_execute_status_message of this BackupPlan.  # noqa: E501


        :return: The last_execute_status_message of this BackupPlan.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message

    @last_execute_status_message.setter
    def last_execute_status_message(self, last_execute_status_message):
        """Sets the last_execute_status_message of this BackupPlan.


        :param last_execute_status_message: The last_execute_status_message of this BackupPlan.  # noqa: E501
        :type last_execute_status_message: str
        """

        self._last_execute_status_message = last_execute_status_message

    @property
    def last_execute_success_job_count(self):
        """Gets the last_execute_success_job_count of this BackupPlan.  # noqa: E501


        :return: The last_execute_success_job_count of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count

    @last_execute_success_job_count.setter
    def last_execute_success_job_count(self, last_execute_success_job_count):
        """Sets the last_execute_success_job_count of this BackupPlan.


        :param last_execute_success_job_count: The last_execute_success_job_count of this BackupPlan.  # noqa: E501
        :type last_execute_success_job_count: int
        """

        self._last_execute_success_job_count = last_execute_success_job_count

    @property
    def last_execute_total_job_count(self):
        """Gets the last_execute_total_job_count of this BackupPlan.  # noqa: E501


        :return: The last_execute_total_job_count of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count

    @last_execute_total_job_count.setter
    def last_execute_total_job_count(self, last_execute_total_job_count):
        """Sets the last_execute_total_job_count of this BackupPlan.


        :param last_execute_total_job_count: The last_execute_total_job_count of this BackupPlan.  # noqa: E501
        :type last_execute_total_job_count: int
        """

        self._last_execute_total_job_count = last_execute_total_job_count

    @property
    def last_executed_at(self):
        """Gets the last_executed_at of this BackupPlan.  # noqa: E501


        :return: The last_executed_at of this BackupPlan.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at

    @last_executed_at.setter
    def last_executed_at(self, last_executed_at):
        """Sets the last_executed_at of this BackupPlan.


        :param last_executed_at: The last_executed_at of this BackupPlan.  # noqa: E501
        :type last_executed_at: str
        """

        self._last_executed_at = last_executed_at

    @property
    def last_manual_execute_status(self):
        """Gets the last_manual_execute_status of this BackupPlan.  # noqa: E501


        :return: The last_manual_execute_status of this BackupPlan.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_manual_execute_status

    @last_manual_execute_status.setter
    def last_manual_execute_status(self, last_manual_execute_status):
        """Sets the last_manual_execute_status of this BackupPlan.


        :param last_manual_execute_status: The last_manual_execute_status of this BackupPlan.  # noqa: E501
        :type last_manual_execute_status: BackupPlanExecutionStatus
        """
        if self.local_vars_configuration.client_side_validation and last_manual_execute_status is None:  # noqa: E501
            raise ValueError("Invalid value for `last_manual_execute_status`, must not be `None`")  # noqa: E501

        self._last_manual_execute_status = last_manual_execute_status

    @property
    def last_manual_execute_status_message(self):
        """Gets the last_manual_execute_status_message of this BackupPlan.  # noqa: E501


        :return: The last_manual_execute_status_message of this BackupPlan.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message

    @last_manual_execute_status_message.setter
    def last_manual_execute_status_message(self, last_manual_execute_status_message):
        """Sets the last_manual_execute_status_message of this BackupPlan.


        :param last_manual_execute_status_message: The last_manual_execute_status_message of this BackupPlan.  # noqa: E501
        :type last_manual_execute_status_message: str
        """

        self._last_manual_execute_status_message = last_manual_execute_status_message

    @property
    def last_manual_execute_success_job_count(self):
        """Gets the last_manual_execute_success_job_count of this BackupPlan.  # noqa: E501


        :return: The last_manual_execute_success_job_count of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count

    @last_manual_execute_success_job_count.setter
    def last_manual_execute_success_job_count(self, last_manual_execute_success_job_count):
        """Sets the last_manual_execute_success_job_count of this BackupPlan.


        :param last_manual_execute_success_job_count: The last_manual_execute_success_job_count of this BackupPlan.  # noqa: E501
        :type last_manual_execute_success_job_count: int
        """

        self._last_manual_execute_success_job_count = last_manual_execute_success_job_count

    @property
    def last_manual_execute_total_job_count(self):
        """Gets the last_manual_execute_total_job_count of this BackupPlan.  # noqa: E501


        :return: The last_manual_execute_total_job_count of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count

    @last_manual_execute_total_job_count.setter
    def last_manual_execute_total_job_count(self, last_manual_execute_total_job_count):
        """Sets the last_manual_execute_total_job_count of this BackupPlan.


        :param last_manual_execute_total_job_count: The last_manual_execute_total_job_count of this BackupPlan.  # noqa: E501
        :type last_manual_execute_total_job_count: int
        """

        self._last_manual_execute_total_job_count = last_manual_execute_total_job_count

    @property
    def last_manual_executed_at(self):
        """Gets the last_manual_executed_at of this BackupPlan.  # noqa: E501


        :return: The last_manual_executed_at of this BackupPlan.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at

    @last_manual_executed_at.setter
    def last_manual_executed_at(self, last_manual_executed_at):
        """Sets the last_manual_executed_at of this BackupPlan.


        :param last_manual_executed_at: The last_manual_executed_at of this BackupPlan.  # noqa: E501
        :type last_manual_executed_at: str
        """

        self._last_manual_executed_at = last_manual_executed_at

    @property
    def logical_size(self):
        """Gets the logical_size of this BackupPlan.  # noqa: E501


        :return: The logical_size of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._logical_size

    @logical_size.setter
    def logical_size(self, logical_size):
        """Sets the logical_size of this BackupPlan.


        :param logical_size: The logical_size of this BackupPlan.  # noqa: E501
        :type logical_size: int
        """
        if self.local_vars_configuration.client_side_validation and logical_size is None:  # noqa: E501
            raise ValueError("Invalid value for `logical_size`, must not be `None`")  # noqa: E501

        self._logical_size = logical_size

    @property
    def name(self):
        """Gets the name of this BackupPlan.  # noqa: E501


        :return: The name of this BackupPlan.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BackupPlan.


        :param name: The name of this BackupPlan.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def next_execute_time(self):
        """Gets the next_execute_time of this BackupPlan.  # noqa: E501


        :return: The next_execute_time of this BackupPlan.  # noqa: E501
        :rtype: str
        """
        return self._next_execute_time

    @next_execute_time.setter
    def next_execute_time(self, next_execute_time):
        """Sets the next_execute_time of this BackupPlan.


        :param next_execute_time: The next_execute_time of this BackupPlan.  # noqa: E501
        :type next_execute_time: str
        """

        self._next_execute_time = next_execute_time

    @property
    def phase(self):
        """Gets the phase of this BackupPlan.  # noqa: E501


        :return: The phase of this BackupPlan.  # noqa: E501
        :rtype: BackupPlanPhase
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """Sets the phase of this BackupPlan.


        :param phase: The phase of this BackupPlan.  # noqa: E501
        :type phase: BackupPlanPhase
        """

        self._phase = phase

    @property
    def physical_size(self):
        """Gets the physical_size of this BackupPlan.  # noqa: E501


        :return: The physical_size of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._physical_size

    @physical_size.setter
    def physical_size(self, physical_size):
        """Sets the physical_size of this BackupPlan.


        :param physical_size: The physical_size of this BackupPlan.  # noqa: E501
        :type physical_size: int
        """
        if self.local_vars_configuration.client_side_validation and physical_size is None:  # noqa: E501
            raise ValueError("Invalid value for `physical_size`, must not be `None`")  # noqa: E501

        self._physical_size = physical_size

    @property
    def snapshot_consistent_type(self):
        """Gets the snapshot_consistent_type of this BackupPlan.  # noqa: E501


        :return: The snapshot_consistent_type of this BackupPlan.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._snapshot_consistent_type

    @snapshot_consistent_type.setter
    def snapshot_consistent_type(self, snapshot_consistent_type):
        """Sets the snapshot_consistent_type of this BackupPlan.


        :param snapshot_consistent_type: The snapshot_consistent_type of this BackupPlan.  # noqa: E501
        :type snapshot_consistent_type: ConsistentType
        """

        self._snapshot_consistent_type = snapshot_consistent_type

    @property
    def status(self):
        """Gets the status of this BackupPlan.  # noqa: E501


        :return: The status of this BackupPlan.  # noqa: E501
        :rtype: BackupPlanStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BackupPlan.


        :param status: The status of this BackupPlan.  # noqa: E501
        :type status: BackupPlanStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def valid_size_of_backup_object(self):
        """Gets the valid_size_of_backup_object of this BackupPlan.  # noqa: E501


        :return: The valid_size_of_backup_object of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_backup_object

    @valid_size_of_backup_object.setter
    def valid_size_of_backup_object(self, valid_size_of_backup_object):
        """Sets the valid_size_of_backup_object of this BackupPlan.


        :param valid_size_of_backup_object: The valid_size_of_backup_object of this BackupPlan.  # noqa: E501
        :type valid_size_of_backup_object: int
        """
        if self.local_vars_configuration.client_side_validation and valid_size_of_backup_object is None:  # noqa: E501
            raise ValueError("Invalid value for `valid_size_of_backup_object`, must not be `None`")  # noqa: E501

        self._valid_size_of_backup_object = valid_size_of_backup_object

    @property
    def valid_size_of_restore_point(self):
        """Gets the valid_size_of_restore_point of this BackupPlan.  # noqa: E501


        :return: The valid_size_of_restore_point of this BackupPlan.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_restore_point

    @valid_size_of_restore_point.setter
    def valid_size_of_restore_point(self, valid_size_of_restore_point):
        """Sets the valid_size_of_restore_point of this BackupPlan.


        :param valid_size_of_restore_point: The valid_size_of_restore_point of this BackupPlan.  # noqa: E501
        :type valid_size_of_restore_point: int
        """
        if self.local_vars_configuration.client_side_validation and valid_size_of_restore_point is None:  # noqa: E501
            raise ValueError("Invalid value for `valid_size_of_restore_point`, must not be `None`")  # noqa: E501

        self._valid_size_of_restore_point = valid_size_of_restore_point

    @property
    def vms(self):
        """Gets the vms of this BackupPlan.  # noqa: E501


        :return: The vms of this BackupPlan.  # noqa: E501
        :rtype: list[NestedVm]
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this BackupPlan.


        :param vms: The vms of this BackupPlan.  # noqa: E501
        :type vms: list[NestedVm]
        """

        self._vms = vms

    @property
    def window_end(self):
        """Gets the window_end of this BackupPlan.  # noqa: E501


        :return: The window_end of this BackupPlan.  # noqa: E501
        :rtype: str
        """
        return self._window_end

    @window_end.setter
    def window_end(self, window_end):
        """Sets the window_end of this BackupPlan.


        :param window_end: The window_end of this BackupPlan.  # noqa: E501
        :type window_end: str
        """

        self._window_end = window_end

    @property
    def window_start(self):
        """Gets the window_start of this BackupPlan.  # noqa: E501


        :return: The window_start of this BackupPlan.  # noqa: E501
        :rtype: str
        """
        return self._window_start

    @window_start.setter
    def window_start(self, window_start):
        """Sets the window_start of this BackupPlan.


        :param window_start: The window_start of this BackupPlan.  # noqa: E501
        :type window_start: str
        """

        self._window_start = window_start

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupPlan):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupPlan):
            return True

        return self.to_dict() != other.to_dict()
