# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupPlanExecution(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'backup_plan': 'NestedBackupPlan',
        'deletable_flag_marked': 'bool',
        'duration': 'int',
        'entity_async_status': 'EntityAsyncStatus',
        'executed_at': 'str',
        'id': 'str',
        'local_created_at': 'str',
        'local_id': 'str',
        'method': 'BackupExecutionMethod',
        'state': 'BackupPlanExecutionState',
        'status': 'BackupPlanExecutionStatus',
        'success_job_count': 'int',
        'total_job_count': 'int',
        'type': 'BackupExecutionType'
    }

    attribute_map = {
        'backup_plan': 'backup_plan',
        'deletable_flag_marked': 'deletable_flag_marked',
        'duration': 'duration',
        'entity_async_status': 'entityAsyncStatus',
        'executed_at': 'executed_at',
        'id': 'id',
        'local_created_at': 'local_created_at',
        'local_id': 'local_id',
        'method': 'method',
        'state': 'state',
        'status': 'status',
        'success_job_count': 'success_job_count',
        'total_job_count': 'total_job_count',
        'type': 'type'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupPlanExecution - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._backup_plan = None
        self._deletable_flag_marked = None
        self._duration = None
        self._entity_async_status = None
        self._executed_at = None
        self._id = None
        self._local_created_at = None
        self._local_id = None
        self._method = None
        self._state = None
        self._status = None
        self._success_job_count = None
        self._total_job_count = None
        self._type = None
        self.discriminator = None

        self.backup_plan = kwargs.get("backup_plan", None)
        self.deletable_flag_marked = kwargs.get("deletable_flag_marked", None)
        self.duration = kwargs.get("duration", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.executed_at = kwargs.get("executed_at", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "local_created_at" in kwargs:
            self.local_created_at = kwargs["local_created_at"]
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "method" in kwargs:
            self.method = kwargs["method"]
        self.state = kwargs.get("state", None)
        if "status" in kwargs:
            self.status = kwargs["status"]
        self.success_job_count = kwargs.get("success_job_count", None)
        self.total_job_count = kwargs.get("total_job_count", None)
        if "type" in kwargs:
            self.type = kwargs["type"]

    @property
    def backup_plan(self):
        """Gets the backup_plan of this BackupPlanExecution.  # noqa: E501


        :return: The backup_plan of this BackupPlanExecution.  # noqa: E501
        :rtype: NestedBackupPlan
        """
        return self._backup_plan

    @backup_plan.setter
    def backup_plan(self, backup_plan):
        """Sets the backup_plan of this BackupPlanExecution.


        :param backup_plan: The backup_plan of this BackupPlanExecution.  # noqa: E501
        :type backup_plan: NestedBackupPlan
        """

        self._backup_plan = backup_plan

    @property
    def deletable_flag_marked(self):
        """Gets the deletable_flag_marked of this BackupPlanExecution.  # noqa: E501


        :return: The deletable_flag_marked of this BackupPlanExecution.  # noqa: E501
        :rtype: bool
        """
        return self._deletable_flag_marked

    @deletable_flag_marked.setter
    def deletable_flag_marked(self, deletable_flag_marked):
        """Sets the deletable_flag_marked of this BackupPlanExecution.


        :param deletable_flag_marked: The deletable_flag_marked of this BackupPlanExecution.  # noqa: E501
        :type deletable_flag_marked: bool
        """

        self._deletable_flag_marked = deletable_flag_marked

    @property
    def duration(self):
        """Gets the duration of this BackupPlanExecution.  # noqa: E501


        :return: The duration of this BackupPlanExecution.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this BackupPlanExecution.


        :param duration: The duration of this BackupPlanExecution.  # noqa: E501
        :type duration: int
        """

        self._duration = duration

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this BackupPlanExecution.  # noqa: E501


        :return: The entity_async_status of this BackupPlanExecution.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this BackupPlanExecution.


        :param entity_async_status: The entity_async_status of this BackupPlanExecution.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def executed_at(self):
        """Gets the executed_at of this BackupPlanExecution.  # noqa: E501


        :return: The executed_at of this BackupPlanExecution.  # noqa: E501
        :rtype: str
        """
        return self._executed_at

    @executed_at.setter
    def executed_at(self, executed_at):
        """Sets the executed_at of this BackupPlanExecution.


        :param executed_at: The executed_at of this BackupPlanExecution.  # noqa: E501
        :type executed_at: str
        """

        self._executed_at = executed_at

    @property
    def id(self):
        """Gets the id of this BackupPlanExecution.  # noqa: E501


        :return: The id of this BackupPlanExecution.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BackupPlanExecution.


        :param id: The id of this BackupPlanExecution.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def local_created_at(self):
        """Gets the local_created_at of this BackupPlanExecution.  # noqa: E501


        :return: The local_created_at of this BackupPlanExecution.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this BackupPlanExecution.


        :param local_created_at: The local_created_at of this BackupPlanExecution.  # noqa: E501
        :type local_created_at: str
        """
        if self.local_vars_configuration.client_side_validation and local_created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `local_created_at`, must not be `None`")  # noqa: E501

        self._local_created_at = local_created_at

    @property
    def local_id(self):
        """Gets the local_id of this BackupPlanExecution.  # noqa: E501


        :return: The local_id of this BackupPlanExecution.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this BackupPlanExecution.


        :param local_id: The local_id of this BackupPlanExecution.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def method(self):
        """Gets the method of this BackupPlanExecution.  # noqa: E501


        :return: The method of this BackupPlanExecution.  # noqa: E501
        :rtype: BackupExecutionMethod
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this BackupPlanExecution.


        :param method: The method of this BackupPlanExecution.  # noqa: E501
        :type method: BackupExecutionMethod
        """
        if self.local_vars_configuration.client_side_validation and method is None:  # noqa: E501
            raise ValueError("Invalid value for `method`, must not be `None`")  # noqa: E501

        self._method = method

    @property
    def state(self):
        """Gets the state of this BackupPlanExecution.  # noqa: E501


        :return: The state of this BackupPlanExecution.  # noqa: E501
        :rtype: BackupPlanExecutionState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this BackupPlanExecution.


        :param state: The state of this BackupPlanExecution.  # noqa: E501
        :type state: BackupPlanExecutionState
        """

        self._state = state

    @property
    def status(self):
        """Gets the status of this BackupPlanExecution.  # noqa: E501


        :return: The status of this BackupPlanExecution.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BackupPlanExecution.


        :param status: The status of this BackupPlanExecution.  # noqa: E501
        :type status: BackupPlanExecutionStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def success_job_count(self):
        """Gets the success_job_count of this BackupPlanExecution.  # noqa: E501


        :return: The success_job_count of this BackupPlanExecution.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count

    @success_job_count.setter
    def success_job_count(self, success_job_count):
        """Sets the success_job_count of this BackupPlanExecution.


        :param success_job_count: The success_job_count of this BackupPlanExecution.  # noqa: E501
        :type success_job_count: int
        """

        self._success_job_count = success_job_count

    @property
    def total_job_count(self):
        """Gets the total_job_count of this BackupPlanExecution.  # noqa: E501


        :return: The total_job_count of this BackupPlanExecution.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count

    @total_job_count.setter
    def total_job_count(self, total_job_count):
        """Sets the total_job_count of this BackupPlanExecution.


        :param total_job_count: The total_job_count of this BackupPlanExecution.  # noqa: E501
        :type total_job_count: int
        """

        self._total_job_count = total_job_count

    @property
    def type(self):
        """Gets the type of this BackupPlanExecution.  # noqa: E501


        :return: The type of this BackupPlanExecution.  # noqa: E501
        :rtype: BackupExecutionType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BackupPlanExecution.


        :param type: The type of this BackupPlanExecution.  # noqa: E501
        :type type: BackupExecutionType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupPlanExecution):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupPlanExecution):
            return True

        return self.to_dict() != other.to_dict()
