# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupPlanExecutionWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[BackupPlanExecutionWhereInput]',
        '_not': 'list[BackupPlanExecutionWhereInput]',
        '_or': 'list[BackupPlanExecutionWhereInput]',
        'backup_plan': 'BackupPlanWhereInput',
        'deletable_flag_marked': 'bool',
        'deletable_flag_marked_not': 'bool',
        'duration': 'int',
        'duration_gt': 'int',
        'duration_gte': 'int',
        'duration_in': 'list[int]',
        'duration_lt': 'int',
        'duration_lte': 'int',
        'duration_not': 'int',
        'duration_not_in': 'list[int]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'executed_at': 'str',
        'executed_at_gt': 'str',
        'executed_at_gte': 'str',
        'executed_at_in': 'list[str]',
        'executed_at_lt': 'str',
        'executed_at_lte': 'str',
        'executed_at_not': 'str',
        'executed_at_not_in': 'list[str]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'local_created_at': 'str',
        'local_created_at_gt': 'str',
        'local_created_at_gte': 'str',
        'local_created_at_in': 'list[str]',
        'local_created_at_lt': 'str',
        'local_created_at_lte': 'str',
        'local_created_at_not': 'str',
        'local_created_at_not_in': 'list[str]',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'method': 'BackupExecutionMethod',
        'method_in': 'list[BackupExecutionMethod]',
        'method_not': 'BackupExecutionMethod',
        'method_not_in': 'list[BackupExecutionMethod]',
        'state': 'BackupPlanExecutionState',
        'state_in': 'list[BackupPlanExecutionState]',
        'state_not': 'BackupPlanExecutionState',
        'state_not_in': 'list[BackupPlanExecutionState]',
        'status': 'BackupPlanExecutionStatus',
        'status_in': 'list[BackupPlanExecutionStatus]',
        'status_not': 'BackupPlanExecutionStatus',
        'status_not_in': 'list[BackupPlanExecutionStatus]',
        'success_job_count': 'int',
        'success_job_count_gt': 'int',
        'success_job_count_gte': 'int',
        'success_job_count_in': 'list[int]',
        'success_job_count_lt': 'int',
        'success_job_count_lte': 'int',
        'success_job_count_not': 'int',
        'success_job_count_not_in': 'list[int]',
        'total_job_count': 'int',
        'total_job_count_gt': 'int',
        'total_job_count_gte': 'int',
        'total_job_count_in': 'list[int]',
        'total_job_count_lt': 'int',
        'total_job_count_lte': 'int',
        'total_job_count_not': 'int',
        'total_job_count_not_in': 'list[int]',
        'type': 'BackupExecutionType',
        'type_in': 'list[BackupExecutionType]',
        'type_not': 'BackupExecutionType',
        'type_not_in': 'list[BackupExecutionType]'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'backup_plan': 'backup_plan',
        'deletable_flag_marked': 'deletable_flag_marked',
        'deletable_flag_marked_not': 'deletable_flag_marked_not',
        'duration': 'duration',
        'duration_gt': 'duration_gt',
        'duration_gte': 'duration_gte',
        'duration_in': 'duration_in',
        'duration_lt': 'duration_lt',
        'duration_lte': 'duration_lte',
        'duration_not': 'duration_not',
        'duration_not_in': 'duration_not_in',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'executed_at': 'executed_at',
        'executed_at_gt': 'executed_at_gt',
        'executed_at_gte': 'executed_at_gte',
        'executed_at_in': 'executed_at_in',
        'executed_at_lt': 'executed_at_lt',
        'executed_at_lte': 'executed_at_lte',
        'executed_at_not': 'executed_at_not',
        'executed_at_not_in': 'executed_at_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'local_created_at': 'local_created_at',
        'local_created_at_gt': 'local_created_at_gt',
        'local_created_at_gte': 'local_created_at_gte',
        'local_created_at_in': 'local_created_at_in',
        'local_created_at_lt': 'local_created_at_lt',
        'local_created_at_lte': 'local_created_at_lte',
        'local_created_at_not': 'local_created_at_not',
        'local_created_at_not_in': 'local_created_at_not_in',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'method': 'method',
        'method_in': 'method_in',
        'method_not': 'method_not',
        'method_not_in': 'method_not_in',
        'state': 'state',
        'state_in': 'state_in',
        'state_not': 'state_not',
        'state_not_in': 'state_not_in',
        'status': 'status',
        'status_in': 'status_in',
        'status_not': 'status_not',
        'status_not_in': 'status_not_in',
        'success_job_count': 'success_job_count',
        'success_job_count_gt': 'success_job_count_gt',
        'success_job_count_gte': 'success_job_count_gte',
        'success_job_count_in': 'success_job_count_in',
        'success_job_count_lt': 'success_job_count_lt',
        'success_job_count_lte': 'success_job_count_lte',
        'success_job_count_not': 'success_job_count_not',
        'success_job_count_not_in': 'success_job_count_not_in',
        'total_job_count': 'total_job_count',
        'total_job_count_gt': 'total_job_count_gt',
        'total_job_count_gte': 'total_job_count_gte',
        'total_job_count_in': 'total_job_count_in',
        'total_job_count_lt': 'total_job_count_lt',
        'total_job_count_lte': 'total_job_count_lte',
        'total_job_count_not': 'total_job_count_not',
        'total_job_count_not_in': 'total_job_count_not_in',
        'type': 'type',
        'type_in': 'type_in',
        'type_not': 'type_not',
        'type_not_in': 'type_not_in'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupPlanExecutionWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._backup_plan = None
        self._deletable_flag_marked = None
        self._deletable_flag_marked_not = None
        self._duration = None
        self._duration_gt = None
        self._duration_gte = None
        self._duration_in = None
        self._duration_lt = None
        self._duration_lte = None
        self._duration_not = None
        self._duration_not_in = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._executed_at = None
        self._executed_at_gt = None
        self._executed_at_gte = None
        self._executed_at_in = None
        self._executed_at_lt = None
        self._executed_at_lte = None
        self._executed_at_not = None
        self._executed_at_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._local_created_at = None
        self._local_created_at_gt = None
        self._local_created_at_gte = None
        self._local_created_at_in = None
        self._local_created_at_lt = None
        self._local_created_at_lte = None
        self._local_created_at_not = None
        self._local_created_at_not_in = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._method = None
        self._method_in = None
        self._method_not = None
        self._method_not_in = None
        self._state = None
        self._state_in = None
        self._state_not = None
        self._state_not_in = None
        self._status = None
        self._status_in = None
        self._status_not = None
        self._status_not_in = None
        self._success_job_count = None
        self._success_job_count_gt = None
        self._success_job_count_gte = None
        self._success_job_count_in = None
        self._success_job_count_lt = None
        self._success_job_count_lte = None
        self._success_job_count_not = None
        self._success_job_count_not_in = None
        self._total_job_count = None
        self._total_job_count_gt = None
        self._total_job_count_gte = None
        self._total_job_count_in = None
        self._total_job_count_lt = None
        self._total_job_count_lte = None
        self._total_job_count_not = None
        self._total_job_count_not_in = None
        self._type = None
        self._type_in = None
        self._type_not = None
        self._type_not_in = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.backup_plan = kwargs.get("backup_plan", None)
        self.deletable_flag_marked = kwargs.get("deletable_flag_marked", None)
        self.deletable_flag_marked_not = kwargs.get("deletable_flag_marked_not", None)
        self.duration = kwargs.get("duration", None)
        self.duration_gt = kwargs.get("duration_gt", None)
        self.duration_gte = kwargs.get("duration_gte", None)
        self.duration_in = kwargs.get("duration_in", None)
        self.duration_lt = kwargs.get("duration_lt", None)
        self.duration_lte = kwargs.get("duration_lte", None)
        self.duration_not = kwargs.get("duration_not", None)
        self.duration_not_in = kwargs.get("duration_not_in", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.executed_at = kwargs.get("executed_at", None)
        self.executed_at_gt = kwargs.get("executed_at_gt", None)
        self.executed_at_gte = kwargs.get("executed_at_gte", None)
        self.executed_at_in = kwargs.get("executed_at_in", None)
        self.executed_at_lt = kwargs.get("executed_at_lt", None)
        self.executed_at_lte = kwargs.get("executed_at_lte", None)
        self.executed_at_not = kwargs.get("executed_at_not", None)
        self.executed_at_not_in = kwargs.get("executed_at_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.local_created_at = kwargs.get("local_created_at", None)
        self.local_created_at_gt = kwargs.get("local_created_at_gt", None)
        self.local_created_at_gte = kwargs.get("local_created_at_gte", None)
        self.local_created_at_in = kwargs.get("local_created_at_in", None)
        self.local_created_at_lt = kwargs.get("local_created_at_lt", None)
        self.local_created_at_lte = kwargs.get("local_created_at_lte", None)
        self.local_created_at_not = kwargs.get("local_created_at_not", None)
        self.local_created_at_not_in = kwargs.get("local_created_at_not_in", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.method = kwargs.get("method", None)
        self.method_in = kwargs.get("method_in", None)
        self.method_not = kwargs.get("method_not", None)
        self.method_not_in = kwargs.get("method_not_in", None)
        self.state = kwargs.get("state", None)
        self.state_in = kwargs.get("state_in", None)
        self.state_not = kwargs.get("state_not", None)
        self.state_not_in = kwargs.get("state_not_in", None)
        self.status = kwargs.get("status", None)
        self.status_in = kwargs.get("status_in", None)
        self.status_not = kwargs.get("status_not", None)
        self.status_not_in = kwargs.get("status_not_in", None)
        self.success_job_count = kwargs.get("success_job_count", None)
        self.success_job_count_gt = kwargs.get("success_job_count_gt", None)
        self.success_job_count_gte = kwargs.get("success_job_count_gte", None)
        self.success_job_count_in = kwargs.get("success_job_count_in", None)
        self.success_job_count_lt = kwargs.get("success_job_count_lt", None)
        self.success_job_count_lte = kwargs.get("success_job_count_lte", None)
        self.success_job_count_not = kwargs.get("success_job_count_not", None)
        self.success_job_count_not_in = kwargs.get("success_job_count_not_in", None)
        self.total_job_count = kwargs.get("total_job_count", None)
        self.total_job_count_gt = kwargs.get("total_job_count_gt", None)
        self.total_job_count_gte = kwargs.get("total_job_count_gte", None)
        self.total_job_count_in = kwargs.get("total_job_count_in", None)
        self.total_job_count_lt = kwargs.get("total_job_count_lt", None)
        self.total_job_count_lte = kwargs.get("total_job_count_lte", None)
        self.total_job_count_not = kwargs.get("total_job_count_not", None)
        self.total_job_count_not_in = kwargs.get("total_job_count_not_in", None)
        self.type = kwargs.get("type", None)
        self.type_in = kwargs.get("type_in", None)
        self.type_not = kwargs.get("type_not", None)
        self.type_not_in = kwargs.get("type_not_in", None)

    @property
    def _and(self):
        """Gets the _and of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The _and of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this BackupPlanExecutionWhereInput.


        :param _and: The _and of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type _and: list[BackupPlanExecutionWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The _not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this BackupPlanExecutionWhereInput.


        :param _not: The _not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type _not: list[BackupPlanExecutionWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The _or of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this BackupPlanExecutionWhereInput.


        :param _or: The _or of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type _or: list[BackupPlanExecutionWhereInput]
        """

        self.__or = _or

    @property
    def backup_plan(self):
        """Gets the backup_plan of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The backup_plan of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: BackupPlanWhereInput
        """
        return self._backup_plan

    @backup_plan.setter
    def backup_plan(self, backup_plan):
        """Sets the backup_plan of this BackupPlanExecutionWhereInput.


        :param backup_plan: The backup_plan of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type backup_plan: BackupPlanWhereInput
        """

        self._backup_plan = backup_plan

    @property
    def deletable_flag_marked(self):
        """Gets the deletable_flag_marked of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The deletable_flag_marked of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._deletable_flag_marked

    @deletable_flag_marked.setter
    def deletable_flag_marked(self, deletable_flag_marked):
        """Sets the deletable_flag_marked of this BackupPlanExecutionWhereInput.


        :param deletable_flag_marked: The deletable_flag_marked of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type deletable_flag_marked: bool
        """

        self._deletable_flag_marked = deletable_flag_marked

    @property
    def deletable_flag_marked_not(self):
        """Gets the deletable_flag_marked_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The deletable_flag_marked_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._deletable_flag_marked_not

    @deletable_flag_marked_not.setter
    def deletable_flag_marked_not(self, deletable_flag_marked_not):
        """Sets the deletable_flag_marked_not of this BackupPlanExecutionWhereInput.


        :param deletable_flag_marked_not: The deletable_flag_marked_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type deletable_flag_marked_not: bool
        """

        self._deletable_flag_marked_not = deletable_flag_marked_not

    @property
    def duration(self):
        """Gets the duration of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The duration of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this BackupPlanExecutionWhereInput.


        :param duration: The duration of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type duration: int
        """

        self._duration = duration

    @property
    def duration_gt(self):
        """Gets the duration_gt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The duration_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration_gt

    @duration_gt.setter
    def duration_gt(self, duration_gt):
        """Sets the duration_gt of this BackupPlanExecutionWhereInput.


        :param duration_gt: The duration_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type duration_gt: int
        """

        self._duration_gt = duration_gt

    @property
    def duration_gte(self):
        """Gets the duration_gte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The duration_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration_gte

    @duration_gte.setter
    def duration_gte(self, duration_gte):
        """Sets the duration_gte of this BackupPlanExecutionWhereInput.


        :param duration_gte: The duration_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type duration_gte: int
        """

        self._duration_gte = duration_gte

    @property
    def duration_in(self):
        """Gets the duration_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The duration_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._duration_in

    @duration_in.setter
    def duration_in(self, duration_in):
        """Sets the duration_in of this BackupPlanExecutionWhereInput.


        :param duration_in: The duration_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type duration_in: list[int]
        """

        self._duration_in = duration_in

    @property
    def duration_lt(self):
        """Gets the duration_lt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The duration_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration_lt

    @duration_lt.setter
    def duration_lt(self, duration_lt):
        """Sets the duration_lt of this BackupPlanExecutionWhereInput.


        :param duration_lt: The duration_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type duration_lt: int
        """

        self._duration_lt = duration_lt

    @property
    def duration_lte(self):
        """Gets the duration_lte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The duration_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration_lte

    @duration_lte.setter
    def duration_lte(self, duration_lte):
        """Sets the duration_lte of this BackupPlanExecutionWhereInput.


        :param duration_lte: The duration_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type duration_lte: int
        """

        self._duration_lte = duration_lte

    @property
    def duration_not(self):
        """Gets the duration_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The duration_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration_not

    @duration_not.setter
    def duration_not(self, duration_not):
        """Sets the duration_not of this BackupPlanExecutionWhereInput.


        :param duration_not: The duration_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type duration_not: int
        """

        self._duration_not = duration_not

    @property
    def duration_not_in(self):
        """Gets the duration_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The duration_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._duration_not_in

    @duration_not_in.setter
    def duration_not_in(self, duration_not_in):
        """Sets the duration_not_in of this BackupPlanExecutionWhereInput.


        :param duration_not_in: The duration_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type duration_not_in: list[int]
        """

        self._duration_not_in = duration_not_in

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this BackupPlanExecutionWhereInput.


        :param entity_async_status: The entity_async_status of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this BackupPlanExecutionWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this BackupPlanExecutionWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this BackupPlanExecutionWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def executed_at(self):
        """Gets the executed_at of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The executed_at of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at

    @executed_at.setter
    def executed_at(self, executed_at):
        """Sets the executed_at of this BackupPlanExecutionWhereInput.


        :param executed_at: The executed_at of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type executed_at: str
        """

        self._executed_at = executed_at

    @property
    def executed_at_gt(self):
        """Gets the executed_at_gt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The executed_at_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at_gt

    @executed_at_gt.setter
    def executed_at_gt(self, executed_at_gt):
        """Sets the executed_at_gt of this BackupPlanExecutionWhereInput.


        :param executed_at_gt: The executed_at_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type executed_at_gt: str
        """

        self._executed_at_gt = executed_at_gt

    @property
    def executed_at_gte(self):
        """Gets the executed_at_gte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The executed_at_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at_gte

    @executed_at_gte.setter
    def executed_at_gte(self, executed_at_gte):
        """Sets the executed_at_gte of this BackupPlanExecutionWhereInput.


        :param executed_at_gte: The executed_at_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type executed_at_gte: str
        """

        self._executed_at_gte = executed_at_gte

    @property
    def executed_at_in(self):
        """Gets the executed_at_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The executed_at_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._executed_at_in

    @executed_at_in.setter
    def executed_at_in(self, executed_at_in):
        """Sets the executed_at_in of this BackupPlanExecutionWhereInput.


        :param executed_at_in: The executed_at_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type executed_at_in: list[str]
        """

        self._executed_at_in = executed_at_in

    @property
    def executed_at_lt(self):
        """Gets the executed_at_lt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The executed_at_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at_lt

    @executed_at_lt.setter
    def executed_at_lt(self, executed_at_lt):
        """Sets the executed_at_lt of this BackupPlanExecutionWhereInput.


        :param executed_at_lt: The executed_at_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type executed_at_lt: str
        """

        self._executed_at_lt = executed_at_lt

    @property
    def executed_at_lte(self):
        """Gets the executed_at_lte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The executed_at_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at_lte

    @executed_at_lte.setter
    def executed_at_lte(self, executed_at_lte):
        """Sets the executed_at_lte of this BackupPlanExecutionWhereInput.


        :param executed_at_lte: The executed_at_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type executed_at_lte: str
        """

        self._executed_at_lte = executed_at_lte

    @property
    def executed_at_not(self):
        """Gets the executed_at_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The executed_at_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at_not

    @executed_at_not.setter
    def executed_at_not(self, executed_at_not):
        """Sets the executed_at_not of this BackupPlanExecutionWhereInput.


        :param executed_at_not: The executed_at_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type executed_at_not: str
        """

        self._executed_at_not = executed_at_not

    @property
    def executed_at_not_in(self):
        """Gets the executed_at_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The executed_at_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._executed_at_not_in

    @executed_at_not_in.setter
    def executed_at_not_in(self, executed_at_not_in):
        """Sets the executed_at_not_in of this BackupPlanExecutionWhereInput.


        :param executed_at_not_in: The executed_at_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type executed_at_not_in: list[str]
        """

        self._executed_at_not_in = executed_at_not_in

    @property
    def id(self):
        """Gets the id of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BackupPlanExecutionWhereInput.


        :param id: The id of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_contains of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this BackupPlanExecutionWhereInput.


        :param id_contains: The id_contains of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this BackupPlanExecutionWhereInput.


        :param id_ends_with: The id_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this BackupPlanExecutionWhereInput.


        :param id_gt: The id_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this BackupPlanExecutionWhereInput.


        :param id_gte: The id_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this BackupPlanExecutionWhereInput.


        :param id_in: The id_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this BackupPlanExecutionWhereInput.


        :param id_lt: The id_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this BackupPlanExecutionWhereInput.


        :param id_lte: The id_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this BackupPlanExecutionWhereInput.


        :param id_not: The id_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_not_contains of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this BackupPlanExecutionWhereInput.


        :param id_not_contains: The id_not_contains of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this BackupPlanExecutionWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this BackupPlanExecutionWhereInput.


        :param id_not_in: The id_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this BackupPlanExecutionWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The id_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this BackupPlanExecutionWhereInput.


        :param id_starts_with: The id_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def local_created_at(self):
        """Gets the local_created_at of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_created_at of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this BackupPlanExecutionWhereInput.


        :param local_created_at: The local_created_at of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_created_at: str
        """

        self._local_created_at = local_created_at

    @property
    def local_created_at_gt(self):
        """Gets the local_created_at_gt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_created_at_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gt

    @local_created_at_gt.setter
    def local_created_at_gt(self, local_created_at_gt):
        """Sets the local_created_at_gt of this BackupPlanExecutionWhereInput.


        :param local_created_at_gt: The local_created_at_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_created_at_gt: str
        """

        self._local_created_at_gt = local_created_at_gt

    @property
    def local_created_at_gte(self):
        """Gets the local_created_at_gte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_created_at_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gte

    @local_created_at_gte.setter
    def local_created_at_gte(self, local_created_at_gte):
        """Sets the local_created_at_gte of this BackupPlanExecutionWhereInput.


        :param local_created_at_gte: The local_created_at_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_created_at_gte: str
        """

        self._local_created_at_gte = local_created_at_gte

    @property
    def local_created_at_in(self):
        """Gets the local_created_at_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_created_at_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_in

    @local_created_at_in.setter
    def local_created_at_in(self, local_created_at_in):
        """Sets the local_created_at_in of this BackupPlanExecutionWhereInput.


        :param local_created_at_in: The local_created_at_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_created_at_in: list[str]
        """

        self._local_created_at_in = local_created_at_in

    @property
    def local_created_at_lt(self):
        """Gets the local_created_at_lt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_created_at_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lt

    @local_created_at_lt.setter
    def local_created_at_lt(self, local_created_at_lt):
        """Sets the local_created_at_lt of this BackupPlanExecutionWhereInput.


        :param local_created_at_lt: The local_created_at_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_created_at_lt: str
        """

        self._local_created_at_lt = local_created_at_lt

    @property
    def local_created_at_lte(self):
        """Gets the local_created_at_lte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_created_at_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lte

    @local_created_at_lte.setter
    def local_created_at_lte(self, local_created_at_lte):
        """Sets the local_created_at_lte of this BackupPlanExecutionWhereInput.


        :param local_created_at_lte: The local_created_at_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_created_at_lte: str
        """

        self._local_created_at_lte = local_created_at_lte

    @property
    def local_created_at_not(self):
        """Gets the local_created_at_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_created_at_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_not

    @local_created_at_not.setter
    def local_created_at_not(self, local_created_at_not):
        """Sets the local_created_at_not of this BackupPlanExecutionWhereInput.


        :param local_created_at_not: The local_created_at_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_created_at_not: str
        """

        self._local_created_at_not = local_created_at_not

    @property
    def local_created_at_not_in(self):
        """Gets the local_created_at_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_created_at_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_not_in

    @local_created_at_not_in.setter
    def local_created_at_not_in(self, local_created_at_not_in):
        """Sets the local_created_at_not_in of this BackupPlanExecutionWhereInput.


        :param local_created_at_not_in: The local_created_at_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_created_at_not_in: list[str]
        """

        self._local_created_at_not_in = local_created_at_not_in

    @property
    def local_id(self):
        """Gets the local_id of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this BackupPlanExecutionWhereInput.


        :param local_id: The local_id of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_contains of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this BackupPlanExecutionWhereInput.


        :param local_id_contains: The local_id_contains of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this BackupPlanExecutionWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this BackupPlanExecutionWhereInput.


        :param local_id_gt: The local_id_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this BackupPlanExecutionWhereInput.


        :param local_id_gte: The local_id_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this BackupPlanExecutionWhereInput.


        :param local_id_in: The local_id_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this BackupPlanExecutionWhereInput.


        :param local_id_lt: The local_id_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this BackupPlanExecutionWhereInput.


        :param local_id_lte: The local_id_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this BackupPlanExecutionWhereInput.


        :param local_id_not: The local_id_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this BackupPlanExecutionWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this BackupPlanExecutionWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this BackupPlanExecutionWhereInput.


        :param local_id_not_in: The local_id_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this BackupPlanExecutionWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this BackupPlanExecutionWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def method(self):
        """Gets the method of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The method of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionMethod
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this BackupPlanExecutionWhereInput.


        :param method: The method of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type method: BackupExecutionMethod
        """

        self._method = method

    @property
    def method_in(self):
        """Gets the method_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The method_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionMethod]
        """
        return self._method_in

    @method_in.setter
    def method_in(self, method_in):
        """Sets the method_in of this BackupPlanExecutionWhereInput.


        :param method_in: The method_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type method_in: list[BackupExecutionMethod]
        """

        self._method_in = method_in

    @property
    def method_not(self):
        """Gets the method_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The method_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionMethod
        """
        return self._method_not

    @method_not.setter
    def method_not(self, method_not):
        """Sets the method_not of this BackupPlanExecutionWhereInput.


        :param method_not: The method_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type method_not: BackupExecutionMethod
        """

        self._method_not = method_not

    @property
    def method_not_in(self):
        """Gets the method_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The method_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionMethod]
        """
        return self._method_not_in

    @method_not_in.setter
    def method_not_in(self, method_not_in):
        """Sets the method_not_in of this BackupPlanExecutionWhereInput.


        :param method_not_in: The method_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type method_not_in: list[BackupExecutionMethod]
        """

        self._method_not_in = method_not_in

    @property
    def state(self):
        """Gets the state of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The state of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this BackupPlanExecutionWhereInput.


        :param state: The state of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type state: BackupPlanExecutionState
        """

        self._state = state

    @property
    def state_in(self):
        """Gets the state_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The state_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionState]
        """
        return self._state_in

    @state_in.setter
    def state_in(self, state_in):
        """Sets the state_in of this BackupPlanExecutionWhereInput.


        :param state_in: The state_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type state_in: list[BackupPlanExecutionState]
        """

        self._state_in = state_in

    @property
    def state_not(self):
        """Gets the state_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The state_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionState
        """
        return self._state_not

    @state_not.setter
    def state_not(self, state_not):
        """Sets the state_not of this BackupPlanExecutionWhereInput.


        :param state_not: The state_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type state_not: BackupPlanExecutionState
        """

        self._state_not = state_not

    @property
    def state_not_in(self):
        """Gets the state_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The state_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionState]
        """
        return self._state_not_in

    @state_not_in.setter
    def state_not_in(self, state_not_in):
        """Sets the state_not_in of this BackupPlanExecutionWhereInput.


        :param state_not_in: The state_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type state_not_in: list[BackupPlanExecutionState]
        """

        self._state_not_in = state_not_in

    @property
    def status(self):
        """Gets the status of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The status of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BackupPlanExecutionWhereInput.


        :param status: The status of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type status: BackupPlanExecutionStatus
        """

        self._status = status

    @property
    def status_in(self):
        """Gets the status_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The status_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionStatus]
        """
        return self._status_in

    @status_in.setter
    def status_in(self, status_in):
        """Sets the status_in of this BackupPlanExecutionWhereInput.


        :param status_in: The status_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type status_in: list[BackupPlanExecutionStatus]
        """

        self._status_in = status_in

    @property
    def status_not(self):
        """Gets the status_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The status_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._status_not

    @status_not.setter
    def status_not(self, status_not):
        """Sets the status_not of this BackupPlanExecutionWhereInput.


        :param status_not: The status_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type status_not: BackupPlanExecutionStatus
        """

        self._status_not = status_not

    @property
    def status_not_in(self):
        """Gets the status_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The status_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionStatus]
        """
        return self._status_not_in

    @status_not_in.setter
    def status_not_in(self, status_not_in):
        """Sets the status_not_in of this BackupPlanExecutionWhereInput.


        :param status_not_in: The status_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type status_not_in: list[BackupPlanExecutionStatus]
        """

        self._status_not_in = status_not_in

    @property
    def success_job_count(self):
        """Gets the success_job_count of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The success_job_count of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count

    @success_job_count.setter
    def success_job_count(self, success_job_count):
        """Sets the success_job_count of this BackupPlanExecutionWhereInput.


        :param success_job_count: The success_job_count of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type success_job_count: int
        """

        self._success_job_count = success_job_count

    @property
    def success_job_count_gt(self):
        """Gets the success_job_count_gt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count_gt

    @success_job_count_gt.setter
    def success_job_count_gt(self, success_job_count_gt):
        """Sets the success_job_count_gt of this BackupPlanExecutionWhereInput.


        :param success_job_count_gt: The success_job_count_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type success_job_count_gt: int
        """

        self._success_job_count_gt = success_job_count_gt

    @property
    def success_job_count_gte(self):
        """Gets the success_job_count_gte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count_gte

    @success_job_count_gte.setter
    def success_job_count_gte(self, success_job_count_gte):
        """Sets the success_job_count_gte of this BackupPlanExecutionWhereInput.


        :param success_job_count_gte: The success_job_count_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type success_job_count_gte: int
        """

        self._success_job_count_gte = success_job_count_gte

    @property
    def success_job_count_in(self):
        """Gets the success_job_count_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._success_job_count_in

    @success_job_count_in.setter
    def success_job_count_in(self, success_job_count_in):
        """Sets the success_job_count_in of this BackupPlanExecutionWhereInput.


        :param success_job_count_in: The success_job_count_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type success_job_count_in: list[int]
        """

        self._success_job_count_in = success_job_count_in

    @property
    def success_job_count_lt(self):
        """Gets the success_job_count_lt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count_lt

    @success_job_count_lt.setter
    def success_job_count_lt(self, success_job_count_lt):
        """Sets the success_job_count_lt of this BackupPlanExecutionWhereInput.


        :param success_job_count_lt: The success_job_count_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type success_job_count_lt: int
        """

        self._success_job_count_lt = success_job_count_lt

    @property
    def success_job_count_lte(self):
        """Gets the success_job_count_lte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count_lte

    @success_job_count_lte.setter
    def success_job_count_lte(self, success_job_count_lte):
        """Sets the success_job_count_lte of this BackupPlanExecutionWhereInput.


        :param success_job_count_lte: The success_job_count_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type success_job_count_lte: int
        """

        self._success_job_count_lte = success_job_count_lte

    @property
    def success_job_count_not(self):
        """Gets the success_job_count_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._success_job_count_not

    @success_job_count_not.setter
    def success_job_count_not(self, success_job_count_not):
        """Sets the success_job_count_not of this BackupPlanExecutionWhereInput.


        :param success_job_count_not: The success_job_count_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type success_job_count_not: int
        """

        self._success_job_count_not = success_job_count_not

    @property
    def success_job_count_not_in(self):
        """Gets the success_job_count_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The success_job_count_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._success_job_count_not_in

    @success_job_count_not_in.setter
    def success_job_count_not_in(self, success_job_count_not_in):
        """Sets the success_job_count_not_in of this BackupPlanExecutionWhereInput.


        :param success_job_count_not_in: The success_job_count_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type success_job_count_not_in: list[int]
        """

        self._success_job_count_not_in = success_job_count_not_in

    @property
    def total_job_count(self):
        """Gets the total_job_count of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The total_job_count of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count

    @total_job_count.setter
    def total_job_count(self, total_job_count):
        """Sets the total_job_count of this BackupPlanExecutionWhereInput.


        :param total_job_count: The total_job_count of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type total_job_count: int
        """

        self._total_job_count = total_job_count

    @property
    def total_job_count_gt(self):
        """Gets the total_job_count_gt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count_gt

    @total_job_count_gt.setter
    def total_job_count_gt(self, total_job_count_gt):
        """Sets the total_job_count_gt of this BackupPlanExecutionWhereInput.


        :param total_job_count_gt: The total_job_count_gt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type total_job_count_gt: int
        """

        self._total_job_count_gt = total_job_count_gt

    @property
    def total_job_count_gte(self):
        """Gets the total_job_count_gte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count_gte

    @total_job_count_gte.setter
    def total_job_count_gte(self, total_job_count_gte):
        """Sets the total_job_count_gte of this BackupPlanExecutionWhereInput.


        :param total_job_count_gte: The total_job_count_gte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type total_job_count_gte: int
        """

        self._total_job_count_gte = total_job_count_gte

    @property
    def total_job_count_in(self):
        """Gets the total_job_count_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_job_count_in

    @total_job_count_in.setter
    def total_job_count_in(self, total_job_count_in):
        """Sets the total_job_count_in of this BackupPlanExecutionWhereInput.


        :param total_job_count_in: The total_job_count_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type total_job_count_in: list[int]
        """

        self._total_job_count_in = total_job_count_in

    @property
    def total_job_count_lt(self):
        """Gets the total_job_count_lt of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count_lt

    @total_job_count_lt.setter
    def total_job_count_lt(self, total_job_count_lt):
        """Sets the total_job_count_lt of this BackupPlanExecutionWhereInput.


        :param total_job_count_lt: The total_job_count_lt of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type total_job_count_lt: int
        """

        self._total_job_count_lt = total_job_count_lt

    @property
    def total_job_count_lte(self):
        """Gets the total_job_count_lte of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count_lte

    @total_job_count_lte.setter
    def total_job_count_lte(self, total_job_count_lte):
        """Sets the total_job_count_lte of this BackupPlanExecutionWhereInput.


        :param total_job_count_lte: The total_job_count_lte of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type total_job_count_lte: int
        """

        self._total_job_count_lte = total_job_count_lte

    @property
    def total_job_count_not(self):
        """Gets the total_job_count_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_job_count_not

    @total_job_count_not.setter
    def total_job_count_not(self, total_job_count_not):
        """Sets the total_job_count_not of this BackupPlanExecutionWhereInput.


        :param total_job_count_not: The total_job_count_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type total_job_count_not: int
        """

        self._total_job_count_not = total_job_count_not

    @property
    def total_job_count_not_in(self):
        """Gets the total_job_count_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The total_job_count_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_job_count_not_in

    @total_job_count_not_in.setter
    def total_job_count_not_in(self, total_job_count_not_in):
        """Sets the total_job_count_not_in of this BackupPlanExecutionWhereInput.


        :param total_job_count_not_in: The total_job_count_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type total_job_count_not_in: list[int]
        """

        self._total_job_count_not_in = total_job_count_not_in

    @property
    def type(self):
        """Gets the type of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The type of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BackupPlanExecutionWhereInput.


        :param type: The type of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type type: BackupExecutionType
        """

        self._type = type

    @property
    def type_in(self):
        """Gets the type_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The type_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionType]
        """
        return self._type_in

    @type_in.setter
    def type_in(self, type_in):
        """Sets the type_in of this BackupPlanExecutionWhereInput.


        :param type_in: The type_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type type_in: list[BackupExecutionType]
        """

        self._type_in = type_in

    @property
    def type_not(self):
        """Gets the type_not of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The type_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionType
        """
        return self._type_not

    @type_not.setter
    def type_not(self, type_not):
        """Sets the type_not of this BackupPlanExecutionWhereInput.


        :param type_not: The type_not of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type type_not: BackupExecutionType
        """

        self._type_not = type_not

    @property
    def type_not_in(self):
        """Gets the type_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501


        :return: The type_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionType]
        """
        return self._type_not_in

    @type_not_in.setter
    def type_not_in(self, type_not_in):
        """Sets the type_not_in of this BackupPlanExecutionWhereInput.


        :param type_not_in: The type_not_in of this BackupPlanExecutionWhereInput.  # noqa: E501
        :type type_not_in: list[BackupExecutionType]
        """

        self._type_not_in = type_not_in

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupPlanExecutionWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupPlanExecutionWhereInput):
            return True

        return self.to_dict() != other.to_dict()
