# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupPlanUpdationParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'disconnect_strategy': 'BackupPlanDeleteStrategy',
        'keep_policy_value': 'int',
        'keep_policy': 'BackupPlanKeepPolicy',
        'backup_delay_option': 'BackupPlanDelayOption',
        'window_end': 'str',
        'window_start': 'str',
        'enable_window': 'bool',
        'full_time_point': 'BackupPlanTimePoint',
        'full_period': 'BackupPlanPeriod',
        'full_interval': 'int',
        'incremental_weekdays': 'list[WeekdayTypeEnum]',
        'incremental_time_points': 'list[BackupPlanTimePoint]',
        'incremental_interval': 'int',
        'incremental_period': 'BackupPlanPeriod',
        'snapshot_consistent_type': 'ConsistentType',
        'compression': 'bool',
        'vms': 'VmWhereInput',
        'description': 'str',
        'name': 'str'
    }

    attribute_map = {
        'disconnect_strategy': 'disconnect_strategy',
        'keep_policy_value': 'keep_policy_value',
        'keep_policy': 'keep_policy',
        'backup_delay_option': 'backup_delay_option',
        'window_end': 'window_end',
        'window_start': 'window_start',
        'enable_window': 'enable_window',
        'full_time_point': 'full_time_point',
        'full_period': 'full_period',
        'full_interval': 'full_interval',
        'incremental_weekdays': 'incremental_weekdays',
        'incremental_time_points': 'incremental_time_points',
        'incremental_interval': 'incremental_interval',
        'incremental_period': 'incremental_period',
        'snapshot_consistent_type': 'snapshot_consistent_type',
        'compression': 'compression',
        'vms': 'vms',
        'description': 'description',
        'name': 'name'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupPlanUpdationParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._disconnect_strategy = None
        self._keep_policy_value = None
        self._keep_policy = None
        self._backup_delay_option = None
        self._window_end = None
        self._window_start = None
        self._enable_window = None
        self._full_time_point = None
        self._full_period = None
        self._full_interval = None
        self._incremental_weekdays = None
        self._incremental_time_points = None
        self._incremental_interval = None
        self._incremental_period = None
        self._snapshot_consistent_type = None
        self._compression = None
        self._vms = None
        self._description = None
        self._name = None
        self.discriminator = None

        if "disconnect_strategy" in kwargs:
            self.disconnect_strategy = kwargs["disconnect_strategy"]
        if "keep_policy_value" in kwargs:
            self.keep_policy_value = kwargs["keep_policy_value"]
        if "keep_policy" in kwargs:
            self.keep_policy = kwargs["keep_policy"]
        if "backup_delay_option" in kwargs:
            self.backup_delay_option = kwargs["backup_delay_option"]
        if "window_end" in kwargs:
            self.window_end = kwargs["window_end"]
        if "window_start" in kwargs:
            self.window_start = kwargs["window_start"]
        if "enable_window" in kwargs:
            self.enable_window = kwargs["enable_window"]
        if "full_time_point" in kwargs:
            self.full_time_point = kwargs["full_time_point"]
        if "full_period" in kwargs:
            self.full_period = kwargs["full_period"]
        if "full_interval" in kwargs:
            self.full_interval = kwargs["full_interval"]
        if "incremental_weekdays" in kwargs:
            self.incremental_weekdays = kwargs["incremental_weekdays"]
        if "incremental_time_points" in kwargs:
            self.incremental_time_points = kwargs["incremental_time_points"]
        if "incremental_interval" in kwargs:
            self.incremental_interval = kwargs["incremental_interval"]
        if "incremental_period" in kwargs:
            self.incremental_period = kwargs["incremental_period"]
        if "snapshot_consistent_type" in kwargs:
            self.snapshot_consistent_type = kwargs["snapshot_consistent_type"]
        if "compression" in kwargs:
            self.compression = kwargs["compression"]
        if "vms" in kwargs:
            self.vms = kwargs["vms"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        if "name" in kwargs:
            self.name = kwargs["name"]

    @property
    def disconnect_strategy(self):
        """Gets the disconnect_strategy of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The disconnect_strategy of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: BackupPlanDeleteStrategy
        """
        return self._disconnect_strategy

    @disconnect_strategy.setter
    def disconnect_strategy(self, disconnect_strategy):
        """Sets the disconnect_strategy of this BackupPlanUpdationParamsData.


        :param disconnect_strategy: The disconnect_strategy of this BackupPlanUpdationParamsData.  # noqa: E501
        :type disconnect_strategy: BackupPlanDeleteStrategy
        """

        self._disconnect_strategy = disconnect_strategy

    @property
    def keep_policy_value(self):
        """Gets the keep_policy_value of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The keep_policy_value of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value

    @keep_policy_value.setter
    def keep_policy_value(self, keep_policy_value):
        """Sets the keep_policy_value of this BackupPlanUpdationParamsData.


        :param keep_policy_value: The keep_policy_value of this BackupPlanUpdationParamsData.  # noqa: E501
        :type keep_policy_value: int
        """

        self._keep_policy_value = keep_policy_value

    @property
    def keep_policy(self):
        """Gets the keep_policy of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The keep_policy of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: BackupPlanKeepPolicy
        """
        return self._keep_policy

    @keep_policy.setter
    def keep_policy(self, keep_policy):
        """Sets the keep_policy of this BackupPlanUpdationParamsData.


        :param keep_policy: The keep_policy of this BackupPlanUpdationParamsData.  # noqa: E501
        :type keep_policy: BackupPlanKeepPolicy
        """

        self._keep_policy = keep_policy

    @property
    def backup_delay_option(self):
        """Gets the backup_delay_option of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The backup_delay_option of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: BackupPlanDelayOption
        """
        return self._backup_delay_option

    @backup_delay_option.setter
    def backup_delay_option(self, backup_delay_option):
        """Sets the backup_delay_option of this BackupPlanUpdationParamsData.


        :param backup_delay_option: The backup_delay_option of this BackupPlanUpdationParamsData.  # noqa: E501
        :type backup_delay_option: BackupPlanDelayOption
        """

        self._backup_delay_option = backup_delay_option

    @property
    def window_end(self):
        """Gets the window_end of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The window_end of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._window_end

    @window_end.setter
    def window_end(self, window_end):
        """Sets the window_end of this BackupPlanUpdationParamsData.


        :param window_end: The window_end of this BackupPlanUpdationParamsData.  # noqa: E501
        :type window_end: str
        """

        self._window_end = window_end

    @property
    def window_start(self):
        """Gets the window_start of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The window_start of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._window_start

    @window_start.setter
    def window_start(self, window_start):
        """Sets the window_start of this BackupPlanUpdationParamsData.


        :param window_start: The window_start of this BackupPlanUpdationParamsData.  # noqa: E501
        :type window_start: str
        """

        self._window_start = window_start

    @property
    def enable_window(self):
        """Gets the enable_window of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The enable_window of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: bool
        """
        return self._enable_window

    @enable_window.setter
    def enable_window(self, enable_window):
        """Sets the enable_window of this BackupPlanUpdationParamsData.


        :param enable_window: The enable_window of this BackupPlanUpdationParamsData.  # noqa: E501
        :type enable_window: bool
        """

        self._enable_window = enable_window

    @property
    def full_time_point(self):
        """Gets the full_time_point of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The full_time_point of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: BackupPlanTimePoint
        """
        return self._full_time_point

    @full_time_point.setter
    def full_time_point(self, full_time_point):
        """Sets the full_time_point of this BackupPlanUpdationParamsData.


        :param full_time_point: The full_time_point of this BackupPlanUpdationParamsData.  # noqa: E501
        :type full_time_point: BackupPlanTimePoint
        """

        self._full_time_point = full_time_point

    @property
    def full_period(self):
        """Gets the full_period of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The full_period of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: BackupPlanPeriod
        """
        return self._full_period

    @full_period.setter
    def full_period(self, full_period):
        """Sets the full_period of this BackupPlanUpdationParamsData.


        :param full_period: The full_period of this BackupPlanUpdationParamsData.  # noqa: E501
        :type full_period: BackupPlanPeriod
        """

        self._full_period = full_period

    @property
    def full_interval(self):
        """Gets the full_interval of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The full_interval of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: int
        """
        return self._full_interval

    @full_interval.setter
    def full_interval(self, full_interval):
        """Sets the full_interval of this BackupPlanUpdationParamsData.


        :param full_interval: The full_interval of this BackupPlanUpdationParamsData.  # noqa: E501
        :type full_interval: int
        """

        self._full_interval = full_interval

    @property
    def incremental_weekdays(self):
        """Gets the incremental_weekdays of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The incremental_weekdays of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: list[WeekdayTypeEnum]
        """
        return self._incremental_weekdays

    @incremental_weekdays.setter
    def incremental_weekdays(self, incremental_weekdays):
        """Sets the incremental_weekdays of this BackupPlanUpdationParamsData.


        :param incremental_weekdays: The incremental_weekdays of this BackupPlanUpdationParamsData.  # noqa: E501
        :type incremental_weekdays: list[WeekdayTypeEnum]
        """

        self._incremental_weekdays = incremental_weekdays

    @property
    def incremental_time_points(self):
        """Gets the incremental_time_points of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The incremental_time_points of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: list[BackupPlanTimePoint]
        """
        return self._incremental_time_points

    @incremental_time_points.setter
    def incremental_time_points(self, incremental_time_points):
        """Sets the incremental_time_points of this BackupPlanUpdationParamsData.


        :param incremental_time_points: The incremental_time_points of this BackupPlanUpdationParamsData.  # noqa: E501
        :type incremental_time_points: list[BackupPlanTimePoint]
        """

        self._incremental_time_points = incremental_time_points

    @property
    def incremental_interval(self):
        """Gets the incremental_interval of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The incremental_interval of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: int
        """
        return self._incremental_interval

    @incremental_interval.setter
    def incremental_interval(self, incremental_interval):
        """Sets the incremental_interval of this BackupPlanUpdationParamsData.


        :param incremental_interval: The incremental_interval of this BackupPlanUpdationParamsData.  # noqa: E501
        :type incremental_interval: int
        """

        self._incremental_interval = incremental_interval

    @property
    def incremental_period(self):
        """Gets the incremental_period of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The incremental_period of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: BackupPlanPeriod
        """
        return self._incremental_period

    @incremental_period.setter
    def incremental_period(self, incremental_period):
        """Sets the incremental_period of this BackupPlanUpdationParamsData.


        :param incremental_period: The incremental_period of this BackupPlanUpdationParamsData.  # noqa: E501
        :type incremental_period: BackupPlanPeriod
        """

        self._incremental_period = incremental_period

    @property
    def snapshot_consistent_type(self):
        """Gets the snapshot_consistent_type of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The snapshot_consistent_type of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._snapshot_consistent_type

    @snapshot_consistent_type.setter
    def snapshot_consistent_type(self, snapshot_consistent_type):
        """Sets the snapshot_consistent_type of this BackupPlanUpdationParamsData.


        :param snapshot_consistent_type: The snapshot_consistent_type of this BackupPlanUpdationParamsData.  # noqa: E501
        :type snapshot_consistent_type: ConsistentType
        """

        self._snapshot_consistent_type = snapshot_consistent_type

    @property
    def compression(self):
        """Gets the compression of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The compression of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: bool
        """
        return self._compression

    @compression.setter
    def compression(self, compression):
        """Sets the compression of this BackupPlanUpdationParamsData.


        :param compression: The compression of this BackupPlanUpdationParamsData.  # noqa: E501
        :type compression: bool
        """

        self._compression = compression

    @property
    def vms(self):
        """Gets the vms of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The vms of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this BackupPlanUpdationParamsData.


        :param vms: The vms of this BackupPlanUpdationParamsData.  # noqa: E501
        :type vms: VmWhereInput
        """

        self._vms = vms

    @property
    def description(self):
        """Gets the description of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The description of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BackupPlanUpdationParamsData.


        :param description: The description of this BackupPlanUpdationParamsData.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def name(self):
        """Gets the name of this BackupPlanUpdationParamsData.  # noqa: E501


        :return: The name of this BackupPlanUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BackupPlanUpdationParamsData.


        :param name: The name of this BackupPlanUpdationParamsData.  # noqa: E501
        :type name: str
        """

        self._name = name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupPlanUpdationParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupPlanUpdationParamsData):
            return True

        return self.to_dict() != other.to_dict()
