# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupPlanWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[BackupPlanWhereInput]',
        '_not': 'list[BackupPlanWhereInput]',
        '_or': 'list[BackupPlanWhereInput]',
        'backup_delay_option': 'BackupPlanDelayOption',
        'backup_delay_option_in': 'list[BackupPlanDelayOption]',
        'backup_delay_option_not': 'BackupPlanDelayOption',
        'backup_delay_option_not_in': 'list[BackupPlanDelayOption]',
        'backup_plan_executions_every': 'BackupPlanExecutionWhereInput',
        'backup_plan_executions_none': 'BackupPlanExecutionWhereInput',
        'backup_plan_executions_some': 'BackupPlanExecutionWhereInput',
        'backup_restore_point_count': 'int',
        'backup_restore_point_count_gt': 'int',
        'backup_restore_point_count_gte': 'int',
        'backup_restore_point_count_in': 'list[int]',
        'backup_restore_point_count_lt': 'int',
        'backup_restore_point_count_lte': 'int',
        'backup_restore_point_count_not': 'int',
        'backup_restore_point_count_not_in': 'list[int]',
        'backup_restore_points_every': 'BackupRestorePointWhereInput',
        'backup_restore_points_none': 'BackupRestorePointWhereInput',
        'backup_restore_points_some': 'BackupRestorePointWhereInput',
        'backup_service': 'BackupServiceWhereInput',
        'backup_store_repository': 'BackupStoreRepositoryWhereInput',
        'backup_total_size': 'int',
        'backup_total_size_gt': 'int',
        'backup_total_size_gte': 'int',
        'backup_total_size_in': 'list[int]',
        'backup_total_size_lt': 'int',
        'backup_total_size_lte': 'int',
        'backup_total_size_not': 'int',
        'backup_total_size_not_in': 'list[int]',
        'compression': 'bool',
        'compression_not': 'bool',
        'compression_ratio': 'float',
        'compression_ratio_gt': 'float',
        'compression_ratio_gte': 'float',
        'compression_ratio_in': 'list[float]',
        'compression_ratio_lt': 'float',
        'compression_ratio_lte': 'float',
        'compression_ratio_not': 'float',
        'compression_ratio_not_in': 'list[float]',
        'created_at': 'str',
        'created_at_gt': 'str',
        'created_at_gte': 'str',
        'created_at_in': 'list[str]',
        'created_at_lt': 'str',
        'created_at_lte': 'str',
        'created_at_not': 'str',
        'created_at_not_in': 'list[str]',
        'delete_strategy': 'BackupPlanDeleteStrategy',
        'delete_strategy_in': 'list[BackupPlanDeleteStrategy]',
        'delete_strategy_not': 'BackupPlanDeleteStrategy',
        'delete_strategy_not_in': 'list[BackupPlanDeleteStrategy]',
        'description': 'str',
        'description_contains': 'str',
        'description_ends_with': 'str',
        'description_gt': 'str',
        'description_gte': 'str',
        'description_in': 'list[str]',
        'description_lt': 'str',
        'description_lte': 'str',
        'description_not': 'str',
        'description_not_contains': 'str',
        'description_not_ends_with': 'str',
        'description_not_in': 'list[str]',
        'description_not_starts_with': 'str',
        'description_starts_with': 'str',
        'enable_window': 'bool',
        'enable_window_not': 'bool',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'full_interval': 'int',
        'full_interval_gt': 'int',
        'full_interval_gte': 'int',
        'full_interval_in': 'list[int]',
        'full_interval_lt': 'int',
        'full_interval_lte': 'int',
        'full_interval_not': 'int',
        'full_interval_not_in': 'list[int]',
        'full_period': 'BackupPlanPeriod',
        'full_period_in': 'list[BackupPlanPeriod]',
        'full_period_not': 'BackupPlanPeriod',
        'full_period_not_in': 'list[BackupPlanPeriod]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'incremental_interval': 'int',
        'incremental_interval_gt': 'int',
        'incremental_interval_gte': 'int',
        'incremental_interval_in': 'list[int]',
        'incremental_interval_lt': 'int',
        'incremental_interval_lte': 'int',
        'incremental_interval_not': 'int',
        'incremental_interval_not_in': 'list[int]',
        'incremental_period': 'BackupPlanPeriod',
        'incremental_period_in': 'list[BackupPlanPeriod]',
        'incremental_period_not': 'BackupPlanPeriod',
        'incremental_period_not_in': 'list[BackupPlanPeriod]',
        'keep_policy': 'BackupPlanKeepPolicy',
        'keep_policy_in': 'list[BackupPlanKeepPolicy]',
        'keep_policy_not': 'BackupPlanKeepPolicy',
        'keep_policy_not_in': 'list[BackupPlanKeepPolicy]',
        'keep_policy_value': 'int',
        'keep_policy_value_gt': 'int',
        'keep_policy_value_gte': 'int',
        'keep_policy_value_in': 'list[int]',
        'keep_policy_value_lt': 'int',
        'keep_policy_value_lte': 'int',
        'keep_policy_value_not': 'int',
        'keep_policy_value_not_in': 'list[int]',
        'last_execute_status': 'BackupPlanExecutionStatus',
        'last_execute_status_in': 'list[BackupPlanExecutionStatus]',
        'last_execute_status_message': 'str',
        'last_execute_status_message_contains': 'str',
        'last_execute_status_message_ends_with': 'str',
        'last_execute_status_message_gt': 'str',
        'last_execute_status_message_gte': 'str',
        'last_execute_status_message_in': 'list[str]',
        'last_execute_status_message_lt': 'str',
        'last_execute_status_message_lte': 'str',
        'last_execute_status_message_not': 'str',
        'last_execute_status_message_not_contains': 'str',
        'last_execute_status_message_not_ends_with': 'str',
        'last_execute_status_message_not_in': 'list[str]',
        'last_execute_status_message_not_starts_with': 'str',
        'last_execute_status_message_starts_with': 'str',
        'last_execute_status_not': 'BackupPlanExecutionStatus',
        'last_execute_status_not_in': 'list[BackupPlanExecutionStatus]',
        'last_execute_success_job_count': 'int',
        'last_execute_success_job_count_gt': 'int',
        'last_execute_success_job_count_gte': 'int',
        'last_execute_success_job_count_in': 'list[int]',
        'last_execute_success_job_count_lt': 'int',
        'last_execute_success_job_count_lte': 'int',
        'last_execute_success_job_count_not': 'int',
        'last_execute_success_job_count_not_in': 'list[int]',
        'last_execute_total_job_count': 'int',
        'last_execute_total_job_count_gt': 'int',
        'last_execute_total_job_count_gte': 'int',
        'last_execute_total_job_count_in': 'list[int]',
        'last_execute_total_job_count_lt': 'int',
        'last_execute_total_job_count_lte': 'int',
        'last_execute_total_job_count_not': 'int',
        'last_execute_total_job_count_not_in': 'list[int]',
        'last_executed_at': 'str',
        'last_executed_at_gt': 'str',
        'last_executed_at_gte': 'str',
        'last_executed_at_in': 'list[str]',
        'last_executed_at_lt': 'str',
        'last_executed_at_lte': 'str',
        'last_executed_at_not': 'str',
        'last_executed_at_not_in': 'list[str]',
        'last_manual_execute_status': 'BackupPlanExecutionStatus',
        'last_manual_execute_status_in': 'list[BackupPlanExecutionStatus]',
        'last_manual_execute_status_message': 'str',
        'last_manual_execute_status_message_contains': 'str',
        'last_manual_execute_status_message_ends_with': 'str',
        'last_manual_execute_status_message_gt': 'str',
        'last_manual_execute_status_message_gte': 'str',
        'last_manual_execute_status_message_in': 'list[str]',
        'last_manual_execute_status_message_lt': 'str',
        'last_manual_execute_status_message_lte': 'str',
        'last_manual_execute_status_message_not': 'str',
        'last_manual_execute_status_message_not_contains': 'str',
        'last_manual_execute_status_message_not_ends_with': 'str',
        'last_manual_execute_status_message_not_in': 'list[str]',
        'last_manual_execute_status_message_not_starts_with': 'str',
        'last_manual_execute_status_message_starts_with': 'str',
        'last_manual_execute_status_not': 'BackupPlanExecutionStatus',
        'last_manual_execute_status_not_in': 'list[BackupPlanExecutionStatus]',
        'last_manual_execute_success_job_count': 'int',
        'last_manual_execute_success_job_count_gt': 'int',
        'last_manual_execute_success_job_count_gte': 'int',
        'last_manual_execute_success_job_count_in': 'list[int]',
        'last_manual_execute_success_job_count_lt': 'int',
        'last_manual_execute_success_job_count_lte': 'int',
        'last_manual_execute_success_job_count_not': 'int',
        'last_manual_execute_success_job_count_not_in': 'list[int]',
        'last_manual_execute_total_job_count': 'int',
        'last_manual_execute_total_job_count_gt': 'int',
        'last_manual_execute_total_job_count_gte': 'int',
        'last_manual_execute_total_job_count_in': 'list[int]',
        'last_manual_execute_total_job_count_lt': 'int',
        'last_manual_execute_total_job_count_lte': 'int',
        'last_manual_execute_total_job_count_not': 'int',
        'last_manual_execute_total_job_count_not_in': 'list[int]',
        'last_manual_executed_at': 'str',
        'last_manual_executed_at_gt': 'str',
        'last_manual_executed_at_gte': 'str',
        'last_manual_executed_at_in': 'list[str]',
        'last_manual_executed_at_lt': 'str',
        'last_manual_executed_at_lte': 'str',
        'last_manual_executed_at_not': 'str',
        'last_manual_executed_at_not_in': 'list[str]',
        'logical_size': 'int',
        'logical_size_gt': 'int',
        'logical_size_gte': 'int',
        'logical_size_in': 'list[int]',
        'logical_size_lt': 'int',
        'logical_size_lte': 'int',
        'logical_size_not': 'int',
        'logical_size_not_in': 'list[int]',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'next_execute_time': 'str',
        'next_execute_time_gt': 'str',
        'next_execute_time_gte': 'str',
        'next_execute_time_in': 'list[str]',
        'next_execute_time_lt': 'str',
        'next_execute_time_lte': 'str',
        'next_execute_time_not': 'str',
        'next_execute_time_not_in': 'list[str]',
        'phase': 'BackupPlanPhase',
        'phase_in': 'list[BackupPlanPhase]',
        'phase_not': 'BackupPlanPhase',
        'phase_not_in': 'list[BackupPlanPhase]',
        'physical_size': 'int',
        'physical_size_gt': 'int',
        'physical_size_gte': 'int',
        'physical_size_in': 'list[int]',
        'physical_size_lt': 'int',
        'physical_size_lte': 'int',
        'physical_size_not': 'int',
        'physical_size_not_in': 'list[int]',
        'snapshot_consistent_type': 'ConsistentType',
        'snapshot_consistent_type_in': 'list[ConsistentType]',
        'snapshot_consistent_type_not': 'ConsistentType',
        'snapshot_consistent_type_not_in': 'list[ConsistentType]',
        'status': 'BackupPlanStatus',
        'status_in': 'list[BackupPlanStatus]',
        'status_not': 'BackupPlanStatus',
        'status_not_in': 'list[BackupPlanStatus]',
        'valid_size_of_backup_object': 'int',
        'valid_size_of_backup_object_gt': 'int',
        'valid_size_of_backup_object_gte': 'int',
        'valid_size_of_backup_object_in': 'list[int]',
        'valid_size_of_backup_object_lt': 'int',
        'valid_size_of_backup_object_lte': 'int',
        'valid_size_of_backup_object_not': 'int',
        'valid_size_of_backup_object_not_in': 'list[int]',
        'valid_size_of_restore_point': 'int',
        'valid_size_of_restore_point_gt': 'int',
        'valid_size_of_restore_point_gte': 'int',
        'valid_size_of_restore_point_in': 'list[int]',
        'valid_size_of_restore_point_lt': 'int',
        'valid_size_of_restore_point_lte': 'int',
        'valid_size_of_restore_point_not': 'int',
        'valid_size_of_restore_point_not_in': 'list[int]',
        'vms_every': 'VmWhereInput',
        'vms_none': 'VmWhereInput',
        'vms_some': 'VmWhereInput',
        'window_end': 'str',
        'window_end_contains': 'str',
        'window_end_ends_with': 'str',
        'window_end_gt': 'str',
        'window_end_gte': 'str',
        'window_end_in': 'list[str]',
        'window_end_lt': 'str',
        'window_end_lte': 'str',
        'window_end_not': 'str',
        'window_end_not_contains': 'str',
        'window_end_not_ends_with': 'str',
        'window_end_not_in': 'list[str]',
        'window_end_not_starts_with': 'str',
        'window_end_starts_with': 'str',
        'window_start': 'str',
        'window_start_contains': 'str',
        'window_start_ends_with': 'str',
        'window_start_gt': 'str',
        'window_start_gte': 'str',
        'window_start_in': 'list[str]',
        'window_start_lt': 'str',
        'window_start_lte': 'str',
        'window_start_not': 'str',
        'window_start_not_contains': 'str',
        'window_start_not_ends_with': 'str',
        'window_start_not_in': 'list[str]',
        'window_start_not_starts_with': 'str',
        'window_start_starts_with': 'str'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'backup_delay_option': 'backup_delay_option',
        'backup_delay_option_in': 'backup_delay_option_in',
        'backup_delay_option_not': 'backup_delay_option_not',
        'backup_delay_option_not_in': 'backup_delay_option_not_in',
        'backup_plan_executions_every': 'backup_plan_executions_every',
        'backup_plan_executions_none': 'backup_plan_executions_none',
        'backup_plan_executions_some': 'backup_plan_executions_some',
        'backup_restore_point_count': 'backup_restore_point_count',
        'backup_restore_point_count_gt': 'backup_restore_point_count_gt',
        'backup_restore_point_count_gte': 'backup_restore_point_count_gte',
        'backup_restore_point_count_in': 'backup_restore_point_count_in',
        'backup_restore_point_count_lt': 'backup_restore_point_count_lt',
        'backup_restore_point_count_lte': 'backup_restore_point_count_lte',
        'backup_restore_point_count_not': 'backup_restore_point_count_not',
        'backup_restore_point_count_not_in': 'backup_restore_point_count_not_in',
        'backup_restore_points_every': 'backup_restore_points_every',
        'backup_restore_points_none': 'backup_restore_points_none',
        'backup_restore_points_some': 'backup_restore_points_some',
        'backup_service': 'backup_service',
        'backup_store_repository': 'backup_store_repository',
        'backup_total_size': 'backup_total_size',
        'backup_total_size_gt': 'backup_total_size_gt',
        'backup_total_size_gte': 'backup_total_size_gte',
        'backup_total_size_in': 'backup_total_size_in',
        'backup_total_size_lt': 'backup_total_size_lt',
        'backup_total_size_lte': 'backup_total_size_lte',
        'backup_total_size_not': 'backup_total_size_not',
        'backup_total_size_not_in': 'backup_total_size_not_in',
        'compression': 'compression',
        'compression_not': 'compression_not',
        'compression_ratio': 'compression_ratio',
        'compression_ratio_gt': 'compression_ratio_gt',
        'compression_ratio_gte': 'compression_ratio_gte',
        'compression_ratio_in': 'compression_ratio_in',
        'compression_ratio_lt': 'compression_ratio_lt',
        'compression_ratio_lte': 'compression_ratio_lte',
        'compression_ratio_not': 'compression_ratio_not',
        'compression_ratio_not_in': 'compression_ratio_not_in',
        'created_at': 'createdAt',
        'created_at_gt': 'createdAt_gt',
        'created_at_gte': 'createdAt_gte',
        'created_at_in': 'createdAt_in',
        'created_at_lt': 'createdAt_lt',
        'created_at_lte': 'createdAt_lte',
        'created_at_not': 'createdAt_not',
        'created_at_not_in': 'createdAt_not_in',
        'delete_strategy': 'delete_strategy',
        'delete_strategy_in': 'delete_strategy_in',
        'delete_strategy_not': 'delete_strategy_not',
        'delete_strategy_not_in': 'delete_strategy_not_in',
        'description': 'description',
        'description_contains': 'description_contains',
        'description_ends_with': 'description_ends_with',
        'description_gt': 'description_gt',
        'description_gte': 'description_gte',
        'description_in': 'description_in',
        'description_lt': 'description_lt',
        'description_lte': 'description_lte',
        'description_not': 'description_not',
        'description_not_contains': 'description_not_contains',
        'description_not_ends_with': 'description_not_ends_with',
        'description_not_in': 'description_not_in',
        'description_not_starts_with': 'description_not_starts_with',
        'description_starts_with': 'description_starts_with',
        'enable_window': 'enable_window',
        'enable_window_not': 'enable_window_not',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'full_interval': 'full_interval',
        'full_interval_gt': 'full_interval_gt',
        'full_interval_gte': 'full_interval_gte',
        'full_interval_in': 'full_interval_in',
        'full_interval_lt': 'full_interval_lt',
        'full_interval_lte': 'full_interval_lte',
        'full_interval_not': 'full_interval_not',
        'full_interval_not_in': 'full_interval_not_in',
        'full_period': 'full_period',
        'full_period_in': 'full_period_in',
        'full_period_not': 'full_period_not',
        'full_period_not_in': 'full_period_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'incremental_interval': 'incremental_interval',
        'incremental_interval_gt': 'incremental_interval_gt',
        'incremental_interval_gte': 'incremental_interval_gte',
        'incremental_interval_in': 'incremental_interval_in',
        'incremental_interval_lt': 'incremental_interval_lt',
        'incremental_interval_lte': 'incremental_interval_lte',
        'incremental_interval_not': 'incremental_interval_not',
        'incremental_interval_not_in': 'incremental_interval_not_in',
        'incremental_period': 'incremental_period',
        'incremental_period_in': 'incremental_period_in',
        'incremental_period_not': 'incremental_period_not',
        'incremental_period_not_in': 'incremental_period_not_in',
        'keep_policy': 'keep_policy',
        'keep_policy_in': 'keep_policy_in',
        'keep_policy_not': 'keep_policy_not',
        'keep_policy_not_in': 'keep_policy_not_in',
        'keep_policy_value': 'keep_policy_value',
        'keep_policy_value_gt': 'keep_policy_value_gt',
        'keep_policy_value_gte': 'keep_policy_value_gte',
        'keep_policy_value_in': 'keep_policy_value_in',
        'keep_policy_value_lt': 'keep_policy_value_lt',
        'keep_policy_value_lte': 'keep_policy_value_lte',
        'keep_policy_value_not': 'keep_policy_value_not',
        'keep_policy_value_not_in': 'keep_policy_value_not_in',
        'last_execute_status': 'last_execute_status',
        'last_execute_status_in': 'last_execute_status_in',
        'last_execute_status_message': 'last_execute_status_message',
        'last_execute_status_message_contains': 'last_execute_status_message_contains',
        'last_execute_status_message_ends_with': 'last_execute_status_message_ends_with',
        'last_execute_status_message_gt': 'last_execute_status_message_gt',
        'last_execute_status_message_gte': 'last_execute_status_message_gte',
        'last_execute_status_message_in': 'last_execute_status_message_in',
        'last_execute_status_message_lt': 'last_execute_status_message_lt',
        'last_execute_status_message_lte': 'last_execute_status_message_lte',
        'last_execute_status_message_not': 'last_execute_status_message_not',
        'last_execute_status_message_not_contains': 'last_execute_status_message_not_contains',
        'last_execute_status_message_not_ends_with': 'last_execute_status_message_not_ends_with',
        'last_execute_status_message_not_in': 'last_execute_status_message_not_in',
        'last_execute_status_message_not_starts_with': 'last_execute_status_message_not_starts_with',
        'last_execute_status_message_starts_with': 'last_execute_status_message_starts_with',
        'last_execute_status_not': 'last_execute_status_not',
        'last_execute_status_not_in': 'last_execute_status_not_in',
        'last_execute_success_job_count': 'last_execute_success_job_count',
        'last_execute_success_job_count_gt': 'last_execute_success_job_count_gt',
        'last_execute_success_job_count_gte': 'last_execute_success_job_count_gte',
        'last_execute_success_job_count_in': 'last_execute_success_job_count_in',
        'last_execute_success_job_count_lt': 'last_execute_success_job_count_lt',
        'last_execute_success_job_count_lte': 'last_execute_success_job_count_lte',
        'last_execute_success_job_count_not': 'last_execute_success_job_count_not',
        'last_execute_success_job_count_not_in': 'last_execute_success_job_count_not_in',
        'last_execute_total_job_count': 'last_execute_total_job_count',
        'last_execute_total_job_count_gt': 'last_execute_total_job_count_gt',
        'last_execute_total_job_count_gte': 'last_execute_total_job_count_gte',
        'last_execute_total_job_count_in': 'last_execute_total_job_count_in',
        'last_execute_total_job_count_lt': 'last_execute_total_job_count_lt',
        'last_execute_total_job_count_lte': 'last_execute_total_job_count_lte',
        'last_execute_total_job_count_not': 'last_execute_total_job_count_not',
        'last_execute_total_job_count_not_in': 'last_execute_total_job_count_not_in',
        'last_executed_at': 'last_executed_at',
        'last_executed_at_gt': 'last_executed_at_gt',
        'last_executed_at_gte': 'last_executed_at_gte',
        'last_executed_at_in': 'last_executed_at_in',
        'last_executed_at_lt': 'last_executed_at_lt',
        'last_executed_at_lte': 'last_executed_at_lte',
        'last_executed_at_not': 'last_executed_at_not',
        'last_executed_at_not_in': 'last_executed_at_not_in',
        'last_manual_execute_status': 'last_manual_execute_status',
        'last_manual_execute_status_in': 'last_manual_execute_status_in',
        'last_manual_execute_status_message': 'last_manual_execute_status_message',
        'last_manual_execute_status_message_contains': 'last_manual_execute_status_message_contains',
        'last_manual_execute_status_message_ends_with': 'last_manual_execute_status_message_ends_with',
        'last_manual_execute_status_message_gt': 'last_manual_execute_status_message_gt',
        'last_manual_execute_status_message_gte': 'last_manual_execute_status_message_gte',
        'last_manual_execute_status_message_in': 'last_manual_execute_status_message_in',
        'last_manual_execute_status_message_lt': 'last_manual_execute_status_message_lt',
        'last_manual_execute_status_message_lte': 'last_manual_execute_status_message_lte',
        'last_manual_execute_status_message_not': 'last_manual_execute_status_message_not',
        'last_manual_execute_status_message_not_contains': 'last_manual_execute_status_message_not_contains',
        'last_manual_execute_status_message_not_ends_with': 'last_manual_execute_status_message_not_ends_with',
        'last_manual_execute_status_message_not_in': 'last_manual_execute_status_message_not_in',
        'last_manual_execute_status_message_not_starts_with': 'last_manual_execute_status_message_not_starts_with',
        'last_manual_execute_status_message_starts_with': 'last_manual_execute_status_message_starts_with',
        'last_manual_execute_status_not': 'last_manual_execute_status_not',
        'last_manual_execute_status_not_in': 'last_manual_execute_status_not_in',
        'last_manual_execute_success_job_count': 'last_manual_execute_success_job_count',
        'last_manual_execute_success_job_count_gt': 'last_manual_execute_success_job_count_gt',
        'last_manual_execute_success_job_count_gte': 'last_manual_execute_success_job_count_gte',
        'last_manual_execute_success_job_count_in': 'last_manual_execute_success_job_count_in',
        'last_manual_execute_success_job_count_lt': 'last_manual_execute_success_job_count_lt',
        'last_manual_execute_success_job_count_lte': 'last_manual_execute_success_job_count_lte',
        'last_manual_execute_success_job_count_not': 'last_manual_execute_success_job_count_not',
        'last_manual_execute_success_job_count_not_in': 'last_manual_execute_success_job_count_not_in',
        'last_manual_execute_total_job_count': 'last_manual_execute_total_job_count',
        'last_manual_execute_total_job_count_gt': 'last_manual_execute_total_job_count_gt',
        'last_manual_execute_total_job_count_gte': 'last_manual_execute_total_job_count_gte',
        'last_manual_execute_total_job_count_in': 'last_manual_execute_total_job_count_in',
        'last_manual_execute_total_job_count_lt': 'last_manual_execute_total_job_count_lt',
        'last_manual_execute_total_job_count_lte': 'last_manual_execute_total_job_count_lte',
        'last_manual_execute_total_job_count_not': 'last_manual_execute_total_job_count_not',
        'last_manual_execute_total_job_count_not_in': 'last_manual_execute_total_job_count_not_in',
        'last_manual_executed_at': 'last_manual_executed_at',
        'last_manual_executed_at_gt': 'last_manual_executed_at_gt',
        'last_manual_executed_at_gte': 'last_manual_executed_at_gte',
        'last_manual_executed_at_in': 'last_manual_executed_at_in',
        'last_manual_executed_at_lt': 'last_manual_executed_at_lt',
        'last_manual_executed_at_lte': 'last_manual_executed_at_lte',
        'last_manual_executed_at_not': 'last_manual_executed_at_not',
        'last_manual_executed_at_not_in': 'last_manual_executed_at_not_in',
        'logical_size': 'logical_size',
        'logical_size_gt': 'logical_size_gt',
        'logical_size_gte': 'logical_size_gte',
        'logical_size_in': 'logical_size_in',
        'logical_size_lt': 'logical_size_lt',
        'logical_size_lte': 'logical_size_lte',
        'logical_size_not': 'logical_size_not',
        'logical_size_not_in': 'logical_size_not_in',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'next_execute_time': 'next_execute_time',
        'next_execute_time_gt': 'next_execute_time_gt',
        'next_execute_time_gte': 'next_execute_time_gte',
        'next_execute_time_in': 'next_execute_time_in',
        'next_execute_time_lt': 'next_execute_time_lt',
        'next_execute_time_lte': 'next_execute_time_lte',
        'next_execute_time_not': 'next_execute_time_not',
        'next_execute_time_not_in': 'next_execute_time_not_in',
        'phase': 'phase',
        'phase_in': 'phase_in',
        'phase_not': 'phase_not',
        'phase_not_in': 'phase_not_in',
        'physical_size': 'physical_size',
        'physical_size_gt': 'physical_size_gt',
        'physical_size_gte': 'physical_size_gte',
        'physical_size_in': 'physical_size_in',
        'physical_size_lt': 'physical_size_lt',
        'physical_size_lte': 'physical_size_lte',
        'physical_size_not': 'physical_size_not',
        'physical_size_not_in': 'physical_size_not_in',
        'snapshot_consistent_type': 'snapshot_consistent_type',
        'snapshot_consistent_type_in': 'snapshot_consistent_type_in',
        'snapshot_consistent_type_not': 'snapshot_consistent_type_not',
        'snapshot_consistent_type_not_in': 'snapshot_consistent_type_not_in',
        'status': 'status',
        'status_in': 'status_in',
        'status_not': 'status_not',
        'status_not_in': 'status_not_in',
        'valid_size_of_backup_object': 'valid_size_of_backup_object',
        'valid_size_of_backup_object_gt': 'valid_size_of_backup_object_gt',
        'valid_size_of_backup_object_gte': 'valid_size_of_backup_object_gte',
        'valid_size_of_backup_object_in': 'valid_size_of_backup_object_in',
        'valid_size_of_backup_object_lt': 'valid_size_of_backup_object_lt',
        'valid_size_of_backup_object_lte': 'valid_size_of_backup_object_lte',
        'valid_size_of_backup_object_not': 'valid_size_of_backup_object_not',
        'valid_size_of_backup_object_not_in': 'valid_size_of_backup_object_not_in',
        'valid_size_of_restore_point': 'valid_size_of_restore_point',
        'valid_size_of_restore_point_gt': 'valid_size_of_restore_point_gt',
        'valid_size_of_restore_point_gte': 'valid_size_of_restore_point_gte',
        'valid_size_of_restore_point_in': 'valid_size_of_restore_point_in',
        'valid_size_of_restore_point_lt': 'valid_size_of_restore_point_lt',
        'valid_size_of_restore_point_lte': 'valid_size_of_restore_point_lte',
        'valid_size_of_restore_point_not': 'valid_size_of_restore_point_not',
        'valid_size_of_restore_point_not_in': 'valid_size_of_restore_point_not_in',
        'vms_every': 'vms_every',
        'vms_none': 'vms_none',
        'vms_some': 'vms_some',
        'window_end': 'window_end',
        'window_end_contains': 'window_end_contains',
        'window_end_ends_with': 'window_end_ends_with',
        'window_end_gt': 'window_end_gt',
        'window_end_gte': 'window_end_gte',
        'window_end_in': 'window_end_in',
        'window_end_lt': 'window_end_lt',
        'window_end_lte': 'window_end_lte',
        'window_end_not': 'window_end_not',
        'window_end_not_contains': 'window_end_not_contains',
        'window_end_not_ends_with': 'window_end_not_ends_with',
        'window_end_not_in': 'window_end_not_in',
        'window_end_not_starts_with': 'window_end_not_starts_with',
        'window_end_starts_with': 'window_end_starts_with',
        'window_start': 'window_start',
        'window_start_contains': 'window_start_contains',
        'window_start_ends_with': 'window_start_ends_with',
        'window_start_gt': 'window_start_gt',
        'window_start_gte': 'window_start_gte',
        'window_start_in': 'window_start_in',
        'window_start_lt': 'window_start_lt',
        'window_start_lte': 'window_start_lte',
        'window_start_not': 'window_start_not',
        'window_start_not_contains': 'window_start_not_contains',
        'window_start_not_ends_with': 'window_start_not_ends_with',
        'window_start_not_in': 'window_start_not_in',
        'window_start_not_starts_with': 'window_start_not_starts_with',
        'window_start_starts_with': 'window_start_starts_with'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupPlanWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._backup_delay_option = None
        self._backup_delay_option_in = None
        self._backup_delay_option_not = None
        self._backup_delay_option_not_in = None
        self._backup_plan_executions_every = None
        self._backup_plan_executions_none = None
        self._backup_plan_executions_some = None
        self._backup_restore_point_count = None
        self._backup_restore_point_count_gt = None
        self._backup_restore_point_count_gte = None
        self._backup_restore_point_count_in = None
        self._backup_restore_point_count_lt = None
        self._backup_restore_point_count_lte = None
        self._backup_restore_point_count_not = None
        self._backup_restore_point_count_not_in = None
        self._backup_restore_points_every = None
        self._backup_restore_points_none = None
        self._backup_restore_points_some = None
        self._backup_service = None
        self._backup_store_repository = None
        self._backup_total_size = None
        self._backup_total_size_gt = None
        self._backup_total_size_gte = None
        self._backup_total_size_in = None
        self._backup_total_size_lt = None
        self._backup_total_size_lte = None
        self._backup_total_size_not = None
        self._backup_total_size_not_in = None
        self._compression = None
        self._compression_not = None
        self._compression_ratio = None
        self._compression_ratio_gt = None
        self._compression_ratio_gte = None
        self._compression_ratio_in = None
        self._compression_ratio_lt = None
        self._compression_ratio_lte = None
        self._compression_ratio_not = None
        self._compression_ratio_not_in = None
        self._created_at = None
        self._created_at_gt = None
        self._created_at_gte = None
        self._created_at_in = None
        self._created_at_lt = None
        self._created_at_lte = None
        self._created_at_not = None
        self._created_at_not_in = None
        self._delete_strategy = None
        self._delete_strategy_in = None
        self._delete_strategy_not = None
        self._delete_strategy_not_in = None
        self._description = None
        self._description_contains = None
        self._description_ends_with = None
        self._description_gt = None
        self._description_gte = None
        self._description_in = None
        self._description_lt = None
        self._description_lte = None
        self._description_not = None
        self._description_not_contains = None
        self._description_not_ends_with = None
        self._description_not_in = None
        self._description_not_starts_with = None
        self._description_starts_with = None
        self._enable_window = None
        self._enable_window_not = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._full_interval = None
        self._full_interval_gt = None
        self._full_interval_gte = None
        self._full_interval_in = None
        self._full_interval_lt = None
        self._full_interval_lte = None
        self._full_interval_not = None
        self._full_interval_not_in = None
        self._full_period = None
        self._full_period_in = None
        self._full_period_not = None
        self._full_period_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._incremental_interval = None
        self._incremental_interval_gt = None
        self._incremental_interval_gte = None
        self._incremental_interval_in = None
        self._incremental_interval_lt = None
        self._incremental_interval_lte = None
        self._incremental_interval_not = None
        self._incremental_interval_not_in = None
        self._incremental_period = None
        self._incremental_period_in = None
        self._incremental_period_not = None
        self._incremental_period_not_in = None
        self._keep_policy = None
        self._keep_policy_in = None
        self._keep_policy_not = None
        self._keep_policy_not_in = None
        self._keep_policy_value = None
        self._keep_policy_value_gt = None
        self._keep_policy_value_gte = None
        self._keep_policy_value_in = None
        self._keep_policy_value_lt = None
        self._keep_policy_value_lte = None
        self._keep_policy_value_not = None
        self._keep_policy_value_not_in = None
        self._last_execute_status = None
        self._last_execute_status_in = None
        self._last_execute_status_message = None
        self._last_execute_status_message_contains = None
        self._last_execute_status_message_ends_with = None
        self._last_execute_status_message_gt = None
        self._last_execute_status_message_gte = None
        self._last_execute_status_message_in = None
        self._last_execute_status_message_lt = None
        self._last_execute_status_message_lte = None
        self._last_execute_status_message_not = None
        self._last_execute_status_message_not_contains = None
        self._last_execute_status_message_not_ends_with = None
        self._last_execute_status_message_not_in = None
        self._last_execute_status_message_not_starts_with = None
        self._last_execute_status_message_starts_with = None
        self._last_execute_status_not = None
        self._last_execute_status_not_in = None
        self._last_execute_success_job_count = None
        self._last_execute_success_job_count_gt = None
        self._last_execute_success_job_count_gte = None
        self._last_execute_success_job_count_in = None
        self._last_execute_success_job_count_lt = None
        self._last_execute_success_job_count_lte = None
        self._last_execute_success_job_count_not = None
        self._last_execute_success_job_count_not_in = None
        self._last_execute_total_job_count = None
        self._last_execute_total_job_count_gt = None
        self._last_execute_total_job_count_gte = None
        self._last_execute_total_job_count_in = None
        self._last_execute_total_job_count_lt = None
        self._last_execute_total_job_count_lte = None
        self._last_execute_total_job_count_not = None
        self._last_execute_total_job_count_not_in = None
        self._last_executed_at = None
        self._last_executed_at_gt = None
        self._last_executed_at_gte = None
        self._last_executed_at_in = None
        self._last_executed_at_lt = None
        self._last_executed_at_lte = None
        self._last_executed_at_not = None
        self._last_executed_at_not_in = None
        self._last_manual_execute_status = None
        self._last_manual_execute_status_in = None
        self._last_manual_execute_status_message = None
        self._last_manual_execute_status_message_contains = None
        self._last_manual_execute_status_message_ends_with = None
        self._last_manual_execute_status_message_gt = None
        self._last_manual_execute_status_message_gte = None
        self._last_manual_execute_status_message_in = None
        self._last_manual_execute_status_message_lt = None
        self._last_manual_execute_status_message_lte = None
        self._last_manual_execute_status_message_not = None
        self._last_manual_execute_status_message_not_contains = None
        self._last_manual_execute_status_message_not_ends_with = None
        self._last_manual_execute_status_message_not_in = None
        self._last_manual_execute_status_message_not_starts_with = None
        self._last_manual_execute_status_message_starts_with = None
        self._last_manual_execute_status_not = None
        self._last_manual_execute_status_not_in = None
        self._last_manual_execute_success_job_count = None
        self._last_manual_execute_success_job_count_gt = None
        self._last_manual_execute_success_job_count_gte = None
        self._last_manual_execute_success_job_count_in = None
        self._last_manual_execute_success_job_count_lt = None
        self._last_manual_execute_success_job_count_lte = None
        self._last_manual_execute_success_job_count_not = None
        self._last_manual_execute_success_job_count_not_in = None
        self._last_manual_execute_total_job_count = None
        self._last_manual_execute_total_job_count_gt = None
        self._last_manual_execute_total_job_count_gte = None
        self._last_manual_execute_total_job_count_in = None
        self._last_manual_execute_total_job_count_lt = None
        self._last_manual_execute_total_job_count_lte = None
        self._last_manual_execute_total_job_count_not = None
        self._last_manual_execute_total_job_count_not_in = None
        self._last_manual_executed_at = None
        self._last_manual_executed_at_gt = None
        self._last_manual_executed_at_gte = None
        self._last_manual_executed_at_in = None
        self._last_manual_executed_at_lt = None
        self._last_manual_executed_at_lte = None
        self._last_manual_executed_at_not = None
        self._last_manual_executed_at_not_in = None
        self._logical_size = None
        self._logical_size_gt = None
        self._logical_size_gte = None
        self._logical_size_in = None
        self._logical_size_lt = None
        self._logical_size_lte = None
        self._logical_size_not = None
        self._logical_size_not_in = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._next_execute_time = None
        self._next_execute_time_gt = None
        self._next_execute_time_gte = None
        self._next_execute_time_in = None
        self._next_execute_time_lt = None
        self._next_execute_time_lte = None
        self._next_execute_time_not = None
        self._next_execute_time_not_in = None
        self._phase = None
        self._phase_in = None
        self._phase_not = None
        self._phase_not_in = None
        self._physical_size = None
        self._physical_size_gt = None
        self._physical_size_gte = None
        self._physical_size_in = None
        self._physical_size_lt = None
        self._physical_size_lte = None
        self._physical_size_not = None
        self._physical_size_not_in = None
        self._snapshot_consistent_type = None
        self._snapshot_consistent_type_in = None
        self._snapshot_consistent_type_not = None
        self._snapshot_consistent_type_not_in = None
        self._status = None
        self._status_in = None
        self._status_not = None
        self._status_not_in = None
        self._valid_size_of_backup_object = None
        self._valid_size_of_backup_object_gt = None
        self._valid_size_of_backup_object_gte = None
        self._valid_size_of_backup_object_in = None
        self._valid_size_of_backup_object_lt = None
        self._valid_size_of_backup_object_lte = None
        self._valid_size_of_backup_object_not = None
        self._valid_size_of_backup_object_not_in = None
        self._valid_size_of_restore_point = None
        self._valid_size_of_restore_point_gt = None
        self._valid_size_of_restore_point_gte = None
        self._valid_size_of_restore_point_in = None
        self._valid_size_of_restore_point_lt = None
        self._valid_size_of_restore_point_lte = None
        self._valid_size_of_restore_point_not = None
        self._valid_size_of_restore_point_not_in = None
        self._vms_every = None
        self._vms_none = None
        self._vms_some = None
        self._window_end = None
        self._window_end_contains = None
        self._window_end_ends_with = None
        self._window_end_gt = None
        self._window_end_gte = None
        self._window_end_in = None
        self._window_end_lt = None
        self._window_end_lte = None
        self._window_end_not = None
        self._window_end_not_contains = None
        self._window_end_not_ends_with = None
        self._window_end_not_in = None
        self._window_end_not_starts_with = None
        self._window_end_starts_with = None
        self._window_start = None
        self._window_start_contains = None
        self._window_start_ends_with = None
        self._window_start_gt = None
        self._window_start_gte = None
        self._window_start_in = None
        self._window_start_lt = None
        self._window_start_lte = None
        self._window_start_not = None
        self._window_start_not_contains = None
        self._window_start_not_ends_with = None
        self._window_start_not_in = None
        self._window_start_not_starts_with = None
        self._window_start_starts_with = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.backup_delay_option = kwargs.get("backup_delay_option", None)
        self.backup_delay_option_in = kwargs.get("backup_delay_option_in", None)
        self.backup_delay_option_not = kwargs.get("backup_delay_option_not", None)
        self.backup_delay_option_not_in = kwargs.get("backup_delay_option_not_in", None)
        self.backup_plan_executions_every = kwargs.get("backup_plan_executions_every", None)
        self.backup_plan_executions_none = kwargs.get("backup_plan_executions_none", None)
        self.backup_plan_executions_some = kwargs.get("backup_plan_executions_some", None)
        self.backup_restore_point_count = kwargs.get("backup_restore_point_count", None)
        self.backup_restore_point_count_gt = kwargs.get("backup_restore_point_count_gt", None)
        self.backup_restore_point_count_gte = kwargs.get("backup_restore_point_count_gte", None)
        self.backup_restore_point_count_in = kwargs.get("backup_restore_point_count_in", None)
        self.backup_restore_point_count_lt = kwargs.get("backup_restore_point_count_lt", None)
        self.backup_restore_point_count_lte = kwargs.get("backup_restore_point_count_lte", None)
        self.backup_restore_point_count_not = kwargs.get("backup_restore_point_count_not", None)
        self.backup_restore_point_count_not_in = kwargs.get("backup_restore_point_count_not_in", None)
        self.backup_restore_points_every = kwargs.get("backup_restore_points_every", None)
        self.backup_restore_points_none = kwargs.get("backup_restore_points_none", None)
        self.backup_restore_points_some = kwargs.get("backup_restore_points_some", None)
        self.backup_service = kwargs.get("backup_service", None)
        self.backup_store_repository = kwargs.get("backup_store_repository", None)
        self.backup_total_size = kwargs.get("backup_total_size", None)
        self.backup_total_size_gt = kwargs.get("backup_total_size_gt", None)
        self.backup_total_size_gte = kwargs.get("backup_total_size_gte", None)
        self.backup_total_size_in = kwargs.get("backup_total_size_in", None)
        self.backup_total_size_lt = kwargs.get("backup_total_size_lt", None)
        self.backup_total_size_lte = kwargs.get("backup_total_size_lte", None)
        self.backup_total_size_not = kwargs.get("backup_total_size_not", None)
        self.backup_total_size_not_in = kwargs.get("backup_total_size_not_in", None)
        self.compression = kwargs.get("compression", None)
        self.compression_not = kwargs.get("compression_not", None)
        self.compression_ratio = kwargs.get("compression_ratio", None)
        self.compression_ratio_gt = kwargs.get("compression_ratio_gt", None)
        self.compression_ratio_gte = kwargs.get("compression_ratio_gte", None)
        self.compression_ratio_in = kwargs.get("compression_ratio_in", None)
        self.compression_ratio_lt = kwargs.get("compression_ratio_lt", None)
        self.compression_ratio_lte = kwargs.get("compression_ratio_lte", None)
        self.compression_ratio_not = kwargs.get("compression_ratio_not", None)
        self.compression_ratio_not_in = kwargs.get("compression_ratio_not_in", None)
        self.created_at = kwargs.get("created_at", None)
        self.created_at_gt = kwargs.get("created_at_gt", None)
        self.created_at_gte = kwargs.get("created_at_gte", None)
        self.created_at_in = kwargs.get("created_at_in", None)
        self.created_at_lt = kwargs.get("created_at_lt", None)
        self.created_at_lte = kwargs.get("created_at_lte", None)
        self.created_at_not = kwargs.get("created_at_not", None)
        self.created_at_not_in = kwargs.get("created_at_not_in", None)
        self.delete_strategy = kwargs.get("delete_strategy", None)
        self.delete_strategy_in = kwargs.get("delete_strategy_in", None)
        self.delete_strategy_not = kwargs.get("delete_strategy_not", None)
        self.delete_strategy_not_in = kwargs.get("delete_strategy_not_in", None)
        self.description = kwargs.get("description", None)
        self.description_contains = kwargs.get("description_contains", None)
        self.description_ends_with = kwargs.get("description_ends_with", None)
        self.description_gt = kwargs.get("description_gt", None)
        self.description_gte = kwargs.get("description_gte", None)
        self.description_in = kwargs.get("description_in", None)
        self.description_lt = kwargs.get("description_lt", None)
        self.description_lte = kwargs.get("description_lte", None)
        self.description_not = kwargs.get("description_not", None)
        self.description_not_contains = kwargs.get("description_not_contains", None)
        self.description_not_ends_with = kwargs.get("description_not_ends_with", None)
        self.description_not_in = kwargs.get("description_not_in", None)
        self.description_not_starts_with = kwargs.get("description_not_starts_with", None)
        self.description_starts_with = kwargs.get("description_starts_with", None)
        self.enable_window = kwargs.get("enable_window", None)
        self.enable_window_not = kwargs.get("enable_window_not", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.full_interval = kwargs.get("full_interval", None)
        self.full_interval_gt = kwargs.get("full_interval_gt", None)
        self.full_interval_gte = kwargs.get("full_interval_gte", None)
        self.full_interval_in = kwargs.get("full_interval_in", None)
        self.full_interval_lt = kwargs.get("full_interval_lt", None)
        self.full_interval_lte = kwargs.get("full_interval_lte", None)
        self.full_interval_not = kwargs.get("full_interval_not", None)
        self.full_interval_not_in = kwargs.get("full_interval_not_in", None)
        self.full_period = kwargs.get("full_period", None)
        self.full_period_in = kwargs.get("full_period_in", None)
        self.full_period_not = kwargs.get("full_period_not", None)
        self.full_period_not_in = kwargs.get("full_period_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.incremental_interval = kwargs.get("incremental_interval", None)
        self.incremental_interval_gt = kwargs.get("incremental_interval_gt", None)
        self.incremental_interval_gte = kwargs.get("incremental_interval_gte", None)
        self.incremental_interval_in = kwargs.get("incremental_interval_in", None)
        self.incremental_interval_lt = kwargs.get("incremental_interval_lt", None)
        self.incremental_interval_lte = kwargs.get("incremental_interval_lte", None)
        self.incremental_interval_not = kwargs.get("incremental_interval_not", None)
        self.incremental_interval_not_in = kwargs.get("incremental_interval_not_in", None)
        self.incremental_period = kwargs.get("incremental_period", None)
        self.incremental_period_in = kwargs.get("incremental_period_in", None)
        self.incremental_period_not = kwargs.get("incremental_period_not", None)
        self.incremental_period_not_in = kwargs.get("incremental_period_not_in", None)
        self.keep_policy = kwargs.get("keep_policy", None)
        self.keep_policy_in = kwargs.get("keep_policy_in", None)
        self.keep_policy_not = kwargs.get("keep_policy_not", None)
        self.keep_policy_not_in = kwargs.get("keep_policy_not_in", None)
        self.keep_policy_value = kwargs.get("keep_policy_value", None)
        self.keep_policy_value_gt = kwargs.get("keep_policy_value_gt", None)
        self.keep_policy_value_gte = kwargs.get("keep_policy_value_gte", None)
        self.keep_policy_value_in = kwargs.get("keep_policy_value_in", None)
        self.keep_policy_value_lt = kwargs.get("keep_policy_value_lt", None)
        self.keep_policy_value_lte = kwargs.get("keep_policy_value_lte", None)
        self.keep_policy_value_not = kwargs.get("keep_policy_value_not", None)
        self.keep_policy_value_not_in = kwargs.get("keep_policy_value_not_in", None)
        self.last_execute_status = kwargs.get("last_execute_status", None)
        self.last_execute_status_in = kwargs.get("last_execute_status_in", None)
        self.last_execute_status_message = kwargs.get("last_execute_status_message", None)
        self.last_execute_status_message_contains = kwargs.get("last_execute_status_message_contains", None)
        self.last_execute_status_message_ends_with = kwargs.get("last_execute_status_message_ends_with", None)
        self.last_execute_status_message_gt = kwargs.get("last_execute_status_message_gt", None)
        self.last_execute_status_message_gte = kwargs.get("last_execute_status_message_gte", None)
        self.last_execute_status_message_in = kwargs.get("last_execute_status_message_in", None)
        self.last_execute_status_message_lt = kwargs.get("last_execute_status_message_lt", None)
        self.last_execute_status_message_lte = kwargs.get("last_execute_status_message_lte", None)
        self.last_execute_status_message_not = kwargs.get("last_execute_status_message_not", None)
        self.last_execute_status_message_not_contains = kwargs.get("last_execute_status_message_not_contains", None)
        self.last_execute_status_message_not_ends_with = kwargs.get("last_execute_status_message_not_ends_with", None)
        self.last_execute_status_message_not_in = kwargs.get("last_execute_status_message_not_in", None)
        self.last_execute_status_message_not_starts_with = kwargs.get("last_execute_status_message_not_starts_with", None)
        self.last_execute_status_message_starts_with = kwargs.get("last_execute_status_message_starts_with", None)
        self.last_execute_status_not = kwargs.get("last_execute_status_not", None)
        self.last_execute_status_not_in = kwargs.get("last_execute_status_not_in", None)
        self.last_execute_success_job_count = kwargs.get("last_execute_success_job_count", None)
        self.last_execute_success_job_count_gt = kwargs.get("last_execute_success_job_count_gt", None)
        self.last_execute_success_job_count_gte = kwargs.get("last_execute_success_job_count_gte", None)
        self.last_execute_success_job_count_in = kwargs.get("last_execute_success_job_count_in", None)
        self.last_execute_success_job_count_lt = kwargs.get("last_execute_success_job_count_lt", None)
        self.last_execute_success_job_count_lte = kwargs.get("last_execute_success_job_count_lte", None)
        self.last_execute_success_job_count_not = kwargs.get("last_execute_success_job_count_not", None)
        self.last_execute_success_job_count_not_in = kwargs.get("last_execute_success_job_count_not_in", None)
        self.last_execute_total_job_count = kwargs.get("last_execute_total_job_count", None)
        self.last_execute_total_job_count_gt = kwargs.get("last_execute_total_job_count_gt", None)
        self.last_execute_total_job_count_gte = kwargs.get("last_execute_total_job_count_gte", None)
        self.last_execute_total_job_count_in = kwargs.get("last_execute_total_job_count_in", None)
        self.last_execute_total_job_count_lt = kwargs.get("last_execute_total_job_count_lt", None)
        self.last_execute_total_job_count_lte = kwargs.get("last_execute_total_job_count_lte", None)
        self.last_execute_total_job_count_not = kwargs.get("last_execute_total_job_count_not", None)
        self.last_execute_total_job_count_not_in = kwargs.get("last_execute_total_job_count_not_in", None)
        self.last_executed_at = kwargs.get("last_executed_at", None)
        self.last_executed_at_gt = kwargs.get("last_executed_at_gt", None)
        self.last_executed_at_gte = kwargs.get("last_executed_at_gte", None)
        self.last_executed_at_in = kwargs.get("last_executed_at_in", None)
        self.last_executed_at_lt = kwargs.get("last_executed_at_lt", None)
        self.last_executed_at_lte = kwargs.get("last_executed_at_lte", None)
        self.last_executed_at_not = kwargs.get("last_executed_at_not", None)
        self.last_executed_at_not_in = kwargs.get("last_executed_at_not_in", None)
        self.last_manual_execute_status = kwargs.get("last_manual_execute_status", None)
        self.last_manual_execute_status_in = kwargs.get("last_manual_execute_status_in", None)
        self.last_manual_execute_status_message = kwargs.get("last_manual_execute_status_message", None)
        self.last_manual_execute_status_message_contains = kwargs.get("last_manual_execute_status_message_contains", None)
        self.last_manual_execute_status_message_ends_with = kwargs.get("last_manual_execute_status_message_ends_with", None)
        self.last_manual_execute_status_message_gt = kwargs.get("last_manual_execute_status_message_gt", None)
        self.last_manual_execute_status_message_gte = kwargs.get("last_manual_execute_status_message_gte", None)
        self.last_manual_execute_status_message_in = kwargs.get("last_manual_execute_status_message_in", None)
        self.last_manual_execute_status_message_lt = kwargs.get("last_manual_execute_status_message_lt", None)
        self.last_manual_execute_status_message_lte = kwargs.get("last_manual_execute_status_message_lte", None)
        self.last_manual_execute_status_message_not = kwargs.get("last_manual_execute_status_message_not", None)
        self.last_manual_execute_status_message_not_contains = kwargs.get("last_manual_execute_status_message_not_contains", None)
        self.last_manual_execute_status_message_not_ends_with = kwargs.get("last_manual_execute_status_message_not_ends_with", None)
        self.last_manual_execute_status_message_not_in = kwargs.get("last_manual_execute_status_message_not_in", None)
        self.last_manual_execute_status_message_not_starts_with = kwargs.get("last_manual_execute_status_message_not_starts_with", None)
        self.last_manual_execute_status_message_starts_with = kwargs.get("last_manual_execute_status_message_starts_with", None)
        self.last_manual_execute_status_not = kwargs.get("last_manual_execute_status_not", None)
        self.last_manual_execute_status_not_in = kwargs.get("last_manual_execute_status_not_in", None)
        self.last_manual_execute_success_job_count = kwargs.get("last_manual_execute_success_job_count", None)
        self.last_manual_execute_success_job_count_gt = kwargs.get("last_manual_execute_success_job_count_gt", None)
        self.last_manual_execute_success_job_count_gte = kwargs.get("last_manual_execute_success_job_count_gte", None)
        self.last_manual_execute_success_job_count_in = kwargs.get("last_manual_execute_success_job_count_in", None)
        self.last_manual_execute_success_job_count_lt = kwargs.get("last_manual_execute_success_job_count_lt", None)
        self.last_manual_execute_success_job_count_lte = kwargs.get("last_manual_execute_success_job_count_lte", None)
        self.last_manual_execute_success_job_count_not = kwargs.get("last_manual_execute_success_job_count_not", None)
        self.last_manual_execute_success_job_count_not_in = kwargs.get("last_manual_execute_success_job_count_not_in", None)
        self.last_manual_execute_total_job_count = kwargs.get("last_manual_execute_total_job_count", None)
        self.last_manual_execute_total_job_count_gt = kwargs.get("last_manual_execute_total_job_count_gt", None)
        self.last_manual_execute_total_job_count_gte = kwargs.get("last_manual_execute_total_job_count_gte", None)
        self.last_manual_execute_total_job_count_in = kwargs.get("last_manual_execute_total_job_count_in", None)
        self.last_manual_execute_total_job_count_lt = kwargs.get("last_manual_execute_total_job_count_lt", None)
        self.last_manual_execute_total_job_count_lte = kwargs.get("last_manual_execute_total_job_count_lte", None)
        self.last_manual_execute_total_job_count_not = kwargs.get("last_manual_execute_total_job_count_not", None)
        self.last_manual_execute_total_job_count_not_in = kwargs.get("last_manual_execute_total_job_count_not_in", None)
        self.last_manual_executed_at = kwargs.get("last_manual_executed_at", None)
        self.last_manual_executed_at_gt = kwargs.get("last_manual_executed_at_gt", None)
        self.last_manual_executed_at_gte = kwargs.get("last_manual_executed_at_gte", None)
        self.last_manual_executed_at_in = kwargs.get("last_manual_executed_at_in", None)
        self.last_manual_executed_at_lt = kwargs.get("last_manual_executed_at_lt", None)
        self.last_manual_executed_at_lte = kwargs.get("last_manual_executed_at_lte", None)
        self.last_manual_executed_at_not = kwargs.get("last_manual_executed_at_not", None)
        self.last_manual_executed_at_not_in = kwargs.get("last_manual_executed_at_not_in", None)
        self.logical_size = kwargs.get("logical_size", None)
        self.logical_size_gt = kwargs.get("logical_size_gt", None)
        self.logical_size_gte = kwargs.get("logical_size_gte", None)
        self.logical_size_in = kwargs.get("logical_size_in", None)
        self.logical_size_lt = kwargs.get("logical_size_lt", None)
        self.logical_size_lte = kwargs.get("logical_size_lte", None)
        self.logical_size_not = kwargs.get("logical_size_not", None)
        self.logical_size_not_in = kwargs.get("logical_size_not_in", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.next_execute_time = kwargs.get("next_execute_time", None)
        self.next_execute_time_gt = kwargs.get("next_execute_time_gt", None)
        self.next_execute_time_gte = kwargs.get("next_execute_time_gte", None)
        self.next_execute_time_in = kwargs.get("next_execute_time_in", None)
        self.next_execute_time_lt = kwargs.get("next_execute_time_lt", None)
        self.next_execute_time_lte = kwargs.get("next_execute_time_lte", None)
        self.next_execute_time_not = kwargs.get("next_execute_time_not", None)
        self.next_execute_time_not_in = kwargs.get("next_execute_time_not_in", None)
        self.phase = kwargs.get("phase", None)
        self.phase_in = kwargs.get("phase_in", None)
        self.phase_not = kwargs.get("phase_not", None)
        self.phase_not_in = kwargs.get("phase_not_in", None)
        self.physical_size = kwargs.get("physical_size", None)
        self.physical_size_gt = kwargs.get("physical_size_gt", None)
        self.physical_size_gte = kwargs.get("physical_size_gte", None)
        self.physical_size_in = kwargs.get("physical_size_in", None)
        self.physical_size_lt = kwargs.get("physical_size_lt", None)
        self.physical_size_lte = kwargs.get("physical_size_lte", None)
        self.physical_size_not = kwargs.get("physical_size_not", None)
        self.physical_size_not_in = kwargs.get("physical_size_not_in", None)
        self.snapshot_consistent_type = kwargs.get("snapshot_consistent_type", None)
        self.snapshot_consistent_type_in = kwargs.get("snapshot_consistent_type_in", None)
        self.snapshot_consistent_type_not = kwargs.get("snapshot_consistent_type_not", None)
        self.snapshot_consistent_type_not_in = kwargs.get("snapshot_consistent_type_not_in", None)
        self.status = kwargs.get("status", None)
        self.status_in = kwargs.get("status_in", None)
        self.status_not = kwargs.get("status_not", None)
        self.status_not_in = kwargs.get("status_not_in", None)
        self.valid_size_of_backup_object = kwargs.get("valid_size_of_backup_object", None)
        self.valid_size_of_backup_object_gt = kwargs.get("valid_size_of_backup_object_gt", None)
        self.valid_size_of_backup_object_gte = kwargs.get("valid_size_of_backup_object_gte", None)
        self.valid_size_of_backup_object_in = kwargs.get("valid_size_of_backup_object_in", None)
        self.valid_size_of_backup_object_lt = kwargs.get("valid_size_of_backup_object_lt", None)
        self.valid_size_of_backup_object_lte = kwargs.get("valid_size_of_backup_object_lte", None)
        self.valid_size_of_backup_object_not = kwargs.get("valid_size_of_backup_object_not", None)
        self.valid_size_of_backup_object_not_in = kwargs.get("valid_size_of_backup_object_not_in", None)
        self.valid_size_of_restore_point = kwargs.get("valid_size_of_restore_point", None)
        self.valid_size_of_restore_point_gt = kwargs.get("valid_size_of_restore_point_gt", None)
        self.valid_size_of_restore_point_gte = kwargs.get("valid_size_of_restore_point_gte", None)
        self.valid_size_of_restore_point_in = kwargs.get("valid_size_of_restore_point_in", None)
        self.valid_size_of_restore_point_lt = kwargs.get("valid_size_of_restore_point_lt", None)
        self.valid_size_of_restore_point_lte = kwargs.get("valid_size_of_restore_point_lte", None)
        self.valid_size_of_restore_point_not = kwargs.get("valid_size_of_restore_point_not", None)
        self.valid_size_of_restore_point_not_in = kwargs.get("valid_size_of_restore_point_not_in", None)
        self.vms_every = kwargs.get("vms_every", None)
        self.vms_none = kwargs.get("vms_none", None)
        self.vms_some = kwargs.get("vms_some", None)
        self.window_end = kwargs.get("window_end", None)
        self.window_end_contains = kwargs.get("window_end_contains", None)
        self.window_end_ends_with = kwargs.get("window_end_ends_with", None)
        self.window_end_gt = kwargs.get("window_end_gt", None)
        self.window_end_gte = kwargs.get("window_end_gte", None)
        self.window_end_in = kwargs.get("window_end_in", None)
        self.window_end_lt = kwargs.get("window_end_lt", None)
        self.window_end_lte = kwargs.get("window_end_lte", None)
        self.window_end_not = kwargs.get("window_end_not", None)
        self.window_end_not_contains = kwargs.get("window_end_not_contains", None)
        self.window_end_not_ends_with = kwargs.get("window_end_not_ends_with", None)
        self.window_end_not_in = kwargs.get("window_end_not_in", None)
        self.window_end_not_starts_with = kwargs.get("window_end_not_starts_with", None)
        self.window_end_starts_with = kwargs.get("window_end_starts_with", None)
        self.window_start = kwargs.get("window_start", None)
        self.window_start_contains = kwargs.get("window_start_contains", None)
        self.window_start_ends_with = kwargs.get("window_start_ends_with", None)
        self.window_start_gt = kwargs.get("window_start_gt", None)
        self.window_start_gte = kwargs.get("window_start_gte", None)
        self.window_start_in = kwargs.get("window_start_in", None)
        self.window_start_lt = kwargs.get("window_start_lt", None)
        self.window_start_lte = kwargs.get("window_start_lte", None)
        self.window_start_not = kwargs.get("window_start_not", None)
        self.window_start_not_contains = kwargs.get("window_start_not_contains", None)
        self.window_start_not_ends_with = kwargs.get("window_start_not_ends_with", None)
        self.window_start_not_in = kwargs.get("window_start_not_in", None)
        self.window_start_not_starts_with = kwargs.get("window_start_not_starts_with", None)
        self.window_start_starts_with = kwargs.get("window_start_starts_with", None)

    @property
    def _and(self):
        """Gets the _and of this BackupPlanWhereInput.  # noqa: E501


        :return: The _and of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this BackupPlanWhereInput.


        :param _and: The _and of this BackupPlanWhereInput.  # noqa: E501
        :type _and: list[BackupPlanWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this BackupPlanWhereInput.  # noqa: E501


        :return: The _not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this BackupPlanWhereInput.


        :param _not: The _not of this BackupPlanWhereInput.  # noqa: E501
        :type _not: list[BackupPlanWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this BackupPlanWhereInput.  # noqa: E501


        :return: The _or of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this BackupPlanWhereInput.


        :param _or: The _or of this BackupPlanWhereInput.  # noqa: E501
        :type _or: list[BackupPlanWhereInput]
        """

        self.__or = _or

    @property
    def backup_delay_option(self):
        """Gets the backup_delay_option of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_delay_option of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanDelayOption
        """
        return self._backup_delay_option

    @backup_delay_option.setter
    def backup_delay_option(self, backup_delay_option):
        """Sets the backup_delay_option of this BackupPlanWhereInput.


        :param backup_delay_option: The backup_delay_option of this BackupPlanWhereInput.  # noqa: E501
        :type backup_delay_option: BackupPlanDelayOption
        """

        self._backup_delay_option = backup_delay_option

    @property
    def backup_delay_option_in(self):
        """Gets the backup_delay_option_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_delay_option_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanDelayOption]
        """
        return self._backup_delay_option_in

    @backup_delay_option_in.setter
    def backup_delay_option_in(self, backup_delay_option_in):
        """Sets the backup_delay_option_in of this BackupPlanWhereInput.


        :param backup_delay_option_in: The backup_delay_option_in of this BackupPlanWhereInput.  # noqa: E501
        :type backup_delay_option_in: list[BackupPlanDelayOption]
        """

        self._backup_delay_option_in = backup_delay_option_in

    @property
    def backup_delay_option_not(self):
        """Gets the backup_delay_option_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_delay_option_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanDelayOption
        """
        return self._backup_delay_option_not

    @backup_delay_option_not.setter
    def backup_delay_option_not(self, backup_delay_option_not):
        """Sets the backup_delay_option_not of this BackupPlanWhereInput.


        :param backup_delay_option_not: The backup_delay_option_not of this BackupPlanWhereInput.  # noqa: E501
        :type backup_delay_option_not: BackupPlanDelayOption
        """

        self._backup_delay_option_not = backup_delay_option_not

    @property
    def backup_delay_option_not_in(self):
        """Gets the backup_delay_option_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_delay_option_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanDelayOption]
        """
        return self._backup_delay_option_not_in

    @backup_delay_option_not_in.setter
    def backup_delay_option_not_in(self, backup_delay_option_not_in):
        """Sets the backup_delay_option_not_in of this BackupPlanWhereInput.


        :param backup_delay_option_not_in: The backup_delay_option_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type backup_delay_option_not_in: list[BackupPlanDelayOption]
        """

        self._backup_delay_option_not_in = backup_delay_option_not_in

    @property
    def backup_plan_executions_every(self):
        """Gets the backup_plan_executions_every of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_plan_executions_every of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionWhereInput
        """
        return self._backup_plan_executions_every

    @backup_plan_executions_every.setter
    def backup_plan_executions_every(self, backup_plan_executions_every):
        """Sets the backup_plan_executions_every of this BackupPlanWhereInput.


        :param backup_plan_executions_every: The backup_plan_executions_every of this BackupPlanWhereInput.  # noqa: E501
        :type backup_plan_executions_every: BackupPlanExecutionWhereInput
        """

        self._backup_plan_executions_every = backup_plan_executions_every

    @property
    def backup_plan_executions_none(self):
        """Gets the backup_plan_executions_none of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_plan_executions_none of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionWhereInput
        """
        return self._backup_plan_executions_none

    @backup_plan_executions_none.setter
    def backup_plan_executions_none(self, backup_plan_executions_none):
        """Sets the backup_plan_executions_none of this BackupPlanWhereInput.


        :param backup_plan_executions_none: The backup_plan_executions_none of this BackupPlanWhereInput.  # noqa: E501
        :type backup_plan_executions_none: BackupPlanExecutionWhereInput
        """

        self._backup_plan_executions_none = backup_plan_executions_none

    @property
    def backup_plan_executions_some(self):
        """Gets the backup_plan_executions_some of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_plan_executions_some of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionWhereInput
        """
        return self._backup_plan_executions_some

    @backup_plan_executions_some.setter
    def backup_plan_executions_some(self, backup_plan_executions_some):
        """Sets the backup_plan_executions_some of this BackupPlanWhereInput.


        :param backup_plan_executions_some: The backup_plan_executions_some of this BackupPlanWhereInput.  # noqa: E501
        :type backup_plan_executions_some: BackupPlanExecutionWhereInput
        """

        self._backup_plan_executions_some = backup_plan_executions_some

    @property
    def backup_restore_point_count(self):
        """Gets the backup_restore_point_count of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_restore_point_count of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_restore_point_count

    @backup_restore_point_count.setter
    def backup_restore_point_count(self, backup_restore_point_count):
        """Sets the backup_restore_point_count of this BackupPlanWhereInput.


        :param backup_restore_point_count: The backup_restore_point_count of this BackupPlanWhereInput.  # noqa: E501
        :type backup_restore_point_count: int
        """

        self._backup_restore_point_count = backup_restore_point_count

    @property
    def backup_restore_point_count_gt(self):
        """Gets the backup_restore_point_count_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_restore_point_count_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_restore_point_count_gt

    @backup_restore_point_count_gt.setter
    def backup_restore_point_count_gt(self, backup_restore_point_count_gt):
        """Sets the backup_restore_point_count_gt of this BackupPlanWhereInput.


        :param backup_restore_point_count_gt: The backup_restore_point_count_gt of this BackupPlanWhereInput.  # noqa: E501
        :type backup_restore_point_count_gt: int
        """

        self._backup_restore_point_count_gt = backup_restore_point_count_gt

    @property
    def backup_restore_point_count_gte(self):
        """Gets the backup_restore_point_count_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_restore_point_count_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_restore_point_count_gte

    @backup_restore_point_count_gte.setter
    def backup_restore_point_count_gte(self, backup_restore_point_count_gte):
        """Sets the backup_restore_point_count_gte of this BackupPlanWhereInput.


        :param backup_restore_point_count_gte: The backup_restore_point_count_gte of this BackupPlanWhereInput.  # noqa: E501
        :type backup_restore_point_count_gte: int
        """

        self._backup_restore_point_count_gte = backup_restore_point_count_gte

    @property
    def backup_restore_point_count_in(self):
        """Gets the backup_restore_point_count_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_restore_point_count_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._backup_restore_point_count_in

    @backup_restore_point_count_in.setter
    def backup_restore_point_count_in(self, backup_restore_point_count_in):
        """Sets the backup_restore_point_count_in of this BackupPlanWhereInput.


        :param backup_restore_point_count_in: The backup_restore_point_count_in of this BackupPlanWhereInput.  # noqa: E501
        :type backup_restore_point_count_in: list[int]
        """

        self._backup_restore_point_count_in = backup_restore_point_count_in

    @property
    def backup_restore_point_count_lt(self):
        """Gets the backup_restore_point_count_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_restore_point_count_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_restore_point_count_lt

    @backup_restore_point_count_lt.setter
    def backup_restore_point_count_lt(self, backup_restore_point_count_lt):
        """Sets the backup_restore_point_count_lt of this BackupPlanWhereInput.


        :param backup_restore_point_count_lt: The backup_restore_point_count_lt of this BackupPlanWhereInput.  # noqa: E501
        :type backup_restore_point_count_lt: int
        """

        self._backup_restore_point_count_lt = backup_restore_point_count_lt

    @property
    def backup_restore_point_count_lte(self):
        """Gets the backup_restore_point_count_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_restore_point_count_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_restore_point_count_lte

    @backup_restore_point_count_lte.setter
    def backup_restore_point_count_lte(self, backup_restore_point_count_lte):
        """Sets the backup_restore_point_count_lte of this BackupPlanWhereInput.


        :param backup_restore_point_count_lte: The backup_restore_point_count_lte of this BackupPlanWhereInput.  # noqa: E501
        :type backup_restore_point_count_lte: int
        """

        self._backup_restore_point_count_lte = backup_restore_point_count_lte

    @property
    def backup_restore_point_count_not(self):
        """Gets the backup_restore_point_count_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_restore_point_count_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_restore_point_count_not

    @backup_restore_point_count_not.setter
    def backup_restore_point_count_not(self, backup_restore_point_count_not):
        """Sets the backup_restore_point_count_not of this BackupPlanWhereInput.


        :param backup_restore_point_count_not: The backup_restore_point_count_not of this BackupPlanWhereInput.  # noqa: E501
        :type backup_restore_point_count_not: int
        """

        self._backup_restore_point_count_not = backup_restore_point_count_not

    @property
    def backup_restore_point_count_not_in(self):
        """Gets the backup_restore_point_count_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_restore_point_count_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._backup_restore_point_count_not_in

    @backup_restore_point_count_not_in.setter
    def backup_restore_point_count_not_in(self, backup_restore_point_count_not_in):
        """Sets the backup_restore_point_count_not_in of this BackupPlanWhereInput.


        :param backup_restore_point_count_not_in: The backup_restore_point_count_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type backup_restore_point_count_not_in: list[int]
        """

        self._backup_restore_point_count_not_in = backup_restore_point_count_not_in

    @property
    def backup_restore_points_every(self):
        """Gets the backup_restore_points_every of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_restore_points_every of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupRestorePointWhereInput
        """
        return self._backup_restore_points_every

    @backup_restore_points_every.setter
    def backup_restore_points_every(self, backup_restore_points_every):
        """Sets the backup_restore_points_every of this BackupPlanWhereInput.


        :param backup_restore_points_every: The backup_restore_points_every of this BackupPlanWhereInput.  # noqa: E501
        :type backup_restore_points_every: BackupRestorePointWhereInput
        """

        self._backup_restore_points_every = backup_restore_points_every

    @property
    def backup_restore_points_none(self):
        """Gets the backup_restore_points_none of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_restore_points_none of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupRestorePointWhereInput
        """
        return self._backup_restore_points_none

    @backup_restore_points_none.setter
    def backup_restore_points_none(self, backup_restore_points_none):
        """Sets the backup_restore_points_none of this BackupPlanWhereInput.


        :param backup_restore_points_none: The backup_restore_points_none of this BackupPlanWhereInput.  # noqa: E501
        :type backup_restore_points_none: BackupRestorePointWhereInput
        """

        self._backup_restore_points_none = backup_restore_points_none

    @property
    def backup_restore_points_some(self):
        """Gets the backup_restore_points_some of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_restore_points_some of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupRestorePointWhereInput
        """
        return self._backup_restore_points_some

    @backup_restore_points_some.setter
    def backup_restore_points_some(self, backup_restore_points_some):
        """Sets the backup_restore_points_some of this BackupPlanWhereInput.


        :param backup_restore_points_some: The backup_restore_points_some of this BackupPlanWhereInput.  # noqa: E501
        :type backup_restore_points_some: BackupRestorePointWhereInput
        """

        self._backup_restore_points_some = backup_restore_points_some

    @property
    def backup_service(self):
        """Gets the backup_service of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_service of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupServiceWhereInput
        """
        return self._backup_service

    @backup_service.setter
    def backup_service(self, backup_service):
        """Sets the backup_service of this BackupPlanWhereInput.


        :param backup_service: The backup_service of this BackupPlanWhereInput.  # noqa: E501
        :type backup_service: BackupServiceWhereInput
        """

        self._backup_service = backup_service

    @property
    def backup_store_repository(self):
        """Gets the backup_store_repository of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_store_repository of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupStoreRepositoryWhereInput
        """
        return self._backup_store_repository

    @backup_store_repository.setter
    def backup_store_repository(self, backup_store_repository):
        """Sets the backup_store_repository of this BackupPlanWhereInput.


        :param backup_store_repository: The backup_store_repository of this BackupPlanWhereInput.  # noqa: E501
        :type backup_store_repository: BackupStoreRepositoryWhereInput
        """

        self._backup_store_repository = backup_store_repository

    @property
    def backup_total_size(self):
        """Gets the backup_total_size of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_total_size of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_total_size

    @backup_total_size.setter
    def backup_total_size(self, backup_total_size):
        """Sets the backup_total_size of this BackupPlanWhereInput.


        :param backup_total_size: The backup_total_size of this BackupPlanWhereInput.  # noqa: E501
        :type backup_total_size: int
        """

        self._backup_total_size = backup_total_size

    @property
    def backup_total_size_gt(self):
        """Gets the backup_total_size_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_total_size_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_total_size_gt

    @backup_total_size_gt.setter
    def backup_total_size_gt(self, backup_total_size_gt):
        """Sets the backup_total_size_gt of this BackupPlanWhereInput.


        :param backup_total_size_gt: The backup_total_size_gt of this BackupPlanWhereInput.  # noqa: E501
        :type backup_total_size_gt: int
        """

        self._backup_total_size_gt = backup_total_size_gt

    @property
    def backup_total_size_gte(self):
        """Gets the backup_total_size_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_total_size_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_total_size_gte

    @backup_total_size_gte.setter
    def backup_total_size_gte(self, backup_total_size_gte):
        """Sets the backup_total_size_gte of this BackupPlanWhereInput.


        :param backup_total_size_gte: The backup_total_size_gte of this BackupPlanWhereInput.  # noqa: E501
        :type backup_total_size_gte: int
        """

        self._backup_total_size_gte = backup_total_size_gte

    @property
    def backup_total_size_in(self):
        """Gets the backup_total_size_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_total_size_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._backup_total_size_in

    @backup_total_size_in.setter
    def backup_total_size_in(self, backup_total_size_in):
        """Sets the backup_total_size_in of this BackupPlanWhereInput.


        :param backup_total_size_in: The backup_total_size_in of this BackupPlanWhereInput.  # noqa: E501
        :type backup_total_size_in: list[int]
        """

        self._backup_total_size_in = backup_total_size_in

    @property
    def backup_total_size_lt(self):
        """Gets the backup_total_size_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_total_size_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_total_size_lt

    @backup_total_size_lt.setter
    def backup_total_size_lt(self, backup_total_size_lt):
        """Sets the backup_total_size_lt of this BackupPlanWhereInput.


        :param backup_total_size_lt: The backup_total_size_lt of this BackupPlanWhereInput.  # noqa: E501
        :type backup_total_size_lt: int
        """

        self._backup_total_size_lt = backup_total_size_lt

    @property
    def backup_total_size_lte(self):
        """Gets the backup_total_size_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_total_size_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_total_size_lte

    @backup_total_size_lte.setter
    def backup_total_size_lte(self, backup_total_size_lte):
        """Sets the backup_total_size_lte of this BackupPlanWhereInput.


        :param backup_total_size_lte: The backup_total_size_lte of this BackupPlanWhereInput.  # noqa: E501
        :type backup_total_size_lte: int
        """

        self._backup_total_size_lte = backup_total_size_lte

    @property
    def backup_total_size_not(self):
        """Gets the backup_total_size_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_total_size_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_total_size_not

    @backup_total_size_not.setter
    def backup_total_size_not(self, backup_total_size_not):
        """Sets the backup_total_size_not of this BackupPlanWhereInput.


        :param backup_total_size_not: The backup_total_size_not of this BackupPlanWhereInput.  # noqa: E501
        :type backup_total_size_not: int
        """

        self._backup_total_size_not = backup_total_size_not

    @property
    def backup_total_size_not_in(self):
        """Gets the backup_total_size_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The backup_total_size_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._backup_total_size_not_in

    @backup_total_size_not_in.setter
    def backup_total_size_not_in(self, backup_total_size_not_in):
        """Sets the backup_total_size_not_in of this BackupPlanWhereInput.


        :param backup_total_size_not_in: The backup_total_size_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type backup_total_size_not_in: list[int]
        """

        self._backup_total_size_not_in = backup_total_size_not_in

    @property
    def compression(self):
        """Gets the compression of this BackupPlanWhereInput.  # noqa: E501


        :return: The compression of this BackupPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._compression

    @compression.setter
    def compression(self, compression):
        """Sets the compression of this BackupPlanWhereInput.


        :param compression: The compression of this BackupPlanWhereInput.  # noqa: E501
        :type compression: bool
        """

        self._compression = compression

    @property
    def compression_not(self):
        """Gets the compression_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The compression_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._compression_not

    @compression_not.setter
    def compression_not(self, compression_not):
        """Sets the compression_not of this BackupPlanWhereInput.


        :param compression_not: The compression_not of this BackupPlanWhereInput.  # noqa: E501
        :type compression_not: bool
        """

        self._compression_not = compression_not

    @property
    def compression_ratio(self):
        """Gets the compression_ratio of this BackupPlanWhereInput.  # noqa: E501


        :return: The compression_ratio of this BackupPlanWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio

    @compression_ratio.setter
    def compression_ratio(self, compression_ratio):
        """Sets the compression_ratio of this BackupPlanWhereInput.


        :param compression_ratio: The compression_ratio of this BackupPlanWhereInput.  # noqa: E501
        :type compression_ratio: float
        """

        self._compression_ratio = compression_ratio

    @property
    def compression_ratio_gt(self):
        """Gets the compression_ratio_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The compression_ratio_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio_gt

    @compression_ratio_gt.setter
    def compression_ratio_gt(self, compression_ratio_gt):
        """Sets the compression_ratio_gt of this BackupPlanWhereInput.


        :param compression_ratio_gt: The compression_ratio_gt of this BackupPlanWhereInput.  # noqa: E501
        :type compression_ratio_gt: float
        """

        self._compression_ratio_gt = compression_ratio_gt

    @property
    def compression_ratio_gte(self):
        """Gets the compression_ratio_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The compression_ratio_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio_gte

    @compression_ratio_gte.setter
    def compression_ratio_gte(self, compression_ratio_gte):
        """Sets the compression_ratio_gte of this BackupPlanWhereInput.


        :param compression_ratio_gte: The compression_ratio_gte of this BackupPlanWhereInput.  # noqa: E501
        :type compression_ratio_gte: float
        """

        self._compression_ratio_gte = compression_ratio_gte

    @property
    def compression_ratio_in(self):
        """Gets the compression_ratio_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The compression_ratio_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._compression_ratio_in

    @compression_ratio_in.setter
    def compression_ratio_in(self, compression_ratio_in):
        """Sets the compression_ratio_in of this BackupPlanWhereInput.


        :param compression_ratio_in: The compression_ratio_in of this BackupPlanWhereInput.  # noqa: E501
        :type compression_ratio_in: list[float]
        """

        self._compression_ratio_in = compression_ratio_in

    @property
    def compression_ratio_lt(self):
        """Gets the compression_ratio_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The compression_ratio_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio_lt

    @compression_ratio_lt.setter
    def compression_ratio_lt(self, compression_ratio_lt):
        """Sets the compression_ratio_lt of this BackupPlanWhereInput.


        :param compression_ratio_lt: The compression_ratio_lt of this BackupPlanWhereInput.  # noqa: E501
        :type compression_ratio_lt: float
        """

        self._compression_ratio_lt = compression_ratio_lt

    @property
    def compression_ratio_lte(self):
        """Gets the compression_ratio_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The compression_ratio_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio_lte

    @compression_ratio_lte.setter
    def compression_ratio_lte(self, compression_ratio_lte):
        """Sets the compression_ratio_lte of this BackupPlanWhereInput.


        :param compression_ratio_lte: The compression_ratio_lte of this BackupPlanWhereInput.  # noqa: E501
        :type compression_ratio_lte: float
        """

        self._compression_ratio_lte = compression_ratio_lte

    @property
    def compression_ratio_not(self):
        """Gets the compression_ratio_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The compression_ratio_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio_not

    @compression_ratio_not.setter
    def compression_ratio_not(self, compression_ratio_not):
        """Sets the compression_ratio_not of this BackupPlanWhereInput.


        :param compression_ratio_not: The compression_ratio_not of this BackupPlanWhereInput.  # noqa: E501
        :type compression_ratio_not: float
        """

        self._compression_ratio_not = compression_ratio_not

    @property
    def compression_ratio_not_in(self):
        """Gets the compression_ratio_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The compression_ratio_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._compression_ratio_not_in

    @compression_ratio_not_in.setter
    def compression_ratio_not_in(self, compression_ratio_not_in):
        """Sets the compression_ratio_not_in of this BackupPlanWhereInput.


        :param compression_ratio_not_in: The compression_ratio_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type compression_ratio_not_in: list[float]
        """

        self._compression_ratio_not_in = compression_ratio_not_in

    @property
    def created_at(self):
        """Gets the created_at of this BackupPlanWhereInput.  # noqa: E501


        :return: The created_at of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this BackupPlanWhereInput.


        :param created_at: The created_at of this BackupPlanWhereInput.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def created_at_gt(self):
        """Gets the created_at_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The created_at_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_gt

    @created_at_gt.setter
    def created_at_gt(self, created_at_gt):
        """Sets the created_at_gt of this BackupPlanWhereInput.


        :param created_at_gt: The created_at_gt of this BackupPlanWhereInput.  # noqa: E501
        :type created_at_gt: str
        """

        self._created_at_gt = created_at_gt

    @property
    def created_at_gte(self):
        """Gets the created_at_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The created_at_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_gte

    @created_at_gte.setter
    def created_at_gte(self, created_at_gte):
        """Sets the created_at_gte of this BackupPlanWhereInput.


        :param created_at_gte: The created_at_gte of this BackupPlanWhereInput.  # noqa: E501
        :type created_at_gte: str
        """

        self._created_at_gte = created_at_gte

    @property
    def created_at_in(self):
        """Gets the created_at_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The created_at_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._created_at_in

    @created_at_in.setter
    def created_at_in(self, created_at_in):
        """Sets the created_at_in of this BackupPlanWhereInput.


        :param created_at_in: The created_at_in of this BackupPlanWhereInput.  # noqa: E501
        :type created_at_in: list[str]
        """

        self._created_at_in = created_at_in

    @property
    def created_at_lt(self):
        """Gets the created_at_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The created_at_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_lt

    @created_at_lt.setter
    def created_at_lt(self, created_at_lt):
        """Sets the created_at_lt of this BackupPlanWhereInput.


        :param created_at_lt: The created_at_lt of this BackupPlanWhereInput.  # noqa: E501
        :type created_at_lt: str
        """

        self._created_at_lt = created_at_lt

    @property
    def created_at_lte(self):
        """Gets the created_at_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The created_at_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_lte

    @created_at_lte.setter
    def created_at_lte(self, created_at_lte):
        """Sets the created_at_lte of this BackupPlanWhereInput.


        :param created_at_lte: The created_at_lte of this BackupPlanWhereInput.  # noqa: E501
        :type created_at_lte: str
        """

        self._created_at_lte = created_at_lte

    @property
    def created_at_not(self):
        """Gets the created_at_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The created_at_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_not

    @created_at_not.setter
    def created_at_not(self, created_at_not):
        """Sets the created_at_not of this BackupPlanWhereInput.


        :param created_at_not: The created_at_not of this BackupPlanWhereInput.  # noqa: E501
        :type created_at_not: str
        """

        self._created_at_not = created_at_not

    @property
    def created_at_not_in(self):
        """Gets the created_at_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The created_at_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._created_at_not_in

    @created_at_not_in.setter
    def created_at_not_in(self, created_at_not_in):
        """Sets the created_at_not_in of this BackupPlanWhereInput.


        :param created_at_not_in: The created_at_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type created_at_not_in: list[str]
        """

        self._created_at_not_in = created_at_not_in

    @property
    def delete_strategy(self):
        """Gets the delete_strategy of this BackupPlanWhereInput.  # noqa: E501


        :return: The delete_strategy of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanDeleteStrategy
        """
        return self._delete_strategy

    @delete_strategy.setter
    def delete_strategy(self, delete_strategy):
        """Sets the delete_strategy of this BackupPlanWhereInput.


        :param delete_strategy: The delete_strategy of this BackupPlanWhereInput.  # noqa: E501
        :type delete_strategy: BackupPlanDeleteStrategy
        """

        self._delete_strategy = delete_strategy

    @property
    def delete_strategy_in(self):
        """Gets the delete_strategy_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The delete_strategy_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanDeleteStrategy]
        """
        return self._delete_strategy_in

    @delete_strategy_in.setter
    def delete_strategy_in(self, delete_strategy_in):
        """Sets the delete_strategy_in of this BackupPlanWhereInput.


        :param delete_strategy_in: The delete_strategy_in of this BackupPlanWhereInput.  # noqa: E501
        :type delete_strategy_in: list[BackupPlanDeleteStrategy]
        """

        self._delete_strategy_in = delete_strategy_in

    @property
    def delete_strategy_not(self):
        """Gets the delete_strategy_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The delete_strategy_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanDeleteStrategy
        """
        return self._delete_strategy_not

    @delete_strategy_not.setter
    def delete_strategy_not(self, delete_strategy_not):
        """Sets the delete_strategy_not of this BackupPlanWhereInput.


        :param delete_strategy_not: The delete_strategy_not of this BackupPlanWhereInput.  # noqa: E501
        :type delete_strategy_not: BackupPlanDeleteStrategy
        """

        self._delete_strategy_not = delete_strategy_not

    @property
    def delete_strategy_not_in(self):
        """Gets the delete_strategy_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The delete_strategy_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanDeleteStrategy]
        """
        return self._delete_strategy_not_in

    @delete_strategy_not_in.setter
    def delete_strategy_not_in(self, delete_strategy_not_in):
        """Sets the delete_strategy_not_in of this BackupPlanWhereInput.


        :param delete_strategy_not_in: The delete_strategy_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type delete_strategy_not_in: list[BackupPlanDeleteStrategy]
        """

        self._delete_strategy_not_in = delete_strategy_not_in

    @property
    def description(self):
        """Gets the description of this BackupPlanWhereInput.  # noqa: E501


        :return: The description of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BackupPlanWhereInput.


        :param description: The description of this BackupPlanWhereInput.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def description_contains(self):
        """Gets the description_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_contains

    @description_contains.setter
    def description_contains(self, description_contains):
        """Sets the description_contains of this BackupPlanWhereInput.


        :param description_contains: The description_contains of this BackupPlanWhereInput.  # noqa: E501
        :type description_contains: str
        """

        self._description_contains = description_contains

    @property
    def description_ends_with(self):
        """Gets the description_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_ends_with

    @description_ends_with.setter
    def description_ends_with(self, description_ends_with):
        """Sets the description_ends_with of this BackupPlanWhereInput.


        :param description_ends_with: The description_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type description_ends_with: str
        """

        self._description_ends_with = description_ends_with

    @property
    def description_gt(self):
        """Gets the description_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gt

    @description_gt.setter
    def description_gt(self, description_gt):
        """Sets the description_gt of this BackupPlanWhereInput.


        :param description_gt: The description_gt of this BackupPlanWhereInput.  # noqa: E501
        :type description_gt: str
        """

        self._description_gt = description_gt

    @property
    def description_gte(self):
        """Gets the description_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gte

    @description_gte.setter
    def description_gte(self, description_gte):
        """Sets the description_gte of this BackupPlanWhereInput.


        :param description_gte: The description_gte of this BackupPlanWhereInput.  # noqa: E501
        :type description_gte: str
        """

        self._description_gte = description_gte

    @property
    def description_in(self):
        """Gets the description_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_in

    @description_in.setter
    def description_in(self, description_in):
        """Sets the description_in of this BackupPlanWhereInput.


        :param description_in: The description_in of this BackupPlanWhereInput.  # noqa: E501
        :type description_in: list[str]
        """

        self._description_in = description_in

    @property
    def description_lt(self):
        """Gets the description_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lt

    @description_lt.setter
    def description_lt(self, description_lt):
        """Sets the description_lt of this BackupPlanWhereInput.


        :param description_lt: The description_lt of this BackupPlanWhereInput.  # noqa: E501
        :type description_lt: str
        """

        self._description_lt = description_lt

    @property
    def description_lte(self):
        """Gets the description_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lte

    @description_lte.setter
    def description_lte(self, description_lte):
        """Sets the description_lte of this BackupPlanWhereInput.


        :param description_lte: The description_lte of this BackupPlanWhereInput.  # noqa: E501
        :type description_lte: str
        """

        self._description_lte = description_lte

    @property
    def description_not(self):
        """Gets the description_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not

    @description_not.setter
    def description_not(self, description_not):
        """Sets the description_not of this BackupPlanWhereInput.


        :param description_not: The description_not of this BackupPlanWhereInput.  # noqa: E501
        :type description_not: str
        """

        self._description_not = description_not

    @property
    def description_not_contains(self):
        """Gets the description_not_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_contains

    @description_not_contains.setter
    def description_not_contains(self, description_not_contains):
        """Sets the description_not_contains of this BackupPlanWhereInput.


        :param description_not_contains: The description_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :type description_not_contains: str
        """

        self._description_not_contains = description_not_contains

    @property
    def description_not_ends_with(self):
        """Gets the description_not_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_ends_with

    @description_not_ends_with.setter
    def description_not_ends_with(self, description_not_ends_with):
        """Sets the description_not_ends_with of this BackupPlanWhereInput.


        :param description_not_ends_with: The description_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type description_not_ends_with: str
        """

        self._description_not_ends_with = description_not_ends_with

    @property
    def description_not_in(self):
        """Gets the description_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_not_in

    @description_not_in.setter
    def description_not_in(self, description_not_in):
        """Sets the description_not_in of this BackupPlanWhereInput.


        :param description_not_in: The description_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type description_not_in: list[str]
        """

        self._description_not_in = description_not_in

    @property
    def description_not_starts_with(self):
        """Gets the description_not_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_starts_with

    @description_not_starts_with.setter
    def description_not_starts_with(self, description_not_starts_with):
        """Sets the description_not_starts_with of this BackupPlanWhereInput.


        :param description_not_starts_with: The description_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type description_not_starts_with: str
        """

        self._description_not_starts_with = description_not_starts_with

    @property
    def description_starts_with(self):
        """Gets the description_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The description_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_starts_with

    @description_starts_with.setter
    def description_starts_with(self, description_starts_with):
        """Sets the description_starts_with of this BackupPlanWhereInput.


        :param description_starts_with: The description_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type description_starts_with: str
        """

        self._description_starts_with = description_starts_with

    @property
    def enable_window(self):
        """Gets the enable_window of this BackupPlanWhereInput.  # noqa: E501


        :return: The enable_window of this BackupPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._enable_window

    @enable_window.setter
    def enable_window(self, enable_window):
        """Sets the enable_window of this BackupPlanWhereInput.


        :param enable_window: The enable_window of this BackupPlanWhereInput.  # noqa: E501
        :type enable_window: bool
        """

        self._enable_window = enable_window

    @property
    def enable_window_not(self):
        """Gets the enable_window_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The enable_window_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._enable_window_not

    @enable_window_not.setter
    def enable_window_not(self, enable_window_not):
        """Sets the enable_window_not of this BackupPlanWhereInput.


        :param enable_window_not: The enable_window_not of this BackupPlanWhereInput.  # noqa: E501
        :type enable_window_not: bool
        """

        self._enable_window_not = enable_window_not

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this BackupPlanWhereInput.  # noqa: E501


        :return: The entity_async_status of this BackupPlanWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this BackupPlanWhereInput.


        :param entity_async_status: The entity_async_status of this BackupPlanWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this BackupPlanWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this BackupPlanWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this BackupPlanWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this BackupPlanWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this BackupPlanWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def full_interval(self):
        """Gets the full_interval of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_interval of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._full_interval

    @full_interval.setter
    def full_interval(self, full_interval):
        """Sets the full_interval of this BackupPlanWhereInput.


        :param full_interval: The full_interval of this BackupPlanWhereInput.  # noqa: E501
        :type full_interval: int
        """

        self._full_interval = full_interval

    @property
    def full_interval_gt(self):
        """Gets the full_interval_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_interval_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._full_interval_gt

    @full_interval_gt.setter
    def full_interval_gt(self, full_interval_gt):
        """Sets the full_interval_gt of this BackupPlanWhereInput.


        :param full_interval_gt: The full_interval_gt of this BackupPlanWhereInput.  # noqa: E501
        :type full_interval_gt: int
        """

        self._full_interval_gt = full_interval_gt

    @property
    def full_interval_gte(self):
        """Gets the full_interval_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_interval_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._full_interval_gte

    @full_interval_gte.setter
    def full_interval_gte(self, full_interval_gte):
        """Sets the full_interval_gte of this BackupPlanWhereInput.


        :param full_interval_gte: The full_interval_gte of this BackupPlanWhereInput.  # noqa: E501
        :type full_interval_gte: int
        """

        self._full_interval_gte = full_interval_gte

    @property
    def full_interval_in(self):
        """Gets the full_interval_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_interval_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._full_interval_in

    @full_interval_in.setter
    def full_interval_in(self, full_interval_in):
        """Sets the full_interval_in of this BackupPlanWhereInput.


        :param full_interval_in: The full_interval_in of this BackupPlanWhereInput.  # noqa: E501
        :type full_interval_in: list[int]
        """

        self._full_interval_in = full_interval_in

    @property
    def full_interval_lt(self):
        """Gets the full_interval_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_interval_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._full_interval_lt

    @full_interval_lt.setter
    def full_interval_lt(self, full_interval_lt):
        """Sets the full_interval_lt of this BackupPlanWhereInput.


        :param full_interval_lt: The full_interval_lt of this BackupPlanWhereInput.  # noqa: E501
        :type full_interval_lt: int
        """

        self._full_interval_lt = full_interval_lt

    @property
    def full_interval_lte(self):
        """Gets the full_interval_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_interval_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._full_interval_lte

    @full_interval_lte.setter
    def full_interval_lte(self, full_interval_lte):
        """Sets the full_interval_lte of this BackupPlanWhereInput.


        :param full_interval_lte: The full_interval_lte of this BackupPlanWhereInput.  # noqa: E501
        :type full_interval_lte: int
        """

        self._full_interval_lte = full_interval_lte

    @property
    def full_interval_not(self):
        """Gets the full_interval_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_interval_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._full_interval_not

    @full_interval_not.setter
    def full_interval_not(self, full_interval_not):
        """Sets the full_interval_not of this BackupPlanWhereInput.


        :param full_interval_not: The full_interval_not of this BackupPlanWhereInput.  # noqa: E501
        :type full_interval_not: int
        """

        self._full_interval_not = full_interval_not

    @property
    def full_interval_not_in(self):
        """Gets the full_interval_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_interval_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._full_interval_not_in

    @full_interval_not_in.setter
    def full_interval_not_in(self, full_interval_not_in):
        """Sets the full_interval_not_in of this BackupPlanWhereInput.


        :param full_interval_not_in: The full_interval_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type full_interval_not_in: list[int]
        """

        self._full_interval_not_in = full_interval_not_in

    @property
    def full_period(self):
        """Gets the full_period of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_period of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanPeriod
        """
        return self._full_period

    @full_period.setter
    def full_period(self, full_period):
        """Sets the full_period of this BackupPlanWhereInput.


        :param full_period: The full_period of this BackupPlanWhereInput.  # noqa: E501
        :type full_period: BackupPlanPeriod
        """

        self._full_period = full_period

    @property
    def full_period_in(self):
        """Gets the full_period_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_period_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanPeriod]
        """
        return self._full_period_in

    @full_period_in.setter
    def full_period_in(self, full_period_in):
        """Sets the full_period_in of this BackupPlanWhereInput.


        :param full_period_in: The full_period_in of this BackupPlanWhereInput.  # noqa: E501
        :type full_period_in: list[BackupPlanPeriod]
        """

        self._full_period_in = full_period_in

    @property
    def full_period_not(self):
        """Gets the full_period_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_period_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanPeriod
        """
        return self._full_period_not

    @full_period_not.setter
    def full_period_not(self, full_period_not):
        """Sets the full_period_not of this BackupPlanWhereInput.


        :param full_period_not: The full_period_not of this BackupPlanWhereInput.  # noqa: E501
        :type full_period_not: BackupPlanPeriod
        """

        self._full_period_not = full_period_not

    @property
    def full_period_not_in(self):
        """Gets the full_period_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The full_period_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanPeriod]
        """
        return self._full_period_not_in

    @full_period_not_in.setter
    def full_period_not_in(self, full_period_not_in):
        """Sets the full_period_not_in of this BackupPlanWhereInput.


        :param full_period_not_in: The full_period_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type full_period_not_in: list[BackupPlanPeriod]
        """

        self._full_period_not_in = full_period_not_in

    @property
    def id(self):
        """Gets the id of this BackupPlanWhereInput.  # noqa: E501


        :return: The id of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BackupPlanWhereInput.


        :param id: The id of this BackupPlanWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this BackupPlanWhereInput.


        :param id_contains: The id_contains of this BackupPlanWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this BackupPlanWhereInput.


        :param id_ends_with: The id_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this BackupPlanWhereInput.


        :param id_gt: The id_gt of this BackupPlanWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this BackupPlanWhereInput.


        :param id_gte: The id_gte of this BackupPlanWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this BackupPlanWhereInput.


        :param id_in: The id_in of this BackupPlanWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this BackupPlanWhereInput.


        :param id_lt: The id_lt of this BackupPlanWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this BackupPlanWhereInput.


        :param id_lte: The id_lte of this BackupPlanWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this BackupPlanWhereInput.


        :param id_not: The id_not of this BackupPlanWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this BackupPlanWhereInput.


        :param id_not_contains: The id_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this BackupPlanWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this BackupPlanWhereInput.


        :param id_not_in: The id_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this BackupPlanWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The id_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this BackupPlanWhereInput.


        :param id_starts_with: The id_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def incremental_interval(self):
        """Gets the incremental_interval of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_interval of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._incremental_interval

    @incremental_interval.setter
    def incremental_interval(self, incremental_interval):
        """Sets the incremental_interval of this BackupPlanWhereInput.


        :param incremental_interval: The incremental_interval of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_interval: int
        """

        self._incremental_interval = incremental_interval

    @property
    def incremental_interval_gt(self):
        """Gets the incremental_interval_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_interval_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._incremental_interval_gt

    @incremental_interval_gt.setter
    def incremental_interval_gt(self, incremental_interval_gt):
        """Sets the incremental_interval_gt of this BackupPlanWhereInput.


        :param incremental_interval_gt: The incremental_interval_gt of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_interval_gt: int
        """

        self._incremental_interval_gt = incremental_interval_gt

    @property
    def incremental_interval_gte(self):
        """Gets the incremental_interval_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_interval_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._incremental_interval_gte

    @incremental_interval_gte.setter
    def incremental_interval_gte(self, incremental_interval_gte):
        """Sets the incremental_interval_gte of this BackupPlanWhereInput.


        :param incremental_interval_gte: The incremental_interval_gte of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_interval_gte: int
        """

        self._incremental_interval_gte = incremental_interval_gte

    @property
    def incremental_interval_in(self):
        """Gets the incremental_interval_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_interval_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._incremental_interval_in

    @incremental_interval_in.setter
    def incremental_interval_in(self, incremental_interval_in):
        """Sets the incremental_interval_in of this BackupPlanWhereInput.


        :param incremental_interval_in: The incremental_interval_in of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_interval_in: list[int]
        """

        self._incremental_interval_in = incremental_interval_in

    @property
    def incremental_interval_lt(self):
        """Gets the incremental_interval_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_interval_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._incremental_interval_lt

    @incremental_interval_lt.setter
    def incremental_interval_lt(self, incremental_interval_lt):
        """Sets the incremental_interval_lt of this BackupPlanWhereInput.


        :param incremental_interval_lt: The incremental_interval_lt of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_interval_lt: int
        """

        self._incremental_interval_lt = incremental_interval_lt

    @property
    def incremental_interval_lte(self):
        """Gets the incremental_interval_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_interval_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._incremental_interval_lte

    @incremental_interval_lte.setter
    def incremental_interval_lte(self, incremental_interval_lte):
        """Sets the incremental_interval_lte of this BackupPlanWhereInput.


        :param incremental_interval_lte: The incremental_interval_lte of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_interval_lte: int
        """

        self._incremental_interval_lte = incremental_interval_lte

    @property
    def incremental_interval_not(self):
        """Gets the incremental_interval_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_interval_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._incremental_interval_not

    @incremental_interval_not.setter
    def incremental_interval_not(self, incremental_interval_not):
        """Sets the incremental_interval_not of this BackupPlanWhereInput.


        :param incremental_interval_not: The incremental_interval_not of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_interval_not: int
        """

        self._incremental_interval_not = incremental_interval_not

    @property
    def incremental_interval_not_in(self):
        """Gets the incremental_interval_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_interval_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._incremental_interval_not_in

    @incremental_interval_not_in.setter
    def incremental_interval_not_in(self, incremental_interval_not_in):
        """Sets the incremental_interval_not_in of this BackupPlanWhereInput.


        :param incremental_interval_not_in: The incremental_interval_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_interval_not_in: list[int]
        """

        self._incremental_interval_not_in = incremental_interval_not_in

    @property
    def incremental_period(self):
        """Gets the incremental_period of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_period of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanPeriod
        """
        return self._incremental_period

    @incremental_period.setter
    def incremental_period(self, incremental_period):
        """Sets the incremental_period of this BackupPlanWhereInput.


        :param incremental_period: The incremental_period of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_period: BackupPlanPeriod
        """

        self._incremental_period = incremental_period

    @property
    def incremental_period_in(self):
        """Gets the incremental_period_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_period_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanPeriod]
        """
        return self._incremental_period_in

    @incremental_period_in.setter
    def incremental_period_in(self, incremental_period_in):
        """Sets the incremental_period_in of this BackupPlanWhereInput.


        :param incremental_period_in: The incremental_period_in of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_period_in: list[BackupPlanPeriod]
        """

        self._incremental_period_in = incremental_period_in

    @property
    def incremental_period_not(self):
        """Gets the incremental_period_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_period_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanPeriod
        """
        return self._incremental_period_not

    @incremental_period_not.setter
    def incremental_period_not(self, incremental_period_not):
        """Sets the incremental_period_not of this BackupPlanWhereInput.


        :param incremental_period_not: The incremental_period_not of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_period_not: BackupPlanPeriod
        """

        self._incremental_period_not = incremental_period_not

    @property
    def incremental_period_not_in(self):
        """Gets the incremental_period_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The incremental_period_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanPeriod]
        """
        return self._incremental_period_not_in

    @incremental_period_not_in.setter
    def incremental_period_not_in(self, incremental_period_not_in):
        """Sets the incremental_period_not_in of this BackupPlanWhereInput.


        :param incremental_period_not_in: The incremental_period_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type incremental_period_not_in: list[BackupPlanPeriod]
        """

        self._incremental_period_not_in = incremental_period_not_in

    @property
    def keep_policy(self):
        """Gets the keep_policy of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanKeepPolicy
        """
        return self._keep_policy

    @keep_policy.setter
    def keep_policy(self, keep_policy):
        """Sets the keep_policy of this BackupPlanWhereInput.


        :param keep_policy: The keep_policy of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy: BackupPlanKeepPolicy
        """

        self._keep_policy = keep_policy

    @property
    def keep_policy_in(self):
        """Gets the keep_policy_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanKeepPolicy]
        """
        return self._keep_policy_in

    @keep_policy_in.setter
    def keep_policy_in(self, keep_policy_in):
        """Sets the keep_policy_in of this BackupPlanWhereInput.


        :param keep_policy_in: The keep_policy_in of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy_in: list[BackupPlanKeepPolicy]
        """

        self._keep_policy_in = keep_policy_in

    @property
    def keep_policy_not(self):
        """Gets the keep_policy_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanKeepPolicy
        """
        return self._keep_policy_not

    @keep_policy_not.setter
    def keep_policy_not(self, keep_policy_not):
        """Sets the keep_policy_not of this BackupPlanWhereInput.


        :param keep_policy_not: The keep_policy_not of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy_not: BackupPlanKeepPolicy
        """

        self._keep_policy_not = keep_policy_not

    @property
    def keep_policy_not_in(self):
        """Gets the keep_policy_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanKeepPolicy]
        """
        return self._keep_policy_not_in

    @keep_policy_not_in.setter
    def keep_policy_not_in(self, keep_policy_not_in):
        """Sets the keep_policy_not_in of this BackupPlanWhereInput.


        :param keep_policy_not_in: The keep_policy_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy_not_in: list[BackupPlanKeepPolicy]
        """

        self._keep_policy_not_in = keep_policy_not_in

    @property
    def keep_policy_value(self):
        """Gets the keep_policy_value of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value

    @keep_policy_value.setter
    def keep_policy_value(self, keep_policy_value):
        """Sets the keep_policy_value of this BackupPlanWhereInput.


        :param keep_policy_value: The keep_policy_value of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy_value: int
        """

        self._keep_policy_value = keep_policy_value

    @property
    def keep_policy_value_gt(self):
        """Gets the keep_policy_value_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value_gt

    @keep_policy_value_gt.setter
    def keep_policy_value_gt(self, keep_policy_value_gt):
        """Sets the keep_policy_value_gt of this BackupPlanWhereInput.


        :param keep_policy_value_gt: The keep_policy_value_gt of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy_value_gt: int
        """

        self._keep_policy_value_gt = keep_policy_value_gt

    @property
    def keep_policy_value_gte(self):
        """Gets the keep_policy_value_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value_gte

    @keep_policy_value_gte.setter
    def keep_policy_value_gte(self, keep_policy_value_gte):
        """Sets the keep_policy_value_gte of this BackupPlanWhereInput.


        :param keep_policy_value_gte: The keep_policy_value_gte of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy_value_gte: int
        """

        self._keep_policy_value_gte = keep_policy_value_gte

    @property
    def keep_policy_value_in(self):
        """Gets the keep_policy_value_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._keep_policy_value_in

    @keep_policy_value_in.setter
    def keep_policy_value_in(self, keep_policy_value_in):
        """Sets the keep_policy_value_in of this BackupPlanWhereInput.


        :param keep_policy_value_in: The keep_policy_value_in of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy_value_in: list[int]
        """

        self._keep_policy_value_in = keep_policy_value_in

    @property
    def keep_policy_value_lt(self):
        """Gets the keep_policy_value_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value_lt

    @keep_policy_value_lt.setter
    def keep_policy_value_lt(self, keep_policy_value_lt):
        """Sets the keep_policy_value_lt of this BackupPlanWhereInput.


        :param keep_policy_value_lt: The keep_policy_value_lt of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy_value_lt: int
        """

        self._keep_policy_value_lt = keep_policy_value_lt

    @property
    def keep_policy_value_lte(self):
        """Gets the keep_policy_value_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value_lte

    @keep_policy_value_lte.setter
    def keep_policy_value_lte(self, keep_policy_value_lte):
        """Sets the keep_policy_value_lte of this BackupPlanWhereInput.


        :param keep_policy_value_lte: The keep_policy_value_lte of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy_value_lte: int
        """

        self._keep_policy_value_lte = keep_policy_value_lte

    @property
    def keep_policy_value_not(self):
        """Gets the keep_policy_value_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._keep_policy_value_not

    @keep_policy_value_not.setter
    def keep_policy_value_not(self, keep_policy_value_not):
        """Sets the keep_policy_value_not of this BackupPlanWhereInput.


        :param keep_policy_value_not: The keep_policy_value_not of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy_value_not: int
        """

        self._keep_policy_value_not = keep_policy_value_not

    @property
    def keep_policy_value_not_in(self):
        """Gets the keep_policy_value_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The keep_policy_value_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._keep_policy_value_not_in

    @keep_policy_value_not_in.setter
    def keep_policy_value_not_in(self, keep_policy_value_not_in):
        """Sets the keep_policy_value_not_in of this BackupPlanWhereInput.


        :param keep_policy_value_not_in: The keep_policy_value_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type keep_policy_value_not_in: list[int]
        """

        self._keep_policy_value_not_in = keep_policy_value_not_in

    @property
    def last_execute_status(self):
        """Gets the last_execute_status of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_execute_status

    @last_execute_status.setter
    def last_execute_status(self, last_execute_status):
        """Sets the last_execute_status of this BackupPlanWhereInput.


        :param last_execute_status: The last_execute_status of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status: BackupPlanExecutionStatus
        """

        self._last_execute_status = last_execute_status

    @property
    def last_execute_status_in(self):
        """Gets the last_execute_status_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionStatus]
        """
        return self._last_execute_status_in

    @last_execute_status_in.setter
    def last_execute_status_in(self, last_execute_status_in):
        """Sets the last_execute_status_in of this BackupPlanWhereInput.


        :param last_execute_status_in: The last_execute_status_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_in: list[BackupPlanExecutionStatus]
        """

        self._last_execute_status_in = last_execute_status_in

    @property
    def last_execute_status_message(self):
        """Gets the last_execute_status_message of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message

    @last_execute_status_message.setter
    def last_execute_status_message(self, last_execute_status_message):
        """Sets the last_execute_status_message of this BackupPlanWhereInput.


        :param last_execute_status_message: The last_execute_status_message of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message: str
        """

        self._last_execute_status_message = last_execute_status_message

    @property
    def last_execute_status_message_contains(self):
        """Gets the last_execute_status_message_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_contains

    @last_execute_status_message_contains.setter
    def last_execute_status_message_contains(self, last_execute_status_message_contains):
        """Sets the last_execute_status_message_contains of this BackupPlanWhereInput.


        :param last_execute_status_message_contains: The last_execute_status_message_contains of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_contains: str
        """

        self._last_execute_status_message_contains = last_execute_status_message_contains

    @property
    def last_execute_status_message_ends_with(self):
        """Gets the last_execute_status_message_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_ends_with

    @last_execute_status_message_ends_with.setter
    def last_execute_status_message_ends_with(self, last_execute_status_message_ends_with):
        """Sets the last_execute_status_message_ends_with of this BackupPlanWhereInput.


        :param last_execute_status_message_ends_with: The last_execute_status_message_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_ends_with: str
        """

        self._last_execute_status_message_ends_with = last_execute_status_message_ends_with

    @property
    def last_execute_status_message_gt(self):
        """Gets the last_execute_status_message_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_gt

    @last_execute_status_message_gt.setter
    def last_execute_status_message_gt(self, last_execute_status_message_gt):
        """Sets the last_execute_status_message_gt of this BackupPlanWhereInput.


        :param last_execute_status_message_gt: The last_execute_status_message_gt of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_gt: str
        """

        self._last_execute_status_message_gt = last_execute_status_message_gt

    @property
    def last_execute_status_message_gte(self):
        """Gets the last_execute_status_message_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_gte

    @last_execute_status_message_gte.setter
    def last_execute_status_message_gte(self, last_execute_status_message_gte):
        """Sets the last_execute_status_message_gte of this BackupPlanWhereInput.


        :param last_execute_status_message_gte: The last_execute_status_message_gte of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_gte: str
        """

        self._last_execute_status_message_gte = last_execute_status_message_gte

    @property
    def last_execute_status_message_in(self):
        """Gets the last_execute_status_message_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_execute_status_message_in

    @last_execute_status_message_in.setter
    def last_execute_status_message_in(self, last_execute_status_message_in):
        """Sets the last_execute_status_message_in of this BackupPlanWhereInput.


        :param last_execute_status_message_in: The last_execute_status_message_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_in: list[str]
        """

        self._last_execute_status_message_in = last_execute_status_message_in

    @property
    def last_execute_status_message_lt(self):
        """Gets the last_execute_status_message_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_lt

    @last_execute_status_message_lt.setter
    def last_execute_status_message_lt(self, last_execute_status_message_lt):
        """Sets the last_execute_status_message_lt of this BackupPlanWhereInput.


        :param last_execute_status_message_lt: The last_execute_status_message_lt of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_lt: str
        """

        self._last_execute_status_message_lt = last_execute_status_message_lt

    @property
    def last_execute_status_message_lte(self):
        """Gets the last_execute_status_message_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_lte

    @last_execute_status_message_lte.setter
    def last_execute_status_message_lte(self, last_execute_status_message_lte):
        """Sets the last_execute_status_message_lte of this BackupPlanWhereInput.


        :param last_execute_status_message_lte: The last_execute_status_message_lte of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_lte: str
        """

        self._last_execute_status_message_lte = last_execute_status_message_lte

    @property
    def last_execute_status_message_not(self):
        """Gets the last_execute_status_message_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_not

    @last_execute_status_message_not.setter
    def last_execute_status_message_not(self, last_execute_status_message_not):
        """Sets the last_execute_status_message_not of this BackupPlanWhereInput.


        :param last_execute_status_message_not: The last_execute_status_message_not of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_not: str
        """

        self._last_execute_status_message_not = last_execute_status_message_not

    @property
    def last_execute_status_message_not_contains(self):
        """Gets the last_execute_status_message_not_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_not_contains

    @last_execute_status_message_not_contains.setter
    def last_execute_status_message_not_contains(self, last_execute_status_message_not_contains):
        """Sets the last_execute_status_message_not_contains of this BackupPlanWhereInput.


        :param last_execute_status_message_not_contains: The last_execute_status_message_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_not_contains: str
        """

        self._last_execute_status_message_not_contains = last_execute_status_message_not_contains

    @property
    def last_execute_status_message_not_ends_with(self):
        """Gets the last_execute_status_message_not_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_not_ends_with

    @last_execute_status_message_not_ends_with.setter
    def last_execute_status_message_not_ends_with(self, last_execute_status_message_not_ends_with):
        """Sets the last_execute_status_message_not_ends_with of this BackupPlanWhereInput.


        :param last_execute_status_message_not_ends_with: The last_execute_status_message_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_not_ends_with: str
        """

        self._last_execute_status_message_not_ends_with = last_execute_status_message_not_ends_with

    @property
    def last_execute_status_message_not_in(self):
        """Gets the last_execute_status_message_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_execute_status_message_not_in

    @last_execute_status_message_not_in.setter
    def last_execute_status_message_not_in(self, last_execute_status_message_not_in):
        """Sets the last_execute_status_message_not_in of this BackupPlanWhereInput.


        :param last_execute_status_message_not_in: The last_execute_status_message_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_not_in: list[str]
        """

        self._last_execute_status_message_not_in = last_execute_status_message_not_in

    @property
    def last_execute_status_message_not_starts_with(self):
        """Gets the last_execute_status_message_not_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_not_starts_with

    @last_execute_status_message_not_starts_with.setter
    def last_execute_status_message_not_starts_with(self, last_execute_status_message_not_starts_with):
        """Sets the last_execute_status_message_not_starts_with of this BackupPlanWhereInput.


        :param last_execute_status_message_not_starts_with: The last_execute_status_message_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_not_starts_with: str
        """

        self._last_execute_status_message_not_starts_with = last_execute_status_message_not_starts_with

    @property
    def last_execute_status_message_starts_with(self):
        """Gets the last_execute_status_message_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_message_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_execute_status_message_starts_with

    @last_execute_status_message_starts_with.setter
    def last_execute_status_message_starts_with(self, last_execute_status_message_starts_with):
        """Sets the last_execute_status_message_starts_with of this BackupPlanWhereInput.


        :param last_execute_status_message_starts_with: The last_execute_status_message_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_message_starts_with: str
        """

        self._last_execute_status_message_starts_with = last_execute_status_message_starts_with

    @property
    def last_execute_status_not(self):
        """Gets the last_execute_status_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_execute_status_not

    @last_execute_status_not.setter
    def last_execute_status_not(self, last_execute_status_not):
        """Sets the last_execute_status_not of this BackupPlanWhereInput.


        :param last_execute_status_not: The last_execute_status_not of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_not: BackupPlanExecutionStatus
        """

        self._last_execute_status_not = last_execute_status_not

    @property
    def last_execute_status_not_in(self):
        """Gets the last_execute_status_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_status_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionStatus]
        """
        return self._last_execute_status_not_in

    @last_execute_status_not_in.setter
    def last_execute_status_not_in(self, last_execute_status_not_in):
        """Sets the last_execute_status_not_in of this BackupPlanWhereInput.


        :param last_execute_status_not_in: The last_execute_status_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_status_not_in: list[BackupPlanExecutionStatus]
        """

        self._last_execute_status_not_in = last_execute_status_not_in

    @property
    def last_execute_success_job_count(self):
        """Gets the last_execute_success_job_count of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count

    @last_execute_success_job_count.setter
    def last_execute_success_job_count(self, last_execute_success_job_count):
        """Sets the last_execute_success_job_count of this BackupPlanWhereInput.


        :param last_execute_success_job_count: The last_execute_success_job_count of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count: int
        """

        self._last_execute_success_job_count = last_execute_success_job_count

    @property
    def last_execute_success_job_count_gt(self):
        """Gets the last_execute_success_job_count_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count_gt

    @last_execute_success_job_count_gt.setter
    def last_execute_success_job_count_gt(self, last_execute_success_job_count_gt):
        """Sets the last_execute_success_job_count_gt of this BackupPlanWhereInput.


        :param last_execute_success_job_count_gt: The last_execute_success_job_count_gt of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_gt: int
        """

        self._last_execute_success_job_count_gt = last_execute_success_job_count_gt

    @property
    def last_execute_success_job_count_gte(self):
        """Gets the last_execute_success_job_count_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count_gte

    @last_execute_success_job_count_gte.setter
    def last_execute_success_job_count_gte(self, last_execute_success_job_count_gte):
        """Sets the last_execute_success_job_count_gte of this BackupPlanWhereInput.


        :param last_execute_success_job_count_gte: The last_execute_success_job_count_gte of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_gte: int
        """

        self._last_execute_success_job_count_gte = last_execute_success_job_count_gte

    @property
    def last_execute_success_job_count_in(self):
        """Gets the last_execute_success_job_count_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_execute_success_job_count_in

    @last_execute_success_job_count_in.setter
    def last_execute_success_job_count_in(self, last_execute_success_job_count_in):
        """Sets the last_execute_success_job_count_in of this BackupPlanWhereInput.


        :param last_execute_success_job_count_in: The last_execute_success_job_count_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_in: list[int]
        """

        self._last_execute_success_job_count_in = last_execute_success_job_count_in

    @property
    def last_execute_success_job_count_lt(self):
        """Gets the last_execute_success_job_count_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count_lt

    @last_execute_success_job_count_lt.setter
    def last_execute_success_job_count_lt(self, last_execute_success_job_count_lt):
        """Sets the last_execute_success_job_count_lt of this BackupPlanWhereInput.


        :param last_execute_success_job_count_lt: The last_execute_success_job_count_lt of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_lt: int
        """

        self._last_execute_success_job_count_lt = last_execute_success_job_count_lt

    @property
    def last_execute_success_job_count_lte(self):
        """Gets the last_execute_success_job_count_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count_lte

    @last_execute_success_job_count_lte.setter
    def last_execute_success_job_count_lte(self, last_execute_success_job_count_lte):
        """Sets the last_execute_success_job_count_lte of this BackupPlanWhereInput.


        :param last_execute_success_job_count_lte: The last_execute_success_job_count_lte of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_lte: int
        """

        self._last_execute_success_job_count_lte = last_execute_success_job_count_lte

    @property
    def last_execute_success_job_count_not(self):
        """Gets the last_execute_success_job_count_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_success_job_count_not

    @last_execute_success_job_count_not.setter
    def last_execute_success_job_count_not(self, last_execute_success_job_count_not):
        """Sets the last_execute_success_job_count_not of this BackupPlanWhereInput.


        :param last_execute_success_job_count_not: The last_execute_success_job_count_not of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_not: int
        """

        self._last_execute_success_job_count_not = last_execute_success_job_count_not

    @property
    def last_execute_success_job_count_not_in(self):
        """Gets the last_execute_success_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_success_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_execute_success_job_count_not_in

    @last_execute_success_job_count_not_in.setter
    def last_execute_success_job_count_not_in(self, last_execute_success_job_count_not_in):
        """Sets the last_execute_success_job_count_not_in of this BackupPlanWhereInput.


        :param last_execute_success_job_count_not_in: The last_execute_success_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_success_job_count_not_in: list[int]
        """

        self._last_execute_success_job_count_not_in = last_execute_success_job_count_not_in

    @property
    def last_execute_total_job_count(self):
        """Gets the last_execute_total_job_count of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count

    @last_execute_total_job_count.setter
    def last_execute_total_job_count(self, last_execute_total_job_count):
        """Sets the last_execute_total_job_count of this BackupPlanWhereInput.


        :param last_execute_total_job_count: The last_execute_total_job_count of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count: int
        """

        self._last_execute_total_job_count = last_execute_total_job_count

    @property
    def last_execute_total_job_count_gt(self):
        """Gets the last_execute_total_job_count_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count_gt

    @last_execute_total_job_count_gt.setter
    def last_execute_total_job_count_gt(self, last_execute_total_job_count_gt):
        """Sets the last_execute_total_job_count_gt of this BackupPlanWhereInput.


        :param last_execute_total_job_count_gt: The last_execute_total_job_count_gt of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_gt: int
        """

        self._last_execute_total_job_count_gt = last_execute_total_job_count_gt

    @property
    def last_execute_total_job_count_gte(self):
        """Gets the last_execute_total_job_count_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count_gte

    @last_execute_total_job_count_gte.setter
    def last_execute_total_job_count_gte(self, last_execute_total_job_count_gte):
        """Sets the last_execute_total_job_count_gte of this BackupPlanWhereInput.


        :param last_execute_total_job_count_gte: The last_execute_total_job_count_gte of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_gte: int
        """

        self._last_execute_total_job_count_gte = last_execute_total_job_count_gte

    @property
    def last_execute_total_job_count_in(self):
        """Gets the last_execute_total_job_count_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_execute_total_job_count_in

    @last_execute_total_job_count_in.setter
    def last_execute_total_job_count_in(self, last_execute_total_job_count_in):
        """Sets the last_execute_total_job_count_in of this BackupPlanWhereInput.


        :param last_execute_total_job_count_in: The last_execute_total_job_count_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_in: list[int]
        """

        self._last_execute_total_job_count_in = last_execute_total_job_count_in

    @property
    def last_execute_total_job_count_lt(self):
        """Gets the last_execute_total_job_count_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count_lt

    @last_execute_total_job_count_lt.setter
    def last_execute_total_job_count_lt(self, last_execute_total_job_count_lt):
        """Sets the last_execute_total_job_count_lt of this BackupPlanWhereInput.


        :param last_execute_total_job_count_lt: The last_execute_total_job_count_lt of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_lt: int
        """

        self._last_execute_total_job_count_lt = last_execute_total_job_count_lt

    @property
    def last_execute_total_job_count_lte(self):
        """Gets the last_execute_total_job_count_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count_lte

    @last_execute_total_job_count_lte.setter
    def last_execute_total_job_count_lte(self, last_execute_total_job_count_lte):
        """Sets the last_execute_total_job_count_lte of this BackupPlanWhereInput.


        :param last_execute_total_job_count_lte: The last_execute_total_job_count_lte of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_lte: int
        """

        self._last_execute_total_job_count_lte = last_execute_total_job_count_lte

    @property
    def last_execute_total_job_count_not(self):
        """Gets the last_execute_total_job_count_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_execute_total_job_count_not

    @last_execute_total_job_count_not.setter
    def last_execute_total_job_count_not(self, last_execute_total_job_count_not):
        """Sets the last_execute_total_job_count_not of this BackupPlanWhereInput.


        :param last_execute_total_job_count_not: The last_execute_total_job_count_not of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_not: int
        """

        self._last_execute_total_job_count_not = last_execute_total_job_count_not

    @property
    def last_execute_total_job_count_not_in(self):
        """Gets the last_execute_total_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_execute_total_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_execute_total_job_count_not_in

    @last_execute_total_job_count_not_in.setter
    def last_execute_total_job_count_not_in(self, last_execute_total_job_count_not_in):
        """Sets the last_execute_total_job_count_not_in of this BackupPlanWhereInput.


        :param last_execute_total_job_count_not_in: The last_execute_total_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_execute_total_job_count_not_in: list[int]
        """

        self._last_execute_total_job_count_not_in = last_execute_total_job_count_not_in

    @property
    def last_executed_at(self):
        """Gets the last_executed_at of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_executed_at of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at

    @last_executed_at.setter
    def last_executed_at(self, last_executed_at):
        """Sets the last_executed_at of this BackupPlanWhereInput.


        :param last_executed_at: The last_executed_at of this BackupPlanWhereInput.  # noqa: E501
        :type last_executed_at: str
        """

        self._last_executed_at = last_executed_at

    @property
    def last_executed_at_gt(self):
        """Gets the last_executed_at_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_gt

    @last_executed_at_gt.setter
    def last_executed_at_gt(self, last_executed_at_gt):
        """Sets the last_executed_at_gt of this BackupPlanWhereInput.


        :param last_executed_at_gt: The last_executed_at_gt of this BackupPlanWhereInput.  # noqa: E501
        :type last_executed_at_gt: str
        """

        self._last_executed_at_gt = last_executed_at_gt

    @property
    def last_executed_at_gte(self):
        """Gets the last_executed_at_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_gte

    @last_executed_at_gte.setter
    def last_executed_at_gte(self, last_executed_at_gte):
        """Sets the last_executed_at_gte of this BackupPlanWhereInput.


        :param last_executed_at_gte: The last_executed_at_gte of this BackupPlanWhereInput.  # noqa: E501
        :type last_executed_at_gte: str
        """

        self._last_executed_at_gte = last_executed_at_gte

    @property
    def last_executed_at_in(self):
        """Gets the last_executed_at_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_executed_at_in

    @last_executed_at_in.setter
    def last_executed_at_in(self, last_executed_at_in):
        """Sets the last_executed_at_in of this BackupPlanWhereInput.


        :param last_executed_at_in: The last_executed_at_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_executed_at_in: list[str]
        """

        self._last_executed_at_in = last_executed_at_in

    @property
    def last_executed_at_lt(self):
        """Gets the last_executed_at_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_lt

    @last_executed_at_lt.setter
    def last_executed_at_lt(self, last_executed_at_lt):
        """Sets the last_executed_at_lt of this BackupPlanWhereInput.


        :param last_executed_at_lt: The last_executed_at_lt of this BackupPlanWhereInput.  # noqa: E501
        :type last_executed_at_lt: str
        """

        self._last_executed_at_lt = last_executed_at_lt

    @property
    def last_executed_at_lte(self):
        """Gets the last_executed_at_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_lte

    @last_executed_at_lte.setter
    def last_executed_at_lte(self, last_executed_at_lte):
        """Sets the last_executed_at_lte of this BackupPlanWhereInput.


        :param last_executed_at_lte: The last_executed_at_lte of this BackupPlanWhereInput.  # noqa: E501
        :type last_executed_at_lte: str
        """

        self._last_executed_at_lte = last_executed_at_lte

    @property
    def last_executed_at_not(self):
        """Gets the last_executed_at_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_executed_at_not

    @last_executed_at_not.setter
    def last_executed_at_not(self, last_executed_at_not):
        """Sets the last_executed_at_not of this BackupPlanWhereInput.


        :param last_executed_at_not: The last_executed_at_not of this BackupPlanWhereInput.  # noqa: E501
        :type last_executed_at_not: str
        """

        self._last_executed_at_not = last_executed_at_not

    @property
    def last_executed_at_not_in(self):
        """Gets the last_executed_at_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_executed_at_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_executed_at_not_in

    @last_executed_at_not_in.setter
    def last_executed_at_not_in(self, last_executed_at_not_in):
        """Sets the last_executed_at_not_in of this BackupPlanWhereInput.


        :param last_executed_at_not_in: The last_executed_at_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_executed_at_not_in: list[str]
        """

        self._last_executed_at_not_in = last_executed_at_not_in

    @property
    def last_manual_execute_status(self):
        """Gets the last_manual_execute_status of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_manual_execute_status

    @last_manual_execute_status.setter
    def last_manual_execute_status(self, last_manual_execute_status):
        """Sets the last_manual_execute_status of this BackupPlanWhereInput.


        :param last_manual_execute_status: The last_manual_execute_status of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status: BackupPlanExecutionStatus
        """

        self._last_manual_execute_status = last_manual_execute_status

    @property
    def last_manual_execute_status_in(self):
        """Gets the last_manual_execute_status_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionStatus]
        """
        return self._last_manual_execute_status_in

    @last_manual_execute_status_in.setter
    def last_manual_execute_status_in(self, last_manual_execute_status_in):
        """Sets the last_manual_execute_status_in of this BackupPlanWhereInput.


        :param last_manual_execute_status_in: The last_manual_execute_status_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_in: list[BackupPlanExecutionStatus]
        """

        self._last_manual_execute_status_in = last_manual_execute_status_in

    @property
    def last_manual_execute_status_message(self):
        """Gets the last_manual_execute_status_message of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message

    @last_manual_execute_status_message.setter
    def last_manual_execute_status_message(self, last_manual_execute_status_message):
        """Sets the last_manual_execute_status_message of this BackupPlanWhereInput.


        :param last_manual_execute_status_message: The last_manual_execute_status_message of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message: str
        """

        self._last_manual_execute_status_message = last_manual_execute_status_message

    @property
    def last_manual_execute_status_message_contains(self):
        """Gets the last_manual_execute_status_message_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_contains

    @last_manual_execute_status_message_contains.setter
    def last_manual_execute_status_message_contains(self, last_manual_execute_status_message_contains):
        """Sets the last_manual_execute_status_message_contains of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_contains: The last_manual_execute_status_message_contains of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_contains: str
        """

        self._last_manual_execute_status_message_contains = last_manual_execute_status_message_contains

    @property
    def last_manual_execute_status_message_ends_with(self):
        """Gets the last_manual_execute_status_message_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_ends_with

    @last_manual_execute_status_message_ends_with.setter
    def last_manual_execute_status_message_ends_with(self, last_manual_execute_status_message_ends_with):
        """Sets the last_manual_execute_status_message_ends_with of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_ends_with: The last_manual_execute_status_message_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_ends_with: str
        """

        self._last_manual_execute_status_message_ends_with = last_manual_execute_status_message_ends_with

    @property
    def last_manual_execute_status_message_gt(self):
        """Gets the last_manual_execute_status_message_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_gt

    @last_manual_execute_status_message_gt.setter
    def last_manual_execute_status_message_gt(self, last_manual_execute_status_message_gt):
        """Sets the last_manual_execute_status_message_gt of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_gt: The last_manual_execute_status_message_gt of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_gt: str
        """

        self._last_manual_execute_status_message_gt = last_manual_execute_status_message_gt

    @property
    def last_manual_execute_status_message_gte(self):
        """Gets the last_manual_execute_status_message_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_gte

    @last_manual_execute_status_message_gte.setter
    def last_manual_execute_status_message_gte(self, last_manual_execute_status_message_gte):
        """Sets the last_manual_execute_status_message_gte of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_gte: The last_manual_execute_status_message_gte of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_gte: str
        """

        self._last_manual_execute_status_message_gte = last_manual_execute_status_message_gte

    @property
    def last_manual_execute_status_message_in(self):
        """Gets the last_manual_execute_status_message_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_manual_execute_status_message_in

    @last_manual_execute_status_message_in.setter
    def last_manual_execute_status_message_in(self, last_manual_execute_status_message_in):
        """Sets the last_manual_execute_status_message_in of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_in: The last_manual_execute_status_message_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_in: list[str]
        """

        self._last_manual_execute_status_message_in = last_manual_execute_status_message_in

    @property
    def last_manual_execute_status_message_lt(self):
        """Gets the last_manual_execute_status_message_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_lt

    @last_manual_execute_status_message_lt.setter
    def last_manual_execute_status_message_lt(self, last_manual_execute_status_message_lt):
        """Sets the last_manual_execute_status_message_lt of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_lt: The last_manual_execute_status_message_lt of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_lt: str
        """

        self._last_manual_execute_status_message_lt = last_manual_execute_status_message_lt

    @property
    def last_manual_execute_status_message_lte(self):
        """Gets the last_manual_execute_status_message_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_lte

    @last_manual_execute_status_message_lte.setter
    def last_manual_execute_status_message_lte(self, last_manual_execute_status_message_lte):
        """Sets the last_manual_execute_status_message_lte of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_lte: The last_manual_execute_status_message_lte of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_lte: str
        """

        self._last_manual_execute_status_message_lte = last_manual_execute_status_message_lte

    @property
    def last_manual_execute_status_message_not(self):
        """Gets the last_manual_execute_status_message_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_not

    @last_manual_execute_status_message_not.setter
    def last_manual_execute_status_message_not(self, last_manual_execute_status_message_not):
        """Sets the last_manual_execute_status_message_not of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_not: The last_manual_execute_status_message_not of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_not: str
        """

        self._last_manual_execute_status_message_not = last_manual_execute_status_message_not

    @property
    def last_manual_execute_status_message_not_contains(self):
        """Gets the last_manual_execute_status_message_not_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_not_contains

    @last_manual_execute_status_message_not_contains.setter
    def last_manual_execute_status_message_not_contains(self, last_manual_execute_status_message_not_contains):
        """Sets the last_manual_execute_status_message_not_contains of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_not_contains: The last_manual_execute_status_message_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_not_contains: str
        """

        self._last_manual_execute_status_message_not_contains = last_manual_execute_status_message_not_contains

    @property
    def last_manual_execute_status_message_not_ends_with(self):
        """Gets the last_manual_execute_status_message_not_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_not_ends_with

    @last_manual_execute_status_message_not_ends_with.setter
    def last_manual_execute_status_message_not_ends_with(self, last_manual_execute_status_message_not_ends_with):
        """Sets the last_manual_execute_status_message_not_ends_with of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_not_ends_with: The last_manual_execute_status_message_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_not_ends_with: str
        """

        self._last_manual_execute_status_message_not_ends_with = last_manual_execute_status_message_not_ends_with

    @property
    def last_manual_execute_status_message_not_in(self):
        """Gets the last_manual_execute_status_message_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_manual_execute_status_message_not_in

    @last_manual_execute_status_message_not_in.setter
    def last_manual_execute_status_message_not_in(self, last_manual_execute_status_message_not_in):
        """Sets the last_manual_execute_status_message_not_in of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_not_in: The last_manual_execute_status_message_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_not_in: list[str]
        """

        self._last_manual_execute_status_message_not_in = last_manual_execute_status_message_not_in

    @property
    def last_manual_execute_status_message_not_starts_with(self):
        """Gets the last_manual_execute_status_message_not_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_not_starts_with

    @last_manual_execute_status_message_not_starts_with.setter
    def last_manual_execute_status_message_not_starts_with(self, last_manual_execute_status_message_not_starts_with):
        """Sets the last_manual_execute_status_message_not_starts_with of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_not_starts_with: The last_manual_execute_status_message_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_not_starts_with: str
        """

        self._last_manual_execute_status_message_not_starts_with = last_manual_execute_status_message_not_starts_with

    @property
    def last_manual_execute_status_message_starts_with(self):
        """Gets the last_manual_execute_status_message_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_message_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_execute_status_message_starts_with

    @last_manual_execute_status_message_starts_with.setter
    def last_manual_execute_status_message_starts_with(self, last_manual_execute_status_message_starts_with):
        """Sets the last_manual_execute_status_message_starts_with of this BackupPlanWhereInput.


        :param last_manual_execute_status_message_starts_with: The last_manual_execute_status_message_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_message_starts_with: str
        """

        self._last_manual_execute_status_message_starts_with = last_manual_execute_status_message_starts_with

    @property
    def last_manual_execute_status_not(self):
        """Gets the last_manual_execute_status_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionStatus
        """
        return self._last_manual_execute_status_not

    @last_manual_execute_status_not.setter
    def last_manual_execute_status_not(self, last_manual_execute_status_not):
        """Sets the last_manual_execute_status_not of this BackupPlanWhereInput.


        :param last_manual_execute_status_not: The last_manual_execute_status_not of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_not: BackupPlanExecutionStatus
        """

        self._last_manual_execute_status_not = last_manual_execute_status_not

    @property
    def last_manual_execute_status_not_in(self):
        """Gets the last_manual_execute_status_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_status_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanExecutionStatus]
        """
        return self._last_manual_execute_status_not_in

    @last_manual_execute_status_not_in.setter
    def last_manual_execute_status_not_in(self, last_manual_execute_status_not_in):
        """Sets the last_manual_execute_status_not_in of this BackupPlanWhereInput.


        :param last_manual_execute_status_not_in: The last_manual_execute_status_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_status_not_in: list[BackupPlanExecutionStatus]
        """

        self._last_manual_execute_status_not_in = last_manual_execute_status_not_in

    @property
    def last_manual_execute_success_job_count(self):
        """Gets the last_manual_execute_success_job_count of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count

    @last_manual_execute_success_job_count.setter
    def last_manual_execute_success_job_count(self, last_manual_execute_success_job_count):
        """Sets the last_manual_execute_success_job_count of this BackupPlanWhereInput.


        :param last_manual_execute_success_job_count: The last_manual_execute_success_job_count of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count: int
        """

        self._last_manual_execute_success_job_count = last_manual_execute_success_job_count

    @property
    def last_manual_execute_success_job_count_gt(self):
        """Gets the last_manual_execute_success_job_count_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count_gt

    @last_manual_execute_success_job_count_gt.setter
    def last_manual_execute_success_job_count_gt(self, last_manual_execute_success_job_count_gt):
        """Sets the last_manual_execute_success_job_count_gt of this BackupPlanWhereInput.


        :param last_manual_execute_success_job_count_gt: The last_manual_execute_success_job_count_gt of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_gt: int
        """

        self._last_manual_execute_success_job_count_gt = last_manual_execute_success_job_count_gt

    @property
    def last_manual_execute_success_job_count_gte(self):
        """Gets the last_manual_execute_success_job_count_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count_gte

    @last_manual_execute_success_job_count_gte.setter
    def last_manual_execute_success_job_count_gte(self, last_manual_execute_success_job_count_gte):
        """Sets the last_manual_execute_success_job_count_gte of this BackupPlanWhereInput.


        :param last_manual_execute_success_job_count_gte: The last_manual_execute_success_job_count_gte of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_gte: int
        """

        self._last_manual_execute_success_job_count_gte = last_manual_execute_success_job_count_gte

    @property
    def last_manual_execute_success_job_count_in(self):
        """Gets the last_manual_execute_success_job_count_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_manual_execute_success_job_count_in

    @last_manual_execute_success_job_count_in.setter
    def last_manual_execute_success_job_count_in(self, last_manual_execute_success_job_count_in):
        """Sets the last_manual_execute_success_job_count_in of this BackupPlanWhereInput.


        :param last_manual_execute_success_job_count_in: The last_manual_execute_success_job_count_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_in: list[int]
        """

        self._last_manual_execute_success_job_count_in = last_manual_execute_success_job_count_in

    @property
    def last_manual_execute_success_job_count_lt(self):
        """Gets the last_manual_execute_success_job_count_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count_lt

    @last_manual_execute_success_job_count_lt.setter
    def last_manual_execute_success_job_count_lt(self, last_manual_execute_success_job_count_lt):
        """Sets the last_manual_execute_success_job_count_lt of this BackupPlanWhereInput.


        :param last_manual_execute_success_job_count_lt: The last_manual_execute_success_job_count_lt of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_lt: int
        """

        self._last_manual_execute_success_job_count_lt = last_manual_execute_success_job_count_lt

    @property
    def last_manual_execute_success_job_count_lte(self):
        """Gets the last_manual_execute_success_job_count_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count_lte

    @last_manual_execute_success_job_count_lte.setter
    def last_manual_execute_success_job_count_lte(self, last_manual_execute_success_job_count_lte):
        """Sets the last_manual_execute_success_job_count_lte of this BackupPlanWhereInput.


        :param last_manual_execute_success_job_count_lte: The last_manual_execute_success_job_count_lte of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_lte: int
        """

        self._last_manual_execute_success_job_count_lte = last_manual_execute_success_job_count_lte

    @property
    def last_manual_execute_success_job_count_not(self):
        """Gets the last_manual_execute_success_job_count_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_success_job_count_not

    @last_manual_execute_success_job_count_not.setter
    def last_manual_execute_success_job_count_not(self, last_manual_execute_success_job_count_not):
        """Sets the last_manual_execute_success_job_count_not of this BackupPlanWhereInput.


        :param last_manual_execute_success_job_count_not: The last_manual_execute_success_job_count_not of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_not: int
        """

        self._last_manual_execute_success_job_count_not = last_manual_execute_success_job_count_not

    @property
    def last_manual_execute_success_job_count_not_in(self):
        """Gets the last_manual_execute_success_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_success_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_manual_execute_success_job_count_not_in

    @last_manual_execute_success_job_count_not_in.setter
    def last_manual_execute_success_job_count_not_in(self, last_manual_execute_success_job_count_not_in):
        """Sets the last_manual_execute_success_job_count_not_in of this BackupPlanWhereInput.


        :param last_manual_execute_success_job_count_not_in: The last_manual_execute_success_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_success_job_count_not_in: list[int]
        """

        self._last_manual_execute_success_job_count_not_in = last_manual_execute_success_job_count_not_in

    @property
    def last_manual_execute_total_job_count(self):
        """Gets the last_manual_execute_total_job_count of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count

    @last_manual_execute_total_job_count.setter
    def last_manual_execute_total_job_count(self, last_manual_execute_total_job_count):
        """Sets the last_manual_execute_total_job_count of this BackupPlanWhereInput.


        :param last_manual_execute_total_job_count: The last_manual_execute_total_job_count of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count: int
        """

        self._last_manual_execute_total_job_count = last_manual_execute_total_job_count

    @property
    def last_manual_execute_total_job_count_gt(self):
        """Gets the last_manual_execute_total_job_count_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count_gt

    @last_manual_execute_total_job_count_gt.setter
    def last_manual_execute_total_job_count_gt(self, last_manual_execute_total_job_count_gt):
        """Sets the last_manual_execute_total_job_count_gt of this BackupPlanWhereInput.


        :param last_manual_execute_total_job_count_gt: The last_manual_execute_total_job_count_gt of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_gt: int
        """

        self._last_manual_execute_total_job_count_gt = last_manual_execute_total_job_count_gt

    @property
    def last_manual_execute_total_job_count_gte(self):
        """Gets the last_manual_execute_total_job_count_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count_gte

    @last_manual_execute_total_job_count_gte.setter
    def last_manual_execute_total_job_count_gte(self, last_manual_execute_total_job_count_gte):
        """Sets the last_manual_execute_total_job_count_gte of this BackupPlanWhereInput.


        :param last_manual_execute_total_job_count_gte: The last_manual_execute_total_job_count_gte of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_gte: int
        """

        self._last_manual_execute_total_job_count_gte = last_manual_execute_total_job_count_gte

    @property
    def last_manual_execute_total_job_count_in(self):
        """Gets the last_manual_execute_total_job_count_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_manual_execute_total_job_count_in

    @last_manual_execute_total_job_count_in.setter
    def last_manual_execute_total_job_count_in(self, last_manual_execute_total_job_count_in):
        """Sets the last_manual_execute_total_job_count_in of this BackupPlanWhereInput.


        :param last_manual_execute_total_job_count_in: The last_manual_execute_total_job_count_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_in: list[int]
        """

        self._last_manual_execute_total_job_count_in = last_manual_execute_total_job_count_in

    @property
    def last_manual_execute_total_job_count_lt(self):
        """Gets the last_manual_execute_total_job_count_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count_lt

    @last_manual_execute_total_job_count_lt.setter
    def last_manual_execute_total_job_count_lt(self, last_manual_execute_total_job_count_lt):
        """Sets the last_manual_execute_total_job_count_lt of this BackupPlanWhereInput.


        :param last_manual_execute_total_job_count_lt: The last_manual_execute_total_job_count_lt of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_lt: int
        """

        self._last_manual_execute_total_job_count_lt = last_manual_execute_total_job_count_lt

    @property
    def last_manual_execute_total_job_count_lte(self):
        """Gets the last_manual_execute_total_job_count_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count_lte

    @last_manual_execute_total_job_count_lte.setter
    def last_manual_execute_total_job_count_lte(self, last_manual_execute_total_job_count_lte):
        """Sets the last_manual_execute_total_job_count_lte of this BackupPlanWhereInput.


        :param last_manual_execute_total_job_count_lte: The last_manual_execute_total_job_count_lte of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_lte: int
        """

        self._last_manual_execute_total_job_count_lte = last_manual_execute_total_job_count_lte

    @property
    def last_manual_execute_total_job_count_not(self):
        """Gets the last_manual_execute_total_job_count_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._last_manual_execute_total_job_count_not

    @last_manual_execute_total_job_count_not.setter
    def last_manual_execute_total_job_count_not(self, last_manual_execute_total_job_count_not):
        """Sets the last_manual_execute_total_job_count_not of this BackupPlanWhereInput.


        :param last_manual_execute_total_job_count_not: The last_manual_execute_total_job_count_not of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_not: int
        """

        self._last_manual_execute_total_job_count_not = last_manual_execute_total_job_count_not

    @property
    def last_manual_execute_total_job_count_not_in(self):
        """Gets the last_manual_execute_total_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_execute_total_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._last_manual_execute_total_job_count_not_in

    @last_manual_execute_total_job_count_not_in.setter
    def last_manual_execute_total_job_count_not_in(self, last_manual_execute_total_job_count_not_in):
        """Sets the last_manual_execute_total_job_count_not_in of this BackupPlanWhereInput.


        :param last_manual_execute_total_job_count_not_in: The last_manual_execute_total_job_count_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_execute_total_job_count_not_in: list[int]
        """

        self._last_manual_execute_total_job_count_not_in = last_manual_execute_total_job_count_not_in

    @property
    def last_manual_executed_at(self):
        """Gets the last_manual_executed_at of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at

    @last_manual_executed_at.setter
    def last_manual_executed_at(self, last_manual_executed_at):
        """Sets the last_manual_executed_at of this BackupPlanWhereInput.


        :param last_manual_executed_at: The last_manual_executed_at of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at: str
        """

        self._last_manual_executed_at = last_manual_executed_at

    @property
    def last_manual_executed_at_gt(self):
        """Gets the last_manual_executed_at_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at_gt

    @last_manual_executed_at_gt.setter
    def last_manual_executed_at_gt(self, last_manual_executed_at_gt):
        """Sets the last_manual_executed_at_gt of this BackupPlanWhereInput.


        :param last_manual_executed_at_gt: The last_manual_executed_at_gt of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_gt: str
        """

        self._last_manual_executed_at_gt = last_manual_executed_at_gt

    @property
    def last_manual_executed_at_gte(self):
        """Gets the last_manual_executed_at_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at_gte

    @last_manual_executed_at_gte.setter
    def last_manual_executed_at_gte(self, last_manual_executed_at_gte):
        """Sets the last_manual_executed_at_gte of this BackupPlanWhereInput.


        :param last_manual_executed_at_gte: The last_manual_executed_at_gte of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_gte: str
        """

        self._last_manual_executed_at_gte = last_manual_executed_at_gte

    @property
    def last_manual_executed_at_in(self):
        """Gets the last_manual_executed_at_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_manual_executed_at_in

    @last_manual_executed_at_in.setter
    def last_manual_executed_at_in(self, last_manual_executed_at_in):
        """Sets the last_manual_executed_at_in of this BackupPlanWhereInput.


        :param last_manual_executed_at_in: The last_manual_executed_at_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_in: list[str]
        """

        self._last_manual_executed_at_in = last_manual_executed_at_in

    @property
    def last_manual_executed_at_lt(self):
        """Gets the last_manual_executed_at_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at_lt

    @last_manual_executed_at_lt.setter
    def last_manual_executed_at_lt(self, last_manual_executed_at_lt):
        """Sets the last_manual_executed_at_lt of this BackupPlanWhereInput.


        :param last_manual_executed_at_lt: The last_manual_executed_at_lt of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_lt: str
        """

        self._last_manual_executed_at_lt = last_manual_executed_at_lt

    @property
    def last_manual_executed_at_lte(self):
        """Gets the last_manual_executed_at_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at_lte

    @last_manual_executed_at_lte.setter
    def last_manual_executed_at_lte(self, last_manual_executed_at_lte):
        """Sets the last_manual_executed_at_lte of this BackupPlanWhereInput.


        :param last_manual_executed_at_lte: The last_manual_executed_at_lte of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_lte: str
        """

        self._last_manual_executed_at_lte = last_manual_executed_at_lte

    @property
    def last_manual_executed_at_not(self):
        """Gets the last_manual_executed_at_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._last_manual_executed_at_not

    @last_manual_executed_at_not.setter
    def last_manual_executed_at_not(self, last_manual_executed_at_not):
        """Sets the last_manual_executed_at_not of this BackupPlanWhereInput.


        :param last_manual_executed_at_not: The last_manual_executed_at_not of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_not: str
        """

        self._last_manual_executed_at_not = last_manual_executed_at_not

    @property
    def last_manual_executed_at_not_in(self):
        """Gets the last_manual_executed_at_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The last_manual_executed_at_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._last_manual_executed_at_not_in

    @last_manual_executed_at_not_in.setter
    def last_manual_executed_at_not_in(self, last_manual_executed_at_not_in):
        """Sets the last_manual_executed_at_not_in of this BackupPlanWhereInput.


        :param last_manual_executed_at_not_in: The last_manual_executed_at_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type last_manual_executed_at_not_in: list[str]
        """

        self._last_manual_executed_at_not_in = last_manual_executed_at_not_in

    @property
    def logical_size(self):
        """Gets the logical_size of this BackupPlanWhereInput.  # noqa: E501


        :return: The logical_size of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size

    @logical_size.setter
    def logical_size(self, logical_size):
        """Sets the logical_size of this BackupPlanWhereInput.


        :param logical_size: The logical_size of this BackupPlanWhereInput.  # noqa: E501
        :type logical_size: int
        """

        self._logical_size = logical_size

    @property
    def logical_size_gt(self):
        """Gets the logical_size_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The logical_size_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_gt

    @logical_size_gt.setter
    def logical_size_gt(self, logical_size_gt):
        """Sets the logical_size_gt of this BackupPlanWhereInput.


        :param logical_size_gt: The logical_size_gt of this BackupPlanWhereInput.  # noqa: E501
        :type logical_size_gt: int
        """

        self._logical_size_gt = logical_size_gt

    @property
    def logical_size_gte(self):
        """Gets the logical_size_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The logical_size_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_gte

    @logical_size_gte.setter
    def logical_size_gte(self, logical_size_gte):
        """Sets the logical_size_gte of this BackupPlanWhereInput.


        :param logical_size_gte: The logical_size_gte of this BackupPlanWhereInput.  # noqa: E501
        :type logical_size_gte: int
        """

        self._logical_size_gte = logical_size_gte

    @property
    def logical_size_in(self):
        """Gets the logical_size_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The logical_size_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._logical_size_in

    @logical_size_in.setter
    def logical_size_in(self, logical_size_in):
        """Sets the logical_size_in of this BackupPlanWhereInput.


        :param logical_size_in: The logical_size_in of this BackupPlanWhereInput.  # noqa: E501
        :type logical_size_in: list[int]
        """

        self._logical_size_in = logical_size_in

    @property
    def logical_size_lt(self):
        """Gets the logical_size_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The logical_size_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_lt

    @logical_size_lt.setter
    def logical_size_lt(self, logical_size_lt):
        """Sets the logical_size_lt of this BackupPlanWhereInput.


        :param logical_size_lt: The logical_size_lt of this BackupPlanWhereInput.  # noqa: E501
        :type logical_size_lt: int
        """

        self._logical_size_lt = logical_size_lt

    @property
    def logical_size_lte(self):
        """Gets the logical_size_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The logical_size_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_lte

    @logical_size_lte.setter
    def logical_size_lte(self, logical_size_lte):
        """Sets the logical_size_lte of this BackupPlanWhereInput.


        :param logical_size_lte: The logical_size_lte of this BackupPlanWhereInput.  # noqa: E501
        :type logical_size_lte: int
        """

        self._logical_size_lte = logical_size_lte

    @property
    def logical_size_not(self):
        """Gets the logical_size_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The logical_size_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_not

    @logical_size_not.setter
    def logical_size_not(self, logical_size_not):
        """Sets the logical_size_not of this BackupPlanWhereInput.


        :param logical_size_not: The logical_size_not of this BackupPlanWhereInput.  # noqa: E501
        :type logical_size_not: int
        """

        self._logical_size_not = logical_size_not

    @property
    def logical_size_not_in(self):
        """Gets the logical_size_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The logical_size_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._logical_size_not_in

    @logical_size_not_in.setter
    def logical_size_not_in(self, logical_size_not_in):
        """Sets the logical_size_not_in of this BackupPlanWhereInput.


        :param logical_size_not_in: The logical_size_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type logical_size_not_in: list[int]
        """

        self._logical_size_not_in = logical_size_not_in

    @property
    def name(self):
        """Gets the name of this BackupPlanWhereInput.  # noqa: E501


        :return: The name of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BackupPlanWhereInput.


        :param name: The name of this BackupPlanWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this BackupPlanWhereInput.


        :param name_contains: The name_contains of this BackupPlanWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this BackupPlanWhereInput.


        :param name_ends_with: The name_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this BackupPlanWhereInput.


        :param name_gt: The name_gt of this BackupPlanWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this BackupPlanWhereInput.


        :param name_gte: The name_gte of this BackupPlanWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this BackupPlanWhereInput.


        :param name_in: The name_in of this BackupPlanWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this BackupPlanWhereInput.


        :param name_lt: The name_lt of this BackupPlanWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this BackupPlanWhereInput.


        :param name_lte: The name_lte of this BackupPlanWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this BackupPlanWhereInput.


        :param name_not: The name_not of this BackupPlanWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this BackupPlanWhereInput.


        :param name_not_contains: The name_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this BackupPlanWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this BackupPlanWhereInput.


        :param name_not_in: The name_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this BackupPlanWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The name_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this BackupPlanWhereInput.


        :param name_starts_with: The name_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def next_execute_time(self):
        """Gets the next_execute_time of this BackupPlanWhereInput.  # noqa: E501


        :return: The next_execute_time of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execute_time

    @next_execute_time.setter
    def next_execute_time(self, next_execute_time):
        """Sets the next_execute_time of this BackupPlanWhereInput.


        :param next_execute_time: The next_execute_time of this BackupPlanWhereInput.  # noqa: E501
        :type next_execute_time: str
        """

        self._next_execute_time = next_execute_time

    @property
    def next_execute_time_gt(self):
        """Gets the next_execute_time_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The next_execute_time_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execute_time_gt

    @next_execute_time_gt.setter
    def next_execute_time_gt(self, next_execute_time_gt):
        """Sets the next_execute_time_gt of this BackupPlanWhereInput.


        :param next_execute_time_gt: The next_execute_time_gt of this BackupPlanWhereInput.  # noqa: E501
        :type next_execute_time_gt: str
        """

        self._next_execute_time_gt = next_execute_time_gt

    @property
    def next_execute_time_gte(self):
        """Gets the next_execute_time_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The next_execute_time_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execute_time_gte

    @next_execute_time_gte.setter
    def next_execute_time_gte(self, next_execute_time_gte):
        """Sets the next_execute_time_gte of this BackupPlanWhereInput.


        :param next_execute_time_gte: The next_execute_time_gte of this BackupPlanWhereInput.  # noqa: E501
        :type next_execute_time_gte: str
        """

        self._next_execute_time_gte = next_execute_time_gte

    @property
    def next_execute_time_in(self):
        """Gets the next_execute_time_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The next_execute_time_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._next_execute_time_in

    @next_execute_time_in.setter
    def next_execute_time_in(self, next_execute_time_in):
        """Sets the next_execute_time_in of this BackupPlanWhereInput.


        :param next_execute_time_in: The next_execute_time_in of this BackupPlanWhereInput.  # noqa: E501
        :type next_execute_time_in: list[str]
        """

        self._next_execute_time_in = next_execute_time_in

    @property
    def next_execute_time_lt(self):
        """Gets the next_execute_time_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The next_execute_time_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execute_time_lt

    @next_execute_time_lt.setter
    def next_execute_time_lt(self, next_execute_time_lt):
        """Sets the next_execute_time_lt of this BackupPlanWhereInput.


        :param next_execute_time_lt: The next_execute_time_lt of this BackupPlanWhereInput.  # noqa: E501
        :type next_execute_time_lt: str
        """

        self._next_execute_time_lt = next_execute_time_lt

    @property
    def next_execute_time_lte(self):
        """Gets the next_execute_time_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The next_execute_time_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execute_time_lte

    @next_execute_time_lte.setter
    def next_execute_time_lte(self, next_execute_time_lte):
        """Sets the next_execute_time_lte of this BackupPlanWhereInput.


        :param next_execute_time_lte: The next_execute_time_lte of this BackupPlanWhereInput.  # noqa: E501
        :type next_execute_time_lte: str
        """

        self._next_execute_time_lte = next_execute_time_lte

    @property
    def next_execute_time_not(self):
        """Gets the next_execute_time_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The next_execute_time_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._next_execute_time_not

    @next_execute_time_not.setter
    def next_execute_time_not(self, next_execute_time_not):
        """Sets the next_execute_time_not of this BackupPlanWhereInput.


        :param next_execute_time_not: The next_execute_time_not of this BackupPlanWhereInput.  # noqa: E501
        :type next_execute_time_not: str
        """

        self._next_execute_time_not = next_execute_time_not

    @property
    def next_execute_time_not_in(self):
        """Gets the next_execute_time_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The next_execute_time_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._next_execute_time_not_in

    @next_execute_time_not_in.setter
    def next_execute_time_not_in(self, next_execute_time_not_in):
        """Sets the next_execute_time_not_in of this BackupPlanWhereInput.


        :param next_execute_time_not_in: The next_execute_time_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type next_execute_time_not_in: list[str]
        """

        self._next_execute_time_not_in = next_execute_time_not_in

    @property
    def phase(self):
        """Gets the phase of this BackupPlanWhereInput.  # noqa: E501


        :return: The phase of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanPhase
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """Sets the phase of this BackupPlanWhereInput.


        :param phase: The phase of this BackupPlanWhereInput.  # noqa: E501
        :type phase: BackupPlanPhase
        """

        self._phase = phase

    @property
    def phase_in(self):
        """Gets the phase_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The phase_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanPhase]
        """
        return self._phase_in

    @phase_in.setter
    def phase_in(self, phase_in):
        """Sets the phase_in of this BackupPlanWhereInput.


        :param phase_in: The phase_in of this BackupPlanWhereInput.  # noqa: E501
        :type phase_in: list[BackupPlanPhase]
        """

        self._phase_in = phase_in

    @property
    def phase_not(self):
        """Gets the phase_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The phase_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanPhase
        """
        return self._phase_not

    @phase_not.setter
    def phase_not(self, phase_not):
        """Sets the phase_not of this BackupPlanWhereInput.


        :param phase_not: The phase_not of this BackupPlanWhereInput.  # noqa: E501
        :type phase_not: BackupPlanPhase
        """

        self._phase_not = phase_not

    @property
    def phase_not_in(self):
        """Gets the phase_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The phase_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanPhase]
        """
        return self._phase_not_in

    @phase_not_in.setter
    def phase_not_in(self, phase_not_in):
        """Sets the phase_not_in of this BackupPlanWhereInput.


        :param phase_not_in: The phase_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type phase_not_in: list[BackupPlanPhase]
        """

        self._phase_not_in = phase_not_in

    @property
    def physical_size(self):
        """Gets the physical_size of this BackupPlanWhereInput.  # noqa: E501


        :return: The physical_size of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size

    @physical_size.setter
    def physical_size(self, physical_size):
        """Sets the physical_size of this BackupPlanWhereInput.


        :param physical_size: The physical_size of this BackupPlanWhereInput.  # noqa: E501
        :type physical_size: int
        """

        self._physical_size = physical_size

    @property
    def physical_size_gt(self):
        """Gets the physical_size_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The physical_size_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size_gt

    @physical_size_gt.setter
    def physical_size_gt(self, physical_size_gt):
        """Sets the physical_size_gt of this BackupPlanWhereInput.


        :param physical_size_gt: The physical_size_gt of this BackupPlanWhereInput.  # noqa: E501
        :type physical_size_gt: int
        """

        self._physical_size_gt = physical_size_gt

    @property
    def physical_size_gte(self):
        """Gets the physical_size_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The physical_size_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size_gte

    @physical_size_gte.setter
    def physical_size_gte(self, physical_size_gte):
        """Sets the physical_size_gte of this BackupPlanWhereInput.


        :param physical_size_gte: The physical_size_gte of this BackupPlanWhereInput.  # noqa: E501
        :type physical_size_gte: int
        """

        self._physical_size_gte = physical_size_gte

    @property
    def physical_size_in(self):
        """Gets the physical_size_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The physical_size_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._physical_size_in

    @physical_size_in.setter
    def physical_size_in(self, physical_size_in):
        """Sets the physical_size_in of this BackupPlanWhereInput.


        :param physical_size_in: The physical_size_in of this BackupPlanWhereInput.  # noqa: E501
        :type physical_size_in: list[int]
        """

        self._physical_size_in = physical_size_in

    @property
    def physical_size_lt(self):
        """Gets the physical_size_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The physical_size_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size_lt

    @physical_size_lt.setter
    def physical_size_lt(self, physical_size_lt):
        """Sets the physical_size_lt of this BackupPlanWhereInput.


        :param physical_size_lt: The physical_size_lt of this BackupPlanWhereInput.  # noqa: E501
        :type physical_size_lt: int
        """

        self._physical_size_lt = physical_size_lt

    @property
    def physical_size_lte(self):
        """Gets the physical_size_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The physical_size_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size_lte

    @physical_size_lte.setter
    def physical_size_lte(self, physical_size_lte):
        """Sets the physical_size_lte of this BackupPlanWhereInput.


        :param physical_size_lte: The physical_size_lte of this BackupPlanWhereInput.  # noqa: E501
        :type physical_size_lte: int
        """

        self._physical_size_lte = physical_size_lte

    @property
    def physical_size_not(self):
        """Gets the physical_size_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The physical_size_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size_not

    @physical_size_not.setter
    def physical_size_not(self, physical_size_not):
        """Sets the physical_size_not of this BackupPlanWhereInput.


        :param physical_size_not: The physical_size_not of this BackupPlanWhereInput.  # noqa: E501
        :type physical_size_not: int
        """

        self._physical_size_not = physical_size_not

    @property
    def physical_size_not_in(self):
        """Gets the physical_size_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The physical_size_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._physical_size_not_in

    @physical_size_not_in.setter
    def physical_size_not_in(self, physical_size_not_in):
        """Sets the physical_size_not_in of this BackupPlanWhereInput.


        :param physical_size_not_in: The physical_size_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type physical_size_not_in: list[int]
        """

        self._physical_size_not_in = physical_size_not_in

    @property
    def snapshot_consistent_type(self):
        """Gets the snapshot_consistent_type of this BackupPlanWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type of this BackupPlanWhereInput.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._snapshot_consistent_type

    @snapshot_consistent_type.setter
    def snapshot_consistent_type(self, snapshot_consistent_type):
        """Sets the snapshot_consistent_type of this BackupPlanWhereInput.


        :param snapshot_consistent_type: The snapshot_consistent_type of this BackupPlanWhereInput.  # noqa: E501
        :type snapshot_consistent_type: ConsistentType
        """

        self._snapshot_consistent_type = snapshot_consistent_type

    @property
    def snapshot_consistent_type_in(self):
        """Gets the snapshot_consistent_type_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[ConsistentType]
        """
        return self._snapshot_consistent_type_in

    @snapshot_consistent_type_in.setter
    def snapshot_consistent_type_in(self, snapshot_consistent_type_in):
        """Sets the snapshot_consistent_type_in of this BackupPlanWhereInput.


        :param snapshot_consistent_type_in: The snapshot_consistent_type_in of this BackupPlanWhereInput.  # noqa: E501
        :type snapshot_consistent_type_in: list[ConsistentType]
        """

        self._snapshot_consistent_type_in = snapshot_consistent_type_in

    @property
    def snapshot_consistent_type_not(self):
        """Gets the snapshot_consistent_type_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._snapshot_consistent_type_not

    @snapshot_consistent_type_not.setter
    def snapshot_consistent_type_not(self, snapshot_consistent_type_not):
        """Sets the snapshot_consistent_type_not of this BackupPlanWhereInput.


        :param snapshot_consistent_type_not: The snapshot_consistent_type_not of this BackupPlanWhereInput.  # noqa: E501
        :type snapshot_consistent_type_not: ConsistentType
        """

        self._snapshot_consistent_type_not = snapshot_consistent_type_not

    @property
    def snapshot_consistent_type_not_in(self):
        """Gets the snapshot_consistent_type_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[ConsistentType]
        """
        return self._snapshot_consistent_type_not_in

    @snapshot_consistent_type_not_in.setter
    def snapshot_consistent_type_not_in(self, snapshot_consistent_type_not_in):
        """Sets the snapshot_consistent_type_not_in of this BackupPlanWhereInput.


        :param snapshot_consistent_type_not_in: The snapshot_consistent_type_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type snapshot_consistent_type_not_in: list[ConsistentType]
        """

        self._snapshot_consistent_type_not_in = snapshot_consistent_type_not_in

    @property
    def status(self):
        """Gets the status of this BackupPlanWhereInput.  # noqa: E501


        :return: The status of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BackupPlanWhereInput.


        :param status: The status of this BackupPlanWhereInput.  # noqa: E501
        :type status: BackupPlanStatus
        """

        self._status = status

    @property
    def status_in(self):
        """Gets the status_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The status_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanStatus]
        """
        return self._status_in

    @status_in.setter
    def status_in(self, status_in):
        """Sets the status_in of this BackupPlanWhereInput.


        :param status_in: The status_in of this BackupPlanWhereInput.  # noqa: E501
        :type status_in: list[BackupPlanStatus]
        """

        self._status_in = status_in

    @property
    def status_not(self):
        """Gets the status_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The status_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: BackupPlanStatus
        """
        return self._status_not

    @status_not.setter
    def status_not(self, status_not):
        """Sets the status_not of this BackupPlanWhereInput.


        :param status_not: The status_not of this BackupPlanWhereInput.  # noqa: E501
        :type status_not: BackupPlanStatus
        """

        self._status_not = status_not

    @property
    def status_not_in(self):
        """Gets the status_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The status_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[BackupPlanStatus]
        """
        return self._status_not_in

    @status_not_in.setter
    def status_not_in(self, status_not_in):
        """Sets the status_not_in of this BackupPlanWhereInput.


        :param status_not_in: The status_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type status_not_in: list[BackupPlanStatus]
        """

        self._status_not_in = status_not_in

    @property
    def valid_size_of_backup_object(self):
        """Gets the valid_size_of_backup_object of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_backup_object of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_backup_object

    @valid_size_of_backup_object.setter
    def valid_size_of_backup_object(self, valid_size_of_backup_object):
        """Sets the valid_size_of_backup_object of this BackupPlanWhereInput.


        :param valid_size_of_backup_object: The valid_size_of_backup_object of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_backup_object: int
        """

        self._valid_size_of_backup_object = valid_size_of_backup_object

    @property
    def valid_size_of_backup_object_gt(self):
        """Gets the valid_size_of_backup_object_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_backup_object_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_backup_object_gt

    @valid_size_of_backup_object_gt.setter
    def valid_size_of_backup_object_gt(self, valid_size_of_backup_object_gt):
        """Sets the valid_size_of_backup_object_gt of this BackupPlanWhereInput.


        :param valid_size_of_backup_object_gt: The valid_size_of_backup_object_gt of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_backup_object_gt: int
        """

        self._valid_size_of_backup_object_gt = valid_size_of_backup_object_gt

    @property
    def valid_size_of_backup_object_gte(self):
        """Gets the valid_size_of_backup_object_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_backup_object_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_backup_object_gte

    @valid_size_of_backup_object_gte.setter
    def valid_size_of_backup_object_gte(self, valid_size_of_backup_object_gte):
        """Sets the valid_size_of_backup_object_gte of this BackupPlanWhereInput.


        :param valid_size_of_backup_object_gte: The valid_size_of_backup_object_gte of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_backup_object_gte: int
        """

        self._valid_size_of_backup_object_gte = valid_size_of_backup_object_gte

    @property
    def valid_size_of_backup_object_in(self):
        """Gets the valid_size_of_backup_object_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_backup_object_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_size_of_backup_object_in

    @valid_size_of_backup_object_in.setter
    def valid_size_of_backup_object_in(self, valid_size_of_backup_object_in):
        """Sets the valid_size_of_backup_object_in of this BackupPlanWhereInput.


        :param valid_size_of_backup_object_in: The valid_size_of_backup_object_in of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_backup_object_in: list[int]
        """

        self._valid_size_of_backup_object_in = valid_size_of_backup_object_in

    @property
    def valid_size_of_backup_object_lt(self):
        """Gets the valid_size_of_backup_object_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_backup_object_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_backup_object_lt

    @valid_size_of_backup_object_lt.setter
    def valid_size_of_backup_object_lt(self, valid_size_of_backup_object_lt):
        """Sets the valid_size_of_backup_object_lt of this BackupPlanWhereInput.


        :param valid_size_of_backup_object_lt: The valid_size_of_backup_object_lt of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_backup_object_lt: int
        """

        self._valid_size_of_backup_object_lt = valid_size_of_backup_object_lt

    @property
    def valid_size_of_backup_object_lte(self):
        """Gets the valid_size_of_backup_object_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_backup_object_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_backup_object_lte

    @valid_size_of_backup_object_lte.setter
    def valid_size_of_backup_object_lte(self, valid_size_of_backup_object_lte):
        """Sets the valid_size_of_backup_object_lte of this BackupPlanWhereInput.


        :param valid_size_of_backup_object_lte: The valid_size_of_backup_object_lte of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_backup_object_lte: int
        """

        self._valid_size_of_backup_object_lte = valid_size_of_backup_object_lte

    @property
    def valid_size_of_backup_object_not(self):
        """Gets the valid_size_of_backup_object_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_backup_object_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_backup_object_not

    @valid_size_of_backup_object_not.setter
    def valid_size_of_backup_object_not(self, valid_size_of_backup_object_not):
        """Sets the valid_size_of_backup_object_not of this BackupPlanWhereInput.


        :param valid_size_of_backup_object_not: The valid_size_of_backup_object_not of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_backup_object_not: int
        """

        self._valid_size_of_backup_object_not = valid_size_of_backup_object_not

    @property
    def valid_size_of_backup_object_not_in(self):
        """Gets the valid_size_of_backup_object_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_backup_object_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_size_of_backup_object_not_in

    @valid_size_of_backup_object_not_in.setter
    def valid_size_of_backup_object_not_in(self, valid_size_of_backup_object_not_in):
        """Sets the valid_size_of_backup_object_not_in of this BackupPlanWhereInput.


        :param valid_size_of_backup_object_not_in: The valid_size_of_backup_object_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_backup_object_not_in: list[int]
        """

        self._valid_size_of_backup_object_not_in = valid_size_of_backup_object_not_in

    @property
    def valid_size_of_restore_point(self):
        """Gets the valid_size_of_restore_point of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_restore_point of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_restore_point

    @valid_size_of_restore_point.setter
    def valid_size_of_restore_point(self, valid_size_of_restore_point):
        """Sets the valid_size_of_restore_point of this BackupPlanWhereInput.


        :param valid_size_of_restore_point: The valid_size_of_restore_point of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_restore_point: int
        """

        self._valid_size_of_restore_point = valid_size_of_restore_point

    @property
    def valid_size_of_restore_point_gt(self):
        """Gets the valid_size_of_restore_point_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_restore_point_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_restore_point_gt

    @valid_size_of_restore_point_gt.setter
    def valid_size_of_restore_point_gt(self, valid_size_of_restore_point_gt):
        """Sets the valid_size_of_restore_point_gt of this BackupPlanWhereInput.


        :param valid_size_of_restore_point_gt: The valid_size_of_restore_point_gt of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_restore_point_gt: int
        """

        self._valid_size_of_restore_point_gt = valid_size_of_restore_point_gt

    @property
    def valid_size_of_restore_point_gte(self):
        """Gets the valid_size_of_restore_point_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_restore_point_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_restore_point_gte

    @valid_size_of_restore_point_gte.setter
    def valid_size_of_restore_point_gte(self, valid_size_of_restore_point_gte):
        """Sets the valid_size_of_restore_point_gte of this BackupPlanWhereInput.


        :param valid_size_of_restore_point_gte: The valid_size_of_restore_point_gte of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_restore_point_gte: int
        """

        self._valid_size_of_restore_point_gte = valid_size_of_restore_point_gte

    @property
    def valid_size_of_restore_point_in(self):
        """Gets the valid_size_of_restore_point_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_restore_point_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_size_of_restore_point_in

    @valid_size_of_restore_point_in.setter
    def valid_size_of_restore_point_in(self, valid_size_of_restore_point_in):
        """Sets the valid_size_of_restore_point_in of this BackupPlanWhereInput.


        :param valid_size_of_restore_point_in: The valid_size_of_restore_point_in of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_restore_point_in: list[int]
        """

        self._valid_size_of_restore_point_in = valid_size_of_restore_point_in

    @property
    def valid_size_of_restore_point_lt(self):
        """Gets the valid_size_of_restore_point_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_restore_point_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_restore_point_lt

    @valid_size_of_restore_point_lt.setter
    def valid_size_of_restore_point_lt(self, valid_size_of_restore_point_lt):
        """Sets the valid_size_of_restore_point_lt of this BackupPlanWhereInput.


        :param valid_size_of_restore_point_lt: The valid_size_of_restore_point_lt of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_restore_point_lt: int
        """

        self._valid_size_of_restore_point_lt = valid_size_of_restore_point_lt

    @property
    def valid_size_of_restore_point_lte(self):
        """Gets the valid_size_of_restore_point_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_restore_point_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_restore_point_lte

    @valid_size_of_restore_point_lte.setter
    def valid_size_of_restore_point_lte(self, valid_size_of_restore_point_lte):
        """Sets the valid_size_of_restore_point_lte of this BackupPlanWhereInput.


        :param valid_size_of_restore_point_lte: The valid_size_of_restore_point_lte of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_restore_point_lte: int
        """

        self._valid_size_of_restore_point_lte = valid_size_of_restore_point_lte

    @property
    def valid_size_of_restore_point_not(self):
        """Gets the valid_size_of_restore_point_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_restore_point_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_of_restore_point_not

    @valid_size_of_restore_point_not.setter
    def valid_size_of_restore_point_not(self, valid_size_of_restore_point_not):
        """Sets the valid_size_of_restore_point_not of this BackupPlanWhereInput.


        :param valid_size_of_restore_point_not: The valid_size_of_restore_point_not of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_restore_point_not: int
        """

        self._valid_size_of_restore_point_not = valid_size_of_restore_point_not

    @property
    def valid_size_of_restore_point_not_in(self):
        """Gets the valid_size_of_restore_point_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The valid_size_of_restore_point_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_size_of_restore_point_not_in

    @valid_size_of_restore_point_not_in.setter
    def valid_size_of_restore_point_not_in(self, valid_size_of_restore_point_not_in):
        """Sets the valid_size_of_restore_point_not_in of this BackupPlanWhereInput.


        :param valid_size_of_restore_point_not_in: The valid_size_of_restore_point_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type valid_size_of_restore_point_not_in: list[int]
        """

        self._valid_size_of_restore_point_not_in = valid_size_of_restore_point_not_in

    @property
    def vms_every(self):
        """Gets the vms_every of this BackupPlanWhereInput.  # noqa: E501


        :return: The vms_every of this BackupPlanWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_every

    @vms_every.setter
    def vms_every(self, vms_every):
        """Sets the vms_every of this BackupPlanWhereInput.


        :param vms_every: The vms_every of this BackupPlanWhereInput.  # noqa: E501
        :type vms_every: VmWhereInput
        """

        self._vms_every = vms_every

    @property
    def vms_none(self):
        """Gets the vms_none of this BackupPlanWhereInput.  # noqa: E501


        :return: The vms_none of this BackupPlanWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_none

    @vms_none.setter
    def vms_none(self, vms_none):
        """Sets the vms_none of this BackupPlanWhereInput.


        :param vms_none: The vms_none of this BackupPlanWhereInput.  # noqa: E501
        :type vms_none: VmWhereInput
        """

        self._vms_none = vms_none

    @property
    def vms_some(self):
        """Gets the vms_some of this BackupPlanWhereInput.  # noqa: E501


        :return: The vms_some of this BackupPlanWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vms_some

    @vms_some.setter
    def vms_some(self, vms_some):
        """Sets the vms_some of this BackupPlanWhereInput.


        :param vms_some: The vms_some of this BackupPlanWhereInput.  # noqa: E501
        :type vms_some: VmWhereInput
        """

        self._vms_some = vms_some

    @property
    def window_end(self):
        """Gets the window_end of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end

    @window_end.setter
    def window_end(self, window_end):
        """Sets the window_end of this BackupPlanWhereInput.


        :param window_end: The window_end of this BackupPlanWhereInput.  # noqa: E501
        :type window_end: str
        """

        self._window_end = window_end

    @property
    def window_end_contains(self):
        """Gets the window_end_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_contains

    @window_end_contains.setter
    def window_end_contains(self, window_end_contains):
        """Sets the window_end_contains of this BackupPlanWhereInput.


        :param window_end_contains: The window_end_contains of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_contains: str
        """

        self._window_end_contains = window_end_contains

    @property
    def window_end_ends_with(self):
        """Gets the window_end_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_ends_with

    @window_end_ends_with.setter
    def window_end_ends_with(self, window_end_ends_with):
        """Sets the window_end_ends_with of this BackupPlanWhereInput.


        :param window_end_ends_with: The window_end_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_ends_with: str
        """

        self._window_end_ends_with = window_end_ends_with

    @property
    def window_end_gt(self):
        """Gets the window_end_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_gt

    @window_end_gt.setter
    def window_end_gt(self, window_end_gt):
        """Sets the window_end_gt of this BackupPlanWhereInput.


        :param window_end_gt: The window_end_gt of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_gt: str
        """

        self._window_end_gt = window_end_gt

    @property
    def window_end_gte(self):
        """Gets the window_end_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_gte

    @window_end_gte.setter
    def window_end_gte(self, window_end_gte):
        """Sets the window_end_gte of this BackupPlanWhereInput.


        :param window_end_gte: The window_end_gte of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_gte: str
        """

        self._window_end_gte = window_end_gte

    @property
    def window_end_in(self):
        """Gets the window_end_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._window_end_in

    @window_end_in.setter
    def window_end_in(self, window_end_in):
        """Sets the window_end_in of this BackupPlanWhereInput.


        :param window_end_in: The window_end_in of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_in: list[str]
        """

        self._window_end_in = window_end_in

    @property
    def window_end_lt(self):
        """Gets the window_end_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_lt

    @window_end_lt.setter
    def window_end_lt(self, window_end_lt):
        """Sets the window_end_lt of this BackupPlanWhereInput.


        :param window_end_lt: The window_end_lt of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_lt: str
        """

        self._window_end_lt = window_end_lt

    @property
    def window_end_lte(self):
        """Gets the window_end_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_lte

    @window_end_lte.setter
    def window_end_lte(self, window_end_lte):
        """Sets the window_end_lte of this BackupPlanWhereInput.


        :param window_end_lte: The window_end_lte of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_lte: str
        """

        self._window_end_lte = window_end_lte

    @property
    def window_end_not(self):
        """Gets the window_end_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_not

    @window_end_not.setter
    def window_end_not(self, window_end_not):
        """Sets the window_end_not of this BackupPlanWhereInput.


        :param window_end_not: The window_end_not of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_not: str
        """

        self._window_end_not = window_end_not

    @property
    def window_end_not_contains(self):
        """Gets the window_end_not_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_not_contains

    @window_end_not_contains.setter
    def window_end_not_contains(self, window_end_not_contains):
        """Sets the window_end_not_contains of this BackupPlanWhereInput.


        :param window_end_not_contains: The window_end_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_not_contains: str
        """

        self._window_end_not_contains = window_end_not_contains

    @property
    def window_end_not_ends_with(self):
        """Gets the window_end_not_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_not_ends_with

    @window_end_not_ends_with.setter
    def window_end_not_ends_with(self, window_end_not_ends_with):
        """Sets the window_end_not_ends_with of this BackupPlanWhereInput.


        :param window_end_not_ends_with: The window_end_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_not_ends_with: str
        """

        self._window_end_not_ends_with = window_end_not_ends_with

    @property
    def window_end_not_in(self):
        """Gets the window_end_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._window_end_not_in

    @window_end_not_in.setter
    def window_end_not_in(self, window_end_not_in):
        """Sets the window_end_not_in of this BackupPlanWhereInput.


        :param window_end_not_in: The window_end_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_not_in: list[str]
        """

        self._window_end_not_in = window_end_not_in

    @property
    def window_end_not_starts_with(self):
        """Gets the window_end_not_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_not_starts_with

    @window_end_not_starts_with.setter
    def window_end_not_starts_with(self, window_end_not_starts_with):
        """Sets the window_end_not_starts_with of this BackupPlanWhereInput.


        :param window_end_not_starts_with: The window_end_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_not_starts_with: str
        """

        self._window_end_not_starts_with = window_end_not_starts_with

    @property
    def window_end_starts_with(self):
        """Gets the window_end_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_end_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_end_starts_with

    @window_end_starts_with.setter
    def window_end_starts_with(self, window_end_starts_with):
        """Sets the window_end_starts_with of this BackupPlanWhereInput.


        :param window_end_starts_with: The window_end_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type window_end_starts_with: str
        """

        self._window_end_starts_with = window_end_starts_with

    @property
    def window_start(self):
        """Gets the window_start of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start

    @window_start.setter
    def window_start(self, window_start):
        """Sets the window_start of this BackupPlanWhereInput.


        :param window_start: The window_start of this BackupPlanWhereInput.  # noqa: E501
        :type window_start: str
        """

        self._window_start = window_start

    @property
    def window_start_contains(self):
        """Gets the window_start_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_contains

    @window_start_contains.setter
    def window_start_contains(self, window_start_contains):
        """Sets the window_start_contains of this BackupPlanWhereInput.


        :param window_start_contains: The window_start_contains of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_contains: str
        """

        self._window_start_contains = window_start_contains

    @property
    def window_start_ends_with(self):
        """Gets the window_start_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_ends_with

    @window_start_ends_with.setter
    def window_start_ends_with(self, window_start_ends_with):
        """Sets the window_start_ends_with of this BackupPlanWhereInput.


        :param window_start_ends_with: The window_start_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_ends_with: str
        """

        self._window_start_ends_with = window_start_ends_with

    @property
    def window_start_gt(self):
        """Gets the window_start_gt of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_gt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_gt

    @window_start_gt.setter
    def window_start_gt(self, window_start_gt):
        """Sets the window_start_gt of this BackupPlanWhereInput.


        :param window_start_gt: The window_start_gt of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_gt: str
        """

        self._window_start_gt = window_start_gt

    @property
    def window_start_gte(self):
        """Gets the window_start_gte of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_gte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_gte

    @window_start_gte.setter
    def window_start_gte(self, window_start_gte):
        """Sets the window_start_gte of this BackupPlanWhereInput.


        :param window_start_gte: The window_start_gte of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_gte: str
        """

        self._window_start_gte = window_start_gte

    @property
    def window_start_in(self):
        """Gets the window_start_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._window_start_in

    @window_start_in.setter
    def window_start_in(self, window_start_in):
        """Sets the window_start_in of this BackupPlanWhereInput.


        :param window_start_in: The window_start_in of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_in: list[str]
        """

        self._window_start_in = window_start_in

    @property
    def window_start_lt(self):
        """Gets the window_start_lt of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_lt of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_lt

    @window_start_lt.setter
    def window_start_lt(self, window_start_lt):
        """Sets the window_start_lt of this BackupPlanWhereInput.


        :param window_start_lt: The window_start_lt of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_lt: str
        """

        self._window_start_lt = window_start_lt

    @property
    def window_start_lte(self):
        """Gets the window_start_lte of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_lte of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_lte

    @window_start_lte.setter
    def window_start_lte(self, window_start_lte):
        """Sets the window_start_lte of this BackupPlanWhereInput.


        :param window_start_lte: The window_start_lte of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_lte: str
        """

        self._window_start_lte = window_start_lte

    @property
    def window_start_not(self):
        """Gets the window_start_not of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_not of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_not

    @window_start_not.setter
    def window_start_not(self, window_start_not):
        """Sets the window_start_not of this BackupPlanWhereInput.


        :param window_start_not: The window_start_not of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_not: str
        """

        self._window_start_not = window_start_not

    @property
    def window_start_not_contains(self):
        """Gets the window_start_not_contains of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_not_contains

    @window_start_not_contains.setter
    def window_start_not_contains(self, window_start_not_contains):
        """Sets the window_start_not_contains of this BackupPlanWhereInput.


        :param window_start_not_contains: The window_start_not_contains of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_not_contains: str
        """

        self._window_start_not_contains = window_start_not_contains

    @property
    def window_start_not_ends_with(self):
        """Gets the window_start_not_ends_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_not_ends_with

    @window_start_not_ends_with.setter
    def window_start_not_ends_with(self, window_start_not_ends_with):
        """Sets the window_start_not_ends_with of this BackupPlanWhereInput.


        :param window_start_not_ends_with: The window_start_not_ends_with of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_not_ends_with: str
        """

        self._window_start_not_ends_with = window_start_not_ends_with

    @property
    def window_start_not_in(self):
        """Gets the window_start_not_in of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_not_in of this BackupPlanWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._window_start_not_in

    @window_start_not_in.setter
    def window_start_not_in(self, window_start_not_in):
        """Sets the window_start_not_in of this BackupPlanWhereInput.


        :param window_start_not_in: The window_start_not_in of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_not_in: list[str]
        """

        self._window_start_not_in = window_start_not_in

    @property
    def window_start_not_starts_with(self):
        """Gets the window_start_not_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_not_starts_with

    @window_start_not_starts_with.setter
    def window_start_not_starts_with(self, window_start_not_starts_with):
        """Sets the window_start_not_starts_with of this BackupPlanWhereInput.


        :param window_start_not_starts_with: The window_start_not_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_not_starts_with: str
        """

        self._window_start_not_starts_with = window_start_not_starts_with

    @property
    def window_start_starts_with(self):
        """Gets the window_start_starts_with of this BackupPlanWhereInput.  # noqa: E501


        :return: The window_start_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._window_start_starts_with

    @window_start_starts_with.setter
    def window_start_starts_with(self, window_start_starts_with):
        """Sets the window_start_starts_with of this BackupPlanWhereInput.


        :param window_start_starts_with: The window_start_starts_with of this BackupPlanWhereInput.  # noqa: E501
        :type window_start_starts_with: str
        """

        self._window_start_starts_with = window_start_starts_with

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupPlanWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupPlanWhereInput):
            return True

        return self.to_dict() != other.to_dict()
