# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupRestoreExecution(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'backup_restore_point': 'NestedBackupRestorePoint',
        'duration': 'int',
        'entity_async_status': 'EntityAsyncStatus',
        'executed_at': 'str',
        'id': 'str',
        'mode': 'BackupRestoreExecutionMode',
        'name': 'str',
        'read_bytes': 'int',
        'rebuild_name': 'str',
        'rebuild_network_mapping': 'list[NestedBackupRestoreExecutionNetworkMapping]',
        'rebuild_target_cluster': 'str',
        'retry_times': 'int',
        'startup_after_restore': 'bool',
        'status': 'BackupExecutionStatus',
        'total_bytes': 'int'
    }

    attribute_map = {
        'backup_restore_point': 'backup_restore_point',
        'duration': 'duration',
        'entity_async_status': 'entityAsyncStatus',
        'executed_at': 'executed_at',
        'id': 'id',
        'mode': 'mode',
        'name': 'name',
        'read_bytes': 'read_bytes',
        'rebuild_name': 'rebuild_name',
        'rebuild_network_mapping': 'rebuild_network_mapping',
        'rebuild_target_cluster': 'rebuild_target_cluster',
        'retry_times': 'retry_times',
        'startup_after_restore': 'startup_after_restore',
        'status': 'status',
        'total_bytes': 'total_bytes'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupRestoreExecution - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._backup_restore_point = None
        self._duration = None
        self._entity_async_status = None
        self._executed_at = None
        self._id = None
        self._mode = None
        self._name = None
        self._read_bytes = None
        self._rebuild_name = None
        self._rebuild_network_mapping = None
        self._rebuild_target_cluster = None
        self._retry_times = None
        self._startup_after_restore = None
        self._status = None
        self._total_bytes = None
        self.discriminator = None

        self.backup_restore_point = kwargs.get("backup_restore_point", None)
        self.duration = kwargs.get("duration", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "executed_at" in kwargs:
            self.executed_at = kwargs["executed_at"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "mode" in kwargs:
            self.mode = kwargs["mode"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.read_bytes = kwargs.get("read_bytes", None)
        self.rebuild_name = kwargs.get("rebuild_name", None)
        self.rebuild_network_mapping = kwargs.get("rebuild_network_mapping", None)
        self.rebuild_target_cluster = kwargs.get("rebuild_target_cluster", None)
        self.retry_times = kwargs.get("retry_times", None)
        if "startup_after_restore" in kwargs:
            self.startup_after_restore = kwargs["startup_after_restore"]
        if "status" in kwargs:
            self.status = kwargs["status"]
        self.total_bytes = kwargs.get("total_bytes", None)

    @property
    def backup_restore_point(self):
        """Gets the backup_restore_point of this BackupRestoreExecution.  # noqa: E501


        :return: The backup_restore_point of this BackupRestoreExecution.  # noqa: E501
        :rtype: NestedBackupRestorePoint
        """
        return self._backup_restore_point

    @backup_restore_point.setter
    def backup_restore_point(self, backup_restore_point):
        """Sets the backup_restore_point of this BackupRestoreExecution.


        :param backup_restore_point: The backup_restore_point of this BackupRestoreExecution.  # noqa: E501
        :type backup_restore_point: NestedBackupRestorePoint
        """

        self._backup_restore_point = backup_restore_point

    @property
    def duration(self):
        """Gets the duration of this BackupRestoreExecution.  # noqa: E501


        :return: The duration of this BackupRestoreExecution.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this BackupRestoreExecution.


        :param duration: The duration of this BackupRestoreExecution.  # noqa: E501
        :type duration: int
        """

        self._duration = duration

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this BackupRestoreExecution.  # noqa: E501


        :return: The entity_async_status of this BackupRestoreExecution.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this BackupRestoreExecution.


        :param entity_async_status: The entity_async_status of this BackupRestoreExecution.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def executed_at(self):
        """Gets the executed_at of this BackupRestoreExecution.  # noqa: E501


        :return: The executed_at of this BackupRestoreExecution.  # noqa: E501
        :rtype: str
        """
        return self._executed_at

    @executed_at.setter
    def executed_at(self, executed_at):
        """Sets the executed_at of this BackupRestoreExecution.


        :param executed_at: The executed_at of this BackupRestoreExecution.  # noqa: E501
        :type executed_at: str
        """
        if self.local_vars_configuration.client_side_validation and executed_at is None:  # noqa: E501
            raise ValueError("Invalid value for `executed_at`, must not be `None`")  # noqa: E501

        self._executed_at = executed_at

    @property
    def id(self):
        """Gets the id of this BackupRestoreExecution.  # noqa: E501


        :return: The id of this BackupRestoreExecution.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BackupRestoreExecution.


        :param id: The id of this BackupRestoreExecution.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def mode(self):
        """Gets the mode of this BackupRestoreExecution.  # noqa: E501


        :return: The mode of this BackupRestoreExecution.  # noqa: E501
        :rtype: BackupRestoreExecutionMode
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """Sets the mode of this BackupRestoreExecution.


        :param mode: The mode of this BackupRestoreExecution.  # noqa: E501
        :type mode: BackupRestoreExecutionMode
        """
        if self.local_vars_configuration.client_side_validation and mode is None:  # noqa: E501
            raise ValueError("Invalid value for `mode`, must not be `None`")  # noqa: E501

        self._mode = mode

    @property
    def name(self):
        """Gets the name of this BackupRestoreExecution.  # noqa: E501


        :return: The name of this BackupRestoreExecution.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BackupRestoreExecution.


        :param name: The name of this BackupRestoreExecution.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def read_bytes(self):
        """Gets the read_bytes of this BackupRestoreExecution.  # noqa: E501


        :return: The read_bytes of this BackupRestoreExecution.  # noqa: E501
        :rtype: int
        """
        return self._read_bytes

    @read_bytes.setter
    def read_bytes(self, read_bytes):
        """Sets the read_bytes of this BackupRestoreExecution.


        :param read_bytes: The read_bytes of this BackupRestoreExecution.  # noqa: E501
        :type read_bytes: int
        """

        self._read_bytes = read_bytes

    @property
    def rebuild_name(self):
        """Gets the rebuild_name of this BackupRestoreExecution.  # noqa: E501


        :return: The rebuild_name of this BackupRestoreExecution.  # noqa: E501
        :rtype: str
        """
        return self._rebuild_name

    @rebuild_name.setter
    def rebuild_name(self, rebuild_name):
        """Sets the rebuild_name of this BackupRestoreExecution.


        :param rebuild_name: The rebuild_name of this BackupRestoreExecution.  # noqa: E501
        :type rebuild_name: str
        """

        self._rebuild_name = rebuild_name

    @property
    def rebuild_network_mapping(self):
        """Gets the rebuild_network_mapping of this BackupRestoreExecution.  # noqa: E501


        :return: The rebuild_network_mapping of this BackupRestoreExecution.  # noqa: E501
        :rtype: list[NestedBackupRestoreExecutionNetworkMapping]
        """
        return self._rebuild_network_mapping

    @rebuild_network_mapping.setter
    def rebuild_network_mapping(self, rebuild_network_mapping):
        """Sets the rebuild_network_mapping of this BackupRestoreExecution.


        :param rebuild_network_mapping: The rebuild_network_mapping of this BackupRestoreExecution.  # noqa: E501
        :type rebuild_network_mapping: list[NestedBackupRestoreExecutionNetworkMapping]
        """

        self._rebuild_network_mapping = rebuild_network_mapping

    @property
    def rebuild_target_cluster(self):
        """Gets the rebuild_target_cluster of this BackupRestoreExecution.  # noqa: E501


        :return: The rebuild_target_cluster of this BackupRestoreExecution.  # noqa: E501
        :rtype: str
        """
        return self._rebuild_target_cluster

    @rebuild_target_cluster.setter
    def rebuild_target_cluster(self, rebuild_target_cluster):
        """Sets the rebuild_target_cluster of this BackupRestoreExecution.


        :param rebuild_target_cluster: The rebuild_target_cluster of this BackupRestoreExecution.  # noqa: E501
        :type rebuild_target_cluster: str
        """

        self._rebuild_target_cluster = rebuild_target_cluster

    @property
    def retry_times(self):
        """Gets the retry_times of this BackupRestoreExecution.  # noqa: E501


        :return: The retry_times of this BackupRestoreExecution.  # noqa: E501
        :rtype: int
        """
        return self._retry_times

    @retry_times.setter
    def retry_times(self, retry_times):
        """Sets the retry_times of this BackupRestoreExecution.


        :param retry_times: The retry_times of this BackupRestoreExecution.  # noqa: E501
        :type retry_times: int
        """

        self._retry_times = retry_times

    @property
    def startup_after_restore(self):
        """Gets the startup_after_restore of this BackupRestoreExecution.  # noqa: E501


        :return: The startup_after_restore of this BackupRestoreExecution.  # noqa: E501
        :rtype: bool
        """
        return self._startup_after_restore

    @startup_after_restore.setter
    def startup_after_restore(self, startup_after_restore):
        """Sets the startup_after_restore of this BackupRestoreExecution.


        :param startup_after_restore: The startup_after_restore of this BackupRestoreExecution.  # noqa: E501
        :type startup_after_restore: bool
        """
        if self.local_vars_configuration.client_side_validation and startup_after_restore is None:  # noqa: E501
            raise ValueError("Invalid value for `startup_after_restore`, must not be `None`")  # noqa: E501

        self._startup_after_restore = startup_after_restore

    @property
    def status(self):
        """Gets the status of this BackupRestoreExecution.  # noqa: E501


        :return: The status of this BackupRestoreExecution.  # noqa: E501
        :rtype: BackupExecutionStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BackupRestoreExecution.


        :param status: The status of this BackupRestoreExecution.  # noqa: E501
        :type status: BackupExecutionStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def total_bytes(self):
        """Gets the total_bytes of this BackupRestoreExecution.  # noqa: E501


        :return: The total_bytes of this BackupRestoreExecution.  # noqa: E501
        :rtype: int
        """
        return self._total_bytes

    @total_bytes.setter
    def total_bytes(self, total_bytes):
        """Sets the total_bytes of this BackupRestoreExecution.


        :param total_bytes: The total_bytes of this BackupRestoreExecution.  # noqa: E501
        :type total_bytes: int
        """

        self._total_bytes = total_bytes

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupRestoreExecution):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupRestoreExecution):
            return True

        return self.to_dict() != other.to_dict()
