# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupRestoreExecutionNetworkInformation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vpc_subnet_local_id': 'str',
        'vpc_local_id': 'str',
        'vlan_local_id': 'str',
        'type': 'VmNicType',
        'typename': 'str'
    }

    attribute_map = {
        'vpc_subnet_local_id': 'vpc_subnet_local_id',
        'vpc_local_id': 'vpc_local_id',
        'vlan_local_id': 'vlan_local_id',
        'type': 'type',
        'typename': '__typename'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupRestoreExecutionNetworkInformation - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vpc_subnet_local_id = None
        self._vpc_local_id = None
        self._vlan_local_id = None
        self._type = None
        self._typename = None
        self.discriminator = None

        self.vpc_subnet_local_id = kwargs.get("vpc_subnet_local_id", None)
        self.vpc_local_id = kwargs.get("vpc_local_id", None)
        self.vlan_local_id = kwargs.get("vlan_local_id", None)
        self.type = kwargs.get("type", None)
        if "typename" in kwargs:
            self.typename = kwargs["typename"]

    @property
    def vpc_subnet_local_id(self):
        """Gets the vpc_subnet_local_id of this BackupRestoreExecutionNetworkInformation.  # noqa: E501


        :return: The vpc_subnet_local_id of this BackupRestoreExecutionNetworkInformation.  # noqa: E501
        :rtype: str
        """
        return self._vpc_subnet_local_id

    @vpc_subnet_local_id.setter
    def vpc_subnet_local_id(self, vpc_subnet_local_id):
        """Sets the vpc_subnet_local_id of this BackupRestoreExecutionNetworkInformation.


        :param vpc_subnet_local_id: The vpc_subnet_local_id of this BackupRestoreExecutionNetworkInformation.  # noqa: E501
        :type vpc_subnet_local_id: str
        """

        self._vpc_subnet_local_id = vpc_subnet_local_id

    @property
    def vpc_local_id(self):
        """Gets the vpc_local_id of this BackupRestoreExecutionNetworkInformation.  # noqa: E501


        :return: The vpc_local_id of this BackupRestoreExecutionNetworkInformation.  # noqa: E501
        :rtype: str
        """
        return self._vpc_local_id

    @vpc_local_id.setter
    def vpc_local_id(self, vpc_local_id):
        """Sets the vpc_local_id of this BackupRestoreExecutionNetworkInformation.


        :param vpc_local_id: The vpc_local_id of this BackupRestoreExecutionNetworkInformation.  # noqa: E501
        :type vpc_local_id: str
        """

        self._vpc_local_id = vpc_local_id

    @property
    def vlan_local_id(self):
        """Gets the vlan_local_id of this BackupRestoreExecutionNetworkInformation.  # noqa: E501


        :return: The vlan_local_id of this BackupRestoreExecutionNetworkInformation.  # noqa: E501
        :rtype: str
        """
        return self._vlan_local_id

    @vlan_local_id.setter
    def vlan_local_id(self, vlan_local_id):
        """Sets the vlan_local_id of this BackupRestoreExecutionNetworkInformation.


        :param vlan_local_id: The vlan_local_id of this BackupRestoreExecutionNetworkInformation.  # noqa: E501
        :type vlan_local_id: str
        """

        self._vlan_local_id = vlan_local_id

    @property
    def type(self):
        """Gets the type of this BackupRestoreExecutionNetworkInformation.  # noqa: E501


        :return: The type of this BackupRestoreExecutionNetworkInformation.  # noqa: E501
        :rtype: VmNicType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BackupRestoreExecutionNetworkInformation.


        :param type: The type of this BackupRestoreExecutionNetworkInformation.  # noqa: E501
        :type type: VmNicType
        """

        self._type = type

    @property
    def typename(self):
        """Gets the typename of this BackupRestoreExecutionNetworkInformation.  # noqa: E501


        :return: The typename of this BackupRestoreExecutionNetworkInformation.  # noqa: E501
        :rtype: str
        """
        return self._typename

    @typename.setter
    def typename(self, typename):
        """Sets the typename of this BackupRestoreExecutionNetworkInformation.


        :param typename: The typename of this BackupRestoreExecutionNetworkInformation.  # noqa: E501
        :type typename: str
        """
        allowed_values = ["BackupRestoreExecutionNetworkInformation"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and typename not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `typename` ({0}), must be one of {1}"  # noqa: E501
                .format(typename, allowed_values)
            )

        self._typename = typename

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupRestoreExecutionNetworkInformation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupRestoreExecutionNetworkInformation):
            return True

        return self.to_dict() != other.to_dict()
