# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupRestorePointRebuildParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'rebuild_network_mapping': 'list[BackupRestoreExecutionNetworkMapping]',
        'rebuild_target_host_id': 'str',
        'rebuild_target_cluster_id': 'str',
        'rebuild_name': 'str',
        'startup_after_restore': 'bool'
    }

    attribute_map = {
        'rebuild_network_mapping': 'rebuild_network_mapping',
        'rebuild_target_host_id': 'rebuild_target_host_id',
        'rebuild_target_cluster_id': 'rebuild_target_cluster_id',
        'rebuild_name': 'rebuild_name',
        'startup_after_restore': 'startup_after_restore'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupRestorePointRebuildParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._rebuild_network_mapping = None
        self._rebuild_target_host_id = None
        self._rebuild_target_cluster_id = None
        self._rebuild_name = None
        self._startup_after_restore = None
        self.discriminator = None

        if "rebuild_network_mapping" in kwargs:
            self.rebuild_network_mapping = kwargs["rebuild_network_mapping"]
        if "rebuild_target_host_id" in kwargs:
            self.rebuild_target_host_id = kwargs["rebuild_target_host_id"]
        if "rebuild_target_cluster_id" in kwargs:
            self.rebuild_target_cluster_id = kwargs["rebuild_target_cluster_id"]
        if "rebuild_name" in kwargs:
            self.rebuild_name = kwargs["rebuild_name"]
        if "startup_after_restore" in kwargs:
            self.startup_after_restore = kwargs["startup_after_restore"]

    @property
    def rebuild_network_mapping(self):
        """Gets the rebuild_network_mapping of this BackupRestorePointRebuildParamsData.  # noqa: E501


        :return: The rebuild_network_mapping of this BackupRestorePointRebuildParamsData.  # noqa: E501
        :rtype: list[BackupRestoreExecutionNetworkMapping]
        """
        return self._rebuild_network_mapping

    @rebuild_network_mapping.setter
    def rebuild_network_mapping(self, rebuild_network_mapping):
        """Sets the rebuild_network_mapping of this BackupRestorePointRebuildParamsData.


        :param rebuild_network_mapping: The rebuild_network_mapping of this BackupRestorePointRebuildParamsData.  # noqa: E501
        :type rebuild_network_mapping: list[BackupRestoreExecutionNetworkMapping]
        """
        if self.local_vars_configuration.client_side_validation and rebuild_network_mapping is None:  # noqa: E501
            raise ValueError("Invalid value for `rebuild_network_mapping`, must not be `None`")  # noqa: E501

        self._rebuild_network_mapping = rebuild_network_mapping

    @property
    def rebuild_target_host_id(self):
        """Gets the rebuild_target_host_id of this BackupRestorePointRebuildParamsData.  # noqa: E501


        :return: The rebuild_target_host_id of this BackupRestorePointRebuildParamsData.  # noqa: E501
        :rtype: str
        """
        return self._rebuild_target_host_id

    @rebuild_target_host_id.setter
    def rebuild_target_host_id(self, rebuild_target_host_id):
        """Sets the rebuild_target_host_id of this BackupRestorePointRebuildParamsData.


        :param rebuild_target_host_id: The rebuild_target_host_id of this BackupRestorePointRebuildParamsData.  # noqa: E501
        :type rebuild_target_host_id: str
        """
        if self.local_vars_configuration.client_side_validation and rebuild_target_host_id is None:  # noqa: E501
            raise ValueError("Invalid value for `rebuild_target_host_id`, must not be `None`")  # noqa: E501

        self._rebuild_target_host_id = rebuild_target_host_id

    @property
    def rebuild_target_cluster_id(self):
        """Gets the rebuild_target_cluster_id of this BackupRestorePointRebuildParamsData.  # noqa: E501


        :return: The rebuild_target_cluster_id of this BackupRestorePointRebuildParamsData.  # noqa: E501
        :rtype: str
        """
        return self._rebuild_target_cluster_id

    @rebuild_target_cluster_id.setter
    def rebuild_target_cluster_id(self, rebuild_target_cluster_id):
        """Sets the rebuild_target_cluster_id of this BackupRestorePointRebuildParamsData.


        :param rebuild_target_cluster_id: The rebuild_target_cluster_id of this BackupRestorePointRebuildParamsData.  # noqa: E501
        :type rebuild_target_cluster_id: str
        """
        if self.local_vars_configuration.client_side_validation and rebuild_target_cluster_id is None:  # noqa: E501
            raise ValueError("Invalid value for `rebuild_target_cluster_id`, must not be `None`")  # noqa: E501

        self._rebuild_target_cluster_id = rebuild_target_cluster_id

    @property
    def rebuild_name(self):
        """Gets the rebuild_name of this BackupRestorePointRebuildParamsData.  # noqa: E501


        :return: The rebuild_name of this BackupRestorePointRebuildParamsData.  # noqa: E501
        :rtype: str
        """
        return self._rebuild_name

    @rebuild_name.setter
    def rebuild_name(self, rebuild_name):
        """Sets the rebuild_name of this BackupRestorePointRebuildParamsData.


        :param rebuild_name: The rebuild_name of this BackupRestorePointRebuildParamsData.  # noqa: E501
        :type rebuild_name: str
        """
        if self.local_vars_configuration.client_side_validation and rebuild_name is None:  # noqa: E501
            raise ValueError("Invalid value for `rebuild_name`, must not be `None`")  # noqa: E501

        self._rebuild_name = rebuild_name

    @property
    def startup_after_restore(self):
        """Gets the startup_after_restore of this BackupRestorePointRebuildParamsData.  # noqa: E501


        :return: The startup_after_restore of this BackupRestorePointRebuildParamsData.  # noqa: E501
        :rtype: bool
        """
        return self._startup_after_restore

    @startup_after_restore.setter
    def startup_after_restore(self, startup_after_restore):
        """Sets the startup_after_restore of this BackupRestorePointRebuildParamsData.


        :param startup_after_restore: The startup_after_restore of this BackupRestorePointRebuildParamsData.  # noqa: E501
        :type startup_after_restore: bool
        """
        if self.local_vars_configuration.client_side_validation and startup_after_restore is None:  # noqa: E501
            raise ValueError("Invalid value for `startup_after_restore`, must not be `None`")  # noqa: E501

        self._startup_after_restore = startup_after_restore

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupRestorePointRebuildParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupRestorePointRebuildParamsData):
            return True

        return self.to_dict() != other.to_dict()
