# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupRestorePointWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[BackupRestorePointWhereInput]',
        '_not': 'list[BackupRestorePointWhereInput]',
        '_or': 'list[BackupRestorePointWhereInput]',
        'backup_plan': 'BackupPlanWhereInput',
        'backup_restore_executions_every': 'BackupRestoreExecutionWhereInput',
        'backup_restore_executions_none': 'BackupRestoreExecutionWhereInput',
        'backup_restore_executions_some': 'BackupRestoreExecutionWhereInput',
        'backup_target_execution': 'BackupTargetExecutionWhereInput',
        'cluster_local_id': 'str',
        'cluster_local_id_contains': 'str',
        'cluster_local_id_ends_with': 'str',
        'cluster_local_id_gt': 'str',
        'cluster_local_id_gte': 'str',
        'cluster_local_id_in': 'list[str]',
        'cluster_local_id_lt': 'str',
        'cluster_local_id_lte': 'str',
        'cluster_local_id_not': 'str',
        'cluster_local_id_not_contains': 'str',
        'cluster_local_id_not_ends_with': 'str',
        'cluster_local_id_not_in': 'list[str]',
        'cluster_local_id_not_starts_with': 'str',
        'cluster_local_id_starts_with': 'str',
        'compressed': 'bool',
        'compressed_not': 'bool',
        'compression_ratio': 'float',
        'compression_ratio_gt': 'float',
        'compression_ratio_gte': 'float',
        'compression_ratio_in': 'list[float]',
        'compression_ratio_lt': 'float',
        'compression_ratio_lte': 'float',
        'compression_ratio_not': 'float',
        'compression_ratio_not_in': 'list[float]',
        'creation': 'BackupRestorePointCreation',
        'creation_in': 'list[BackupRestorePointCreation]',
        'creation_not': 'BackupRestorePointCreation',
        'creation_not_in': 'list[BackupRestorePointCreation]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'local_created_at': 'str',
        'local_created_at_gt': 'str',
        'local_created_at_gte': 'str',
        'local_created_at_in': 'list[str]',
        'local_created_at_lt': 'str',
        'local_created_at_lte': 'str',
        'local_created_at_not': 'str',
        'local_created_at_not_in': 'list[str]',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'logical_size': 'int',
        'logical_size_gt': 'int',
        'logical_size_gte': 'int',
        'logical_size_in': 'list[int]',
        'logical_size_lt': 'int',
        'logical_size_lte': 'int',
        'logical_size_not': 'int',
        'logical_size_not_in': 'list[int]',
        'parent_restore_point': 'str',
        'parent_restore_point_contains': 'str',
        'parent_restore_point_ends_with': 'str',
        'parent_restore_point_gt': 'str',
        'parent_restore_point_gte': 'str',
        'parent_restore_point_in': 'list[str]',
        'parent_restore_point_lt': 'str',
        'parent_restore_point_lte': 'str',
        'parent_restore_point_not': 'str',
        'parent_restore_point_not_contains': 'str',
        'parent_restore_point_not_ends_with': 'str',
        'parent_restore_point_not_in': 'list[str]',
        'parent_restore_point_not_starts_with': 'str',
        'parent_restore_point_starts_with': 'str',
        'physical_size': 'int',
        'physical_size_gt': 'int',
        'physical_size_gte': 'int',
        'physical_size_in': 'list[int]',
        'physical_size_lt': 'int',
        'physical_size_lte': 'int',
        'physical_size_not': 'int',
        'physical_size_not_in': 'list[int]',
        'size': 'int',
        'size_gt': 'int',
        'size_gte': 'int',
        'size_in': 'list[int]',
        'size_lt': 'int',
        'size_lte': 'int',
        'size_not': 'int',
        'size_not_in': 'list[int]',
        'slice': 'str',
        'slice_contains': 'str',
        'slice_ends_with': 'str',
        'slice_gt': 'str',
        'slice_gte': 'str',
        'slice_in': 'list[str]',
        'slice_lt': 'str',
        'slice_lte': 'str',
        'slice_not': 'str',
        'slice_not_contains': 'str',
        'slice_not_ends_with': 'str',
        'slice_not_in': 'list[str]',
        'slice_not_starts_with': 'str',
        'slice_starts_with': 'str',
        'snapshot_consistent_type': 'ConsistentType',
        'snapshot_consistent_type_in': 'list[ConsistentType]',
        'snapshot_consistent_type_not': 'ConsistentType',
        'snapshot_consistent_type_not_in': 'list[ConsistentType]',
        'type': 'BackupRestorePointType',
        'type_in': 'list[BackupRestorePointType]',
        'type_not': 'BackupRestorePointType',
        'type_not_in': 'list[BackupRestorePointType]',
        'valid_capacity': 'int',
        'valid_capacity_gt': 'int',
        'valid_capacity_gte': 'int',
        'valid_capacity_in': 'list[int]',
        'valid_capacity_lt': 'int',
        'valid_capacity_lte': 'int',
        'valid_capacity_not': 'int',
        'valid_capacity_not_in': 'list[int]',
        'valid_size': 'int',
        'valid_size_gt': 'int',
        'valid_size_gte': 'int',
        'valid_size_in': 'list[int]',
        'valid_size_lt': 'int',
        'valid_size_lte': 'int',
        'valid_size_not': 'int',
        'valid_size_not_in': 'list[int]',
        'vm': 'VmWhereInput',
        'vm_local_id': 'str',
        'vm_local_id_contains': 'str',
        'vm_local_id_ends_with': 'str',
        'vm_local_id_gt': 'str',
        'vm_local_id_gte': 'str',
        'vm_local_id_in': 'list[str]',
        'vm_local_id_lt': 'str',
        'vm_local_id_lte': 'str',
        'vm_local_id_not': 'str',
        'vm_local_id_not_contains': 'str',
        'vm_local_id_not_ends_with': 'str',
        'vm_local_id_not_in': 'list[str]',
        'vm_local_id_not_starts_with': 'str',
        'vm_local_id_starts_with': 'str',
        'vm_name': 'str',
        'vm_name_contains': 'str',
        'vm_name_ends_with': 'str',
        'vm_name_gt': 'str',
        'vm_name_gte': 'str',
        'vm_name_in': 'list[str]',
        'vm_name_lt': 'str',
        'vm_name_lte': 'str',
        'vm_name_not': 'str',
        'vm_name_not_contains': 'str',
        'vm_name_not_ends_with': 'str',
        'vm_name_not_in': 'list[str]',
        'vm_name_not_starts_with': 'str',
        'vm_name_starts_with': 'str'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'backup_plan': 'backup_plan',
        'backup_restore_executions_every': 'backup_restore_executions_every',
        'backup_restore_executions_none': 'backup_restore_executions_none',
        'backup_restore_executions_some': 'backup_restore_executions_some',
        'backup_target_execution': 'backup_target_execution',
        'cluster_local_id': 'cluster_local_id',
        'cluster_local_id_contains': 'cluster_local_id_contains',
        'cluster_local_id_ends_with': 'cluster_local_id_ends_with',
        'cluster_local_id_gt': 'cluster_local_id_gt',
        'cluster_local_id_gte': 'cluster_local_id_gte',
        'cluster_local_id_in': 'cluster_local_id_in',
        'cluster_local_id_lt': 'cluster_local_id_lt',
        'cluster_local_id_lte': 'cluster_local_id_lte',
        'cluster_local_id_not': 'cluster_local_id_not',
        'cluster_local_id_not_contains': 'cluster_local_id_not_contains',
        'cluster_local_id_not_ends_with': 'cluster_local_id_not_ends_with',
        'cluster_local_id_not_in': 'cluster_local_id_not_in',
        'cluster_local_id_not_starts_with': 'cluster_local_id_not_starts_with',
        'cluster_local_id_starts_with': 'cluster_local_id_starts_with',
        'compressed': 'compressed',
        'compressed_not': 'compressed_not',
        'compression_ratio': 'compression_ratio',
        'compression_ratio_gt': 'compression_ratio_gt',
        'compression_ratio_gte': 'compression_ratio_gte',
        'compression_ratio_in': 'compression_ratio_in',
        'compression_ratio_lt': 'compression_ratio_lt',
        'compression_ratio_lte': 'compression_ratio_lte',
        'compression_ratio_not': 'compression_ratio_not',
        'compression_ratio_not_in': 'compression_ratio_not_in',
        'creation': 'creation',
        'creation_in': 'creation_in',
        'creation_not': 'creation_not',
        'creation_not_in': 'creation_not_in',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'local_created_at': 'local_created_at',
        'local_created_at_gt': 'local_created_at_gt',
        'local_created_at_gte': 'local_created_at_gte',
        'local_created_at_in': 'local_created_at_in',
        'local_created_at_lt': 'local_created_at_lt',
        'local_created_at_lte': 'local_created_at_lte',
        'local_created_at_not': 'local_created_at_not',
        'local_created_at_not_in': 'local_created_at_not_in',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'logical_size': 'logical_size',
        'logical_size_gt': 'logical_size_gt',
        'logical_size_gte': 'logical_size_gte',
        'logical_size_in': 'logical_size_in',
        'logical_size_lt': 'logical_size_lt',
        'logical_size_lte': 'logical_size_lte',
        'logical_size_not': 'logical_size_not',
        'logical_size_not_in': 'logical_size_not_in',
        'parent_restore_point': 'parent_restore_point',
        'parent_restore_point_contains': 'parent_restore_point_contains',
        'parent_restore_point_ends_with': 'parent_restore_point_ends_with',
        'parent_restore_point_gt': 'parent_restore_point_gt',
        'parent_restore_point_gte': 'parent_restore_point_gte',
        'parent_restore_point_in': 'parent_restore_point_in',
        'parent_restore_point_lt': 'parent_restore_point_lt',
        'parent_restore_point_lte': 'parent_restore_point_lte',
        'parent_restore_point_not': 'parent_restore_point_not',
        'parent_restore_point_not_contains': 'parent_restore_point_not_contains',
        'parent_restore_point_not_ends_with': 'parent_restore_point_not_ends_with',
        'parent_restore_point_not_in': 'parent_restore_point_not_in',
        'parent_restore_point_not_starts_with': 'parent_restore_point_not_starts_with',
        'parent_restore_point_starts_with': 'parent_restore_point_starts_with',
        'physical_size': 'physical_size',
        'physical_size_gt': 'physical_size_gt',
        'physical_size_gte': 'physical_size_gte',
        'physical_size_in': 'physical_size_in',
        'physical_size_lt': 'physical_size_lt',
        'physical_size_lte': 'physical_size_lte',
        'physical_size_not': 'physical_size_not',
        'physical_size_not_in': 'physical_size_not_in',
        'size': 'size',
        'size_gt': 'size_gt',
        'size_gte': 'size_gte',
        'size_in': 'size_in',
        'size_lt': 'size_lt',
        'size_lte': 'size_lte',
        'size_not': 'size_not',
        'size_not_in': 'size_not_in',
        'slice': 'slice',
        'slice_contains': 'slice_contains',
        'slice_ends_with': 'slice_ends_with',
        'slice_gt': 'slice_gt',
        'slice_gte': 'slice_gte',
        'slice_in': 'slice_in',
        'slice_lt': 'slice_lt',
        'slice_lte': 'slice_lte',
        'slice_not': 'slice_not',
        'slice_not_contains': 'slice_not_contains',
        'slice_not_ends_with': 'slice_not_ends_with',
        'slice_not_in': 'slice_not_in',
        'slice_not_starts_with': 'slice_not_starts_with',
        'slice_starts_with': 'slice_starts_with',
        'snapshot_consistent_type': 'snapshot_consistent_type',
        'snapshot_consistent_type_in': 'snapshot_consistent_type_in',
        'snapshot_consistent_type_not': 'snapshot_consistent_type_not',
        'snapshot_consistent_type_not_in': 'snapshot_consistent_type_not_in',
        'type': 'type',
        'type_in': 'type_in',
        'type_not': 'type_not',
        'type_not_in': 'type_not_in',
        'valid_capacity': 'valid_capacity',
        'valid_capacity_gt': 'valid_capacity_gt',
        'valid_capacity_gte': 'valid_capacity_gte',
        'valid_capacity_in': 'valid_capacity_in',
        'valid_capacity_lt': 'valid_capacity_lt',
        'valid_capacity_lte': 'valid_capacity_lte',
        'valid_capacity_not': 'valid_capacity_not',
        'valid_capacity_not_in': 'valid_capacity_not_in',
        'valid_size': 'valid_size',
        'valid_size_gt': 'valid_size_gt',
        'valid_size_gte': 'valid_size_gte',
        'valid_size_in': 'valid_size_in',
        'valid_size_lt': 'valid_size_lt',
        'valid_size_lte': 'valid_size_lte',
        'valid_size_not': 'valid_size_not',
        'valid_size_not_in': 'valid_size_not_in',
        'vm': 'vm',
        'vm_local_id': 'vm_local_id',
        'vm_local_id_contains': 'vm_local_id_contains',
        'vm_local_id_ends_with': 'vm_local_id_ends_with',
        'vm_local_id_gt': 'vm_local_id_gt',
        'vm_local_id_gte': 'vm_local_id_gte',
        'vm_local_id_in': 'vm_local_id_in',
        'vm_local_id_lt': 'vm_local_id_lt',
        'vm_local_id_lte': 'vm_local_id_lte',
        'vm_local_id_not': 'vm_local_id_not',
        'vm_local_id_not_contains': 'vm_local_id_not_contains',
        'vm_local_id_not_ends_with': 'vm_local_id_not_ends_with',
        'vm_local_id_not_in': 'vm_local_id_not_in',
        'vm_local_id_not_starts_with': 'vm_local_id_not_starts_with',
        'vm_local_id_starts_with': 'vm_local_id_starts_with',
        'vm_name': 'vm_name',
        'vm_name_contains': 'vm_name_contains',
        'vm_name_ends_with': 'vm_name_ends_with',
        'vm_name_gt': 'vm_name_gt',
        'vm_name_gte': 'vm_name_gte',
        'vm_name_in': 'vm_name_in',
        'vm_name_lt': 'vm_name_lt',
        'vm_name_lte': 'vm_name_lte',
        'vm_name_not': 'vm_name_not',
        'vm_name_not_contains': 'vm_name_not_contains',
        'vm_name_not_ends_with': 'vm_name_not_ends_with',
        'vm_name_not_in': 'vm_name_not_in',
        'vm_name_not_starts_with': 'vm_name_not_starts_with',
        'vm_name_starts_with': 'vm_name_starts_with'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupRestorePointWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._backup_plan = None
        self._backup_restore_executions_every = None
        self._backup_restore_executions_none = None
        self._backup_restore_executions_some = None
        self._backup_target_execution = None
        self._cluster_local_id = None
        self._cluster_local_id_contains = None
        self._cluster_local_id_ends_with = None
        self._cluster_local_id_gt = None
        self._cluster_local_id_gte = None
        self._cluster_local_id_in = None
        self._cluster_local_id_lt = None
        self._cluster_local_id_lte = None
        self._cluster_local_id_not = None
        self._cluster_local_id_not_contains = None
        self._cluster_local_id_not_ends_with = None
        self._cluster_local_id_not_in = None
        self._cluster_local_id_not_starts_with = None
        self._cluster_local_id_starts_with = None
        self._compressed = None
        self._compressed_not = None
        self._compression_ratio = None
        self._compression_ratio_gt = None
        self._compression_ratio_gte = None
        self._compression_ratio_in = None
        self._compression_ratio_lt = None
        self._compression_ratio_lte = None
        self._compression_ratio_not = None
        self._compression_ratio_not_in = None
        self._creation = None
        self._creation_in = None
        self._creation_not = None
        self._creation_not_in = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._local_created_at = None
        self._local_created_at_gt = None
        self._local_created_at_gte = None
        self._local_created_at_in = None
        self._local_created_at_lt = None
        self._local_created_at_lte = None
        self._local_created_at_not = None
        self._local_created_at_not_in = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._logical_size = None
        self._logical_size_gt = None
        self._logical_size_gte = None
        self._logical_size_in = None
        self._logical_size_lt = None
        self._logical_size_lte = None
        self._logical_size_not = None
        self._logical_size_not_in = None
        self._parent_restore_point = None
        self._parent_restore_point_contains = None
        self._parent_restore_point_ends_with = None
        self._parent_restore_point_gt = None
        self._parent_restore_point_gte = None
        self._parent_restore_point_in = None
        self._parent_restore_point_lt = None
        self._parent_restore_point_lte = None
        self._parent_restore_point_not = None
        self._parent_restore_point_not_contains = None
        self._parent_restore_point_not_ends_with = None
        self._parent_restore_point_not_in = None
        self._parent_restore_point_not_starts_with = None
        self._parent_restore_point_starts_with = None
        self._physical_size = None
        self._physical_size_gt = None
        self._physical_size_gte = None
        self._physical_size_in = None
        self._physical_size_lt = None
        self._physical_size_lte = None
        self._physical_size_not = None
        self._physical_size_not_in = None
        self._size = None
        self._size_gt = None
        self._size_gte = None
        self._size_in = None
        self._size_lt = None
        self._size_lte = None
        self._size_not = None
        self._size_not_in = None
        self._slice = None
        self._slice_contains = None
        self._slice_ends_with = None
        self._slice_gt = None
        self._slice_gte = None
        self._slice_in = None
        self._slice_lt = None
        self._slice_lte = None
        self._slice_not = None
        self._slice_not_contains = None
        self._slice_not_ends_with = None
        self._slice_not_in = None
        self._slice_not_starts_with = None
        self._slice_starts_with = None
        self._snapshot_consistent_type = None
        self._snapshot_consistent_type_in = None
        self._snapshot_consistent_type_not = None
        self._snapshot_consistent_type_not_in = None
        self._type = None
        self._type_in = None
        self._type_not = None
        self._type_not_in = None
        self._valid_capacity = None
        self._valid_capacity_gt = None
        self._valid_capacity_gte = None
        self._valid_capacity_in = None
        self._valid_capacity_lt = None
        self._valid_capacity_lte = None
        self._valid_capacity_not = None
        self._valid_capacity_not_in = None
        self._valid_size = None
        self._valid_size_gt = None
        self._valid_size_gte = None
        self._valid_size_in = None
        self._valid_size_lt = None
        self._valid_size_lte = None
        self._valid_size_not = None
        self._valid_size_not_in = None
        self._vm = None
        self._vm_local_id = None
        self._vm_local_id_contains = None
        self._vm_local_id_ends_with = None
        self._vm_local_id_gt = None
        self._vm_local_id_gte = None
        self._vm_local_id_in = None
        self._vm_local_id_lt = None
        self._vm_local_id_lte = None
        self._vm_local_id_not = None
        self._vm_local_id_not_contains = None
        self._vm_local_id_not_ends_with = None
        self._vm_local_id_not_in = None
        self._vm_local_id_not_starts_with = None
        self._vm_local_id_starts_with = None
        self._vm_name = None
        self._vm_name_contains = None
        self._vm_name_ends_with = None
        self._vm_name_gt = None
        self._vm_name_gte = None
        self._vm_name_in = None
        self._vm_name_lt = None
        self._vm_name_lte = None
        self._vm_name_not = None
        self._vm_name_not_contains = None
        self._vm_name_not_ends_with = None
        self._vm_name_not_in = None
        self._vm_name_not_starts_with = None
        self._vm_name_starts_with = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.backup_plan = kwargs.get("backup_plan", None)
        self.backup_restore_executions_every = kwargs.get("backup_restore_executions_every", None)
        self.backup_restore_executions_none = kwargs.get("backup_restore_executions_none", None)
        self.backup_restore_executions_some = kwargs.get("backup_restore_executions_some", None)
        self.backup_target_execution = kwargs.get("backup_target_execution", None)
        self.cluster_local_id = kwargs.get("cluster_local_id", None)
        self.cluster_local_id_contains = kwargs.get("cluster_local_id_contains", None)
        self.cluster_local_id_ends_with = kwargs.get("cluster_local_id_ends_with", None)
        self.cluster_local_id_gt = kwargs.get("cluster_local_id_gt", None)
        self.cluster_local_id_gte = kwargs.get("cluster_local_id_gte", None)
        self.cluster_local_id_in = kwargs.get("cluster_local_id_in", None)
        self.cluster_local_id_lt = kwargs.get("cluster_local_id_lt", None)
        self.cluster_local_id_lte = kwargs.get("cluster_local_id_lte", None)
        self.cluster_local_id_not = kwargs.get("cluster_local_id_not", None)
        self.cluster_local_id_not_contains = kwargs.get("cluster_local_id_not_contains", None)
        self.cluster_local_id_not_ends_with = kwargs.get("cluster_local_id_not_ends_with", None)
        self.cluster_local_id_not_in = kwargs.get("cluster_local_id_not_in", None)
        self.cluster_local_id_not_starts_with = kwargs.get("cluster_local_id_not_starts_with", None)
        self.cluster_local_id_starts_with = kwargs.get("cluster_local_id_starts_with", None)
        self.compressed = kwargs.get("compressed", None)
        self.compressed_not = kwargs.get("compressed_not", None)
        self.compression_ratio = kwargs.get("compression_ratio", None)
        self.compression_ratio_gt = kwargs.get("compression_ratio_gt", None)
        self.compression_ratio_gte = kwargs.get("compression_ratio_gte", None)
        self.compression_ratio_in = kwargs.get("compression_ratio_in", None)
        self.compression_ratio_lt = kwargs.get("compression_ratio_lt", None)
        self.compression_ratio_lte = kwargs.get("compression_ratio_lte", None)
        self.compression_ratio_not = kwargs.get("compression_ratio_not", None)
        self.compression_ratio_not_in = kwargs.get("compression_ratio_not_in", None)
        self.creation = kwargs.get("creation", None)
        self.creation_in = kwargs.get("creation_in", None)
        self.creation_not = kwargs.get("creation_not", None)
        self.creation_not_in = kwargs.get("creation_not_in", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.local_created_at = kwargs.get("local_created_at", None)
        self.local_created_at_gt = kwargs.get("local_created_at_gt", None)
        self.local_created_at_gte = kwargs.get("local_created_at_gte", None)
        self.local_created_at_in = kwargs.get("local_created_at_in", None)
        self.local_created_at_lt = kwargs.get("local_created_at_lt", None)
        self.local_created_at_lte = kwargs.get("local_created_at_lte", None)
        self.local_created_at_not = kwargs.get("local_created_at_not", None)
        self.local_created_at_not_in = kwargs.get("local_created_at_not_in", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.logical_size = kwargs.get("logical_size", None)
        self.logical_size_gt = kwargs.get("logical_size_gt", None)
        self.logical_size_gte = kwargs.get("logical_size_gte", None)
        self.logical_size_in = kwargs.get("logical_size_in", None)
        self.logical_size_lt = kwargs.get("logical_size_lt", None)
        self.logical_size_lte = kwargs.get("logical_size_lte", None)
        self.logical_size_not = kwargs.get("logical_size_not", None)
        self.logical_size_not_in = kwargs.get("logical_size_not_in", None)
        self.parent_restore_point = kwargs.get("parent_restore_point", None)
        self.parent_restore_point_contains = kwargs.get("parent_restore_point_contains", None)
        self.parent_restore_point_ends_with = kwargs.get("parent_restore_point_ends_with", None)
        self.parent_restore_point_gt = kwargs.get("parent_restore_point_gt", None)
        self.parent_restore_point_gte = kwargs.get("parent_restore_point_gte", None)
        self.parent_restore_point_in = kwargs.get("parent_restore_point_in", None)
        self.parent_restore_point_lt = kwargs.get("parent_restore_point_lt", None)
        self.parent_restore_point_lte = kwargs.get("parent_restore_point_lte", None)
        self.parent_restore_point_not = kwargs.get("parent_restore_point_not", None)
        self.parent_restore_point_not_contains = kwargs.get("parent_restore_point_not_contains", None)
        self.parent_restore_point_not_ends_with = kwargs.get("parent_restore_point_not_ends_with", None)
        self.parent_restore_point_not_in = kwargs.get("parent_restore_point_not_in", None)
        self.parent_restore_point_not_starts_with = kwargs.get("parent_restore_point_not_starts_with", None)
        self.parent_restore_point_starts_with = kwargs.get("parent_restore_point_starts_with", None)
        self.physical_size = kwargs.get("physical_size", None)
        self.physical_size_gt = kwargs.get("physical_size_gt", None)
        self.physical_size_gte = kwargs.get("physical_size_gte", None)
        self.physical_size_in = kwargs.get("physical_size_in", None)
        self.physical_size_lt = kwargs.get("physical_size_lt", None)
        self.physical_size_lte = kwargs.get("physical_size_lte", None)
        self.physical_size_not = kwargs.get("physical_size_not", None)
        self.physical_size_not_in = kwargs.get("physical_size_not_in", None)
        self.size = kwargs.get("size", None)
        self.size_gt = kwargs.get("size_gt", None)
        self.size_gte = kwargs.get("size_gte", None)
        self.size_in = kwargs.get("size_in", None)
        self.size_lt = kwargs.get("size_lt", None)
        self.size_lte = kwargs.get("size_lte", None)
        self.size_not = kwargs.get("size_not", None)
        self.size_not_in = kwargs.get("size_not_in", None)
        self.slice = kwargs.get("slice", None)
        self.slice_contains = kwargs.get("slice_contains", None)
        self.slice_ends_with = kwargs.get("slice_ends_with", None)
        self.slice_gt = kwargs.get("slice_gt", None)
        self.slice_gte = kwargs.get("slice_gte", None)
        self.slice_in = kwargs.get("slice_in", None)
        self.slice_lt = kwargs.get("slice_lt", None)
        self.slice_lte = kwargs.get("slice_lte", None)
        self.slice_not = kwargs.get("slice_not", None)
        self.slice_not_contains = kwargs.get("slice_not_contains", None)
        self.slice_not_ends_with = kwargs.get("slice_not_ends_with", None)
        self.slice_not_in = kwargs.get("slice_not_in", None)
        self.slice_not_starts_with = kwargs.get("slice_not_starts_with", None)
        self.slice_starts_with = kwargs.get("slice_starts_with", None)
        self.snapshot_consistent_type = kwargs.get("snapshot_consistent_type", None)
        self.snapshot_consistent_type_in = kwargs.get("snapshot_consistent_type_in", None)
        self.snapshot_consistent_type_not = kwargs.get("snapshot_consistent_type_not", None)
        self.snapshot_consistent_type_not_in = kwargs.get("snapshot_consistent_type_not_in", None)
        self.type = kwargs.get("type", None)
        self.type_in = kwargs.get("type_in", None)
        self.type_not = kwargs.get("type_not", None)
        self.type_not_in = kwargs.get("type_not_in", None)
        self.valid_capacity = kwargs.get("valid_capacity", None)
        self.valid_capacity_gt = kwargs.get("valid_capacity_gt", None)
        self.valid_capacity_gte = kwargs.get("valid_capacity_gte", None)
        self.valid_capacity_in = kwargs.get("valid_capacity_in", None)
        self.valid_capacity_lt = kwargs.get("valid_capacity_lt", None)
        self.valid_capacity_lte = kwargs.get("valid_capacity_lte", None)
        self.valid_capacity_not = kwargs.get("valid_capacity_not", None)
        self.valid_capacity_not_in = kwargs.get("valid_capacity_not_in", None)
        self.valid_size = kwargs.get("valid_size", None)
        self.valid_size_gt = kwargs.get("valid_size_gt", None)
        self.valid_size_gte = kwargs.get("valid_size_gte", None)
        self.valid_size_in = kwargs.get("valid_size_in", None)
        self.valid_size_lt = kwargs.get("valid_size_lt", None)
        self.valid_size_lte = kwargs.get("valid_size_lte", None)
        self.valid_size_not = kwargs.get("valid_size_not", None)
        self.valid_size_not_in = kwargs.get("valid_size_not_in", None)
        self.vm = kwargs.get("vm", None)
        self.vm_local_id = kwargs.get("vm_local_id", None)
        self.vm_local_id_contains = kwargs.get("vm_local_id_contains", None)
        self.vm_local_id_ends_with = kwargs.get("vm_local_id_ends_with", None)
        self.vm_local_id_gt = kwargs.get("vm_local_id_gt", None)
        self.vm_local_id_gte = kwargs.get("vm_local_id_gte", None)
        self.vm_local_id_in = kwargs.get("vm_local_id_in", None)
        self.vm_local_id_lt = kwargs.get("vm_local_id_lt", None)
        self.vm_local_id_lte = kwargs.get("vm_local_id_lte", None)
        self.vm_local_id_not = kwargs.get("vm_local_id_not", None)
        self.vm_local_id_not_contains = kwargs.get("vm_local_id_not_contains", None)
        self.vm_local_id_not_ends_with = kwargs.get("vm_local_id_not_ends_with", None)
        self.vm_local_id_not_in = kwargs.get("vm_local_id_not_in", None)
        self.vm_local_id_not_starts_with = kwargs.get("vm_local_id_not_starts_with", None)
        self.vm_local_id_starts_with = kwargs.get("vm_local_id_starts_with", None)
        self.vm_name = kwargs.get("vm_name", None)
        self.vm_name_contains = kwargs.get("vm_name_contains", None)
        self.vm_name_ends_with = kwargs.get("vm_name_ends_with", None)
        self.vm_name_gt = kwargs.get("vm_name_gt", None)
        self.vm_name_gte = kwargs.get("vm_name_gte", None)
        self.vm_name_in = kwargs.get("vm_name_in", None)
        self.vm_name_lt = kwargs.get("vm_name_lt", None)
        self.vm_name_lte = kwargs.get("vm_name_lte", None)
        self.vm_name_not = kwargs.get("vm_name_not", None)
        self.vm_name_not_contains = kwargs.get("vm_name_not_contains", None)
        self.vm_name_not_ends_with = kwargs.get("vm_name_not_ends_with", None)
        self.vm_name_not_in = kwargs.get("vm_name_not_in", None)
        self.vm_name_not_starts_with = kwargs.get("vm_name_not_starts_with", None)
        self.vm_name_starts_with = kwargs.get("vm_name_starts_with", None)

    @property
    def _and(self):
        """Gets the _and of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The _and of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupRestorePointWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this BackupRestorePointWhereInput.


        :param _and: The _and of this BackupRestorePointWhereInput.  # noqa: E501
        :type _and: list[BackupRestorePointWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The _not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupRestorePointWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this BackupRestorePointWhereInput.


        :param _not: The _not of this BackupRestorePointWhereInput.  # noqa: E501
        :type _not: list[BackupRestorePointWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The _or of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupRestorePointWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this BackupRestorePointWhereInput.


        :param _or: The _or of this BackupRestorePointWhereInput.  # noqa: E501
        :type _or: list[BackupRestorePointWhereInput]
        """

        self.__or = _or

    @property
    def backup_plan(self):
        """Gets the backup_plan of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The backup_plan of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: BackupPlanWhereInput
        """
        return self._backup_plan

    @backup_plan.setter
    def backup_plan(self, backup_plan):
        """Sets the backup_plan of this BackupRestorePointWhereInput.


        :param backup_plan: The backup_plan of this BackupRestorePointWhereInput.  # noqa: E501
        :type backup_plan: BackupPlanWhereInput
        """

        self._backup_plan = backup_plan

    @property
    def backup_restore_executions_every(self):
        """Gets the backup_restore_executions_every of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The backup_restore_executions_every of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: BackupRestoreExecutionWhereInput
        """
        return self._backup_restore_executions_every

    @backup_restore_executions_every.setter
    def backup_restore_executions_every(self, backup_restore_executions_every):
        """Sets the backup_restore_executions_every of this BackupRestorePointWhereInput.


        :param backup_restore_executions_every: The backup_restore_executions_every of this BackupRestorePointWhereInput.  # noqa: E501
        :type backup_restore_executions_every: BackupRestoreExecutionWhereInput
        """

        self._backup_restore_executions_every = backup_restore_executions_every

    @property
    def backup_restore_executions_none(self):
        """Gets the backup_restore_executions_none of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The backup_restore_executions_none of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: BackupRestoreExecutionWhereInput
        """
        return self._backup_restore_executions_none

    @backup_restore_executions_none.setter
    def backup_restore_executions_none(self, backup_restore_executions_none):
        """Sets the backup_restore_executions_none of this BackupRestorePointWhereInput.


        :param backup_restore_executions_none: The backup_restore_executions_none of this BackupRestorePointWhereInput.  # noqa: E501
        :type backup_restore_executions_none: BackupRestoreExecutionWhereInput
        """

        self._backup_restore_executions_none = backup_restore_executions_none

    @property
    def backup_restore_executions_some(self):
        """Gets the backup_restore_executions_some of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The backup_restore_executions_some of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: BackupRestoreExecutionWhereInput
        """
        return self._backup_restore_executions_some

    @backup_restore_executions_some.setter
    def backup_restore_executions_some(self, backup_restore_executions_some):
        """Sets the backup_restore_executions_some of this BackupRestorePointWhereInput.


        :param backup_restore_executions_some: The backup_restore_executions_some of this BackupRestorePointWhereInput.  # noqa: E501
        :type backup_restore_executions_some: BackupRestoreExecutionWhereInput
        """

        self._backup_restore_executions_some = backup_restore_executions_some

    @property
    def backup_target_execution(self):
        """Gets the backup_target_execution of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The backup_target_execution of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: BackupTargetExecutionWhereInput
        """
        return self._backup_target_execution

    @backup_target_execution.setter
    def backup_target_execution(self, backup_target_execution):
        """Sets the backup_target_execution of this BackupRestorePointWhereInput.


        :param backup_target_execution: The backup_target_execution of this BackupRestorePointWhereInput.  # noqa: E501
        :type backup_target_execution: BackupTargetExecutionWhereInput
        """

        self._backup_target_execution = backup_target_execution

    @property
    def cluster_local_id(self):
        """Gets the cluster_local_id of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id

    @cluster_local_id.setter
    def cluster_local_id(self, cluster_local_id):
        """Sets the cluster_local_id of this BackupRestorePointWhereInput.


        :param cluster_local_id: The cluster_local_id of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id: str
        """

        self._cluster_local_id = cluster_local_id

    @property
    def cluster_local_id_contains(self):
        """Gets the cluster_local_id_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_contains

    @cluster_local_id_contains.setter
    def cluster_local_id_contains(self, cluster_local_id_contains):
        """Sets the cluster_local_id_contains of this BackupRestorePointWhereInput.


        :param cluster_local_id_contains: The cluster_local_id_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_contains: str
        """

        self._cluster_local_id_contains = cluster_local_id_contains

    @property
    def cluster_local_id_ends_with(self):
        """Gets the cluster_local_id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_ends_with

    @cluster_local_id_ends_with.setter
    def cluster_local_id_ends_with(self, cluster_local_id_ends_with):
        """Sets the cluster_local_id_ends_with of this BackupRestorePointWhereInput.


        :param cluster_local_id_ends_with: The cluster_local_id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_ends_with: str
        """

        self._cluster_local_id_ends_with = cluster_local_id_ends_with

    @property
    def cluster_local_id_gt(self):
        """Gets the cluster_local_id_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_gt

    @cluster_local_id_gt.setter
    def cluster_local_id_gt(self, cluster_local_id_gt):
        """Sets the cluster_local_id_gt of this BackupRestorePointWhereInput.


        :param cluster_local_id_gt: The cluster_local_id_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_gt: str
        """

        self._cluster_local_id_gt = cluster_local_id_gt

    @property
    def cluster_local_id_gte(self):
        """Gets the cluster_local_id_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_gte

    @cluster_local_id_gte.setter
    def cluster_local_id_gte(self, cluster_local_id_gte):
        """Sets the cluster_local_id_gte of this BackupRestorePointWhereInput.


        :param cluster_local_id_gte: The cluster_local_id_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_gte: str
        """

        self._cluster_local_id_gte = cluster_local_id_gte

    @property
    def cluster_local_id_in(self):
        """Gets the cluster_local_id_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cluster_local_id_in

    @cluster_local_id_in.setter
    def cluster_local_id_in(self, cluster_local_id_in):
        """Sets the cluster_local_id_in of this BackupRestorePointWhereInput.


        :param cluster_local_id_in: The cluster_local_id_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_in: list[str]
        """

        self._cluster_local_id_in = cluster_local_id_in

    @property
    def cluster_local_id_lt(self):
        """Gets the cluster_local_id_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_lt

    @cluster_local_id_lt.setter
    def cluster_local_id_lt(self, cluster_local_id_lt):
        """Sets the cluster_local_id_lt of this BackupRestorePointWhereInput.


        :param cluster_local_id_lt: The cluster_local_id_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_lt: str
        """

        self._cluster_local_id_lt = cluster_local_id_lt

    @property
    def cluster_local_id_lte(self):
        """Gets the cluster_local_id_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_lte

    @cluster_local_id_lte.setter
    def cluster_local_id_lte(self, cluster_local_id_lte):
        """Sets the cluster_local_id_lte of this BackupRestorePointWhereInput.


        :param cluster_local_id_lte: The cluster_local_id_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_lte: str
        """

        self._cluster_local_id_lte = cluster_local_id_lte

    @property
    def cluster_local_id_not(self):
        """Gets the cluster_local_id_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not

    @cluster_local_id_not.setter
    def cluster_local_id_not(self, cluster_local_id_not):
        """Sets the cluster_local_id_not of this BackupRestorePointWhereInput.


        :param cluster_local_id_not: The cluster_local_id_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_not: str
        """

        self._cluster_local_id_not = cluster_local_id_not

    @property
    def cluster_local_id_not_contains(self):
        """Gets the cluster_local_id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not_contains

    @cluster_local_id_not_contains.setter
    def cluster_local_id_not_contains(self, cluster_local_id_not_contains):
        """Sets the cluster_local_id_not_contains of this BackupRestorePointWhereInput.


        :param cluster_local_id_not_contains: The cluster_local_id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_not_contains: str
        """

        self._cluster_local_id_not_contains = cluster_local_id_not_contains

    @property
    def cluster_local_id_not_ends_with(self):
        """Gets the cluster_local_id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not_ends_with

    @cluster_local_id_not_ends_with.setter
    def cluster_local_id_not_ends_with(self, cluster_local_id_not_ends_with):
        """Sets the cluster_local_id_not_ends_with of this BackupRestorePointWhereInput.


        :param cluster_local_id_not_ends_with: The cluster_local_id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_not_ends_with: str
        """

        self._cluster_local_id_not_ends_with = cluster_local_id_not_ends_with

    @property
    def cluster_local_id_not_in(self):
        """Gets the cluster_local_id_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cluster_local_id_not_in

    @cluster_local_id_not_in.setter
    def cluster_local_id_not_in(self, cluster_local_id_not_in):
        """Sets the cluster_local_id_not_in of this BackupRestorePointWhereInput.


        :param cluster_local_id_not_in: The cluster_local_id_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_not_in: list[str]
        """

        self._cluster_local_id_not_in = cluster_local_id_not_in

    @property
    def cluster_local_id_not_starts_with(self):
        """Gets the cluster_local_id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not_starts_with

    @cluster_local_id_not_starts_with.setter
    def cluster_local_id_not_starts_with(self, cluster_local_id_not_starts_with):
        """Sets the cluster_local_id_not_starts_with of this BackupRestorePointWhereInput.


        :param cluster_local_id_not_starts_with: The cluster_local_id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_not_starts_with: str
        """

        self._cluster_local_id_not_starts_with = cluster_local_id_not_starts_with

    @property
    def cluster_local_id_starts_with(self):
        """Gets the cluster_local_id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The cluster_local_id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_starts_with

    @cluster_local_id_starts_with.setter
    def cluster_local_id_starts_with(self, cluster_local_id_starts_with):
        """Sets the cluster_local_id_starts_with of this BackupRestorePointWhereInput.


        :param cluster_local_id_starts_with: The cluster_local_id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type cluster_local_id_starts_with: str
        """

        self._cluster_local_id_starts_with = cluster_local_id_starts_with

    @property
    def compressed(self):
        """Gets the compressed of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The compressed of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._compressed

    @compressed.setter
    def compressed(self, compressed):
        """Sets the compressed of this BackupRestorePointWhereInput.


        :param compressed: The compressed of this BackupRestorePointWhereInput.  # noqa: E501
        :type compressed: bool
        """

        self._compressed = compressed

    @property
    def compressed_not(self):
        """Gets the compressed_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The compressed_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._compressed_not

    @compressed_not.setter
    def compressed_not(self, compressed_not):
        """Sets the compressed_not of this BackupRestorePointWhereInput.


        :param compressed_not: The compressed_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type compressed_not: bool
        """

        self._compressed_not = compressed_not

    @property
    def compression_ratio(self):
        """Gets the compression_ratio of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The compression_ratio of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio

    @compression_ratio.setter
    def compression_ratio(self, compression_ratio):
        """Sets the compression_ratio of this BackupRestorePointWhereInput.


        :param compression_ratio: The compression_ratio of this BackupRestorePointWhereInput.  # noqa: E501
        :type compression_ratio: float
        """

        self._compression_ratio = compression_ratio

    @property
    def compression_ratio_gt(self):
        """Gets the compression_ratio_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The compression_ratio_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio_gt

    @compression_ratio_gt.setter
    def compression_ratio_gt(self, compression_ratio_gt):
        """Sets the compression_ratio_gt of this BackupRestorePointWhereInput.


        :param compression_ratio_gt: The compression_ratio_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type compression_ratio_gt: float
        """

        self._compression_ratio_gt = compression_ratio_gt

    @property
    def compression_ratio_gte(self):
        """Gets the compression_ratio_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The compression_ratio_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio_gte

    @compression_ratio_gte.setter
    def compression_ratio_gte(self, compression_ratio_gte):
        """Sets the compression_ratio_gte of this BackupRestorePointWhereInput.


        :param compression_ratio_gte: The compression_ratio_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type compression_ratio_gte: float
        """

        self._compression_ratio_gte = compression_ratio_gte

    @property
    def compression_ratio_in(self):
        """Gets the compression_ratio_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The compression_ratio_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._compression_ratio_in

    @compression_ratio_in.setter
    def compression_ratio_in(self, compression_ratio_in):
        """Sets the compression_ratio_in of this BackupRestorePointWhereInput.


        :param compression_ratio_in: The compression_ratio_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type compression_ratio_in: list[float]
        """

        self._compression_ratio_in = compression_ratio_in

    @property
    def compression_ratio_lt(self):
        """Gets the compression_ratio_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The compression_ratio_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio_lt

    @compression_ratio_lt.setter
    def compression_ratio_lt(self, compression_ratio_lt):
        """Sets the compression_ratio_lt of this BackupRestorePointWhereInput.


        :param compression_ratio_lt: The compression_ratio_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type compression_ratio_lt: float
        """

        self._compression_ratio_lt = compression_ratio_lt

    @property
    def compression_ratio_lte(self):
        """Gets the compression_ratio_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The compression_ratio_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio_lte

    @compression_ratio_lte.setter
    def compression_ratio_lte(self, compression_ratio_lte):
        """Sets the compression_ratio_lte of this BackupRestorePointWhereInput.


        :param compression_ratio_lte: The compression_ratio_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type compression_ratio_lte: float
        """

        self._compression_ratio_lte = compression_ratio_lte

    @property
    def compression_ratio_not(self):
        """Gets the compression_ratio_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The compression_ratio_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._compression_ratio_not

    @compression_ratio_not.setter
    def compression_ratio_not(self, compression_ratio_not):
        """Sets the compression_ratio_not of this BackupRestorePointWhereInput.


        :param compression_ratio_not: The compression_ratio_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type compression_ratio_not: float
        """

        self._compression_ratio_not = compression_ratio_not

    @property
    def compression_ratio_not_in(self):
        """Gets the compression_ratio_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The compression_ratio_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._compression_ratio_not_in

    @compression_ratio_not_in.setter
    def compression_ratio_not_in(self, compression_ratio_not_in):
        """Sets the compression_ratio_not_in of this BackupRestorePointWhereInput.


        :param compression_ratio_not_in: The compression_ratio_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type compression_ratio_not_in: list[float]
        """

        self._compression_ratio_not_in = compression_ratio_not_in

    @property
    def creation(self):
        """Gets the creation of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The creation of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: BackupRestorePointCreation
        """
        return self._creation

    @creation.setter
    def creation(self, creation):
        """Sets the creation of this BackupRestorePointWhereInput.


        :param creation: The creation of this BackupRestorePointWhereInput.  # noqa: E501
        :type creation: BackupRestorePointCreation
        """

        self._creation = creation

    @property
    def creation_in(self):
        """Gets the creation_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The creation_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupRestorePointCreation]
        """
        return self._creation_in

    @creation_in.setter
    def creation_in(self, creation_in):
        """Sets the creation_in of this BackupRestorePointWhereInput.


        :param creation_in: The creation_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type creation_in: list[BackupRestorePointCreation]
        """

        self._creation_in = creation_in

    @property
    def creation_not(self):
        """Gets the creation_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The creation_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: BackupRestorePointCreation
        """
        return self._creation_not

    @creation_not.setter
    def creation_not(self, creation_not):
        """Sets the creation_not of this BackupRestorePointWhereInput.


        :param creation_not: The creation_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type creation_not: BackupRestorePointCreation
        """

        self._creation_not = creation_not

    @property
    def creation_not_in(self):
        """Gets the creation_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The creation_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupRestorePointCreation]
        """
        return self._creation_not_in

    @creation_not_in.setter
    def creation_not_in(self, creation_not_in):
        """Sets the creation_not_in of this BackupRestorePointWhereInput.


        :param creation_not_in: The creation_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type creation_not_in: list[BackupRestorePointCreation]
        """

        self._creation_not_in = creation_not_in

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The entity_async_status of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this BackupRestorePointWhereInput.


        :param entity_async_status: The entity_async_status of this BackupRestorePointWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this BackupRestorePointWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this BackupRestorePointWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this BackupRestorePointWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def id(self):
        """Gets the id of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BackupRestorePointWhereInput.


        :param id: The id of this BackupRestorePointWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this BackupRestorePointWhereInput.


        :param id_contains: The id_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this BackupRestorePointWhereInput.


        :param id_ends_with: The id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this BackupRestorePointWhereInput.


        :param id_gt: The id_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this BackupRestorePointWhereInput.


        :param id_gte: The id_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this BackupRestorePointWhereInput.


        :param id_in: The id_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this BackupRestorePointWhereInput.


        :param id_lt: The id_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this BackupRestorePointWhereInput.


        :param id_lte: The id_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this BackupRestorePointWhereInput.


        :param id_not: The id_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this BackupRestorePointWhereInput.


        :param id_not_contains: The id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this BackupRestorePointWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this BackupRestorePointWhereInput.


        :param id_not_in: The id_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this BackupRestorePointWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this BackupRestorePointWhereInput.


        :param id_starts_with: The id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def local_created_at(self):
        """Gets the local_created_at of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this BackupRestorePointWhereInput.


        :param local_created_at: The local_created_at of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_created_at: str
        """

        self._local_created_at = local_created_at

    @property
    def local_created_at_gt(self):
        """Gets the local_created_at_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gt

    @local_created_at_gt.setter
    def local_created_at_gt(self, local_created_at_gt):
        """Sets the local_created_at_gt of this BackupRestorePointWhereInput.


        :param local_created_at_gt: The local_created_at_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_created_at_gt: str
        """

        self._local_created_at_gt = local_created_at_gt

    @property
    def local_created_at_gte(self):
        """Gets the local_created_at_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_gte

    @local_created_at_gte.setter
    def local_created_at_gte(self, local_created_at_gte):
        """Sets the local_created_at_gte of this BackupRestorePointWhereInput.


        :param local_created_at_gte: The local_created_at_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_created_at_gte: str
        """

        self._local_created_at_gte = local_created_at_gte

    @property
    def local_created_at_in(self):
        """Gets the local_created_at_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_in

    @local_created_at_in.setter
    def local_created_at_in(self, local_created_at_in):
        """Sets the local_created_at_in of this BackupRestorePointWhereInput.


        :param local_created_at_in: The local_created_at_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_created_at_in: list[str]
        """

        self._local_created_at_in = local_created_at_in

    @property
    def local_created_at_lt(self):
        """Gets the local_created_at_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lt

    @local_created_at_lt.setter
    def local_created_at_lt(self, local_created_at_lt):
        """Sets the local_created_at_lt of this BackupRestorePointWhereInput.


        :param local_created_at_lt: The local_created_at_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_created_at_lt: str
        """

        self._local_created_at_lt = local_created_at_lt

    @property
    def local_created_at_lte(self):
        """Gets the local_created_at_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_lte

    @local_created_at_lte.setter
    def local_created_at_lte(self, local_created_at_lte):
        """Sets the local_created_at_lte of this BackupRestorePointWhereInput.


        :param local_created_at_lte: The local_created_at_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_created_at_lte: str
        """

        self._local_created_at_lte = local_created_at_lte

    @property
    def local_created_at_not(self):
        """Gets the local_created_at_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at_not

    @local_created_at_not.setter
    def local_created_at_not(self, local_created_at_not):
        """Sets the local_created_at_not of this BackupRestorePointWhereInput.


        :param local_created_at_not: The local_created_at_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_created_at_not: str
        """

        self._local_created_at_not = local_created_at_not

    @property
    def local_created_at_not_in(self):
        """Gets the local_created_at_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_created_at_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_created_at_not_in

    @local_created_at_not_in.setter
    def local_created_at_not_in(self, local_created_at_not_in):
        """Sets the local_created_at_not_in of this BackupRestorePointWhereInput.


        :param local_created_at_not_in: The local_created_at_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_created_at_not_in: list[str]
        """

        self._local_created_at_not_in = local_created_at_not_in

    @property
    def local_id(self):
        """Gets the local_id of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this BackupRestorePointWhereInput.


        :param local_id: The local_id of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this BackupRestorePointWhereInput.


        :param local_id_contains: The local_id_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this BackupRestorePointWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this BackupRestorePointWhereInput.


        :param local_id_gt: The local_id_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this BackupRestorePointWhereInput.


        :param local_id_gte: The local_id_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this BackupRestorePointWhereInput.


        :param local_id_in: The local_id_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this BackupRestorePointWhereInput.


        :param local_id_lt: The local_id_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this BackupRestorePointWhereInput.


        :param local_id_lte: The local_id_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this BackupRestorePointWhereInput.


        :param local_id_not: The local_id_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this BackupRestorePointWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this BackupRestorePointWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this BackupRestorePointWhereInput.


        :param local_id_not_in: The local_id_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this BackupRestorePointWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this BackupRestorePointWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def logical_size(self):
        """Gets the logical_size of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The logical_size of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size

    @logical_size.setter
    def logical_size(self, logical_size):
        """Sets the logical_size of this BackupRestorePointWhereInput.


        :param logical_size: The logical_size of this BackupRestorePointWhereInput.  # noqa: E501
        :type logical_size: int
        """

        self._logical_size = logical_size

    @property
    def logical_size_gt(self):
        """Gets the logical_size_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The logical_size_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_gt

    @logical_size_gt.setter
    def logical_size_gt(self, logical_size_gt):
        """Sets the logical_size_gt of this BackupRestorePointWhereInput.


        :param logical_size_gt: The logical_size_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type logical_size_gt: int
        """

        self._logical_size_gt = logical_size_gt

    @property
    def logical_size_gte(self):
        """Gets the logical_size_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The logical_size_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_gte

    @logical_size_gte.setter
    def logical_size_gte(self, logical_size_gte):
        """Sets the logical_size_gte of this BackupRestorePointWhereInput.


        :param logical_size_gte: The logical_size_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type logical_size_gte: int
        """

        self._logical_size_gte = logical_size_gte

    @property
    def logical_size_in(self):
        """Gets the logical_size_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The logical_size_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._logical_size_in

    @logical_size_in.setter
    def logical_size_in(self, logical_size_in):
        """Sets the logical_size_in of this BackupRestorePointWhereInput.


        :param logical_size_in: The logical_size_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type logical_size_in: list[int]
        """

        self._logical_size_in = logical_size_in

    @property
    def logical_size_lt(self):
        """Gets the logical_size_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The logical_size_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_lt

    @logical_size_lt.setter
    def logical_size_lt(self, logical_size_lt):
        """Sets the logical_size_lt of this BackupRestorePointWhereInput.


        :param logical_size_lt: The logical_size_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type logical_size_lt: int
        """

        self._logical_size_lt = logical_size_lt

    @property
    def logical_size_lte(self):
        """Gets the logical_size_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The logical_size_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_lte

    @logical_size_lte.setter
    def logical_size_lte(self, logical_size_lte):
        """Sets the logical_size_lte of this BackupRestorePointWhereInput.


        :param logical_size_lte: The logical_size_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type logical_size_lte: int
        """

        self._logical_size_lte = logical_size_lte

    @property
    def logical_size_not(self):
        """Gets the logical_size_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The logical_size_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._logical_size_not

    @logical_size_not.setter
    def logical_size_not(self, logical_size_not):
        """Sets the logical_size_not of this BackupRestorePointWhereInput.


        :param logical_size_not: The logical_size_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type logical_size_not: int
        """

        self._logical_size_not = logical_size_not

    @property
    def logical_size_not_in(self):
        """Gets the logical_size_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The logical_size_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._logical_size_not_in

    @logical_size_not_in.setter
    def logical_size_not_in(self, logical_size_not_in):
        """Sets the logical_size_not_in of this BackupRestorePointWhereInput.


        :param logical_size_not_in: The logical_size_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type logical_size_not_in: list[int]
        """

        self._logical_size_not_in = logical_size_not_in

    @property
    def parent_restore_point(self):
        """Gets the parent_restore_point of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point

    @parent_restore_point.setter
    def parent_restore_point(self, parent_restore_point):
        """Sets the parent_restore_point of this BackupRestorePointWhereInput.


        :param parent_restore_point: The parent_restore_point of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point: str
        """

        self._parent_restore_point = parent_restore_point

    @property
    def parent_restore_point_contains(self):
        """Gets the parent_restore_point_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_contains

    @parent_restore_point_contains.setter
    def parent_restore_point_contains(self, parent_restore_point_contains):
        """Sets the parent_restore_point_contains of this BackupRestorePointWhereInput.


        :param parent_restore_point_contains: The parent_restore_point_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_contains: str
        """

        self._parent_restore_point_contains = parent_restore_point_contains

    @property
    def parent_restore_point_ends_with(self):
        """Gets the parent_restore_point_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_ends_with

    @parent_restore_point_ends_with.setter
    def parent_restore_point_ends_with(self, parent_restore_point_ends_with):
        """Sets the parent_restore_point_ends_with of this BackupRestorePointWhereInput.


        :param parent_restore_point_ends_with: The parent_restore_point_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_ends_with: str
        """

        self._parent_restore_point_ends_with = parent_restore_point_ends_with

    @property
    def parent_restore_point_gt(self):
        """Gets the parent_restore_point_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_gt

    @parent_restore_point_gt.setter
    def parent_restore_point_gt(self, parent_restore_point_gt):
        """Sets the parent_restore_point_gt of this BackupRestorePointWhereInput.


        :param parent_restore_point_gt: The parent_restore_point_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_gt: str
        """

        self._parent_restore_point_gt = parent_restore_point_gt

    @property
    def parent_restore_point_gte(self):
        """Gets the parent_restore_point_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_gte

    @parent_restore_point_gte.setter
    def parent_restore_point_gte(self, parent_restore_point_gte):
        """Sets the parent_restore_point_gte of this BackupRestorePointWhereInput.


        :param parent_restore_point_gte: The parent_restore_point_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_gte: str
        """

        self._parent_restore_point_gte = parent_restore_point_gte

    @property
    def parent_restore_point_in(self):
        """Gets the parent_restore_point_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._parent_restore_point_in

    @parent_restore_point_in.setter
    def parent_restore_point_in(self, parent_restore_point_in):
        """Sets the parent_restore_point_in of this BackupRestorePointWhereInput.


        :param parent_restore_point_in: The parent_restore_point_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_in: list[str]
        """

        self._parent_restore_point_in = parent_restore_point_in

    @property
    def parent_restore_point_lt(self):
        """Gets the parent_restore_point_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_lt

    @parent_restore_point_lt.setter
    def parent_restore_point_lt(self, parent_restore_point_lt):
        """Sets the parent_restore_point_lt of this BackupRestorePointWhereInput.


        :param parent_restore_point_lt: The parent_restore_point_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_lt: str
        """

        self._parent_restore_point_lt = parent_restore_point_lt

    @property
    def parent_restore_point_lte(self):
        """Gets the parent_restore_point_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_lte

    @parent_restore_point_lte.setter
    def parent_restore_point_lte(self, parent_restore_point_lte):
        """Sets the parent_restore_point_lte of this BackupRestorePointWhereInput.


        :param parent_restore_point_lte: The parent_restore_point_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_lte: str
        """

        self._parent_restore_point_lte = parent_restore_point_lte

    @property
    def parent_restore_point_not(self):
        """Gets the parent_restore_point_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_not

    @parent_restore_point_not.setter
    def parent_restore_point_not(self, parent_restore_point_not):
        """Sets the parent_restore_point_not of this BackupRestorePointWhereInput.


        :param parent_restore_point_not: The parent_restore_point_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_not: str
        """

        self._parent_restore_point_not = parent_restore_point_not

    @property
    def parent_restore_point_not_contains(self):
        """Gets the parent_restore_point_not_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_not_contains

    @parent_restore_point_not_contains.setter
    def parent_restore_point_not_contains(self, parent_restore_point_not_contains):
        """Sets the parent_restore_point_not_contains of this BackupRestorePointWhereInput.


        :param parent_restore_point_not_contains: The parent_restore_point_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_not_contains: str
        """

        self._parent_restore_point_not_contains = parent_restore_point_not_contains

    @property
    def parent_restore_point_not_ends_with(self):
        """Gets the parent_restore_point_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_not_ends_with

    @parent_restore_point_not_ends_with.setter
    def parent_restore_point_not_ends_with(self, parent_restore_point_not_ends_with):
        """Sets the parent_restore_point_not_ends_with of this BackupRestorePointWhereInput.


        :param parent_restore_point_not_ends_with: The parent_restore_point_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_not_ends_with: str
        """

        self._parent_restore_point_not_ends_with = parent_restore_point_not_ends_with

    @property
    def parent_restore_point_not_in(self):
        """Gets the parent_restore_point_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._parent_restore_point_not_in

    @parent_restore_point_not_in.setter
    def parent_restore_point_not_in(self, parent_restore_point_not_in):
        """Sets the parent_restore_point_not_in of this BackupRestorePointWhereInput.


        :param parent_restore_point_not_in: The parent_restore_point_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_not_in: list[str]
        """

        self._parent_restore_point_not_in = parent_restore_point_not_in

    @property
    def parent_restore_point_not_starts_with(self):
        """Gets the parent_restore_point_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_not_starts_with

    @parent_restore_point_not_starts_with.setter
    def parent_restore_point_not_starts_with(self, parent_restore_point_not_starts_with):
        """Sets the parent_restore_point_not_starts_with of this BackupRestorePointWhereInput.


        :param parent_restore_point_not_starts_with: The parent_restore_point_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_not_starts_with: str
        """

        self._parent_restore_point_not_starts_with = parent_restore_point_not_starts_with

    @property
    def parent_restore_point_starts_with(self):
        """Gets the parent_restore_point_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The parent_restore_point_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_restore_point_starts_with

    @parent_restore_point_starts_with.setter
    def parent_restore_point_starts_with(self, parent_restore_point_starts_with):
        """Sets the parent_restore_point_starts_with of this BackupRestorePointWhereInput.


        :param parent_restore_point_starts_with: The parent_restore_point_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type parent_restore_point_starts_with: str
        """

        self._parent_restore_point_starts_with = parent_restore_point_starts_with

    @property
    def physical_size(self):
        """Gets the physical_size of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The physical_size of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size

    @physical_size.setter
    def physical_size(self, physical_size):
        """Sets the physical_size of this BackupRestorePointWhereInput.


        :param physical_size: The physical_size of this BackupRestorePointWhereInput.  # noqa: E501
        :type physical_size: int
        """

        self._physical_size = physical_size

    @property
    def physical_size_gt(self):
        """Gets the physical_size_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The physical_size_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size_gt

    @physical_size_gt.setter
    def physical_size_gt(self, physical_size_gt):
        """Sets the physical_size_gt of this BackupRestorePointWhereInput.


        :param physical_size_gt: The physical_size_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type physical_size_gt: int
        """

        self._physical_size_gt = physical_size_gt

    @property
    def physical_size_gte(self):
        """Gets the physical_size_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The physical_size_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size_gte

    @physical_size_gte.setter
    def physical_size_gte(self, physical_size_gte):
        """Sets the physical_size_gte of this BackupRestorePointWhereInput.


        :param physical_size_gte: The physical_size_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type physical_size_gte: int
        """

        self._physical_size_gte = physical_size_gte

    @property
    def physical_size_in(self):
        """Gets the physical_size_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The physical_size_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._physical_size_in

    @physical_size_in.setter
    def physical_size_in(self, physical_size_in):
        """Sets the physical_size_in of this BackupRestorePointWhereInput.


        :param physical_size_in: The physical_size_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type physical_size_in: list[int]
        """

        self._physical_size_in = physical_size_in

    @property
    def physical_size_lt(self):
        """Gets the physical_size_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The physical_size_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size_lt

    @physical_size_lt.setter
    def physical_size_lt(self, physical_size_lt):
        """Sets the physical_size_lt of this BackupRestorePointWhereInput.


        :param physical_size_lt: The physical_size_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type physical_size_lt: int
        """

        self._physical_size_lt = physical_size_lt

    @property
    def physical_size_lte(self):
        """Gets the physical_size_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The physical_size_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size_lte

    @physical_size_lte.setter
    def physical_size_lte(self, physical_size_lte):
        """Sets the physical_size_lte of this BackupRestorePointWhereInput.


        :param physical_size_lte: The physical_size_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type physical_size_lte: int
        """

        self._physical_size_lte = physical_size_lte

    @property
    def physical_size_not(self):
        """Gets the physical_size_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The physical_size_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._physical_size_not

    @physical_size_not.setter
    def physical_size_not(self, physical_size_not):
        """Sets the physical_size_not of this BackupRestorePointWhereInput.


        :param physical_size_not: The physical_size_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type physical_size_not: int
        """

        self._physical_size_not = physical_size_not

    @property
    def physical_size_not_in(self):
        """Gets the physical_size_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The physical_size_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._physical_size_not_in

    @physical_size_not_in.setter
    def physical_size_not_in(self, physical_size_not_in):
        """Sets the physical_size_not_in of this BackupRestorePointWhereInput.


        :param physical_size_not_in: The physical_size_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type physical_size_not_in: list[int]
        """

        self._physical_size_not_in = physical_size_not_in

    @property
    def size(self):
        """Gets the size of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The size of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this BackupRestorePointWhereInput.


        :param size: The size of this BackupRestorePointWhereInput.  # noqa: E501
        :type size: int
        """

        self._size = size

    @property
    def size_gt(self):
        """Gets the size_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The size_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_gt

    @size_gt.setter
    def size_gt(self, size_gt):
        """Sets the size_gt of this BackupRestorePointWhereInput.


        :param size_gt: The size_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type size_gt: int
        """

        self._size_gt = size_gt

    @property
    def size_gte(self):
        """Gets the size_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The size_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_gte

    @size_gte.setter
    def size_gte(self, size_gte):
        """Sets the size_gte of this BackupRestorePointWhereInput.


        :param size_gte: The size_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type size_gte: int
        """

        self._size_gte = size_gte

    @property
    def size_in(self):
        """Gets the size_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The size_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._size_in

    @size_in.setter
    def size_in(self, size_in):
        """Sets the size_in of this BackupRestorePointWhereInput.


        :param size_in: The size_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type size_in: list[int]
        """

        self._size_in = size_in

    @property
    def size_lt(self):
        """Gets the size_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The size_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_lt

    @size_lt.setter
    def size_lt(self, size_lt):
        """Sets the size_lt of this BackupRestorePointWhereInput.


        :param size_lt: The size_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type size_lt: int
        """

        self._size_lt = size_lt

    @property
    def size_lte(self):
        """Gets the size_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The size_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_lte

    @size_lte.setter
    def size_lte(self, size_lte):
        """Sets the size_lte of this BackupRestorePointWhereInput.


        :param size_lte: The size_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type size_lte: int
        """

        self._size_lte = size_lte

    @property
    def size_not(self):
        """Gets the size_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The size_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._size_not

    @size_not.setter
    def size_not(self, size_not):
        """Sets the size_not of this BackupRestorePointWhereInput.


        :param size_not: The size_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type size_not: int
        """

        self._size_not = size_not

    @property
    def size_not_in(self):
        """Gets the size_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The size_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._size_not_in

    @size_not_in.setter
    def size_not_in(self, size_not_in):
        """Sets the size_not_in of this BackupRestorePointWhereInput.


        :param size_not_in: The size_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type size_not_in: list[int]
        """

        self._size_not_in = size_not_in

    @property
    def slice(self):
        """Gets the slice of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice

    @slice.setter
    def slice(self, slice):
        """Sets the slice of this BackupRestorePointWhereInput.


        :param slice: The slice of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice: str
        """

        self._slice = slice

    @property
    def slice_contains(self):
        """Gets the slice_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_contains

    @slice_contains.setter
    def slice_contains(self, slice_contains):
        """Sets the slice_contains of this BackupRestorePointWhereInput.


        :param slice_contains: The slice_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_contains: str
        """

        self._slice_contains = slice_contains

    @property
    def slice_ends_with(self):
        """Gets the slice_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_ends_with

    @slice_ends_with.setter
    def slice_ends_with(self, slice_ends_with):
        """Sets the slice_ends_with of this BackupRestorePointWhereInput.


        :param slice_ends_with: The slice_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_ends_with: str
        """

        self._slice_ends_with = slice_ends_with

    @property
    def slice_gt(self):
        """Gets the slice_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_gt

    @slice_gt.setter
    def slice_gt(self, slice_gt):
        """Sets the slice_gt of this BackupRestorePointWhereInput.


        :param slice_gt: The slice_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_gt: str
        """

        self._slice_gt = slice_gt

    @property
    def slice_gte(self):
        """Gets the slice_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_gte

    @slice_gte.setter
    def slice_gte(self, slice_gte):
        """Sets the slice_gte of this BackupRestorePointWhereInput.


        :param slice_gte: The slice_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_gte: str
        """

        self._slice_gte = slice_gte

    @property
    def slice_in(self):
        """Gets the slice_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._slice_in

    @slice_in.setter
    def slice_in(self, slice_in):
        """Sets the slice_in of this BackupRestorePointWhereInput.


        :param slice_in: The slice_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_in: list[str]
        """

        self._slice_in = slice_in

    @property
    def slice_lt(self):
        """Gets the slice_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_lt

    @slice_lt.setter
    def slice_lt(self, slice_lt):
        """Sets the slice_lt of this BackupRestorePointWhereInput.


        :param slice_lt: The slice_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_lt: str
        """

        self._slice_lt = slice_lt

    @property
    def slice_lte(self):
        """Gets the slice_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_lte

    @slice_lte.setter
    def slice_lte(self, slice_lte):
        """Sets the slice_lte of this BackupRestorePointWhereInput.


        :param slice_lte: The slice_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_lte: str
        """

        self._slice_lte = slice_lte

    @property
    def slice_not(self):
        """Gets the slice_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_not

    @slice_not.setter
    def slice_not(self, slice_not):
        """Sets the slice_not of this BackupRestorePointWhereInput.


        :param slice_not: The slice_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_not: str
        """

        self._slice_not = slice_not

    @property
    def slice_not_contains(self):
        """Gets the slice_not_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_not_contains

    @slice_not_contains.setter
    def slice_not_contains(self, slice_not_contains):
        """Sets the slice_not_contains of this BackupRestorePointWhereInput.


        :param slice_not_contains: The slice_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_not_contains: str
        """

        self._slice_not_contains = slice_not_contains

    @property
    def slice_not_ends_with(self):
        """Gets the slice_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_not_ends_with

    @slice_not_ends_with.setter
    def slice_not_ends_with(self, slice_not_ends_with):
        """Sets the slice_not_ends_with of this BackupRestorePointWhereInput.


        :param slice_not_ends_with: The slice_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_not_ends_with: str
        """

        self._slice_not_ends_with = slice_not_ends_with

    @property
    def slice_not_in(self):
        """Gets the slice_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._slice_not_in

    @slice_not_in.setter
    def slice_not_in(self, slice_not_in):
        """Sets the slice_not_in of this BackupRestorePointWhereInput.


        :param slice_not_in: The slice_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_not_in: list[str]
        """

        self._slice_not_in = slice_not_in

    @property
    def slice_not_starts_with(self):
        """Gets the slice_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_not_starts_with

    @slice_not_starts_with.setter
    def slice_not_starts_with(self, slice_not_starts_with):
        """Sets the slice_not_starts_with of this BackupRestorePointWhereInput.


        :param slice_not_starts_with: The slice_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_not_starts_with: str
        """

        self._slice_not_starts_with = slice_not_starts_with

    @property
    def slice_starts_with(self):
        """Gets the slice_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The slice_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._slice_starts_with

    @slice_starts_with.setter
    def slice_starts_with(self, slice_starts_with):
        """Sets the slice_starts_with of this BackupRestorePointWhereInput.


        :param slice_starts_with: The slice_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type slice_starts_with: str
        """

        self._slice_starts_with = slice_starts_with

    @property
    def snapshot_consistent_type(self):
        """Gets the snapshot_consistent_type of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._snapshot_consistent_type

    @snapshot_consistent_type.setter
    def snapshot_consistent_type(self, snapshot_consistent_type):
        """Sets the snapshot_consistent_type of this BackupRestorePointWhereInput.


        :param snapshot_consistent_type: The snapshot_consistent_type of this BackupRestorePointWhereInput.  # noqa: E501
        :type snapshot_consistent_type: ConsistentType
        """

        self._snapshot_consistent_type = snapshot_consistent_type

    @property
    def snapshot_consistent_type_in(self):
        """Gets the snapshot_consistent_type_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[ConsistentType]
        """
        return self._snapshot_consistent_type_in

    @snapshot_consistent_type_in.setter
    def snapshot_consistent_type_in(self, snapshot_consistent_type_in):
        """Sets the snapshot_consistent_type_in of this BackupRestorePointWhereInput.


        :param snapshot_consistent_type_in: The snapshot_consistent_type_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type snapshot_consistent_type_in: list[ConsistentType]
        """

        self._snapshot_consistent_type_in = snapshot_consistent_type_in

    @property
    def snapshot_consistent_type_not(self):
        """Gets the snapshot_consistent_type_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: ConsistentType
        """
        return self._snapshot_consistent_type_not

    @snapshot_consistent_type_not.setter
    def snapshot_consistent_type_not(self, snapshot_consistent_type_not):
        """Sets the snapshot_consistent_type_not of this BackupRestorePointWhereInput.


        :param snapshot_consistent_type_not: The snapshot_consistent_type_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type snapshot_consistent_type_not: ConsistentType
        """

        self._snapshot_consistent_type_not = snapshot_consistent_type_not

    @property
    def snapshot_consistent_type_not_in(self):
        """Gets the snapshot_consistent_type_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The snapshot_consistent_type_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[ConsistentType]
        """
        return self._snapshot_consistent_type_not_in

    @snapshot_consistent_type_not_in.setter
    def snapshot_consistent_type_not_in(self, snapshot_consistent_type_not_in):
        """Sets the snapshot_consistent_type_not_in of this BackupRestorePointWhereInput.


        :param snapshot_consistent_type_not_in: The snapshot_consistent_type_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type snapshot_consistent_type_not_in: list[ConsistentType]
        """

        self._snapshot_consistent_type_not_in = snapshot_consistent_type_not_in

    @property
    def type(self):
        """Gets the type of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The type of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: BackupRestorePointType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BackupRestorePointWhereInput.


        :param type: The type of this BackupRestorePointWhereInput.  # noqa: E501
        :type type: BackupRestorePointType
        """

        self._type = type

    @property
    def type_in(self):
        """Gets the type_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The type_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupRestorePointType]
        """
        return self._type_in

    @type_in.setter
    def type_in(self, type_in):
        """Sets the type_in of this BackupRestorePointWhereInput.


        :param type_in: The type_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type type_in: list[BackupRestorePointType]
        """

        self._type_in = type_in

    @property
    def type_not(self):
        """Gets the type_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The type_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: BackupRestorePointType
        """
        return self._type_not

    @type_not.setter
    def type_not(self, type_not):
        """Sets the type_not of this BackupRestorePointWhereInput.


        :param type_not: The type_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type type_not: BackupRestorePointType
        """

        self._type_not = type_not

    @property
    def type_not_in(self):
        """Gets the type_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The type_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[BackupRestorePointType]
        """
        return self._type_not_in

    @type_not_in.setter
    def type_not_in(self, type_not_in):
        """Sets the type_not_in of this BackupRestorePointWhereInput.


        :param type_not_in: The type_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type type_not_in: list[BackupRestorePointType]
        """

        self._type_not_in = type_not_in

    @property
    def valid_capacity(self):
        """Gets the valid_capacity of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_capacity of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_capacity

    @valid_capacity.setter
    def valid_capacity(self, valid_capacity):
        """Sets the valid_capacity of this BackupRestorePointWhereInput.


        :param valid_capacity: The valid_capacity of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_capacity: int
        """

        self._valid_capacity = valid_capacity

    @property
    def valid_capacity_gt(self):
        """Gets the valid_capacity_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_capacity_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_capacity_gt

    @valid_capacity_gt.setter
    def valid_capacity_gt(self, valid_capacity_gt):
        """Sets the valid_capacity_gt of this BackupRestorePointWhereInput.


        :param valid_capacity_gt: The valid_capacity_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_capacity_gt: int
        """

        self._valid_capacity_gt = valid_capacity_gt

    @property
    def valid_capacity_gte(self):
        """Gets the valid_capacity_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_capacity_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_capacity_gte

    @valid_capacity_gte.setter
    def valid_capacity_gte(self, valid_capacity_gte):
        """Sets the valid_capacity_gte of this BackupRestorePointWhereInput.


        :param valid_capacity_gte: The valid_capacity_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_capacity_gte: int
        """

        self._valid_capacity_gte = valid_capacity_gte

    @property
    def valid_capacity_in(self):
        """Gets the valid_capacity_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_capacity_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_capacity_in

    @valid_capacity_in.setter
    def valid_capacity_in(self, valid_capacity_in):
        """Sets the valid_capacity_in of this BackupRestorePointWhereInput.


        :param valid_capacity_in: The valid_capacity_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_capacity_in: list[int]
        """

        self._valid_capacity_in = valid_capacity_in

    @property
    def valid_capacity_lt(self):
        """Gets the valid_capacity_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_capacity_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_capacity_lt

    @valid_capacity_lt.setter
    def valid_capacity_lt(self, valid_capacity_lt):
        """Sets the valid_capacity_lt of this BackupRestorePointWhereInput.


        :param valid_capacity_lt: The valid_capacity_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_capacity_lt: int
        """

        self._valid_capacity_lt = valid_capacity_lt

    @property
    def valid_capacity_lte(self):
        """Gets the valid_capacity_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_capacity_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_capacity_lte

    @valid_capacity_lte.setter
    def valid_capacity_lte(self, valid_capacity_lte):
        """Sets the valid_capacity_lte of this BackupRestorePointWhereInput.


        :param valid_capacity_lte: The valid_capacity_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_capacity_lte: int
        """

        self._valid_capacity_lte = valid_capacity_lte

    @property
    def valid_capacity_not(self):
        """Gets the valid_capacity_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_capacity_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_capacity_not

    @valid_capacity_not.setter
    def valid_capacity_not(self, valid_capacity_not):
        """Sets the valid_capacity_not of this BackupRestorePointWhereInput.


        :param valid_capacity_not: The valid_capacity_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_capacity_not: int
        """

        self._valid_capacity_not = valid_capacity_not

    @property
    def valid_capacity_not_in(self):
        """Gets the valid_capacity_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_capacity_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_capacity_not_in

    @valid_capacity_not_in.setter
    def valid_capacity_not_in(self, valid_capacity_not_in):
        """Sets the valid_capacity_not_in of this BackupRestorePointWhereInput.


        :param valid_capacity_not_in: The valid_capacity_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_capacity_not_in: list[int]
        """

        self._valid_capacity_not_in = valid_capacity_not_in

    @property
    def valid_size(self):
        """Gets the valid_size of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_size of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size

    @valid_size.setter
    def valid_size(self, valid_size):
        """Sets the valid_size of this BackupRestorePointWhereInput.


        :param valid_size: The valid_size of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_size: int
        """

        self._valid_size = valid_size

    @property
    def valid_size_gt(self):
        """Gets the valid_size_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_size_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_gt

    @valid_size_gt.setter
    def valid_size_gt(self, valid_size_gt):
        """Sets the valid_size_gt of this BackupRestorePointWhereInput.


        :param valid_size_gt: The valid_size_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_size_gt: int
        """

        self._valid_size_gt = valid_size_gt

    @property
    def valid_size_gte(self):
        """Gets the valid_size_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_size_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_gte

    @valid_size_gte.setter
    def valid_size_gte(self, valid_size_gte):
        """Sets the valid_size_gte of this BackupRestorePointWhereInput.


        :param valid_size_gte: The valid_size_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_size_gte: int
        """

        self._valid_size_gte = valid_size_gte

    @property
    def valid_size_in(self):
        """Gets the valid_size_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_size_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_size_in

    @valid_size_in.setter
    def valid_size_in(self, valid_size_in):
        """Sets the valid_size_in of this BackupRestorePointWhereInput.


        :param valid_size_in: The valid_size_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_size_in: list[int]
        """

        self._valid_size_in = valid_size_in

    @property
    def valid_size_lt(self):
        """Gets the valid_size_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_size_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_lt

    @valid_size_lt.setter
    def valid_size_lt(self, valid_size_lt):
        """Sets the valid_size_lt of this BackupRestorePointWhereInput.


        :param valid_size_lt: The valid_size_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_size_lt: int
        """

        self._valid_size_lt = valid_size_lt

    @property
    def valid_size_lte(self):
        """Gets the valid_size_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_size_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_lte

    @valid_size_lte.setter
    def valid_size_lte(self, valid_size_lte):
        """Sets the valid_size_lte of this BackupRestorePointWhereInput.


        :param valid_size_lte: The valid_size_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_size_lte: int
        """

        self._valid_size_lte = valid_size_lte

    @property
    def valid_size_not(self):
        """Gets the valid_size_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_size_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_size_not

    @valid_size_not.setter
    def valid_size_not(self, valid_size_not):
        """Sets the valid_size_not of this BackupRestorePointWhereInput.


        :param valid_size_not: The valid_size_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_size_not: int
        """

        self._valid_size_not = valid_size_not

    @property
    def valid_size_not_in(self):
        """Gets the valid_size_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The valid_size_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_size_not_in

    @valid_size_not_in.setter
    def valid_size_not_in(self, valid_size_not_in):
        """Sets the valid_size_not_in of this BackupRestorePointWhereInput.


        :param valid_size_not_in: The valid_size_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type valid_size_not_in: list[int]
        """

        self._valid_size_not_in = valid_size_not_in

    @property
    def vm(self):
        """Gets the vm of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vm

    @vm.setter
    def vm(self, vm):
        """Sets the vm of this BackupRestorePointWhereInput.


        :param vm: The vm of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm: VmWhereInput
        """

        self._vm = vm

    @property
    def vm_local_id(self):
        """Gets the vm_local_id of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id

    @vm_local_id.setter
    def vm_local_id(self, vm_local_id):
        """Sets the vm_local_id of this BackupRestorePointWhereInput.


        :param vm_local_id: The vm_local_id of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id: str
        """

        self._vm_local_id = vm_local_id

    @property
    def vm_local_id_contains(self):
        """Gets the vm_local_id_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_contains

    @vm_local_id_contains.setter
    def vm_local_id_contains(self, vm_local_id_contains):
        """Sets the vm_local_id_contains of this BackupRestorePointWhereInput.


        :param vm_local_id_contains: The vm_local_id_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_contains: str
        """

        self._vm_local_id_contains = vm_local_id_contains

    @property
    def vm_local_id_ends_with(self):
        """Gets the vm_local_id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_ends_with

    @vm_local_id_ends_with.setter
    def vm_local_id_ends_with(self, vm_local_id_ends_with):
        """Sets the vm_local_id_ends_with of this BackupRestorePointWhereInput.


        :param vm_local_id_ends_with: The vm_local_id_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_ends_with: str
        """

        self._vm_local_id_ends_with = vm_local_id_ends_with

    @property
    def vm_local_id_gt(self):
        """Gets the vm_local_id_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_gt

    @vm_local_id_gt.setter
    def vm_local_id_gt(self, vm_local_id_gt):
        """Sets the vm_local_id_gt of this BackupRestorePointWhereInput.


        :param vm_local_id_gt: The vm_local_id_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_gt: str
        """

        self._vm_local_id_gt = vm_local_id_gt

    @property
    def vm_local_id_gte(self):
        """Gets the vm_local_id_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_gte

    @vm_local_id_gte.setter
    def vm_local_id_gte(self, vm_local_id_gte):
        """Sets the vm_local_id_gte of this BackupRestorePointWhereInput.


        :param vm_local_id_gte: The vm_local_id_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_gte: str
        """

        self._vm_local_id_gte = vm_local_id_gte

    @property
    def vm_local_id_in(self):
        """Gets the vm_local_id_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_local_id_in

    @vm_local_id_in.setter
    def vm_local_id_in(self, vm_local_id_in):
        """Sets the vm_local_id_in of this BackupRestorePointWhereInput.


        :param vm_local_id_in: The vm_local_id_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_in: list[str]
        """

        self._vm_local_id_in = vm_local_id_in

    @property
    def vm_local_id_lt(self):
        """Gets the vm_local_id_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_lt

    @vm_local_id_lt.setter
    def vm_local_id_lt(self, vm_local_id_lt):
        """Sets the vm_local_id_lt of this BackupRestorePointWhereInput.


        :param vm_local_id_lt: The vm_local_id_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_lt: str
        """

        self._vm_local_id_lt = vm_local_id_lt

    @property
    def vm_local_id_lte(self):
        """Gets the vm_local_id_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_lte

    @vm_local_id_lte.setter
    def vm_local_id_lte(self, vm_local_id_lte):
        """Sets the vm_local_id_lte of this BackupRestorePointWhereInput.


        :param vm_local_id_lte: The vm_local_id_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_lte: str
        """

        self._vm_local_id_lte = vm_local_id_lte

    @property
    def vm_local_id_not(self):
        """Gets the vm_local_id_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not

    @vm_local_id_not.setter
    def vm_local_id_not(self, vm_local_id_not):
        """Sets the vm_local_id_not of this BackupRestorePointWhereInput.


        :param vm_local_id_not: The vm_local_id_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_not: str
        """

        self._vm_local_id_not = vm_local_id_not

    @property
    def vm_local_id_not_contains(self):
        """Gets the vm_local_id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not_contains

    @vm_local_id_not_contains.setter
    def vm_local_id_not_contains(self, vm_local_id_not_contains):
        """Sets the vm_local_id_not_contains of this BackupRestorePointWhereInput.


        :param vm_local_id_not_contains: The vm_local_id_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_not_contains: str
        """

        self._vm_local_id_not_contains = vm_local_id_not_contains

    @property
    def vm_local_id_not_ends_with(self):
        """Gets the vm_local_id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not_ends_with

    @vm_local_id_not_ends_with.setter
    def vm_local_id_not_ends_with(self, vm_local_id_not_ends_with):
        """Sets the vm_local_id_not_ends_with of this BackupRestorePointWhereInput.


        :param vm_local_id_not_ends_with: The vm_local_id_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_not_ends_with: str
        """

        self._vm_local_id_not_ends_with = vm_local_id_not_ends_with

    @property
    def vm_local_id_not_in(self):
        """Gets the vm_local_id_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_local_id_not_in

    @vm_local_id_not_in.setter
    def vm_local_id_not_in(self, vm_local_id_not_in):
        """Sets the vm_local_id_not_in of this BackupRestorePointWhereInput.


        :param vm_local_id_not_in: The vm_local_id_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_not_in: list[str]
        """

        self._vm_local_id_not_in = vm_local_id_not_in

    @property
    def vm_local_id_not_starts_with(self):
        """Gets the vm_local_id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not_starts_with

    @vm_local_id_not_starts_with.setter
    def vm_local_id_not_starts_with(self, vm_local_id_not_starts_with):
        """Sets the vm_local_id_not_starts_with of this BackupRestorePointWhereInput.


        :param vm_local_id_not_starts_with: The vm_local_id_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_not_starts_with: str
        """

        self._vm_local_id_not_starts_with = vm_local_id_not_starts_with

    @property
    def vm_local_id_starts_with(self):
        """Gets the vm_local_id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_local_id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_starts_with

    @vm_local_id_starts_with.setter
    def vm_local_id_starts_with(self, vm_local_id_starts_with):
        """Sets the vm_local_id_starts_with of this BackupRestorePointWhereInput.


        :param vm_local_id_starts_with: The vm_local_id_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_local_id_starts_with: str
        """

        self._vm_local_id_starts_with = vm_local_id_starts_with

    @property
    def vm_name(self):
        """Gets the vm_name of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name

    @vm_name.setter
    def vm_name(self, vm_name):
        """Sets the vm_name of this BackupRestorePointWhereInput.


        :param vm_name: The vm_name of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name: str
        """

        self._vm_name = vm_name

    @property
    def vm_name_contains(self):
        """Gets the vm_name_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_contains

    @vm_name_contains.setter
    def vm_name_contains(self, vm_name_contains):
        """Sets the vm_name_contains of this BackupRestorePointWhereInput.


        :param vm_name_contains: The vm_name_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_contains: str
        """

        self._vm_name_contains = vm_name_contains

    @property
    def vm_name_ends_with(self):
        """Gets the vm_name_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_ends_with

    @vm_name_ends_with.setter
    def vm_name_ends_with(self, vm_name_ends_with):
        """Sets the vm_name_ends_with of this BackupRestorePointWhereInput.


        :param vm_name_ends_with: The vm_name_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_ends_with: str
        """

        self._vm_name_ends_with = vm_name_ends_with

    @property
    def vm_name_gt(self):
        """Gets the vm_name_gt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_gt

    @vm_name_gt.setter
    def vm_name_gt(self, vm_name_gt):
        """Sets the vm_name_gt of this BackupRestorePointWhereInput.


        :param vm_name_gt: The vm_name_gt of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_gt: str
        """

        self._vm_name_gt = vm_name_gt

    @property
    def vm_name_gte(self):
        """Gets the vm_name_gte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_gte

    @vm_name_gte.setter
    def vm_name_gte(self, vm_name_gte):
        """Sets the vm_name_gte of this BackupRestorePointWhereInput.


        :param vm_name_gte: The vm_name_gte of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_gte: str
        """

        self._vm_name_gte = vm_name_gte

    @property
    def vm_name_in(self):
        """Gets the vm_name_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_name_in

    @vm_name_in.setter
    def vm_name_in(self, vm_name_in):
        """Sets the vm_name_in of this BackupRestorePointWhereInput.


        :param vm_name_in: The vm_name_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_in: list[str]
        """

        self._vm_name_in = vm_name_in

    @property
    def vm_name_lt(self):
        """Gets the vm_name_lt of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_lt

    @vm_name_lt.setter
    def vm_name_lt(self, vm_name_lt):
        """Sets the vm_name_lt of this BackupRestorePointWhereInput.


        :param vm_name_lt: The vm_name_lt of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_lt: str
        """

        self._vm_name_lt = vm_name_lt

    @property
    def vm_name_lte(self):
        """Gets the vm_name_lte of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_lte

    @vm_name_lte.setter
    def vm_name_lte(self, vm_name_lte):
        """Sets the vm_name_lte of this BackupRestorePointWhereInput.


        :param vm_name_lte: The vm_name_lte of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_lte: str
        """

        self._vm_name_lte = vm_name_lte

    @property
    def vm_name_not(self):
        """Gets the vm_name_not of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_not of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not

    @vm_name_not.setter
    def vm_name_not(self, vm_name_not):
        """Sets the vm_name_not of this BackupRestorePointWhereInput.


        :param vm_name_not: The vm_name_not of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_not: str
        """

        self._vm_name_not = vm_name_not

    @property
    def vm_name_not_contains(self):
        """Gets the vm_name_not_contains of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not_contains

    @vm_name_not_contains.setter
    def vm_name_not_contains(self, vm_name_not_contains):
        """Sets the vm_name_not_contains of this BackupRestorePointWhereInput.


        :param vm_name_not_contains: The vm_name_not_contains of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_not_contains: str
        """

        self._vm_name_not_contains = vm_name_not_contains

    @property
    def vm_name_not_ends_with(self):
        """Gets the vm_name_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not_ends_with

    @vm_name_not_ends_with.setter
    def vm_name_not_ends_with(self, vm_name_not_ends_with):
        """Sets the vm_name_not_ends_with of this BackupRestorePointWhereInput.


        :param vm_name_not_ends_with: The vm_name_not_ends_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_not_ends_with: str
        """

        self._vm_name_not_ends_with = vm_name_not_ends_with

    @property
    def vm_name_not_in(self):
        """Gets the vm_name_not_in of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_name_not_in

    @vm_name_not_in.setter
    def vm_name_not_in(self, vm_name_not_in):
        """Sets the vm_name_not_in of this BackupRestorePointWhereInput.


        :param vm_name_not_in: The vm_name_not_in of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_not_in: list[str]
        """

        self._vm_name_not_in = vm_name_not_in

    @property
    def vm_name_not_starts_with(self):
        """Gets the vm_name_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not_starts_with

    @vm_name_not_starts_with.setter
    def vm_name_not_starts_with(self, vm_name_not_starts_with):
        """Sets the vm_name_not_starts_with of this BackupRestorePointWhereInput.


        :param vm_name_not_starts_with: The vm_name_not_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_not_starts_with: str
        """

        self._vm_name_not_starts_with = vm_name_not_starts_with

    @property
    def vm_name_starts_with(self):
        """Gets the vm_name_starts_with of this BackupRestorePointWhereInput.  # noqa: E501


        :return: The vm_name_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_starts_with

    @vm_name_starts_with.setter
    def vm_name_starts_with(self, vm_name_starts_with):
        """Sets the vm_name_starts_with of this BackupRestorePointWhereInput.


        :param vm_name_starts_with: The vm_name_starts_with of this BackupRestorePointWhereInput.  # noqa: E501
        :type vm_name_starts_with: str
        """

        self._vm_name_starts_with = vm_name_starts_with

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupRestorePointWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupRestorePointWhereInput):
            return True

        return self.to_dict() != other.to_dict()
