# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupServiceWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[BackupServiceWhereInput]',
        '_not': 'list[BackupServiceWhereInput]',
        '_or': 'list[BackupServiceWhereInput]',
        'application': 'CloudTowerApplicationWhereInput',
        'backup_clusters_every': 'ClusterWhereInput',
        'backup_clusters_none': 'ClusterWhereInput',
        'backup_clusters_some': 'ClusterWhereInput',
        'backup_network_gateway': 'str',
        'backup_network_gateway_contains': 'str',
        'backup_network_gateway_ends_with': 'str',
        'backup_network_gateway_gt': 'str',
        'backup_network_gateway_gte': 'str',
        'backup_network_gateway_in': 'list[str]',
        'backup_network_gateway_lt': 'str',
        'backup_network_gateway_lte': 'str',
        'backup_network_gateway_not': 'str',
        'backup_network_gateway_not_contains': 'str',
        'backup_network_gateway_not_ends_with': 'str',
        'backup_network_gateway_not_in': 'list[str]',
        'backup_network_gateway_not_starts_with': 'str',
        'backup_network_gateway_starts_with': 'str',
        'backup_network_ip': 'str',
        'backup_network_ip_contains': 'str',
        'backup_network_ip_ends_with': 'str',
        'backup_network_ip_gt': 'str',
        'backup_network_ip_gte': 'str',
        'backup_network_ip_in': 'list[str]',
        'backup_network_ip_lt': 'str',
        'backup_network_ip_lte': 'str',
        'backup_network_ip_not': 'str',
        'backup_network_ip_not_contains': 'str',
        'backup_network_ip_not_ends_with': 'str',
        'backup_network_ip_not_in': 'list[str]',
        'backup_network_ip_not_starts_with': 'str',
        'backup_network_ip_starts_with': 'str',
        'backup_network_subnet_mask': 'str',
        'backup_network_subnet_mask_contains': 'str',
        'backup_network_subnet_mask_ends_with': 'str',
        'backup_network_subnet_mask_gt': 'str',
        'backup_network_subnet_mask_gte': 'str',
        'backup_network_subnet_mask_in': 'list[str]',
        'backup_network_subnet_mask_lt': 'str',
        'backup_network_subnet_mask_lte': 'str',
        'backup_network_subnet_mask_not': 'str',
        'backup_network_subnet_mask_not_contains': 'str',
        'backup_network_subnet_mask_not_ends_with': 'str',
        'backup_network_subnet_mask_not_in': 'list[str]',
        'backup_network_subnet_mask_not_starts_with': 'str',
        'backup_network_subnet_mask_starts_with': 'str',
        'backup_network_type': 'BackupServiceNetworkType',
        'backup_network_type_in': 'list[BackupServiceNetworkType]',
        'backup_network_type_not': 'BackupServiceNetworkType',
        'backup_network_type_not_in': 'list[BackupServiceNetworkType]',
        'backup_network_vlan': 'str',
        'backup_network_vlan_contains': 'str',
        'backup_network_vlan_ends_with': 'str',
        'backup_network_vlan_gt': 'str',
        'backup_network_vlan_gte': 'str',
        'backup_network_vlan_in': 'list[str]',
        'backup_network_vlan_lt': 'str',
        'backup_network_vlan_lte': 'str',
        'backup_network_vlan_not': 'str',
        'backup_network_vlan_not_contains': 'str',
        'backup_network_vlan_not_ends_with': 'str',
        'backup_network_vlan_not_in': 'list[str]',
        'backup_network_vlan_not_starts_with': 'str',
        'backup_network_vlan_starts_with': 'str',
        'backup_plans_every': 'BackupPlanWhereInput',
        'backup_plans_none': 'BackupPlanWhereInput',
        'backup_plans_some': 'BackupPlanWhereInput',
        'backup_rd_iops_max': 'int',
        'backup_rd_iops_max_gt': 'int',
        'backup_rd_iops_max_gte': 'int',
        'backup_rd_iops_max_in': 'list[int]',
        'backup_rd_iops_max_lt': 'int',
        'backup_rd_iops_max_lte': 'int',
        'backup_rd_iops_max_not': 'int',
        'backup_rd_iops_max_not_in': 'list[int]',
        'backup_store_repositories_every': 'BackupStoreRepositoryWhereInput',
        'backup_store_repositories_none': 'BackupStoreRepositoryWhereInput',
        'backup_store_repositories_some': 'BackupStoreRepositoryWhereInput',
        'backup_wr_iops_max': 'int',
        'backup_wr_iops_max_gt': 'int',
        'backup_wr_iops_max_gte': 'int',
        'backup_wr_iops_max_in': 'list[int]',
        'backup_wr_iops_max_lt': 'int',
        'backup_wr_iops_max_lte': 'int',
        'backup_wr_iops_max_not': 'int',
        'backup_wr_iops_max_not_in': 'list[int]',
        'description': 'str',
        'description_contains': 'str',
        'description_ends_with': 'str',
        'description_gt': 'str',
        'description_gte': 'str',
        'description_in': 'list[str]',
        'description_lt': 'str',
        'description_lte': 'str',
        'description_not': 'str',
        'description_not_contains': 'str',
        'description_not_ends_with': 'str',
        'description_not_in': 'list[str]',
        'description_not_starts_with': 'str',
        'description_starts_with': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'kube_config': 'str',
        'kube_config_contains': 'str',
        'kube_config_ends_with': 'str',
        'kube_config_gt': 'str',
        'kube_config_gte': 'str',
        'kube_config_in': 'list[str]',
        'kube_config_lt': 'str',
        'kube_config_lte': 'str',
        'kube_config_not': 'str',
        'kube_config_not_contains': 'str',
        'kube_config_not_ends_with': 'str',
        'kube_config_not_in': 'list[str]',
        'kube_config_not_starts_with': 'str',
        'kube_config_starts_with': 'str',
        'management_network_gateway': 'str',
        'management_network_gateway_contains': 'str',
        'management_network_gateway_ends_with': 'str',
        'management_network_gateway_gt': 'str',
        'management_network_gateway_gte': 'str',
        'management_network_gateway_in': 'list[str]',
        'management_network_gateway_lt': 'str',
        'management_network_gateway_lte': 'str',
        'management_network_gateway_not': 'str',
        'management_network_gateway_not_contains': 'str',
        'management_network_gateway_not_ends_with': 'str',
        'management_network_gateway_not_in': 'list[str]',
        'management_network_gateway_not_starts_with': 'str',
        'management_network_gateway_starts_with': 'str',
        'management_network_ip': 'str',
        'management_network_ip_contains': 'str',
        'management_network_ip_ends_with': 'str',
        'management_network_ip_gt': 'str',
        'management_network_ip_gte': 'str',
        'management_network_ip_in': 'list[str]',
        'management_network_ip_lt': 'str',
        'management_network_ip_lte': 'str',
        'management_network_ip_not': 'str',
        'management_network_ip_not_contains': 'str',
        'management_network_ip_not_ends_with': 'str',
        'management_network_ip_not_in': 'list[str]',
        'management_network_ip_not_starts_with': 'str',
        'management_network_ip_starts_with': 'str',
        'management_network_subnet_mask': 'str',
        'management_network_subnet_mask_contains': 'str',
        'management_network_subnet_mask_ends_with': 'str',
        'management_network_subnet_mask_gt': 'str',
        'management_network_subnet_mask_gte': 'str',
        'management_network_subnet_mask_in': 'list[str]',
        'management_network_subnet_mask_lt': 'str',
        'management_network_subnet_mask_lte': 'str',
        'management_network_subnet_mask_not': 'str',
        'management_network_subnet_mask_not_contains': 'str',
        'management_network_subnet_mask_not_ends_with': 'str',
        'management_network_subnet_mask_not_in': 'list[str]',
        'management_network_subnet_mask_not_starts_with': 'str',
        'management_network_subnet_mask_starts_with': 'str',
        'management_network_vlan': 'str',
        'management_network_vlan_contains': 'str',
        'management_network_vlan_ends_with': 'str',
        'management_network_vlan_gt': 'str',
        'management_network_vlan_gte': 'str',
        'management_network_vlan_in': 'list[str]',
        'management_network_vlan_lt': 'str',
        'management_network_vlan_lte': 'str',
        'management_network_vlan_not': 'str',
        'management_network_vlan_not_contains': 'str',
        'management_network_vlan_not_ends_with': 'str',
        'management_network_vlan_not_in': 'list[str]',
        'management_network_vlan_not_starts_with': 'str',
        'management_network_vlan_starts_with': 'str',
        'max_job_retry_times': 'int',
        'max_job_retry_times_gt': 'int',
        'max_job_retry_times_gte': 'int',
        'max_job_retry_times_in': 'list[int]',
        'max_job_retry_times_lt': 'int',
        'max_job_retry_times_lte': 'int',
        'max_job_retry_times_not': 'int',
        'max_job_retry_times_not_in': 'list[int]',
        'max_parallel_backup_jobs': 'int',
        'max_parallel_backup_jobs_gt': 'int',
        'max_parallel_backup_jobs_gte': 'int',
        'max_parallel_backup_jobs_in': 'list[int]',
        'max_parallel_backup_jobs_lt': 'int',
        'max_parallel_backup_jobs_lte': 'int',
        'max_parallel_backup_jobs_not': 'int',
        'max_parallel_backup_jobs_not_in': 'list[int]',
        'max_parallel_restore_jobs': 'int',
        'max_parallel_restore_jobs_gt': 'int',
        'max_parallel_restore_jobs_gte': 'int',
        'max_parallel_restore_jobs_in': 'list[int]',
        'max_parallel_restore_jobs_lt': 'int',
        'max_parallel_restore_jobs_lte': 'int',
        'max_parallel_restore_jobs_not': 'int',
        'max_parallel_restore_jobs_not_in': 'list[int]',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'restore_rd_iops_max': 'int',
        'restore_rd_iops_max_gt': 'int',
        'restore_rd_iops_max_gte': 'int',
        'restore_rd_iops_max_in': 'list[int]',
        'restore_rd_iops_max_lt': 'int',
        'restore_rd_iops_max_lte': 'int',
        'restore_rd_iops_max_not': 'int',
        'restore_rd_iops_max_not_in': 'list[int]',
        'restore_wr_iops_max': 'int',
        'restore_wr_iops_max_gt': 'int',
        'restore_wr_iops_max_gte': 'int',
        'restore_wr_iops_max_in': 'list[int]',
        'restore_wr_iops_max_lt': 'int',
        'restore_wr_iops_max_lte': 'int',
        'restore_wr_iops_max_not': 'int',
        'restore_wr_iops_max_not_in': 'list[int]',
        'retry_interval': 'int',
        'retry_interval_gt': 'int',
        'retry_interval_gte': 'int',
        'retry_interval_in': 'list[int]',
        'retry_interval_lt': 'int',
        'retry_interval_lte': 'int',
        'retry_interval_not': 'int',
        'retry_interval_not_in': 'list[int]',
        'running_vm': 'VmWhereInput',
        'status': 'BackupServiceStatus',
        'status_in': 'list[BackupServiceStatus]',
        'status_not': 'BackupServiceStatus',
        'status_not_in': 'list[BackupServiceStatus]',
        'storage_network_gateway': 'str',
        'storage_network_gateway_contains': 'str',
        'storage_network_gateway_ends_with': 'str',
        'storage_network_gateway_gt': 'str',
        'storage_network_gateway_gte': 'str',
        'storage_network_gateway_in': 'list[str]',
        'storage_network_gateway_lt': 'str',
        'storage_network_gateway_lte': 'str',
        'storage_network_gateway_not': 'str',
        'storage_network_gateway_not_contains': 'str',
        'storage_network_gateway_not_ends_with': 'str',
        'storage_network_gateway_not_in': 'list[str]',
        'storage_network_gateway_not_starts_with': 'str',
        'storage_network_gateway_starts_with': 'str',
        'storage_network_ip': 'str',
        'storage_network_ip_contains': 'str',
        'storage_network_ip_ends_with': 'str',
        'storage_network_ip_gt': 'str',
        'storage_network_ip_gte': 'str',
        'storage_network_ip_in': 'list[str]',
        'storage_network_ip_lt': 'str',
        'storage_network_ip_lte': 'str',
        'storage_network_ip_not': 'str',
        'storage_network_ip_not_contains': 'str',
        'storage_network_ip_not_ends_with': 'str',
        'storage_network_ip_not_in': 'list[str]',
        'storage_network_ip_not_starts_with': 'str',
        'storage_network_ip_starts_with': 'str',
        'storage_network_subnet_mask': 'str',
        'storage_network_subnet_mask_contains': 'str',
        'storage_network_subnet_mask_ends_with': 'str',
        'storage_network_subnet_mask_gt': 'str',
        'storage_network_subnet_mask_gte': 'str',
        'storage_network_subnet_mask_in': 'list[str]',
        'storage_network_subnet_mask_lt': 'str',
        'storage_network_subnet_mask_lte': 'str',
        'storage_network_subnet_mask_not': 'str',
        'storage_network_subnet_mask_not_contains': 'str',
        'storage_network_subnet_mask_not_ends_with': 'str',
        'storage_network_subnet_mask_not_in': 'list[str]',
        'storage_network_subnet_mask_not_starts_with': 'str',
        'storage_network_subnet_mask_starts_with': 'str',
        'storage_network_type': 'BackupServiceNetworkType',
        'storage_network_type_in': 'list[BackupServiceNetworkType]',
        'storage_network_type_not': 'BackupServiceNetworkType',
        'storage_network_type_not_in': 'list[BackupServiceNetworkType]',
        'storage_network_vlan': 'str',
        'storage_network_vlan_contains': 'str',
        'storage_network_vlan_ends_with': 'str',
        'storage_network_vlan_gt': 'str',
        'storage_network_vlan_gte': 'str',
        'storage_network_vlan_in': 'list[str]',
        'storage_network_vlan_lt': 'str',
        'storage_network_vlan_lte': 'str',
        'storage_network_vlan_not': 'str',
        'storage_network_vlan_not_contains': 'str',
        'storage_network_vlan_not_ends_with': 'str',
        'storage_network_vlan_not_in': 'list[str]',
        'storage_network_vlan_not_starts_with': 'str',
        'storage_network_vlan_starts_with': 'str'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'application': 'application',
        'backup_clusters_every': 'backup_clusters_every',
        'backup_clusters_none': 'backup_clusters_none',
        'backup_clusters_some': 'backup_clusters_some',
        'backup_network_gateway': 'backup_network_gateway',
        'backup_network_gateway_contains': 'backup_network_gateway_contains',
        'backup_network_gateway_ends_with': 'backup_network_gateway_ends_with',
        'backup_network_gateway_gt': 'backup_network_gateway_gt',
        'backup_network_gateway_gte': 'backup_network_gateway_gte',
        'backup_network_gateway_in': 'backup_network_gateway_in',
        'backup_network_gateway_lt': 'backup_network_gateway_lt',
        'backup_network_gateway_lte': 'backup_network_gateway_lte',
        'backup_network_gateway_not': 'backup_network_gateway_not',
        'backup_network_gateway_not_contains': 'backup_network_gateway_not_contains',
        'backup_network_gateway_not_ends_with': 'backup_network_gateway_not_ends_with',
        'backup_network_gateway_not_in': 'backup_network_gateway_not_in',
        'backup_network_gateway_not_starts_with': 'backup_network_gateway_not_starts_with',
        'backup_network_gateway_starts_with': 'backup_network_gateway_starts_with',
        'backup_network_ip': 'backup_network_ip',
        'backup_network_ip_contains': 'backup_network_ip_contains',
        'backup_network_ip_ends_with': 'backup_network_ip_ends_with',
        'backup_network_ip_gt': 'backup_network_ip_gt',
        'backup_network_ip_gte': 'backup_network_ip_gte',
        'backup_network_ip_in': 'backup_network_ip_in',
        'backup_network_ip_lt': 'backup_network_ip_lt',
        'backup_network_ip_lte': 'backup_network_ip_lte',
        'backup_network_ip_not': 'backup_network_ip_not',
        'backup_network_ip_not_contains': 'backup_network_ip_not_contains',
        'backup_network_ip_not_ends_with': 'backup_network_ip_not_ends_with',
        'backup_network_ip_not_in': 'backup_network_ip_not_in',
        'backup_network_ip_not_starts_with': 'backup_network_ip_not_starts_with',
        'backup_network_ip_starts_with': 'backup_network_ip_starts_with',
        'backup_network_subnet_mask': 'backup_network_subnet_mask',
        'backup_network_subnet_mask_contains': 'backup_network_subnet_mask_contains',
        'backup_network_subnet_mask_ends_with': 'backup_network_subnet_mask_ends_with',
        'backup_network_subnet_mask_gt': 'backup_network_subnet_mask_gt',
        'backup_network_subnet_mask_gte': 'backup_network_subnet_mask_gte',
        'backup_network_subnet_mask_in': 'backup_network_subnet_mask_in',
        'backup_network_subnet_mask_lt': 'backup_network_subnet_mask_lt',
        'backup_network_subnet_mask_lte': 'backup_network_subnet_mask_lte',
        'backup_network_subnet_mask_not': 'backup_network_subnet_mask_not',
        'backup_network_subnet_mask_not_contains': 'backup_network_subnet_mask_not_contains',
        'backup_network_subnet_mask_not_ends_with': 'backup_network_subnet_mask_not_ends_with',
        'backup_network_subnet_mask_not_in': 'backup_network_subnet_mask_not_in',
        'backup_network_subnet_mask_not_starts_with': 'backup_network_subnet_mask_not_starts_with',
        'backup_network_subnet_mask_starts_with': 'backup_network_subnet_mask_starts_with',
        'backup_network_type': 'backup_network_type',
        'backup_network_type_in': 'backup_network_type_in',
        'backup_network_type_not': 'backup_network_type_not',
        'backup_network_type_not_in': 'backup_network_type_not_in',
        'backup_network_vlan': 'backup_network_vlan',
        'backup_network_vlan_contains': 'backup_network_vlan_contains',
        'backup_network_vlan_ends_with': 'backup_network_vlan_ends_with',
        'backup_network_vlan_gt': 'backup_network_vlan_gt',
        'backup_network_vlan_gte': 'backup_network_vlan_gte',
        'backup_network_vlan_in': 'backup_network_vlan_in',
        'backup_network_vlan_lt': 'backup_network_vlan_lt',
        'backup_network_vlan_lte': 'backup_network_vlan_lte',
        'backup_network_vlan_not': 'backup_network_vlan_not',
        'backup_network_vlan_not_contains': 'backup_network_vlan_not_contains',
        'backup_network_vlan_not_ends_with': 'backup_network_vlan_not_ends_with',
        'backup_network_vlan_not_in': 'backup_network_vlan_not_in',
        'backup_network_vlan_not_starts_with': 'backup_network_vlan_not_starts_with',
        'backup_network_vlan_starts_with': 'backup_network_vlan_starts_with',
        'backup_plans_every': 'backup_plans_every',
        'backup_plans_none': 'backup_plans_none',
        'backup_plans_some': 'backup_plans_some',
        'backup_rd_iops_max': 'backup_rd_iops_max',
        'backup_rd_iops_max_gt': 'backup_rd_iops_max_gt',
        'backup_rd_iops_max_gte': 'backup_rd_iops_max_gte',
        'backup_rd_iops_max_in': 'backup_rd_iops_max_in',
        'backup_rd_iops_max_lt': 'backup_rd_iops_max_lt',
        'backup_rd_iops_max_lte': 'backup_rd_iops_max_lte',
        'backup_rd_iops_max_not': 'backup_rd_iops_max_not',
        'backup_rd_iops_max_not_in': 'backup_rd_iops_max_not_in',
        'backup_store_repositories_every': 'backup_store_repositories_every',
        'backup_store_repositories_none': 'backup_store_repositories_none',
        'backup_store_repositories_some': 'backup_store_repositories_some',
        'backup_wr_iops_max': 'backup_wr_iops_max',
        'backup_wr_iops_max_gt': 'backup_wr_iops_max_gt',
        'backup_wr_iops_max_gte': 'backup_wr_iops_max_gte',
        'backup_wr_iops_max_in': 'backup_wr_iops_max_in',
        'backup_wr_iops_max_lt': 'backup_wr_iops_max_lt',
        'backup_wr_iops_max_lte': 'backup_wr_iops_max_lte',
        'backup_wr_iops_max_not': 'backup_wr_iops_max_not',
        'backup_wr_iops_max_not_in': 'backup_wr_iops_max_not_in',
        'description': 'description',
        'description_contains': 'description_contains',
        'description_ends_with': 'description_ends_with',
        'description_gt': 'description_gt',
        'description_gte': 'description_gte',
        'description_in': 'description_in',
        'description_lt': 'description_lt',
        'description_lte': 'description_lte',
        'description_not': 'description_not',
        'description_not_contains': 'description_not_contains',
        'description_not_ends_with': 'description_not_ends_with',
        'description_not_in': 'description_not_in',
        'description_not_starts_with': 'description_not_starts_with',
        'description_starts_with': 'description_starts_with',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'kube_config': 'kube_config',
        'kube_config_contains': 'kube_config_contains',
        'kube_config_ends_with': 'kube_config_ends_with',
        'kube_config_gt': 'kube_config_gt',
        'kube_config_gte': 'kube_config_gte',
        'kube_config_in': 'kube_config_in',
        'kube_config_lt': 'kube_config_lt',
        'kube_config_lte': 'kube_config_lte',
        'kube_config_not': 'kube_config_not',
        'kube_config_not_contains': 'kube_config_not_contains',
        'kube_config_not_ends_with': 'kube_config_not_ends_with',
        'kube_config_not_in': 'kube_config_not_in',
        'kube_config_not_starts_with': 'kube_config_not_starts_with',
        'kube_config_starts_with': 'kube_config_starts_with',
        'management_network_gateway': 'management_network_gateway',
        'management_network_gateway_contains': 'management_network_gateway_contains',
        'management_network_gateway_ends_with': 'management_network_gateway_ends_with',
        'management_network_gateway_gt': 'management_network_gateway_gt',
        'management_network_gateway_gte': 'management_network_gateway_gte',
        'management_network_gateway_in': 'management_network_gateway_in',
        'management_network_gateway_lt': 'management_network_gateway_lt',
        'management_network_gateway_lte': 'management_network_gateway_lte',
        'management_network_gateway_not': 'management_network_gateway_not',
        'management_network_gateway_not_contains': 'management_network_gateway_not_contains',
        'management_network_gateway_not_ends_with': 'management_network_gateway_not_ends_with',
        'management_network_gateway_not_in': 'management_network_gateway_not_in',
        'management_network_gateway_not_starts_with': 'management_network_gateway_not_starts_with',
        'management_network_gateway_starts_with': 'management_network_gateway_starts_with',
        'management_network_ip': 'management_network_ip',
        'management_network_ip_contains': 'management_network_ip_contains',
        'management_network_ip_ends_with': 'management_network_ip_ends_with',
        'management_network_ip_gt': 'management_network_ip_gt',
        'management_network_ip_gte': 'management_network_ip_gte',
        'management_network_ip_in': 'management_network_ip_in',
        'management_network_ip_lt': 'management_network_ip_lt',
        'management_network_ip_lte': 'management_network_ip_lte',
        'management_network_ip_not': 'management_network_ip_not',
        'management_network_ip_not_contains': 'management_network_ip_not_contains',
        'management_network_ip_not_ends_with': 'management_network_ip_not_ends_with',
        'management_network_ip_not_in': 'management_network_ip_not_in',
        'management_network_ip_not_starts_with': 'management_network_ip_not_starts_with',
        'management_network_ip_starts_with': 'management_network_ip_starts_with',
        'management_network_subnet_mask': 'management_network_subnet_mask',
        'management_network_subnet_mask_contains': 'management_network_subnet_mask_contains',
        'management_network_subnet_mask_ends_with': 'management_network_subnet_mask_ends_with',
        'management_network_subnet_mask_gt': 'management_network_subnet_mask_gt',
        'management_network_subnet_mask_gte': 'management_network_subnet_mask_gte',
        'management_network_subnet_mask_in': 'management_network_subnet_mask_in',
        'management_network_subnet_mask_lt': 'management_network_subnet_mask_lt',
        'management_network_subnet_mask_lte': 'management_network_subnet_mask_lte',
        'management_network_subnet_mask_not': 'management_network_subnet_mask_not',
        'management_network_subnet_mask_not_contains': 'management_network_subnet_mask_not_contains',
        'management_network_subnet_mask_not_ends_with': 'management_network_subnet_mask_not_ends_with',
        'management_network_subnet_mask_not_in': 'management_network_subnet_mask_not_in',
        'management_network_subnet_mask_not_starts_with': 'management_network_subnet_mask_not_starts_with',
        'management_network_subnet_mask_starts_with': 'management_network_subnet_mask_starts_with',
        'management_network_vlan': 'management_network_vlan',
        'management_network_vlan_contains': 'management_network_vlan_contains',
        'management_network_vlan_ends_with': 'management_network_vlan_ends_with',
        'management_network_vlan_gt': 'management_network_vlan_gt',
        'management_network_vlan_gte': 'management_network_vlan_gte',
        'management_network_vlan_in': 'management_network_vlan_in',
        'management_network_vlan_lt': 'management_network_vlan_lt',
        'management_network_vlan_lte': 'management_network_vlan_lte',
        'management_network_vlan_not': 'management_network_vlan_not',
        'management_network_vlan_not_contains': 'management_network_vlan_not_contains',
        'management_network_vlan_not_ends_with': 'management_network_vlan_not_ends_with',
        'management_network_vlan_not_in': 'management_network_vlan_not_in',
        'management_network_vlan_not_starts_with': 'management_network_vlan_not_starts_with',
        'management_network_vlan_starts_with': 'management_network_vlan_starts_with',
        'max_job_retry_times': 'max_job_retry_times',
        'max_job_retry_times_gt': 'max_job_retry_times_gt',
        'max_job_retry_times_gte': 'max_job_retry_times_gte',
        'max_job_retry_times_in': 'max_job_retry_times_in',
        'max_job_retry_times_lt': 'max_job_retry_times_lt',
        'max_job_retry_times_lte': 'max_job_retry_times_lte',
        'max_job_retry_times_not': 'max_job_retry_times_not',
        'max_job_retry_times_not_in': 'max_job_retry_times_not_in',
        'max_parallel_backup_jobs': 'max_parallel_backup_jobs',
        'max_parallel_backup_jobs_gt': 'max_parallel_backup_jobs_gt',
        'max_parallel_backup_jobs_gte': 'max_parallel_backup_jobs_gte',
        'max_parallel_backup_jobs_in': 'max_parallel_backup_jobs_in',
        'max_parallel_backup_jobs_lt': 'max_parallel_backup_jobs_lt',
        'max_parallel_backup_jobs_lte': 'max_parallel_backup_jobs_lte',
        'max_parallel_backup_jobs_not': 'max_parallel_backup_jobs_not',
        'max_parallel_backup_jobs_not_in': 'max_parallel_backup_jobs_not_in',
        'max_parallel_restore_jobs': 'max_parallel_restore_jobs',
        'max_parallel_restore_jobs_gt': 'max_parallel_restore_jobs_gt',
        'max_parallel_restore_jobs_gte': 'max_parallel_restore_jobs_gte',
        'max_parallel_restore_jobs_in': 'max_parallel_restore_jobs_in',
        'max_parallel_restore_jobs_lt': 'max_parallel_restore_jobs_lt',
        'max_parallel_restore_jobs_lte': 'max_parallel_restore_jobs_lte',
        'max_parallel_restore_jobs_not': 'max_parallel_restore_jobs_not',
        'max_parallel_restore_jobs_not_in': 'max_parallel_restore_jobs_not_in',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'restore_rd_iops_max': 'restore_rd_iops_max',
        'restore_rd_iops_max_gt': 'restore_rd_iops_max_gt',
        'restore_rd_iops_max_gte': 'restore_rd_iops_max_gte',
        'restore_rd_iops_max_in': 'restore_rd_iops_max_in',
        'restore_rd_iops_max_lt': 'restore_rd_iops_max_lt',
        'restore_rd_iops_max_lte': 'restore_rd_iops_max_lte',
        'restore_rd_iops_max_not': 'restore_rd_iops_max_not',
        'restore_rd_iops_max_not_in': 'restore_rd_iops_max_not_in',
        'restore_wr_iops_max': 'restore_wr_iops_max',
        'restore_wr_iops_max_gt': 'restore_wr_iops_max_gt',
        'restore_wr_iops_max_gte': 'restore_wr_iops_max_gte',
        'restore_wr_iops_max_in': 'restore_wr_iops_max_in',
        'restore_wr_iops_max_lt': 'restore_wr_iops_max_lt',
        'restore_wr_iops_max_lte': 'restore_wr_iops_max_lte',
        'restore_wr_iops_max_not': 'restore_wr_iops_max_not',
        'restore_wr_iops_max_not_in': 'restore_wr_iops_max_not_in',
        'retry_interval': 'retry_interval',
        'retry_interval_gt': 'retry_interval_gt',
        'retry_interval_gte': 'retry_interval_gte',
        'retry_interval_in': 'retry_interval_in',
        'retry_interval_lt': 'retry_interval_lt',
        'retry_interval_lte': 'retry_interval_lte',
        'retry_interval_not': 'retry_interval_not',
        'retry_interval_not_in': 'retry_interval_not_in',
        'running_vm': 'running_vm',
        'status': 'status',
        'status_in': 'status_in',
        'status_not': 'status_not',
        'status_not_in': 'status_not_in',
        'storage_network_gateway': 'storage_network_gateway',
        'storage_network_gateway_contains': 'storage_network_gateway_contains',
        'storage_network_gateway_ends_with': 'storage_network_gateway_ends_with',
        'storage_network_gateway_gt': 'storage_network_gateway_gt',
        'storage_network_gateway_gte': 'storage_network_gateway_gte',
        'storage_network_gateway_in': 'storage_network_gateway_in',
        'storage_network_gateway_lt': 'storage_network_gateway_lt',
        'storage_network_gateway_lte': 'storage_network_gateway_lte',
        'storage_network_gateway_not': 'storage_network_gateway_not',
        'storage_network_gateway_not_contains': 'storage_network_gateway_not_contains',
        'storage_network_gateway_not_ends_with': 'storage_network_gateway_not_ends_with',
        'storage_network_gateway_not_in': 'storage_network_gateway_not_in',
        'storage_network_gateway_not_starts_with': 'storage_network_gateway_not_starts_with',
        'storage_network_gateway_starts_with': 'storage_network_gateway_starts_with',
        'storage_network_ip': 'storage_network_ip',
        'storage_network_ip_contains': 'storage_network_ip_contains',
        'storage_network_ip_ends_with': 'storage_network_ip_ends_with',
        'storage_network_ip_gt': 'storage_network_ip_gt',
        'storage_network_ip_gte': 'storage_network_ip_gte',
        'storage_network_ip_in': 'storage_network_ip_in',
        'storage_network_ip_lt': 'storage_network_ip_lt',
        'storage_network_ip_lte': 'storage_network_ip_lte',
        'storage_network_ip_not': 'storage_network_ip_not',
        'storage_network_ip_not_contains': 'storage_network_ip_not_contains',
        'storage_network_ip_not_ends_with': 'storage_network_ip_not_ends_with',
        'storage_network_ip_not_in': 'storage_network_ip_not_in',
        'storage_network_ip_not_starts_with': 'storage_network_ip_not_starts_with',
        'storage_network_ip_starts_with': 'storage_network_ip_starts_with',
        'storage_network_subnet_mask': 'storage_network_subnet_mask',
        'storage_network_subnet_mask_contains': 'storage_network_subnet_mask_contains',
        'storage_network_subnet_mask_ends_with': 'storage_network_subnet_mask_ends_with',
        'storage_network_subnet_mask_gt': 'storage_network_subnet_mask_gt',
        'storage_network_subnet_mask_gte': 'storage_network_subnet_mask_gte',
        'storage_network_subnet_mask_in': 'storage_network_subnet_mask_in',
        'storage_network_subnet_mask_lt': 'storage_network_subnet_mask_lt',
        'storage_network_subnet_mask_lte': 'storage_network_subnet_mask_lte',
        'storage_network_subnet_mask_not': 'storage_network_subnet_mask_not',
        'storage_network_subnet_mask_not_contains': 'storage_network_subnet_mask_not_contains',
        'storage_network_subnet_mask_not_ends_with': 'storage_network_subnet_mask_not_ends_with',
        'storage_network_subnet_mask_not_in': 'storage_network_subnet_mask_not_in',
        'storage_network_subnet_mask_not_starts_with': 'storage_network_subnet_mask_not_starts_with',
        'storage_network_subnet_mask_starts_with': 'storage_network_subnet_mask_starts_with',
        'storage_network_type': 'storage_network_type',
        'storage_network_type_in': 'storage_network_type_in',
        'storage_network_type_not': 'storage_network_type_not',
        'storage_network_type_not_in': 'storage_network_type_not_in',
        'storage_network_vlan': 'storage_network_vlan',
        'storage_network_vlan_contains': 'storage_network_vlan_contains',
        'storage_network_vlan_ends_with': 'storage_network_vlan_ends_with',
        'storage_network_vlan_gt': 'storage_network_vlan_gt',
        'storage_network_vlan_gte': 'storage_network_vlan_gte',
        'storage_network_vlan_in': 'storage_network_vlan_in',
        'storage_network_vlan_lt': 'storage_network_vlan_lt',
        'storage_network_vlan_lte': 'storage_network_vlan_lte',
        'storage_network_vlan_not': 'storage_network_vlan_not',
        'storage_network_vlan_not_contains': 'storage_network_vlan_not_contains',
        'storage_network_vlan_not_ends_with': 'storage_network_vlan_not_ends_with',
        'storage_network_vlan_not_in': 'storage_network_vlan_not_in',
        'storage_network_vlan_not_starts_with': 'storage_network_vlan_not_starts_with',
        'storage_network_vlan_starts_with': 'storage_network_vlan_starts_with'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupServiceWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._application = None
        self._backup_clusters_every = None
        self._backup_clusters_none = None
        self._backup_clusters_some = None
        self._backup_network_gateway = None
        self._backup_network_gateway_contains = None
        self._backup_network_gateway_ends_with = None
        self._backup_network_gateway_gt = None
        self._backup_network_gateway_gte = None
        self._backup_network_gateway_in = None
        self._backup_network_gateway_lt = None
        self._backup_network_gateway_lte = None
        self._backup_network_gateway_not = None
        self._backup_network_gateway_not_contains = None
        self._backup_network_gateway_not_ends_with = None
        self._backup_network_gateway_not_in = None
        self._backup_network_gateway_not_starts_with = None
        self._backup_network_gateway_starts_with = None
        self._backup_network_ip = None
        self._backup_network_ip_contains = None
        self._backup_network_ip_ends_with = None
        self._backup_network_ip_gt = None
        self._backup_network_ip_gte = None
        self._backup_network_ip_in = None
        self._backup_network_ip_lt = None
        self._backup_network_ip_lte = None
        self._backup_network_ip_not = None
        self._backup_network_ip_not_contains = None
        self._backup_network_ip_not_ends_with = None
        self._backup_network_ip_not_in = None
        self._backup_network_ip_not_starts_with = None
        self._backup_network_ip_starts_with = None
        self._backup_network_subnet_mask = None
        self._backup_network_subnet_mask_contains = None
        self._backup_network_subnet_mask_ends_with = None
        self._backup_network_subnet_mask_gt = None
        self._backup_network_subnet_mask_gte = None
        self._backup_network_subnet_mask_in = None
        self._backup_network_subnet_mask_lt = None
        self._backup_network_subnet_mask_lte = None
        self._backup_network_subnet_mask_not = None
        self._backup_network_subnet_mask_not_contains = None
        self._backup_network_subnet_mask_not_ends_with = None
        self._backup_network_subnet_mask_not_in = None
        self._backup_network_subnet_mask_not_starts_with = None
        self._backup_network_subnet_mask_starts_with = None
        self._backup_network_type = None
        self._backup_network_type_in = None
        self._backup_network_type_not = None
        self._backup_network_type_not_in = None
        self._backup_network_vlan = None
        self._backup_network_vlan_contains = None
        self._backup_network_vlan_ends_with = None
        self._backup_network_vlan_gt = None
        self._backup_network_vlan_gte = None
        self._backup_network_vlan_in = None
        self._backup_network_vlan_lt = None
        self._backup_network_vlan_lte = None
        self._backup_network_vlan_not = None
        self._backup_network_vlan_not_contains = None
        self._backup_network_vlan_not_ends_with = None
        self._backup_network_vlan_not_in = None
        self._backup_network_vlan_not_starts_with = None
        self._backup_network_vlan_starts_with = None
        self._backup_plans_every = None
        self._backup_plans_none = None
        self._backup_plans_some = None
        self._backup_rd_iops_max = None
        self._backup_rd_iops_max_gt = None
        self._backup_rd_iops_max_gte = None
        self._backup_rd_iops_max_in = None
        self._backup_rd_iops_max_lt = None
        self._backup_rd_iops_max_lte = None
        self._backup_rd_iops_max_not = None
        self._backup_rd_iops_max_not_in = None
        self._backup_store_repositories_every = None
        self._backup_store_repositories_none = None
        self._backup_store_repositories_some = None
        self._backup_wr_iops_max = None
        self._backup_wr_iops_max_gt = None
        self._backup_wr_iops_max_gte = None
        self._backup_wr_iops_max_in = None
        self._backup_wr_iops_max_lt = None
        self._backup_wr_iops_max_lte = None
        self._backup_wr_iops_max_not = None
        self._backup_wr_iops_max_not_in = None
        self._description = None
        self._description_contains = None
        self._description_ends_with = None
        self._description_gt = None
        self._description_gte = None
        self._description_in = None
        self._description_lt = None
        self._description_lte = None
        self._description_not = None
        self._description_not_contains = None
        self._description_not_ends_with = None
        self._description_not_in = None
        self._description_not_starts_with = None
        self._description_starts_with = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._kube_config = None
        self._kube_config_contains = None
        self._kube_config_ends_with = None
        self._kube_config_gt = None
        self._kube_config_gte = None
        self._kube_config_in = None
        self._kube_config_lt = None
        self._kube_config_lte = None
        self._kube_config_not = None
        self._kube_config_not_contains = None
        self._kube_config_not_ends_with = None
        self._kube_config_not_in = None
        self._kube_config_not_starts_with = None
        self._kube_config_starts_with = None
        self._management_network_gateway = None
        self._management_network_gateway_contains = None
        self._management_network_gateway_ends_with = None
        self._management_network_gateway_gt = None
        self._management_network_gateway_gte = None
        self._management_network_gateway_in = None
        self._management_network_gateway_lt = None
        self._management_network_gateway_lte = None
        self._management_network_gateway_not = None
        self._management_network_gateway_not_contains = None
        self._management_network_gateway_not_ends_with = None
        self._management_network_gateway_not_in = None
        self._management_network_gateway_not_starts_with = None
        self._management_network_gateway_starts_with = None
        self._management_network_ip = None
        self._management_network_ip_contains = None
        self._management_network_ip_ends_with = None
        self._management_network_ip_gt = None
        self._management_network_ip_gte = None
        self._management_network_ip_in = None
        self._management_network_ip_lt = None
        self._management_network_ip_lte = None
        self._management_network_ip_not = None
        self._management_network_ip_not_contains = None
        self._management_network_ip_not_ends_with = None
        self._management_network_ip_not_in = None
        self._management_network_ip_not_starts_with = None
        self._management_network_ip_starts_with = None
        self._management_network_subnet_mask = None
        self._management_network_subnet_mask_contains = None
        self._management_network_subnet_mask_ends_with = None
        self._management_network_subnet_mask_gt = None
        self._management_network_subnet_mask_gte = None
        self._management_network_subnet_mask_in = None
        self._management_network_subnet_mask_lt = None
        self._management_network_subnet_mask_lte = None
        self._management_network_subnet_mask_not = None
        self._management_network_subnet_mask_not_contains = None
        self._management_network_subnet_mask_not_ends_with = None
        self._management_network_subnet_mask_not_in = None
        self._management_network_subnet_mask_not_starts_with = None
        self._management_network_subnet_mask_starts_with = None
        self._management_network_vlan = None
        self._management_network_vlan_contains = None
        self._management_network_vlan_ends_with = None
        self._management_network_vlan_gt = None
        self._management_network_vlan_gte = None
        self._management_network_vlan_in = None
        self._management_network_vlan_lt = None
        self._management_network_vlan_lte = None
        self._management_network_vlan_not = None
        self._management_network_vlan_not_contains = None
        self._management_network_vlan_not_ends_with = None
        self._management_network_vlan_not_in = None
        self._management_network_vlan_not_starts_with = None
        self._management_network_vlan_starts_with = None
        self._max_job_retry_times = None
        self._max_job_retry_times_gt = None
        self._max_job_retry_times_gte = None
        self._max_job_retry_times_in = None
        self._max_job_retry_times_lt = None
        self._max_job_retry_times_lte = None
        self._max_job_retry_times_not = None
        self._max_job_retry_times_not_in = None
        self._max_parallel_backup_jobs = None
        self._max_parallel_backup_jobs_gt = None
        self._max_parallel_backup_jobs_gte = None
        self._max_parallel_backup_jobs_in = None
        self._max_parallel_backup_jobs_lt = None
        self._max_parallel_backup_jobs_lte = None
        self._max_parallel_backup_jobs_not = None
        self._max_parallel_backup_jobs_not_in = None
        self._max_parallel_restore_jobs = None
        self._max_parallel_restore_jobs_gt = None
        self._max_parallel_restore_jobs_gte = None
        self._max_parallel_restore_jobs_in = None
        self._max_parallel_restore_jobs_lt = None
        self._max_parallel_restore_jobs_lte = None
        self._max_parallel_restore_jobs_not = None
        self._max_parallel_restore_jobs_not_in = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._restore_rd_iops_max = None
        self._restore_rd_iops_max_gt = None
        self._restore_rd_iops_max_gte = None
        self._restore_rd_iops_max_in = None
        self._restore_rd_iops_max_lt = None
        self._restore_rd_iops_max_lte = None
        self._restore_rd_iops_max_not = None
        self._restore_rd_iops_max_not_in = None
        self._restore_wr_iops_max = None
        self._restore_wr_iops_max_gt = None
        self._restore_wr_iops_max_gte = None
        self._restore_wr_iops_max_in = None
        self._restore_wr_iops_max_lt = None
        self._restore_wr_iops_max_lte = None
        self._restore_wr_iops_max_not = None
        self._restore_wr_iops_max_not_in = None
        self._retry_interval = None
        self._retry_interval_gt = None
        self._retry_interval_gte = None
        self._retry_interval_in = None
        self._retry_interval_lt = None
        self._retry_interval_lte = None
        self._retry_interval_not = None
        self._retry_interval_not_in = None
        self._running_vm = None
        self._status = None
        self._status_in = None
        self._status_not = None
        self._status_not_in = None
        self._storage_network_gateway = None
        self._storage_network_gateway_contains = None
        self._storage_network_gateway_ends_with = None
        self._storage_network_gateway_gt = None
        self._storage_network_gateway_gte = None
        self._storage_network_gateway_in = None
        self._storage_network_gateway_lt = None
        self._storage_network_gateway_lte = None
        self._storage_network_gateway_not = None
        self._storage_network_gateway_not_contains = None
        self._storage_network_gateway_not_ends_with = None
        self._storage_network_gateway_not_in = None
        self._storage_network_gateway_not_starts_with = None
        self._storage_network_gateway_starts_with = None
        self._storage_network_ip = None
        self._storage_network_ip_contains = None
        self._storage_network_ip_ends_with = None
        self._storage_network_ip_gt = None
        self._storage_network_ip_gte = None
        self._storage_network_ip_in = None
        self._storage_network_ip_lt = None
        self._storage_network_ip_lte = None
        self._storage_network_ip_not = None
        self._storage_network_ip_not_contains = None
        self._storage_network_ip_not_ends_with = None
        self._storage_network_ip_not_in = None
        self._storage_network_ip_not_starts_with = None
        self._storage_network_ip_starts_with = None
        self._storage_network_subnet_mask = None
        self._storage_network_subnet_mask_contains = None
        self._storage_network_subnet_mask_ends_with = None
        self._storage_network_subnet_mask_gt = None
        self._storage_network_subnet_mask_gte = None
        self._storage_network_subnet_mask_in = None
        self._storage_network_subnet_mask_lt = None
        self._storage_network_subnet_mask_lte = None
        self._storage_network_subnet_mask_not = None
        self._storage_network_subnet_mask_not_contains = None
        self._storage_network_subnet_mask_not_ends_with = None
        self._storage_network_subnet_mask_not_in = None
        self._storage_network_subnet_mask_not_starts_with = None
        self._storage_network_subnet_mask_starts_with = None
        self._storage_network_type = None
        self._storage_network_type_in = None
        self._storage_network_type_not = None
        self._storage_network_type_not_in = None
        self._storage_network_vlan = None
        self._storage_network_vlan_contains = None
        self._storage_network_vlan_ends_with = None
        self._storage_network_vlan_gt = None
        self._storage_network_vlan_gte = None
        self._storage_network_vlan_in = None
        self._storage_network_vlan_lt = None
        self._storage_network_vlan_lte = None
        self._storage_network_vlan_not = None
        self._storage_network_vlan_not_contains = None
        self._storage_network_vlan_not_ends_with = None
        self._storage_network_vlan_not_in = None
        self._storage_network_vlan_not_starts_with = None
        self._storage_network_vlan_starts_with = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.application = kwargs.get("application", None)
        self.backup_clusters_every = kwargs.get("backup_clusters_every", None)
        self.backup_clusters_none = kwargs.get("backup_clusters_none", None)
        self.backup_clusters_some = kwargs.get("backup_clusters_some", None)
        self.backup_network_gateway = kwargs.get("backup_network_gateway", None)
        self.backup_network_gateway_contains = kwargs.get("backup_network_gateway_contains", None)
        self.backup_network_gateway_ends_with = kwargs.get("backup_network_gateway_ends_with", None)
        self.backup_network_gateway_gt = kwargs.get("backup_network_gateway_gt", None)
        self.backup_network_gateway_gte = kwargs.get("backup_network_gateway_gte", None)
        self.backup_network_gateway_in = kwargs.get("backup_network_gateway_in", None)
        self.backup_network_gateway_lt = kwargs.get("backup_network_gateway_lt", None)
        self.backup_network_gateway_lte = kwargs.get("backup_network_gateway_lte", None)
        self.backup_network_gateway_not = kwargs.get("backup_network_gateway_not", None)
        self.backup_network_gateway_not_contains = kwargs.get("backup_network_gateway_not_contains", None)
        self.backup_network_gateway_not_ends_with = kwargs.get("backup_network_gateway_not_ends_with", None)
        self.backup_network_gateway_not_in = kwargs.get("backup_network_gateway_not_in", None)
        self.backup_network_gateway_not_starts_with = kwargs.get("backup_network_gateway_not_starts_with", None)
        self.backup_network_gateway_starts_with = kwargs.get("backup_network_gateway_starts_with", None)
        self.backup_network_ip = kwargs.get("backup_network_ip", None)
        self.backup_network_ip_contains = kwargs.get("backup_network_ip_contains", None)
        self.backup_network_ip_ends_with = kwargs.get("backup_network_ip_ends_with", None)
        self.backup_network_ip_gt = kwargs.get("backup_network_ip_gt", None)
        self.backup_network_ip_gte = kwargs.get("backup_network_ip_gte", None)
        self.backup_network_ip_in = kwargs.get("backup_network_ip_in", None)
        self.backup_network_ip_lt = kwargs.get("backup_network_ip_lt", None)
        self.backup_network_ip_lte = kwargs.get("backup_network_ip_lte", None)
        self.backup_network_ip_not = kwargs.get("backup_network_ip_not", None)
        self.backup_network_ip_not_contains = kwargs.get("backup_network_ip_not_contains", None)
        self.backup_network_ip_not_ends_with = kwargs.get("backup_network_ip_not_ends_with", None)
        self.backup_network_ip_not_in = kwargs.get("backup_network_ip_not_in", None)
        self.backup_network_ip_not_starts_with = kwargs.get("backup_network_ip_not_starts_with", None)
        self.backup_network_ip_starts_with = kwargs.get("backup_network_ip_starts_with", None)
        self.backup_network_subnet_mask = kwargs.get("backup_network_subnet_mask", None)
        self.backup_network_subnet_mask_contains = kwargs.get("backup_network_subnet_mask_contains", None)
        self.backup_network_subnet_mask_ends_with = kwargs.get("backup_network_subnet_mask_ends_with", None)
        self.backup_network_subnet_mask_gt = kwargs.get("backup_network_subnet_mask_gt", None)
        self.backup_network_subnet_mask_gte = kwargs.get("backup_network_subnet_mask_gte", None)
        self.backup_network_subnet_mask_in = kwargs.get("backup_network_subnet_mask_in", None)
        self.backup_network_subnet_mask_lt = kwargs.get("backup_network_subnet_mask_lt", None)
        self.backup_network_subnet_mask_lte = kwargs.get("backup_network_subnet_mask_lte", None)
        self.backup_network_subnet_mask_not = kwargs.get("backup_network_subnet_mask_not", None)
        self.backup_network_subnet_mask_not_contains = kwargs.get("backup_network_subnet_mask_not_contains", None)
        self.backup_network_subnet_mask_not_ends_with = kwargs.get("backup_network_subnet_mask_not_ends_with", None)
        self.backup_network_subnet_mask_not_in = kwargs.get("backup_network_subnet_mask_not_in", None)
        self.backup_network_subnet_mask_not_starts_with = kwargs.get("backup_network_subnet_mask_not_starts_with", None)
        self.backup_network_subnet_mask_starts_with = kwargs.get("backup_network_subnet_mask_starts_with", None)
        self.backup_network_type = kwargs.get("backup_network_type", None)
        self.backup_network_type_in = kwargs.get("backup_network_type_in", None)
        self.backup_network_type_not = kwargs.get("backup_network_type_not", None)
        self.backup_network_type_not_in = kwargs.get("backup_network_type_not_in", None)
        self.backup_network_vlan = kwargs.get("backup_network_vlan", None)
        self.backup_network_vlan_contains = kwargs.get("backup_network_vlan_contains", None)
        self.backup_network_vlan_ends_with = kwargs.get("backup_network_vlan_ends_with", None)
        self.backup_network_vlan_gt = kwargs.get("backup_network_vlan_gt", None)
        self.backup_network_vlan_gte = kwargs.get("backup_network_vlan_gte", None)
        self.backup_network_vlan_in = kwargs.get("backup_network_vlan_in", None)
        self.backup_network_vlan_lt = kwargs.get("backup_network_vlan_lt", None)
        self.backup_network_vlan_lte = kwargs.get("backup_network_vlan_lte", None)
        self.backup_network_vlan_not = kwargs.get("backup_network_vlan_not", None)
        self.backup_network_vlan_not_contains = kwargs.get("backup_network_vlan_not_contains", None)
        self.backup_network_vlan_not_ends_with = kwargs.get("backup_network_vlan_not_ends_with", None)
        self.backup_network_vlan_not_in = kwargs.get("backup_network_vlan_not_in", None)
        self.backup_network_vlan_not_starts_with = kwargs.get("backup_network_vlan_not_starts_with", None)
        self.backup_network_vlan_starts_with = kwargs.get("backup_network_vlan_starts_with", None)
        self.backup_plans_every = kwargs.get("backup_plans_every", None)
        self.backup_plans_none = kwargs.get("backup_plans_none", None)
        self.backup_plans_some = kwargs.get("backup_plans_some", None)
        self.backup_rd_iops_max = kwargs.get("backup_rd_iops_max", None)
        self.backup_rd_iops_max_gt = kwargs.get("backup_rd_iops_max_gt", None)
        self.backup_rd_iops_max_gte = kwargs.get("backup_rd_iops_max_gte", None)
        self.backup_rd_iops_max_in = kwargs.get("backup_rd_iops_max_in", None)
        self.backup_rd_iops_max_lt = kwargs.get("backup_rd_iops_max_lt", None)
        self.backup_rd_iops_max_lte = kwargs.get("backup_rd_iops_max_lte", None)
        self.backup_rd_iops_max_not = kwargs.get("backup_rd_iops_max_not", None)
        self.backup_rd_iops_max_not_in = kwargs.get("backup_rd_iops_max_not_in", None)
        self.backup_store_repositories_every = kwargs.get("backup_store_repositories_every", None)
        self.backup_store_repositories_none = kwargs.get("backup_store_repositories_none", None)
        self.backup_store_repositories_some = kwargs.get("backup_store_repositories_some", None)
        self.backup_wr_iops_max = kwargs.get("backup_wr_iops_max", None)
        self.backup_wr_iops_max_gt = kwargs.get("backup_wr_iops_max_gt", None)
        self.backup_wr_iops_max_gte = kwargs.get("backup_wr_iops_max_gte", None)
        self.backup_wr_iops_max_in = kwargs.get("backup_wr_iops_max_in", None)
        self.backup_wr_iops_max_lt = kwargs.get("backup_wr_iops_max_lt", None)
        self.backup_wr_iops_max_lte = kwargs.get("backup_wr_iops_max_lte", None)
        self.backup_wr_iops_max_not = kwargs.get("backup_wr_iops_max_not", None)
        self.backup_wr_iops_max_not_in = kwargs.get("backup_wr_iops_max_not_in", None)
        self.description = kwargs.get("description", None)
        self.description_contains = kwargs.get("description_contains", None)
        self.description_ends_with = kwargs.get("description_ends_with", None)
        self.description_gt = kwargs.get("description_gt", None)
        self.description_gte = kwargs.get("description_gte", None)
        self.description_in = kwargs.get("description_in", None)
        self.description_lt = kwargs.get("description_lt", None)
        self.description_lte = kwargs.get("description_lte", None)
        self.description_not = kwargs.get("description_not", None)
        self.description_not_contains = kwargs.get("description_not_contains", None)
        self.description_not_ends_with = kwargs.get("description_not_ends_with", None)
        self.description_not_in = kwargs.get("description_not_in", None)
        self.description_not_starts_with = kwargs.get("description_not_starts_with", None)
        self.description_starts_with = kwargs.get("description_starts_with", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.kube_config = kwargs.get("kube_config", None)
        self.kube_config_contains = kwargs.get("kube_config_contains", None)
        self.kube_config_ends_with = kwargs.get("kube_config_ends_with", None)
        self.kube_config_gt = kwargs.get("kube_config_gt", None)
        self.kube_config_gte = kwargs.get("kube_config_gte", None)
        self.kube_config_in = kwargs.get("kube_config_in", None)
        self.kube_config_lt = kwargs.get("kube_config_lt", None)
        self.kube_config_lte = kwargs.get("kube_config_lte", None)
        self.kube_config_not = kwargs.get("kube_config_not", None)
        self.kube_config_not_contains = kwargs.get("kube_config_not_contains", None)
        self.kube_config_not_ends_with = kwargs.get("kube_config_not_ends_with", None)
        self.kube_config_not_in = kwargs.get("kube_config_not_in", None)
        self.kube_config_not_starts_with = kwargs.get("kube_config_not_starts_with", None)
        self.kube_config_starts_with = kwargs.get("kube_config_starts_with", None)
        self.management_network_gateway = kwargs.get("management_network_gateway", None)
        self.management_network_gateway_contains = kwargs.get("management_network_gateway_contains", None)
        self.management_network_gateway_ends_with = kwargs.get("management_network_gateway_ends_with", None)
        self.management_network_gateway_gt = kwargs.get("management_network_gateway_gt", None)
        self.management_network_gateway_gte = kwargs.get("management_network_gateway_gte", None)
        self.management_network_gateway_in = kwargs.get("management_network_gateway_in", None)
        self.management_network_gateway_lt = kwargs.get("management_network_gateway_lt", None)
        self.management_network_gateway_lte = kwargs.get("management_network_gateway_lte", None)
        self.management_network_gateway_not = kwargs.get("management_network_gateway_not", None)
        self.management_network_gateway_not_contains = kwargs.get("management_network_gateway_not_contains", None)
        self.management_network_gateway_not_ends_with = kwargs.get("management_network_gateway_not_ends_with", None)
        self.management_network_gateway_not_in = kwargs.get("management_network_gateway_not_in", None)
        self.management_network_gateway_not_starts_with = kwargs.get("management_network_gateway_not_starts_with", None)
        self.management_network_gateway_starts_with = kwargs.get("management_network_gateway_starts_with", None)
        self.management_network_ip = kwargs.get("management_network_ip", None)
        self.management_network_ip_contains = kwargs.get("management_network_ip_contains", None)
        self.management_network_ip_ends_with = kwargs.get("management_network_ip_ends_with", None)
        self.management_network_ip_gt = kwargs.get("management_network_ip_gt", None)
        self.management_network_ip_gte = kwargs.get("management_network_ip_gte", None)
        self.management_network_ip_in = kwargs.get("management_network_ip_in", None)
        self.management_network_ip_lt = kwargs.get("management_network_ip_lt", None)
        self.management_network_ip_lte = kwargs.get("management_network_ip_lte", None)
        self.management_network_ip_not = kwargs.get("management_network_ip_not", None)
        self.management_network_ip_not_contains = kwargs.get("management_network_ip_not_contains", None)
        self.management_network_ip_not_ends_with = kwargs.get("management_network_ip_not_ends_with", None)
        self.management_network_ip_not_in = kwargs.get("management_network_ip_not_in", None)
        self.management_network_ip_not_starts_with = kwargs.get("management_network_ip_not_starts_with", None)
        self.management_network_ip_starts_with = kwargs.get("management_network_ip_starts_with", None)
        self.management_network_subnet_mask = kwargs.get("management_network_subnet_mask", None)
        self.management_network_subnet_mask_contains = kwargs.get("management_network_subnet_mask_contains", None)
        self.management_network_subnet_mask_ends_with = kwargs.get("management_network_subnet_mask_ends_with", None)
        self.management_network_subnet_mask_gt = kwargs.get("management_network_subnet_mask_gt", None)
        self.management_network_subnet_mask_gte = kwargs.get("management_network_subnet_mask_gte", None)
        self.management_network_subnet_mask_in = kwargs.get("management_network_subnet_mask_in", None)
        self.management_network_subnet_mask_lt = kwargs.get("management_network_subnet_mask_lt", None)
        self.management_network_subnet_mask_lte = kwargs.get("management_network_subnet_mask_lte", None)
        self.management_network_subnet_mask_not = kwargs.get("management_network_subnet_mask_not", None)
        self.management_network_subnet_mask_not_contains = kwargs.get("management_network_subnet_mask_not_contains", None)
        self.management_network_subnet_mask_not_ends_with = kwargs.get("management_network_subnet_mask_not_ends_with", None)
        self.management_network_subnet_mask_not_in = kwargs.get("management_network_subnet_mask_not_in", None)
        self.management_network_subnet_mask_not_starts_with = kwargs.get("management_network_subnet_mask_not_starts_with", None)
        self.management_network_subnet_mask_starts_with = kwargs.get("management_network_subnet_mask_starts_with", None)
        self.management_network_vlan = kwargs.get("management_network_vlan", None)
        self.management_network_vlan_contains = kwargs.get("management_network_vlan_contains", None)
        self.management_network_vlan_ends_with = kwargs.get("management_network_vlan_ends_with", None)
        self.management_network_vlan_gt = kwargs.get("management_network_vlan_gt", None)
        self.management_network_vlan_gte = kwargs.get("management_network_vlan_gte", None)
        self.management_network_vlan_in = kwargs.get("management_network_vlan_in", None)
        self.management_network_vlan_lt = kwargs.get("management_network_vlan_lt", None)
        self.management_network_vlan_lte = kwargs.get("management_network_vlan_lte", None)
        self.management_network_vlan_not = kwargs.get("management_network_vlan_not", None)
        self.management_network_vlan_not_contains = kwargs.get("management_network_vlan_not_contains", None)
        self.management_network_vlan_not_ends_with = kwargs.get("management_network_vlan_not_ends_with", None)
        self.management_network_vlan_not_in = kwargs.get("management_network_vlan_not_in", None)
        self.management_network_vlan_not_starts_with = kwargs.get("management_network_vlan_not_starts_with", None)
        self.management_network_vlan_starts_with = kwargs.get("management_network_vlan_starts_with", None)
        self.max_job_retry_times = kwargs.get("max_job_retry_times", None)
        self.max_job_retry_times_gt = kwargs.get("max_job_retry_times_gt", None)
        self.max_job_retry_times_gte = kwargs.get("max_job_retry_times_gte", None)
        self.max_job_retry_times_in = kwargs.get("max_job_retry_times_in", None)
        self.max_job_retry_times_lt = kwargs.get("max_job_retry_times_lt", None)
        self.max_job_retry_times_lte = kwargs.get("max_job_retry_times_lte", None)
        self.max_job_retry_times_not = kwargs.get("max_job_retry_times_not", None)
        self.max_job_retry_times_not_in = kwargs.get("max_job_retry_times_not_in", None)
        self.max_parallel_backup_jobs = kwargs.get("max_parallel_backup_jobs", None)
        self.max_parallel_backup_jobs_gt = kwargs.get("max_parallel_backup_jobs_gt", None)
        self.max_parallel_backup_jobs_gte = kwargs.get("max_parallel_backup_jobs_gte", None)
        self.max_parallel_backup_jobs_in = kwargs.get("max_parallel_backup_jobs_in", None)
        self.max_parallel_backup_jobs_lt = kwargs.get("max_parallel_backup_jobs_lt", None)
        self.max_parallel_backup_jobs_lte = kwargs.get("max_parallel_backup_jobs_lte", None)
        self.max_parallel_backup_jobs_not = kwargs.get("max_parallel_backup_jobs_not", None)
        self.max_parallel_backup_jobs_not_in = kwargs.get("max_parallel_backup_jobs_not_in", None)
        self.max_parallel_restore_jobs = kwargs.get("max_parallel_restore_jobs", None)
        self.max_parallel_restore_jobs_gt = kwargs.get("max_parallel_restore_jobs_gt", None)
        self.max_parallel_restore_jobs_gte = kwargs.get("max_parallel_restore_jobs_gte", None)
        self.max_parallel_restore_jobs_in = kwargs.get("max_parallel_restore_jobs_in", None)
        self.max_parallel_restore_jobs_lt = kwargs.get("max_parallel_restore_jobs_lt", None)
        self.max_parallel_restore_jobs_lte = kwargs.get("max_parallel_restore_jobs_lte", None)
        self.max_parallel_restore_jobs_not = kwargs.get("max_parallel_restore_jobs_not", None)
        self.max_parallel_restore_jobs_not_in = kwargs.get("max_parallel_restore_jobs_not_in", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.restore_rd_iops_max = kwargs.get("restore_rd_iops_max", None)
        self.restore_rd_iops_max_gt = kwargs.get("restore_rd_iops_max_gt", None)
        self.restore_rd_iops_max_gte = kwargs.get("restore_rd_iops_max_gte", None)
        self.restore_rd_iops_max_in = kwargs.get("restore_rd_iops_max_in", None)
        self.restore_rd_iops_max_lt = kwargs.get("restore_rd_iops_max_lt", None)
        self.restore_rd_iops_max_lte = kwargs.get("restore_rd_iops_max_lte", None)
        self.restore_rd_iops_max_not = kwargs.get("restore_rd_iops_max_not", None)
        self.restore_rd_iops_max_not_in = kwargs.get("restore_rd_iops_max_not_in", None)
        self.restore_wr_iops_max = kwargs.get("restore_wr_iops_max", None)
        self.restore_wr_iops_max_gt = kwargs.get("restore_wr_iops_max_gt", None)
        self.restore_wr_iops_max_gte = kwargs.get("restore_wr_iops_max_gte", None)
        self.restore_wr_iops_max_in = kwargs.get("restore_wr_iops_max_in", None)
        self.restore_wr_iops_max_lt = kwargs.get("restore_wr_iops_max_lt", None)
        self.restore_wr_iops_max_lte = kwargs.get("restore_wr_iops_max_lte", None)
        self.restore_wr_iops_max_not = kwargs.get("restore_wr_iops_max_not", None)
        self.restore_wr_iops_max_not_in = kwargs.get("restore_wr_iops_max_not_in", None)
        self.retry_interval = kwargs.get("retry_interval", None)
        self.retry_interval_gt = kwargs.get("retry_interval_gt", None)
        self.retry_interval_gte = kwargs.get("retry_interval_gte", None)
        self.retry_interval_in = kwargs.get("retry_interval_in", None)
        self.retry_interval_lt = kwargs.get("retry_interval_lt", None)
        self.retry_interval_lte = kwargs.get("retry_interval_lte", None)
        self.retry_interval_not = kwargs.get("retry_interval_not", None)
        self.retry_interval_not_in = kwargs.get("retry_interval_not_in", None)
        self.running_vm = kwargs.get("running_vm", None)
        self.status = kwargs.get("status", None)
        self.status_in = kwargs.get("status_in", None)
        self.status_not = kwargs.get("status_not", None)
        self.status_not_in = kwargs.get("status_not_in", None)
        self.storage_network_gateway = kwargs.get("storage_network_gateway", None)
        self.storage_network_gateway_contains = kwargs.get("storage_network_gateway_contains", None)
        self.storage_network_gateway_ends_with = kwargs.get("storage_network_gateway_ends_with", None)
        self.storage_network_gateway_gt = kwargs.get("storage_network_gateway_gt", None)
        self.storage_network_gateway_gte = kwargs.get("storage_network_gateway_gte", None)
        self.storage_network_gateway_in = kwargs.get("storage_network_gateway_in", None)
        self.storage_network_gateway_lt = kwargs.get("storage_network_gateway_lt", None)
        self.storage_network_gateway_lte = kwargs.get("storage_network_gateway_lte", None)
        self.storage_network_gateway_not = kwargs.get("storage_network_gateway_not", None)
        self.storage_network_gateway_not_contains = kwargs.get("storage_network_gateway_not_contains", None)
        self.storage_network_gateway_not_ends_with = kwargs.get("storage_network_gateway_not_ends_with", None)
        self.storage_network_gateway_not_in = kwargs.get("storage_network_gateway_not_in", None)
        self.storage_network_gateway_not_starts_with = kwargs.get("storage_network_gateway_not_starts_with", None)
        self.storage_network_gateway_starts_with = kwargs.get("storage_network_gateway_starts_with", None)
        self.storage_network_ip = kwargs.get("storage_network_ip", None)
        self.storage_network_ip_contains = kwargs.get("storage_network_ip_contains", None)
        self.storage_network_ip_ends_with = kwargs.get("storage_network_ip_ends_with", None)
        self.storage_network_ip_gt = kwargs.get("storage_network_ip_gt", None)
        self.storage_network_ip_gte = kwargs.get("storage_network_ip_gte", None)
        self.storage_network_ip_in = kwargs.get("storage_network_ip_in", None)
        self.storage_network_ip_lt = kwargs.get("storage_network_ip_lt", None)
        self.storage_network_ip_lte = kwargs.get("storage_network_ip_lte", None)
        self.storage_network_ip_not = kwargs.get("storage_network_ip_not", None)
        self.storage_network_ip_not_contains = kwargs.get("storage_network_ip_not_contains", None)
        self.storage_network_ip_not_ends_with = kwargs.get("storage_network_ip_not_ends_with", None)
        self.storage_network_ip_not_in = kwargs.get("storage_network_ip_not_in", None)
        self.storage_network_ip_not_starts_with = kwargs.get("storage_network_ip_not_starts_with", None)
        self.storage_network_ip_starts_with = kwargs.get("storage_network_ip_starts_with", None)
        self.storage_network_subnet_mask = kwargs.get("storage_network_subnet_mask", None)
        self.storage_network_subnet_mask_contains = kwargs.get("storage_network_subnet_mask_contains", None)
        self.storage_network_subnet_mask_ends_with = kwargs.get("storage_network_subnet_mask_ends_with", None)
        self.storage_network_subnet_mask_gt = kwargs.get("storage_network_subnet_mask_gt", None)
        self.storage_network_subnet_mask_gte = kwargs.get("storage_network_subnet_mask_gte", None)
        self.storage_network_subnet_mask_in = kwargs.get("storage_network_subnet_mask_in", None)
        self.storage_network_subnet_mask_lt = kwargs.get("storage_network_subnet_mask_lt", None)
        self.storage_network_subnet_mask_lte = kwargs.get("storage_network_subnet_mask_lte", None)
        self.storage_network_subnet_mask_not = kwargs.get("storage_network_subnet_mask_not", None)
        self.storage_network_subnet_mask_not_contains = kwargs.get("storage_network_subnet_mask_not_contains", None)
        self.storage_network_subnet_mask_not_ends_with = kwargs.get("storage_network_subnet_mask_not_ends_with", None)
        self.storage_network_subnet_mask_not_in = kwargs.get("storage_network_subnet_mask_not_in", None)
        self.storage_network_subnet_mask_not_starts_with = kwargs.get("storage_network_subnet_mask_not_starts_with", None)
        self.storage_network_subnet_mask_starts_with = kwargs.get("storage_network_subnet_mask_starts_with", None)
        self.storage_network_type = kwargs.get("storage_network_type", None)
        self.storage_network_type_in = kwargs.get("storage_network_type_in", None)
        self.storage_network_type_not = kwargs.get("storage_network_type_not", None)
        self.storage_network_type_not_in = kwargs.get("storage_network_type_not_in", None)
        self.storage_network_vlan = kwargs.get("storage_network_vlan", None)
        self.storage_network_vlan_contains = kwargs.get("storage_network_vlan_contains", None)
        self.storage_network_vlan_ends_with = kwargs.get("storage_network_vlan_ends_with", None)
        self.storage_network_vlan_gt = kwargs.get("storage_network_vlan_gt", None)
        self.storage_network_vlan_gte = kwargs.get("storage_network_vlan_gte", None)
        self.storage_network_vlan_in = kwargs.get("storage_network_vlan_in", None)
        self.storage_network_vlan_lt = kwargs.get("storage_network_vlan_lt", None)
        self.storage_network_vlan_lte = kwargs.get("storage_network_vlan_lte", None)
        self.storage_network_vlan_not = kwargs.get("storage_network_vlan_not", None)
        self.storage_network_vlan_not_contains = kwargs.get("storage_network_vlan_not_contains", None)
        self.storage_network_vlan_not_ends_with = kwargs.get("storage_network_vlan_not_ends_with", None)
        self.storage_network_vlan_not_in = kwargs.get("storage_network_vlan_not_in", None)
        self.storage_network_vlan_not_starts_with = kwargs.get("storage_network_vlan_not_starts_with", None)
        self.storage_network_vlan_starts_with = kwargs.get("storage_network_vlan_starts_with", None)

    @property
    def _and(self):
        """Gets the _and of this BackupServiceWhereInput.  # noqa: E501


        :return: The _and of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[BackupServiceWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this BackupServiceWhereInput.


        :param _and: The _and of this BackupServiceWhereInput.  # noqa: E501
        :type _and: list[BackupServiceWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this BackupServiceWhereInput.  # noqa: E501


        :return: The _not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[BackupServiceWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this BackupServiceWhereInput.


        :param _not: The _not of this BackupServiceWhereInput.  # noqa: E501
        :type _not: list[BackupServiceWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this BackupServiceWhereInput.  # noqa: E501


        :return: The _or of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[BackupServiceWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this BackupServiceWhereInput.


        :param _or: The _or of this BackupServiceWhereInput.  # noqa: E501
        :type _or: list[BackupServiceWhereInput]
        """

        self.__or = _or

    @property
    def application(self):
        """Gets the application of this BackupServiceWhereInput.  # noqa: E501


        :return: The application of this BackupServiceWhereInput.  # noqa: E501
        :rtype: CloudTowerApplicationWhereInput
        """
        return self._application

    @application.setter
    def application(self, application):
        """Sets the application of this BackupServiceWhereInput.


        :param application: The application of this BackupServiceWhereInput.  # noqa: E501
        :type application: CloudTowerApplicationWhereInput
        """

        self._application = application

    @property
    def backup_clusters_every(self):
        """Gets the backup_clusters_every of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_clusters_every of this BackupServiceWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._backup_clusters_every

    @backup_clusters_every.setter
    def backup_clusters_every(self, backup_clusters_every):
        """Sets the backup_clusters_every of this BackupServiceWhereInput.


        :param backup_clusters_every: The backup_clusters_every of this BackupServiceWhereInput.  # noqa: E501
        :type backup_clusters_every: ClusterWhereInput
        """

        self._backup_clusters_every = backup_clusters_every

    @property
    def backup_clusters_none(self):
        """Gets the backup_clusters_none of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_clusters_none of this BackupServiceWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._backup_clusters_none

    @backup_clusters_none.setter
    def backup_clusters_none(self, backup_clusters_none):
        """Sets the backup_clusters_none of this BackupServiceWhereInput.


        :param backup_clusters_none: The backup_clusters_none of this BackupServiceWhereInput.  # noqa: E501
        :type backup_clusters_none: ClusterWhereInput
        """

        self._backup_clusters_none = backup_clusters_none

    @property
    def backup_clusters_some(self):
        """Gets the backup_clusters_some of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_clusters_some of this BackupServiceWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._backup_clusters_some

    @backup_clusters_some.setter
    def backup_clusters_some(self, backup_clusters_some):
        """Sets the backup_clusters_some of this BackupServiceWhereInput.


        :param backup_clusters_some: The backup_clusters_some of this BackupServiceWhereInput.  # noqa: E501
        :type backup_clusters_some: ClusterWhereInput
        """

        self._backup_clusters_some = backup_clusters_some

    @property
    def backup_network_gateway(self):
        """Gets the backup_network_gateway of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway

    @backup_network_gateway.setter
    def backup_network_gateway(self, backup_network_gateway):
        """Sets the backup_network_gateway of this BackupServiceWhereInput.


        :param backup_network_gateway: The backup_network_gateway of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway: str
        """

        self._backup_network_gateway = backup_network_gateway

    @property
    def backup_network_gateway_contains(self):
        """Gets the backup_network_gateway_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway_contains

    @backup_network_gateway_contains.setter
    def backup_network_gateway_contains(self, backup_network_gateway_contains):
        """Sets the backup_network_gateway_contains of this BackupServiceWhereInput.


        :param backup_network_gateway_contains: The backup_network_gateway_contains of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_contains: str
        """

        self._backup_network_gateway_contains = backup_network_gateway_contains

    @property
    def backup_network_gateway_ends_with(self):
        """Gets the backup_network_gateway_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway_ends_with

    @backup_network_gateway_ends_with.setter
    def backup_network_gateway_ends_with(self, backup_network_gateway_ends_with):
        """Sets the backup_network_gateway_ends_with of this BackupServiceWhereInput.


        :param backup_network_gateway_ends_with: The backup_network_gateway_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_ends_with: str
        """

        self._backup_network_gateway_ends_with = backup_network_gateway_ends_with

    @property
    def backup_network_gateway_gt(self):
        """Gets the backup_network_gateway_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway_gt

    @backup_network_gateway_gt.setter
    def backup_network_gateway_gt(self, backup_network_gateway_gt):
        """Sets the backup_network_gateway_gt of this BackupServiceWhereInput.


        :param backup_network_gateway_gt: The backup_network_gateway_gt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_gt: str
        """

        self._backup_network_gateway_gt = backup_network_gateway_gt

    @property
    def backup_network_gateway_gte(self):
        """Gets the backup_network_gateway_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway_gte

    @backup_network_gateway_gte.setter
    def backup_network_gateway_gte(self, backup_network_gateway_gte):
        """Sets the backup_network_gateway_gte of this BackupServiceWhereInput.


        :param backup_network_gateway_gte: The backup_network_gateway_gte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_gte: str
        """

        self._backup_network_gateway_gte = backup_network_gateway_gte

    @property
    def backup_network_gateway_in(self):
        """Gets the backup_network_gateway_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._backup_network_gateway_in

    @backup_network_gateway_in.setter
    def backup_network_gateway_in(self, backup_network_gateway_in):
        """Sets the backup_network_gateway_in of this BackupServiceWhereInput.


        :param backup_network_gateway_in: The backup_network_gateway_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_in: list[str]
        """

        self._backup_network_gateway_in = backup_network_gateway_in

    @property
    def backup_network_gateway_lt(self):
        """Gets the backup_network_gateway_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway_lt

    @backup_network_gateway_lt.setter
    def backup_network_gateway_lt(self, backup_network_gateway_lt):
        """Sets the backup_network_gateway_lt of this BackupServiceWhereInput.


        :param backup_network_gateway_lt: The backup_network_gateway_lt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_lt: str
        """

        self._backup_network_gateway_lt = backup_network_gateway_lt

    @property
    def backup_network_gateway_lte(self):
        """Gets the backup_network_gateway_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway_lte

    @backup_network_gateway_lte.setter
    def backup_network_gateway_lte(self, backup_network_gateway_lte):
        """Sets the backup_network_gateway_lte of this BackupServiceWhereInput.


        :param backup_network_gateway_lte: The backup_network_gateway_lte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_lte: str
        """

        self._backup_network_gateway_lte = backup_network_gateway_lte

    @property
    def backup_network_gateway_not(self):
        """Gets the backup_network_gateway_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway_not

    @backup_network_gateway_not.setter
    def backup_network_gateway_not(self, backup_network_gateway_not):
        """Sets the backup_network_gateway_not of this BackupServiceWhereInput.


        :param backup_network_gateway_not: The backup_network_gateway_not of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_not: str
        """

        self._backup_network_gateway_not = backup_network_gateway_not

    @property
    def backup_network_gateway_not_contains(self):
        """Gets the backup_network_gateway_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway_not_contains

    @backup_network_gateway_not_contains.setter
    def backup_network_gateway_not_contains(self, backup_network_gateway_not_contains):
        """Sets the backup_network_gateway_not_contains of this BackupServiceWhereInput.


        :param backup_network_gateway_not_contains: The backup_network_gateway_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_not_contains: str
        """

        self._backup_network_gateway_not_contains = backup_network_gateway_not_contains

    @property
    def backup_network_gateway_not_ends_with(self):
        """Gets the backup_network_gateway_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway_not_ends_with

    @backup_network_gateway_not_ends_with.setter
    def backup_network_gateway_not_ends_with(self, backup_network_gateway_not_ends_with):
        """Sets the backup_network_gateway_not_ends_with of this BackupServiceWhereInput.


        :param backup_network_gateway_not_ends_with: The backup_network_gateway_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_not_ends_with: str
        """

        self._backup_network_gateway_not_ends_with = backup_network_gateway_not_ends_with

    @property
    def backup_network_gateway_not_in(self):
        """Gets the backup_network_gateway_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._backup_network_gateway_not_in

    @backup_network_gateway_not_in.setter
    def backup_network_gateway_not_in(self, backup_network_gateway_not_in):
        """Sets the backup_network_gateway_not_in of this BackupServiceWhereInput.


        :param backup_network_gateway_not_in: The backup_network_gateway_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_not_in: list[str]
        """

        self._backup_network_gateway_not_in = backup_network_gateway_not_in

    @property
    def backup_network_gateway_not_starts_with(self):
        """Gets the backup_network_gateway_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway_not_starts_with

    @backup_network_gateway_not_starts_with.setter
    def backup_network_gateway_not_starts_with(self, backup_network_gateway_not_starts_with):
        """Sets the backup_network_gateway_not_starts_with of this BackupServiceWhereInput.


        :param backup_network_gateway_not_starts_with: The backup_network_gateway_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_not_starts_with: str
        """

        self._backup_network_gateway_not_starts_with = backup_network_gateway_not_starts_with

    @property
    def backup_network_gateway_starts_with(self):
        """Gets the backup_network_gateway_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_gateway_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_gateway_starts_with

    @backup_network_gateway_starts_with.setter
    def backup_network_gateway_starts_with(self, backup_network_gateway_starts_with):
        """Sets the backup_network_gateway_starts_with of this BackupServiceWhereInput.


        :param backup_network_gateway_starts_with: The backup_network_gateway_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_gateway_starts_with: str
        """

        self._backup_network_gateway_starts_with = backup_network_gateway_starts_with

    @property
    def backup_network_ip(self):
        """Gets the backup_network_ip of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip

    @backup_network_ip.setter
    def backup_network_ip(self, backup_network_ip):
        """Sets the backup_network_ip of this BackupServiceWhereInput.


        :param backup_network_ip: The backup_network_ip of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip: str
        """

        self._backup_network_ip = backup_network_ip

    @property
    def backup_network_ip_contains(self):
        """Gets the backup_network_ip_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip_contains

    @backup_network_ip_contains.setter
    def backup_network_ip_contains(self, backup_network_ip_contains):
        """Sets the backup_network_ip_contains of this BackupServiceWhereInput.


        :param backup_network_ip_contains: The backup_network_ip_contains of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_contains: str
        """

        self._backup_network_ip_contains = backup_network_ip_contains

    @property
    def backup_network_ip_ends_with(self):
        """Gets the backup_network_ip_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip_ends_with

    @backup_network_ip_ends_with.setter
    def backup_network_ip_ends_with(self, backup_network_ip_ends_with):
        """Sets the backup_network_ip_ends_with of this BackupServiceWhereInput.


        :param backup_network_ip_ends_with: The backup_network_ip_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_ends_with: str
        """

        self._backup_network_ip_ends_with = backup_network_ip_ends_with

    @property
    def backup_network_ip_gt(self):
        """Gets the backup_network_ip_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip_gt

    @backup_network_ip_gt.setter
    def backup_network_ip_gt(self, backup_network_ip_gt):
        """Sets the backup_network_ip_gt of this BackupServiceWhereInput.


        :param backup_network_ip_gt: The backup_network_ip_gt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_gt: str
        """

        self._backup_network_ip_gt = backup_network_ip_gt

    @property
    def backup_network_ip_gte(self):
        """Gets the backup_network_ip_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip_gte

    @backup_network_ip_gte.setter
    def backup_network_ip_gte(self, backup_network_ip_gte):
        """Sets the backup_network_ip_gte of this BackupServiceWhereInput.


        :param backup_network_ip_gte: The backup_network_ip_gte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_gte: str
        """

        self._backup_network_ip_gte = backup_network_ip_gte

    @property
    def backup_network_ip_in(self):
        """Gets the backup_network_ip_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._backup_network_ip_in

    @backup_network_ip_in.setter
    def backup_network_ip_in(self, backup_network_ip_in):
        """Sets the backup_network_ip_in of this BackupServiceWhereInput.


        :param backup_network_ip_in: The backup_network_ip_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_in: list[str]
        """

        self._backup_network_ip_in = backup_network_ip_in

    @property
    def backup_network_ip_lt(self):
        """Gets the backup_network_ip_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip_lt

    @backup_network_ip_lt.setter
    def backup_network_ip_lt(self, backup_network_ip_lt):
        """Sets the backup_network_ip_lt of this BackupServiceWhereInput.


        :param backup_network_ip_lt: The backup_network_ip_lt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_lt: str
        """

        self._backup_network_ip_lt = backup_network_ip_lt

    @property
    def backup_network_ip_lte(self):
        """Gets the backup_network_ip_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip_lte

    @backup_network_ip_lte.setter
    def backup_network_ip_lte(self, backup_network_ip_lte):
        """Sets the backup_network_ip_lte of this BackupServiceWhereInput.


        :param backup_network_ip_lte: The backup_network_ip_lte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_lte: str
        """

        self._backup_network_ip_lte = backup_network_ip_lte

    @property
    def backup_network_ip_not(self):
        """Gets the backup_network_ip_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip_not

    @backup_network_ip_not.setter
    def backup_network_ip_not(self, backup_network_ip_not):
        """Sets the backup_network_ip_not of this BackupServiceWhereInput.


        :param backup_network_ip_not: The backup_network_ip_not of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_not: str
        """

        self._backup_network_ip_not = backup_network_ip_not

    @property
    def backup_network_ip_not_contains(self):
        """Gets the backup_network_ip_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip_not_contains

    @backup_network_ip_not_contains.setter
    def backup_network_ip_not_contains(self, backup_network_ip_not_contains):
        """Sets the backup_network_ip_not_contains of this BackupServiceWhereInput.


        :param backup_network_ip_not_contains: The backup_network_ip_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_not_contains: str
        """

        self._backup_network_ip_not_contains = backup_network_ip_not_contains

    @property
    def backup_network_ip_not_ends_with(self):
        """Gets the backup_network_ip_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip_not_ends_with

    @backup_network_ip_not_ends_with.setter
    def backup_network_ip_not_ends_with(self, backup_network_ip_not_ends_with):
        """Sets the backup_network_ip_not_ends_with of this BackupServiceWhereInput.


        :param backup_network_ip_not_ends_with: The backup_network_ip_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_not_ends_with: str
        """

        self._backup_network_ip_not_ends_with = backup_network_ip_not_ends_with

    @property
    def backup_network_ip_not_in(self):
        """Gets the backup_network_ip_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._backup_network_ip_not_in

    @backup_network_ip_not_in.setter
    def backup_network_ip_not_in(self, backup_network_ip_not_in):
        """Sets the backup_network_ip_not_in of this BackupServiceWhereInput.


        :param backup_network_ip_not_in: The backup_network_ip_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_not_in: list[str]
        """

        self._backup_network_ip_not_in = backup_network_ip_not_in

    @property
    def backup_network_ip_not_starts_with(self):
        """Gets the backup_network_ip_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip_not_starts_with

    @backup_network_ip_not_starts_with.setter
    def backup_network_ip_not_starts_with(self, backup_network_ip_not_starts_with):
        """Sets the backup_network_ip_not_starts_with of this BackupServiceWhereInput.


        :param backup_network_ip_not_starts_with: The backup_network_ip_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_not_starts_with: str
        """

        self._backup_network_ip_not_starts_with = backup_network_ip_not_starts_with

    @property
    def backup_network_ip_starts_with(self):
        """Gets the backup_network_ip_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_ip_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_ip_starts_with

    @backup_network_ip_starts_with.setter
    def backup_network_ip_starts_with(self, backup_network_ip_starts_with):
        """Sets the backup_network_ip_starts_with of this BackupServiceWhereInput.


        :param backup_network_ip_starts_with: The backup_network_ip_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_ip_starts_with: str
        """

        self._backup_network_ip_starts_with = backup_network_ip_starts_with

    @property
    def backup_network_subnet_mask(self):
        """Gets the backup_network_subnet_mask of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask

    @backup_network_subnet_mask.setter
    def backup_network_subnet_mask(self, backup_network_subnet_mask):
        """Sets the backup_network_subnet_mask of this BackupServiceWhereInput.


        :param backup_network_subnet_mask: The backup_network_subnet_mask of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask: str
        """

        self._backup_network_subnet_mask = backup_network_subnet_mask

    @property
    def backup_network_subnet_mask_contains(self):
        """Gets the backup_network_subnet_mask_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask_contains

    @backup_network_subnet_mask_contains.setter
    def backup_network_subnet_mask_contains(self, backup_network_subnet_mask_contains):
        """Sets the backup_network_subnet_mask_contains of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_contains: The backup_network_subnet_mask_contains of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_contains: str
        """

        self._backup_network_subnet_mask_contains = backup_network_subnet_mask_contains

    @property
    def backup_network_subnet_mask_ends_with(self):
        """Gets the backup_network_subnet_mask_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask_ends_with

    @backup_network_subnet_mask_ends_with.setter
    def backup_network_subnet_mask_ends_with(self, backup_network_subnet_mask_ends_with):
        """Sets the backup_network_subnet_mask_ends_with of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_ends_with: The backup_network_subnet_mask_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_ends_with: str
        """

        self._backup_network_subnet_mask_ends_with = backup_network_subnet_mask_ends_with

    @property
    def backup_network_subnet_mask_gt(self):
        """Gets the backup_network_subnet_mask_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask_gt

    @backup_network_subnet_mask_gt.setter
    def backup_network_subnet_mask_gt(self, backup_network_subnet_mask_gt):
        """Sets the backup_network_subnet_mask_gt of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_gt: The backup_network_subnet_mask_gt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_gt: str
        """

        self._backup_network_subnet_mask_gt = backup_network_subnet_mask_gt

    @property
    def backup_network_subnet_mask_gte(self):
        """Gets the backup_network_subnet_mask_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask_gte

    @backup_network_subnet_mask_gte.setter
    def backup_network_subnet_mask_gte(self, backup_network_subnet_mask_gte):
        """Sets the backup_network_subnet_mask_gte of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_gte: The backup_network_subnet_mask_gte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_gte: str
        """

        self._backup_network_subnet_mask_gte = backup_network_subnet_mask_gte

    @property
    def backup_network_subnet_mask_in(self):
        """Gets the backup_network_subnet_mask_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._backup_network_subnet_mask_in

    @backup_network_subnet_mask_in.setter
    def backup_network_subnet_mask_in(self, backup_network_subnet_mask_in):
        """Sets the backup_network_subnet_mask_in of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_in: The backup_network_subnet_mask_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_in: list[str]
        """

        self._backup_network_subnet_mask_in = backup_network_subnet_mask_in

    @property
    def backup_network_subnet_mask_lt(self):
        """Gets the backup_network_subnet_mask_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask_lt

    @backup_network_subnet_mask_lt.setter
    def backup_network_subnet_mask_lt(self, backup_network_subnet_mask_lt):
        """Sets the backup_network_subnet_mask_lt of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_lt: The backup_network_subnet_mask_lt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_lt: str
        """

        self._backup_network_subnet_mask_lt = backup_network_subnet_mask_lt

    @property
    def backup_network_subnet_mask_lte(self):
        """Gets the backup_network_subnet_mask_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask_lte

    @backup_network_subnet_mask_lte.setter
    def backup_network_subnet_mask_lte(self, backup_network_subnet_mask_lte):
        """Sets the backup_network_subnet_mask_lte of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_lte: The backup_network_subnet_mask_lte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_lte: str
        """

        self._backup_network_subnet_mask_lte = backup_network_subnet_mask_lte

    @property
    def backup_network_subnet_mask_not(self):
        """Gets the backup_network_subnet_mask_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask_not

    @backup_network_subnet_mask_not.setter
    def backup_network_subnet_mask_not(self, backup_network_subnet_mask_not):
        """Sets the backup_network_subnet_mask_not of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_not: The backup_network_subnet_mask_not of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_not: str
        """

        self._backup_network_subnet_mask_not = backup_network_subnet_mask_not

    @property
    def backup_network_subnet_mask_not_contains(self):
        """Gets the backup_network_subnet_mask_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask_not_contains

    @backup_network_subnet_mask_not_contains.setter
    def backup_network_subnet_mask_not_contains(self, backup_network_subnet_mask_not_contains):
        """Sets the backup_network_subnet_mask_not_contains of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_not_contains: The backup_network_subnet_mask_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_not_contains: str
        """

        self._backup_network_subnet_mask_not_contains = backup_network_subnet_mask_not_contains

    @property
    def backup_network_subnet_mask_not_ends_with(self):
        """Gets the backup_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask_not_ends_with

    @backup_network_subnet_mask_not_ends_with.setter
    def backup_network_subnet_mask_not_ends_with(self, backup_network_subnet_mask_not_ends_with):
        """Sets the backup_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_not_ends_with: The backup_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_not_ends_with: str
        """

        self._backup_network_subnet_mask_not_ends_with = backup_network_subnet_mask_not_ends_with

    @property
    def backup_network_subnet_mask_not_in(self):
        """Gets the backup_network_subnet_mask_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._backup_network_subnet_mask_not_in

    @backup_network_subnet_mask_not_in.setter
    def backup_network_subnet_mask_not_in(self, backup_network_subnet_mask_not_in):
        """Sets the backup_network_subnet_mask_not_in of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_not_in: The backup_network_subnet_mask_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_not_in: list[str]
        """

        self._backup_network_subnet_mask_not_in = backup_network_subnet_mask_not_in

    @property
    def backup_network_subnet_mask_not_starts_with(self):
        """Gets the backup_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask_not_starts_with

    @backup_network_subnet_mask_not_starts_with.setter
    def backup_network_subnet_mask_not_starts_with(self, backup_network_subnet_mask_not_starts_with):
        """Sets the backup_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_not_starts_with: The backup_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_not_starts_with: str
        """

        self._backup_network_subnet_mask_not_starts_with = backup_network_subnet_mask_not_starts_with

    @property
    def backup_network_subnet_mask_starts_with(self):
        """Gets the backup_network_subnet_mask_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_subnet_mask_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_subnet_mask_starts_with

    @backup_network_subnet_mask_starts_with.setter
    def backup_network_subnet_mask_starts_with(self, backup_network_subnet_mask_starts_with):
        """Sets the backup_network_subnet_mask_starts_with of this BackupServiceWhereInput.


        :param backup_network_subnet_mask_starts_with: The backup_network_subnet_mask_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_subnet_mask_starts_with: str
        """

        self._backup_network_subnet_mask_starts_with = backup_network_subnet_mask_starts_with

    @property
    def backup_network_type(self):
        """Gets the backup_network_type of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_type of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupServiceNetworkType
        """
        return self._backup_network_type

    @backup_network_type.setter
    def backup_network_type(self, backup_network_type):
        """Sets the backup_network_type of this BackupServiceWhereInput.


        :param backup_network_type: The backup_network_type of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_type: BackupServiceNetworkType
        """

        self._backup_network_type = backup_network_type

    @property
    def backup_network_type_in(self):
        """Gets the backup_network_type_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_type_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[BackupServiceNetworkType]
        """
        return self._backup_network_type_in

    @backup_network_type_in.setter
    def backup_network_type_in(self, backup_network_type_in):
        """Sets the backup_network_type_in of this BackupServiceWhereInput.


        :param backup_network_type_in: The backup_network_type_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_type_in: list[BackupServiceNetworkType]
        """

        self._backup_network_type_in = backup_network_type_in

    @property
    def backup_network_type_not(self):
        """Gets the backup_network_type_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_type_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupServiceNetworkType
        """
        return self._backup_network_type_not

    @backup_network_type_not.setter
    def backup_network_type_not(self, backup_network_type_not):
        """Sets the backup_network_type_not of this BackupServiceWhereInput.


        :param backup_network_type_not: The backup_network_type_not of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_type_not: BackupServiceNetworkType
        """

        self._backup_network_type_not = backup_network_type_not

    @property
    def backup_network_type_not_in(self):
        """Gets the backup_network_type_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_type_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[BackupServiceNetworkType]
        """
        return self._backup_network_type_not_in

    @backup_network_type_not_in.setter
    def backup_network_type_not_in(self, backup_network_type_not_in):
        """Sets the backup_network_type_not_in of this BackupServiceWhereInput.


        :param backup_network_type_not_in: The backup_network_type_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_type_not_in: list[BackupServiceNetworkType]
        """

        self._backup_network_type_not_in = backup_network_type_not_in

    @property
    def backup_network_vlan(self):
        """Gets the backup_network_vlan of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan

    @backup_network_vlan.setter
    def backup_network_vlan(self, backup_network_vlan):
        """Sets the backup_network_vlan of this BackupServiceWhereInput.


        :param backup_network_vlan: The backup_network_vlan of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan: str
        """

        self._backup_network_vlan = backup_network_vlan

    @property
    def backup_network_vlan_contains(self):
        """Gets the backup_network_vlan_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan_contains

    @backup_network_vlan_contains.setter
    def backup_network_vlan_contains(self, backup_network_vlan_contains):
        """Sets the backup_network_vlan_contains of this BackupServiceWhereInput.


        :param backup_network_vlan_contains: The backup_network_vlan_contains of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_contains: str
        """

        self._backup_network_vlan_contains = backup_network_vlan_contains

    @property
    def backup_network_vlan_ends_with(self):
        """Gets the backup_network_vlan_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan_ends_with

    @backup_network_vlan_ends_with.setter
    def backup_network_vlan_ends_with(self, backup_network_vlan_ends_with):
        """Sets the backup_network_vlan_ends_with of this BackupServiceWhereInput.


        :param backup_network_vlan_ends_with: The backup_network_vlan_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_ends_with: str
        """

        self._backup_network_vlan_ends_with = backup_network_vlan_ends_with

    @property
    def backup_network_vlan_gt(self):
        """Gets the backup_network_vlan_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan_gt

    @backup_network_vlan_gt.setter
    def backup_network_vlan_gt(self, backup_network_vlan_gt):
        """Sets the backup_network_vlan_gt of this BackupServiceWhereInput.


        :param backup_network_vlan_gt: The backup_network_vlan_gt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_gt: str
        """

        self._backup_network_vlan_gt = backup_network_vlan_gt

    @property
    def backup_network_vlan_gte(self):
        """Gets the backup_network_vlan_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan_gte

    @backup_network_vlan_gte.setter
    def backup_network_vlan_gte(self, backup_network_vlan_gte):
        """Sets the backup_network_vlan_gte of this BackupServiceWhereInput.


        :param backup_network_vlan_gte: The backup_network_vlan_gte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_gte: str
        """

        self._backup_network_vlan_gte = backup_network_vlan_gte

    @property
    def backup_network_vlan_in(self):
        """Gets the backup_network_vlan_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._backup_network_vlan_in

    @backup_network_vlan_in.setter
    def backup_network_vlan_in(self, backup_network_vlan_in):
        """Sets the backup_network_vlan_in of this BackupServiceWhereInput.


        :param backup_network_vlan_in: The backup_network_vlan_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_in: list[str]
        """

        self._backup_network_vlan_in = backup_network_vlan_in

    @property
    def backup_network_vlan_lt(self):
        """Gets the backup_network_vlan_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan_lt

    @backup_network_vlan_lt.setter
    def backup_network_vlan_lt(self, backup_network_vlan_lt):
        """Sets the backup_network_vlan_lt of this BackupServiceWhereInput.


        :param backup_network_vlan_lt: The backup_network_vlan_lt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_lt: str
        """

        self._backup_network_vlan_lt = backup_network_vlan_lt

    @property
    def backup_network_vlan_lte(self):
        """Gets the backup_network_vlan_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan_lte

    @backup_network_vlan_lte.setter
    def backup_network_vlan_lte(self, backup_network_vlan_lte):
        """Sets the backup_network_vlan_lte of this BackupServiceWhereInput.


        :param backup_network_vlan_lte: The backup_network_vlan_lte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_lte: str
        """

        self._backup_network_vlan_lte = backup_network_vlan_lte

    @property
    def backup_network_vlan_not(self):
        """Gets the backup_network_vlan_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan_not

    @backup_network_vlan_not.setter
    def backup_network_vlan_not(self, backup_network_vlan_not):
        """Sets the backup_network_vlan_not of this BackupServiceWhereInput.


        :param backup_network_vlan_not: The backup_network_vlan_not of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_not: str
        """

        self._backup_network_vlan_not = backup_network_vlan_not

    @property
    def backup_network_vlan_not_contains(self):
        """Gets the backup_network_vlan_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan_not_contains

    @backup_network_vlan_not_contains.setter
    def backup_network_vlan_not_contains(self, backup_network_vlan_not_contains):
        """Sets the backup_network_vlan_not_contains of this BackupServiceWhereInput.


        :param backup_network_vlan_not_contains: The backup_network_vlan_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_not_contains: str
        """

        self._backup_network_vlan_not_contains = backup_network_vlan_not_contains

    @property
    def backup_network_vlan_not_ends_with(self):
        """Gets the backup_network_vlan_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan_not_ends_with

    @backup_network_vlan_not_ends_with.setter
    def backup_network_vlan_not_ends_with(self, backup_network_vlan_not_ends_with):
        """Sets the backup_network_vlan_not_ends_with of this BackupServiceWhereInput.


        :param backup_network_vlan_not_ends_with: The backup_network_vlan_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_not_ends_with: str
        """

        self._backup_network_vlan_not_ends_with = backup_network_vlan_not_ends_with

    @property
    def backup_network_vlan_not_in(self):
        """Gets the backup_network_vlan_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._backup_network_vlan_not_in

    @backup_network_vlan_not_in.setter
    def backup_network_vlan_not_in(self, backup_network_vlan_not_in):
        """Sets the backup_network_vlan_not_in of this BackupServiceWhereInput.


        :param backup_network_vlan_not_in: The backup_network_vlan_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_not_in: list[str]
        """

        self._backup_network_vlan_not_in = backup_network_vlan_not_in

    @property
    def backup_network_vlan_not_starts_with(self):
        """Gets the backup_network_vlan_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan_not_starts_with

    @backup_network_vlan_not_starts_with.setter
    def backup_network_vlan_not_starts_with(self, backup_network_vlan_not_starts_with):
        """Sets the backup_network_vlan_not_starts_with of this BackupServiceWhereInput.


        :param backup_network_vlan_not_starts_with: The backup_network_vlan_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_not_starts_with: str
        """

        self._backup_network_vlan_not_starts_with = backup_network_vlan_not_starts_with

    @property
    def backup_network_vlan_starts_with(self):
        """Gets the backup_network_vlan_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_network_vlan_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_network_vlan_starts_with

    @backup_network_vlan_starts_with.setter
    def backup_network_vlan_starts_with(self, backup_network_vlan_starts_with):
        """Sets the backup_network_vlan_starts_with of this BackupServiceWhereInput.


        :param backup_network_vlan_starts_with: The backup_network_vlan_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type backup_network_vlan_starts_with: str
        """

        self._backup_network_vlan_starts_with = backup_network_vlan_starts_with

    @property
    def backup_plans_every(self):
        """Gets the backup_plans_every of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_plans_every of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupPlanWhereInput
        """
        return self._backup_plans_every

    @backup_plans_every.setter
    def backup_plans_every(self, backup_plans_every):
        """Sets the backup_plans_every of this BackupServiceWhereInput.


        :param backup_plans_every: The backup_plans_every of this BackupServiceWhereInput.  # noqa: E501
        :type backup_plans_every: BackupPlanWhereInput
        """

        self._backup_plans_every = backup_plans_every

    @property
    def backup_plans_none(self):
        """Gets the backup_plans_none of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_plans_none of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupPlanWhereInput
        """
        return self._backup_plans_none

    @backup_plans_none.setter
    def backup_plans_none(self, backup_plans_none):
        """Sets the backup_plans_none of this BackupServiceWhereInput.


        :param backup_plans_none: The backup_plans_none of this BackupServiceWhereInput.  # noqa: E501
        :type backup_plans_none: BackupPlanWhereInput
        """

        self._backup_plans_none = backup_plans_none

    @property
    def backup_plans_some(self):
        """Gets the backup_plans_some of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_plans_some of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupPlanWhereInput
        """
        return self._backup_plans_some

    @backup_plans_some.setter
    def backup_plans_some(self, backup_plans_some):
        """Sets the backup_plans_some of this BackupServiceWhereInput.


        :param backup_plans_some: The backup_plans_some of this BackupServiceWhereInput.  # noqa: E501
        :type backup_plans_some: BackupPlanWhereInput
        """

        self._backup_plans_some = backup_plans_some

    @property
    def backup_rd_iops_max(self):
        """Gets the backup_rd_iops_max of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_rd_iops_max of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_rd_iops_max

    @backup_rd_iops_max.setter
    def backup_rd_iops_max(self, backup_rd_iops_max):
        """Sets the backup_rd_iops_max of this BackupServiceWhereInput.


        :param backup_rd_iops_max: The backup_rd_iops_max of this BackupServiceWhereInput.  # noqa: E501
        :type backup_rd_iops_max: int
        """

        self._backup_rd_iops_max = backup_rd_iops_max

    @property
    def backup_rd_iops_max_gt(self):
        """Gets the backup_rd_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_rd_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_rd_iops_max_gt

    @backup_rd_iops_max_gt.setter
    def backup_rd_iops_max_gt(self, backup_rd_iops_max_gt):
        """Sets the backup_rd_iops_max_gt of this BackupServiceWhereInput.


        :param backup_rd_iops_max_gt: The backup_rd_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_rd_iops_max_gt: int
        """

        self._backup_rd_iops_max_gt = backup_rd_iops_max_gt

    @property
    def backup_rd_iops_max_gte(self):
        """Gets the backup_rd_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_rd_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_rd_iops_max_gte

    @backup_rd_iops_max_gte.setter
    def backup_rd_iops_max_gte(self, backup_rd_iops_max_gte):
        """Sets the backup_rd_iops_max_gte of this BackupServiceWhereInput.


        :param backup_rd_iops_max_gte: The backup_rd_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_rd_iops_max_gte: int
        """

        self._backup_rd_iops_max_gte = backup_rd_iops_max_gte

    @property
    def backup_rd_iops_max_in(self):
        """Gets the backup_rd_iops_max_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_rd_iops_max_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._backup_rd_iops_max_in

    @backup_rd_iops_max_in.setter
    def backup_rd_iops_max_in(self, backup_rd_iops_max_in):
        """Sets the backup_rd_iops_max_in of this BackupServiceWhereInput.


        :param backup_rd_iops_max_in: The backup_rd_iops_max_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_rd_iops_max_in: list[int]
        """

        self._backup_rd_iops_max_in = backup_rd_iops_max_in

    @property
    def backup_rd_iops_max_lt(self):
        """Gets the backup_rd_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_rd_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_rd_iops_max_lt

    @backup_rd_iops_max_lt.setter
    def backup_rd_iops_max_lt(self, backup_rd_iops_max_lt):
        """Sets the backup_rd_iops_max_lt of this BackupServiceWhereInput.


        :param backup_rd_iops_max_lt: The backup_rd_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_rd_iops_max_lt: int
        """

        self._backup_rd_iops_max_lt = backup_rd_iops_max_lt

    @property
    def backup_rd_iops_max_lte(self):
        """Gets the backup_rd_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_rd_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_rd_iops_max_lte

    @backup_rd_iops_max_lte.setter
    def backup_rd_iops_max_lte(self, backup_rd_iops_max_lte):
        """Sets the backup_rd_iops_max_lte of this BackupServiceWhereInput.


        :param backup_rd_iops_max_lte: The backup_rd_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_rd_iops_max_lte: int
        """

        self._backup_rd_iops_max_lte = backup_rd_iops_max_lte

    @property
    def backup_rd_iops_max_not(self):
        """Gets the backup_rd_iops_max_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_rd_iops_max_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_rd_iops_max_not

    @backup_rd_iops_max_not.setter
    def backup_rd_iops_max_not(self, backup_rd_iops_max_not):
        """Sets the backup_rd_iops_max_not of this BackupServiceWhereInput.


        :param backup_rd_iops_max_not: The backup_rd_iops_max_not of this BackupServiceWhereInput.  # noqa: E501
        :type backup_rd_iops_max_not: int
        """

        self._backup_rd_iops_max_not = backup_rd_iops_max_not

    @property
    def backup_rd_iops_max_not_in(self):
        """Gets the backup_rd_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_rd_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._backup_rd_iops_max_not_in

    @backup_rd_iops_max_not_in.setter
    def backup_rd_iops_max_not_in(self, backup_rd_iops_max_not_in):
        """Sets the backup_rd_iops_max_not_in of this BackupServiceWhereInput.


        :param backup_rd_iops_max_not_in: The backup_rd_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_rd_iops_max_not_in: list[int]
        """

        self._backup_rd_iops_max_not_in = backup_rd_iops_max_not_in

    @property
    def backup_store_repositories_every(self):
        """Gets the backup_store_repositories_every of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_store_repositories_every of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupStoreRepositoryWhereInput
        """
        return self._backup_store_repositories_every

    @backup_store_repositories_every.setter
    def backup_store_repositories_every(self, backup_store_repositories_every):
        """Sets the backup_store_repositories_every of this BackupServiceWhereInput.


        :param backup_store_repositories_every: The backup_store_repositories_every of this BackupServiceWhereInput.  # noqa: E501
        :type backup_store_repositories_every: BackupStoreRepositoryWhereInput
        """

        self._backup_store_repositories_every = backup_store_repositories_every

    @property
    def backup_store_repositories_none(self):
        """Gets the backup_store_repositories_none of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_store_repositories_none of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupStoreRepositoryWhereInput
        """
        return self._backup_store_repositories_none

    @backup_store_repositories_none.setter
    def backup_store_repositories_none(self, backup_store_repositories_none):
        """Sets the backup_store_repositories_none of this BackupServiceWhereInput.


        :param backup_store_repositories_none: The backup_store_repositories_none of this BackupServiceWhereInput.  # noqa: E501
        :type backup_store_repositories_none: BackupStoreRepositoryWhereInput
        """

        self._backup_store_repositories_none = backup_store_repositories_none

    @property
    def backup_store_repositories_some(self):
        """Gets the backup_store_repositories_some of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_store_repositories_some of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupStoreRepositoryWhereInput
        """
        return self._backup_store_repositories_some

    @backup_store_repositories_some.setter
    def backup_store_repositories_some(self, backup_store_repositories_some):
        """Sets the backup_store_repositories_some of this BackupServiceWhereInput.


        :param backup_store_repositories_some: The backup_store_repositories_some of this BackupServiceWhereInput.  # noqa: E501
        :type backup_store_repositories_some: BackupStoreRepositoryWhereInput
        """

        self._backup_store_repositories_some = backup_store_repositories_some

    @property
    def backup_wr_iops_max(self):
        """Gets the backup_wr_iops_max of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_wr_iops_max of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_wr_iops_max

    @backup_wr_iops_max.setter
    def backup_wr_iops_max(self, backup_wr_iops_max):
        """Sets the backup_wr_iops_max of this BackupServiceWhereInput.


        :param backup_wr_iops_max: The backup_wr_iops_max of this BackupServiceWhereInput.  # noqa: E501
        :type backup_wr_iops_max: int
        """

        self._backup_wr_iops_max = backup_wr_iops_max

    @property
    def backup_wr_iops_max_gt(self):
        """Gets the backup_wr_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_wr_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_wr_iops_max_gt

    @backup_wr_iops_max_gt.setter
    def backup_wr_iops_max_gt(self, backup_wr_iops_max_gt):
        """Sets the backup_wr_iops_max_gt of this BackupServiceWhereInput.


        :param backup_wr_iops_max_gt: The backup_wr_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_wr_iops_max_gt: int
        """

        self._backup_wr_iops_max_gt = backup_wr_iops_max_gt

    @property
    def backup_wr_iops_max_gte(self):
        """Gets the backup_wr_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_wr_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_wr_iops_max_gte

    @backup_wr_iops_max_gte.setter
    def backup_wr_iops_max_gte(self, backup_wr_iops_max_gte):
        """Sets the backup_wr_iops_max_gte of this BackupServiceWhereInput.


        :param backup_wr_iops_max_gte: The backup_wr_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_wr_iops_max_gte: int
        """

        self._backup_wr_iops_max_gte = backup_wr_iops_max_gte

    @property
    def backup_wr_iops_max_in(self):
        """Gets the backup_wr_iops_max_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_wr_iops_max_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._backup_wr_iops_max_in

    @backup_wr_iops_max_in.setter
    def backup_wr_iops_max_in(self, backup_wr_iops_max_in):
        """Sets the backup_wr_iops_max_in of this BackupServiceWhereInput.


        :param backup_wr_iops_max_in: The backup_wr_iops_max_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_wr_iops_max_in: list[int]
        """

        self._backup_wr_iops_max_in = backup_wr_iops_max_in

    @property
    def backup_wr_iops_max_lt(self):
        """Gets the backup_wr_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_wr_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_wr_iops_max_lt

    @backup_wr_iops_max_lt.setter
    def backup_wr_iops_max_lt(self, backup_wr_iops_max_lt):
        """Sets the backup_wr_iops_max_lt of this BackupServiceWhereInput.


        :param backup_wr_iops_max_lt: The backup_wr_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501
        :type backup_wr_iops_max_lt: int
        """

        self._backup_wr_iops_max_lt = backup_wr_iops_max_lt

    @property
    def backup_wr_iops_max_lte(self):
        """Gets the backup_wr_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_wr_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_wr_iops_max_lte

    @backup_wr_iops_max_lte.setter
    def backup_wr_iops_max_lte(self, backup_wr_iops_max_lte):
        """Sets the backup_wr_iops_max_lte of this BackupServiceWhereInput.


        :param backup_wr_iops_max_lte: The backup_wr_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501
        :type backup_wr_iops_max_lte: int
        """

        self._backup_wr_iops_max_lte = backup_wr_iops_max_lte

    @property
    def backup_wr_iops_max_not(self):
        """Gets the backup_wr_iops_max_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_wr_iops_max_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._backup_wr_iops_max_not

    @backup_wr_iops_max_not.setter
    def backup_wr_iops_max_not(self, backup_wr_iops_max_not):
        """Sets the backup_wr_iops_max_not of this BackupServiceWhereInput.


        :param backup_wr_iops_max_not: The backup_wr_iops_max_not of this BackupServiceWhereInput.  # noqa: E501
        :type backup_wr_iops_max_not: int
        """

        self._backup_wr_iops_max_not = backup_wr_iops_max_not

    @property
    def backup_wr_iops_max_not_in(self):
        """Gets the backup_wr_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The backup_wr_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._backup_wr_iops_max_not_in

    @backup_wr_iops_max_not_in.setter
    def backup_wr_iops_max_not_in(self, backup_wr_iops_max_not_in):
        """Sets the backup_wr_iops_max_not_in of this BackupServiceWhereInput.


        :param backup_wr_iops_max_not_in: The backup_wr_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type backup_wr_iops_max_not_in: list[int]
        """

        self._backup_wr_iops_max_not_in = backup_wr_iops_max_not_in

    @property
    def description(self):
        """Gets the description of this BackupServiceWhereInput.  # noqa: E501


        :return: The description of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BackupServiceWhereInput.


        :param description: The description of this BackupServiceWhereInput.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def description_contains(self):
        """Gets the description_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_contains

    @description_contains.setter
    def description_contains(self, description_contains):
        """Sets the description_contains of this BackupServiceWhereInput.


        :param description_contains: The description_contains of this BackupServiceWhereInput.  # noqa: E501
        :type description_contains: str
        """

        self._description_contains = description_contains

    @property
    def description_ends_with(self):
        """Gets the description_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_ends_with

    @description_ends_with.setter
    def description_ends_with(self, description_ends_with):
        """Sets the description_ends_with of this BackupServiceWhereInput.


        :param description_ends_with: The description_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type description_ends_with: str
        """

        self._description_ends_with = description_ends_with

    @property
    def description_gt(self):
        """Gets the description_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gt

    @description_gt.setter
    def description_gt(self, description_gt):
        """Sets the description_gt of this BackupServiceWhereInput.


        :param description_gt: The description_gt of this BackupServiceWhereInput.  # noqa: E501
        :type description_gt: str
        """

        self._description_gt = description_gt

    @property
    def description_gte(self):
        """Gets the description_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gte

    @description_gte.setter
    def description_gte(self, description_gte):
        """Sets the description_gte of this BackupServiceWhereInput.


        :param description_gte: The description_gte of this BackupServiceWhereInput.  # noqa: E501
        :type description_gte: str
        """

        self._description_gte = description_gte

    @property
    def description_in(self):
        """Gets the description_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_in

    @description_in.setter
    def description_in(self, description_in):
        """Sets the description_in of this BackupServiceWhereInput.


        :param description_in: The description_in of this BackupServiceWhereInput.  # noqa: E501
        :type description_in: list[str]
        """

        self._description_in = description_in

    @property
    def description_lt(self):
        """Gets the description_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lt

    @description_lt.setter
    def description_lt(self, description_lt):
        """Sets the description_lt of this BackupServiceWhereInput.


        :param description_lt: The description_lt of this BackupServiceWhereInput.  # noqa: E501
        :type description_lt: str
        """

        self._description_lt = description_lt

    @property
    def description_lte(self):
        """Gets the description_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lte

    @description_lte.setter
    def description_lte(self, description_lte):
        """Sets the description_lte of this BackupServiceWhereInput.


        :param description_lte: The description_lte of this BackupServiceWhereInput.  # noqa: E501
        :type description_lte: str
        """

        self._description_lte = description_lte

    @property
    def description_not(self):
        """Gets the description_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not

    @description_not.setter
    def description_not(self, description_not):
        """Sets the description_not of this BackupServiceWhereInput.


        :param description_not: The description_not of this BackupServiceWhereInput.  # noqa: E501
        :type description_not: str
        """

        self._description_not = description_not

    @property
    def description_not_contains(self):
        """Gets the description_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_contains

    @description_not_contains.setter
    def description_not_contains(self, description_not_contains):
        """Sets the description_not_contains of this BackupServiceWhereInput.


        :param description_not_contains: The description_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type description_not_contains: str
        """

        self._description_not_contains = description_not_contains

    @property
    def description_not_ends_with(self):
        """Gets the description_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_ends_with

    @description_not_ends_with.setter
    def description_not_ends_with(self, description_not_ends_with):
        """Sets the description_not_ends_with of this BackupServiceWhereInput.


        :param description_not_ends_with: The description_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type description_not_ends_with: str
        """

        self._description_not_ends_with = description_not_ends_with

    @property
    def description_not_in(self):
        """Gets the description_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_not_in

    @description_not_in.setter
    def description_not_in(self, description_not_in):
        """Sets the description_not_in of this BackupServiceWhereInput.


        :param description_not_in: The description_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type description_not_in: list[str]
        """

        self._description_not_in = description_not_in

    @property
    def description_not_starts_with(self):
        """Gets the description_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_starts_with

    @description_not_starts_with.setter
    def description_not_starts_with(self, description_not_starts_with):
        """Sets the description_not_starts_with of this BackupServiceWhereInput.


        :param description_not_starts_with: The description_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type description_not_starts_with: str
        """

        self._description_not_starts_with = description_not_starts_with

    @property
    def description_starts_with(self):
        """Gets the description_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The description_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_starts_with

    @description_starts_with.setter
    def description_starts_with(self, description_starts_with):
        """Sets the description_starts_with of this BackupServiceWhereInput.


        :param description_starts_with: The description_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type description_starts_with: str
        """

        self._description_starts_with = description_starts_with

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this BackupServiceWhereInput.  # noqa: E501


        :return: The entity_async_status of this BackupServiceWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this BackupServiceWhereInput.


        :param entity_async_status: The entity_async_status of this BackupServiceWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this BackupServiceWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this BackupServiceWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this BackupServiceWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this BackupServiceWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this BackupServiceWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def id(self):
        """Gets the id of this BackupServiceWhereInput.  # noqa: E501


        :return: The id of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BackupServiceWhereInput.


        :param id: The id of this BackupServiceWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this BackupServiceWhereInput.


        :param id_contains: The id_contains of this BackupServiceWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this BackupServiceWhereInput.


        :param id_ends_with: The id_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this BackupServiceWhereInput.


        :param id_gt: The id_gt of this BackupServiceWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this BackupServiceWhereInput.


        :param id_gte: The id_gte of this BackupServiceWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this BackupServiceWhereInput.


        :param id_in: The id_in of this BackupServiceWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this BackupServiceWhereInput.


        :param id_lt: The id_lt of this BackupServiceWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this BackupServiceWhereInput.


        :param id_lte: The id_lte of this BackupServiceWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this BackupServiceWhereInput.


        :param id_not: The id_not of this BackupServiceWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this BackupServiceWhereInput.


        :param id_not_contains: The id_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this BackupServiceWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this BackupServiceWhereInput.


        :param id_not_in: The id_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this BackupServiceWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The id_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this BackupServiceWhereInput.


        :param id_starts_with: The id_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def kube_config(self):
        """Gets the kube_config of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config

    @kube_config.setter
    def kube_config(self, kube_config):
        """Sets the kube_config of this BackupServiceWhereInput.


        :param kube_config: The kube_config of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config: str
        """

        self._kube_config = kube_config

    @property
    def kube_config_contains(self):
        """Gets the kube_config_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_contains

    @kube_config_contains.setter
    def kube_config_contains(self, kube_config_contains):
        """Sets the kube_config_contains of this BackupServiceWhereInput.


        :param kube_config_contains: The kube_config_contains of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_contains: str
        """

        self._kube_config_contains = kube_config_contains

    @property
    def kube_config_ends_with(self):
        """Gets the kube_config_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_ends_with

    @kube_config_ends_with.setter
    def kube_config_ends_with(self, kube_config_ends_with):
        """Sets the kube_config_ends_with of this BackupServiceWhereInput.


        :param kube_config_ends_with: The kube_config_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_ends_with: str
        """

        self._kube_config_ends_with = kube_config_ends_with

    @property
    def kube_config_gt(self):
        """Gets the kube_config_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_gt

    @kube_config_gt.setter
    def kube_config_gt(self, kube_config_gt):
        """Sets the kube_config_gt of this BackupServiceWhereInput.


        :param kube_config_gt: The kube_config_gt of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_gt: str
        """

        self._kube_config_gt = kube_config_gt

    @property
    def kube_config_gte(self):
        """Gets the kube_config_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_gte

    @kube_config_gte.setter
    def kube_config_gte(self, kube_config_gte):
        """Sets the kube_config_gte of this BackupServiceWhereInput.


        :param kube_config_gte: The kube_config_gte of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_gte: str
        """

        self._kube_config_gte = kube_config_gte

    @property
    def kube_config_in(self):
        """Gets the kube_config_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._kube_config_in

    @kube_config_in.setter
    def kube_config_in(self, kube_config_in):
        """Sets the kube_config_in of this BackupServiceWhereInput.


        :param kube_config_in: The kube_config_in of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_in: list[str]
        """

        self._kube_config_in = kube_config_in

    @property
    def kube_config_lt(self):
        """Gets the kube_config_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_lt

    @kube_config_lt.setter
    def kube_config_lt(self, kube_config_lt):
        """Sets the kube_config_lt of this BackupServiceWhereInput.


        :param kube_config_lt: The kube_config_lt of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_lt: str
        """

        self._kube_config_lt = kube_config_lt

    @property
    def kube_config_lte(self):
        """Gets the kube_config_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_lte

    @kube_config_lte.setter
    def kube_config_lte(self, kube_config_lte):
        """Sets the kube_config_lte of this BackupServiceWhereInput.


        :param kube_config_lte: The kube_config_lte of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_lte: str
        """

        self._kube_config_lte = kube_config_lte

    @property
    def kube_config_not(self):
        """Gets the kube_config_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_not

    @kube_config_not.setter
    def kube_config_not(self, kube_config_not):
        """Sets the kube_config_not of this BackupServiceWhereInput.


        :param kube_config_not: The kube_config_not of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_not: str
        """

        self._kube_config_not = kube_config_not

    @property
    def kube_config_not_contains(self):
        """Gets the kube_config_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_not_contains

    @kube_config_not_contains.setter
    def kube_config_not_contains(self, kube_config_not_contains):
        """Sets the kube_config_not_contains of this BackupServiceWhereInput.


        :param kube_config_not_contains: The kube_config_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_not_contains: str
        """

        self._kube_config_not_contains = kube_config_not_contains

    @property
    def kube_config_not_ends_with(self):
        """Gets the kube_config_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_not_ends_with

    @kube_config_not_ends_with.setter
    def kube_config_not_ends_with(self, kube_config_not_ends_with):
        """Sets the kube_config_not_ends_with of this BackupServiceWhereInput.


        :param kube_config_not_ends_with: The kube_config_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_not_ends_with: str
        """

        self._kube_config_not_ends_with = kube_config_not_ends_with

    @property
    def kube_config_not_in(self):
        """Gets the kube_config_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._kube_config_not_in

    @kube_config_not_in.setter
    def kube_config_not_in(self, kube_config_not_in):
        """Sets the kube_config_not_in of this BackupServiceWhereInput.


        :param kube_config_not_in: The kube_config_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_not_in: list[str]
        """

        self._kube_config_not_in = kube_config_not_in

    @property
    def kube_config_not_starts_with(self):
        """Gets the kube_config_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_not_starts_with

    @kube_config_not_starts_with.setter
    def kube_config_not_starts_with(self, kube_config_not_starts_with):
        """Sets the kube_config_not_starts_with of this BackupServiceWhereInput.


        :param kube_config_not_starts_with: The kube_config_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_not_starts_with: str
        """

        self._kube_config_not_starts_with = kube_config_not_starts_with

    @property
    def kube_config_starts_with(self):
        """Gets the kube_config_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The kube_config_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._kube_config_starts_with

    @kube_config_starts_with.setter
    def kube_config_starts_with(self, kube_config_starts_with):
        """Sets the kube_config_starts_with of this BackupServiceWhereInput.


        :param kube_config_starts_with: The kube_config_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type kube_config_starts_with: str
        """

        self._kube_config_starts_with = kube_config_starts_with

    @property
    def management_network_gateway(self):
        """Gets the management_network_gateway of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway

    @management_network_gateway.setter
    def management_network_gateway(self, management_network_gateway):
        """Sets the management_network_gateway of this BackupServiceWhereInput.


        :param management_network_gateway: The management_network_gateway of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway: str
        """

        self._management_network_gateway = management_network_gateway

    @property
    def management_network_gateway_contains(self):
        """Gets the management_network_gateway_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway_contains

    @management_network_gateway_contains.setter
    def management_network_gateway_contains(self, management_network_gateway_contains):
        """Sets the management_network_gateway_contains of this BackupServiceWhereInput.


        :param management_network_gateway_contains: The management_network_gateway_contains of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_contains: str
        """

        self._management_network_gateway_contains = management_network_gateway_contains

    @property
    def management_network_gateway_ends_with(self):
        """Gets the management_network_gateway_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway_ends_with

    @management_network_gateway_ends_with.setter
    def management_network_gateway_ends_with(self, management_network_gateway_ends_with):
        """Sets the management_network_gateway_ends_with of this BackupServiceWhereInput.


        :param management_network_gateway_ends_with: The management_network_gateway_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_ends_with: str
        """

        self._management_network_gateway_ends_with = management_network_gateway_ends_with

    @property
    def management_network_gateway_gt(self):
        """Gets the management_network_gateway_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway_gt

    @management_network_gateway_gt.setter
    def management_network_gateway_gt(self, management_network_gateway_gt):
        """Sets the management_network_gateway_gt of this BackupServiceWhereInput.


        :param management_network_gateway_gt: The management_network_gateway_gt of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_gt: str
        """

        self._management_network_gateway_gt = management_network_gateway_gt

    @property
    def management_network_gateway_gte(self):
        """Gets the management_network_gateway_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway_gte

    @management_network_gateway_gte.setter
    def management_network_gateway_gte(self, management_network_gateway_gte):
        """Sets the management_network_gateway_gte of this BackupServiceWhereInput.


        :param management_network_gateway_gte: The management_network_gateway_gte of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_gte: str
        """

        self._management_network_gateway_gte = management_network_gateway_gte

    @property
    def management_network_gateway_in(self):
        """Gets the management_network_gateway_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_network_gateway_in

    @management_network_gateway_in.setter
    def management_network_gateway_in(self, management_network_gateway_in):
        """Sets the management_network_gateway_in of this BackupServiceWhereInput.


        :param management_network_gateway_in: The management_network_gateway_in of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_in: list[str]
        """

        self._management_network_gateway_in = management_network_gateway_in

    @property
    def management_network_gateway_lt(self):
        """Gets the management_network_gateway_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway_lt

    @management_network_gateway_lt.setter
    def management_network_gateway_lt(self, management_network_gateway_lt):
        """Sets the management_network_gateway_lt of this BackupServiceWhereInput.


        :param management_network_gateway_lt: The management_network_gateway_lt of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_lt: str
        """

        self._management_network_gateway_lt = management_network_gateway_lt

    @property
    def management_network_gateway_lte(self):
        """Gets the management_network_gateway_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway_lte

    @management_network_gateway_lte.setter
    def management_network_gateway_lte(self, management_network_gateway_lte):
        """Sets the management_network_gateway_lte of this BackupServiceWhereInput.


        :param management_network_gateway_lte: The management_network_gateway_lte of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_lte: str
        """

        self._management_network_gateway_lte = management_network_gateway_lte

    @property
    def management_network_gateway_not(self):
        """Gets the management_network_gateway_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway_not

    @management_network_gateway_not.setter
    def management_network_gateway_not(self, management_network_gateway_not):
        """Sets the management_network_gateway_not of this BackupServiceWhereInput.


        :param management_network_gateway_not: The management_network_gateway_not of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_not: str
        """

        self._management_network_gateway_not = management_network_gateway_not

    @property
    def management_network_gateway_not_contains(self):
        """Gets the management_network_gateway_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway_not_contains

    @management_network_gateway_not_contains.setter
    def management_network_gateway_not_contains(self, management_network_gateway_not_contains):
        """Sets the management_network_gateway_not_contains of this BackupServiceWhereInput.


        :param management_network_gateway_not_contains: The management_network_gateway_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_not_contains: str
        """

        self._management_network_gateway_not_contains = management_network_gateway_not_contains

    @property
    def management_network_gateway_not_ends_with(self):
        """Gets the management_network_gateway_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway_not_ends_with

    @management_network_gateway_not_ends_with.setter
    def management_network_gateway_not_ends_with(self, management_network_gateway_not_ends_with):
        """Sets the management_network_gateway_not_ends_with of this BackupServiceWhereInput.


        :param management_network_gateway_not_ends_with: The management_network_gateway_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_not_ends_with: str
        """

        self._management_network_gateway_not_ends_with = management_network_gateway_not_ends_with

    @property
    def management_network_gateway_not_in(self):
        """Gets the management_network_gateway_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_network_gateway_not_in

    @management_network_gateway_not_in.setter
    def management_network_gateway_not_in(self, management_network_gateway_not_in):
        """Sets the management_network_gateway_not_in of this BackupServiceWhereInput.


        :param management_network_gateway_not_in: The management_network_gateway_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_not_in: list[str]
        """

        self._management_network_gateway_not_in = management_network_gateway_not_in

    @property
    def management_network_gateway_not_starts_with(self):
        """Gets the management_network_gateway_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway_not_starts_with

    @management_network_gateway_not_starts_with.setter
    def management_network_gateway_not_starts_with(self, management_network_gateway_not_starts_with):
        """Sets the management_network_gateway_not_starts_with of this BackupServiceWhereInput.


        :param management_network_gateway_not_starts_with: The management_network_gateway_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_not_starts_with: str
        """

        self._management_network_gateway_not_starts_with = management_network_gateway_not_starts_with

    @property
    def management_network_gateway_starts_with(self):
        """Gets the management_network_gateway_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_gateway_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_gateway_starts_with

    @management_network_gateway_starts_with.setter
    def management_network_gateway_starts_with(self, management_network_gateway_starts_with):
        """Sets the management_network_gateway_starts_with of this BackupServiceWhereInput.


        :param management_network_gateway_starts_with: The management_network_gateway_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_gateway_starts_with: str
        """

        self._management_network_gateway_starts_with = management_network_gateway_starts_with

    @property
    def management_network_ip(self):
        """Gets the management_network_ip of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip

    @management_network_ip.setter
    def management_network_ip(self, management_network_ip):
        """Sets the management_network_ip of this BackupServiceWhereInput.


        :param management_network_ip: The management_network_ip of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip: str
        """

        self._management_network_ip = management_network_ip

    @property
    def management_network_ip_contains(self):
        """Gets the management_network_ip_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip_contains

    @management_network_ip_contains.setter
    def management_network_ip_contains(self, management_network_ip_contains):
        """Sets the management_network_ip_contains of this BackupServiceWhereInput.


        :param management_network_ip_contains: The management_network_ip_contains of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_contains: str
        """

        self._management_network_ip_contains = management_network_ip_contains

    @property
    def management_network_ip_ends_with(self):
        """Gets the management_network_ip_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip_ends_with

    @management_network_ip_ends_with.setter
    def management_network_ip_ends_with(self, management_network_ip_ends_with):
        """Sets the management_network_ip_ends_with of this BackupServiceWhereInput.


        :param management_network_ip_ends_with: The management_network_ip_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_ends_with: str
        """

        self._management_network_ip_ends_with = management_network_ip_ends_with

    @property
    def management_network_ip_gt(self):
        """Gets the management_network_ip_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip_gt

    @management_network_ip_gt.setter
    def management_network_ip_gt(self, management_network_ip_gt):
        """Sets the management_network_ip_gt of this BackupServiceWhereInput.


        :param management_network_ip_gt: The management_network_ip_gt of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_gt: str
        """

        self._management_network_ip_gt = management_network_ip_gt

    @property
    def management_network_ip_gte(self):
        """Gets the management_network_ip_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip_gte

    @management_network_ip_gte.setter
    def management_network_ip_gte(self, management_network_ip_gte):
        """Sets the management_network_ip_gte of this BackupServiceWhereInput.


        :param management_network_ip_gte: The management_network_ip_gte of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_gte: str
        """

        self._management_network_ip_gte = management_network_ip_gte

    @property
    def management_network_ip_in(self):
        """Gets the management_network_ip_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_network_ip_in

    @management_network_ip_in.setter
    def management_network_ip_in(self, management_network_ip_in):
        """Sets the management_network_ip_in of this BackupServiceWhereInput.


        :param management_network_ip_in: The management_network_ip_in of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_in: list[str]
        """

        self._management_network_ip_in = management_network_ip_in

    @property
    def management_network_ip_lt(self):
        """Gets the management_network_ip_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip_lt

    @management_network_ip_lt.setter
    def management_network_ip_lt(self, management_network_ip_lt):
        """Sets the management_network_ip_lt of this BackupServiceWhereInput.


        :param management_network_ip_lt: The management_network_ip_lt of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_lt: str
        """

        self._management_network_ip_lt = management_network_ip_lt

    @property
    def management_network_ip_lte(self):
        """Gets the management_network_ip_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip_lte

    @management_network_ip_lte.setter
    def management_network_ip_lte(self, management_network_ip_lte):
        """Sets the management_network_ip_lte of this BackupServiceWhereInput.


        :param management_network_ip_lte: The management_network_ip_lte of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_lte: str
        """

        self._management_network_ip_lte = management_network_ip_lte

    @property
    def management_network_ip_not(self):
        """Gets the management_network_ip_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip_not

    @management_network_ip_not.setter
    def management_network_ip_not(self, management_network_ip_not):
        """Sets the management_network_ip_not of this BackupServiceWhereInput.


        :param management_network_ip_not: The management_network_ip_not of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_not: str
        """

        self._management_network_ip_not = management_network_ip_not

    @property
    def management_network_ip_not_contains(self):
        """Gets the management_network_ip_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip_not_contains

    @management_network_ip_not_contains.setter
    def management_network_ip_not_contains(self, management_network_ip_not_contains):
        """Sets the management_network_ip_not_contains of this BackupServiceWhereInput.


        :param management_network_ip_not_contains: The management_network_ip_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_not_contains: str
        """

        self._management_network_ip_not_contains = management_network_ip_not_contains

    @property
    def management_network_ip_not_ends_with(self):
        """Gets the management_network_ip_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip_not_ends_with

    @management_network_ip_not_ends_with.setter
    def management_network_ip_not_ends_with(self, management_network_ip_not_ends_with):
        """Sets the management_network_ip_not_ends_with of this BackupServiceWhereInput.


        :param management_network_ip_not_ends_with: The management_network_ip_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_not_ends_with: str
        """

        self._management_network_ip_not_ends_with = management_network_ip_not_ends_with

    @property
    def management_network_ip_not_in(self):
        """Gets the management_network_ip_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_network_ip_not_in

    @management_network_ip_not_in.setter
    def management_network_ip_not_in(self, management_network_ip_not_in):
        """Sets the management_network_ip_not_in of this BackupServiceWhereInput.


        :param management_network_ip_not_in: The management_network_ip_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_not_in: list[str]
        """

        self._management_network_ip_not_in = management_network_ip_not_in

    @property
    def management_network_ip_not_starts_with(self):
        """Gets the management_network_ip_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip_not_starts_with

    @management_network_ip_not_starts_with.setter
    def management_network_ip_not_starts_with(self, management_network_ip_not_starts_with):
        """Sets the management_network_ip_not_starts_with of this BackupServiceWhereInput.


        :param management_network_ip_not_starts_with: The management_network_ip_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_not_starts_with: str
        """

        self._management_network_ip_not_starts_with = management_network_ip_not_starts_with

    @property
    def management_network_ip_starts_with(self):
        """Gets the management_network_ip_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_ip_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_ip_starts_with

    @management_network_ip_starts_with.setter
    def management_network_ip_starts_with(self, management_network_ip_starts_with):
        """Sets the management_network_ip_starts_with of this BackupServiceWhereInput.


        :param management_network_ip_starts_with: The management_network_ip_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_ip_starts_with: str
        """

        self._management_network_ip_starts_with = management_network_ip_starts_with

    @property
    def management_network_subnet_mask(self):
        """Gets the management_network_subnet_mask of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask

    @management_network_subnet_mask.setter
    def management_network_subnet_mask(self, management_network_subnet_mask):
        """Sets the management_network_subnet_mask of this BackupServiceWhereInput.


        :param management_network_subnet_mask: The management_network_subnet_mask of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask: str
        """

        self._management_network_subnet_mask = management_network_subnet_mask

    @property
    def management_network_subnet_mask_contains(self):
        """Gets the management_network_subnet_mask_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask_contains

    @management_network_subnet_mask_contains.setter
    def management_network_subnet_mask_contains(self, management_network_subnet_mask_contains):
        """Sets the management_network_subnet_mask_contains of this BackupServiceWhereInput.


        :param management_network_subnet_mask_contains: The management_network_subnet_mask_contains of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_contains: str
        """

        self._management_network_subnet_mask_contains = management_network_subnet_mask_contains

    @property
    def management_network_subnet_mask_ends_with(self):
        """Gets the management_network_subnet_mask_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask_ends_with

    @management_network_subnet_mask_ends_with.setter
    def management_network_subnet_mask_ends_with(self, management_network_subnet_mask_ends_with):
        """Sets the management_network_subnet_mask_ends_with of this BackupServiceWhereInput.


        :param management_network_subnet_mask_ends_with: The management_network_subnet_mask_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_ends_with: str
        """

        self._management_network_subnet_mask_ends_with = management_network_subnet_mask_ends_with

    @property
    def management_network_subnet_mask_gt(self):
        """Gets the management_network_subnet_mask_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask_gt

    @management_network_subnet_mask_gt.setter
    def management_network_subnet_mask_gt(self, management_network_subnet_mask_gt):
        """Sets the management_network_subnet_mask_gt of this BackupServiceWhereInput.


        :param management_network_subnet_mask_gt: The management_network_subnet_mask_gt of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_gt: str
        """

        self._management_network_subnet_mask_gt = management_network_subnet_mask_gt

    @property
    def management_network_subnet_mask_gte(self):
        """Gets the management_network_subnet_mask_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask_gte

    @management_network_subnet_mask_gte.setter
    def management_network_subnet_mask_gte(self, management_network_subnet_mask_gte):
        """Sets the management_network_subnet_mask_gte of this BackupServiceWhereInput.


        :param management_network_subnet_mask_gte: The management_network_subnet_mask_gte of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_gte: str
        """

        self._management_network_subnet_mask_gte = management_network_subnet_mask_gte

    @property
    def management_network_subnet_mask_in(self):
        """Gets the management_network_subnet_mask_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_network_subnet_mask_in

    @management_network_subnet_mask_in.setter
    def management_network_subnet_mask_in(self, management_network_subnet_mask_in):
        """Sets the management_network_subnet_mask_in of this BackupServiceWhereInput.


        :param management_network_subnet_mask_in: The management_network_subnet_mask_in of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_in: list[str]
        """

        self._management_network_subnet_mask_in = management_network_subnet_mask_in

    @property
    def management_network_subnet_mask_lt(self):
        """Gets the management_network_subnet_mask_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask_lt

    @management_network_subnet_mask_lt.setter
    def management_network_subnet_mask_lt(self, management_network_subnet_mask_lt):
        """Sets the management_network_subnet_mask_lt of this BackupServiceWhereInput.


        :param management_network_subnet_mask_lt: The management_network_subnet_mask_lt of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_lt: str
        """

        self._management_network_subnet_mask_lt = management_network_subnet_mask_lt

    @property
    def management_network_subnet_mask_lte(self):
        """Gets the management_network_subnet_mask_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask_lte

    @management_network_subnet_mask_lte.setter
    def management_network_subnet_mask_lte(self, management_network_subnet_mask_lte):
        """Sets the management_network_subnet_mask_lte of this BackupServiceWhereInput.


        :param management_network_subnet_mask_lte: The management_network_subnet_mask_lte of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_lte: str
        """

        self._management_network_subnet_mask_lte = management_network_subnet_mask_lte

    @property
    def management_network_subnet_mask_not(self):
        """Gets the management_network_subnet_mask_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask_not

    @management_network_subnet_mask_not.setter
    def management_network_subnet_mask_not(self, management_network_subnet_mask_not):
        """Sets the management_network_subnet_mask_not of this BackupServiceWhereInput.


        :param management_network_subnet_mask_not: The management_network_subnet_mask_not of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_not: str
        """

        self._management_network_subnet_mask_not = management_network_subnet_mask_not

    @property
    def management_network_subnet_mask_not_contains(self):
        """Gets the management_network_subnet_mask_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask_not_contains

    @management_network_subnet_mask_not_contains.setter
    def management_network_subnet_mask_not_contains(self, management_network_subnet_mask_not_contains):
        """Sets the management_network_subnet_mask_not_contains of this BackupServiceWhereInput.


        :param management_network_subnet_mask_not_contains: The management_network_subnet_mask_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_not_contains: str
        """

        self._management_network_subnet_mask_not_contains = management_network_subnet_mask_not_contains

    @property
    def management_network_subnet_mask_not_ends_with(self):
        """Gets the management_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask_not_ends_with

    @management_network_subnet_mask_not_ends_with.setter
    def management_network_subnet_mask_not_ends_with(self, management_network_subnet_mask_not_ends_with):
        """Sets the management_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.


        :param management_network_subnet_mask_not_ends_with: The management_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_not_ends_with: str
        """

        self._management_network_subnet_mask_not_ends_with = management_network_subnet_mask_not_ends_with

    @property
    def management_network_subnet_mask_not_in(self):
        """Gets the management_network_subnet_mask_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_network_subnet_mask_not_in

    @management_network_subnet_mask_not_in.setter
    def management_network_subnet_mask_not_in(self, management_network_subnet_mask_not_in):
        """Sets the management_network_subnet_mask_not_in of this BackupServiceWhereInput.


        :param management_network_subnet_mask_not_in: The management_network_subnet_mask_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_not_in: list[str]
        """

        self._management_network_subnet_mask_not_in = management_network_subnet_mask_not_in

    @property
    def management_network_subnet_mask_not_starts_with(self):
        """Gets the management_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask_not_starts_with

    @management_network_subnet_mask_not_starts_with.setter
    def management_network_subnet_mask_not_starts_with(self, management_network_subnet_mask_not_starts_with):
        """Sets the management_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.


        :param management_network_subnet_mask_not_starts_with: The management_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_not_starts_with: str
        """

        self._management_network_subnet_mask_not_starts_with = management_network_subnet_mask_not_starts_with

    @property
    def management_network_subnet_mask_starts_with(self):
        """Gets the management_network_subnet_mask_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_subnet_mask_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_subnet_mask_starts_with

    @management_network_subnet_mask_starts_with.setter
    def management_network_subnet_mask_starts_with(self, management_network_subnet_mask_starts_with):
        """Sets the management_network_subnet_mask_starts_with of this BackupServiceWhereInput.


        :param management_network_subnet_mask_starts_with: The management_network_subnet_mask_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_subnet_mask_starts_with: str
        """

        self._management_network_subnet_mask_starts_with = management_network_subnet_mask_starts_with

    @property
    def management_network_vlan(self):
        """Gets the management_network_vlan of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan

    @management_network_vlan.setter
    def management_network_vlan(self, management_network_vlan):
        """Sets the management_network_vlan of this BackupServiceWhereInput.


        :param management_network_vlan: The management_network_vlan of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan: str
        """

        self._management_network_vlan = management_network_vlan

    @property
    def management_network_vlan_contains(self):
        """Gets the management_network_vlan_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan_contains

    @management_network_vlan_contains.setter
    def management_network_vlan_contains(self, management_network_vlan_contains):
        """Sets the management_network_vlan_contains of this BackupServiceWhereInput.


        :param management_network_vlan_contains: The management_network_vlan_contains of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_contains: str
        """

        self._management_network_vlan_contains = management_network_vlan_contains

    @property
    def management_network_vlan_ends_with(self):
        """Gets the management_network_vlan_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan_ends_with

    @management_network_vlan_ends_with.setter
    def management_network_vlan_ends_with(self, management_network_vlan_ends_with):
        """Sets the management_network_vlan_ends_with of this BackupServiceWhereInput.


        :param management_network_vlan_ends_with: The management_network_vlan_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_ends_with: str
        """

        self._management_network_vlan_ends_with = management_network_vlan_ends_with

    @property
    def management_network_vlan_gt(self):
        """Gets the management_network_vlan_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan_gt

    @management_network_vlan_gt.setter
    def management_network_vlan_gt(self, management_network_vlan_gt):
        """Sets the management_network_vlan_gt of this BackupServiceWhereInput.


        :param management_network_vlan_gt: The management_network_vlan_gt of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_gt: str
        """

        self._management_network_vlan_gt = management_network_vlan_gt

    @property
    def management_network_vlan_gte(self):
        """Gets the management_network_vlan_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan_gte

    @management_network_vlan_gte.setter
    def management_network_vlan_gte(self, management_network_vlan_gte):
        """Sets the management_network_vlan_gte of this BackupServiceWhereInput.


        :param management_network_vlan_gte: The management_network_vlan_gte of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_gte: str
        """

        self._management_network_vlan_gte = management_network_vlan_gte

    @property
    def management_network_vlan_in(self):
        """Gets the management_network_vlan_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_network_vlan_in

    @management_network_vlan_in.setter
    def management_network_vlan_in(self, management_network_vlan_in):
        """Sets the management_network_vlan_in of this BackupServiceWhereInput.


        :param management_network_vlan_in: The management_network_vlan_in of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_in: list[str]
        """

        self._management_network_vlan_in = management_network_vlan_in

    @property
    def management_network_vlan_lt(self):
        """Gets the management_network_vlan_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan_lt

    @management_network_vlan_lt.setter
    def management_network_vlan_lt(self, management_network_vlan_lt):
        """Sets the management_network_vlan_lt of this BackupServiceWhereInput.


        :param management_network_vlan_lt: The management_network_vlan_lt of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_lt: str
        """

        self._management_network_vlan_lt = management_network_vlan_lt

    @property
    def management_network_vlan_lte(self):
        """Gets the management_network_vlan_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan_lte

    @management_network_vlan_lte.setter
    def management_network_vlan_lte(self, management_network_vlan_lte):
        """Sets the management_network_vlan_lte of this BackupServiceWhereInput.


        :param management_network_vlan_lte: The management_network_vlan_lte of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_lte: str
        """

        self._management_network_vlan_lte = management_network_vlan_lte

    @property
    def management_network_vlan_not(self):
        """Gets the management_network_vlan_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan_not

    @management_network_vlan_not.setter
    def management_network_vlan_not(self, management_network_vlan_not):
        """Sets the management_network_vlan_not of this BackupServiceWhereInput.


        :param management_network_vlan_not: The management_network_vlan_not of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_not: str
        """

        self._management_network_vlan_not = management_network_vlan_not

    @property
    def management_network_vlan_not_contains(self):
        """Gets the management_network_vlan_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan_not_contains

    @management_network_vlan_not_contains.setter
    def management_network_vlan_not_contains(self, management_network_vlan_not_contains):
        """Sets the management_network_vlan_not_contains of this BackupServiceWhereInput.


        :param management_network_vlan_not_contains: The management_network_vlan_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_not_contains: str
        """

        self._management_network_vlan_not_contains = management_network_vlan_not_contains

    @property
    def management_network_vlan_not_ends_with(self):
        """Gets the management_network_vlan_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan_not_ends_with

    @management_network_vlan_not_ends_with.setter
    def management_network_vlan_not_ends_with(self, management_network_vlan_not_ends_with):
        """Sets the management_network_vlan_not_ends_with of this BackupServiceWhereInput.


        :param management_network_vlan_not_ends_with: The management_network_vlan_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_not_ends_with: str
        """

        self._management_network_vlan_not_ends_with = management_network_vlan_not_ends_with

    @property
    def management_network_vlan_not_in(self):
        """Gets the management_network_vlan_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._management_network_vlan_not_in

    @management_network_vlan_not_in.setter
    def management_network_vlan_not_in(self, management_network_vlan_not_in):
        """Sets the management_network_vlan_not_in of this BackupServiceWhereInput.


        :param management_network_vlan_not_in: The management_network_vlan_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_not_in: list[str]
        """

        self._management_network_vlan_not_in = management_network_vlan_not_in

    @property
    def management_network_vlan_not_starts_with(self):
        """Gets the management_network_vlan_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan_not_starts_with

    @management_network_vlan_not_starts_with.setter
    def management_network_vlan_not_starts_with(self, management_network_vlan_not_starts_with):
        """Sets the management_network_vlan_not_starts_with of this BackupServiceWhereInput.


        :param management_network_vlan_not_starts_with: The management_network_vlan_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_not_starts_with: str
        """

        self._management_network_vlan_not_starts_with = management_network_vlan_not_starts_with

    @property
    def management_network_vlan_starts_with(self):
        """Gets the management_network_vlan_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The management_network_vlan_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._management_network_vlan_starts_with

    @management_network_vlan_starts_with.setter
    def management_network_vlan_starts_with(self, management_network_vlan_starts_with):
        """Sets the management_network_vlan_starts_with of this BackupServiceWhereInput.


        :param management_network_vlan_starts_with: The management_network_vlan_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type management_network_vlan_starts_with: str
        """

        self._management_network_vlan_starts_with = management_network_vlan_starts_with

    @property
    def max_job_retry_times(self):
        """Gets the max_job_retry_times of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_job_retry_times of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_job_retry_times

    @max_job_retry_times.setter
    def max_job_retry_times(self, max_job_retry_times):
        """Sets the max_job_retry_times of this BackupServiceWhereInput.


        :param max_job_retry_times: The max_job_retry_times of this BackupServiceWhereInput.  # noqa: E501
        :type max_job_retry_times: int
        """

        self._max_job_retry_times = max_job_retry_times

    @property
    def max_job_retry_times_gt(self):
        """Gets the max_job_retry_times_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_job_retry_times_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_job_retry_times_gt

    @max_job_retry_times_gt.setter
    def max_job_retry_times_gt(self, max_job_retry_times_gt):
        """Sets the max_job_retry_times_gt of this BackupServiceWhereInput.


        :param max_job_retry_times_gt: The max_job_retry_times_gt of this BackupServiceWhereInput.  # noqa: E501
        :type max_job_retry_times_gt: int
        """

        self._max_job_retry_times_gt = max_job_retry_times_gt

    @property
    def max_job_retry_times_gte(self):
        """Gets the max_job_retry_times_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_job_retry_times_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_job_retry_times_gte

    @max_job_retry_times_gte.setter
    def max_job_retry_times_gte(self, max_job_retry_times_gte):
        """Sets the max_job_retry_times_gte of this BackupServiceWhereInput.


        :param max_job_retry_times_gte: The max_job_retry_times_gte of this BackupServiceWhereInput.  # noqa: E501
        :type max_job_retry_times_gte: int
        """

        self._max_job_retry_times_gte = max_job_retry_times_gte

    @property
    def max_job_retry_times_in(self):
        """Gets the max_job_retry_times_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_job_retry_times_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_job_retry_times_in

    @max_job_retry_times_in.setter
    def max_job_retry_times_in(self, max_job_retry_times_in):
        """Sets the max_job_retry_times_in of this BackupServiceWhereInput.


        :param max_job_retry_times_in: The max_job_retry_times_in of this BackupServiceWhereInput.  # noqa: E501
        :type max_job_retry_times_in: list[int]
        """

        self._max_job_retry_times_in = max_job_retry_times_in

    @property
    def max_job_retry_times_lt(self):
        """Gets the max_job_retry_times_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_job_retry_times_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_job_retry_times_lt

    @max_job_retry_times_lt.setter
    def max_job_retry_times_lt(self, max_job_retry_times_lt):
        """Sets the max_job_retry_times_lt of this BackupServiceWhereInput.


        :param max_job_retry_times_lt: The max_job_retry_times_lt of this BackupServiceWhereInput.  # noqa: E501
        :type max_job_retry_times_lt: int
        """

        self._max_job_retry_times_lt = max_job_retry_times_lt

    @property
    def max_job_retry_times_lte(self):
        """Gets the max_job_retry_times_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_job_retry_times_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_job_retry_times_lte

    @max_job_retry_times_lte.setter
    def max_job_retry_times_lte(self, max_job_retry_times_lte):
        """Sets the max_job_retry_times_lte of this BackupServiceWhereInput.


        :param max_job_retry_times_lte: The max_job_retry_times_lte of this BackupServiceWhereInput.  # noqa: E501
        :type max_job_retry_times_lte: int
        """

        self._max_job_retry_times_lte = max_job_retry_times_lte

    @property
    def max_job_retry_times_not(self):
        """Gets the max_job_retry_times_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_job_retry_times_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_job_retry_times_not

    @max_job_retry_times_not.setter
    def max_job_retry_times_not(self, max_job_retry_times_not):
        """Sets the max_job_retry_times_not of this BackupServiceWhereInput.


        :param max_job_retry_times_not: The max_job_retry_times_not of this BackupServiceWhereInput.  # noqa: E501
        :type max_job_retry_times_not: int
        """

        self._max_job_retry_times_not = max_job_retry_times_not

    @property
    def max_job_retry_times_not_in(self):
        """Gets the max_job_retry_times_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_job_retry_times_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_job_retry_times_not_in

    @max_job_retry_times_not_in.setter
    def max_job_retry_times_not_in(self, max_job_retry_times_not_in):
        """Sets the max_job_retry_times_not_in of this BackupServiceWhereInput.


        :param max_job_retry_times_not_in: The max_job_retry_times_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type max_job_retry_times_not_in: list[int]
        """

        self._max_job_retry_times_not_in = max_job_retry_times_not_in

    @property
    def max_parallel_backup_jobs(self):
        """Gets the max_parallel_backup_jobs of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_backup_jobs of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_backup_jobs

    @max_parallel_backup_jobs.setter
    def max_parallel_backup_jobs(self, max_parallel_backup_jobs):
        """Sets the max_parallel_backup_jobs of this BackupServiceWhereInput.


        :param max_parallel_backup_jobs: The max_parallel_backup_jobs of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_backup_jobs: int
        """

        self._max_parallel_backup_jobs = max_parallel_backup_jobs

    @property
    def max_parallel_backup_jobs_gt(self):
        """Gets the max_parallel_backup_jobs_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_backup_jobs_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_backup_jobs_gt

    @max_parallel_backup_jobs_gt.setter
    def max_parallel_backup_jobs_gt(self, max_parallel_backup_jobs_gt):
        """Sets the max_parallel_backup_jobs_gt of this BackupServiceWhereInput.


        :param max_parallel_backup_jobs_gt: The max_parallel_backup_jobs_gt of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_backup_jobs_gt: int
        """

        self._max_parallel_backup_jobs_gt = max_parallel_backup_jobs_gt

    @property
    def max_parallel_backup_jobs_gte(self):
        """Gets the max_parallel_backup_jobs_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_backup_jobs_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_backup_jobs_gte

    @max_parallel_backup_jobs_gte.setter
    def max_parallel_backup_jobs_gte(self, max_parallel_backup_jobs_gte):
        """Sets the max_parallel_backup_jobs_gte of this BackupServiceWhereInput.


        :param max_parallel_backup_jobs_gte: The max_parallel_backup_jobs_gte of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_backup_jobs_gte: int
        """

        self._max_parallel_backup_jobs_gte = max_parallel_backup_jobs_gte

    @property
    def max_parallel_backup_jobs_in(self):
        """Gets the max_parallel_backup_jobs_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_backup_jobs_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_parallel_backup_jobs_in

    @max_parallel_backup_jobs_in.setter
    def max_parallel_backup_jobs_in(self, max_parallel_backup_jobs_in):
        """Sets the max_parallel_backup_jobs_in of this BackupServiceWhereInput.


        :param max_parallel_backup_jobs_in: The max_parallel_backup_jobs_in of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_backup_jobs_in: list[int]
        """

        self._max_parallel_backup_jobs_in = max_parallel_backup_jobs_in

    @property
    def max_parallel_backup_jobs_lt(self):
        """Gets the max_parallel_backup_jobs_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_backup_jobs_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_backup_jobs_lt

    @max_parallel_backup_jobs_lt.setter
    def max_parallel_backup_jobs_lt(self, max_parallel_backup_jobs_lt):
        """Sets the max_parallel_backup_jobs_lt of this BackupServiceWhereInput.


        :param max_parallel_backup_jobs_lt: The max_parallel_backup_jobs_lt of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_backup_jobs_lt: int
        """

        self._max_parallel_backup_jobs_lt = max_parallel_backup_jobs_lt

    @property
    def max_parallel_backup_jobs_lte(self):
        """Gets the max_parallel_backup_jobs_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_backup_jobs_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_backup_jobs_lte

    @max_parallel_backup_jobs_lte.setter
    def max_parallel_backup_jobs_lte(self, max_parallel_backup_jobs_lte):
        """Sets the max_parallel_backup_jobs_lte of this BackupServiceWhereInput.


        :param max_parallel_backup_jobs_lte: The max_parallel_backup_jobs_lte of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_backup_jobs_lte: int
        """

        self._max_parallel_backup_jobs_lte = max_parallel_backup_jobs_lte

    @property
    def max_parallel_backup_jobs_not(self):
        """Gets the max_parallel_backup_jobs_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_backup_jobs_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_backup_jobs_not

    @max_parallel_backup_jobs_not.setter
    def max_parallel_backup_jobs_not(self, max_parallel_backup_jobs_not):
        """Sets the max_parallel_backup_jobs_not of this BackupServiceWhereInput.


        :param max_parallel_backup_jobs_not: The max_parallel_backup_jobs_not of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_backup_jobs_not: int
        """

        self._max_parallel_backup_jobs_not = max_parallel_backup_jobs_not

    @property
    def max_parallel_backup_jobs_not_in(self):
        """Gets the max_parallel_backup_jobs_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_backup_jobs_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_parallel_backup_jobs_not_in

    @max_parallel_backup_jobs_not_in.setter
    def max_parallel_backup_jobs_not_in(self, max_parallel_backup_jobs_not_in):
        """Sets the max_parallel_backup_jobs_not_in of this BackupServiceWhereInput.


        :param max_parallel_backup_jobs_not_in: The max_parallel_backup_jobs_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_backup_jobs_not_in: list[int]
        """

        self._max_parallel_backup_jobs_not_in = max_parallel_backup_jobs_not_in

    @property
    def max_parallel_restore_jobs(self):
        """Gets the max_parallel_restore_jobs of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_restore_jobs of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_restore_jobs

    @max_parallel_restore_jobs.setter
    def max_parallel_restore_jobs(self, max_parallel_restore_jobs):
        """Sets the max_parallel_restore_jobs of this BackupServiceWhereInput.


        :param max_parallel_restore_jobs: The max_parallel_restore_jobs of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_restore_jobs: int
        """

        self._max_parallel_restore_jobs = max_parallel_restore_jobs

    @property
    def max_parallel_restore_jobs_gt(self):
        """Gets the max_parallel_restore_jobs_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_restore_jobs_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_restore_jobs_gt

    @max_parallel_restore_jobs_gt.setter
    def max_parallel_restore_jobs_gt(self, max_parallel_restore_jobs_gt):
        """Sets the max_parallel_restore_jobs_gt of this BackupServiceWhereInput.


        :param max_parallel_restore_jobs_gt: The max_parallel_restore_jobs_gt of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_restore_jobs_gt: int
        """

        self._max_parallel_restore_jobs_gt = max_parallel_restore_jobs_gt

    @property
    def max_parallel_restore_jobs_gte(self):
        """Gets the max_parallel_restore_jobs_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_restore_jobs_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_restore_jobs_gte

    @max_parallel_restore_jobs_gte.setter
    def max_parallel_restore_jobs_gte(self, max_parallel_restore_jobs_gte):
        """Sets the max_parallel_restore_jobs_gte of this BackupServiceWhereInput.


        :param max_parallel_restore_jobs_gte: The max_parallel_restore_jobs_gte of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_restore_jobs_gte: int
        """

        self._max_parallel_restore_jobs_gte = max_parallel_restore_jobs_gte

    @property
    def max_parallel_restore_jobs_in(self):
        """Gets the max_parallel_restore_jobs_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_restore_jobs_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_parallel_restore_jobs_in

    @max_parallel_restore_jobs_in.setter
    def max_parallel_restore_jobs_in(self, max_parallel_restore_jobs_in):
        """Sets the max_parallel_restore_jobs_in of this BackupServiceWhereInput.


        :param max_parallel_restore_jobs_in: The max_parallel_restore_jobs_in of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_restore_jobs_in: list[int]
        """

        self._max_parallel_restore_jobs_in = max_parallel_restore_jobs_in

    @property
    def max_parallel_restore_jobs_lt(self):
        """Gets the max_parallel_restore_jobs_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_restore_jobs_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_restore_jobs_lt

    @max_parallel_restore_jobs_lt.setter
    def max_parallel_restore_jobs_lt(self, max_parallel_restore_jobs_lt):
        """Sets the max_parallel_restore_jobs_lt of this BackupServiceWhereInput.


        :param max_parallel_restore_jobs_lt: The max_parallel_restore_jobs_lt of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_restore_jobs_lt: int
        """

        self._max_parallel_restore_jobs_lt = max_parallel_restore_jobs_lt

    @property
    def max_parallel_restore_jobs_lte(self):
        """Gets the max_parallel_restore_jobs_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_restore_jobs_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_restore_jobs_lte

    @max_parallel_restore_jobs_lte.setter
    def max_parallel_restore_jobs_lte(self, max_parallel_restore_jobs_lte):
        """Sets the max_parallel_restore_jobs_lte of this BackupServiceWhereInput.


        :param max_parallel_restore_jobs_lte: The max_parallel_restore_jobs_lte of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_restore_jobs_lte: int
        """

        self._max_parallel_restore_jobs_lte = max_parallel_restore_jobs_lte

    @property
    def max_parallel_restore_jobs_not(self):
        """Gets the max_parallel_restore_jobs_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_restore_jobs_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._max_parallel_restore_jobs_not

    @max_parallel_restore_jobs_not.setter
    def max_parallel_restore_jobs_not(self, max_parallel_restore_jobs_not):
        """Sets the max_parallel_restore_jobs_not of this BackupServiceWhereInput.


        :param max_parallel_restore_jobs_not: The max_parallel_restore_jobs_not of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_restore_jobs_not: int
        """

        self._max_parallel_restore_jobs_not = max_parallel_restore_jobs_not

    @property
    def max_parallel_restore_jobs_not_in(self):
        """Gets the max_parallel_restore_jobs_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The max_parallel_restore_jobs_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._max_parallel_restore_jobs_not_in

    @max_parallel_restore_jobs_not_in.setter
    def max_parallel_restore_jobs_not_in(self, max_parallel_restore_jobs_not_in):
        """Sets the max_parallel_restore_jobs_not_in of this BackupServiceWhereInput.


        :param max_parallel_restore_jobs_not_in: The max_parallel_restore_jobs_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type max_parallel_restore_jobs_not_in: list[int]
        """

        self._max_parallel_restore_jobs_not_in = max_parallel_restore_jobs_not_in

    @property
    def name(self):
        """Gets the name of this BackupServiceWhereInput.  # noqa: E501


        :return: The name of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BackupServiceWhereInput.


        :param name: The name of this BackupServiceWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this BackupServiceWhereInput.


        :param name_contains: The name_contains of this BackupServiceWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this BackupServiceWhereInput.


        :param name_ends_with: The name_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this BackupServiceWhereInput.


        :param name_gt: The name_gt of this BackupServiceWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this BackupServiceWhereInput.


        :param name_gte: The name_gte of this BackupServiceWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this BackupServiceWhereInput.


        :param name_in: The name_in of this BackupServiceWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this BackupServiceWhereInput.


        :param name_lt: The name_lt of this BackupServiceWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this BackupServiceWhereInput.


        :param name_lte: The name_lte of this BackupServiceWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this BackupServiceWhereInput.


        :param name_not: The name_not of this BackupServiceWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this BackupServiceWhereInput.


        :param name_not_contains: The name_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this BackupServiceWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this BackupServiceWhereInput.


        :param name_not_in: The name_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this BackupServiceWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The name_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this BackupServiceWhereInput.


        :param name_starts_with: The name_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def restore_rd_iops_max(self):
        """Gets the restore_rd_iops_max of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_rd_iops_max of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_rd_iops_max

    @restore_rd_iops_max.setter
    def restore_rd_iops_max(self, restore_rd_iops_max):
        """Sets the restore_rd_iops_max of this BackupServiceWhereInput.


        :param restore_rd_iops_max: The restore_rd_iops_max of this BackupServiceWhereInput.  # noqa: E501
        :type restore_rd_iops_max: int
        """

        self._restore_rd_iops_max = restore_rd_iops_max

    @property
    def restore_rd_iops_max_gt(self):
        """Gets the restore_rd_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_rd_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_rd_iops_max_gt

    @restore_rd_iops_max_gt.setter
    def restore_rd_iops_max_gt(self, restore_rd_iops_max_gt):
        """Sets the restore_rd_iops_max_gt of this BackupServiceWhereInput.


        :param restore_rd_iops_max_gt: The restore_rd_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501
        :type restore_rd_iops_max_gt: int
        """

        self._restore_rd_iops_max_gt = restore_rd_iops_max_gt

    @property
    def restore_rd_iops_max_gte(self):
        """Gets the restore_rd_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_rd_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_rd_iops_max_gte

    @restore_rd_iops_max_gte.setter
    def restore_rd_iops_max_gte(self, restore_rd_iops_max_gte):
        """Sets the restore_rd_iops_max_gte of this BackupServiceWhereInput.


        :param restore_rd_iops_max_gte: The restore_rd_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501
        :type restore_rd_iops_max_gte: int
        """

        self._restore_rd_iops_max_gte = restore_rd_iops_max_gte

    @property
    def restore_rd_iops_max_in(self):
        """Gets the restore_rd_iops_max_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_rd_iops_max_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._restore_rd_iops_max_in

    @restore_rd_iops_max_in.setter
    def restore_rd_iops_max_in(self, restore_rd_iops_max_in):
        """Sets the restore_rd_iops_max_in of this BackupServiceWhereInput.


        :param restore_rd_iops_max_in: The restore_rd_iops_max_in of this BackupServiceWhereInput.  # noqa: E501
        :type restore_rd_iops_max_in: list[int]
        """

        self._restore_rd_iops_max_in = restore_rd_iops_max_in

    @property
    def restore_rd_iops_max_lt(self):
        """Gets the restore_rd_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_rd_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_rd_iops_max_lt

    @restore_rd_iops_max_lt.setter
    def restore_rd_iops_max_lt(self, restore_rd_iops_max_lt):
        """Sets the restore_rd_iops_max_lt of this BackupServiceWhereInput.


        :param restore_rd_iops_max_lt: The restore_rd_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501
        :type restore_rd_iops_max_lt: int
        """

        self._restore_rd_iops_max_lt = restore_rd_iops_max_lt

    @property
    def restore_rd_iops_max_lte(self):
        """Gets the restore_rd_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_rd_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_rd_iops_max_lte

    @restore_rd_iops_max_lte.setter
    def restore_rd_iops_max_lte(self, restore_rd_iops_max_lte):
        """Sets the restore_rd_iops_max_lte of this BackupServiceWhereInput.


        :param restore_rd_iops_max_lte: The restore_rd_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501
        :type restore_rd_iops_max_lte: int
        """

        self._restore_rd_iops_max_lte = restore_rd_iops_max_lte

    @property
    def restore_rd_iops_max_not(self):
        """Gets the restore_rd_iops_max_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_rd_iops_max_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_rd_iops_max_not

    @restore_rd_iops_max_not.setter
    def restore_rd_iops_max_not(self, restore_rd_iops_max_not):
        """Sets the restore_rd_iops_max_not of this BackupServiceWhereInput.


        :param restore_rd_iops_max_not: The restore_rd_iops_max_not of this BackupServiceWhereInput.  # noqa: E501
        :type restore_rd_iops_max_not: int
        """

        self._restore_rd_iops_max_not = restore_rd_iops_max_not

    @property
    def restore_rd_iops_max_not_in(self):
        """Gets the restore_rd_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_rd_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._restore_rd_iops_max_not_in

    @restore_rd_iops_max_not_in.setter
    def restore_rd_iops_max_not_in(self, restore_rd_iops_max_not_in):
        """Sets the restore_rd_iops_max_not_in of this BackupServiceWhereInput.


        :param restore_rd_iops_max_not_in: The restore_rd_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type restore_rd_iops_max_not_in: list[int]
        """

        self._restore_rd_iops_max_not_in = restore_rd_iops_max_not_in

    @property
    def restore_wr_iops_max(self):
        """Gets the restore_wr_iops_max of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_wr_iops_max of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_wr_iops_max

    @restore_wr_iops_max.setter
    def restore_wr_iops_max(self, restore_wr_iops_max):
        """Sets the restore_wr_iops_max of this BackupServiceWhereInput.


        :param restore_wr_iops_max: The restore_wr_iops_max of this BackupServiceWhereInput.  # noqa: E501
        :type restore_wr_iops_max: int
        """

        self._restore_wr_iops_max = restore_wr_iops_max

    @property
    def restore_wr_iops_max_gt(self):
        """Gets the restore_wr_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_wr_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_wr_iops_max_gt

    @restore_wr_iops_max_gt.setter
    def restore_wr_iops_max_gt(self, restore_wr_iops_max_gt):
        """Sets the restore_wr_iops_max_gt of this BackupServiceWhereInput.


        :param restore_wr_iops_max_gt: The restore_wr_iops_max_gt of this BackupServiceWhereInput.  # noqa: E501
        :type restore_wr_iops_max_gt: int
        """

        self._restore_wr_iops_max_gt = restore_wr_iops_max_gt

    @property
    def restore_wr_iops_max_gte(self):
        """Gets the restore_wr_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_wr_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_wr_iops_max_gte

    @restore_wr_iops_max_gte.setter
    def restore_wr_iops_max_gte(self, restore_wr_iops_max_gte):
        """Sets the restore_wr_iops_max_gte of this BackupServiceWhereInput.


        :param restore_wr_iops_max_gte: The restore_wr_iops_max_gte of this BackupServiceWhereInput.  # noqa: E501
        :type restore_wr_iops_max_gte: int
        """

        self._restore_wr_iops_max_gte = restore_wr_iops_max_gte

    @property
    def restore_wr_iops_max_in(self):
        """Gets the restore_wr_iops_max_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_wr_iops_max_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._restore_wr_iops_max_in

    @restore_wr_iops_max_in.setter
    def restore_wr_iops_max_in(self, restore_wr_iops_max_in):
        """Sets the restore_wr_iops_max_in of this BackupServiceWhereInput.


        :param restore_wr_iops_max_in: The restore_wr_iops_max_in of this BackupServiceWhereInput.  # noqa: E501
        :type restore_wr_iops_max_in: list[int]
        """

        self._restore_wr_iops_max_in = restore_wr_iops_max_in

    @property
    def restore_wr_iops_max_lt(self):
        """Gets the restore_wr_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_wr_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_wr_iops_max_lt

    @restore_wr_iops_max_lt.setter
    def restore_wr_iops_max_lt(self, restore_wr_iops_max_lt):
        """Sets the restore_wr_iops_max_lt of this BackupServiceWhereInput.


        :param restore_wr_iops_max_lt: The restore_wr_iops_max_lt of this BackupServiceWhereInput.  # noqa: E501
        :type restore_wr_iops_max_lt: int
        """

        self._restore_wr_iops_max_lt = restore_wr_iops_max_lt

    @property
    def restore_wr_iops_max_lte(self):
        """Gets the restore_wr_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_wr_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_wr_iops_max_lte

    @restore_wr_iops_max_lte.setter
    def restore_wr_iops_max_lte(self, restore_wr_iops_max_lte):
        """Sets the restore_wr_iops_max_lte of this BackupServiceWhereInput.


        :param restore_wr_iops_max_lte: The restore_wr_iops_max_lte of this BackupServiceWhereInput.  # noqa: E501
        :type restore_wr_iops_max_lte: int
        """

        self._restore_wr_iops_max_lte = restore_wr_iops_max_lte

    @property
    def restore_wr_iops_max_not(self):
        """Gets the restore_wr_iops_max_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_wr_iops_max_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._restore_wr_iops_max_not

    @restore_wr_iops_max_not.setter
    def restore_wr_iops_max_not(self, restore_wr_iops_max_not):
        """Sets the restore_wr_iops_max_not of this BackupServiceWhereInput.


        :param restore_wr_iops_max_not: The restore_wr_iops_max_not of this BackupServiceWhereInput.  # noqa: E501
        :type restore_wr_iops_max_not: int
        """

        self._restore_wr_iops_max_not = restore_wr_iops_max_not

    @property
    def restore_wr_iops_max_not_in(self):
        """Gets the restore_wr_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The restore_wr_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._restore_wr_iops_max_not_in

    @restore_wr_iops_max_not_in.setter
    def restore_wr_iops_max_not_in(self, restore_wr_iops_max_not_in):
        """Sets the restore_wr_iops_max_not_in of this BackupServiceWhereInput.


        :param restore_wr_iops_max_not_in: The restore_wr_iops_max_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type restore_wr_iops_max_not_in: list[int]
        """

        self._restore_wr_iops_max_not_in = restore_wr_iops_max_not_in

    @property
    def retry_interval(self):
        """Gets the retry_interval of this BackupServiceWhereInput.  # noqa: E501


        :return: The retry_interval of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval

    @retry_interval.setter
    def retry_interval(self, retry_interval):
        """Sets the retry_interval of this BackupServiceWhereInput.


        :param retry_interval: The retry_interval of this BackupServiceWhereInput.  # noqa: E501
        :type retry_interval: int
        """

        self._retry_interval = retry_interval

    @property
    def retry_interval_gt(self):
        """Gets the retry_interval_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The retry_interval_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval_gt

    @retry_interval_gt.setter
    def retry_interval_gt(self, retry_interval_gt):
        """Sets the retry_interval_gt of this BackupServiceWhereInput.


        :param retry_interval_gt: The retry_interval_gt of this BackupServiceWhereInput.  # noqa: E501
        :type retry_interval_gt: int
        """

        self._retry_interval_gt = retry_interval_gt

    @property
    def retry_interval_gte(self):
        """Gets the retry_interval_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The retry_interval_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval_gte

    @retry_interval_gte.setter
    def retry_interval_gte(self, retry_interval_gte):
        """Sets the retry_interval_gte of this BackupServiceWhereInput.


        :param retry_interval_gte: The retry_interval_gte of this BackupServiceWhereInput.  # noqa: E501
        :type retry_interval_gte: int
        """

        self._retry_interval_gte = retry_interval_gte

    @property
    def retry_interval_in(self):
        """Gets the retry_interval_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The retry_interval_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._retry_interval_in

    @retry_interval_in.setter
    def retry_interval_in(self, retry_interval_in):
        """Sets the retry_interval_in of this BackupServiceWhereInput.


        :param retry_interval_in: The retry_interval_in of this BackupServiceWhereInput.  # noqa: E501
        :type retry_interval_in: list[int]
        """

        self._retry_interval_in = retry_interval_in

    @property
    def retry_interval_lt(self):
        """Gets the retry_interval_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The retry_interval_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval_lt

    @retry_interval_lt.setter
    def retry_interval_lt(self, retry_interval_lt):
        """Sets the retry_interval_lt of this BackupServiceWhereInput.


        :param retry_interval_lt: The retry_interval_lt of this BackupServiceWhereInput.  # noqa: E501
        :type retry_interval_lt: int
        """

        self._retry_interval_lt = retry_interval_lt

    @property
    def retry_interval_lte(self):
        """Gets the retry_interval_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The retry_interval_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval_lte

    @retry_interval_lte.setter
    def retry_interval_lte(self, retry_interval_lte):
        """Sets the retry_interval_lte of this BackupServiceWhereInput.


        :param retry_interval_lte: The retry_interval_lte of this BackupServiceWhereInput.  # noqa: E501
        :type retry_interval_lte: int
        """

        self._retry_interval_lte = retry_interval_lte

    @property
    def retry_interval_not(self):
        """Gets the retry_interval_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The retry_interval_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_interval_not

    @retry_interval_not.setter
    def retry_interval_not(self, retry_interval_not):
        """Sets the retry_interval_not of this BackupServiceWhereInput.


        :param retry_interval_not: The retry_interval_not of this BackupServiceWhereInput.  # noqa: E501
        :type retry_interval_not: int
        """

        self._retry_interval_not = retry_interval_not

    @property
    def retry_interval_not_in(self):
        """Gets the retry_interval_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The retry_interval_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._retry_interval_not_in

    @retry_interval_not_in.setter
    def retry_interval_not_in(self, retry_interval_not_in):
        """Sets the retry_interval_not_in of this BackupServiceWhereInput.


        :param retry_interval_not_in: The retry_interval_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type retry_interval_not_in: list[int]
        """

        self._retry_interval_not_in = retry_interval_not_in

    @property
    def running_vm(self):
        """Gets the running_vm of this BackupServiceWhereInput.  # noqa: E501


        :return: The running_vm of this BackupServiceWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._running_vm

    @running_vm.setter
    def running_vm(self, running_vm):
        """Sets the running_vm of this BackupServiceWhereInput.


        :param running_vm: The running_vm of this BackupServiceWhereInput.  # noqa: E501
        :type running_vm: VmWhereInput
        """

        self._running_vm = running_vm

    @property
    def status(self):
        """Gets the status of this BackupServiceWhereInput.  # noqa: E501


        :return: The status of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupServiceStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BackupServiceWhereInput.


        :param status: The status of this BackupServiceWhereInput.  # noqa: E501
        :type status: BackupServiceStatus
        """

        self._status = status

    @property
    def status_in(self):
        """Gets the status_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The status_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[BackupServiceStatus]
        """
        return self._status_in

    @status_in.setter
    def status_in(self, status_in):
        """Sets the status_in of this BackupServiceWhereInput.


        :param status_in: The status_in of this BackupServiceWhereInput.  # noqa: E501
        :type status_in: list[BackupServiceStatus]
        """

        self._status_in = status_in

    @property
    def status_not(self):
        """Gets the status_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The status_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupServiceStatus
        """
        return self._status_not

    @status_not.setter
    def status_not(self, status_not):
        """Sets the status_not of this BackupServiceWhereInput.


        :param status_not: The status_not of this BackupServiceWhereInput.  # noqa: E501
        :type status_not: BackupServiceStatus
        """

        self._status_not = status_not

    @property
    def status_not_in(self):
        """Gets the status_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The status_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[BackupServiceStatus]
        """
        return self._status_not_in

    @status_not_in.setter
    def status_not_in(self, status_not_in):
        """Sets the status_not_in of this BackupServiceWhereInput.


        :param status_not_in: The status_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type status_not_in: list[BackupServiceStatus]
        """

        self._status_not_in = status_not_in

    @property
    def storage_network_gateway(self):
        """Gets the storage_network_gateway of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway

    @storage_network_gateway.setter
    def storage_network_gateway(self, storage_network_gateway):
        """Sets the storage_network_gateway of this BackupServiceWhereInput.


        :param storage_network_gateway: The storage_network_gateway of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway: str
        """

        self._storage_network_gateway = storage_network_gateway

    @property
    def storage_network_gateway_contains(self):
        """Gets the storage_network_gateway_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway_contains

    @storage_network_gateway_contains.setter
    def storage_network_gateway_contains(self, storage_network_gateway_contains):
        """Sets the storage_network_gateway_contains of this BackupServiceWhereInput.


        :param storage_network_gateway_contains: The storage_network_gateway_contains of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_contains: str
        """

        self._storage_network_gateway_contains = storage_network_gateway_contains

    @property
    def storage_network_gateway_ends_with(self):
        """Gets the storage_network_gateway_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway_ends_with

    @storage_network_gateway_ends_with.setter
    def storage_network_gateway_ends_with(self, storage_network_gateway_ends_with):
        """Sets the storage_network_gateway_ends_with of this BackupServiceWhereInput.


        :param storage_network_gateway_ends_with: The storage_network_gateway_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_ends_with: str
        """

        self._storage_network_gateway_ends_with = storage_network_gateway_ends_with

    @property
    def storage_network_gateway_gt(self):
        """Gets the storage_network_gateway_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway_gt

    @storage_network_gateway_gt.setter
    def storage_network_gateway_gt(self, storage_network_gateway_gt):
        """Sets the storage_network_gateway_gt of this BackupServiceWhereInput.


        :param storage_network_gateway_gt: The storage_network_gateway_gt of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_gt: str
        """

        self._storage_network_gateway_gt = storage_network_gateway_gt

    @property
    def storage_network_gateway_gte(self):
        """Gets the storage_network_gateway_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway_gte

    @storage_network_gateway_gte.setter
    def storage_network_gateway_gte(self, storage_network_gateway_gte):
        """Sets the storage_network_gateway_gte of this BackupServiceWhereInput.


        :param storage_network_gateway_gte: The storage_network_gateway_gte of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_gte: str
        """

        self._storage_network_gateway_gte = storage_network_gateway_gte

    @property
    def storage_network_gateway_in(self):
        """Gets the storage_network_gateway_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._storage_network_gateway_in

    @storage_network_gateway_in.setter
    def storage_network_gateway_in(self, storage_network_gateway_in):
        """Sets the storage_network_gateway_in of this BackupServiceWhereInput.


        :param storage_network_gateway_in: The storage_network_gateway_in of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_in: list[str]
        """

        self._storage_network_gateway_in = storage_network_gateway_in

    @property
    def storage_network_gateway_lt(self):
        """Gets the storage_network_gateway_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway_lt

    @storage_network_gateway_lt.setter
    def storage_network_gateway_lt(self, storage_network_gateway_lt):
        """Sets the storage_network_gateway_lt of this BackupServiceWhereInput.


        :param storage_network_gateway_lt: The storage_network_gateway_lt of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_lt: str
        """

        self._storage_network_gateway_lt = storage_network_gateway_lt

    @property
    def storage_network_gateway_lte(self):
        """Gets the storage_network_gateway_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway_lte

    @storage_network_gateway_lte.setter
    def storage_network_gateway_lte(self, storage_network_gateway_lte):
        """Sets the storage_network_gateway_lte of this BackupServiceWhereInput.


        :param storage_network_gateway_lte: The storage_network_gateway_lte of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_lte: str
        """

        self._storage_network_gateway_lte = storage_network_gateway_lte

    @property
    def storage_network_gateway_not(self):
        """Gets the storage_network_gateway_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway_not

    @storage_network_gateway_not.setter
    def storage_network_gateway_not(self, storage_network_gateway_not):
        """Sets the storage_network_gateway_not of this BackupServiceWhereInput.


        :param storage_network_gateway_not: The storage_network_gateway_not of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_not: str
        """

        self._storage_network_gateway_not = storage_network_gateway_not

    @property
    def storage_network_gateway_not_contains(self):
        """Gets the storage_network_gateway_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway_not_contains

    @storage_network_gateway_not_contains.setter
    def storage_network_gateway_not_contains(self, storage_network_gateway_not_contains):
        """Sets the storage_network_gateway_not_contains of this BackupServiceWhereInput.


        :param storage_network_gateway_not_contains: The storage_network_gateway_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_not_contains: str
        """

        self._storage_network_gateway_not_contains = storage_network_gateway_not_contains

    @property
    def storage_network_gateway_not_ends_with(self):
        """Gets the storage_network_gateway_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway_not_ends_with

    @storage_network_gateway_not_ends_with.setter
    def storage_network_gateway_not_ends_with(self, storage_network_gateway_not_ends_with):
        """Sets the storage_network_gateway_not_ends_with of this BackupServiceWhereInput.


        :param storage_network_gateway_not_ends_with: The storage_network_gateway_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_not_ends_with: str
        """

        self._storage_network_gateway_not_ends_with = storage_network_gateway_not_ends_with

    @property
    def storage_network_gateway_not_in(self):
        """Gets the storage_network_gateway_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._storage_network_gateway_not_in

    @storage_network_gateway_not_in.setter
    def storage_network_gateway_not_in(self, storage_network_gateway_not_in):
        """Sets the storage_network_gateway_not_in of this BackupServiceWhereInput.


        :param storage_network_gateway_not_in: The storage_network_gateway_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_not_in: list[str]
        """

        self._storage_network_gateway_not_in = storage_network_gateway_not_in

    @property
    def storage_network_gateway_not_starts_with(self):
        """Gets the storage_network_gateway_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway_not_starts_with

    @storage_network_gateway_not_starts_with.setter
    def storage_network_gateway_not_starts_with(self, storage_network_gateway_not_starts_with):
        """Sets the storage_network_gateway_not_starts_with of this BackupServiceWhereInput.


        :param storage_network_gateway_not_starts_with: The storage_network_gateway_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_not_starts_with: str
        """

        self._storage_network_gateway_not_starts_with = storage_network_gateway_not_starts_with

    @property
    def storage_network_gateway_starts_with(self):
        """Gets the storage_network_gateway_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_gateway_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_gateway_starts_with

    @storage_network_gateway_starts_with.setter
    def storage_network_gateway_starts_with(self, storage_network_gateway_starts_with):
        """Sets the storage_network_gateway_starts_with of this BackupServiceWhereInput.


        :param storage_network_gateway_starts_with: The storage_network_gateway_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_gateway_starts_with: str
        """

        self._storage_network_gateway_starts_with = storage_network_gateway_starts_with

    @property
    def storage_network_ip(self):
        """Gets the storage_network_ip of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip

    @storage_network_ip.setter
    def storage_network_ip(self, storage_network_ip):
        """Sets the storage_network_ip of this BackupServiceWhereInput.


        :param storage_network_ip: The storage_network_ip of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip: str
        """

        self._storage_network_ip = storage_network_ip

    @property
    def storage_network_ip_contains(self):
        """Gets the storage_network_ip_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip_contains

    @storage_network_ip_contains.setter
    def storage_network_ip_contains(self, storage_network_ip_contains):
        """Sets the storage_network_ip_contains of this BackupServiceWhereInput.


        :param storage_network_ip_contains: The storage_network_ip_contains of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_contains: str
        """

        self._storage_network_ip_contains = storage_network_ip_contains

    @property
    def storage_network_ip_ends_with(self):
        """Gets the storage_network_ip_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip_ends_with

    @storage_network_ip_ends_with.setter
    def storage_network_ip_ends_with(self, storage_network_ip_ends_with):
        """Sets the storage_network_ip_ends_with of this BackupServiceWhereInput.


        :param storage_network_ip_ends_with: The storage_network_ip_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_ends_with: str
        """

        self._storage_network_ip_ends_with = storage_network_ip_ends_with

    @property
    def storage_network_ip_gt(self):
        """Gets the storage_network_ip_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip_gt

    @storage_network_ip_gt.setter
    def storage_network_ip_gt(self, storage_network_ip_gt):
        """Sets the storage_network_ip_gt of this BackupServiceWhereInput.


        :param storage_network_ip_gt: The storage_network_ip_gt of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_gt: str
        """

        self._storage_network_ip_gt = storage_network_ip_gt

    @property
    def storage_network_ip_gte(self):
        """Gets the storage_network_ip_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip_gte

    @storage_network_ip_gte.setter
    def storage_network_ip_gte(self, storage_network_ip_gte):
        """Sets the storage_network_ip_gte of this BackupServiceWhereInput.


        :param storage_network_ip_gte: The storage_network_ip_gte of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_gte: str
        """

        self._storage_network_ip_gte = storage_network_ip_gte

    @property
    def storage_network_ip_in(self):
        """Gets the storage_network_ip_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._storage_network_ip_in

    @storage_network_ip_in.setter
    def storage_network_ip_in(self, storage_network_ip_in):
        """Sets the storage_network_ip_in of this BackupServiceWhereInput.


        :param storage_network_ip_in: The storage_network_ip_in of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_in: list[str]
        """

        self._storage_network_ip_in = storage_network_ip_in

    @property
    def storage_network_ip_lt(self):
        """Gets the storage_network_ip_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip_lt

    @storage_network_ip_lt.setter
    def storage_network_ip_lt(self, storage_network_ip_lt):
        """Sets the storage_network_ip_lt of this BackupServiceWhereInput.


        :param storage_network_ip_lt: The storage_network_ip_lt of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_lt: str
        """

        self._storage_network_ip_lt = storage_network_ip_lt

    @property
    def storage_network_ip_lte(self):
        """Gets the storage_network_ip_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip_lte

    @storage_network_ip_lte.setter
    def storage_network_ip_lte(self, storage_network_ip_lte):
        """Sets the storage_network_ip_lte of this BackupServiceWhereInput.


        :param storage_network_ip_lte: The storage_network_ip_lte of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_lte: str
        """

        self._storage_network_ip_lte = storage_network_ip_lte

    @property
    def storage_network_ip_not(self):
        """Gets the storage_network_ip_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip_not

    @storage_network_ip_not.setter
    def storage_network_ip_not(self, storage_network_ip_not):
        """Sets the storage_network_ip_not of this BackupServiceWhereInput.


        :param storage_network_ip_not: The storage_network_ip_not of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_not: str
        """

        self._storage_network_ip_not = storage_network_ip_not

    @property
    def storage_network_ip_not_contains(self):
        """Gets the storage_network_ip_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip_not_contains

    @storage_network_ip_not_contains.setter
    def storage_network_ip_not_contains(self, storage_network_ip_not_contains):
        """Sets the storage_network_ip_not_contains of this BackupServiceWhereInput.


        :param storage_network_ip_not_contains: The storage_network_ip_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_not_contains: str
        """

        self._storage_network_ip_not_contains = storage_network_ip_not_contains

    @property
    def storage_network_ip_not_ends_with(self):
        """Gets the storage_network_ip_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip_not_ends_with

    @storage_network_ip_not_ends_with.setter
    def storage_network_ip_not_ends_with(self, storage_network_ip_not_ends_with):
        """Sets the storage_network_ip_not_ends_with of this BackupServiceWhereInput.


        :param storage_network_ip_not_ends_with: The storage_network_ip_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_not_ends_with: str
        """

        self._storage_network_ip_not_ends_with = storage_network_ip_not_ends_with

    @property
    def storage_network_ip_not_in(self):
        """Gets the storage_network_ip_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._storage_network_ip_not_in

    @storage_network_ip_not_in.setter
    def storage_network_ip_not_in(self, storage_network_ip_not_in):
        """Sets the storage_network_ip_not_in of this BackupServiceWhereInput.


        :param storage_network_ip_not_in: The storage_network_ip_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_not_in: list[str]
        """

        self._storage_network_ip_not_in = storage_network_ip_not_in

    @property
    def storage_network_ip_not_starts_with(self):
        """Gets the storage_network_ip_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip_not_starts_with

    @storage_network_ip_not_starts_with.setter
    def storage_network_ip_not_starts_with(self, storage_network_ip_not_starts_with):
        """Sets the storage_network_ip_not_starts_with of this BackupServiceWhereInput.


        :param storage_network_ip_not_starts_with: The storage_network_ip_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_not_starts_with: str
        """

        self._storage_network_ip_not_starts_with = storage_network_ip_not_starts_with

    @property
    def storage_network_ip_starts_with(self):
        """Gets the storage_network_ip_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_ip_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_ip_starts_with

    @storage_network_ip_starts_with.setter
    def storage_network_ip_starts_with(self, storage_network_ip_starts_with):
        """Sets the storage_network_ip_starts_with of this BackupServiceWhereInput.


        :param storage_network_ip_starts_with: The storage_network_ip_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_ip_starts_with: str
        """

        self._storage_network_ip_starts_with = storage_network_ip_starts_with

    @property
    def storage_network_subnet_mask(self):
        """Gets the storage_network_subnet_mask of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask

    @storage_network_subnet_mask.setter
    def storage_network_subnet_mask(self, storage_network_subnet_mask):
        """Sets the storage_network_subnet_mask of this BackupServiceWhereInput.


        :param storage_network_subnet_mask: The storage_network_subnet_mask of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask: str
        """

        self._storage_network_subnet_mask = storage_network_subnet_mask

    @property
    def storage_network_subnet_mask_contains(self):
        """Gets the storage_network_subnet_mask_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask_contains

    @storage_network_subnet_mask_contains.setter
    def storage_network_subnet_mask_contains(self, storage_network_subnet_mask_contains):
        """Sets the storage_network_subnet_mask_contains of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_contains: The storage_network_subnet_mask_contains of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_contains: str
        """

        self._storage_network_subnet_mask_contains = storage_network_subnet_mask_contains

    @property
    def storage_network_subnet_mask_ends_with(self):
        """Gets the storage_network_subnet_mask_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask_ends_with

    @storage_network_subnet_mask_ends_with.setter
    def storage_network_subnet_mask_ends_with(self, storage_network_subnet_mask_ends_with):
        """Sets the storage_network_subnet_mask_ends_with of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_ends_with: The storage_network_subnet_mask_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_ends_with: str
        """

        self._storage_network_subnet_mask_ends_with = storage_network_subnet_mask_ends_with

    @property
    def storage_network_subnet_mask_gt(self):
        """Gets the storage_network_subnet_mask_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask_gt

    @storage_network_subnet_mask_gt.setter
    def storage_network_subnet_mask_gt(self, storage_network_subnet_mask_gt):
        """Sets the storage_network_subnet_mask_gt of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_gt: The storage_network_subnet_mask_gt of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_gt: str
        """

        self._storage_network_subnet_mask_gt = storage_network_subnet_mask_gt

    @property
    def storage_network_subnet_mask_gte(self):
        """Gets the storage_network_subnet_mask_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask_gte

    @storage_network_subnet_mask_gte.setter
    def storage_network_subnet_mask_gte(self, storage_network_subnet_mask_gte):
        """Sets the storage_network_subnet_mask_gte of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_gte: The storage_network_subnet_mask_gte of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_gte: str
        """

        self._storage_network_subnet_mask_gte = storage_network_subnet_mask_gte

    @property
    def storage_network_subnet_mask_in(self):
        """Gets the storage_network_subnet_mask_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._storage_network_subnet_mask_in

    @storage_network_subnet_mask_in.setter
    def storage_network_subnet_mask_in(self, storage_network_subnet_mask_in):
        """Sets the storage_network_subnet_mask_in of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_in: The storage_network_subnet_mask_in of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_in: list[str]
        """

        self._storage_network_subnet_mask_in = storage_network_subnet_mask_in

    @property
    def storage_network_subnet_mask_lt(self):
        """Gets the storage_network_subnet_mask_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask_lt

    @storage_network_subnet_mask_lt.setter
    def storage_network_subnet_mask_lt(self, storage_network_subnet_mask_lt):
        """Sets the storage_network_subnet_mask_lt of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_lt: The storage_network_subnet_mask_lt of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_lt: str
        """

        self._storage_network_subnet_mask_lt = storage_network_subnet_mask_lt

    @property
    def storage_network_subnet_mask_lte(self):
        """Gets the storage_network_subnet_mask_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask_lte

    @storage_network_subnet_mask_lte.setter
    def storage_network_subnet_mask_lte(self, storage_network_subnet_mask_lte):
        """Sets the storage_network_subnet_mask_lte of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_lte: The storage_network_subnet_mask_lte of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_lte: str
        """

        self._storage_network_subnet_mask_lte = storage_network_subnet_mask_lte

    @property
    def storage_network_subnet_mask_not(self):
        """Gets the storage_network_subnet_mask_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask_not

    @storage_network_subnet_mask_not.setter
    def storage_network_subnet_mask_not(self, storage_network_subnet_mask_not):
        """Sets the storage_network_subnet_mask_not of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_not: The storage_network_subnet_mask_not of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_not: str
        """

        self._storage_network_subnet_mask_not = storage_network_subnet_mask_not

    @property
    def storage_network_subnet_mask_not_contains(self):
        """Gets the storage_network_subnet_mask_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask_not_contains

    @storage_network_subnet_mask_not_contains.setter
    def storage_network_subnet_mask_not_contains(self, storage_network_subnet_mask_not_contains):
        """Sets the storage_network_subnet_mask_not_contains of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_not_contains: The storage_network_subnet_mask_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_not_contains: str
        """

        self._storage_network_subnet_mask_not_contains = storage_network_subnet_mask_not_contains

    @property
    def storage_network_subnet_mask_not_ends_with(self):
        """Gets the storage_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask_not_ends_with

    @storage_network_subnet_mask_not_ends_with.setter
    def storage_network_subnet_mask_not_ends_with(self, storage_network_subnet_mask_not_ends_with):
        """Sets the storage_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_not_ends_with: The storage_network_subnet_mask_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_not_ends_with: str
        """

        self._storage_network_subnet_mask_not_ends_with = storage_network_subnet_mask_not_ends_with

    @property
    def storage_network_subnet_mask_not_in(self):
        """Gets the storage_network_subnet_mask_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._storage_network_subnet_mask_not_in

    @storage_network_subnet_mask_not_in.setter
    def storage_network_subnet_mask_not_in(self, storage_network_subnet_mask_not_in):
        """Sets the storage_network_subnet_mask_not_in of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_not_in: The storage_network_subnet_mask_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_not_in: list[str]
        """

        self._storage_network_subnet_mask_not_in = storage_network_subnet_mask_not_in

    @property
    def storage_network_subnet_mask_not_starts_with(self):
        """Gets the storage_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask_not_starts_with

    @storage_network_subnet_mask_not_starts_with.setter
    def storage_network_subnet_mask_not_starts_with(self, storage_network_subnet_mask_not_starts_with):
        """Sets the storage_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_not_starts_with: The storage_network_subnet_mask_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_not_starts_with: str
        """

        self._storage_network_subnet_mask_not_starts_with = storage_network_subnet_mask_not_starts_with

    @property
    def storage_network_subnet_mask_starts_with(self):
        """Gets the storage_network_subnet_mask_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_subnet_mask_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_subnet_mask_starts_with

    @storage_network_subnet_mask_starts_with.setter
    def storage_network_subnet_mask_starts_with(self, storage_network_subnet_mask_starts_with):
        """Sets the storage_network_subnet_mask_starts_with of this BackupServiceWhereInput.


        :param storage_network_subnet_mask_starts_with: The storage_network_subnet_mask_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_subnet_mask_starts_with: str
        """

        self._storage_network_subnet_mask_starts_with = storage_network_subnet_mask_starts_with

    @property
    def storage_network_type(self):
        """Gets the storage_network_type of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_type of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupServiceNetworkType
        """
        return self._storage_network_type

    @storage_network_type.setter
    def storage_network_type(self, storage_network_type):
        """Sets the storage_network_type of this BackupServiceWhereInput.


        :param storage_network_type: The storage_network_type of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_type: BackupServiceNetworkType
        """

        self._storage_network_type = storage_network_type

    @property
    def storage_network_type_in(self):
        """Gets the storage_network_type_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_type_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[BackupServiceNetworkType]
        """
        return self._storage_network_type_in

    @storage_network_type_in.setter
    def storage_network_type_in(self, storage_network_type_in):
        """Sets the storage_network_type_in of this BackupServiceWhereInput.


        :param storage_network_type_in: The storage_network_type_in of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_type_in: list[BackupServiceNetworkType]
        """

        self._storage_network_type_in = storage_network_type_in

    @property
    def storage_network_type_not(self):
        """Gets the storage_network_type_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_type_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: BackupServiceNetworkType
        """
        return self._storage_network_type_not

    @storage_network_type_not.setter
    def storage_network_type_not(self, storage_network_type_not):
        """Sets the storage_network_type_not of this BackupServiceWhereInput.


        :param storage_network_type_not: The storage_network_type_not of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_type_not: BackupServiceNetworkType
        """

        self._storage_network_type_not = storage_network_type_not

    @property
    def storage_network_type_not_in(self):
        """Gets the storage_network_type_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_type_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[BackupServiceNetworkType]
        """
        return self._storage_network_type_not_in

    @storage_network_type_not_in.setter
    def storage_network_type_not_in(self, storage_network_type_not_in):
        """Sets the storage_network_type_not_in of this BackupServiceWhereInput.


        :param storage_network_type_not_in: The storage_network_type_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_type_not_in: list[BackupServiceNetworkType]
        """

        self._storage_network_type_not_in = storage_network_type_not_in

    @property
    def storage_network_vlan(self):
        """Gets the storage_network_vlan of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan

    @storage_network_vlan.setter
    def storage_network_vlan(self, storage_network_vlan):
        """Sets the storage_network_vlan of this BackupServiceWhereInput.


        :param storage_network_vlan: The storage_network_vlan of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan: str
        """

        self._storage_network_vlan = storage_network_vlan

    @property
    def storage_network_vlan_contains(self):
        """Gets the storage_network_vlan_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan_contains

    @storage_network_vlan_contains.setter
    def storage_network_vlan_contains(self, storage_network_vlan_contains):
        """Sets the storage_network_vlan_contains of this BackupServiceWhereInput.


        :param storage_network_vlan_contains: The storage_network_vlan_contains of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_contains: str
        """

        self._storage_network_vlan_contains = storage_network_vlan_contains

    @property
    def storage_network_vlan_ends_with(self):
        """Gets the storage_network_vlan_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan_ends_with

    @storage_network_vlan_ends_with.setter
    def storage_network_vlan_ends_with(self, storage_network_vlan_ends_with):
        """Sets the storage_network_vlan_ends_with of this BackupServiceWhereInput.


        :param storage_network_vlan_ends_with: The storage_network_vlan_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_ends_with: str
        """

        self._storage_network_vlan_ends_with = storage_network_vlan_ends_with

    @property
    def storage_network_vlan_gt(self):
        """Gets the storage_network_vlan_gt of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_gt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan_gt

    @storage_network_vlan_gt.setter
    def storage_network_vlan_gt(self, storage_network_vlan_gt):
        """Sets the storage_network_vlan_gt of this BackupServiceWhereInput.


        :param storage_network_vlan_gt: The storage_network_vlan_gt of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_gt: str
        """

        self._storage_network_vlan_gt = storage_network_vlan_gt

    @property
    def storage_network_vlan_gte(self):
        """Gets the storage_network_vlan_gte of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_gte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan_gte

    @storage_network_vlan_gte.setter
    def storage_network_vlan_gte(self, storage_network_vlan_gte):
        """Sets the storage_network_vlan_gte of this BackupServiceWhereInput.


        :param storage_network_vlan_gte: The storage_network_vlan_gte of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_gte: str
        """

        self._storage_network_vlan_gte = storage_network_vlan_gte

    @property
    def storage_network_vlan_in(self):
        """Gets the storage_network_vlan_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._storage_network_vlan_in

    @storage_network_vlan_in.setter
    def storage_network_vlan_in(self, storage_network_vlan_in):
        """Sets the storage_network_vlan_in of this BackupServiceWhereInput.


        :param storage_network_vlan_in: The storage_network_vlan_in of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_in: list[str]
        """

        self._storage_network_vlan_in = storage_network_vlan_in

    @property
    def storage_network_vlan_lt(self):
        """Gets the storage_network_vlan_lt of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_lt of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan_lt

    @storage_network_vlan_lt.setter
    def storage_network_vlan_lt(self, storage_network_vlan_lt):
        """Sets the storage_network_vlan_lt of this BackupServiceWhereInput.


        :param storage_network_vlan_lt: The storage_network_vlan_lt of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_lt: str
        """

        self._storage_network_vlan_lt = storage_network_vlan_lt

    @property
    def storage_network_vlan_lte(self):
        """Gets the storage_network_vlan_lte of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_lte of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan_lte

    @storage_network_vlan_lte.setter
    def storage_network_vlan_lte(self, storage_network_vlan_lte):
        """Sets the storage_network_vlan_lte of this BackupServiceWhereInput.


        :param storage_network_vlan_lte: The storage_network_vlan_lte of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_lte: str
        """

        self._storage_network_vlan_lte = storage_network_vlan_lte

    @property
    def storage_network_vlan_not(self):
        """Gets the storage_network_vlan_not of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_not of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan_not

    @storage_network_vlan_not.setter
    def storage_network_vlan_not(self, storage_network_vlan_not):
        """Sets the storage_network_vlan_not of this BackupServiceWhereInput.


        :param storage_network_vlan_not: The storage_network_vlan_not of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_not: str
        """

        self._storage_network_vlan_not = storage_network_vlan_not

    @property
    def storage_network_vlan_not_contains(self):
        """Gets the storage_network_vlan_not_contains of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan_not_contains

    @storage_network_vlan_not_contains.setter
    def storage_network_vlan_not_contains(self, storage_network_vlan_not_contains):
        """Sets the storage_network_vlan_not_contains of this BackupServiceWhereInput.


        :param storage_network_vlan_not_contains: The storage_network_vlan_not_contains of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_not_contains: str
        """

        self._storage_network_vlan_not_contains = storage_network_vlan_not_contains

    @property
    def storage_network_vlan_not_ends_with(self):
        """Gets the storage_network_vlan_not_ends_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan_not_ends_with

    @storage_network_vlan_not_ends_with.setter
    def storage_network_vlan_not_ends_with(self, storage_network_vlan_not_ends_with):
        """Sets the storage_network_vlan_not_ends_with of this BackupServiceWhereInput.


        :param storage_network_vlan_not_ends_with: The storage_network_vlan_not_ends_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_not_ends_with: str
        """

        self._storage_network_vlan_not_ends_with = storage_network_vlan_not_ends_with

    @property
    def storage_network_vlan_not_in(self):
        """Gets the storage_network_vlan_not_in of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_not_in of this BackupServiceWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._storage_network_vlan_not_in

    @storage_network_vlan_not_in.setter
    def storage_network_vlan_not_in(self, storage_network_vlan_not_in):
        """Sets the storage_network_vlan_not_in of this BackupServiceWhereInput.


        :param storage_network_vlan_not_in: The storage_network_vlan_not_in of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_not_in: list[str]
        """

        self._storage_network_vlan_not_in = storage_network_vlan_not_in

    @property
    def storage_network_vlan_not_starts_with(self):
        """Gets the storage_network_vlan_not_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan_not_starts_with

    @storage_network_vlan_not_starts_with.setter
    def storage_network_vlan_not_starts_with(self, storage_network_vlan_not_starts_with):
        """Sets the storage_network_vlan_not_starts_with of this BackupServiceWhereInput.


        :param storage_network_vlan_not_starts_with: The storage_network_vlan_not_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_not_starts_with: str
        """

        self._storage_network_vlan_not_starts_with = storage_network_vlan_not_starts_with

    @property
    def storage_network_vlan_starts_with(self):
        """Gets the storage_network_vlan_starts_with of this BackupServiceWhereInput.  # noqa: E501


        :return: The storage_network_vlan_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._storage_network_vlan_starts_with

    @storage_network_vlan_starts_with.setter
    def storage_network_vlan_starts_with(self, storage_network_vlan_starts_with):
        """Sets the storage_network_vlan_starts_with of this BackupServiceWhereInput.


        :param storage_network_vlan_starts_with: The storage_network_vlan_starts_with of this BackupServiceWhereInput.  # noqa: E501
        :type storage_network_vlan_starts_with: str
        """

        self._storage_network_vlan_starts_with = storage_network_vlan_starts_with

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupServiceWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupServiceWhereInput):
            return True

        return self.to_dict() != other.to_dict()
