# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupStoreRepository(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'backup_plans': 'list[NestedBackupPlan]',
        'backup_restore_points': 'list[NestedBackupRestorePoint]',
        'backup_service': 'NestedBackupService',
        'created_at': 'str',
        'description': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'error_code': 'str',
        'id': 'str',
        'iscsi_chap_name': 'str',
        'iscsi_chap_secret': 'str',
        'iscsi_ip': 'str',
        'iscsi_lun_id': 'str',
        'iscsi_port': 'int',
        'iscsi_target_iqn': 'str',
        'name': 'str',
        'nfs_path': 'str',
        'nfs_server': 'str',
        'status': 'BackupStoreStatus',
        'total_capacity': 'int',
        'type': 'BackupStoreType',
        'update_timestamp': 'str',
        'used_data_space': 'int',
        'used_data_space_usage': 'float',
        'valid_data_space': 'int'
    }

    attribute_map = {
        'backup_plans': 'backup_plans',
        'backup_restore_points': 'backup_restore_points',
        'backup_service': 'backup_service',
        'created_at': 'createdAt',
        'description': 'description',
        'entity_async_status': 'entityAsyncStatus',
        'error_code': 'error_code',
        'id': 'id',
        'iscsi_chap_name': 'iscsi_chap_name',
        'iscsi_chap_secret': 'iscsi_chap_secret',
        'iscsi_ip': 'iscsi_ip',
        'iscsi_lun_id': 'iscsi_lun_id',
        'iscsi_port': 'iscsi_port',
        'iscsi_target_iqn': 'iscsi_target_iqn',
        'name': 'name',
        'nfs_path': 'nfs_path',
        'nfs_server': 'nfs_server',
        'status': 'status',
        'total_capacity': 'total_capacity',
        'type': 'type',
        'update_timestamp': 'update_timestamp',
        'used_data_space': 'used_data_space',
        'used_data_space_usage': 'used_data_space_usage',
        'valid_data_space': 'valid_data_space'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupStoreRepository - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._backup_plans = None
        self._backup_restore_points = None
        self._backup_service = None
        self._created_at = None
        self._description = None
        self._entity_async_status = None
        self._error_code = None
        self._id = None
        self._iscsi_chap_name = None
        self._iscsi_chap_secret = None
        self._iscsi_ip = None
        self._iscsi_lun_id = None
        self._iscsi_port = None
        self._iscsi_target_iqn = None
        self._name = None
        self._nfs_path = None
        self._nfs_server = None
        self._status = None
        self._total_capacity = None
        self._type = None
        self._update_timestamp = None
        self._used_data_space = None
        self._used_data_space_usage = None
        self._valid_data_space = None
        self.discriminator = None

        self.backup_plans = kwargs.get("backup_plans", None)
        self.backup_restore_points = kwargs.get("backup_restore_points", None)
        self.backup_service = kwargs.get("backup_service", None)
        if "created_at" in kwargs:
            self.created_at = kwargs["created_at"]
        self.description = kwargs.get("description", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.error_code = kwargs.get("error_code", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.iscsi_chap_name = kwargs.get("iscsi_chap_name", None)
        self.iscsi_chap_secret = kwargs.get("iscsi_chap_secret", None)
        self.iscsi_ip = kwargs.get("iscsi_ip", None)
        self.iscsi_lun_id = kwargs.get("iscsi_lun_id", None)
        self.iscsi_port = kwargs.get("iscsi_port", None)
        self.iscsi_target_iqn = kwargs.get("iscsi_target_iqn", None)
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.nfs_path = kwargs.get("nfs_path", None)
        self.nfs_server = kwargs.get("nfs_server", None)
        if "status" in kwargs:
            self.status = kwargs["status"]
        if "total_capacity" in kwargs:
            self.total_capacity = kwargs["total_capacity"]
        if "type" in kwargs:
            self.type = kwargs["type"]
        self.update_timestamp = kwargs.get("update_timestamp", None)
        if "used_data_space" in kwargs:
            self.used_data_space = kwargs["used_data_space"]
        self.used_data_space_usage = kwargs.get("used_data_space_usage", None)
        self.valid_data_space = kwargs.get("valid_data_space", None)

    @property
    def backup_plans(self):
        """Gets the backup_plans of this BackupStoreRepository.  # noqa: E501


        :return: The backup_plans of this BackupStoreRepository.  # noqa: E501
        :rtype: list[NestedBackupPlan]
        """
        return self._backup_plans

    @backup_plans.setter
    def backup_plans(self, backup_plans):
        """Sets the backup_plans of this BackupStoreRepository.


        :param backup_plans: The backup_plans of this BackupStoreRepository.  # noqa: E501
        :type backup_plans: list[NestedBackupPlan]
        """

        self._backup_plans = backup_plans

    @property
    def backup_restore_points(self):
        """Gets the backup_restore_points of this BackupStoreRepository.  # noqa: E501


        :return: The backup_restore_points of this BackupStoreRepository.  # noqa: E501
        :rtype: list[NestedBackupRestorePoint]
        """
        return self._backup_restore_points

    @backup_restore_points.setter
    def backup_restore_points(self, backup_restore_points):
        """Sets the backup_restore_points of this BackupStoreRepository.


        :param backup_restore_points: The backup_restore_points of this BackupStoreRepository.  # noqa: E501
        :type backup_restore_points: list[NestedBackupRestorePoint]
        """

        self._backup_restore_points = backup_restore_points

    @property
    def backup_service(self):
        """Gets the backup_service of this BackupStoreRepository.  # noqa: E501


        :return: The backup_service of this BackupStoreRepository.  # noqa: E501
        :rtype: NestedBackupService
        """
        return self._backup_service

    @backup_service.setter
    def backup_service(self, backup_service):
        """Sets the backup_service of this BackupStoreRepository.


        :param backup_service: The backup_service of this BackupStoreRepository.  # noqa: E501
        :type backup_service: NestedBackupService
        """

        self._backup_service = backup_service

    @property
    def created_at(self):
        """Gets the created_at of this BackupStoreRepository.  # noqa: E501


        :return: The created_at of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this BackupStoreRepository.


        :param created_at: The created_at of this BackupStoreRepository.  # noqa: E501
        :type created_at: str
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def description(self):
        """Gets the description of this BackupStoreRepository.  # noqa: E501


        :return: The description of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BackupStoreRepository.


        :param description: The description of this BackupStoreRepository.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this BackupStoreRepository.  # noqa: E501


        :return: The entity_async_status of this BackupStoreRepository.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this BackupStoreRepository.


        :param entity_async_status: The entity_async_status of this BackupStoreRepository.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def error_code(self):
        """Gets the error_code of this BackupStoreRepository.  # noqa: E501


        :return: The error_code of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """Sets the error_code of this BackupStoreRepository.


        :param error_code: The error_code of this BackupStoreRepository.  # noqa: E501
        :type error_code: str
        """

        self._error_code = error_code

    @property
    def id(self):
        """Gets the id of this BackupStoreRepository.  # noqa: E501


        :return: The id of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BackupStoreRepository.


        :param id: The id of this BackupStoreRepository.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def iscsi_chap_name(self):
        """Gets the iscsi_chap_name of this BackupStoreRepository.  # noqa: E501


        :return: The iscsi_chap_name of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name

    @iscsi_chap_name.setter
    def iscsi_chap_name(self, iscsi_chap_name):
        """Sets the iscsi_chap_name of this BackupStoreRepository.


        :param iscsi_chap_name: The iscsi_chap_name of this BackupStoreRepository.  # noqa: E501
        :type iscsi_chap_name: str
        """

        self._iscsi_chap_name = iscsi_chap_name

    @property
    def iscsi_chap_secret(self):
        """Gets the iscsi_chap_secret of this BackupStoreRepository.  # noqa: E501


        :return: The iscsi_chap_secret of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret

    @iscsi_chap_secret.setter
    def iscsi_chap_secret(self, iscsi_chap_secret):
        """Sets the iscsi_chap_secret of this BackupStoreRepository.


        :param iscsi_chap_secret: The iscsi_chap_secret of this BackupStoreRepository.  # noqa: E501
        :type iscsi_chap_secret: str
        """

        self._iscsi_chap_secret = iscsi_chap_secret

    @property
    def iscsi_ip(self):
        """Gets the iscsi_ip of this BackupStoreRepository.  # noqa: E501


        :return: The iscsi_ip of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip

    @iscsi_ip.setter
    def iscsi_ip(self, iscsi_ip):
        """Sets the iscsi_ip of this BackupStoreRepository.


        :param iscsi_ip: The iscsi_ip of this BackupStoreRepository.  # noqa: E501
        :type iscsi_ip: str
        """

        self._iscsi_ip = iscsi_ip

    @property
    def iscsi_lun_id(self):
        """Gets the iscsi_lun_id of this BackupStoreRepository.  # noqa: E501


        :return: The iscsi_lun_id of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id

    @iscsi_lun_id.setter
    def iscsi_lun_id(self, iscsi_lun_id):
        """Sets the iscsi_lun_id of this BackupStoreRepository.


        :param iscsi_lun_id: The iscsi_lun_id of this BackupStoreRepository.  # noqa: E501
        :type iscsi_lun_id: str
        """

        self._iscsi_lun_id = iscsi_lun_id

    @property
    def iscsi_port(self):
        """Gets the iscsi_port of this BackupStoreRepository.  # noqa: E501


        :return: The iscsi_port of this BackupStoreRepository.  # noqa: E501
        :rtype: int
        """
        return self._iscsi_port

    @iscsi_port.setter
    def iscsi_port(self, iscsi_port):
        """Sets the iscsi_port of this BackupStoreRepository.


        :param iscsi_port: The iscsi_port of this BackupStoreRepository.  # noqa: E501
        :type iscsi_port: int
        """

        self._iscsi_port = iscsi_port

    @property
    def iscsi_target_iqn(self):
        """Gets the iscsi_target_iqn of this BackupStoreRepository.  # noqa: E501


        :return: The iscsi_target_iqn of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn

    @iscsi_target_iqn.setter
    def iscsi_target_iqn(self, iscsi_target_iqn):
        """Sets the iscsi_target_iqn of this BackupStoreRepository.


        :param iscsi_target_iqn: The iscsi_target_iqn of this BackupStoreRepository.  # noqa: E501
        :type iscsi_target_iqn: str
        """

        self._iscsi_target_iqn = iscsi_target_iqn

    @property
    def name(self):
        """Gets the name of this BackupStoreRepository.  # noqa: E501


        :return: The name of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BackupStoreRepository.


        :param name: The name of this BackupStoreRepository.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def nfs_path(self):
        """Gets the nfs_path of this BackupStoreRepository.  # noqa: E501


        :return: The nfs_path of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path

    @nfs_path.setter
    def nfs_path(self, nfs_path):
        """Sets the nfs_path of this BackupStoreRepository.


        :param nfs_path: The nfs_path of this BackupStoreRepository.  # noqa: E501
        :type nfs_path: str
        """

        self._nfs_path = nfs_path

    @property
    def nfs_server(self):
        """Gets the nfs_server of this BackupStoreRepository.  # noqa: E501


        :return: The nfs_server of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server

    @nfs_server.setter
    def nfs_server(self, nfs_server):
        """Sets the nfs_server of this BackupStoreRepository.


        :param nfs_server: The nfs_server of this BackupStoreRepository.  # noqa: E501
        :type nfs_server: str
        """

        self._nfs_server = nfs_server

    @property
    def status(self):
        """Gets the status of this BackupStoreRepository.  # noqa: E501


        :return: The status of this BackupStoreRepository.  # noqa: E501
        :rtype: BackupStoreStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BackupStoreRepository.


        :param status: The status of this BackupStoreRepository.  # noqa: E501
        :type status: BackupStoreStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def total_capacity(self):
        """Gets the total_capacity of this BackupStoreRepository.  # noqa: E501


        :return: The total_capacity of this BackupStoreRepository.  # noqa: E501
        :rtype: int
        """
        return self._total_capacity

    @total_capacity.setter
    def total_capacity(self, total_capacity):
        """Sets the total_capacity of this BackupStoreRepository.


        :param total_capacity: The total_capacity of this BackupStoreRepository.  # noqa: E501
        :type total_capacity: int
        """
        if self.local_vars_configuration.client_side_validation and total_capacity is None:  # noqa: E501
            raise ValueError("Invalid value for `total_capacity`, must not be `None`")  # noqa: E501

        self._total_capacity = total_capacity

    @property
    def type(self):
        """Gets the type of this BackupStoreRepository.  # noqa: E501


        :return: The type of this BackupStoreRepository.  # noqa: E501
        :rtype: BackupStoreType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BackupStoreRepository.


        :param type: The type of this BackupStoreRepository.  # noqa: E501
        :type type: BackupStoreType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def update_timestamp(self):
        """Gets the update_timestamp of this BackupStoreRepository.  # noqa: E501


        :return: The update_timestamp of this BackupStoreRepository.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp

    @update_timestamp.setter
    def update_timestamp(self, update_timestamp):
        """Sets the update_timestamp of this BackupStoreRepository.


        :param update_timestamp: The update_timestamp of this BackupStoreRepository.  # noqa: E501
        :type update_timestamp: str
        """

        self._update_timestamp = update_timestamp

    @property
    def used_data_space(self):
        """Gets the used_data_space of this BackupStoreRepository.  # noqa: E501


        :return: The used_data_space of this BackupStoreRepository.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space

    @used_data_space.setter
    def used_data_space(self, used_data_space):
        """Sets the used_data_space of this BackupStoreRepository.


        :param used_data_space: The used_data_space of this BackupStoreRepository.  # noqa: E501
        :type used_data_space: int
        """
        if self.local_vars_configuration.client_side_validation and used_data_space is None:  # noqa: E501
            raise ValueError("Invalid value for `used_data_space`, must not be `None`")  # noqa: E501

        self._used_data_space = used_data_space

    @property
    def used_data_space_usage(self):
        """Gets the used_data_space_usage of this BackupStoreRepository.  # noqa: E501


        :return: The used_data_space_usage of this BackupStoreRepository.  # noqa: E501
        :rtype: float
        """
        return self._used_data_space_usage

    @used_data_space_usage.setter
    def used_data_space_usage(self, used_data_space_usage):
        """Sets the used_data_space_usage of this BackupStoreRepository.


        :param used_data_space_usage: The used_data_space_usage of this BackupStoreRepository.  # noqa: E501
        :type used_data_space_usage: float
        """

        self._used_data_space_usage = used_data_space_usage

    @property
    def valid_data_space(self):
        """Gets the valid_data_space of this BackupStoreRepository.  # noqa: E501


        :return: The valid_data_space of this BackupStoreRepository.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space

    @valid_data_space.setter
    def valid_data_space(self, valid_data_space):
        """Sets the valid_data_space of this BackupStoreRepository.


        :param valid_data_space: The valid_data_space of this BackupStoreRepository.  # noqa: E501
        :type valid_data_space: int
        """

        self._valid_data_space = valid_data_space

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupStoreRepository):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupStoreRepository):
            return True

        return self.to_dict() != other.to_dict()
