# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupStoreRepositoryWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[BackupStoreRepositoryWhereInput]',
        '_not': 'list[BackupStoreRepositoryWhereInput]',
        '_or': 'list[BackupStoreRepositoryWhereInput]',
        'backup_plans_every': 'BackupPlanWhereInput',
        'backup_plans_none': 'BackupPlanWhereInput',
        'backup_plans_some': 'BackupPlanWhereInput',
        'backup_restore_points_every': 'BackupRestorePointWhereInput',
        'backup_restore_points_none': 'BackupRestorePointWhereInput',
        'backup_restore_points_some': 'BackupRestorePointWhereInput',
        'backup_service': 'BackupServiceWhereInput',
        'created_at': 'str',
        'created_at_gt': 'str',
        'created_at_gte': 'str',
        'created_at_in': 'list[str]',
        'created_at_lt': 'str',
        'created_at_lte': 'str',
        'created_at_not': 'str',
        'created_at_not_in': 'list[str]',
        'description': 'str',
        'description_contains': 'str',
        'description_ends_with': 'str',
        'description_gt': 'str',
        'description_gte': 'str',
        'description_in': 'list[str]',
        'description_lt': 'str',
        'description_lte': 'str',
        'description_not': 'str',
        'description_not_contains': 'str',
        'description_not_ends_with': 'str',
        'description_not_in': 'list[str]',
        'description_not_starts_with': 'str',
        'description_starts_with': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'error_code': 'str',
        'error_code_contains': 'str',
        'error_code_ends_with': 'str',
        'error_code_gt': 'str',
        'error_code_gte': 'str',
        'error_code_in': 'list[str]',
        'error_code_lt': 'str',
        'error_code_lte': 'str',
        'error_code_not': 'str',
        'error_code_not_contains': 'str',
        'error_code_not_ends_with': 'str',
        'error_code_not_in': 'list[str]',
        'error_code_not_starts_with': 'str',
        'error_code_starts_with': 'str',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'iscsi_chap_name': 'str',
        'iscsi_chap_name_contains': 'str',
        'iscsi_chap_name_ends_with': 'str',
        'iscsi_chap_name_gt': 'str',
        'iscsi_chap_name_gte': 'str',
        'iscsi_chap_name_in': 'list[str]',
        'iscsi_chap_name_lt': 'str',
        'iscsi_chap_name_lte': 'str',
        'iscsi_chap_name_not': 'str',
        'iscsi_chap_name_not_contains': 'str',
        'iscsi_chap_name_not_ends_with': 'str',
        'iscsi_chap_name_not_in': 'list[str]',
        'iscsi_chap_name_not_starts_with': 'str',
        'iscsi_chap_name_starts_with': 'str',
        'iscsi_chap_secret': 'str',
        'iscsi_chap_secret_contains': 'str',
        'iscsi_chap_secret_ends_with': 'str',
        'iscsi_chap_secret_gt': 'str',
        'iscsi_chap_secret_gte': 'str',
        'iscsi_chap_secret_in': 'list[str]',
        'iscsi_chap_secret_lt': 'str',
        'iscsi_chap_secret_lte': 'str',
        'iscsi_chap_secret_not': 'str',
        'iscsi_chap_secret_not_contains': 'str',
        'iscsi_chap_secret_not_ends_with': 'str',
        'iscsi_chap_secret_not_in': 'list[str]',
        'iscsi_chap_secret_not_starts_with': 'str',
        'iscsi_chap_secret_starts_with': 'str',
        'iscsi_ip': 'str',
        'iscsi_ip_contains': 'str',
        'iscsi_ip_ends_with': 'str',
        'iscsi_ip_gt': 'str',
        'iscsi_ip_gte': 'str',
        'iscsi_ip_in': 'list[str]',
        'iscsi_ip_lt': 'str',
        'iscsi_ip_lte': 'str',
        'iscsi_ip_not': 'str',
        'iscsi_ip_not_contains': 'str',
        'iscsi_ip_not_ends_with': 'str',
        'iscsi_ip_not_in': 'list[str]',
        'iscsi_ip_not_starts_with': 'str',
        'iscsi_ip_starts_with': 'str',
        'iscsi_lun_id': 'str',
        'iscsi_lun_id_contains': 'str',
        'iscsi_lun_id_ends_with': 'str',
        'iscsi_lun_id_gt': 'str',
        'iscsi_lun_id_gte': 'str',
        'iscsi_lun_id_in': 'list[str]',
        'iscsi_lun_id_lt': 'str',
        'iscsi_lun_id_lte': 'str',
        'iscsi_lun_id_not': 'str',
        'iscsi_lun_id_not_contains': 'str',
        'iscsi_lun_id_not_ends_with': 'str',
        'iscsi_lun_id_not_in': 'list[str]',
        'iscsi_lun_id_not_starts_with': 'str',
        'iscsi_lun_id_starts_with': 'str',
        'iscsi_port': 'int',
        'iscsi_port_gt': 'int',
        'iscsi_port_gte': 'int',
        'iscsi_port_in': 'list[int]',
        'iscsi_port_lt': 'int',
        'iscsi_port_lte': 'int',
        'iscsi_port_not': 'int',
        'iscsi_port_not_in': 'list[int]',
        'iscsi_target_iqn': 'str',
        'iscsi_target_iqn_contains': 'str',
        'iscsi_target_iqn_ends_with': 'str',
        'iscsi_target_iqn_gt': 'str',
        'iscsi_target_iqn_gte': 'str',
        'iscsi_target_iqn_in': 'list[str]',
        'iscsi_target_iqn_lt': 'str',
        'iscsi_target_iqn_lte': 'str',
        'iscsi_target_iqn_not': 'str',
        'iscsi_target_iqn_not_contains': 'str',
        'iscsi_target_iqn_not_ends_with': 'str',
        'iscsi_target_iqn_not_in': 'list[str]',
        'iscsi_target_iqn_not_starts_with': 'str',
        'iscsi_target_iqn_starts_with': 'str',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'nfs_path': 'str',
        'nfs_path_contains': 'str',
        'nfs_path_ends_with': 'str',
        'nfs_path_gt': 'str',
        'nfs_path_gte': 'str',
        'nfs_path_in': 'list[str]',
        'nfs_path_lt': 'str',
        'nfs_path_lte': 'str',
        'nfs_path_not': 'str',
        'nfs_path_not_contains': 'str',
        'nfs_path_not_ends_with': 'str',
        'nfs_path_not_in': 'list[str]',
        'nfs_path_not_starts_with': 'str',
        'nfs_path_starts_with': 'str',
        'nfs_server': 'str',
        'nfs_server_contains': 'str',
        'nfs_server_ends_with': 'str',
        'nfs_server_gt': 'str',
        'nfs_server_gte': 'str',
        'nfs_server_in': 'list[str]',
        'nfs_server_lt': 'str',
        'nfs_server_lte': 'str',
        'nfs_server_not': 'str',
        'nfs_server_not_contains': 'str',
        'nfs_server_not_ends_with': 'str',
        'nfs_server_not_in': 'list[str]',
        'nfs_server_not_starts_with': 'str',
        'nfs_server_starts_with': 'str',
        'status': 'BackupStoreStatus',
        'status_in': 'list[BackupStoreStatus]',
        'status_not': 'BackupStoreStatus',
        'status_not_in': 'list[BackupStoreStatus]',
        'total_capacity': 'int',
        'total_capacity_gt': 'int',
        'total_capacity_gte': 'int',
        'total_capacity_in': 'list[int]',
        'total_capacity_lt': 'int',
        'total_capacity_lte': 'int',
        'total_capacity_not': 'int',
        'total_capacity_not_in': 'list[int]',
        'type': 'BackupStoreType',
        'type_in': 'list[BackupStoreType]',
        'type_not': 'BackupStoreType',
        'type_not_in': 'list[BackupStoreType]',
        'update_timestamp': 'str',
        'update_timestamp_contains': 'str',
        'update_timestamp_ends_with': 'str',
        'update_timestamp_gt': 'str',
        'update_timestamp_gte': 'str',
        'update_timestamp_in': 'list[str]',
        'update_timestamp_lt': 'str',
        'update_timestamp_lte': 'str',
        'update_timestamp_not': 'str',
        'update_timestamp_not_contains': 'str',
        'update_timestamp_not_ends_with': 'str',
        'update_timestamp_not_in': 'list[str]',
        'update_timestamp_not_starts_with': 'str',
        'update_timestamp_starts_with': 'str',
        'used_data_space': 'int',
        'used_data_space_gt': 'int',
        'used_data_space_gte': 'int',
        'used_data_space_in': 'list[int]',
        'used_data_space_lt': 'int',
        'used_data_space_lte': 'int',
        'used_data_space_not': 'int',
        'used_data_space_not_in': 'list[int]',
        'used_data_space_usage': 'float',
        'used_data_space_usage_gt': 'float',
        'used_data_space_usage_gte': 'float',
        'used_data_space_usage_in': 'list[float]',
        'used_data_space_usage_lt': 'float',
        'used_data_space_usage_lte': 'float',
        'used_data_space_usage_not': 'float',
        'used_data_space_usage_not_in': 'list[float]',
        'valid_data_space': 'int',
        'valid_data_space_gt': 'int',
        'valid_data_space_gte': 'int',
        'valid_data_space_in': 'list[int]',
        'valid_data_space_lt': 'int',
        'valid_data_space_lte': 'int',
        'valid_data_space_not': 'int',
        'valid_data_space_not_in': 'list[int]'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'backup_plans_every': 'backup_plans_every',
        'backup_plans_none': 'backup_plans_none',
        'backup_plans_some': 'backup_plans_some',
        'backup_restore_points_every': 'backup_restore_points_every',
        'backup_restore_points_none': 'backup_restore_points_none',
        'backup_restore_points_some': 'backup_restore_points_some',
        'backup_service': 'backup_service',
        'created_at': 'createdAt',
        'created_at_gt': 'createdAt_gt',
        'created_at_gte': 'createdAt_gte',
        'created_at_in': 'createdAt_in',
        'created_at_lt': 'createdAt_lt',
        'created_at_lte': 'createdAt_lte',
        'created_at_not': 'createdAt_not',
        'created_at_not_in': 'createdAt_not_in',
        'description': 'description',
        'description_contains': 'description_contains',
        'description_ends_with': 'description_ends_with',
        'description_gt': 'description_gt',
        'description_gte': 'description_gte',
        'description_in': 'description_in',
        'description_lt': 'description_lt',
        'description_lte': 'description_lte',
        'description_not': 'description_not',
        'description_not_contains': 'description_not_contains',
        'description_not_ends_with': 'description_not_ends_with',
        'description_not_in': 'description_not_in',
        'description_not_starts_with': 'description_not_starts_with',
        'description_starts_with': 'description_starts_with',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'error_code': 'error_code',
        'error_code_contains': 'error_code_contains',
        'error_code_ends_with': 'error_code_ends_with',
        'error_code_gt': 'error_code_gt',
        'error_code_gte': 'error_code_gte',
        'error_code_in': 'error_code_in',
        'error_code_lt': 'error_code_lt',
        'error_code_lte': 'error_code_lte',
        'error_code_not': 'error_code_not',
        'error_code_not_contains': 'error_code_not_contains',
        'error_code_not_ends_with': 'error_code_not_ends_with',
        'error_code_not_in': 'error_code_not_in',
        'error_code_not_starts_with': 'error_code_not_starts_with',
        'error_code_starts_with': 'error_code_starts_with',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'iscsi_chap_name': 'iscsi_chap_name',
        'iscsi_chap_name_contains': 'iscsi_chap_name_contains',
        'iscsi_chap_name_ends_with': 'iscsi_chap_name_ends_with',
        'iscsi_chap_name_gt': 'iscsi_chap_name_gt',
        'iscsi_chap_name_gte': 'iscsi_chap_name_gte',
        'iscsi_chap_name_in': 'iscsi_chap_name_in',
        'iscsi_chap_name_lt': 'iscsi_chap_name_lt',
        'iscsi_chap_name_lte': 'iscsi_chap_name_lte',
        'iscsi_chap_name_not': 'iscsi_chap_name_not',
        'iscsi_chap_name_not_contains': 'iscsi_chap_name_not_contains',
        'iscsi_chap_name_not_ends_with': 'iscsi_chap_name_not_ends_with',
        'iscsi_chap_name_not_in': 'iscsi_chap_name_not_in',
        'iscsi_chap_name_not_starts_with': 'iscsi_chap_name_not_starts_with',
        'iscsi_chap_name_starts_with': 'iscsi_chap_name_starts_with',
        'iscsi_chap_secret': 'iscsi_chap_secret',
        'iscsi_chap_secret_contains': 'iscsi_chap_secret_contains',
        'iscsi_chap_secret_ends_with': 'iscsi_chap_secret_ends_with',
        'iscsi_chap_secret_gt': 'iscsi_chap_secret_gt',
        'iscsi_chap_secret_gte': 'iscsi_chap_secret_gte',
        'iscsi_chap_secret_in': 'iscsi_chap_secret_in',
        'iscsi_chap_secret_lt': 'iscsi_chap_secret_lt',
        'iscsi_chap_secret_lte': 'iscsi_chap_secret_lte',
        'iscsi_chap_secret_not': 'iscsi_chap_secret_not',
        'iscsi_chap_secret_not_contains': 'iscsi_chap_secret_not_contains',
        'iscsi_chap_secret_not_ends_with': 'iscsi_chap_secret_not_ends_with',
        'iscsi_chap_secret_not_in': 'iscsi_chap_secret_not_in',
        'iscsi_chap_secret_not_starts_with': 'iscsi_chap_secret_not_starts_with',
        'iscsi_chap_secret_starts_with': 'iscsi_chap_secret_starts_with',
        'iscsi_ip': 'iscsi_ip',
        'iscsi_ip_contains': 'iscsi_ip_contains',
        'iscsi_ip_ends_with': 'iscsi_ip_ends_with',
        'iscsi_ip_gt': 'iscsi_ip_gt',
        'iscsi_ip_gte': 'iscsi_ip_gte',
        'iscsi_ip_in': 'iscsi_ip_in',
        'iscsi_ip_lt': 'iscsi_ip_lt',
        'iscsi_ip_lte': 'iscsi_ip_lte',
        'iscsi_ip_not': 'iscsi_ip_not',
        'iscsi_ip_not_contains': 'iscsi_ip_not_contains',
        'iscsi_ip_not_ends_with': 'iscsi_ip_not_ends_with',
        'iscsi_ip_not_in': 'iscsi_ip_not_in',
        'iscsi_ip_not_starts_with': 'iscsi_ip_not_starts_with',
        'iscsi_ip_starts_with': 'iscsi_ip_starts_with',
        'iscsi_lun_id': 'iscsi_lun_id',
        'iscsi_lun_id_contains': 'iscsi_lun_id_contains',
        'iscsi_lun_id_ends_with': 'iscsi_lun_id_ends_with',
        'iscsi_lun_id_gt': 'iscsi_lun_id_gt',
        'iscsi_lun_id_gte': 'iscsi_lun_id_gte',
        'iscsi_lun_id_in': 'iscsi_lun_id_in',
        'iscsi_lun_id_lt': 'iscsi_lun_id_lt',
        'iscsi_lun_id_lte': 'iscsi_lun_id_lte',
        'iscsi_lun_id_not': 'iscsi_lun_id_not',
        'iscsi_lun_id_not_contains': 'iscsi_lun_id_not_contains',
        'iscsi_lun_id_not_ends_with': 'iscsi_lun_id_not_ends_with',
        'iscsi_lun_id_not_in': 'iscsi_lun_id_not_in',
        'iscsi_lun_id_not_starts_with': 'iscsi_lun_id_not_starts_with',
        'iscsi_lun_id_starts_with': 'iscsi_lun_id_starts_with',
        'iscsi_port': 'iscsi_port',
        'iscsi_port_gt': 'iscsi_port_gt',
        'iscsi_port_gte': 'iscsi_port_gte',
        'iscsi_port_in': 'iscsi_port_in',
        'iscsi_port_lt': 'iscsi_port_lt',
        'iscsi_port_lte': 'iscsi_port_lte',
        'iscsi_port_not': 'iscsi_port_not',
        'iscsi_port_not_in': 'iscsi_port_not_in',
        'iscsi_target_iqn': 'iscsi_target_iqn',
        'iscsi_target_iqn_contains': 'iscsi_target_iqn_contains',
        'iscsi_target_iqn_ends_with': 'iscsi_target_iqn_ends_with',
        'iscsi_target_iqn_gt': 'iscsi_target_iqn_gt',
        'iscsi_target_iqn_gte': 'iscsi_target_iqn_gte',
        'iscsi_target_iqn_in': 'iscsi_target_iqn_in',
        'iscsi_target_iqn_lt': 'iscsi_target_iqn_lt',
        'iscsi_target_iqn_lte': 'iscsi_target_iqn_lte',
        'iscsi_target_iqn_not': 'iscsi_target_iqn_not',
        'iscsi_target_iqn_not_contains': 'iscsi_target_iqn_not_contains',
        'iscsi_target_iqn_not_ends_with': 'iscsi_target_iqn_not_ends_with',
        'iscsi_target_iqn_not_in': 'iscsi_target_iqn_not_in',
        'iscsi_target_iqn_not_starts_with': 'iscsi_target_iqn_not_starts_with',
        'iscsi_target_iqn_starts_with': 'iscsi_target_iqn_starts_with',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'nfs_path': 'nfs_path',
        'nfs_path_contains': 'nfs_path_contains',
        'nfs_path_ends_with': 'nfs_path_ends_with',
        'nfs_path_gt': 'nfs_path_gt',
        'nfs_path_gte': 'nfs_path_gte',
        'nfs_path_in': 'nfs_path_in',
        'nfs_path_lt': 'nfs_path_lt',
        'nfs_path_lte': 'nfs_path_lte',
        'nfs_path_not': 'nfs_path_not',
        'nfs_path_not_contains': 'nfs_path_not_contains',
        'nfs_path_not_ends_with': 'nfs_path_not_ends_with',
        'nfs_path_not_in': 'nfs_path_not_in',
        'nfs_path_not_starts_with': 'nfs_path_not_starts_with',
        'nfs_path_starts_with': 'nfs_path_starts_with',
        'nfs_server': 'nfs_server',
        'nfs_server_contains': 'nfs_server_contains',
        'nfs_server_ends_with': 'nfs_server_ends_with',
        'nfs_server_gt': 'nfs_server_gt',
        'nfs_server_gte': 'nfs_server_gte',
        'nfs_server_in': 'nfs_server_in',
        'nfs_server_lt': 'nfs_server_lt',
        'nfs_server_lte': 'nfs_server_lte',
        'nfs_server_not': 'nfs_server_not',
        'nfs_server_not_contains': 'nfs_server_not_contains',
        'nfs_server_not_ends_with': 'nfs_server_not_ends_with',
        'nfs_server_not_in': 'nfs_server_not_in',
        'nfs_server_not_starts_with': 'nfs_server_not_starts_with',
        'nfs_server_starts_with': 'nfs_server_starts_with',
        'status': 'status',
        'status_in': 'status_in',
        'status_not': 'status_not',
        'status_not_in': 'status_not_in',
        'total_capacity': 'total_capacity',
        'total_capacity_gt': 'total_capacity_gt',
        'total_capacity_gte': 'total_capacity_gte',
        'total_capacity_in': 'total_capacity_in',
        'total_capacity_lt': 'total_capacity_lt',
        'total_capacity_lte': 'total_capacity_lte',
        'total_capacity_not': 'total_capacity_not',
        'total_capacity_not_in': 'total_capacity_not_in',
        'type': 'type',
        'type_in': 'type_in',
        'type_not': 'type_not',
        'type_not_in': 'type_not_in',
        'update_timestamp': 'update_timestamp',
        'update_timestamp_contains': 'update_timestamp_contains',
        'update_timestamp_ends_with': 'update_timestamp_ends_with',
        'update_timestamp_gt': 'update_timestamp_gt',
        'update_timestamp_gte': 'update_timestamp_gte',
        'update_timestamp_in': 'update_timestamp_in',
        'update_timestamp_lt': 'update_timestamp_lt',
        'update_timestamp_lte': 'update_timestamp_lte',
        'update_timestamp_not': 'update_timestamp_not',
        'update_timestamp_not_contains': 'update_timestamp_not_contains',
        'update_timestamp_not_ends_with': 'update_timestamp_not_ends_with',
        'update_timestamp_not_in': 'update_timestamp_not_in',
        'update_timestamp_not_starts_with': 'update_timestamp_not_starts_with',
        'update_timestamp_starts_with': 'update_timestamp_starts_with',
        'used_data_space': 'used_data_space',
        'used_data_space_gt': 'used_data_space_gt',
        'used_data_space_gte': 'used_data_space_gte',
        'used_data_space_in': 'used_data_space_in',
        'used_data_space_lt': 'used_data_space_lt',
        'used_data_space_lte': 'used_data_space_lte',
        'used_data_space_not': 'used_data_space_not',
        'used_data_space_not_in': 'used_data_space_not_in',
        'used_data_space_usage': 'used_data_space_usage',
        'used_data_space_usage_gt': 'used_data_space_usage_gt',
        'used_data_space_usage_gte': 'used_data_space_usage_gte',
        'used_data_space_usage_in': 'used_data_space_usage_in',
        'used_data_space_usage_lt': 'used_data_space_usage_lt',
        'used_data_space_usage_lte': 'used_data_space_usage_lte',
        'used_data_space_usage_not': 'used_data_space_usage_not',
        'used_data_space_usage_not_in': 'used_data_space_usage_not_in',
        'valid_data_space': 'valid_data_space',
        'valid_data_space_gt': 'valid_data_space_gt',
        'valid_data_space_gte': 'valid_data_space_gte',
        'valid_data_space_in': 'valid_data_space_in',
        'valid_data_space_lt': 'valid_data_space_lt',
        'valid_data_space_lte': 'valid_data_space_lte',
        'valid_data_space_not': 'valid_data_space_not',
        'valid_data_space_not_in': 'valid_data_space_not_in'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupStoreRepositoryWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._backup_plans_every = None
        self._backup_plans_none = None
        self._backup_plans_some = None
        self._backup_restore_points_every = None
        self._backup_restore_points_none = None
        self._backup_restore_points_some = None
        self._backup_service = None
        self._created_at = None
        self._created_at_gt = None
        self._created_at_gte = None
        self._created_at_in = None
        self._created_at_lt = None
        self._created_at_lte = None
        self._created_at_not = None
        self._created_at_not_in = None
        self._description = None
        self._description_contains = None
        self._description_ends_with = None
        self._description_gt = None
        self._description_gte = None
        self._description_in = None
        self._description_lt = None
        self._description_lte = None
        self._description_not = None
        self._description_not_contains = None
        self._description_not_ends_with = None
        self._description_not_in = None
        self._description_not_starts_with = None
        self._description_starts_with = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._error_code = None
        self._error_code_contains = None
        self._error_code_ends_with = None
        self._error_code_gt = None
        self._error_code_gte = None
        self._error_code_in = None
        self._error_code_lt = None
        self._error_code_lte = None
        self._error_code_not = None
        self._error_code_not_contains = None
        self._error_code_not_ends_with = None
        self._error_code_not_in = None
        self._error_code_not_starts_with = None
        self._error_code_starts_with = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._iscsi_chap_name = None
        self._iscsi_chap_name_contains = None
        self._iscsi_chap_name_ends_with = None
        self._iscsi_chap_name_gt = None
        self._iscsi_chap_name_gte = None
        self._iscsi_chap_name_in = None
        self._iscsi_chap_name_lt = None
        self._iscsi_chap_name_lte = None
        self._iscsi_chap_name_not = None
        self._iscsi_chap_name_not_contains = None
        self._iscsi_chap_name_not_ends_with = None
        self._iscsi_chap_name_not_in = None
        self._iscsi_chap_name_not_starts_with = None
        self._iscsi_chap_name_starts_with = None
        self._iscsi_chap_secret = None
        self._iscsi_chap_secret_contains = None
        self._iscsi_chap_secret_ends_with = None
        self._iscsi_chap_secret_gt = None
        self._iscsi_chap_secret_gte = None
        self._iscsi_chap_secret_in = None
        self._iscsi_chap_secret_lt = None
        self._iscsi_chap_secret_lte = None
        self._iscsi_chap_secret_not = None
        self._iscsi_chap_secret_not_contains = None
        self._iscsi_chap_secret_not_ends_with = None
        self._iscsi_chap_secret_not_in = None
        self._iscsi_chap_secret_not_starts_with = None
        self._iscsi_chap_secret_starts_with = None
        self._iscsi_ip = None
        self._iscsi_ip_contains = None
        self._iscsi_ip_ends_with = None
        self._iscsi_ip_gt = None
        self._iscsi_ip_gte = None
        self._iscsi_ip_in = None
        self._iscsi_ip_lt = None
        self._iscsi_ip_lte = None
        self._iscsi_ip_not = None
        self._iscsi_ip_not_contains = None
        self._iscsi_ip_not_ends_with = None
        self._iscsi_ip_not_in = None
        self._iscsi_ip_not_starts_with = None
        self._iscsi_ip_starts_with = None
        self._iscsi_lun_id = None
        self._iscsi_lun_id_contains = None
        self._iscsi_lun_id_ends_with = None
        self._iscsi_lun_id_gt = None
        self._iscsi_lun_id_gte = None
        self._iscsi_lun_id_in = None
        self._iscsi_lun_id_lt = None
        self._iscsi_lun_id_lte = None
        self._iscsi_lun_id_not = None
        self._iscsi_lun_id_not_contains = None
        self._iscsi_lun_id_not_ends_with = None
        self._iscsi_lun_id_not_in = None
        self._iscsi_lun_id_not_starts_with = None
        self._iscsi_lun_id_starts_with = None
        self._iscsi_port = None
        self._iscsi_port_gt = None
        self._iscsi_port_gte = None
        self._iscsi_port_in = None
        self._iscsi_port_lt = None
        self._iscsi_port_lte = None
        self._iscsi_port_not = None
        self._iscsi_port_not_in = None
        self._iscsi_target_iqn = None
        self._iscsi_target_iqn_contains = None
        self._iscsi_target_iqn_ends_with = None
        self._iscsi_target_iqn_gt = None
        self._iscsi_target_iqn_gte = None
        self._iscsi_target_iqn_in = None
        self._iscsi_target_iqn_lt = None
        self._iscsi_target_iqn_lte = None
        self._iscsi_target_iqn_not = None
        self._iscsi_target_iqn_not_contains = None
        self._iscsi_target_iqn_not_ends_with = None
        self._iscsi_target_iqn_not_in = None
        self._iscsi_target_iqn_not_starts_with = None
        self._iscsi_target_iqn_starts_with = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._nfs_path = None
        self._nfs_path_contains = None
        self._nfs_path_ends_with = None
        self._nfs_path_gt = None
        self._nfs_path_gte = None
        self._nfs_path_in = None
        self._nfs_path_lt = None
        self._nfs_path_lte = None
        self._nfs_path_not = None
        self._nfs_path_not_contains = None
        self._nfs_path_not_ends_with = None
        self._nfs_path_not_in = None
        self._nfs_path_not_starts_with = None
        self._nfs_path_starts_with = None
        self._nfs_server = None
        self._nfs_server_contains = None
        self._nfs_server_ends_with = None
        self._nfs_server_gt = None
        self._nfs_server_gte = None
        self._nfs_server_in = None
        self._nfs_server_lt = None
        self._nfs_server_lte = None
        self._nfs_server_not = None
        self._nfs_server_not_contains = None
        self._nfs_server_not_ends_with = None
        self._nfs_server_not_in = None
        self._nfs_server_not_starts_with = None
        self._nfs_server_starts_with = None
        self._status = None
        self._status_in = None
        self._status_not = None
        self._status_not_in = None
        self._total_capacity = None
        self._total_capacity_gt = None
        self._total_capacity_gte = None
        self._total_capacity_in = None
        self._total_capacity_lt = None
        self._total_capacity_lte = None
        self._total_capacity_not = None
        self._total_capacity_not_in = None
        self._type = None
        self._type_in = None
        self._type_not = None
        self._type_not_in = None
        self._update_timestamp = None
        self._update_timestamp_contains = None
        self._update_timestamp_ends_with = None
        self._update_timestamp_gt = None
        self._update_timestamp_gte = None
        self._update_timestamp_in = None
        self._update_timestamp_lt = None
        self._update_timestamp_lte = None
        self._update_timestamp_not = None
        self._update_timestamp_not_contains = None
        self._update_timestamp_not_ends_with = None
        self._update_timestamp_not_in = None
        self._update_timestamp_not_starts_with = None
        self._update_timestamp_starts_with = None
        self._used_data_space = None
        self._used_data_space_gt = None
        self._used_data_space_gte = None
        self._used_data_space_in = None
        self._used_data_space_lt = None
        self._used_data_space_lte = None
        self._used_data_space_not = None
        self._used_data_space_not_in = None
        self._used_data_space_usage = None
        self._used_data_space_usage_gt = None
        self._used_data_space_usage_gte = None
        self._used_data_space_usage_in = None
        self._used_data_space_usage_lt = None
        self._used_data_space_usage_lte = None
        self._used_data_space_usage_not = None
        self._used_data_space_usage_not_in = None
        self._valid_data_space = None
        self._valid_data_space_gt = None
        self._valid_data_space_gte = None
        self._valid_data_space_in = None
        self._valid_data_space_lt = None
        self._valid_data_space_lte = None
        self._valid_data_space_not = None
        self._valid_data_space_not_in = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.backup_plans_every = kwargs.get("backup_plans_every", None)
        self.backup_plans_none = kwargs.get("backup_plans_none", None)
        self.backup_plans_some = kwargs.get("backup_plans_some", None)
        self.backup_restore_points_every = kwargs.get("backup_restore_points_every", None)
        self.backup_restore_points_none = kwargs.get("backup_restore_points_none", None)
        self.backup_restore_points_some = kwargs.get("backup_restore_points_some", None)
        self.backup_service = kwargs.get("backup_service", None)
        self.created_at = kwargs.get("created_at", None)
        self.created_at_gt = kwargs.get("created_at_gt", None)
        self.created_at_gte = kwargs.get("created_at_gte", None)
        self.created_at_in = kwargs.get("created_at_in", None)
        self.created_at_lt = kwargs.get("created_at_lt", None)
        self.created_at_lte = kwargs.get("created_at_lte", None)
        self.created_at_not = kwargs.get("created_at_not", None)
        self.created_at_not_in = kwargs.get("created_at_not_in", None)
        self.description = kwargs.get("description", None)
        self.description_contains = kwargs.get("description_contains", None)
        self.description_ends_with = kwargs.get("description_ends_with", None)
        self.description_gt = kwargs.get("description_gt", None)
        self.description_gte = kwargs.get("description_gte", None)
        self.description_in = kwargs.get("description_in", None)
        self.description_lt = kwargs.get("description_lt", None)
        self.description_lte = kwargs.get("description_lte", None)
        self.description_not = kwargs.get("description_not", None)
        self.description_not_contains = kwargs.get("description_not_contains", None)
        self.description_not_ends_with = kwargs.get("description_not_ends_with", None)
        self.description_not_in = kwargs.get("description_not_in", None)
        self.description_not_starts_with = kwargs.get("description_not_starts_with", None)
        self.description_starts_with = kwargs.get("description_starts_with", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.error_code = kwargs.get("error_code", None)
        self.error_code_contains = kwargs.get("error_code_contains", None)
        self.error_code_ends_with = kwargs.get("error_code_ends_with", None)
        self.error_code_gt = kwargs.get("error_code_gt", None)
        self.error_code_gte = kwargs.get("error_code_gte", None)
        self.error_code_in = kwargs.get("error_code_in", None)
        self.error_code_lt = kwargs.get("error_code_lt", None)
        self.error_code_lte = kwargs.get("error_code_lte", None)
        self.error_code_not = kwargs.get("error_code_not", None)
        self.error_code_not_contains = kwargs.get("error_code_not_contains", None)
        self.error_code_not_ends_with = kwargs.get("error_code_not_ends_with", None)
        self.error_code_not_in = kwargs.get("error_code_not_in", None)
        self.error_code_not_starts_with = kwargs.get("error_code_not_starts_with", None)
        self.error_code_starts_with = kwargs.get("error_code_starts_with", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.iscsi_chap_name = kwargs.get("iscsi_chap_name", None)
        self.iscsi_chap_name_contains = kwargs.get("iscsi_chap_name_contains", None)
        self.iscsi_chap_name_ends_with = kwargs.get("iscsi_chap_name_ends_with", None)
        self.iscsi_chap_name_gt = kwargs.get("iscsi_chap_name_gt", None)
        self.iscsi_chap_name_gte = kwargs.get("iscsi_chap_name_gte", None)
        self.iscsi_chap_name_in = kwargs.get("iscsi_chap_name_in", None)
        self.iscsi_chap_name_lt = kwargs.get("iscsi_chap_name_lt", None)
        self.iscsi_chap_name_lte = kwargs.get("iscsi_chap_name_lte", None)
        self.iscsi_chap_name_not = kwargs.get("iscsi_chap_name_not", None)
        self.iscsi_chap_name_not_contains = kwargs.get("iscsi_chap_name_not_contains", None)
        self.iscsi_chap_name_not_ends_with = kwargs.get("iscsi_chap_name_not_ends_with", None)
        self.iscsi_chap_name_not_in = kwargs.get("iscsi_chap_name_not_in", None)
        self.iscsi_chap_name_not_starts_with = kwargs.get("iscsi_chap_name_not_starts_with", None)
        self.iscsi_chap_name_starts_with = kwargs.get("iscsi_chap_name_starts_with", None)
        self.iscsi_chap_secret = kwargs.get("iscsi_chap_secret", None)
        self.iscsi_chap_secret_contains = kwargs.get("iscsi_chap_secret_contains", None)
        self.iscsi_chap_secret_ends_with = kwargs.get("iscsi_chap_secret_ends_with", None)
        self.iscsi_chap_secret_gt = kwargs.get("iscsi_chap_secret_gt", None)
        self.iscsi_chap_secret_gte = kwargs.get("iscsi_chap_secret_gte", None)
        self.iscsi_chap_secret_in = kwargs.get("iscsi_chap_secret_in", None)
        self.iscsi_chap_secret_lt = kwargs.get("iscsi_chap_secret_lt", None)
        self.iscsi_chap_secret_lte = kwargs.get("iscsi_chap_secret_lte", None)
        self.iscsi_chap_secret_not = kwargs.get("iscsi_chap_secret_not", None)
        self.iscsi_chap_secret_not_contains = kwargs.get("iscsi_chap_secret_not_contains", None)
        self.iscsi_chap_secret_not_ends_with = kwargs.get("iscsi_chap_secret_not_ends_with", None)
        self.iscsi_chap_secret_not_in = kwargs.get("iscsi_chap_secret_not_in", None)
        self.iscsi_chap_secret_not_starts_with = kwargs.get("iscsi_chap_secret_not_starts_with", None)
        self.iscsi_chap_secret_starts_with = kwargs.get("iscsi_chap_secret_starts_with", None)
        self.iscsi_ip = kwargs.get("iscsi_ip", None)
        self.iscsi_ip_contains = kwargs.get("iscsi_ip_contains", None)
        self.iscsi_ip_ends_with = kwargs.get("iscsi_ip_ends_with", None)
        self.iscsi_ip_gt = kwargs.get("iscsi_ip_gt", None)
        self.iscsi_ip_gte = kwargs.get("iscsi_ip_gte", None)
        self.iscsi_ip_in = kwargs.get("iscsi_ip_in", None)
        self.iscsi_ip_lt = kwargs.get("iscsi_ip_lt", None)
        self.iscsi_ip_lte = kwargs.get("iscsi_ip_lte", None)
        self.iscsi_ip_not = kwargs.get("iscsi_ip_not", None)
        self.iscsi_ip_not_contains = kwargs.get("iscsi_ip_not_contains", None)
        self.iscsi_ip_not_ends_with = kwargs.get("iscsi_ip_not_ends_with", None)
        self.iscsi_ip_not_in = kwargs.get("iscsi_ip_not_in", None)
        self.iscsi_ip_not_starts_with = kwargs.get("iscsi_ip_not_starts_with", None)
        self.iscsi_ip_starts_with = kwargs.get("iscsi_ip_starts_with", None)
        self.iscsi_lun_id = kwargs.get("iscsi_lun_id", None)
        self.iscsi_lun_id_contains = kwargs.get("iscsi_lun_id_contains", None)
        self.iscsi_lun_id_ends_with = kwargs.get("iscsi_lun_id_ends_with", None)
        self.iscsi_lun_id_gt = kwargs.get("iscsi_lun_id_gt", None)
        self.iscsi_lun_id_gte = kwargs.get("iscsi_lun_id_gte", None)
        self.iscsi_lun_id_in = kwargs.get("iscsi_lun_id_in", None)
        self.iscsi_lun_id_lt = kwargs.get("iscsi_lun_id_lt", None)
        self.iscsi_lun_id_lte = kwargs.get("iscsi_lun_id_lte", None)
        self.iscsi_lun_id_not = kwargs.get("iscsi_lun_id_not", None)
        self.iscsi_lun_id_not_contains = kwargs.get("iscsi_lun_id_not_contains", None)
        self.iscsi_lun_id_not_ends_with = kwargs.get("iscsi_lun_id_not_ends_with", None)
        self.iscsi_lun_id_not_in = kwargs.get("iscsi_lun_id_not_in", None)
        self.iscsi_lun_id_not_starts_with = kwargs.get("iscsi_lun_id_not_starts_with", None)
        self.iscsi_lun_id_starts_with = kwargs.get("iscsi_lun_id_starts_with", None)
        self.iscsi_port = kwargs.get("iscsi_port", None)
        self.iscsi_port_gt = kwargs.get("iscsi_port_gt", None)
        self.iscsi_port_gte = kwargs.get("iscsi_port_gte", None)
        self.iscsi_port_in = kwargs.get("iscsi_port_in", None)
        self.iscsi_port_lt = kwargs.get("iscsi_port_lt", None)
        self.iscsi_port_lte = kwargs.get("iscsi_port_lte", None)
        self.iscsi_port_not = kwargs.get("iscsi_port_not", None)
        self.iscsi_port_not_in = kwargs.get("iscsi_port_not_in", None)
        self.iscsi_target_iqn = kwargs.get("iscsi_target_iqn", None)
        self.iscsi_target_iqn_contains = kwargs.get("iscsi_target_iqn_contains", None)
        self.iscsi_target_iqn_ends_with = kwargs.get("iscsi_target_iqn_ends_with", None)
        self.iscsi_target_iqn_gt = kwargs.get("iscsi_target_iqn_gt", None)
        self.iscsi_target_iqn_gte = kwargs.get("iscsi_target_iqn_gte", None)
        self.iscsi_target_iqn_in = kwargs.get("iscsi_target_iqn_in", None)
        self.iscsi_target_iqn_lt = kwargs.get("iscsi_target_iqn_lt", None)
        self.iscsi_target_iqn_lte = kwargs.get("iscsi_target_iqn_lte", None)
        self.iscsi_target_iqn_not = kwargs.get("iscsi_target_iqn_not", None)
        self.iscsi_target_iqn_not_contains = kwargs.get("iscsi_target_iqn_not_contains", None)
        self.iscsi_target_iqn_not_ends_with = kwargs.get("iscsi_target_iqn_not_ends_with", None)
        self.iscsi_target_iqn_not_in = kwargs.get("iscsi_target_iqn_not_in", None)
        self.iscsi_target_iqn_not_starts_with = kwargs.get("iscsi_target_iqn_not_starts_with", None)
        self.iscsi_target_iqn_starts_with = kwargs.get("iscsi_target_iqn_starts_with", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.nfs_path = kwargs.get("nfs_path", None)
        self.nfs_path_contains = kwargs.get("nfs_path_contains", None)
        self.nfs_path_ends_with = kwargs.get("nfs_path_ends_with", None)
        self.nfs_path_gt = kwargs.get("nfs_path_gt", None)
        self.nfs_path_gte = kwargs.get("nfs_path_gte", None)
        self.nfs_path_in = kwargs.get("nfs_path_in", None)
        self.nfs_path_lt = kwargs.get("nfs_path_lt", None)
        self.nfs_path_lte = kwargs.get("nfs_path_lte", None)
        self.nfs_path_not = kwargs.get("nfs_path_not", None)
        self.nfs_path_not_contains = kwargs.get("nfs_path_not_contains", None)
        self.nfs_path_not_ends_with = kwargs.get("nfs_path_not_ends_with", None)
        self.nfs_path_not_in = kwargs.get("nfs_path_not_in", None)
        self.nfs_path_not_starts_with = kwargs.get("nfs_path_not_starts_with", None)
        self.nfs_path_starts_with = kwargs.get("nfs_path_starts_with", None)
        self.nfs_server = kwargs.get("nfs_server", None)
        self.nfs_server_contains = kwargs.get("nfs_server_contains", None)
        self.nfs_server_ends_with = kwargs.get("nfs_server_ends_with", None)
        self.nfs_server_gt = kwargs.get("nfs_server_gt", None)
        self.nfs_server_gte = kwargs.get("nfs_server_gte", None)
        self.nfs_server_in = kwargs.get("nfs_server_in", None)
        self.nfs_server_lt = kwargs.get("nfs_server_lt", None)
        self.nfs_server_lte = kwargs.get("nfs_server_lte", None)
        self.nfs_server_not = kwargs.get("nfs_server_not", None)
        self.nfs_server_not_contains = kwargs.get("nfs_server_not_contains", None)
        self.nfs_server_not_ends_with = kwargs.get("nfs_server_not_ends_with", None)
        self.nfs_server_not_in = kwargs.get("nfs_server_not_in", None)
        self.nfs_server_not_starts_with = kwargs.get("nfs_server_not_starts_with", None)
        self.nfs_server_starts_with = kwargs.get("nfs_server_starts_with", None)
        self.status = kwargs.get("status", None)
        self.status_in = kwargs.get("status_in", None)
        self.status_not = kwargs.get("status_not", None)
        self.status_not_in = kwargs.get("status_not_in", None)
        self.total_capacity = kwargs.get("total_capacity", None)
        self.total_capacity_gt = kwargs.get("total_capacity_gt", None)
        self.total_capacity_gte = kwargs.get("total_capacity_gte", None)
        self.total_capacity_in = kwargs.get("total_capacity_in", None)
        self.total_capacity_lt = kwargs.get("total_capacity_lt", None)
        self.total_capacity_lte = kwargs.get("total_capacity_lte", None)
        self.total_capacity_not = kwargs.get("total_capacity_not", None)
        self.total_capacity_not_in = kwargs.get("total_capacity_not_in", None)
        self.type = kwargs.get("type", None)
        self.type_in = kwargs.get("type_in", None)
        self.type_not = kwargs.get("type_not", None)
        self.type_not_in = kwargs.get("type_not_in", None)
        self.update_timestamp = kwargs.get("update_timestamp", None)
        self.update_timestamp_contains = kwargs.get("update_timestamp_contains", None)
        self.update_timestamp_ends_with = kwargs.get("update_timestamp_ends_with", None)
        self.update_timestamp_gt = kwargs.get("update_timestamp_gt", None)
        self.update_timestamp_gte = kwargs.get("update_timestamp_gte", None)
        self.update_timestamp_in = kwargs.get("update_timestamp_in", None)
        self.update_timestamp_lt = kwargs.get("update_timestamp_lt", None)
        self.update_timestamp_lte = kwargs.get("update_timestamp_lte", None)
        self.update_timestamp_not = kwargs.get("update_timestamp_not", None)
        self.update_timestamp_not_contains = kwargs.get("update_timestamp_not_contains", None)
        self.update_timestamp_not_ends_with = kwargs.get("update_timestamp_not_ends_with", None)
        self.update_timestamp_not_in = kwargs.get("update_timestamp_not_in", None)
        self.update_timestamp_not_starts_with = kwargs.get("update_timestamp_not_starts_with", None)
        self.update_timestamp_starts_with = kwargs.get("update_timestamp_starts_with", None)
        self.used_data_space = kwargs.get("used_data_space", None)
        self.used_data_space_gt = kwargs.get("used_data_space_gt", None)
        self.used_data_space_gte = kwargs.get("used_data_space_gte", None)
        self.used_data_space_in = kwargs.get("used_data_space_in", None)
        self.used_data_space_lt = kwargs.get("used_data_space_lt", None)
        self.used_data_space_lte = kwargs.get("used_data_space_lte", None)
        self.used_data_space_not = kwargs.get("used_data_space_not", None)
        self.used_data_space_not_in = kwargs.get("used_data_space_not_in", None)
        self.used_data_space_usage = kwargs.get("used_data_space_usage", None)
        self.used_data_space_usage_gt = kwargs.get("used_data_space_usage_gt", None)
        self.used_data_space_usage_gte = kwargs.get("used_data_space_usage_gte", None)
        self.used_data_space_usage_in = kwargs.get("used_data_space_usage_in", None)
        self.used_data_space_usage_lt = kwargs.get("used_data_space_usage_lt", None)
        self.used_data_space_usage_lte = kwargs.get("used_data_space_usage_lte", None)
        self.used_data_space_usage_not = kwargs.get("used_data_space_usage_not", None)
        self.used_data_space_usage_not_in = kwargs.get("used_data_space_usage_not_in", None)
        self.valid_data_space = kwargs.get("valid_data_space", None)
        self.valid_data_space_gt = kwargs.get("valid_data_space_gt", None)
        self.valid_data_space_gte = kwargs.get("valid_data_space_gte", None)
        self.valid_data_space_in = kwargs.get("valid_data_space_in", None)
        self.valid_data_space_lt = kwargs.get("valid_data_space_lt", None)
        self.valid_data_space_lte = kwargs.get("valid_data_space_lte", None)
        self.valid_data_space_not = kwargs.get("valid_data_space_not", None)
        self.valid_data_space_not_in = kwargs.get("valid_data_space_not_in", None)

    @property
    def _and(self):
        """Gets the _and of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The _and of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[BackupStoreRepositoryWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this BackupStoreRepositoryWhereInput.


        :param _and: The _and of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type _and: list[BackupStoreRepositoryWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The _not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[BackupStoreRepositoryWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this BackupStoreRepositoryWhereInput.


        :param _not: The _not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type _not: list[BackupStoreRepositoryWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The _or of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[BackupStoreRepositoryWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this BackupStoreRepositoryWhereInput.


        :param _or: The _or of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type _or: list[BackupStoreRepositoryWhereInput]
        """

        self.__or = _or

    @property
    def backup_plans_every(self):
        """Gets the backup_plans_every of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The backup_plans_every of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: BackupPlanWhereInput
        """
        return self._backup_plans_every

    @backup_plans_every.setter
    def backup_plans_every(self, backup_plans_every):
        """Sets the backup_plans_every of this BackupStoreRepositoryWhereInput.


        :param backup_plans_every: The backup_plans_every of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type backup_plans_every: BackupPlanWhereInput
        """

        self._backup_plans_every = backup_plans_every

    @property
    def backup_plans_none(self):
        """Gets the backup_plans_none of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The backup_plans_none of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: BackupPlanWhereInput
        """
        return self._backup_plans_none

    @backup_plans_none.setter
    def backup_plans_none(self, backup_plans_none):
        """Sets the backup_plans_none of this BackupStoreRepositoryWhereInput.


        :param backup_plans_none: The backup_plans_none of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type backup_plans_none: BackupPlanWhereInput
        """

        self._backup_plans_none = backup_plans_none

    @property
    def backup_plans_some(self):
        """Gets the backup_plans_some of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The backup_plans_some of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: BackupPlanWhereInput
        """
        return self._backup_plans_some

    @backup_plans_some.setter
    def backup_plans_some(self, backup_plans_some):
        """Sets the backup_plans_some of this BackupStoreRepositoryWhereInput.


        :param backup_plans_some: The backup_plans_some of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type backup_plans_some: BackupPlanWhereInput
        """

        self._backup_plans_some = backup_plans_some

    @property
    def backup_restore_points_every(self):
        """Gets the backup_restore_points_every of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The backup_restore_points_every of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: BackupRestorePointWhereInput
        """
        return self._backup_restore_points_every

    @backup_restore_points_every.setter
    def backup_restore_points_every(self, backup_restore_points_every):
        """Sets the backup_restore_points_every of this BackupStoreRepositoryWhereInput.


        :param backup_restore_points_every: The backup_restore_points_every of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type backup_restore_points_every: BackupRestorePointWhereInput
        """

        self._backup_restore_points_every = backup_restore_points_every

    @property
    def backup_restore_points_none(self):
        """Gets the backup_restore_points_none of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The backup_restore_points_none of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: BackupRestorePointWhereInput
        """
        return self._backup_restore_points_none

    @backup_restore_points_none.setter
    def backup_restore_points_none(self, backup_restore_points_none):
        """Sets the backup_restore_points_none of this BackupStoreRepositoryWhereInput.


        :param backup_restore_points_none: The backup_restore_points_none of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type backup_restore_points_none: BackupRestorePointWhereInput
        """

        self._backup_restore_points_none = backup_restore_points_none

    @property
    def backup_restore_points_some(self):
        """Gets the backup_restore_points_some of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The backup_restore_points_some of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: BackupRestorePointWhereInput
        """
        return self._backup_restore_points_some

    @backup_restore_points_some.setter
    def backup_restore_points_some(self, backup_restore_points_some):
        """Sets the backup_restore_points_some of this BackupStoreRepositoryWhereInput.


        :param backup_restore_points_some: The backup_restore_points_some of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type backup_restore_points_some: BackupRestorePointWhereInput
        """

        self._backup_restore_points_some = backup_restore_points_some

    @property
    def backup_service(self):
        """Gets the backup_service of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The backup_service of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: BackupServiceWhereInput
        """
        return self._backup_service

    @backup_service.setter
    def backup_service(self, backup_service):
        """Sets the backup_service of this BackupStoreRepositoryWhereInput.


        :param backup_service: The backup_service of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type backup_service: BackupServiceWhereInput
        """

        self._backup_service = backup_service

    @property
    def created_at(self):
        """Gets the created_at of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The created_at of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this BackupStoreRepositoryWhereInput.


        :param created_at: The created_at of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def created_at_gt(self):
        """Gets the created_at_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The created_at_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_gt

    @created_at_gt.setter
    def created_at_gt(self, created_at_gt):
        """Sets the created_at_gt of this BackupStoreRepositoryWhereInput.


        :param created_at_gt: The created_at_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type created_at_gt: str
        """

        self._created_at_gt = created_at_gt

    @property
    def created_at_gte(self):
        """Gets the created_at_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The created_at_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_gte

    @created_at_gte.setter
    def created_at_gte(self, created_at_gte):
        """Sets the created_at_gte of this BackupStoreRepositoryWhereInput.


        :param created_at_gte: The created_at_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type created_at_gte: str
        """

        self._created_at_gte = created_at_gte

    @property
    def created_at_in(self):
        """Gets the created_at_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The created_at_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._created_at_in

    @created_at_in.setter
    def created_at_in(self, created_at_in):
        """Sets the created_at_in of this BackupStoreRepositoryWhereInput.


        :param created_at_in: The created_at_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type created_at_in: list[str]
        """

        self._created_at_in = created_at_in

    @property
    def created_at_lt(self):
        """Gets the created_at_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The created_at_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_lt

    @created_at_lt.setter
    def created_at_lt(self, created_at_lt):
        """Sets the created_at_lt of this BackupStoreRepositoryWhereInput.


        :param created_at_lt: The created_at_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type created_at_lt: str
        """

        self._created_at_lt = created_at_lt

    @property
    def created_at_lte(self):
        """Gets the created_at_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The created_at_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_lte

    @created_at_lte.setter
    def created_at_lte(self, created_at_lte):
        """Sets the created_at_lte of this BackupStoreRepositoryWhereInput.


        :param created_at_lte: The created_at_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type created_at_lte: str
        """

        self._created_at_lte = created_at_lte

    @property
    def created_at_not(self):
        """Gets the created_at_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The created_at_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at_not

    @created_at_not.setter
    def created_at_not(self, created_at_not):
        """Sets the created_at_not of this BackupStoreRepositoryWhereInput.


        :param created_at_not: The created_at_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type created_at_not: str
        """

        self._created_at_not = created_at_not

    @property
    def created_at_not_in(self):
        """Gets the created_at_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The created_at_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._created_at_not_in

    @created_at_not_in.setter
    def created_at_not_in(self, created_at_not_in):
        """Sets the created_at_not_in of this BackupStoreRepositoryWhereInput.


        :param created_at_not_in: The created_at_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type created_at_not_in: list[str]
        """

        self._created_at_not_in = created_at_not_in

    @property
    def description(self):
        """Gets the description of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BackupStoreRepositoryWhereInput.


        :param description: The description of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def description_contains(self):
        """Gets the description_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_contains

    @description_contains.setter
    def description_contains(self, description_contains):
        """Sets the description_contains of this BackupStoreRepositoryWhereInput.


        :param description_contains: The description_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_contains: str
        """

        self._description_contains = description_contains

    @property
    def description_ends_with(self):
        """Gets the description_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_ends_with

    @description_ends_with.setter
    def description_ends_with(self, description_ends_with):
        """Sets the description_ends_with of this BackupStoreRepositoryWhereInput.


        :param description_ends_with: The description_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_ends_with: str
        """

        self._description_ends_with = description_ends_with

    @property
    def description_gt(self):
        """Gets the description_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gt

    @description_gt.setter
    def description_gt(self, description_gt):
        """Sets the description_gt of this BackupStoreRepositoryWhereInput.


        :param description_gt: The description_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_gt: str
        """

        self._description_gt = description_gt

    @property
    def description_gte(self):
        """Gets the description_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_gte

    @description_gte.setter
    def description_gte(self, description_gte):
        """Sets the description_gte of this BackupStoreRepositoryWhereInput.


        :param description_gte: The description_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_gte: str
        """

        self._description_gte = description_gte

    @property
    def description_in(self):
        """Gets the description_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_in

    @description_in.setter
    def description_in(self, description_in):
        """Sets the description_in of this BackupStoreRepositoryWhereInput.


        :param description_in: The description_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_in: list[str]
        """

        self._description_in = description_in

    @property
    def description_lt(self):
        """Gets the description_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lt

    @description_lt.setter
    def description_lt(self, description_lt):
        """Sets the description_lt of this BackupStoreRepositoryWhereInput.


        :param description_lt: The description_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_lt: str
        """

        self._description_lt = description_lt

    @property
    def description_lte(self):
        """Gets the description_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_lte

    @description_lte.setter
    def description_lte(self, description_lte):
        """Sets the description_lte of this BackupStoreRepositoryWhereInput.


        :param description_lte: The description_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_lte: str
        """

        self._description_lte = description_lte

    @property
    def description_not(self):
        """Gets the description_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not

    @description_not.setter
    def description_not(self, description_not):
        """Sets the description_not of this BackupStoreRepositoryWhereInput.


        :param description_not: The description_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_not: str
        """

        self._description_not = description_not

    @property
    def description_not_contains(self):
        """Gets the description_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_contains

    @description_not_contains.setter
    def description_not_contains(self, description_not_contains):
        """Sets the description_not_contains of this BackupStoreRepositoryWhereInput.


        :param description_not_contains: The description_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_not_contains: str
        """

        self._description_not_contains = description_not_contains

    @property
    def description_not_ends_with(self):
        """Gets the description_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_ends_with

    @description_not_ends_with.setter
    def description_not_ends_with(self, description_not_ends_with):
        """Sets the description_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param description_not_ends_with: The description_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_not_ends_with: str
        """

        self._description_not_ends_with = description_not_ends_with

    @property
    def description_not_in(self):
        """Gets the description_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._description_not_in

    @description_not_in.setter
    def description_not_in(self, description_not_in):
        """Sets the description_not_in of this BackupStoreRepositoryWhereInput.


        :param description_not_in: The description_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_not_in: list[str]
        """

        self._description_not_in = description_not_in

    @property
    def description_not_starts_with(self):
        """Gets the description_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_not_starts_with

    @description_not_starts_with.setter
    def description_not_starts_with(self, description_not_starts_with):
        """Sets the description_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param description_not_starts_with: The description_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_not_starts_with: str
        """

        self._description_not_starts_with = description_not_starts_with

    @property
    def description_starts_with(self):
        """Gets the description_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The description_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._description_starts_with

    @description_starts_with.setter
    def description_starts_with(self, description_starts_with):
        """Sets the description_starts_with of this BackupStoreRepositoryWhereInput.


        :param description_starts_with: The description_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type description_starts_with: str
        """

        self._description_starts_with = description_starts_with

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The entity_async_status of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this BackupStoreRepositoryWhereInput.


        :param entity_async_status: The entity_async_status of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this BackupStoreRepositoryWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this BackupStoreRepositoryWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this BackupStoreRepositoryWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def error_code(self):
        """Gets the error_code of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """Sets the error_code of this BackupStoreRepositoryWhereInput.


        :param error_code: The error_code of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code: str
        """

        self._error_code = error_code

    @property
    def error_code_contains(self):
        """Gets the error_code_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code_contains

    @error_code_contains.setter
    def error_code_contains(self, error_code_contains):
        """Sets the error_code_contains of this BackupStoreRepositoryWhereInput.


        :param error_code_contains: The error_code_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_contains: str
        """

        self._error_code_contains = error_code_contains

    @property
    def error_code_ends_with(self):
        """Gets the error_code_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code_ends_with

    @error_code_ends_with.setter
    def error_code_ends_with(self, error_code_ends_with):
        """Sets the error_code_ends_with of this BackupStoreRepositoryWhereInput.


        :param error_code_ends_with: The error_code_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_ends_with: str
        """

        self._error_code_ends_with = error_code_ends_with

    @property
    def error_code_gt(self):
        """Gets the error_code_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code_gt

    @error_code_gt.setter
    def error_code_gt(self, error_code_gt):
        """Sets the error_code_gt of this BackupStoreRepositoryWhereInput.


        :param error_code_gt: The error_code_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_gt: str
        """

        self._error_code_gt = error_code_gt

    @property
    def error_code_gte(self):
        """Gets the error_code_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code_gte

    @error_code_gte.setter
    def error_code_gte(self, error_code_gte):
        """Sets the error_code_gte of this BackupStoreRepositoryWhereInput.


        :param error_code_gte: The error_code_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_gte: str
        """

        self._error_code_gte = error_code_gte

    @property
    def error_code_in(self):
        """Gets the error_code_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._error_code_in

    @error_code_in.setter
    def error_code_in(self, error_code_in):
        """Sets the error_code_in of this BackupStoreRepositoryWhereInput.


        :param error_code_in: The error_code_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_in: list[str]
        """

        self._error_code_in = error_code_in

    @property
    def error_code_lt(self):
        """Gets the error_code_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code_lt

    @error_code_lt.setter
    def error_code_lt(self, error_code_lt):
        """Sets the error_code_lt of this BackupStoreRepositoryWhereInput.


        :param error_code_lt: The error_code_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_lt: str
        """

        self._error_code_lt = error_code_lt

    @property
    def error_code_lte(self):
        """Gets the error_code_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code_lte

    @error_code_lte.setter
    def error_code_lte(self, error_code_lte):
        """Sets the error_code_lte of this BackupStoreRepositoryWhereInput.


        :param error_code_lte: The error_code_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_lte: str
        """

        self._error_code_lte = error_code_lte

    @property
    def error_code_not(self):
        """Gets the error_code_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code_not

    @error_code_not.setter
    def error_code_not(self, error_code_not):
        """Sets the error_code_not of this BackupStoreRepositoryWhereInput.


        :param error_code_not: The error_code_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_not: str
        """

        self._error_code_not = error_code_not

    @property
    def error_code_not_contains(self):
        """Gets the error_code_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code_not_contains

    @error_code_not_contains.setter
    def error_code_not_contains(self, error_code_not_contains):
        """Sets the error_code_not_contains of this BackupStoreRepositoryWhereInput.


        :param error_code_not_contains: The error_code_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_not_contains: str
        """

        self._error_code_not_contains = error_code_not_contains

    @property
    def error_code_not_ends_with(self):
        """Gets the error_code_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code_not_ends_with

    @error_code_not_ends_with.setter
    def error_code_not_ends_with(self, error_code_not_ends_with):
        """Sets the error_code_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param error_code_not_ends_with: The error_code_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_not_ends_with: str
        """

        self._error_code_not_ends_with = error_code_not_ends_with

    @property
    def error_code_not_in(self):
        """Gets the error_code_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._error_code_not_in

    @error_code_not_in.setter
    def error_code_not_in(self, error_code_not_in):
        """Sets the error_code_not_in of this BackupStoreRepositoryWhereInput.


        :param error_code_not_in: The error_code_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_not_in: list[str]
        """

        self._error_code_not_in = error_code_not_in

    @property
    def error_code_not_starts_with(self):
        """Gets the error_code_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code_not_starts_with

    @error_code_not_starts_with.setter
    def error_code_not_starts_with(self, error_code_not_starts_with):
        """Sets the error_code_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param error_code_not_starts_with: The error_code_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_not_starts_with: str
        """

        self._error_code_not_starts_with = error_code_not_starts_with

    @property
    def error_code_starts_with(self):
        """Gets the error_code_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The error_code_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._error_code_starts_with

    @error_code_starts_with.setter
    def error_code_starts_with(self, error_code_starts_with):
        """Sets the error_code_starts_with of this BackupStoreRepositoryWhereInput.


        :param error_code_starts_with: The error_code_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type error_code_starts_with: str
        """

        self._error_code_starts_with = error_code_starts_with

    @property
    def id(self):
        """Gets the id of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BackupStoreRepositoryWhereInput.


        :param id: The id of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this BackupStoreRepositoryWhereInput.


        :param id_contains: The id_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this BackupStoreRepositoryWhereInput.


        :param id_ends_with: The id_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this BackupStoreRepositoryWhereInput.


        :param id_gt: The id_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this BackupStoreRepositoryWhereInput.


        :param id_gte: The id_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this BackupStoreRepositoryWhereInput.


        :param id_in: The id_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this BackupStoreRepositoryWhereInput.


        :param id_lt: The id_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this BackupStoreRepositoryWhereInput.


        :param id_lte: The id_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this BackupStoreRepositoryWhereInput.


        :param id_not: The id_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this BackupStoreRepositoryWhereInput.


        :param id_not_contains: The id_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this BackupStoreRepositoryWhereInput.


        :param id_not_in: The id_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The id_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this BackupStoreRepositoryWhereInput.


        :param id_starts_with: The id_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def iscsi_chap_name(self):
        """Gets the iscsi_chap_name of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name

    @iscsi_chap_name.setter
    def iscsi_chap_name(self, iscsi_chap_name):
        """Sets the iscsi_chap_name of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name: The iscsi_chap_name of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name: str
        """

        self._iscsi_chap_name = iscsi_chap_name

    @property
    def iscsi_chap_name_contains(self):
        """Gets the iscsi_chap_name_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name_contains

    @iscsi_chap_name_contains.setter
    def iscsi_chap_name_contains(self, iscsi_chap_name_contains):
        """Sets the iscsi_chap_name_contains of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_contains: The iscsi_chap_name_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_contains: str
        """

        self._iscsi_chap_name_contains = iscsi_chap_name_contains

    @property
    def iscsi_chap_name_ends_with(self):
        """Gets the iscsi_chap_name_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name_ends_with

    @iscsi_chap_name_ends_with.setter
    def iscsi_chap_name_ends_with(self, iscsi_chap_name_ends_with):
        """Sets the iscsi_chap_name_ends_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_ends_with: The iscsi_chap_name_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_ends_with: str
        """

        self._iscsi_chap_name_ends_with = iscsi_chap_name_ends_with

    @property
    def iscsi_chap_name_gt(self):
        """Gets the iscsi_chap_name_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name_gt

    @iscsi_chap_name_gt.setter
    def iscsi_chap_name_gt(self, iscsi_chap_name_gt):
        """Sets the iscsi_chap_name_gt of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_gt: The iscsi_chap_name_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_gt: str
        """

        self._iscsi_chap_name_gt = iscsi_chap_name_gt

    @property
    def iscsi_chap_name_gte(self):
        """Gets the iscsi_chap_name_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name_gte

    @iscsi_chap_name_gte.setter
    def iscsi_chap_name_gte(self, iscsi_chap_name_gte):
        """Sets the iscsi_chap_name_gte of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_gte: The iscsi_chap_name_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_gte: str
        """

        self._iscsi_chap_name_gte = iscsi_chap_name_gte

    @property
    def iscsi_chap_name_in(self):
        """Gets the iscsi_chap_name_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._iscsi_chap_name_in

    @iscsi_chap_name_in.setter
    def iscsi_chap_name_in(self, iscsi_chap_name_in):
        """Sets the iscsi_chap_name_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_in: The iscsi_chap_name_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_in: list[str]
        """

        self._iscsi_chap_name_in = iscsi_chap_name_in

    @property
    def iscsi_chap_name_lt(self):
        """Gets the iscsi_chap_name_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name_lt

    @iscsi_chap_name_lt.setter
    def iscsi_chap_name_lt(self, iscsi_chap_name_lt):
        """Sets the iscsi_chap_name_lt of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_lt: The iscsi_chap_name_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_lt: str
        """

        self._iscsi_chap_name_lt = iscsi_chap_name_lt

    @property
    def iscsi_chap_name_lte(self):
        """Gets the iscsi_chap_name_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name_lte

    @iscsi_chap_name_lte.setter
    def iscsi_chap_name_lte(self, iscsi_chap_name_lte):
        """Sets the iscsi_chap_name_lte of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_lte: The iscsi_chap_name_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_lte: str
        """

        self._iscsi_chap_name_lte = iscsi_chap_name_lte

    @property
    def iscsi_chap_name_not(self):
        """Gets the iscsi_chap_name_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name_not

    @iscsi_chap_name_not.setter
    def iscsi_chap_name_not(self, iscsi_chap_name_not):
        """Sets the iscsi_chap_name_not of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_not: The iscsi_chap_name_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_not: str
        """

        self._iscsi_chap_name_not = iscsi_chap_name_not

    @property
    def iscsi_chap_name_not_contains(self):
        """Gets the iscsi_chap_name_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name_not_contains

    @iscsi_chap_name_not_contains.setter
    def iscsi_chap_name_not_contains(self, iscsi_chap_name_not_contains):
        """Sets the iscsi_chap_name_not_contains of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_not_contains: The iscsi_chap_name_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_not_contains: str
        """

        self._iscsi_chap_name_not_contains = iscsi_chap_name_not_contains

    @property
    def iscsi_chap_name_not_ends_with(self):
        """Gets the iscsi_chap_name_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name_not_ends_with

    @iscsi_chap_name_not_ends_with.setter
    def iscsi_chap_name_not_ends_with(self, iscsi_chap_name_not_ends_with):
        """Sets the iscsi_chap_name_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_not_ends_with: The iscsi_chap_name_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_not_ends_with: str
        """

        self._iscsi_chap_name_not_ends_with = iscsi_chap_name_not_ends_with

    @property
    def iscsi_chap_name_not_in(self):
        """Gets the iscsi_chap_name_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._iscsi_chap_name_not_in

    @iscsi_chap_name_not_in.setter
    def iscsi_chap_name_not_in(self, iscsi_chap_name_not_in):
        """Sets the iscsi_chap_name_not_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_not_in: The iscsi_chap_name_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_not_in: list[str]
        """

        self._iscsi_chap_name_not_in = iscsi_chap_name_not_in

    @property
    def iscsi_chap_name_not_starts_with(self):
        """Gets the iscsi_chap_name_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name_not_starts_with

    @iscsi_chap_name_not_starts_with.setter
    def iscsi_chap_name_not_starts_with(self, iscsi_chap_name_not_starts_with):
        """Sets the iscsi_chap_name_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_not_starts_with: The iscsi_chap_name_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_not_starts_with: str
        """

        self._iscsi_chap_name_not_starts_with = iscsi_chap_name_not_starts_with

    @property
    def iscsi_chap_name_starts_with(self):
        """Gets the iscsi_chap_name_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_name_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_name_starts_with

    @iscsi_chap_name_starts_with.setter
    def iscsi_chap_name_starts_with(self, iscsi_chap_name_starts_with):
        """Sets the iscsi_chap_name_starts_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_name_starts_with: The iscsi_chap_name_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_name_starts_with: str
        """

        self._iscsi_chap_name_starts_with = iscsi_chap_name_starts_with

    @property
    def iscsi_chap_secret(self):
        """Gets the iscsi_chap_secret of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret

    @iscsi_chap_secret.setter
    def iscsi_chap_secret(self, iscsi_chap_secret):
        """Sets the iscsi_chap_secret of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret: The iscsi_chap_secret of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret: str
        """

        self._iscsi_chap_secret = iscsi_chap_secret

    @property
    def iscsi_chap_secret_contains(self):
        """Gets the iscsi_chap_secret_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret_contains

    @iscsi_chap_secret_contains.setter
    def iscsi_chap_secret_contains(self, iscsi_chap_secret_contains):
        """Sets the iscsi_chap_secret_contains of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_contains: The iscsi_chap_secret_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_contains: str
        """

        self._iscsi_chap_secret_contains = iscsi_chap_secret_contains

    @property
    def iscsi_chap_secret_ends_with(self):
        """Gets the iscsi_chap_secret_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret_ends_with

    @iscsi_chap_secret_ends_with.setter
    def iscsi_chap_secret_ends_with(self, iscsi_chap_secret_ends_with):
        """Sets the iscsi_chap_secret_ends_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_ends_with: The iscsi_chap_secret_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_ends_with: str
        """

        self._iscsi_chap_secret_ends_with = iscsi_chap_secret_ends_with

    @property
    def iscsi_chap_secret_gt(self):
        """Gets the iscsi_chap_secret_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret_gt

    @iscsi_chap_secret_gt.setter
    def iscsi_chap_secret_gt(self, iscsi_chap_secret_gt):
        """Sets the iscsi_chap_secret_gt of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_gt: The iscsi_chap_secret_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_gt: str
        """

        self._iscsi_chap_secret_gt = iscsi_chap_secret_gt

    @property
    def iscsi_chap_secret_gte(self):
        """Gets the iscsi_chap_secret_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret_gte

    @iscsi_chap_secret_gte.setter
    def iscsi_chap_secret_gte(self, iscsi_chap_secret_gte):
        """Sets the iscsi_chap_secret_gte of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_gte: The iscsi_chap_secret_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_gte: str
        """

        self._iscsi_chap_secret_gte = iscsi_chap_secret_gte

    @property
    def iscsi_chap_secret_in(self):
        """Gets the iscsi_chap_secret_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._iscsi_chap_secret_in

    @iscsi_chap_secret_in.setter
    def iscsi_chap_secret_in(self, iscsi_chap_secret_in):
        """Sets the iscsi_chap_secret_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_in: The iscsi_chap_secret_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_in: list[str]
        """

        self._iscsi_chap_secret_in = iscsi_chap_secret_in

    @property
    def iscsi_chap_secret_lt(self):
        """Gets the iscsi_chap_secret_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret_lt

    @iscsi_chap_secret_lt.setter
    def iscsi_chap_secret_lt(self, iscsi_chap_secret_lt):
        """Sets the iscsi_chap_secret_lt of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_lt: The iscsi_chap_secret_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_lt: str
        """

        self._iscsi_chap_secret_lt = iscsi_chap_secret_lt

    @property
    def iscsi_chap_secret_lte(self):
        """Gets the iscsi_chap_secret_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret_lte

    @iscsi_chap_secret_lte.setter
    def iscsi_chap_secret_lte(self, iscsi_chap_secret_lte):
        """Sets the iscsi_chap_secret_lte of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_lte: The iscsi_chap_secret_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_lte: str
        """

        self._iscsi_chap_secret_lte = iscsi_chap_secret_lte

    @property
    def iscsi_chap_secret_not(self):
        """Gets the iscsi_chap_secret_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret_not

    @iscsi_chap_secret_not.setter
    def iscsi_chap_secret_not(self, iscsi_chap_secret_not):
        """Sets the iscsi_chap_secret_not of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_not: The iscsi_chap_secret_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_not: str
        """

        self._iscsi_chap_secret_not = iscsi_chap_secret_not

    @property
    def iscsi_chap_secret_not_contains(self):
        """Gets the iscsi_chap_secret_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret_not_contains

    @iscsi_chap_secret_not_contains.setter
    def iscsi_chap_secret_not_contains(self, iscsi_chap_secret_not_contains):
        """Sets the iscsi_chap_secret_not_contains of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_not_contains: The iscsi_chap_secret_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_not_contains: str
        """

        self._iscsi_chap_secret_not_contains = iscsi_chap_secret_not_contains

    @property
    def iscsi_chap_secret_not_ends_with(self):
        """Gets the iscsi_chap_secret_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret_not_ends_with

    @iscsi_chap_secret_not_ends_with.setter
    def iscsi_chap_secret_not_ends_with(self, iscsi_chap_secret_not_ends_with):
        """Sets the iscsi_chap_secret_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_not_ends_with: The iscsi_chap_secret_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_not_ends_with: str
        """

        self._iscsi_chap_secret_not_ends_with = iscsi_chap_secret_not_ends_with

    @property
    def iscsi_chap_secret_not_in(self):
        """Gets the iscsi_chap_secret_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._iscsi_chap_secret_not_in

    @iscsi_chap_secret_not_in.setter
    def iscsi_chap_secret_not_in(self, iscsi_chap_secret_not_in):
        """Sets the iscsi_chap_secret_not_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_not_in: The iscsi_chap_secret_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_not_in: list[str]
        """

        self._iscsi_chap_secret_not_in = iscsi_chap_secret_not_in

    @property
    def iscsi_chap_secret_not_starts_with(self):
        """Gets the iscsi_chap_secret_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret_not_starts_with

    @iscsi_chap_secret_not_starts_with.setter
    def iscsi_chap_secret_not_starts_with(self, iscsi_chap_secret_not_starts_with):
        """Sets the iscsi_chap_secret_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_not_starts_with: The iscsi_chap_secret_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_not_starts_with: str
        """

        self._iscsi_chap_secret_not_starts_with = iscsi_chap_secret_not_starts_with

    @property
    def iscsi_chap_secret_starts_with(self):
        """Gets the iscsi_chap_secret_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_chap_secret_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_chap_secret_starts_with

    @iscsi_chap_secret_starts_with.setter
    def iscsi_chap_secret_starts_with(self, iscsi_chap_secret_starts_with):
        """Sets the iscsi_chap_secret_starts_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_chap_secret_starts_with: The iscsi_chap_secret_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_chap_secret_starts_with: str
        """

        self._iscsi_chap_secret_starts_with = iscsi_chap_secret_starts_with

    @property
    def iscsi_ip(self):
        """Gets the iscsi_ip of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip

    @iscsi_ip.setter
    def iscsi_ip(self, iscsi_ip):
        """Sets the iscsi_ip of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip: The iscsi_ip of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip: str
        """

        self._iscsi_ip = iscsi_ip

    @property
    def iscsi_ip_contains(self):
        """Gets the iscsi_ip_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip_contains

    @iscsi_ip_contains.setter
    def iscsi_ip_contains(self, iscsi_ip_contains):
        """Sets the iscsi_ip_contains of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_contains: The iscsi_ip_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_contains: str
        """

        self._iscsi_ip_contains = iscsi_ip_contains

    @property
    def iscsi_ip_ends_with(self):
        """Gets the iscsi_ip_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip_ends_with

    @iscsi_ip_ends_with.setter
    def iscsi_ip_ends_with(self, iscsi_ip_ends_with):
        """Sets the iscsi_ip_ends_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_ends_with: The iscsi_ip_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_ends_with: str
        """

        self._iscsi_ip_ends_with = iscsi_ip_ends_with

    @property
    def iscsi_ip_gt(self):
        """Gets the iscsi_ip_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip_gt

    @iscsi_ip_gt.setter
    def iscsi_ip_gt(self, iscsi_ip_gt):
        """Sets the iscsi_ip_gt of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_gt: The iscsi_ip_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_gt: str
        """

        self._iscsi_ip_gt = iscsi_ip_gt

    @property
    def iscsi_ip_gte(self):
        """Gets the iscsi_ip_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip_gte

    @iscsi_ip_gte.setter
    def iscsi_ip_gte(self, iscsi_ip_gte):
        """Sets the iscsi_ip_gte of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_gte: The iscsi_ip_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_gte: str
        """

        self._iscsi_ip_gte = iscsi_ip_gte

    @property
    def iscsi_ip_in(self):
        """Gets the iscsi_ip_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._iscsi_ip_in

    @iscsi_ip_in.setter
    def iscsi_ip_in(self, iscsi_ip_in):
        """Sets the iscsi_ip_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_in: The iscsi_ip_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_in: list[str]
        """

        self._iscsi_ip_in = iscsi_ip_in

    @property
    def iscsi_ip_lt(self):
        """Gets the iscsi_ip_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip_lt

    @iscsi_ip_lt.setter
    def iscsi_ip_lt(self, iscsi_ip_lt):
        """Sets the iscsi_ip_lt of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_lt: The iscsi_ip_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_lt: str
        """

        self._iscsi_ip_lt = iscsi_ip_lt

    @property
    def iscsi_ip_lte(self):
        """Gets the iscsi_ip_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip_lte

    @iscsi_ip_lte.setter
    def iscsi_ip_lte(self, iscsi_ip_lte):
        """Sets the iscsi_ip_lte of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_lte: The iscsi_ip_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_lte: str
        """

        self._iscsi_ip_lte = iscsi_ip_lte

    @property
    def iscsi_ip_not(self):
        """Gets the iscsi_ip_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip_not

    @iscsi_ip_not.setter
    def iscsi_ip_not(self, iscsi_ip_not):
        """Sets the iscsi_ip_not of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_not: The iscsi_ip_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_not: str
        """

        self._iscsi_ip_not = iscsi_ip_not

    @property
    def iscsi_ip_not_contains(self):
        """Gets the iscsi_ip_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip_not_contains

    @iscsi_ip_not_contains.setter
    def iscsi_ip_not_contains(self, iscsi_ip_not_contains):
        """Sets the iscsi_ip_not_contains of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_not_contains: The iscsi_ip_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_not_contains: str
        """

        self._iscsi_ip_not_contains = iscsi_ip_not_contains

    @property
    def iscsi_ip_not_ends_with(self):
        """Gets the iscsi_ip_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip_not_ends_with

    @iscsi_ip_not_ends_with.setter
    def iscsi_ip_not_ends_with(self, iscsi_ip_not_ends_with):
        """Sets the iscsi_ip_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_not_ends_with: The iscsi_ip_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_not_ends_with: str
        """

        self._iscsi_ip_not_ends_with = iscsi_ip_not_ends_with

    @property
    def iscsi_ip_not_in(self):
        """Gets the iscsi_ip_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._iscsi_ip_not_in

    @iscsi_ip_not_in.setter
    def iscsi_ip_not_in(self, iscsi_ip_not_in):
        """Sets the iscsi_ip_not_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_not_in: The iscsi_ip_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_not_in: list[str]
        """

        self._iscsi_ip_not_in = iscsi_ip_not_in

    @property
    def iscsi_ip_not_starts_with(self):
        """Gets the iscsi_ip_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip_not_starts_with

    @iscsi_ip_not_starts_with.setter
    def iscsi_ip_not_starts_with(self, iscsi_ip_not_starts_with):
        """Sets the iscsi_ip_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_not_starts_with: The iscsi_ip_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_not_starts_with: str
        """

        self._iscsi_ip_not_starts_with = iscsi_ip_not_starts_with

    @property
    def iscsi_ip_starts_with(self):
        """Gets the iscsi_ip_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_ip_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_ip_starts_with

    @iscsi_ip_starts_with.setter
    def iscsi_ip_starts_with(self, iscsi_ip_starts_with):
        """Sets the iscsi_ip_starts_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_ip_starts_with: The iscsi_ip_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_ip_starts_with: str
        """

        self._iscsi_ip_starts_with = iscsi_ip_starts_with

    @property
    def iscsi_lun_id(self):
        """Gets the iscsi_lun_id of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id

    @iscsi_lun_id.setter
    def iscsi_lun_id(self, iscsi_lun_id):
        """Sets the iscsi_lun_id of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id: The iscsi_lun_id of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id: str
        """

        self._iscsi_lun_id = iscsi_lun_id

    @property
    def iscsi_lun_id_contains(self):
        """Gets the iscsi_lun_id_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id_contains

    @iscsi_lun_id_contains.setter
    def iscsi_lun_id_contains(self, iscsi_lun_id_contains):
        """Sets the iscsi_lun_id_contains of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_contains: The iscsi_lun_id_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_contains: str
        """

        self._iscsi_lun_id_contains = iscsi_lun_id_contains

    @property
    def iscsi_lun_id_ends_with(self):
        """Gets the iscsi_lun_id_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id_ends_with

    @iscsi_lun_id_ends_with.setter
    def iscsi_lun_id_ends_with(self, iscsi_lun_id_ends_with):
        """Sets the iscsi_lun_id_ends_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_ends_with: The iscsi_lun_id_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_ends_with: str
        """

        self._iscsi_lun_id_ends_with = iscsi_lun_id_ends_with

    @property
    def iscsi_lun_id_gt(self):
        """Gets the iscsi_lun_id_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id_gt

    @iscsi_lun_id_gt.setter
    def iscsi_lun_id_gt(self, iscsi_lun_id_gt):
        """Sets the iscsi_lun_id_gt of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_gt: The iscsi_lun_id_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_gt: str
        """

        self._iscsi_lun_id_gt = iscsi_lun_id_gt

    @property
    def iscsi_lun_id_gte(self):
        """Gets the iscsi_lun_id_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id_gte

    @iscsi_lun_id_gte.setter
    def iscsi_lun_id_gte(self, iscsi_lun_id_gte):
        """Sets the iscsi_lun_id_gte of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_gte: The iscsi_lun_id_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_gte: str
        """

        self._iscsi_lun_id_gte = iscsi_lun_id_gte

    @property
    def iscsi_lun_id_in(self):
        """Gets the iscsi_lun_id_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._iscsi_lun_id_in

    @iscsi_lun_id_in.setter
    def iscsi_lun_id_in(self, iscsi_lun_id_in):
        """Sets the iscsi_lun_id_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_in: The iscsi_lun_id_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_in: list[str]
        """

        self._iscsi_lun_id_in = iscsi_lun_id_in

    @property
    def iscsi_lun_id_lt(self):
        """Gets the iscsi_lun_id_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id_lt

    @iscsi_lun_id_lt.setter
    def iscsi_lun_id_lt(self, iscsi_lun_id_lt):
        """Sets the iscsi_lun_id_lt of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_lt: The iscsi_lun_id_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_lt: str
        """

        self._iscsi_lun_id_lt = iscsi_lun_id_lt

    @property
    def iscsi_lun_id_lte(self):
        """Gets the iscsi_lun_id_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id_lte

    @iscsi_lun_id_lte.setter
    def iscsi_lun_id_lte(self, iscsi_lun_id_lte):
        """Sets the iscsi_lun_id_lte of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_lte: The iscsi_lun_id_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_lte: str
        """

        self._iscsi_lun_id_lte = iscsi_lun_id_lte

    @property
    def iscsi_lun_id_not(self):
        """Gets the iscsi_lun_id_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id_not

    @iscsi_lun_id_not.setter
    def iscsi_lun_id_not(self, iscsi_lun_id_not):
        """Sets the iscsi_lun_id_not of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_not: The iscsi_lun_id_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_not: str
        """

        self._iscsi_lun_id_not = iscsi_lun_id_not

    @property
    def iscsi_lun_id_not_contains(self):
        """Gets the iscsi_lun_id_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id_not_contains

    @iscsi_lun_id_not_contains.setter
    def iscsi_lun_id_not_contains(self, iscsi_lun_id_not_contains):
        """Sets the iscsi_lun_id_not_contains of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_not_contains: The iscsi_lun_id_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_not_contains: str
        """

        self._iscsi_lun_id_not_contains = iscsi_lun_id_not_contains

    @property
    def iscsi_lun_id_not_ends_with(self):
        """Gets the iscsi_lun_id_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id_not_ends_with

    @iscsi_lun_id_not_ends_with.setter
    def iscsi_lun_id_not_ends_with(self, iscsi_lun_id_not_ends_with):
        """Sets the iscsi_lun_id_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_not_ends_with: The iscsi_lun_id_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_not_ends_with: str
        """

        self._iscsi_lun_id_not_ends_with = iscsi_lun_id_not_ends_with

    @property
    def iscsi_lun_id_not_in(self):
        """Gets the iscsi_lun_id_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._iscsi_lun_id_not_in

    @iscsi_lun_id_not_in.setter
    def iscsi_lun_id_not_in(self, iscsi_lun_id_not_in):
        """Sets the iscsi_lun_id_not_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_not_in: The iscsi_lun_id_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_not_in: list[str]
        """

        self._iscsi_lun_id_not_in = iscsi_lun_id_not_in

    @property
    def iscsi_lun_id_not_starts_with(self):
        """Gets the iscsi_lun_id_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id_not_starts_with

    @iscsi_lun_id_not_starts_with.setter
    def iscsi_lun_id_not_starts_with(self, iscsi_lun_id_not_starts_with):
        """Sets the iscsi_lun_id_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_not_starts_with: The iscsi_lun_id_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_not_starts_with: str
        """

        self._iscsi_lun_id_not_starts_with = iscsi_lun_id_not_starts_with

    @property
    def iscsi_lun_id_starts_with(self):
        """Gets the iscsi_lun_id_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_lun_id_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_lun_id_starts_with

    @iscsi_lun_id_starts_with.setter
    def iscsi_lun_id_starts_with(self, iscsi_lun_id_starts_with):
        """Sets the iscsi_lun_id_starts_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_lun_id_starts_with: The iscsi_lun_id_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_lun_id_starts_with: str
        """

        self._iscsi_lun_id_starts_with = iscsi_lun_id_starts_with

    @property
    def iscsi_port(self):
        """Gets the iscsi_port of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_port of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._iscsi_port

    @iscsi_port.setter
    def iscsi_port(self, iscsi_port):
        """Sets the iscsi_port of this BackupStoreRepositoryWhereInput.


        :param iscsi_port: The iscsi_port of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_port: int
        """

        self._iscsi_port = iscsi_port

    @property
    def iscsi_port_gt(self):
        """Gets the iscsi_port_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_port_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._iscsi_port_gt

    @iscsi_port_gt.setter
    def iscsi_port_gt(self, iscsi_port_gt):
        """Sets the iscsi_port_gt of this BackupStoreRepositoryWhereInput.


        :param iscsi_port_gt: The iscsi_port_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_port_gt: int
        """

        self._iscsi_port_gt = iscsi_port_gt

    @property
    def iscsi_port_gte(self):
        """Gets the iscsi_port_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_port_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._iscsi_port_gte

    @iscsi_port_gte.setter
    def iscsi_port_gte(self, iscsi_port_gte):
        """Sets the iscsi_port_gte of this BackupStoreRepositoryWhereInput.


        :param iscsi_port_gte: The iscsi_port_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_port_gte: int
        """

        self._iscsi_port_gte = iscsi_port_gte

    @property
    def iscsi_port_in(self):
        """Gets the iscsi_port_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_port_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._iscsi_port_in

    @iscsi_port_in.setter
    def iscsi_port_in(self, iscsi_port_in):
        """Sets the iscsi_port_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_port_in: The iscsi_port_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_port_in: list[int]
        """

        self._iscsi_port_in = iscsi_port_in

    @property
    def iscsi_port_lt(self):
        """Gets the iscsi_port_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_port_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._iscsi_port_lt

    @iscsi_port_lt.setter
    def iscsi_port_lt(self, iscsi_port_lt):
        """Sets the iscsi_port_lt of this BackupStoreRepositoryWhereInput.


        :param iscsi_port_lt: The iscsi_port_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_port_lt: int
        """

        self._iscsi_port_lt = iscsi_port_lt

    @property
    def iscsi_port_lte(self):
        """Gets the iscsi_port_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_port_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._iscsi_port_lte

    @iscsi_port_lte.setter
    def iscsi_port_lte(self, iscsi_port_lte):
        """Sets the iscsi_port_lte of this BackupStoreRepositoryWhereInput.


        :param iscsi_port_lte: The iscsi_port_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_port_lte: int
        """

        self._iscsi_port_lte = iscsi_port_lte

    @property
    def iscsi_port_not(self):
        """Gets the iscsi_port_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_port_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._iscsi_port_not

    @iscsi_port_not.setter
    def iscsi_port_not(self, iscsi_port_not):
        """Sets the iscsi_port_not of this BackupStoreRepositoryWhereInput.


        :param iscsi_port_not: The iscsi_port_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_port_not: int
        """

        self._iscsi_port_not = iscsi_port_not

    @property
    def iscsi_port_not_in(self):
        """Gets the iscsi_port_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_port_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._iscsi_port_not_in

    @iscsi_port_not_in.setter
    def iscsi_port_not_in(self, iscsi_port_not_in):
        """Sets the iscsi_port_not_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_port_not_in: The iscsi_port_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_port_not_in: list[int]
        """

        self._iscsi_port_not_in = iscsi_port_not_in

    @property
    def iscsi_target_iqn(self):
        """Gets the iscsi_target_iqn of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn

    @iscsi_target_iqn.setter
    def iscsi_target_iqn(self, iscsi_target_iqn):
        """Sets the iscsi_target_iqn of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn: The iscsi_target_iqn of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn: str
        """

        self._iscsi_target_iqn = iscsi_target_iqn

    @property
    def iscsi_target_iqn_contains(self):
        """Gets the iscsi_target_iqn_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn_contains

    @iscsi_target_iqn_contains.setter
    def iscsi_target_iqn_contains(self, iscsi_target_iqn_contains):
        """Sets the iscsi_target_iqn_contains of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_contains: The iscsi_target_iqn_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_contains: str
        """

        self._iscsi_target_iqn_contains = iscsi_target_iqn_contains

    @property
    def iscsi_target_iqn_ends_with(self):
        """Gets the iscsi_target_iqn_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn_ends_with

    @iscsi_target_iqn_ends_with.setter
    def iscsi_target_iqn_ends_with(self, iscsi_target_iqn_ends_with):
        """Sets the iscsi_target_iqn_ends_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_ends_with: The iscsi_target_iqn_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_ends_with: str
        """

        self._iscsi_target_iqn_ends_with = iscsi_target_iqn_ends_with

    @property
    def iscsi_target_iqn_gt(self):
        """Gets the iscsi_target_iqn_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn_gt

    @iscsi_target_iqn_gt.setter
    def iscsi_target_iqn_gt(self, iscsi_target_iqn_gt):
        """Sets the iscsi_target_iqn_gt of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_gt: The iscsi_target_iqn_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_gt: str
        """

        self._iscsi_target_iqn_gt = iscsi_target_iqn_gt

    @property
    def iscsi_target_iqn_gte(self):
        """Gets the iscsi_target_iqn_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn_gte

    @iscsi_target_iqn_gte.setter
    def iscsi_target_iqn_gte(self, iscsi_target_iqn_gte):
        """Sets the iscsi_target_iqn_gte of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_gte: The iscsi_target_iqn_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_gte: str
        """

        self._iscsi_target_iqn_gte = iscsi_target_iqn_gte

    @property
    def iscsi_target_iqn_in(self):
        """Gets the iscsi_target_iqn_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._iscsi_target_iqn_in

    @iscsi_target_iqn_in.setter
    def iscsi_target_iqn_in(self, iscsi_target_iqn_in):
        """Sets the iscsi_target_iqn_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_in: The iscsi_target_iqn_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_in: list[str]
        """

        self._iscsi_target_iqn_in = iscsi_target_iqn_in

    @property
    def iscsi_target_iqn_lt(self):
        """Gets the iscsi_target_iqn_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn_lt

    @iscsi_target_iqn_lt.setter
    def iscsi_target_iqn_lt(self, iscsi_target_iqn_lt):
        """Sets the iscsi_target_iqn_lt of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_lt: The iscsi_target_iqn_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_lt: str
        """

        self._iscsi_target_iqn_lt = iscsi_target_iqn_lt

    @property
    def iscsi_target_iqn_lte(self):
        """Gets the iscsi_target_iqn_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn_lte

    @iscsi_target_iqn_lte.setter
    def iscsi_target_iqn_lte(self, iscsi_target_iqn_lte):
        """Sets the iscsi_target_iqn_lte of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_lte: The iscsi_target_iqn_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_lte: str
        """

        self._iscsi_target_iqn_lte = iscsi_target_iqn_lte

    @property
    def iscsi_target_iqn_not(self):
        """Gets the iscsi_target_iqn_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn_not

    @iscsi_target_iqn_not.setter
    def iscsi_target_iqn_not(self, iscsi_target_iqn_not):
        """Sets the iscsi_target_iqn_not of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_not: The iscsi_target_iqn_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_not: str
        """

        self._iscsi_target_iqn_not = iscsi_target_iqn_not

    @property
    def iscsi_target_iqn_not_contains(self):
        """Gets the iscsi_target_iqn_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn_not_contains

    @iscsi_target_iqn_not_contains.setter
    def iscsi_target_iqn_not_contains(self, iscsi_target_iqn_not_contains):
        """Sets the iscsi_target_iqn_not_contains of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_not_contains: The iscsi_target_iqn_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_not_contains: str
        """

        self._iscsi_target_iqn_not_contains = iscsi_target_iqn_not_contains

    @property
    def iscsi_target_iqn_not_ends_with(self):
        """Gets the iscsi_target_iqn_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn_not_ends_with

    @iscsi_target_iqn_not_ends_with.setter
    def iscsi_target_iqn_not_ends_with(self, iscsi_target_iqn_not_ends_with):
        """Sets the iscsi_target_iqn_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_not_ends_with: The iscsi_target_iqn_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_not_ends_with: str
        """

        self._iscsi_target_iqn_not_ends_with = iscsi_target_iqn_not_ends_with

    @property
    def iscsi_target_iqn_not_in(self):
        """Gets the iscsi_target_iqn_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._iscsi_target_iqn_not_in

    @iscsi_target_iqn_not_in.setter
    def iscsi_target_iqn_not_in(self, iscsi_target_iqn_not_in):
        """Sets the iscsi_target_iqn_not_in of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_not_in: The iscsi_target_iqn_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_not_in: list[str]
        """

        self._iscsi_target_iqn_not_in = iscsi_target_iqn_not_in

    @property
    def iscsi_target_iqn_not_starts_with(self):
        """Gets the iscsi_target_iqn_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn_not_starts_with

    @iscsi_target_iqn_not_starts_with.setter
    def iscsi_target_iqn_not_starts_with(self, iscsi_target_iqn_not_starts_with):
        """Sets the iscsi_target_iqn_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_not_starts_with: The iscsi_target_iqn_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_not_starts_with: str
        """

        self._iscsi_target_iqn_not_starts_with = iscsi_target_iqn_not_starts_with

    @property
    def iscsi_target_iqn_starts_with(self):
        """Gets the iscsi_target_iqn_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The iscsi_target_iqn_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_target_iqn_starts_with

    @iscsi_target_iqn_starts_with.setter
    def iscsi_target_iqn_starts_with(self, iscsi_target_iqn_starts_with):
        """Sets the iscsi_target_iqn_starts_with of this BackupStoreRepositoryWhereInput.


        :param iscsi_target_iqn_starts_with: The iscsi_target_iqn_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type iscsi_target_iqn_starts_with: str
        """

        self._iscsi_target_iqn_starts_with = iscsi_target_iqn_starts_with

    @property
    def name(self):
        """Gets the name of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BackupStoreRepositoryWhereInput.


        :param name: The name of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this BackupStoreRepositoryWhereInput.


        :param name_contains: The name_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this BackupStoreRepositoryWhereInput.


        :param name_ends_with: The name_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this BackupStoreRepositoryWhereInput.


        :param name_gt: The name_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this BackupStoreRepositoryWhereInput.


        :param name_gte: The name_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this BackupStoreRepositoryWhereInput.


        :param name_in: The name_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this BackupStoreRepositoryWhereInput.


        :param name_lt: The name_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this BackupStoreRepositoryWhereInput.


        :param name_lte: The name_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this BackupStoreRepositoryWhereInput.


        :param name_not: The name_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this BackupStoreRepositoryWhereInput.


        :param name_not_contains: The name_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this BackupStoreRepositoryWhereInput.


        :param name_not_in: The name_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The name_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this BackupStoreRepositoryWhereInput.


        :param name_starts_with: The name_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def nfs_path(self):
        """Gets the nfs_path of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path

    @nfs_path.setter
    def nfs_path(self, nfs_path):
        """Sets the nfs_path of this BackupStoreRepositoryWhereInput.


        :param nfs_path: The nfs_path of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path: str
        """

        self._nfs_path = nfs_path

    @property
    def nfs_path_contains(self):
        """Gets the nfs_path_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path_contains

    @nfs_path_contains.setter
    def nfs_path_contains(self, nfs_path_contains):
        """Sets the nfs_path_contains of this BackupStoreRepositoryWhereInput.


        :param nfs_path_contains: The nfs_path_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_contains: str
        """

        self._nfs_path_contains = nfs_path_contains

    @property
    def nfs_path_ends_with(self):
        """Gets the nfs_path_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path_ends_with

    @nfs_path_ends_with.setter
    def nfs_path_ends_with(self, nfs_path_ends_with):
        """Sets the nfs_path_ends_with of this BackupStoreRepositoryWhereInput.


        :param nfs_path_ends_with: The nfs_path_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_ends_with: str
        """

        self._nfs_path_ends_with = nfs_path_ends_with

    @property
    def nfs_path_gt(self):
        """Gets the nfs_path_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path_gt

    @nfs_path_gt.setter
    def nfs_path_gt(self, nfs_path_gt):
        """Sets the nfs_path_gt of this BackupStoreRepositoryWhereInput.


        :param nfs_path_gt: The nfs_path_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_gt: str
        """

        self._nfs_path_gt = nfs_path_gt

    @property
    def nfs_path_gte(self):
        """Gets the nfs_path_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path_gte

    @nfs_path_gte.setter
    def nfs_path_gte(self, nfs_path_gte):
        """Sets the nfs_path_gte of this BackupStoreRepositoryWhereInput.


        :param nfs_path_gte: The nfs_path_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_gte: str
        """

        self._nfs_path_gte = nfs_path_gte

    @property
    def nfs_path_in(self):
        """Gets the nfs_path_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._nfs_path_in

    @nfs_path_in.setter
    def nfs_path_in(self, nfs_path_in):
        """Sets the nfs_path_in of this BackupStoreRepositoryWhereInput.


        :param nfs_path_in: The nfs_path_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_in: list[str]
        """

        self._nfs_path_in = nfs_path_in

    @property
    def nfs_path_lt(self):
        """Gets the nfs_path_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path_lt

    @nfs_path_lt.setter
    def nfs_path_lt(self, nfs_path_lt):
        """Sets the nfs_path_lt of this BackupStoreRepositoryWhereInput.


        :param nfs_path_lt: The nfs_path_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_lt: str
        """

        self._nfs_path_lt = nfs_path_lt

    @property
    def nfs_path_lte(self):
        """Gets the nfs_path_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path_lte

    @nfs_path_lte.setter
    def nfs_path_lte(self, nfs_path_lte):
        """Sets the nfs_path_lte of this BackupStoreRepositoryWhereInput.


        :param nfs_path_lte: The nfs_path_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_lte: str
        """

        self._nfs_path_lte = nfs_path_lte

    @property
    def nfs_path_not(self):
        """Gets the nfs_path_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path_not

    @nfs_path_not.setter
    def nfs_path_not(self, nfs_path_not):
        """Sets the nfs_path_not of this BackupStoreRepositoryWhereInput.


        :param nfs_path_not: The nfs_path_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_not: str
        """

        self._nfs_path_not = nfs_path_not

    @property
    def nfs_path_not_contains(self):
        """Gets the nfs_path_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path_not_contains

    @nfs_path_not_contains.setter
    def nfs_path_not_contains(self, nfs_path_not_contains):
        """Sets the nfs_path_not_contains of this BackupStoreRepositoryWhereInput.


        :param nfs_path_not_contains: The nfs_path_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_not_contains: str
        """

        self._nfs_path_not_contains = nfs_path_not_contains

    @property
    def nfs_path_not_ends_with(self):
        """Gets the nfs_path_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path_not_ends_with

    @nfs_path_not_ends_with.setter
    def nfs_path_not_ends_with(self, nfs_path_not_ends_with):
        """Sets the nfs_path_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param nfs_path_not_ends_with: The nfs_path_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_not_ends_with: str
        """

        self._nfs_path_not_ends_with = nfs_path_not_ends_with

    @property
    def nfs_path_not_in(self):
        """Gets the nfs_path_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._nfs_path_not_in

    @nfs_path_not_in.setter
    def nfs_path_not_in(self, nfs_path_not_in):
        """Sets the nfs_path_not_in of this BackupStoreRepositoryWhereInput.


        :param nfs_path_not_in: The nfs_path_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_not_in: list[str]
        """

        self._nfs_path_not_in = nfs_path_not_in

    @property
    def nfs_path_not_starts_with(self):
        """Gets the nfs_path_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path_not_starts_with

    @nfs_path_not_starts_with.setter
    def nfs_path_not_starts_with(self, nfs_path_not_starts_with):
        """Sets the nfs_path_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param nfs_path_not_starts_with: The nfs_path_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_not_starts_with: str
        """

        self._nfs_path_not_starts_with = nfs_path_not_starts_with

    @property
    def nfs_path_starts_with(self):
        """Gets the nfs_path_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_path_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_path_starts_with

    @nfs_path_starts_with.setter
    def nfs_path_starts_with(self, nfs_path_starts_with):
        """Sets the nfs_path_starts_with of this BackupStoreRepositoryWhereInput.


        :param nfs_path_starts_with: The nfs_path_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_path_starts_with: str
        """

        self._nfs_path_starts_with = nfs_path_starts_with

    @property
    def nfs_server(self):
        """Gets the nfs_server of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server

    @nfs_server.setter
    def nfs_server(self, nfs_server):
        """Sets the nfs_server of this BackupStoreRepositoryWhereInput.


        :param nfs_server: The nfs_server of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server: str
        """

        self._nfs_server = nfs_server

    @property
    def nfs_server_contains(self):
        """Gets the nfs_server_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server_contains

    @nfs_server_contains.setter
    def nfs_server_contains(self, nfs_server_contains):
        """Sets the nfs_server_contains of this BackupStoreRepositoryWhereInput.


        :param nfs_server_contains: The nfs_server_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_contains: str
        """

        self._nfs_server_contains = nfs_server_contains

    @property
    def nfs_server_ends_with(self):
        """Gets the nfs_server_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server_ends_with

    @nfs_server_ends_with.setter
    def nfs_server_ends_with(self, nfs_server_ends_with):
        """Sets the nfs_server_ends_with of this BackupStoreRepositoryWhereInput.


        :param nfs_server_ends_with: The nfs_server_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_ends_with: str
        """

        self._nfs_server_ends_with = nfs_server_ends_with

    @property
    def nfs_server_gt(self):
        """Gets the nfs_server_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server_gt

    @nfs_server_gt.setter
    def nfs_server_gt(self, nfs_server_gt):
        """Sets the nfs_server_gt of this BackupStoreRepositoryWhereInput.


        :param nfs_server_gt: The nfs_server_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_gt: str
        """

        self._nfs_server_gt = nfs_server_gt

    @property
    def nfs_server_gte(self):
        """Gets the nfs_server_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server_gte

    @nfs_server_gte.setter
    def nfs_server_gte(self, nfs_server_gte):
        """Sets the nfs_server_gte of this BackupStoreRepositoryWhereInput.


        :param nfs_server_gte: The nfs_server_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_gte: str
        """

        self._nfs_server_gte = nfs_server_gte

    @property
    def nfs_server_in(self):
        """Gets the nfs_server_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._nfs_server_in

    @nfs_server_in.setter
    def nfs_server_in(self, nfs_server_in):
        """Sets the nfs_server_in of this BackupStoreRepositoryWhereInput.


        :param nfs_server_in: The nfs_server_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_in: list[str]
        """

        self._nfs_server_in = nfs_server_in

    @property
    def nfs_server_lt(self):
        """Gets the nfs_server_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server_lt

    @nfs_server_lt.setter
    def nfs_server_lt(self, nfs_server_lt):
        """Sets the nfs_server_lt of this BackupStoreRepositoryWhereInput.


        :param nfs_server_lt: The nfs_server_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_lt: str
        """

        self._nfs_server_lt = nfs_server_lt

    @property
    def nfs_server_lte(self):
        """Gets the nfs_server_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server_lte

    @nfs_server_lte.setter
    def nfs_server_lte(self, nfs_server_lte):
        """Sets the nfs_server_lte of this BackupStoreRepositoryWhereInput.


        :param nfs_server_lte: The nfs_server_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_lte: str
        """

        self._nfs_server_lte = nfs_server_lte

    @property
    def nfs_server_not(self):
        """Gets the nfs_server_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server_not

    @nfs_server_not.setter
    def nfs_server_not(self, nfs_server_not):
        """Sets the nfs_server_not of this BackupStoreRepositoryWhereInput.


        :param nfs_server_not: The nfs_server_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_not: str
        """

        self._nfs_server_not = nfs_server_not

    @property
    def nfs_server_not_contains(self):
        """Gets the nfs_server_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server_not_contains

    @nfs_server_not_contains.setter
    def nfs_server_not_contains(self, nfs_server_not_contains):
        """Sets the nfs_server_not_contains of this BackupStoreRepositoryWhereInput.


        :param nfs_server_not_contains: The nfs_server_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_not_contains: str
        """

        self._nfs_server_not_contains = nfs_server_not_contains

    @property
    def nfs_server_not_ends_with(self):
        """Gets the nfs_server_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server_not_ends_with

    @nfs_server_not_ends_with.setter
    def nfs_server_not_ends_with(self, nfs_server_not_ends_with):
        """Sets the nfs_server_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param nfs_server_not_ends_with: The nfs_server_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_not_ends_with: str
        """

        self._nfs_server_not_ends_with = nfs_server_not_ends_with

    @property
    def nfs_server_not_in(self):
        """Gets the nfs_server_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._nfs_server_not_in

    @nfs_server_not_in.setter
    def nfs_server_not_in(self, nfs_server_not_in):
        """Sets the nfs_server_not_in of this BackupStoreRepositoryWhereInput.


        :param nfs_server_not_in: The nfs_server_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_not_in: list[str]
        """

        self._nfs_server_not_in = nfs_server_not_in

    @property
    def nfs_server_not_starts_with(self):
        """Gets the nfs_server_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server_not_starts_with

    @nfs_server_not_starts_with.setter
    def nfs_server_not_starts_with(self, nfs_server_not_starts_with):
        """Sets the nfs_server_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param nfs_server_not_starts_with: The nfs_server_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_not_starts_with: str
        """

        self._nfs_server_not_starts_with = nfs_server_not_starts_with

    @property
    def nfs_server_starts_with(self):
        """Gets the nfs_server_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The nfs_server_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._nfs_server_starts_with

    @nfs_server_starts_with.setter
    def nfs_server_starts_with(self, nfs_server_starts_with):
        """Sets the nfs_server_starts_with of this BackupStoreRepositoryWhereInput.


        :param nfs_server_starts_with: The nfs_server_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type nfs_server_starts_with: str
        """

        self._nfs_server_starts_with = nfs_server_starts_with

    @property
    def status(self):
        """Gets the status of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The status of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: BackupStoreStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BackupStoreRepositoryWhereInput.


        :param status: The status of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type status: BackupStoreStatus
        """

        self._status = status

    @property
    def status_in(self):
        """Gets the status_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The status_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[BackupStoreStatus]
        """
        return self._status_in

    @status_in.setter
    def status_in(self, status_in):
        """Sets the status_in of this BackupStoreRepositoryWhereInput.


        :param status_in: The status_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type status_in: list[BackupStoreStatus]
        """

        self._status_in = status_in

    @property
    def status_not(self):
        """Gets the status_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The status_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: BackupStoreStatus
        """
        return self._status_not

    @status_not.setter
    def status_not(self, status_not):
        """Sets the status_not of this BackupStoreRepositoryWhereInput.


        :param status_not: The status_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type status_not: BackupStoreStatus
        """

        self._status_not = status_not

    @property
    def status_not_in(self):
        """Gets the status_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The status_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[BackupStoreStatus]
        """
        return self._status_not_in

    @status_not_in.setter
    def status_not_in(self, status_not_in):
        """Sets the status_not_in of this BackupStoreRepositoryWhereInput.


        :param status_not_in: The status_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type status_not_in: list[BackupStoreStatus]
        """

        self._status_not_in = status_not_in

    @property
    def total_capacity(self):
        """Gets the total_capacity of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The total_capacity of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_capacity

    @total_capacity.setter
    def total_capacity(self, total_capacity):
        """Sets the total_capacity of this BackupStoreRepositoryWhereInput.


        :param total_capacity: The total_capacity of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type total_capacity: int
        """

        self._total_capacity = total_capacity

    @property
    def total_capacity_gt(self):
        """Gets the total_capacity_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The total_capacity_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_capacity_gt

    @total_capacity_gt.setter
    def total_capacity_gt(self, total_capacity_gt):
        """Sets the total_capacity_gt of this BackupStoreRepositoryWhereInput.


        :param total_capacity_gt: The total_capacity_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type total_capacity_gt: int
        """

        self._total_capacity_gt = total_capacity_gt

    @property
    def total_capacity_gte(self):
        """Gets the total_capacity_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The total_capacity_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_capacity_gte

    @total_capacity_gte.setter
    def total_capacity_gte(self, total_capacity_gte):
        """Sets the total_capacity_gte of this BackupStoreRepositoryWhereInput.


        :param total_capacity_gte: The total_capacity_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type total_capacity_gte: int
        """

        self._total_capacity_gte = total_capacity_gte

    @property
    def total_capacity_in(self):
        """Gets the total_capacity_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The total_capacity_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_capacity_in

    @total_capacity_in.setter
    def total_capacity_in(self, total_capacity_in):
        """Sets the total_capacity_in of this BackupStoreRepositoryWhereInput.


        :param total_capacity_in: The total_capacity_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type total_capacity_in: list[int]
        """

        self._total_capacity_in = total_capacity_in

    @property
    def total_capacity_lt(self):
        """Gets the total_capacity_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The total_capacity_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_capacity_lt

    @total_capacity_lt.setter
    def total_capacity_lt(self, total_capacity_lt):
        """Sets the total_capacity_lt of this BackupStoreRepositoryWhereInput.


        :param total_capacity_lt: The total_capacity_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type total_capacity_lt: int
        """

        self._total_capacity_lt = total_capacity_lt

    @property
    def total_capacity_lte(self):
        """Gets the total_capacity_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The total_capacity_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_capacity_lte

    @total_capacity_lte.setter
    def total_capacity_lte(self, total_capacity_lte):
        """Sets the total_capacity_lte of this BackupStoreRepositoryWhereInput.


        :param total_capacity_lte: The total_capacity_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type total_capacity_lte: int
        """

        self._total_capacity_lte = total_capacity_lte

    @property
    def total_capacity_not(self):
        """Gets the total_capacity_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The total_capacity_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_capacity_not

    @total_capacity_not.setter
    def total_capacity_not(self, total_capacity_not):
        """Sets the total_capacity_not of this BackupStoreRepositoryWhereInput.


        :param total_capacity_not: The total_capacity_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type total_capacity_not: int
        """

        self._total_capacity_not = total_capacity_not

    @property
    def total_capacity_not_in(self):
        """Gets the total_capacity_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The total_capacity_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_capacity_not_in

    @total_capacity_not_in.setter
    def total_capacity_not_in(self, total_capacity_not_in):
        """Sets the total_capacity_not_in of this BackupStoreRepositoryWhereInput.


        :param total_capacity_not_in: The total_capacity_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type total_capacity_not_in: list[int]
        """

        self._total_capacity_not_in = total_capacity_not_in

    @property
    def type(self):
        """Gets the type of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The type of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: BackupStoreType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BackupStoreRepositoryWhereInput.


        :param type: The type of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type type: BackupStoreType
        """

        self._type = type

    @property
    def type_in(self):
        """Gets the type_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The type_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[BackupStoreType]
        """
        return self._type_in

    @type_in.setter
    def type_in(self, type_in):
        """Sets the type_in of this BackupStoreRepositoryWhereInput.


        :param type_in: The type_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type type_in: list[BackupStoreType]
        """

        self._type_in = type_in

    @property
    def type_not(self):
        """Gets the type_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The type_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: BackupStoreType
        """
        return self._type_not

    @type_not.setter
    def type_not(self, type_not):
        """Sets the type_not of this BackupStoreRepositoryWhereInput.


        :param type_not: The type_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type type_not: BackupStoreType
        """

        self._type_not = type_not

    @property
    def type_not_in(self):
        """Gets the type_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The type_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[BackupStoreType]
        """
        return self._type_not_in

    @type_not_in.setter
    def type_not_in(self, type_not_in):
        """Sets the type_not_in of this BackupStoreRepositoryWhereInput.


        :param type_not_in: The type_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type type_not_in: list[BackupStoreType]
        """

        self._type_not_in = type_not_in

    @property
    def update_timestamp(self):
        """Gets the update_timestamp of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp

    @update_timestamp.setter
    def update_timestamp(self, update_timestamp):
        """Sets the update_timestamp of this BackupStoreRepositoryWhereInput.


        :param update_timestamp: The update_timestamp of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp: str
        """

        self._update_timestamp = update_timestamp

    @property
    def update_timestamp_contains(self):
        """Gets the update_timestamp_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp_contains

    @update_timestamp_contains.setter
    def update_timestamp_contains(self, update_timestamp_contains):
        """Sets the update_timestamp_contains of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_contains: The update_timestamp_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_contains: str
        """

        self._update_timestamp_contains = update_timestamp_contains

    @property
    def update_timestamp_ends_with(self):
        """Gets the update_timestamp_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp_ends_with

    @update_timestamp_ends_with.setter
    def update_timestamp_ends_with(self, update_timestamp_ends_with):
        """Sets the update_timestamp_ends_with of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_ends_with: The update_timestamp_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_ends_with: str
        """

        self._update_timestamp_ends_with = update_timestamp_ends_with

    @property
    def update_timestamp_gt(self):
        """Gets the update_timestamp_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp_gt

    @update_timestamp_gt.setter
    def update_timestamp_gt(self, update_timestamp_gt):
        """Sets the update_timestamp_gt of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_gt: The update_timestamp_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_gt: str
        """

        self._update_timestamp_gt = update_timestamp_gt

    @property
    def update_timestamp_gte(self):
        """Gets the update_timestamp_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp_gte

    @update_timestamp_gte.setter
    def update_timestamp_gte(self, update_timestamp_gte):
        """Sets the update_timestamp_gte of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_gte: The update_timestamp_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_gte: str
        """

        self._update_timestamp_gte = update_timestamp_gte

    @property
    def update_timestamp_in(self):
        """Gets the update_timestamp_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._update_timestamp_in

    @update_timestamp_in.setter
    def update_timestamp_in(self, update_timestamp_in):
        """Sets the update_timestamp_in of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_in: The update_timestamp_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_in: list[str]
        """

        self._update_timestamp_in = update_timestamp_in

    @property
    def update_timestamp_lt(self):
        """Gets the update_timestamp_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp_lt

    @update_timestamp_lt.setter
    def update_timestamp_lt(self, update_timestamp_lt):
        """Sets the update_timestamp_lt of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_lt: The update_timestamp_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_lt: str
        """

        self._update_timestamp_lt = update_timestamp_lt

    @property
    def update_timestamp_lte(self):
        """Gets the update_timestamp_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp_lte

    @update_timestamp_lte.setter
    def update_timestamp_lte(self, update_timestamp_lte):
        """Sets the update_timestamp_lte of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_lte: The update_timestamp_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_lte: str
        """

        self._update_timestamp_lte = update_timestamp_lte

    @property
    def update_timestamp_not(self):
        """Gets the update_timestamp_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp_not

    @update_timestamp_not.setter
    def update_timestamp_not(self, update_timestamp_not):
        """Sets the update_timestamp_not of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_not: The update_timestamp_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_not: str
        """

        self._update_timestamp_not = update_timestamp_not

    @property
    def update_timestamp_not_contains(self):
        """Gets the update_timestamp_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp_not_contains

    @update_timestamp_not_contains.setter
    def update_timestamp_not_contains(self, update_timestamp_not_contains):
        """Sets the update_timestamp_not_contains of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_not_contains: The update_timestamp_not_contains of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_not_contains: str
        """

        self._update_timestamp_not_contains = update_timestamp_not_contains

    @property
    def update_timestamp_not_ends_with(self):
        """Gets the update_timestamp_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp_not_ends_with

    @update_timestamp_not_ends_with.setter
    def update_timestamp_not_ends_with(self, update_timestamp_not_ends_with):
        """Sets the update_timestamp_not_ends_with of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_not_ends_with: The update_timestamp_not_ends_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_not_ends_with: str
        """

        self._update_timestamp_not_ends_with = update_timestamp_not_ends_with

    @property
    def update_timestamp_not_in(self):
        """Gets the update_timestamp_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._update_timestamp_not_in

    @update_timestamp_not_in.setter
    def update_timestamp_not_in(self, update_timestamp_not_in):
        """Sets the update_timestamp_not_in of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_not_in: The update_timestamp_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_not_in: list[str]
        """

        self._update_timestamp_not_in = update_timestamp_not_in

    @property
    def update_timestamp_not_starts_with(self):
        """Gets the update_timestamp_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp_not_starts_with

    @update_timestamp_not_starts_with.setter
    def update_timestamp_not_starts_with(self, update_timestamp_not_starts_with):
        """Sets the update_timestamp_not_starts_with of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_not_starts_with: The update_timestamp_not_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_not_starts_with: str
        """

        self._update_timestamp_not_starts_with = update_timestamp_not_starts_with

    @property
    def update_timestamp_starts_with(self):
        """Gets the update_timestamp_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The update_timestamp_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._update_timestamp_starts_with

    @update_timestamp_starts_with.setter
    def update_timestamp_starts_with(self, update_timestamp_starts_with):
        """Sets the update_timestamp_starts_with of this BackupStoreRepositoryWhereInput.


        :param update_timestamp_starts_with: The update_timestamp_starts_with of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type update_timestamp_starts_with: str
        """

        self._update_timestamp_starts_with = update_timestamp_starts_with

    @property
    def used_data_space(self):
        """Gets the used_data_space of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space

    @used_data_space.setter
    def used_data_space(self, used_data_space):
        """Sets the used_data_space of this BackupStoreRepositoryWhereInput.


        :param used_data_space: The used_data_space of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space: int
        """

        self._used_data_space = used_data_space

    @property
    def used_data_space_gt(self):
        """Gets the used_data_space_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_gt

    @used_data_space_gt.setter
    def used_data_space_gt(self, used_data_space_gt):
        """Sets the used_data_space_gt of this BackupStoreRepositoryWhereInput.


        :param used_data_space_gt: The used_data_space_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_gt: int
        """

        self._used_data_space_gt = used_data_space_gt

    @property
    def used_data_space_gte(self):
        """Gets the used_data_space_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_gte

    @used_data_space_gte.setter
    def used_data_space_gte(self, used_data_space_gte):
        """Sets the used_data_space_gte of this BackupStoreRepositoryWhereInput.


        :param used_data_space_gte: The used_data_space_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_gte: int
        """

        self._used_data_space_gte = used_data_space_gte

    @property
    def used_data_space_in(self):
        """Gets the used_data_space_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_data_space_in

    @used_data_space_in.setter
    def used_data_space_in(self, used_data_space_in):
        """Sets the used_data_space_in of this BackupStoreRepositoryWhereInput.


        :param used_data_space_in: The used_data_space_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_in: list[int]
        """

        self._used_data_space_in = used_data_space_in

    @property
    def used_data_space_lt(self):
        """Gets the used_data_space_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_lt

    @used_data_space_lt.setter
    def used_data_space_lt(self, used_data_space_lt):
        """Sets the used_data_space_lt of this BackupStoreRepositoryWhereInput.


        :param used_data_space_lt: The used_data_space_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_lt: int
        """

        self._used_data_space_lt = used_data_space_lt

    @property
    def used_data_space_lte(self):
        """Gets the used_data_space_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_lte

    @used_data_space_lte.setter
    def used_data_space_lte(self, used_data_space_lte):
        """Sets the used_data_space_lte of this BackupStoreRepositoryWhereInput.


        :param used_data_space_lte: The used_data_space_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_lte: int
        """

        self._used_data_space_lte = used_data_space_lte

    @property
    def used_data_space_not(self):
        """Gets the used_data_space_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space_not

    @used_data_space_not.setter
    def used_data_space_not(self, used_data_space_not):
        """Sets the used_data_space_not of this BackupStoreRepositoryWhereInput.


        :param used_data_space_not: The used_data_space_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_not: int
        """

        self._used_data_space_not = used_data_space_not

    @property
    def used_data_space_not_in(self):
        """Gets the used_data_space_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._used_data_space_not_in

    @used_data_space_not_in.setter
    def used_data_space_not_in(self, used_data_space_not_in):
        """Sets the used_data_space_not_in of this BackupStoreRepositoryWhereInput.


        :param used_data_space_not_in: The used_data_space_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_not_in: list[int]
        """

        self._used_data_space_not_in = used_data_space_not_in

    @property
    def used_data_space_usage(self):
        """Gets the used_data_space_usage of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_usage of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_data_space_usage

    @used_data_space_usage.setter
    def used_data_space_usage(self, used_data_space_usage):
        """Sets the used_data_space_usage of this BackupStoreRepositoryWhereInput.


        :param used_data_space_usage: The used_data_space_usage of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_usage: float
        """

        self._used_data_space_usage = used_data_space_usage

    @property
    def used_data_space_usage_gt(self):
        """Gets the used_data_space_usage_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_usage_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_data_space_usage_gt

    @used_data_space_usage_gt.setter
    def used_data_space_usage_gt(self, used_data_space_usage_gt):
        """Sets the used_data_space_usage_gt of this BackupStoreRepositoryWhereInput.


        :param used_data_space_usage_gt: The used_data_space_usage_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_usage_gt: float
        """

        self._used_data_space_usage_gt = used_data_space_usage_gt

    @property
    def used_data_space_usage_gte(self):
        """Gets the used_data_space_usage_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_usage_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_data_space_usage_gte

    @used_data_space_usage_gte.setter
    def used_data_space_usage_gte(self, used_data_space_usage_gte):
        """Sets the used_data_space_usage_gte of this BackupStoreRepositoryWhereInput.


        :param used_data_space_usage_gte: The used_data_space_usage_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_usage_gte: float
        """

        self._used_data_space_usage_gte = used_data_space_usage_gte

    @property
    def used_data_space_usage_in(self):
        """Gets the used_data_space_usage_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_usage_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._used_data_space_usage_in

    @used_data_space_usage_in.setter
    def used_data_space_usage_in(self, used_data_space_usage_in):
        """Sets the used_data_space_usage_in of this BackupStoreRepositoryWhereInput.


        :param used_data_space_usage_in: The used_data_space_usage_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_usage_in: list[float]
        """

        self._used_data_space_usage_in = used_data_space_usage_in

    @property
    def used_data_space_usage_lt(self):
        """Gets the used_data_space_usage_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_usage_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_data_space_usage_lt

    @used_data_space_usage_lt.setter
    def used_data_space_usage_lt(self, used_data_space_usage_lt):
        """Sets the used_data_space_usage_lt of this BackupStoreRepositoryWhereInput.


        :param used_data_space_usage_lt: The used_data_space_usage_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_usage_lt: float
        """

        self._used_data_space_usage_lt = used_data_space_usage_lt

    @property
    def used_data_space_usage_lte(self):
        """Gets the used_data_space_usage_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_usage_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_data_space_usage_lte

    @used_data_space_usage_lte.setter
    def used_data_space_usage_lte(self, used_data_space_usage_lte):
        """Sets the used_data_space_usage_lte of this BackupStoreRepositoryWhereInput.


        :param used_data_space_usage_lte: The used_data_space_usage_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_usage_lte: float
        """

        self._used_data_space_usage_lte = used_data_space_usage_lte

    @property
    def used_data_space_usage_not(self):
        """Gets the used_data_space_usage_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_usage_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: float
        """
        return self._used_data_space_usage_not

    @used_data_space_usage_not.setter
    def used_data_space_usage_not(self, used_data_space_usage_not):
        """Sets the used_data_space_usage_not of this BackupStoreRepositoryWhereInput.


        :param used_data_space_usage_not: The used_data_space_usage_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_usage_not: float
        """

        self._used_data_space_usage_not = used_data_space_usage_not

    @property
    def used_data_space_usage_not_in(self):
        """Gets the used_data_space_usage_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The used_data_space_usage_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[float]
        """
        return self._used_data_space_usage_not_in

    @used_data_space_usage_not_in.setter
    def used_data_space_usage_not_in(self, used_data_space_usage_not_in):
        """Sets the used_data_space_usage_not_in of this BackupStoreRepositoryWhereInput.


        :param used_data_space_usage_not_in: The used_data_space_usage_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type used_data_space_usage_not_in: list[float]
        """

        self._used_data_space_usage_not_in = used_data_space_usage_not_in

    @property
    def valid_data_space(self):
        """Gets the valid_data_space of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The valid_data_space of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space

    @valid_data_space.setter
    def valid_data_space(self, valid_data_space):
        """Sets the valid_data_space of this BackupStoreRepositoryWhereInput.


        :param valid_data_space: The valid_data_space of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type valid_data_space: int
        """

        self._valid_data_space = valid_data_space

    @property
    def valid_data_space_gt(self):
        """Gets the valid_data_space_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The valid_data_space_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space_gt

    @valid_data_space_gt.setter
    def valid_data_space_gt(self, valid_data_space_gt):
        """Sets the valid_data_space_gt of this BackupStoreRepositoryWhereInput.


        :param valid_data_space_gt: The valid_data_space_gt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type valid_data_space_gt: int
        """

        self._valid_data_space_gt = valid_data_space_gt

    @property
    def valid_data_space_gte(self):
        """Gets the valid_data_space_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The valid_data_space_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space_gte

    @valid_data_space_gte.setter
    def valid_data_space_gte(self, valid_data_space_gte):
        """Sets the valid_data_space_gte of this BackupStoreRepositoryWhereInput.


        :param valid_data_space_gte: The valid_data_space_gte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type valid_data_space_gte: int
        """

        self._valid_data_space_gte = valid_data_space_gte

    @property
    def valid_data_space_in(self):
        """Gets the valid_data_space_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The valid_data_space_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_data_space_in

    @valid_data_space_in.setter
    def valid_data_space_in(self, valid_data_space_in):
        """Sets the valid_data_space_in of this BackupStoreRepositoryWhereInput.


        :param valid_data_space_in: The valid_data_space_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type valid_data_space_in: list[int]
        """

        self._valid_data_space_in = valid_data_space_in

    @property
    def valid_data_space_lt(self):
        """Gets the valid_data_space_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The valid_data_space_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space_lt

    @valid_data_space_lt.setter
    def valid_data_space_lt(self, valid_data_space_lt):
        """Sets the valid_data_space_lt of this BackupStoreRepositoryWhereInput.


        :param valid_data_space_lt: The valid_data_space_lt of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type valid_data_space_lt: int
        """

        self._valid_data_space_lt = valid_data_space_lt

    @property
    def valid_data_space_lte(self):
        """Gets the valid_data_space_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The valid_data_space_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space_lte

    @valid_data_space_lte.setter
    def valid_data_space_lte(self, valid_data_space_lte):
        """Sets the valid_data_space_lte of this BackupStoreRepositoryWhereInput.


        :param valid_data_space_lte: The valid_data_space_lte of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type valid_data_space_lte: int
        """

        self._valid_data_space_lte = valid_data_space_lte

    @property
    def valid_data_space_not(self):
        """Gets the valid_data_space_not of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The valid_data_space_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space_not

    @valid_data_space_not.setter
    def valid_data_space_not(self, valid_data_space_not):
        """Sets the valid_data_space_not of this BackupStoreRepositoryWhereInput.


        :param valid_data_space_not: The valid_data_space_not of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type valid_data_space_not: int
        """

        self._valid_data_space_not = valid_data_space_not

    @property
    def valid_data_space_not_in(self):
        """Gets the valid_data_space_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501


        :return: The valid_data_space_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._valid_data_space_not_in

    @valid_data_space_not_in.setter
    def valid_data_space_not_in(self, valid_data_space_not_in):
        """Sets the valid_data_space_not_in of this BackupStoreRepositoryWhereInput.


        :param valid_data_space_not_in: The valid_data_space_not_in of this BackupStoreRepositoryWhereInput.  # noqa: E501
        :type valid_data_space_not_in: list[int]
        """

        self._valid_data_space_not_in = valid_data_space_not_in

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupStoreRepositoryWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupStoreRepositoryWhereInput):
            return True

        return self.to_dict() != other.to_dict()
