# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BackupTargetExecutionWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[BackupTargetExecutionWhereInput]',
        '_not': 'list[BackupTargetExecutionWhereInput]',
        '_or': 'list[BackupTargetExecutionWhereInput]',
        'backup_group': 'str',
        'backup_group_contains': 'str',
        'backup_group_ends_with': 'str',
        'backup_group_gt': 'str',
        'backup_group_gte': 'str',
        'backup_group_in': 'list[str]',
        'backup_group_lt': 'str',
        'backup_group_lte': 'str',
        'backup_group_not': 'str',
        'backup_group_not_contains': 'str',
        'backup_group_not_ends_with': 'str',
        'backup_group_not_in': 'list[str]',
        'backup_group_not_starts_with': 'str',
        'backup_group_starts_with': 'str',
        'backup_plan_execution': 'BackupPlanExecutionWhereInput',
        'backup_restore_point': 'BackupRestorePointWhereInput',
        'cluster_local_id': 'str',
        'cluster_local_id_contains': 'str',
        'cluster_local_id_ends_with': 'str',
        'cluster_local_id_gt': 'str',
        'cluster_local_id_gte': 'str',
        'cluster_local_id_in': 'list[str]',
        'cluster_local_id_lt': 'str',
        'cluster_local_id_lte': 'str',
        'cluster_local_id_not': 'str',
        'cluster_local_id_not_contains': 'str',
        'cluster_local_id_not_ends_with': 'str',
        'cluster_local_id_not_in': 'list[str]',
        'cluster_local_id_not_starts_with': 'str',
        'cluster_local_id_starts_with': 'str',
        'duration': 'int',
        'duration_gt': 'int',
        'duration_gte': 'int',
        'duration_in': 'list[int]',
        'duration_lt': 'int',
        'duration_lte': 'int',
        'duration_not': 'int',
        'duration_not_in': 'list[int]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'executed_at': 'str',
        'executed_at_gt': 'str',
        'executed_at_gte': 'str',
        'executed_at_in': 'list[str]',
        'executed_at_lt': 'str',
        'executed_at_lte': 'str',
        'executed_at_not': 'str',
        'executed_at_not_in': 'list[str]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'local_id': 'str',
        'local_id_contains': 'str',
        'local_id_ends_with': 'str',
        'local_id_gt': 'str',
        'local_id_gte': 'str',
        'local_id_in': 'list[str]',
        'local_id_lt': 'str',
        'local_id_lte': 'str',
        'local_id_not': 'str',
        'local_id_not_contains': 'str',
        'local_id_not_ends_with': 'str',
        'local_id_not_in': 'list[str]',
        'local_id_not_starts_with': 'str',
        'local_id_starts_with': 'str',
        'parent_backup': 'str',
        'parent_backup_contains': 'str',
        'parent_backup_ends_with': 'str',
        'parent_backup_gt': 'str',
        'parent_backup_gte': 'str',
        'parent_backup_in': 'list[str]',
        'parent_backup_lt': 'str',
        'parent_backup_lte': 'str',
        'parent_backup_not': 'str',
        'parent_backup_not_contains': 'str',
        'parent_backup_not_ends_with': 'str',
        'parent_backup_not_in': 'list[str]',
        'parent_backup_not_starts_with': 'str',
        'parent_backup_starts_with': 'str',
        'read_bytes': 'int',
        'read_bytes_gt': 'int',
        'read_bytes_gte': 'int',
        'read_bytes_in': 'list[int]',
        'read_bytes_lt': 'int',
        'read_bytes_lte': 'int',
        'read_bytes_not': 'int',
        'read_bytes_not_in': 'list[int]',
        'retry_times': 'int',
        'retry_times_gt': 'int',
        'retry_times_gte': 'int',
        'retry_times_in': 'list[int]',
        'retry_times_lt': 'int',
        'retry_times_lte': 'int',
        'retry_times_not': 'int',
        'retry_times_not_in': 'list[int]',
        'status': 'BackupExecutionStatus',
        'status_in': 'list[BackupExecutionStatus]',
        'status_not': 'BackupExecutionStatus',
        'status_not_in': 'list[BackupExecutionStatus]',
        'total_bytes': 'int',
        'total_bytes_gt': 'int',
        'total_bytes_gte': 'int',
        'total_bytes_in': 'list[int]',
        'total_bytes_lt': 'int',
        'total_bytes_lte': 'int',
        'total_bytes_not': 'int',
        'total_bytes_not_in': 'list[int]',
        'type': 'BackupExecutionType',
        'type_in': 'list[BackupExecutionType]',
        'type_not': 'BackupExecutionType',
        'type_not_in': 'list[BackupExecutionType]',
        'vm': 'VmWhereInput',
        'vm_local_id': 'str',
        'vm_local_id_contains': 'str',
        'vm_local_id_ends_with': 'str',
        'vm_local_id_gt': 'str',
        'vm_local_id_gte': 'str',
        'vm_local_id_in': 'list[str]',
        'vm_local_id_lt': 'str',
        'vm_local_id_lte': 'str',
        'vm_local_id_not': 'str',
        'vm_local_id_not_contains': 'str',
        'vm_local_id_not_ends_with': 'str',
        'vm_local_id_not_in': 'list[str]',
        'vm_local_id_not_starts_with': 'str',
        'vm_local_id_starts_with': 'str',
        'vm_name': 'str',
        'vm_name_contains': 'str',
        'vm_name_ends_with': 'str',
        'vm_name_gt': 'str',
        'vm_name_gte': 'str',
        'vm_name_in': 'list[str]',
        'vm_name_lt': 'str',
        'vm_name_lte': 'str',
        'vm_name_not': 'str',
        'vm_name_not_contains': 'str',
        'vm_name_not_ends_with': 'str',
        'vm_name_not_in': 'list[str]',
        'vm_name_not_starts_with': 'str',
        'vm_name_starts_with': 'str'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'backup_group': 'backup_group',
        'backup_group_contains': 'backup_group_contains',
        'backup_group_ends_with': 'backup_group_ends_with',
        'backup_group_gt': 'backup_group_gt',
        'backup_group_gte': 'backup_group_gte',
        'backup_group_in': 'backup_group_in',
        'backup_group_lt': 'backup_group_lt',
        'backup_group_lte': 'backup_group_lte',
        'backup_group_not': 'backup_group_not',
        'backup_group_not_contains': 'backup_group_not_contains',
        'backup_group_not_ends_with': 'backup_group_not_ends_with',
        'backup_group_not_in': 'backup_group_not_in',
        'backup_group_not_starts_with': 'backup_group_not_starts_with',
        'backup_group_starts_with': 'backup_group_starts_with',
        'backup_plan_execution': 'backup_plan_execution',
        'backup_restore_point': 'backup_restore_point',
        'cluster_local_id': 'cluster_local_id',
        'cluster_local_id_contains': 'cluster_local_id_contains',
        'cluster_local_id_ends_with': 'cluster_local_id_ends_with',
        'cluster_local_id_gt': 'cluster_local_id_gt',
        'cluster_local_id_gte': 'cluster_local_id_gte',
        'cluster_local_id_in': 'cluster_local_id_in',
        'cluster_local_id_lt': 'cluster_local_id_lt',
        'cluster_local_id_lte': 'cluster_local_id_lte',
        'cluster_local_id_not': 'cluster_local_id_not',
        'cluster_local_id_not_contains': 'cluster_local_id_not_contains',
        'cluster_local_id_not_ends_with': 'cluster_local_id_not_ends_with',
        'cluster_local_id_not_in': 'cluster_local_id_not_in',
        'cluster_local_id_not_starts_with': 'cluster_local_id_not_starts_with',
        'cluster_local_id_starts_with': 'cluster_local_id_starts_with',
        'duration': 'duration',
        'duration_gt': 'duration_gt',
        'duration_gte': 'duration_gte',
        'duration_in': 'duration_in',
        'duration_lt': 'duration_lt',
        'duration_lte': 'duration_lte',
        'duration_not': 'duration_not',
        'duration_not_in': 'duration_not_in',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'executed_at': 'executed_at',
        'executed_at_gt': 'executed_at_gt',
        'executed_at_gte': 'executed_at_gte',
        'executed_at_in': 'executed_at_in',
        'executed_at_lt': 'executed_at_lt',
        'executed_at_lte': 'executed_at_lte',
        'executed_at_not': 'executed_at_not',
        'executed_at_not_in': 'executed_at_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'local_id': 'local_id',
        'local_id_contains': 'local_id_contains',
        'local_id_ends_with': 'local_id_ends_with',
        'local_id_gt': 'local_id_gt',
        'local_id_gte': 'local_id_gte',
        'local_id_in': 'local_id_in',
        'local_id_lt': 'local_id_lt',
        'local_id_lte': 'local_id_lte',
        'local_id_not': 'local_id_not',
        'local_id_not_contains': 'local_id_not_contains',
        'local_id_not_ends_with': 'local_id_not_ends_with',
        'local_id_not_in': 'local_id_not_in',
        'local_id_not_starts_with': 'local_id_not_starts_with',
        'local_id_starts_with': 'local_id_starts_with',
        'parent_backup': 'parent_backup',
        'parent_backup_contains': 'parent_backup_contains',
        'parent_backup_ends_with': 'parent_backup_ends_with',
        'parent_backup_gt': 'parent_backup_gt',
        'parent_backup_gte': 'parent_backup_gte',
        'parent_backup_in': 'parent_backup_in',
        'parent_backup_lt': 'parent_backup_lt',
        'parent_backup_lte': 'parent_backup_lte',
        'parent_backup_not': 'parent_backup_not',
        'parent_backup_not_contains': 'parent_backup_not_contains',
        'parent_backup_not_ends_with': 'parent_backup_not_ends_with',
        'parent_backup_not_in': 'parent_backup_not_in',
        'parent_backup_not_starts_with': 'parent_backup_not_starts_with',
        'parent_backup_starts_with': 'parent_backup_starts_with',
        'read_bytes': 'read_bytes',
        'read_bytes_gt': 'read_bytes_gt',
        'read_bytes_gte': 'read_bytes_gte',
        'read_bytes_in': 'read_bytes_in',
        'read_bytes_lt': 'read_bytes_lt',
        'read_bytes_lte': 'read_bytes_lte',
        'read_bytes_not': 'read_bytes_not',
        'read_bytes_not_in': 'read_bytes_not_in',
        'retry_times': 'retry_times',
        'retry_times_gt': 'retry_times_gt',
        'retry_times_gte': 'retry_times_gte',
        'retry_times_in': 'retry_times_in',
        'retry_times_lt': 'retry_times_lt',
        'retry_times_lte': 'retry_times_lte',
        'retry_times_not': 'retry_times_not',
        'retry_times_not_in': 'retry_times_not_in',
        'status': 'status',
        'status_in': 'status_in',
        'status_not': 'status_not',
        'status_not_in': 'status_not_in',
        'total_bytes': 'total_bytes',
        'total_bytes_gt': 'total_bytes_gt',
        'total_bytes_gte': 'total_bytes_gte',
        'total_bytes_in': 'total_bytes_in',
        'total_bytes_lt': 'total_bytes_lt',
        'total_bytes_lte': 'total_bytes_lte',
        'total_bytes_not': 'total_bytes_not',
        'total_bytes_not_in': 'total_bytes_not_in',
        'type': 'type',
        'type_in': 'type_in',
        'type_not': 'type_not',
        'type_not_in': 'type_not_in',
        'vm': 'vm',
        'vm_local_id': 'vm_local_id',
        'vm_local_id_contains': 'vm_local_id_contains',
        'vm_local_id_ends_with': 'vm_local_id_ends_with',
        'vm_local_id_gt': 'vm_local_id_gt',
        'vm_local_id_gte': 'vm_local_id_gte',
        'vm_local_id_in': 'vm_local_id_in',
        'vm_local_id_lt': 'vm_local_id_lt',
        'vm_local_id_lte': 'vm_local_id_lte',
        'vm_local_id_not': 'vm_local_id_not',
        'vm_local_id_not_contains': 'vm_local_id_not_contains',
        'vm_local_id_not_ends_with': 'vm_local_id_not_ends_with',
        'vm_local_id_not_in': 'vm_local_id_not_in',
        'vm_local_id_not_starts_with': 'vm_local_id_not_starts_with',
        'vm_local_id_starts_with': 'vm_local_id_starts_with',
        'vm_name': 'vm_name',
        'vm_name_contains': 'vm_name_contains',
        'vm_name_ends_with': 'vm_name_ends_with',
        'vm_name_gt': 'vm_name_gt',
        'vm_name_gte': 'vm_name_gte',
        'vm_name_in': 'vm_name_in',
        'vm_name_lt': 'vm_name_lt',
        'vm_name_lte': 'vm_name_lte',
        'vm_name_not': 'vm_name_not',
        'vm_name_not_contains': 'vm_name_not_contains',
        'vm_name_not_ends_with': 'vm_name_not_ends_with',
        'vm_name_not_in': 'vm_name_not_in',
        'vm_name_not_starts_with': 'vm_name_not_starts_with',
        'vm_name_starts_with': 'vm_name_starts_with'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BackupTargetExecutionWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._backup_group = None
        self._backup_group_contains = None
        self._backup_group_ends_with = None
        self._backup_group_gt = None
        self._backup_group_gte = None
        self._backup_group_in = None
        self._backup_group_lt = None
        self._backup_group_lte = None
        self._backup_group_not = None
        self._backup_group_not_contains = None
        self._backup_group_not_ends_with = None
        self._backup_group_not_in = None
        self._backup_group_not_starts_with = None
        self._backup_group_starts_with = None
        self._backup_plan_execution = None
        self._backup_restore_point = None
        self._cluster_local_id = None
        self._cluster_local_id_contains = None
        self._cluster_local_id_ends_with = None
        self._cluster_local_id_gt = None
        self._cluster_local_id_gte = None
        self._cluster_local_id_in = None
        self._cluster_local_id_lt = None
        self._cluster_local_id_lte = None
        self._cluster_local_id_not = None
        self._cluster_local_id_not_contains = None
        self._cluster_local_id_not_ends_with = None
        self._cluster_local_id_not_in = None
        self._cluster_local_id_not_starts_with = None
        self._cluster_local_id_starts_with = None
        self._duration = None
        self._duration_gt = None
        self._duration_gte = None
        self._duration_in = None
        self._duration_lt = None
        self._duration_lte = None
        self._duration_not = None
        self._duration_not_in = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._executed_at = None
        self._executed_at_gt = None
        self._executed_at_gte = None
        self._executed_at_in = None
        self._executed_at_lt = None
        self._executed_at_lte = None
        self._executed_at_not = None
        self._executed_at_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._local_id = None
        self._local_id_contains = None
        self._local_id_ends_with = None
        self._local_id_gt = None
        self._local_id_gte = None
        self._local_id_in = None
        self._local_id_lt = None
        self._local_id_lte = None
        self._local_id_not = None
        self._local_id_not_contains = None
        self._local_id_not_ends_with = None
        self._local_id_not_in = None
        self._local_id_not_starts_with = None
        self._local_id_starts_with = None
        self._parent_backup = None
        self._parent_backup_contains = None
        self._parent_backup_ends_with = None
        self._parent_backup_gt = None
        self._parent_backup_gte = None
        self._parent_backup_in = None
        self._parent_backup_lt = None
        self._parent_backup_lte = None
        self._parent_backup_not = None
        self._parent_backup_not_contains = None
        self._parent_backup_not_ends_with = None
        self._parent_backup_not_in = None
        self._parent_backup_not_starts_with = None
        self._parent_backup_starts_with = None
        self._read_bytes = None
        self._read_bytes_gt = None
        self._read_bytes_gte = None
        self._read_bytes_in = None
        self._read_bytes_lt = None
        self._read_bytes_lte = None
        self._read_bytes_not = None
        self._read_bytes_not_in = None
        self._retry_times = None
        self._retry_times_gt = None
        self._retry_times_gte = None
        self._retry_times_in = None
        self._retry_times_lt = None
        self._retry_times_lte = None
        self._retry_times_not = None
        self._retry_times_not_in = None
        self._status = None
        self._status_in = None
        self._status_not = None
        self._status_not_in = None
        self._total_bytes = None
        self._total_bytes_gt = None
        self._total_bytes_gte = None
        self._total_bytes_in = None
        self._total_bytes_lt = None
        self._total_bytes_lte = None
        self._total_bytes_not = None
        self._total_bytes_not_in = None
        self._type = None
        self._type_in = None
        self._type_not = None
        self._type_not_in = None
        self._vm = None
        self._vm_local_id = None
        self._vm_local_id_contains = None
        self._vm_local_id_ends_with = None
        self._vm_local_id_gt = None
        self._vm_local_id_gte = None
        self._vm_local_id_in = None
        self._vm_local_id_lt = None
        self._vm_local_id_lte = None
        self._vm_local_id_not = None
        self._vm_local_id_not_contains = None
        self._vm_local_id_not_ends_with = None
        self._vm_local_id_not_in = None
        self._vm_local_id_not_starts_with = None
        self._vm_local_id_starts_with = None
        self._vm_name = None
        self._vm_name_contains = None
        self._vm_name_ends_with = None
        self._vm_name_gt = None
        self._vm_name_gte = None
        self._vm_name_in = None
        self._vm_name_lt = None
        self._vm_name_lte = None
        self._vm_name_not = None
        self._vm_name_not_contains = None
        self._vm_name_not_ends_with = None
        self._vm_name_not_in = None
        self._vm_name_not_starts_with = None
        self._vm_name_starts_with = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.backup_group = kwargs.get("backup_group", None)
        self.backup_group_contains = kwargs.get("backup_group_contains", None)
        self.backup_group_ends_with = kwargs.get("backup_group_ends_with", None)
        self.backup_group_gt = kwargs.get("backup_group_gt", None)
        self.backup_group_gte = kwargs.get("backup_group_gte", None)
        self.backup_group_in = kwargs.get("backup_group_in", None)
        self.backup_group_lt = kwargs.get("backup_group_lt", None)
        self.backup_group_lte = kwargs.get("backup_group_lte", None)
        self.backup_group_not = kwargs.get("backup_group_not", None)
        self.backup_group_not_contains = kwargs.get("backup_group_not_contains", None)
        self.backup_group_not_ends_with = kwargs.get("backup_group_not_ends_with", None)
        self.backup_group_not_in = kwargs.get("backup_group_not_in", None)
        self.backup_group_not_starts_with = kwargs.get("backup_group_not_starts_with", None)
        self.backup_group_starts_with = kwargs.get("backup_group_starts_with", None)
        self.backup_plan_execution = kwargs.get("backup_plan_execution", None)
        self.backup_restore_point = kwargs.get("backup_restore_point", None)
        self.cluster_local_id = kwargs.get("cluster_local_id", None)
        self.cluster_local_id_contains = kwargs.get("cluster_local_id_contains", None)
        self.cluster_local_id_ends_with = kwargs.get("cluster_local_id_ends_with", None)
        self.cluster_local_id_gt = kwargs.get("cluster_local_id_gt", None)
        self.cluster_local_id_gte = kwargs.get("cluster_local_id_gte", None)
        self.cluster_local_id_in = kwargs.get("cluster_local_id_in", None)
        self.cluster_local_id_lt = kwargs.get("cluster_local_id_lt", None)
        self.cluster_local_id_lte = kwargs.get("cluster_local_id_lte", None)
        self.cluster_local_id_not = kwargs.get("cluster_local_id_not", None)
        self.cluster_local_id_not_contains = kwargs.get("cluster_local_id_not_contains", None)
        self.cluster_local_id_not_ends_with = kwargs.get("cluster_local_id_not_ends_with", None)
        self.cluster_local_id_not_in = kwargs.get("cluster_local_id_not_in", None)
        self.cluster_local_id_not_starts_with = kwargs.get("cluster_local_id_not_starts_with", None)
        self.cluster_local_id_starts_with = kwargs.get("cluster_local_id_starts_with", None)
        self.duration = kwargs.get("duration", None)
        self.duration_gt = kwargs.get("duration_gt", None)
        self.duration_gte = kwargs.get("duration_gte", None)
        self.duration_in = kwargs.get("duration_in", None)
        self.duration_lt = kwargs.get("duration_lt", None)
        self.duration_lte = kwargs.get("duration_lte", None)
        self.duration_not = kwargs.get("duration_not", None)
        self.duration_not_in = kwargs.get("duration_not_in", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.executed_at = kwargs.get("executed_at", None)
        self.executed_at_gt = kwargs.get("executed_at_gt", None)
        self.executed_at_gte = kwargs.get("executed_at_gte", None)
        self.executed_at_in = kwargs.get("executed_at_in", None)
        self.executed_at_lt = kwargs.get("executed_at_lt", None)
        self.executed_at_lte = kwargs.get("executed_at_lte", None)
        self.executed_at_not = kwargs.get("executed_at_not", None)
        self.executed_at_not_in = kwargs.get("executed_at_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.local_id = kwargs.get("local_id", None)
        self.local_id_contains = kwargs.get("local_id_contains", None)
        self.local_id_ends_with = kwargs.get("local_id_ends_with", None)
        self.local_id_gt = kwargs.get("local_id_gt", None)
        self.local_id_gte = kwargs.get("local_id_gte", None)
        self.local_id_in = kwargs.get("local_id_in", None)
        self.local_id_lt = kwargs.get("local_id_lt", None)
        self.local_id_lte = kwargs.get("local_id_lte", None)
        self.local_id_not = kwargs.get("local_id_not", None)
        self.local_id_not_contains = kwargs.get("local_id_not_contains", None)
        self.local_id_not_ends_with = kwargs.get("local_id_not_ends_with", None)
        self.local_id_not_in = kwargs.get("local_id_not_in", None)
        self.local_id_not_starts_with = kwargs.get("local_id_not_starts_with", None)
        self.local_id_starts_with = kwargs.get("local_id_starts_with", None)
        self.parent_backup = kwargs.get("parent_backup", None)
        self.parent_backup_contains = kwargs.get("parent_backup_contains", None)
        self.parent_backup_ends_with = kwargs.get("parent_backup_ends_with", None)
        self.parent_backup_gt = kwargs.get("parent_backup_gt", None)
        self.parent_backup_gte = kwargs.get("parent_backup_gte", None)
        self.parent_backup_in = kwargs.get("parent_backup_in", None)
        self.parent_backup_lt = kwargs.get("parent_backup_lt", None)
        self.parent_backup_lte = kwargs.get("parent_backup_lte", None)
        self.parent_backup_not = kwargs.get("parent_backup_not", None)
        self.parent_backup_not_contains = kwargs.get("parent_backup_not_contains", None)
        self.parent_backup_not_ends_with = kwargs.get("parent_backup_not_ends_with", None)
        self.parent_backup_not_in = kwargs.get("parent_backup_not_in", None)
        self.parent_backup_not_starts_with = kwargs.get("parent_backup_not_starts_with", None)
        self.parent_backup_starts_with = kwargs.get("parent_backup_starts_with", None)
        self.read_bytes = kwargs.get("read_bytes", None)
        self.read_bytes_gt = kwargs.get("read_bytes_gt", None)
        self.read_bytes_gte = kwargs.get("read_bytes_gte", None)
        self.read_bytes_in = kwargs.get("read_bytes_in", None)
        self.read_bytes_lt = kwargs.get("read_bytes_lt", None)
        self.read_bytes_lte = kwargs.get("read_bytes_lte", None)
        self.read_bytes_not = kwargs.get("read_bytes_not", None)
        self.read_bytes_not_in = kwargs.get("read_bytes_not_in", None)
        self.retry_times = kwargs.get("retry_times", None)
        self.retry_times_gt = kwargs.get("retry_times_gt", None)
        self.retry_times_gte = kwargs.get("retry_times_gte", None)
        self.retry_times_in = kwargs.get("retry_times_in", None)
        self.retry_times_lt = kwargs.get("retry_times_lt", None)
        self.retry_times_lte = kwargs.get("retry_times_lte", None)
        self.retry_times_not = kwargs.get("retry_times_not", None)
        self.retry_times_not_in = kwargs.get("retry_times_not_in", None)
        self.status = kwargs.get("status", None)
        self.status_in = kwargs.get("status_in", None)
        self.status_not = kwargs.get("status_not", None)
        self.status_not_in = kwargs.get("status_not_in", None)
        self.total_bytes = kwargs.get("total_bytes", None)
        self.total_bytes_gt = kwargs.get("total_bytes_gt", None)
        self.total_bytes_gte = kwargs.get("total_bytes_gte", None)
        self.total_bytes_in = kwargs.get("total_bytes_in", None)
        self.total_bytes_lt = kwargs.get("total_bytes_lt", None)
        self.total_bytes_lte = kwargs.get("total_bytes_lte", None)
        self.total_bytes_not = kwargs.get("total_bytes_not", None)
        self.total_bytes_not_in = kwargs.get("total_bytes_not_in", None)
        self.type = kwargs.get("type", None)
        self.type_in = kwargs.get("type_in", None)
        self.type_not = kwargs.get("type_not", None)
        self.type_not_in = kwargs.get("type_not_in", None)
        self.vm = kwargs.get("vm", None)
        self.vm_local_id = kwargs.get("vm_local_id", None)
        self.vm_local_id_contains = kwargs.get("vm_local_id_contains", None)
        self.vm_local_id_ends_with = kwargs.get("vm_local_id_ends_with", None)
        self.vm_local_id_gt = kwargs.get("vm_local_id_gt", None)
        self.vm_local_id_gte = kwargs.get("vm_local_id_gte", None)
        self.vm_local_id_in = kwargs.get("vm_local_id_in", None)
        self.vm_local_id_lt = kwargs.get("vm_local_id_lt", None)
        self.vm_local_id_lte = kwargs.get("vm_local_id_lte", None)
        self.vm_local_id_not = kwargs.get("vm_local_id_not", None)
        self.vm_local_id_not_contains = kwargs.get("vm_local_id_not_contains", None)
        self.vm_local_id_not_ends_with = kwargs.get("vm_local_id_not_ends_with", None)
        self.vm_local_id_not_in = kwargs.get("vm_local_id_not_in", None)
        self.vm_local_id_not_starts_with = kwargs.get("vm_local_id_not_starts_with", None)
        self.vm_local_id_starts_with = kwargs.get("vm_local_id_starts_with", None)
        self.vm_name = kwargs.get("vm_name", None)
        self.vm_name_contains = kwargs.get("vm_name_contains", None)
        self.vm_name_ends_with = kwargs.get("vm_name_ends_with", None)
        self.vm_name_gt = kwargs.get("vm_name_gt", None)
        self.vm_name_gte = kwargs.get("vm_name_gte", None)
        self.vm_name_in = kwargs.get("vm_name_in", None)
        self.vm_name_lt = kwargs.get("vm_name_lt", None)
        self.vm_name_lte = kwargs.get("vm_name_lte", None)
        self.vm_name_not = kwargs.get("vm_name_not", None)
        self.vm_name_not_contains = kwargs.get("vm_name_not_contains", None)
        self.vm_name_not_ends_with = kwargs.get("vm_name_not_ends_with", None)
        self.vm_name_not_in = kwargs.get("vm_name_not_in", None)
        self.vm_name_not_starts_with = kwargs.get("vm_name_not_starts_with", None)
        self.vm_name_starts_with = kwargs.get("vm_name_starts_with", None)

    @property
    def _and(self):
        """Gets the _and of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The _and of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupTargetExecutionWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this BackupTargetExecutionWhereInput.


        :param _and: The _and of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type _and: list[BackupTargetExecutionWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The _not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupTargetExecutionWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this BackupTargetExecutionWhereInput.


        :param _not: The _not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type _not: list[BackupTargetExecutionWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The _or of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupTargetExecutionWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this BackupTargetExecutionWhereInput.


        :param _or: The _or of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type _or: list[BackupTargetExecutionWhereInput]
        """

        self.__or = _or

    @property
    def backup_group(self):
        """Gets the backup_group of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group

    @backup_group.setter
    def backup_group(self, backup_group):
        """Sets the backup_group of this BackupTargetExecutionWhereInput.


        :param backup_group: The backup_group of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group: str
        """

        self._backup_group = backup_group

    @property
    def backup_group_contains(self):
        """Gets the backup_group_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group_contains

    @backup_group_contains.setter
    def backup_group_contains(self, backup_group_contains):
        """Sets the backup_group_contains of this BackupTargetExecutionWhereInput.


        :param backup_group_contains: The backup_group_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_contains: str
        """

        self._backup_group_contains = backup_group_contains

    @property
    def backup_group_ends_with(self):
        """Gets the backup_group_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group_ends_with

    @backup_group_ends_with.setter
    def backup_group_ends_with(self, backup_group_ends_with):
        """Sets the backup_group_ends_with of this BackupTargetExecutionWhereInput.


        :param backup_group_ends_with: The backup_group_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_ends_with: str
        """

        self._backup_group_ends_with = backup_group_ends_with

    @property
    def backup_group_gt(self):
        """Gets the backup_group_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group_gt

    @backup_group_gt.setter
    def backup_group_gt(self, backup_group_gt):
        """Sets the backup_group_gt of this BackupTargetExecutionWhereInput.


        :param backup_group_gt: The backup_group_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_gt: str
        """

        self._backup_group_gt = backup_group_gt

    @property
    def backup_group_gte(self):
        """Gets the backup_group_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group_gte

    @backup_group_gte.setter
    def backup_group_gte(self, backup_group_gte):
        """Sets the backup_group_gte of this BackupTargetExecutionWhereInput.


        :param backup_group_gte: The backup_group_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_gte: str
        """

        self._backup_group_gte = backup_group_gte

    @property
    def backup_group_in(self):
        """Gets the backup_group_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._backup_group_in

    @backup_group_in.setter
    def backup_group_in(self, backup_group_in):
        """Sets the backup_group_in of this BackupTargetExecutionWhereInput.


        :param backup_group_in: The backup_group_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_in: list[str]
        """

        self._backup_group_in = backup_group_in

    @property
    def backup_group_lt(self):
        """Gets the backup_group_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group_lt

    @backup_group_lt.setter
    def backup_group_lt(self, backup_group_lt):
        """Sets the backup_group_lt of this BackupTargetExecutionWhereInput.


        :param backup_group_lt: The backup_group_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_lt: str
        """

        self._backup_group_lt = backup_group_lt

    @property
    def backup_group_lte(self):
        """Gets the backup_group_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group_lte

    @backup_group_lte.setter
    def backup_group_lte(self, backup_group_lte):
        """Sets the backup_group_lte of this BackupTargetExecutionWhereInput.


        :param backup_group_lte: The backup_group_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_lte: str
        """

        self._backup_group_lte = backup_group_lte

    @property
    def backup_group_not(self):
        """Gets the backup_group_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group_not

    @backup_group_not.setter
    def backup_group_not(self, backup_group_not):
        """Sets the backup_group_not of this BackupTargetExecutionWhereInput.


        :param backup_group_not: The backup_group_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_not: str
        """

        self._backup_group_not = backup_group_not

    @property
    def backup_group_not_contains(self):
        """Gets the backup_group_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group_not_contains

    @backup_group_not_contains.setter
    def backup_group_not_contains(self, backup_group_not_contains):
        """Sets the backup_group_not_contains of this BackupTargetExecutionWhereInput.


        :param backup_group_not_contains: The backup_group_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_not_contains: str
        """

        self._backup_group_not_contains = backup_group_not_contains

    @property
    def backup_group_not_ends_with(self):
        """Gets the backup_group_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group_not_ends_with

    @backup_group_not_ends_with.setter
    def backup_group_not_ends_with(self, backup_group_not_ends_with):
        """Sets the backup_group_not_ends_with of this BackupTargetExecutionWhereInput.


        :param backup_group_not_ends_with: The backup_group_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_not_ends_with: str
        """

        self._backup_group_not_ends_with = backup_group_not_ends_with

    @property
    def backup_group_not_in(self):
        """Gets the backup_group_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._backup_group_not_in

    @backup_group_not_in.setter
    def backup_group_not_in(self, backup_group_not_in):
        """Sets the backup_group_not_in of this BackupTargetExecutionWhereInput.


        :param backup_group_not_in: The backup_group_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_not_in: list[str]
        """

        self._backup_group_not_in = backup_group_not_in

    @property
    def backup_group_not_starts_with(self):
        """Gets the backup_group_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group_not_starts_with

    @backup_group_not_starts_with.setter
    def backup_group_not_starts_with(self, backup_group_not_starts_with):
        """Sets the backup_group_not_starts_with of this BackupTargetExecutionWhereInput.


        :param backup_group_not_starts_with: The backup_group_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_not_starts_with: str
        """

        self._backup_group_not_starts_with = backup_group_not_starts_with

    @property
    def backup_group_starts_with(self):
        """Gets the backup_group_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_group_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._backup_group_starts_with

    @backup_group_starts_with.setter
    def backup_group_starts_with(self, backup_group_starts_with):
        """Sets the backup_group_starts_with of this BackupTargetExecutionWhereInput.


        :param backup_group_starts_with: The backup_group_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_group_starts_with: str
        """

        self._backup_group_starts_with = backup_group_starts_with

    @property
    def backup_plan_execution(self):
        """Gets the backup_plan_execution of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_plan_execution of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: BackupPlanExecutionWhereInput
        """
        return self._backup_plan_execution

    @backup_plan_execution.setter
    def backup_plan_execution(self, backup_plan_execution):
        """Sets the backup_plan_execution of this BackupTargetExecutionWhereInput.


        :param backup_plan_execution: The backup_plan_execution of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_plan_execution: BackupPlanExecutionWhereInput
        """

        self._backup_plan_execution = backup_plan_execution

    @property
    def backup_restore_point(self):
        """Gets the backup_restore_point of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The backup_restore_point of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: BackupRestorePointWhereInput
        """
        return self._backup_restore_point

    @backup_restore_point.setter
    def backup_restore_point(self, backup_restore_point):
        """Sets the backup_restore_point of this BackupTargetExecutionWhereInput.


        :param backup_restore_point: The backup_restore_point of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type backup_restore_point: BackupRestorePointWhereInput
        """

        self._backup_restore_point = backup_restore_point

    @property
    def cluster_local_id(self):
        """Gets the cluster_local_id of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id

    @cluster_local_id.setter
    def cluster_local_id(self, cluster_local_id):
        """Sets the cluster_local_id of this BackupTargetExecutionWhereInput.


        :param cluster_local_id: The cluster_local_id of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id: str
        """

        self._cluster_local_id = cluster_local_id

    @property
    def cluster_local_id_contains(self):
        """Gets the cluster_local_id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_contains

    @cluster_local_id_contains.setter
    def cluster_local_id_contains(self, cluster_local_id_contains):
        """Sets the cluster_local_id_contains of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_contains: The cluster_local_id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_contains: str
        """

        self._cluster_local_id_contains = cluster_local_id_contains

    @property
    def cluster_local_id_ends_with(self):
        """Gets the cluster_local_id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_ends_with

    @cluster_local_id_ends_with.setter
    def cluster_local_id_ends_with(self, cluster_local_id_ends_with):
        """Sets the cluster_local_id_ends_with of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_ends_with: The cluster_local_id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_ends_with: str
        """

        self._cluster_local_id_ends_with = cluster_local_id_ends_with

    @property
    def cluster_local_id_gt(self):
        """Gets the cluster_local_id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_gt

    @cluster_local_id_gt.setter
    def cluster_local_id_gt(self, cluster_local_id_gt):
        """Sets the cluster_local_id_gt of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_gt: The cluster_local_id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_gt: str
        """

        self._cluster_local_id_gt = cluster_local_id_gt

    @property
    def cluster_local_id_gte(self):
        """Gets the cluster_local_id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_gte

    @cluster_local_id_gte.setter
    def cluster_local_id_gte(self, cluster_local_id_gte):
        """Sets the cluster_local_id_gte of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_gte: The cluster_local_id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_gte: str
        """

        self._cluster_local_id_gte = cluster_local_id_gte

    @property
    def cluster_local_id_in(self):
        """Gets the cluster_local_id_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cluster_local_id_in

    @cluster_local_id_in.setter
    def cluster_local_id_in(self, cluster_local_id_in):
        """Sets the cluster_local_id_in of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_in: The cluster_local_id_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_in: list[str]
        """

        self._cluster_local_id_in = cluster_local_id_in

    @property
    def cluster_local_id_lt(self):
        """Gets the cluster_local_id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_lt

    @cluster_local_id_lt.setter
    def cluster_local_id_lt(self, cluster_local_id_lt):
        """Sets the cluster_local_id_lt of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_lt: The cluster_local_id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_lt: str
        """

        self._cluster_local_id_lt = cluster_local_id_lt

    @property
    def cluster_local_id_lte(self):
        """Gets the cluster_local_id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_lte

    @cluster_local_id_lte.setter
    def cluster_local_id_lte(self, cluster_local_id_lte):
        """Sets the cluster_local_id_lte of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_lte: The cluster_local_id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_lte: str
        """

        self._cluster_local_id_lte = cluster_local_id_lte

    @property
    def cluster_local_id_not(self):
        """Gets the cluster_local_id_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not

    @cluster_local_id_not.setter
    def cluster_local_id_not(self, cluster_local_id_not):
        """Sets the cluster_local_id_not of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_not: The cluster_local_id_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_not: str
        """

        self._cluster_local_id_not = cluster_local_id_not

    @property
    def cluster_local_id_not_contains(self):
        """Gets the cluster_local_id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not_contains

    @cluster_local_id_not_contains.setter
    def cluster_local_id_not_contains(self, cluster_local_id_not_contains):
        """Sets the cluster_local_id_not_contains of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_not_contains: The cluster_local_id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_not_contains: str
        """

        self._cluster_local_id_not_contains = cluster_local_id_not_contains

    @property
    def cluster_local_id_not_ends_with(self):
        """Gets the cluster_local_id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not_ends_with

    @cluster_local_id_not_ends_with.setter
    def cluster_local_id_not_ends_with(self, cluster_local_id_not_ends_with):
        """Sets the cluster_local_id_not_ends_with of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_not_ends_with: The cluster_local_id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_not_ends_with: str
        """

        self._cluster_local_id_not_ends_with = cluster_local_id_not_ends_with

    @property
    def cluster_local_id_not_in(self):
        """Gets the cluster_local_id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._cluster_local_id_not_in

    @cluster_local_id_not_in.setter
    def cluster_local_id_not_in(self, cluster_local_id_not_in):
        """Sets the cluster_local_id_not_in of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_not_in: The cluster_local_id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_not_in: list[str]
        """

        self._cluster_local_id_not_in = cluster_local_id_not_in

    @property
    def cluster_local_id_not_starts_with(self):
        """Gets the cluster_local_id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_not_starts_with

    @cluster_local_id_not_starts_with.setter
    def cluster_local_id_not_starts_with(self, cluster_local_id_not_starts_with):
        """Sets the cluster_local_id_not_starts_with of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_not_starts_with: The cluster_local_id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_not_starts_with: str
        """

        self._cluster_local_id_not_starts_with = cluster_local_id_not_starts_with

    @property
    def cluster_local_id_starts_with(self):
        """Gets the cluster_local_id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The cluster_local_id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._cluster_local_id_starts_with

    @cluster_local_id_starts_with.setter
    def cluster_local_id_starts_with(self, cluster_local_id_starts_with):
        """Sets the cluster_local_id_starts_with of this BackupTargetExecutionWhereInput.


        :param cluster_local_id_starts_with: The cluster_local_id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type cluster_local_id_starts_with: str
        """

        self._cluster_local_id_starts_with = cluster_local_id_starts_with

    @property
    def duration(self):
        """Gets the duration of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The duration of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this BackupTargetExecutionWhereInput.


        :param duration: The duration of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type duration: int
        """

        self._duration = duration

    @property
    def duration_gt(self):
        """Gets the duration_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The duration_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration_gt

    @duration_gt.setter
    def duration_gt(self, duration_gt):
        """Sets the duration_gt of this BackupTargetExecutionWhereInput.


        :param duration_gt: The duration_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type duration_gt: int
        """

        self._duration_gt = duration_gt

    @property
    def duration_gte(self):
        """Gets the duration_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The duration_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration_gte

    @duration_gte.setter
    def duration_gte(self, duration_gte):
        """Sets the duration_gte of this BackupTargetExecutionWhereInput.


        :param duration_gte: The duration_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type duration_gte: int
        """

        self._duration_gte = duration_gte

    @property
    def duration_in(self):
        """Gets the duration_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The duration_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._duration_in

    @duration_in.setter
    def duration_in(self, duration_in):
        """Sets the duration_in of this BackupTargetExecutionWhereInput.


        :param duration_in: The duration_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type duration_in: list[int]
        """

        self._duration_in = duration_in

    @property
    def duration_lt(self):
        """Gets the duration_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The duration_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration_lt

    @duration_lt.setter
    def duration_lt(self, duration_lt):
        """Sets the duration_lt of this BackupTargetExecutionWhereInput.


        :param duration_lt: The duration_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type duration_lt: int
        """

        self._duration_lt = duration_lt

    @property
    def duration_lte(self):
        """Gets the duration_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The duration_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration_lte

    @duration_lte.setter
    def duration_lte(self, duration_lte):
        """Sets the duration_lte of this BackupTargetExecutionWhereInput.


        :param duration_lte: The duration_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type duration_lte: int
        """

        self._duration_lte = duration_lte

    @property
    def duration_not(self):
        """Gets the duration_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The duration_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._duration_not

    @duration_not.setter
    def duration_not(self, duration_not):
        """Sets the duration_not of this BackupTargetExecutionWhereInput.


        :param duration_not: The duration_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type duration_not: int
        """

        self._duration_not = duration_not

    @property
    def duration_not_in(self):
        """Gets the duration_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The duration_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._duration_not_in

    @duration_not_in.setter
    def duration_not_in(self, duration_not_in):
        """Sets the duration_not_in of this BackupTargetExecutionWhereInput.


        :param duration_not_in: The duration_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type duration_not_in: list[int]
        """

        self._duration_not_in = duration_not_in

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this BackupTargetExecutionWhereInput.


        :param entity_async_status: The entity_async_status of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this BackupTargetExecutionWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this BackupTargetExecutionWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this BackupTargetExecutionWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def executed_at(self):
        """Gets the executed_at of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The executed_at of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at

    @executed_at.setter
    def executed_at(self, executed_at):
        """Sets the executed_at of this BackupTargetExecutionWhereInput.


        :param executed_at: The executed_at of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type executed_at: str
        """

        self._executed_at = executed_at

    @property
    def executed_at_gt(self):
        """Gets the executed_at_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The executed_at_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at_gt

    @executed_at_gt.setter
    def executed_at_gt(self, executed_at_gt):
        """Sets the executed_at_gt of this BackupTargetExecutionWhereInput.


        :param executed_at_gt: The executed_at_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type executed_at_gt: str
        """

        self._executed_at_gt = executed_at_gt

    @property
    def executed_at_gte(self):
        """Gets the executed_at_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The executed_at_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at_gte

    @executed_at_gte.setter
    def executed_at_gte(self, executed_at_gte):
        """Sets the executed_at_gte of this BackupTargetExecutionWhereInput.


        :param executed_at_gte: The executed_at_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type executed_at_gte: str
        """

        self._executed_at_gte = executed_at_gte

    @property
    def executed_at_in(self):
        """Gets the executed_at_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The executed_at_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._executed_at_in

    @executed_at_in.setter
    def executed_at_in(self, executed_at_in):
        """Sets the executed_at_in of this BackupTargetExecutionWhereInput.


        :param executed_at_in: The executed_at_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type executed_at_in: list[str]
        """

        self._executed_at_in = executed_at_in

    @property
    def executed_at_lt(self):
        """Gets the executed_at_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The executed_at_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at_lt

    @executed_at_lt.setter
    def executed_at_lt(self, executed_at_lt):
        """Sets the executed_at_lt of this BackupTargetExecutionWhereInput.


        :param executed_at_lt: The executed_at_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type executed_at_lt: str
        """

        self._executed_at_lt = executed_at_lt

    @property
    def executed_at_lte(self):
        """Gets the executed_at_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The executed_at_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at_lte

    @executed_at_lte.setter
    def executed_at_lte(self, executed_at_lte):
        """Sets the executed_at_lte of this BackupTargetExecutionWhereInput.


        :param executed_at_lte: The executed_at_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type executed_at_lte: str
        """

        self._executed_at_lte = executed_at_lte

    @property
    def executed_at_not(self):
        """Gets the executed_at_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The executed_at_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._executed_at_not

    @executed_at_not.setter
    def executed_at_not(self, executed_at_not):
        """Sets the executed_at_not of this BackupTargetExecutionWhereInput.


        :param executed_at_not: The executed_at_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type executed_at_not: str
        """

        self._executed_at_not = executed_at_not

    @property
    def executed_at_not_in(self):
        """Gets the executed_at_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The executed_at_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._executed_at_not_in

    @executed_at_not_in.setter
    def executed_at_not_in(self, executed_at_not_in):
        """Sets the executed_at_not_in of this BackupTargetExecutionWhereInput.


        :param executed_at_not_in: The executed_at_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type executed_at_not_in: list[str]
        """

        self._executed_at_not_in = executed_at_not_in

    @property
    def id(self):
        """Gets the id of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BackupTargetExecutionWhereInput.


        :param id: The id of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this BackupTargetExecutionWhereInput.


        :param id_contains: The id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this BackupTargetExecutionWhereInput.


        :param id_ends_with: The id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this BackupTargetExecutionWhereInput.


        :param id_gt: The id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this BackupTargetExecutionWhereInput.


        :param id_gte: The id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this BackupTargetExecutionWhereInput.


        :param id_in: The id_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this BackupTargetExecutionWhereInput.


        :param id_lt: The id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this BackupTargetExecutionWhereInput.


        :param id_lte: The id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this BackupTargetExecutionWhereInput.


        :param id_not: The id_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this BackupTargetExecutionWhereInput.


        :param id_not_contains: The id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this BackupTargetExecutionWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this BackupTargetExecutionWhereInput.


        :param id_not_in: The id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this BackupTargetExecutionWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this BackupTargetExecutionWhereInput.


        :param id_starts_with: The id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def local_id(self):
        """Gets the local_id of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this BackupTargetExecutionWhereInput.


        :param local_id: The local_id of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def local_id_contains(self):
        """Gets the local_id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_contains

    @local_id_contains.setter
    def local_id_contains(self, local_id_contains):
        """Sets the local_id_contains of this BackupTargetExecutionWhereInput.


        :param local_id_contains: The local_id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_contains: str
        """

        self._local_id_contains = local_id_contains

    @property
    def local_id_ends_with(self):
        """Gets the local_id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_ends_with

    @local_id_ends_with.setter
    def local_id_ends_with(self, local_id_ends_with):
        """Sets the local_id_ends_with of this BackupTargetExecutionWhereInput.


        :param local_id_ends_with: The local_id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_ends_with: str
        """

        self._local_id_ends_with = local_id_ends_with

    @property
    def local_id_gt(self):
        """Gets the local_id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gt

    @local_id_gt.setter
    def local_id_gt(self, local_id_gt):
        """Sets the local_id_gt of this BackupTargetExecutionWhereInput.


        :param local_id_gt: The local_id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_gt: str
        """

        self._local_id_gt = local_id_gt

    @property
    def local_id_gte(self):
        """Gets the local_id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_gte

    @local_id_gte.setter
    def local_id_gte(self, local_id_gte):
        """Sets the local_id_gte of this BackupTargetExecutionWhereInput.


        :param local_id_gte: The local_id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_gte: str
        """

        self._local_id_gte = local_id_gte

    @property
    def local_id_in(self):
        """Gets the local_id_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_in

    @local_id_in.setter
    def local_id_in(self, local_id_in):
        """Sets the local_id_in of this BackupTargetExecutionWhereInput.


        :param local_id_in: The local_id_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_in: list[str]
        """

        self._local_id_in = local_id_in

    @property
    def local_id_lt(self):
        """Gets the local_id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lt

    @local_id_lt.setter
    def local_id_lt(self, local_id_lt):
        """Sets the local_id_lt of this BackupTargetExecutionWhereInput.


        :param local_id_lt: The local_id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_lt: str
        """

        self._local_id_lt = local_id_lt

    @property
    def local_id_lte(self):
        """Gets the local_id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_lte

    @local_id_lte.setter
    def local_id_lte(self, local_id_lte):
        """Sets the local_id_lte of this BackupTargetExecutionWhereInput.


        :param local_id_lte: The local_id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_lte: str
        """

        self._local_id_lte = local_id_lte

    @property
    def local_id_not(self):
        """Gets the local_id_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not

    @local_id_not.setter
    def local_id_not(self, local_id_not):
        """Sets the local_id_not of this BackupTargetExecutionWhereInput.


        :param local_id_not: The local_id_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_not: str
        """

        self._local_id_not = local_id_not

    @property
    def local_id_not_contains(self):
        """Gets the local_id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_contains

    @local_id_not_contains.setter
    def local_id_not_contains(self, local_id_not_contains):
        """Sets the local_id_not_contains of this BackupTargetExecutionWhereInput.


        :param local_id_not_contains: The local_id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_not_contains: str
        """

        self._local_id_not_contains = local_id_not_contains

    @property
    def local_id_not_ends_with(self):
        """Gets the local_id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_ends_with

    @local_id_not_ends_with.setter
    def local_id_not_ends_with(self, local_id_not_ends_with):
        """Sets the local_id_not_ends_with of this BackupTargetExecutionWhereInput.


        :param local_id_not_ends_with: The local_id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_not_ends_with: str
        """

        self._local_id_not_ends_with = local_id_not_ends_with

    @property
    def local_id_not_in(self):
        """Gets the local_id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._local_id_not_in

    @local_id_not_in.setter
    def local_id_not_in(self, local_id_not_in):
        """Sets the local_id_not_in of this BackupTargetExecutionWhereInput.


        :param local_id_not_in: The local_id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_not_in: list[str]
        """

        self._local_id_not_in = local_id_not_in

    @property
    def local_id_not_starts_with(self):
        """Gets the local_id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_not_starts_with

    @local_id_not_starts_with.setter
    def local_id_not_starts_with(self, local_id_not_starts_with):
        """Sets the local_id_not_starts_with of this BackupTargetExecutionWhereInput.


        :param local_id_not_starts_with: The local_id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_not_starts_with: str
        """

        self._local_id_not_starts_with = local_id_not_starts_with

    @property
    def local_id_starts_with(self):
        """Gets the local_id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The local_id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._local_id_starts_with

    @local_id_starts_with.setter
    def local_id_starts_with(self, local_id_starts_with):
        """Sets the local_id_starts_with of this BackupTargetExecutionWhereInput.


        :param local_id_starts_with: The local_id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type local_id_starts_with: str
        """

        self._local_id_starts_with = local_id_starts_with

    @property
    def parent_backup(self):
        """Gets the parent_backup of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup

    @parent_backup.setter
    def parent_backup(self, parent_backup):
        """Sets the parent_backup of this BackupTargetExecutionWhereInput.


        :param parent_backup: The parent_backup of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup: str
        """

        self._parent_backup = parent_backup

    @property
    def parent_backup_contains(self):
        """Gets the parent_backup_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup_contains

    @parent_backup_contains.setter
    def parent_backup_contains(self, parent_backup_contains):
        """Sets the parent_backup_contains of this BackupTargetExecutionWhereInput.


        :param parent_backup_contains: The parent_backup_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_contains: str
        """

        self._parent_backup_contains = parent_backup_contains

    @property
    def parent_backup_ends_with(self):
        """Gets the parent_backup_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup_ends_with

    @parent_backup_ends_with.setter
    def parent_backup_ends_with(self, parent_backup_ends_with):
        """Sets the parent_backup_ends_with of this BackupTargetExecutionWhereInput.


        :param parent_backup_ends_with: The parent_backup_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_ends_with: str
        """

        self._parent_backup_ends_with = parent_backup_ends_with

    @property
    def parent_backup_gt(self):
        """Gets the parent_backup_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup_gt

    @parent_backup_gt.setter
    def parent_backup_gt(self, parent_backup_gt):
        """Sets the parent_backup_gt of this BackupTargetExecutionWhereInput.


        :param parent_backup_gt: The parent_backup_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_gt: str
        """

        self._parent_backup_gt = parent_backup_gt

    @property
    def parent_backup_gte(self):
        """Gets the parent_backup_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup_gte

    @parent_backup_gte.setter
    def parent_backup_gte(self, parent_backup_gte):
        """Sets the parent_backup_gte of this BackupTargetExecutionWhereInput.


        :param parent_backup_gte: The parent_backup_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_gte: str
        """

        self._parent_backup_gte = parent_backup_gte

    @property
    def parent_backup_in(self):
        """Gets the parent_backup_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._parent_backup_in

    @parent_backup_in.setter
    def parent_backup_in(self, parent_backup_in):
        """Sets the parent_backup_in of this BackupTargetExecutionWhereInput.


        :param parent_backup_in: The parent_backup_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_in: list[str]
        """

        self._parent_backup_in = parent_backup_in

    @property
    def parent_backup_lt(self):
        """Gets the parent_backup_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup_lt

    @parent_backup_lt.setter
    def parent_backup_lt(self, parent_backup_lt):
        """Sets the parent_backup_lt of this BackupTargetExecutionWhereInput.


        :param parent_backup_lt: The parent_backup_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_lt: str
        """

        self._parent_backup_lt = parent_backup_lt

    @property
    def parent_backup_lte(self):
        """Gets the parent_backup_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup_lte

    @parent_backup_lte.setter
    def parent_backup_lte(self, parent_backup_lte):
        """Sets the parent_backup_lte of this BackupTargetExecutionWhereInput.


        :param parent_backup_lte: The parent_backup_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_lte: str
        """

        self._parent_backup_lte = parent_backup_lte

    @property
    def parent_backup_not(self):
        """Gets the parent_backup_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup_not

    @parent_backup_not.setter
    def parent_backup_not(self, parent_backup_not):
        """Sets the parent_backup_not of this BackupTargetExecutionWhereInput.


        :param parent_backup_not: The parent_backup_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_not: str
        """

        self._parent_backup_not = parent_backup_not

    @property
    def parent_backup_not_contains(self):
        """Gets the parent_backup_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup_not_contains

    @parent_backup_not_contains.setter
    def parent_backup_not_contains(self, parent_backup_not_contains):
        """Sets the parent_backup_not_contains of this BackupTargetExecutionWhereInput.


        :param parent_backup_not_contains: The parent_backup_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_not_contains: str
        """

        self._parent_backup_not_contains = parent_backup_not_contains

    @property
    def parent_backup_not_ends_with(self):
        """Gets the parent_backup_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup_not_ends_with

    @parent_backup_not_ends_with.setter
    def parent_backup_not_ends_with(self, parent_backup_not_ends_with):
        """Sets the parent_backup_not_ends_with of this BackupTargetExecutionWhereInput.


        :param parent_backup_not_ends_with: The parent_backup_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_not_ends_with: str
        """

        self._parent_backup_not_ends_with = parent_backup_not_ends_with

    @property
    def parent_backup_not_in(self):
        """Gets the parent_backup_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._parent_backup_not_in

    @parent_backup_not_in.setter
    def parent_backup_not_in(self, parent_backup_not_in):
        """Sets the parent_backup_not_in of this BackupTargetExecutionWhereInput.


        :param parent_backup_not_in: The parent_backup_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_not_in: list[str]
        """

        self._parent_backup_not_in = parent_backup_not_in

    @property
    def parent_backup_not_starts_with(self):
        """Gets the parent_backup_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup_not_starts_with

    @parent_backup_not_starts_with.setter
    def parent_backup_not_starts_with(self, parent_backup_not_starts_with):
        """Sets the parent_backup_not_starts_with of this BackupTargetExecutionWhereInput.


        :param parent_backup_not_starts_with: The parent_backup_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_not_starts_with: str
        """

        self._parent_backup_not_starts_with = parent_backup_not_starts_with

    @property
    def parent_backup_starts_with(self):
        """Gets the parent_backup_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The parent_backup_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._parent_backup_starts_with

    @parent_backup_starts_with.setter
    def parent_backup_starts_with(self, parent_backup_starts_with):
        """Sets the parent_backup_starts_with of this BackupTargetExecutionWhereInput.


        :param parent_backup_starts_with: The parent_backup_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type parent_backup_starts_with: str
        """

        self._parent_backup_starts_with = parent_backup_starts_with

    @property
    def read_bytes(self):
        """Gets the read_bytes of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The read_bytes of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._read_bytes

    @read_bytes.setter
    def read_bytes(self, read_bytes):
        """Sets the read_bytes of this BackupTargetExecutionWhereInput.


        :param read_bytes: The read_bytes of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type read_bytes: int
        """

        self._read_bytes = read_bytes

    @property
    def read_bytes_gt(self):
        """Gets the read_bytes_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The read_bytes_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._read_bytes_gt

    @read_bytes_gt.setter
    def read_bytes_gt(self, read_bytes_gt):
        """Sets the read_bytes_gt of this BackupTargetExecutionWhereInput.


        :param read_bytes_gt: The read_bytes_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type read_bytes_gt: int
        """

        self._read_bytes_gt = read_bytes_gt

    @property
    def read_bytes_gte(self):
        """Gets the read_bytes_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The read_bytes_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._read_bytes_gte

    @read_bytes_gte.setter
    def read_bytes_gte(self, read_bytes_gte):
        """Sets the read_bytes_gte of this BackupTargetExecutionWhereInput.


        :param read_bytes_gte: The read_bytes_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type read_bytes_gte: int
        """

        self._read_bytes_gte = read_bytes_gte

    @property
    def read_bytes_in(self):
        """Gets the read_bytes_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The read_bytes_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._read_bytes_in

    @read_bytes_in.setter
    def read_bytes_in(self, read_bytes_in):
        """Sets the read_bytes_in of this BackupTargetExecutionWhereInput.


        :param read_bytes_in: The read_bytes_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type read_bytes_in: list[int]
        """

        self._read_bytes_in = read_bytes_in

    @property
    def read_bytes_lt(self):
        """Gets the read_bytes_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The read_bytes_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._read_bytes_lt

    @read_bytes_lt.setter
    def read_bytes_lt(self, read_bytes_lt):
        """Sets the read_bytes_lt of this BackupTargetExecutionWhereInput.


        :param read_bytes_lt: The read_bytes_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type read_bytes_lt: int
        """

        self._read_bytes_lt = read_bytes_lt

    @property
    def read_bytes_lte(self):
        """Gets the read_bytes_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The read_bytes_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._read_bytes_lte

    @read_bytes_lte.setter
    def read_bytes_lte(self, read_bytes_lte):
        """Sets the read_bytes_lte of this BackupTargetExecutionWhereInput.


        :param read_bytes_lte: The read_bytes_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type read_bytes_lte: int
        """

        self._read_bytes_lte = read_bytes_lte

    @property
    def read_bytes_not(self):
        """Gets the read_bytes_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The read_bytes_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._read_bytes_not

    @read_bytes_not.setter
    def read_bytes_not(self, read_bytes_not):
        """Sets the read_bytes_not of this BackupTargetExecutionWhereInput.


        :param read_bytes_not: The read_bytes_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type read_bytes_not: int
        """

        self._read_bytes_not = read_bytes_not

    @property
    def read_bytes_not_in(self):
        """Gets the read_bytes_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The read_bytes_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._read_bytes_not_in

    @read_bytes_not_in.setter
    def read_bytes_not_in(self, read_bytes_not_in):
        """Sets the read_bytes_not_in of this BackupTargetExecutionWhereInput.


        :param read_bytes_not_in: The read_bytes_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type read_bytes_not_in: list[int]
        """

        self._read_bytes_not_in = read_bytes_not_in

    @property
    def retry_times(self):
        """Gets the retry_times of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The retry_times of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_times

    @retry_times.setter
    def retry_times(self, retry_times):
        """Sets the retry_times of this BackupTargetExecutionWhereInput.


        :param retry_times: The retry_times of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type retry_times: int
        """

        self._retry_times = retry_times

    @property
    def retry_times_gt(self):
        """Gets the retry_times_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The retry_times_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_times_gt

    @retry_times_gt.setter
    def retry_times_gt(self, retry_times_gt):
        """Sets the retry_times_gt of this BackupTargetExecutionWhereInput.


        :param retry_times_gt: The retry_times_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type retry_times_gt: int
        """

        self._retry_times_gt = retry_times_gt

    @property
    def retry_times_gte(self):
        """Gets the retry_times_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The retry_times_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_times_gte

    @retry_times_gte.setter
    def retry_times_gte(self, retry_times_gte):
        """Sets the retry_times_gte of this BackupTargetExecutionWhereInput.


        :param retry_times_gte: The retry_times_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type retry_times_gte: int
        """

        self._retry_times_gte = retry_times_gte

    @property
    def retry_times_in(self):
        """Gets the retry_times_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The retry_times_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._retry_times_in

    @retry_times_in.setter
    def retry_times_in(self, retry_times_in):
        """Sets the retry_times_in of this BackupTargetExecutionWhereInput.


        :param retry_times_in: The retry_times_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type retry_times_in: list[int]
        """

        self._retry_times_in = retry_times_in

    @property
    def retry_times_lt(self):
        """Gets the retry_times_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The retry_times_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_times_lt

    @retry_times_lt.setter
    def retry_times_lt(self, retry_times_lt):
        """Sets the retry_times_lt of this BackupTargetExecutionWhereInput.


        :param retry_times_lt: The retry_times_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type retry_times_lt: int
        """

        self._retry_times_lt = retry_times_lt

    @property
    def retry_times_lte(self):
        """Gets the retry_times_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The retry_times_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_times_lte

    @retry_times_lte.setter
    def retry_times_lte(self, retry_times_lte):
        """Sets the retry_times_lte of this BackupTargetExecutionWhereInput.


        :param retry_times_lte: The retry_times_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type retry_times_lte: int
        """

        self._retry_times_lte = retry_times_lte

    @property
    def retry_times_not(self):
        """Gets the retry_times_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The retry_times_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._retry_times_not

    @retry_times_not.setter
    def retry_times_not(self, retry_times_not):
        """Sets the retry_times_not of this BackupTargetExecutionWhereInput.


        :param retry_times_not: The retry_times_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type retry_times_not: int
        """

        self._retry_times_not = retry_times_not

    @property
    def retry_times_not_in(self):
        """Gets the retry_times_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The retry_times_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._retry_times_not_in

    @retry_times_not_in.setter
    def retry_times_not_in(self, retry_times_not_in):
        """Sets the retry_times_not_in of this BackupTargetExecutionWhereInput.


        :param retry_times_not_in: The retry_times_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type retry_times_not_in: list[int]
        """

        self._retry_times_not_in = retry_times_not_in

    @property
    def status(self):
        """Gets the status of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The status of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BackupTargetExecutionWhereInput.


        :param status: The status of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type status: BackupExecutionStatus
        """

        self._status = status

    @property
    def status_in(self):
        """Gets the status_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The status_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionStatus]
        """
        return self._status_in

    @status_in.setter
    def status_in(self, status_in):
        """Sets the status_in of this BackupTargetExecutionWhereInput.


        :param status_in: The status_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type status_in: list[BackupExecutionStatus]
        """

        self._status_in = status_in

    @property
    def status_not(self):
        """Gets the status_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The status_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionStatus
        """
        return self._status_not

    @status_not.setter
    def status_not(self, status_not):
        """Sets the status_not of this BackupTargetExecutionWhereInput.


        :param status_not: The status_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type status_not: BackupExecutionStatus
        """

        self._status_not = status_not

    @property
    def status_not_in(self):
        """Gets the status_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The status_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionStatus]
        """
        return self._status_not_in

    @status_not_in.setter
    def status_not_in(self, status_not_in):
        """Sets the status_not_in of this BackupTargetExecutionWhereInput.


        :param status_not_in: The status_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type status_not_in: list[BackupExecutionStatus]
        """

        self._status_not_in = status_not_in

    @property
    def total_bytes(self):
        """Gets the total_bytes of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The total_bytes of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_bytes

    @total_bytes.setter
    def total_bytes(self, total_bytes):
        """Sets the total_bytes of this BackupTargetExecutionWhereInput.


        :param total_bytes: The total_bytes of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type total_bytes: int
        """

        self._total_bytes = total_bytes

    @property
    def total_bytes_gt(self):
        """Gets the total_bytes_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The total_bytes_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_bytes_gt

    @total_bytes_gt.setter
    def total_bytes_gt(self, total_bytes_gt):
        """Sets the total_bytes_gt of this BackupTargetExecutionWhereInput.


        :param total_bytes_gt: The total_bytes_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type total_bytes_gt: int
        """

        self._total_bytes_gt = total_bytes_gt

    @property
    def total_bytes_gte(self):
        """Gets the total_bytes_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The total_bytes_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_bytes_gte

    @total_bytes_gte.setter
    def total_bytes_gte(self, total_bytes_gte):
        """Sets the total_bytes_gte of this BackupTargetExecutionWhereInput.


        :param total_bytes_gte: The total_bytes_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type total_bytes_gte: int
        """

        self._total_bytes_gte = total_bytes_gte

    @property
    def total_bytes_in(self):
        """Gets the total_bytes_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The total_bytes_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_bytes_in

    @total_bytes_in.setter
    def total_bytes_in(self, total_bytes_in):
        """Sets the total_bytes_in of this BackupTargetExecutionWhereInput.


        :param total_bytes_in: The total_bytes_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type total_bytes_in: list[int]
        """

        self._total_bytes_in = total_bytes_in

    @property
    def total_bytes_lt(self):
        """Gets the total_bytes_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The total_bytes_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_bytes_lt

    @total_bytes_lt.setter
    def total_bytes_lt(self, total_bytes_lt):
        """Sets the total_bytes_lt of this BackupTargetExecutionWhereInput.


        :param total_bytes_lt: The total_bytes_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type total_bytes_lt: int
        """

        self._total_bytes_lt = total_bytes_lt

    @property
    def total_bytes_lte(self):
        """Gets the total_bytes_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The total_bytes_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_bytes_lte

    @total_bytes_lte.setter
    def total_bytes_lte(self, total_bytes_lte):
        """Sets the total_bytes_lte of this BackupTargetExecutionWhereInput.


        :param total_bytes_lte: The total_bytes_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type total_bytes_lte: int
        """

        self._total_bytes_lte = total_bytes_lte

    @property
    def total_bytes_not(self):
        """Gets the total_bytes_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The total_bytes_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._total_bytes_not

    @total_bytes_not.setter
    def total_bytes_not(self, total_bytes_not):
        """Sets the total_bytes_not of this BackupTargetExecutionWhereInput.


        :param total_bytes_not: The total_bytes_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type total_bytes_not: int
        """

        self._total_bytes_not = total_bytes_not

    @property
    def total_bytes_not_in(self):
        """Gets the total_bytes_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The total_bytes_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._total_bytes_not_in

    @total_bytes_not_in.setter
    def total_bytes_not_in(self, total_bytes_not_in):
        """Sets the total_bytes_not_in of this BackupTargetExecutionWhereInput.


        :param total_bytes_not_in: The total_bytes_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type total_bytes_not_in: list[int]
        """

        self._total_bytes_not_in = total_bytes_not_in

    @property
    def type(self):
        """Gets the type of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The type of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BackupTargetExecutionWhereInput.


        :param type: The type of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type type: BackupExecutionType
        """

        self._type = type

    @property
    def type_in(self):
        """Gets the type_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The type_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionType]
        """
        return self._type_in

    @type_in.setter
    def type_in(self, type_in):
        """Sets the type_in of this BackupTargetExecutionWhereInput.


        :param type_in: The type_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type type_in: list[BackupExecutionType]
        """

        self._type_in = type_in

    @property
    def type_not(self):
        """Gets the type_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The type_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: BackupExecutionType
        """
        return self._type_not

    @type_not.setter
    def type_not(self, type_not):
        """Sets the type_not of this BackupTargetExecutionWhereInput.


        :param type_not: The type_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type type_not: BackupExecutionType
        """

        self._type_not = type_not

    @property
    def type_not_in(self):
        """Gets the type_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The type_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[BackupExecutionType]
        """
        return self._type_not_in

    @type_not_in.setter
    def type_not_in(self, type_not_in):
        """Sets the type_not_in of this BackupTargetExecutionWhereInput.


        :param type_not_in: The type_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type type_not_in: list[BackupExecutionType]
        """

        self._type_not_in = type_not_in

    @property
    def vm(self):
        """Gets the vm of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: VmWhereInput
        """
        return self._vm

    @vm.setter
    def vm(self, vm):
        """Sets the vm of this BackupTargetExecutionWhereInput.


        :param vm: The vm of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm: VmWhereInput
        """

        self._vm = vm

    @property
    def vm_local_id(self):
        """Gets the vm_local_id of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id

    @vm_local_id.setter
    def vm_local_id(self, vm_local_id):
        """Sets the vm_local_id of this BackupTargetExecutionWhereInput.


        :param vm_local_id: The vm_local_id of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id: str
        """

        self._vm_local_id = vm_local_id

    @property
    def vm_local_id_contains(self):
        """Gets the vm_local_id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_contains

    @vm_local_id_contains.setter
    def vm_local_id_contains(self, vm_local_id_contains):
        """Sets the vm_local_id_contains of this BackupTargetExecutionWhereInput.


        :param vm_local_id_contains: The vm_local_id_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_contains: str
        """

        self._vm_local_id_contains = vm_local_id_contains

    @property
    def vm_local_id_ends_with(self):
        """Gets the vm_local_id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_ends_with

    @vm_local_id_ends_with.setter
    def vm_local_id_ends_with(self, vm_local_id_ends_with):
        """Sets the vm_local_id_ends_with of this BackupTargetExecutionWhereInput.


        :param vm_local_id_ends_with: The vm_local_id_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_ends_with: str
        """

        self._vm_local_id_ends_with = vm_local_id_ends_with

    @property
    def vm_local_id_gt(self):
        """Gets the vm_local_id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_gt

    @vm_local_id_gt.setter
    def vm_local_id_gt(self, vm_local_id_gt):
        """Sets the vm_local_id_gt of this BackupTargetExecutionWhereInput.


        :param vm_local_id_gt: The vm_local_id_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_gt: str
        """

        self._vm_local_id_gt = vm_local_id_gt

    @property
    def vm_local_id_gte(self):
        """Gets the vm_local_id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_gte

    @vm_local_id_gte.setter
    def vm_local_id_gte(self, vm_local_id_gte):
        """Sets the vm_local_id_gte of this BackupTargetExecutionWhereInput.


        :param vm_local_id_gte: The vm_local_id_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_gte: str
        """

        self._vm_local_id_gte = vm_local_id_gte

    @property
    def vm_local_id_in(self):
        """Gets the vm_local_id_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_local_id_in

    @vm_local_id_in.setter
    def vm_local_id_in(self, vm_local_id_in):
        """Sets the vm_local_id_in of this BackupTargetExecutionWhereInput.


        :param vm_local_id_in: The vm_local_id_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_in: list[str]
        """

        self._vm_local_id_in = vm_local_id_in

    @property
    def vm_local_id_lt(self):
        """Gets the vm_local_id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_lt

    @vm_local_id_lt.setter
    def vm_local_id_lt(self, vm_local_id_lt):
        """Sets the vm_local_id_lt of this BackupTargetExecutionWhereInput.


        :param vm_local_id_lt: The vm_local_id_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_lt: str
        """

        self._vm_local_id_lt = vm_local_id_lt

    @property
    def vm_local_id_lte(self):
        """Gets the vm_local_id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_lte

    @vm_local_id_lte.setter
    def vm_local_id_lte(self, vm_local_id_lte):
        """Sets the vm_local_id_lte of this BackupTargetExecutionWhereInput.


        :param vm_local_id_lte: The vm_local_id_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_lte: str
        """

        self._vm_local_id_lte = vm_local_id_lte

    @property
    def vm_local_id_not(self):
        """Gets the vm_local_id_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not

    @vm_local_id_not.setter
    def vm_local_id_not(self, vm_local_id_not):
        """Sets the vm_local_id_not of this BackupTargetExecutionWhereInput.


        :param vm_local_id_not: The vm_local_id_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_not: str
        """

        self._vm_local_id_not = vm_local_id_not

    @property
    def vm_local_id_not_contains(self):
        """Gets the vm_local_id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not_contains

    @vm_local_id_not_contains.setter
    def vm_local_id_not_contains(self, vm_local_id_not_contains):
        """Sets the vm_local_id_not_contains of this BackupTargetExecutionWhereInput.


        :param vm_local_id_not_contains: The vm_local_id_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_not_contains: str
        """

        self._vm_local_id_not_contains = vm_local_id_not_contains

    @property
    def vm_local_id_not_ends_with(self):
        """Gets the vm_local_id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not_ends_with

    @vm_local_id_not_ends_with.setter
    def vm_local_id_not_ends_with(self, vm_local_id_not_ends_with):
        """Sets the vm_local_id_not_ends_with of this BackupTargetExecutionWhereInput.


        :param vm_local_id_not_ends_with: The vm_local_id_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_not_ends_with: str
        """

        self._vm_local_id_not_ends_with = vm_local_id_not_ends_with

    @property
    def vm_local_id_not_in(self):
        """Gets the vm_local_id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_local_id_not_in

    @vm_local_id_not_in.setter
    def vm_local_id_not_in(self, vm_local_id_not_in):
        """Sets the vm_local_id_not_in of this BackupTargetExecutionWhereInput.


        :param vm_local_id_not_in: The vm_local_id_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_not_in: list[str]
        """

        self._vm_local_id_not_in = vm_local_id_not_in

    @property
    def vm_local_id_not_starts_with(self):
        """Gets the vm_local_id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_not_starts_with

    @vm_local_id_not_starts_with.setter
    def vm_local_id_not_starts_with(self, vm_local_id_not_starts_with):
        """Sets the vm_local_id_not_starts_with of this BackupTargetExecutionWhereInput.


        :param vm_local_id_not_starts_with: The vm_local_id_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_not_starts_with: str
        """

        self._vm_local_id_not_starts_with = vm_local_id_not_starts_with

    @property
    def vm_local_id_starts_with(self):
        """Gets the vm_local_id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_local_id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_local_id_starts_with

    @vm_local_id_starts_with.setter
    def vm_local_id_starts_with(self, vm_local_id_starts_with):
        """Sets the vm_local_id_starts_with of this BackupTargetExecutionWhereInput.


        :param vm_local_id_starts_with: The vm_local_id_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_local_id_starts_with: str
        """

        self._vm_local_id_starts_with = vm_local_id_starts_with

    @property
    def vm_name(self):
        """Gets the vm_name of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name

    @vm_name.setter
    def vm_name(self, vm_name):
        """Sets the vm_name of this BackupTargetExecutionWhereInput.


        :param vm_name: The vm_name of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name: str
        """

        self._vm_name = vm_name

    @property
    def vm_name_contains(self):
        """Gets the vm_name_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_contains

    @vm_name_contains.setter
    def vm_name_contains(self, vm_name_contains):
        """Sets the vm_name_contains of this BackupTargetExecutionWhereInput.


        :param vm_name_contains: The vm_name_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_contains: str
        """

        self._vm_name_contains = vm_name_contains

    @property
    def vm_name_ends_with(self):
        """Gets the vm_name_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_ends_with

    @vm_name_ends_with.setter
    def vm_name_ends_with(self, vm_name_ends_with):
        """Sets the vm_name_ends_with of this BackupTargetExecutionWhereInput.


        :param vm_name_ends_with: The vm_name_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_ends_with: str
        """

        self._vm_name_ends_with = vm_name_ends_with

    @property
    def vm_name_gt(self):
        """Gets the vm_name_gt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_gt

    @vm_name_gt.setter
    def vm_name_gt(self, vm_name_gt):
        """Sets the vm_name_gt of this BackupTargetExecutionWhereInput.


        :param vm_name_gt: The vm_name_gt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_gt: str
        """

        self._vm_name_gt = vm_name_gt

    @property
    def vm_name_gte(self):
        """Gets the vm_name_gte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_gte

    @vm_name_gte.setter
    def vm_name_gte(self, vm_name_gte):
        """Sets the vm_name_gte of this BackupTargetExecutionWhereInput.


        :param vm_name_gte: The vm_name_gte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_gte: str
        """

        self._vm_name_gte = vm_name_gte

    @property
    def vm_name_in(self):
        """Gets the vm_name_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_name_in

    @vm_name_in.setter
    def vm_name_in(self, vm_name_in):
        """Sets the vm_name_in of this BackupTargetExecutionWhereInput.


        :param vm_name_in: The vm_name_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_in: list[str]
        """

        self._vm_name_in = vm_name_in

    @property
    def vm_name_lt(self):
        """Gets the vm_name_lt of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_lt

    @vm_name_lt.setter
    def vm_name_lt(self, vm_name_lt):
        """Sets the vm_name_lt of this BackupTargetExecutionWhereInput.


        :param vm_name_lt: The vm_name_lt of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_lt: str
        """

        self._vm_name_lt = vm_name_lt

    @property
    def vm_name_lte(self):
        """Gets the vm_name_lte of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_lte

    @vm_name_lte.setter
    def vm_name_lte(self, vm_name_lte):
        """Sets the vm_name_lte of this BackupTargetExecutionWhereInput.


        :param vm_name_lte: The vm_name_lte of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_lte: str
        """

        self._vm_name_lte = vm_name_lte

    @property
    def vm_name_not(self):
        """Gets the vm_name_not of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not

    @vm_name_not.setter
    def vm_name_not(self, vm_name_not):
        """Sets the vm_name_not of this BackupTargetExecutionWhereInput.


        :param vm_name_not: The vm_name_not of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_not: str
        """

        self._vm_name_not = vm_name_not

    @property
    def vm_name_not_contains(self):
        """Gets the vm_name_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not_contains

    @vm_name_not_contains.setter
    def vm_name_not_contains(self, vm_name_not_contains):
        """Sets the vm_name_not_contains of this BackupTargetExecutionWhereInput.


        :param vm_name_not_contains: The vm_name_not_contains of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_not_contains: str
        """

        self._vm_name_not_contains = vm_name_not_contains

    @property
    def vm_name_not_ends_with(self):
        """Gets the vm_name_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not_ends_with

    @vm_name_not_ends_with.setter
    def vm_name_not_ends_with(self, vm_name_not_ends_with):
        """Sets the vm_name_not_ends_with of this BackupTargetExecutionWhereInput.


        :param vm_name_not_ends_with: The vm_name_not_ends_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_not_ends_with: str
        """

        self._vm_name_not_ends_with = vm_name_not_ends_with

    @property
    def vm_name_not_in(self):
        """Gets the vm_name_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._vm_name_not_in

    @vm_name_not_in.setter
    def vm_name_not_in(self, vm_name_not_in):
        """Sets the vm_name_not_in of this BackupTargetExecutionWhereInput.


        :param vm_name_not_in: The vm_name_not_in of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_not_in: list[str]
        """

        self._vm_name_not_in = vm_name_not_in

    @property
    def vm_name_not_starts_with(self):
        """Gets the vm_name_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_not_starts_with

    @vm_name_not_starts_with.setter
    def vm_name_not_starts_with(self, vm_name_not_starts_with):
        """Sets the vm_name_not_starts_with of this BackupTargetExecutionWhereInput.


        :param vm_name_not_starts_with: The vm_name_not_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_not_starts_with: str
        """

        self._vm_name_not_starts_with = vm_name_not_starts_with

    @property
    def vm_name_starts_with(self):
        """Gets the vm_name_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501


        :return: The vm_name_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._vm_name_starts_with

    @vm_name_starts_with.setter
    def vm_name_starts_with(self, vm_name_starts_with):
        """Sets the vm_name_starts_with of this BackupTargetExecutionWhereInput.


        :param vm_name_starts_with: The vm_name_starts_with of this BackupTargetExecutionWhereInput.  # noqa: E501
        :type vm_name_starts_with: str
        """

        self._vm_name_starts_with = vm_name_starts_with

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupTargetExecutionWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupTargetExecutionWhereInput):
            return True

        return self.to_dict() != other.to_dict()
