# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class BusinessHost(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'business_host_group': 'NestedBusinessHostGroup',
        'cluster': 'NestedCluster',
        'description': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'id': 'str',
        'initiators': 'list[NestedInitiator]',
        'iscsi_luns': 'list[NestedIscsiLun]',
        'iscsi_targets': 'list[NestedIscsiTarget]',
        'labels': 'list[NestedLabel]',
        'local_id': 'str',
        'name': 'str',
        'nvmf_namespaces': 'list[NestedNvmfNamespace]',
        'nvmf_subsystems': 'list[NestedNvmfSubsystem]'
    }

    attribute_map = {
        'business_host_group': 'business_host_group',
        'cluster': 'cluster',
        'description': 'description',
        'entity_async_status': 'entityAsyncStatus',
        'id': 'id',
        'initiators': 'initiators',
        'iscsi_luns': 'iscsi_luns',
        'iscsi_targets': 'iscsi_targets',
        'labels': 'labels',
        'local_id': 'local_id',
        'name': 'name',
        'nvmf_namespaces': 'nvmf_namespaces',
        'nvmf_subsystems': 'nvmf_subsystems'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """BusinessHost - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._business_host_group = None
        self._cluster = None
        self._description = None
        self._entity_async_status = None
        self._id = None
        self._initiators = None
        self._iscsi_luns = None
        self._iscsi_targets = None
        self._labels = None
        self._local_id = None
        self._name = None
        self._nvmf_namespaces = None
        self._nvmf_subsystems = None
        self.discriminator = None

        self.business_host_group = kwargs.get("business_host_group", None)
        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        self.description = kwargs.get("description", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "initiators" in kwargs:
            self.initiators = kwargs["initiators"]
        self.iscsi_luns = kwargs.get("iscsi_luns", None)
        self.iscsi_targets = kwargs.get("iscsi_targets", None)
        self.labels = kwargs.get("labels", None)
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.nvmf_namespaces = kwargs.get("nvmf_namespaces", None)
        self.nvmf_subsystems = kwargs.get("nvmf_subsystems", None)

    @property
    def business_host_group(self):
        """Gets the business_host_group of this BusinessHost.  # noqa: E501


        :return: The business_host_group of this BusinessHost.  # noqa: E501
        :rtype: NestedBusinessHostGroup
        """
        return self._business_host_group

    @business_host_group.setter
    def business_host_group(self, business_host_group):
        """Sets the business_host_group of this BusinessHost.


        :param business_host_group: The business_host_group of this BusinessHost.  # noqa: E501
        :type business_host_group: NestedBusinessHostGroup
        """

        self._business_host_group = business_host_group

    @property
    def cluster(self):
        """Gets the cluster of this BusinessHost.  # noqa: E501


        :return: The cluster of this BusinessHost.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this BusinessHost.


        :param cluster: The cluster of this BusinessHost.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def description(self):
        """Gets the description of this BusinessHost.  # noqa: E501


        :return: The description of this BusinessHost.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BusinessHost.


        :param description: The description of this BusinessHost.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this BusinessHost.  # noqa: E501


        :return: The entity_async_status of this BusinessHost.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this BusinessHost.


        :param entity_async_status: The entity_async_status of this BusinessHost.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def id(self):
        """Gets the id of this BusinessHost.  # noqa: E501


        :return: The id of this BusinessHost.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BusinessHost.


        :param id: The id of this BusinessHost.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def initiators(self):
        """Gets the initiators of this BusinessHost.  # noqa: E501


        :return: The initiators of this BusinessHost.  # noqa: E501
        :rtype: list[NestedInitiator]
        """
        return self._initiators

    @initiators.setter
    def initiators(self, initiators):
        """Sets the initiators of this BusinessHost.


        :param initiators: The initiators of this BusinessHost.  # noqa: E501
        :type initiators: list[NestedInitiator]
        """
        if self.local_vars_configuration.client_side_validation and initiators is None:  # noqa: E501
            raise ValueError("Invalid value for `initiators`, must not be `None`")  # noqa: E501

        self._initiators = initiators

    @property
    def iscsi_luns(self):
        """Gets the iscsi_luns of this BusinessHost.  # noqa: E501


        :return: The iscsi_luns of this BusinessHost.  # noqa: E501
        :rtype: list[NestedIscsiLun]
        """
        return self._iscsi_luns

    @iscsi_luns.setter
    def iscsi_luns(self, iscsi_luns):
        """Sets the iscsi_luns of this BusinessHost.


        :param iscsi_luns: The iscsi_luns of this BusinessHost.  # noqa: E501
        :type iscsi_luns: list[NestedIscsiLun]
        """

        self._iscsi_luns = iscsi_luns

    @property
    def iscsi_targets(self):
        """Gets the iscsi_targets of this BusinessHost.  # noqa: E501


        :return: The iscsi_targets of this BusinessHost.  # noqa: E501
        :rtype: list[NestedIscsiTarget]
        """
        return self._iscsi_targets

    @iscsi_targets.setter
    def iscsi_targets(self, iscsi_targets):
        """Sets the iscsi_targets of this BusinessHost.


        :param iscsi_targets: The iscsi_targets of this BusinessHost.  # noqa: E501
        :type iscsi_targets: list[NestedIscsiTarget]
        """

        self._iscsi_targets = iscsi_targets

    @property
    def labels(self):
        """Gets the labels of this BusinessHost.  # noqa: E501


        :return: The labels of this BusinessHost.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this BusinessHost.


        :param labels: The labels of this BusinessHost.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def local_id(self):
        """Gets the local_id of this BusinessHost.  # noqa: E501


        :return: The local_id of this BusinessHost.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this BusinessHost.


        :param local_id: The local_id of this BusinessHost.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def name(self):
        """Gets the name of this BusinessHost.  # noqa: E501


        :return: The name of this BusinessHost.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BusinessHost.


        :param name: The name of this BusinessHost.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def nvmf_namespaces(self):
        """Gets the nvmf_namespaces of this BusinessHost.  # noqa: E501


        :return: The nvmf_namespaces of this BusinessHost.  # noqa: E501
        :rtype: list[NestedNvmfNamespace]
        """
        return self._nvmf_namespaces

    @nvmf_namespaces.setter
    def nvmf_namespaces(self, nvmf_namespaces):
        """Sets the nvmf_namespaces of this BusinessHost.


        :param nvmf_namespaces: The nvmf_namespaces of this BusinessHost.  # noqa: E501
        :type nvmf_namespaces: list[NestedNvmfNamespace]
        """

        self._nvmf_namespaces = nvmf_namespaces

    @property
    def nvmf_subsystems(self):
        """Gets the nvmf_subsystems of this BusinessHost.  # noqa: E501


        :return: The nvmf_subsystems of this BusinessHost.  # noqa: E501
        :rtype: list[NestedNvmfSubsystem]
        """
        return self._nvmf_subsystems

    @nvmf_subsystems.setter
    def nvmf_subsystems(self, nvmf_subsystems):
        """Sets the nvmf_subsystems of this BusinessHost.


        :param nvmf_subsystems: The nvmf_subsystems of this BusinessHost.  # noqa: E501
        :type nvmf_subsystems: list[NestedNvmfSubsystem]
        """

        self._nvmf_subsystems = nvmf_subsystems

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BusinessHost):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BusinessHost):
            return True

        return self.to_dict() != other.to_dict()
