# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class CloudTowerApplication(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'entity_async_status': 'EntityAsyncStatus',
        'id': 'str',
        'instance_statuses': 'object',
        'name': 'str',
        'package': 'NestedCloudTowerApplicationPackage',
        'placement_situation': 'str',
        'placement_verb': 'str',
        'resource_version': 'int',
        'state': 'CloudTowerApplicationState',
        'target_package': 'str',
        'user': 'NestedUser',
        'vm_spec': 'object'
    }

    attribute_map = {
        'entity_async_status': 'entityAsyncStatus',
        'id': 'id',
        'instance_statuses': 'instanceStatuses',
        'name': 'name',
        'package': 'package',
        'placement_situation': 'placementSituation',
        'placement_verb': 'placementVerb',
        'resource_version': 'resourceVersion',
        'state': 'state',
        'target_package': 'targetPackage',
        'user': 'user',
        'vm_spec': 'vmSpec'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """CloudTowerApplication - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._entity_async_status = None
        self._id = None
        self._instance_statuses = None
        self._name = None
        self._package = None
        self._placement_situation = None
        self._placement_verb = None
        self._resource_version = None
        self._state = None
        self._target_package = None
        self._user = None
        self._vm_spec = None
        self.discriminator = None

        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "instance_statuses" in kwargs:
            self.instance_statuses = kwargs["instance_statuses"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.package = kwargs.get("package", None)
        self.placement_situation = kwargs.get("placement_situation", None)
        self.placement_verb = kwargs.get("placement_verb", None)
        if "resource_version" in kwargs:
            self.resource_version = kwargs["resource_version"]
        self.state = kwargs.get("state", None)
        if "target_package" in kwargs:
            self.target_package = kwargs["target_package"]
        self.user = kwargs.get("user", None)
        if "vm_spec" in kwargs:
            self.vm_spec = kwargs["vm_spec"]

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this CloudTowerApplication.  # noqa: E501


        :return: The entity_async_status of this CloudTowerApplication.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this CloudTowerApplication.


        :param entity_async_status: The entity_async_status of this CloudTowerApplication.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def id(self):
        """Gets the id of this CloudTowerApplication.  # noqa: E501


        :return: The id of this CloudTowerApplication.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CloudTowerApplication.


        :param id: The id of this CloudTowerApplication.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def instance_statuses(self):
        """Gets the instance_statuses of this CloudTowerApplication.  # noqa: E501


        :return: The instance_statuses of this CloudTowerApplication.  # noqa: E501
        :rtype: object
        """
        return self._instance_statuses

    @instance_statuses.setter
    def instance_statuses(self, instance_statuses):
        """Sets the instance_statuses of this CloudTowerApplication.


        :param instance_statuses: The instance_statuses of this CloudTowerApplication.  # noqa: E501
        :type instance_statuses: object
        """
        if self.local_vars_configuration.client_side_validation and instance_statuses is None:  # noqa: E501
            raise ValueError("Invalid value for `instance_statuses`, must not be `None`")  # noqa: E501

        self._instance_statuses = instance_statuses

    @property
    def name(self):
        """Gets the name of this CloudTowerApplication.  # noqa: E501


        :return: The name of this CloudTowerApplication.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CloudTowerApplication.


        :param name: The name of this CloudTowerApplication.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def package(self):
        """Gets the package of this CloudTowerApplication.  # noqa: E501


        :return: The package of this CloudTowerApplication.  # noqa: E501
        :rtype: NestedCloudTowerApplicationPackage
        """
        return self._package

    @package.setter
    def package(self, package):
        """Sets the package of this CloudTowerApplication.


        :param package: The package of this CloudTowerApplication.  # noqa: E501
        :type package: NestedCloudTowerApplicationPackage
        """

        self._package = package

    @property
    def placement_situation(self):
        """Gets the placement_situation of this CloudTowerApplication.  # noqa: E501


        :return: The placement_situation of this CloudTowerApplication.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation

    @placement_situation.setter
    def placement_situation(self, placement_situation):
        """Sets the placement_situation of this CloudTowerApplication.


        :param placement_situation: The placement_situation of this CloudTowerApplication.  # noqa: E501
        :type placement_situation: str
        """

        self._placement_situation = placement_situation

    @property
    def placement_verb(self):
        """Gets the placement_verb of this CloudTowerApplication.  # noqa: E501


        :return: The placement_verb of this CloudTowerApplication.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb

    @placement_verb.setter
    def placement_verb(self, placement_verb):
        """Sets the placement_verb of this CloudTowerApplication.


        :param placement_verb: The placement_verb of this CloudTowerApplication.  # noqa: E501
        :type placement_verb: str
        """

        self._placement_verb = placement_verb

    @property
    def resource_version(self):
        """Gets the resource_version of this CloudTowerApplication.  # noqa: E501


        :return: The resource_version of this CloudTowerApplication.  # noqa: E501
        :rtype: int
        """
        return self._resource_version

    @resource_version.setter
    def resource_version(self, resource_version):
        """Sets the resource_version of this CloudTowerApplication.


        :param resource_version: The resource_version of this CloudTowerApplication.  # noqa: E501
        :type resource_version: int
        """
        if self.local_vars_configuration.client_side_validation and resource_version is None:  # noqa: E501
            raise ValueError("Invalid value for `resource_version`, must not be `None`")  # noqa: E501

        self._resource_version = resource_version

    @property
    def state(self):
        """Gets the state of this CloudTowerApplication.  # noqa: E501


        :return: The state of this CloudTowerApplication.  # noqa: E501
        :rtype: CloudTowerApplicationState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this CloudTowerApplication.


        :param state: The state of this CloudTowerApplication.  # noqa: E501
        :type state: CloudTowerApplicationState
        """

        self._state = state

    @property
    def target_package(self):
        """Gets the target_package of this CloudTowerApplication.  # noqa: E501


        :return: The target_package of this CloudTowerApplication.  # noqa: E501
        :rtype: str
        """
        return self._target_package

    @target_package.setter
    def target_package(self, target_package):
        """Sets the target_package of this CloudTowerApplication.


        :param target_package: The target_package of this CloudTowerApplication.  # noqa: E501
        :type target_package: str
        """
        if self.local_vars_configuration.client_side_validation and target_package is None:  # noqa: E501
            raise ValueError("Invalid value for `target_package`, must not be `None`")  # noqa: E501

        self._target_package = target_package

    @property
    def user(self):
        """Gets the user of this CloudTowerApplication.  # noqa: E501


        :return: The user of this CloudTowerApplication.  # noqa: E501
        :rtype: NestedUser
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this CloudTowerApplication.


        :param user: The user of this CloudTowerApplication.  # noqa: E501
        :type user: NestedUser
        """

        self._user = user

    @property
    def vm_spec(self):
        """Gets the vm_spec of this CloudTowerApplication.  # noqa: E501


        :return: The vm_spec of this CloudTowerApplication.  # noqa: E501
        :rtype: object
        """
        return self._vm_spec

    @vm_spec.setter
    def vm_spec(self, vm_spec):
        """Sets the vm_spec of this CloudTowerApplication.


        :param vm_spec: The vm_spec of this CloudTowerApplication.  # noqa: E501
        :type vm_spec: object
        """
        if self.local_vars_configuration.client_side_validation and vm_spec is None:  # noqa: E501
            raise ValueError("Invalid value for `vm_spec`, must not be `None`")  # noqa: E501

        self._vm_spec = vm_spec

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CloudTowerApplication):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CloudTowerApplication):
            return True

        return self.to_dict() != other.to_dict()
