# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class CloudTowerApplicationPackage(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'applications': 'list[NestedCloudTowerApplication]',
        'architecture': 'Architecture',
        'containers': 'object',
        'id': 'str',
        'images': 'object',
        'name': 'str',
        'scos_version': 'str',
        'version': 'str'
    }

    attribute_map = {
        'applications': 'applications',
        'architecture': 'architecture',
        'containers': 'containers',
        'id': 'id',
        'images': 'images',
        'name': 'name',
        'scos_version': 'scosVersion',
        'version': 'version'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """CloudTowerApplicationPackage - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._applications = None
        self._architecture = None
        self._containers = None
        self._id = None
        self._images = None
        self._name = None
        self._scos_version = None
        self._version = None
        self.discriminator = None

        self.applications = kwargs.get("applications", None)
        if "architecture" in kwargs:
            self.architecture = kwargs["architecture"]
        if "containers" in kwargs:
            self.containers = kwargs["containers"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "images" in kwargs:
            self.images = kwargs["images"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "scos_version" in kwargs:
            self.scos_version = kwargs["scos_version"]
        if "version" in kwargs:
            self.version = kwargs["version"]

    @property
    def applications(self):
        """Gets the applications of this CloudTowerApplicationPackage.  # noqa: E501


        :return: The applications of this CloudTowerApplicationPackage.  # noqa: E501
        :rtype: list[NestedCloudTowerApplication]
        """
        return self._applications

    @applications.setter
    def applications(self, applications):
        """Sets the applications of this CloudTowerApplicationPackage.


        :param applications: The applications of this CloudTowerApplicationPackage.  # noqa: E501
        :type applications: list[NestedCloudTowerApplication]
        """

        self._applications = applications

    @property
    def architecture(self):
        """Gets the architecture of this CloudTowerApplicationPackage.  # noqa: E501


        :return: The architecture of this CloudTowerApplicationPackage.  # noqa: E501
        :rtype: Architecture
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """Sets the architecture of this CloudTowerApplicationPackage.


        :param architecture: The architecture of this CloudTowerApplicationPackage.  # noqa: E501
        :type architecture: Architecture
        """
        if self.local_vars_configuration.client_side_validation and architecture is None:  # noqa: E501
            raise ValueError("Invalid value for `architecture`, must not be `None`")  # noqa: E501

        self._architecture = architecture

    @property
    def containers(self):
        """Gets the containers of this CloudTowerApplicationPackage.  # noqa: E501


        :return: The containers of this CloudTowerApplicationPackage.  # noqa: E501
        :rtype: object
        """
        return self._containers

    @containers.setter
    def containers(self, containers):
        """Sets the containers of this CloudTowerApplicationPackage.


        :param containers: The containers of this CloudTowerApplicationPackage.  # noqa: E501
        :type containers: object
        """
        if self.local_vars_configuration.client_side_validation and containers is None:  # noqa: E501
            raise ValueError("Invalid value for `containers`, must not be `None`")  # noqa: E501

        self._containers = containers

    @property
    def id(self):
        """Gets the id of this CloudTowerApplicationPackage.  # noqa: E501


        :return: The id of this CloudTowerApplicationPackage.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CloudTowerApplicationPackage.


        :param id: The id of this CloudTowerApplicationPackage.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def images(self):
        """Gets the images of this CloudTowerApplicationPackage.  # noqa: E501


        :return: The images of this CloudTowerApplicationPackage.  # noqa: E501
        :rtype: object
        """
        return self._images

    @images.setter
    def images(self, images):
        """Sets the images of this CloudTowerApplicationPackage.


        :param images: The images of this CloudTowerApplicationPackage.  # noqa: E501
        :type images: object
        """
        if self.local_vars_configuration.client_side_validation and images is None:  # noqa: E501
            raise ValueError("Invalid value for `images`, must not be `None`")  # noqa: E501

        self._images = images

    @property
    def name(self):
        """Gets the name of this CloudTowerApplicationPackage.  # noqa: E501


        :return: The name of this CloudTowerApplicationPackage.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CloudTowerApplicationPackage.


        :param name: The name of this CloudTowerApplicationPackage.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def scos_version(self):
        """Gets the scos_version of this CloudTowerApplicationPackage.  # noqa: E501


        :return: The scos_version of this CloudTowerApplicationPackage.  # noqa: E501
        :rtype: str
        """
        return self._scos_version

    @scos_version.setter
    def scos_version(self, scos_version):
        """Sets the scos_version of this CloudTowerApplicationPackage.


        :param scos_version: The scos_version of this CloudTowerApplicationPackage.  # noqa: E501
        :type scos_version: str
        """
        if self.local_vars_configuration.client_side_validation and scos_version is None:  # noqa: E501
            raise ValueError("Invalid value for `scos_version`, must not be `None`")  # noqa: E501

        self._scos_version = scos_version

    @property
    def version(self):
        """Gets the version of this CloudTowerApplicationPackage.  # noqa: E501


        :return: The version of this CloudTowerApplicationPackage.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this CloudTowerApplicationPackage.


        :param version: The version of this CloudTowerApplicationPackage.  # noqa: E501
        :type version: str
        """
        if self.local_vars_configuration.client_side_validation and version is None:  # noqa: E501
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CloudTowerApplicationPackage):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CloudTowerApplicationPackage):
            return True

        return self.to_dict() != other.to_dict()
