# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class CloudTowerApplicationPackageWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[CloudTowerApplicationPackageWhereInput]',
        '_not': 'list[CloudTowerApplicationPackageWhereInput]',
        '_or': 'list[CloudTowerApplicationPackageWhereInput]',
        'applications_every': 'CloudTowerApplicationWhereInput',
        'applications_none': 'CloudTowerApplicationWhereInput',
        'applications_some': 'CloudTowerApplicationWhereInput',
        'architecture': 'Architecture',
        'architecture_in': 'list[Architecture]',
        'architecture_not': 'Architecture',
        'architecture_not_in': 'list[Architecture]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'scos_version': 'str',
        'scos_version_contains': 'str',
        'scos_version_ends_with': 'str',
        'scos_version_gt': 'str',
        'scos_version_gte': 'str',
        'scos_version_in': 'list[str]',
        'scos_version_lt': 'str',
        'scos_version_lte': 'str',
        'scos_version_not': 'str',
        'scos_version_not_contains': 'str',
        'scos_version_not_ends_with': 'str',
        'scos_version_not_in': 'list[str]',
        'scos_version_not_starts_with': 'str',
        'scos_version_starts_with': 'str',
        'version': 'str',
        'version_contains': 'str',
        'version_ends_with': 'str',
        'version_gt': 'str',
        'version_gte': 'str',
        'version_in': 'list[str]',
        'version_lt': 'str',
        'version_lte': 'str',
        'version_not': 'str',
        'version_not_contains': 'str',
        'version_not_ends_with': 'str',
        'version_not_in': 'list[str]',
        'version_not_starts_with': 'str',
        'version_starts_with': 'str'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'applications_every': 'applications_every',
        'applications_none': 'applications_none',
        'applications_some': 'applications_some',
        'architecture': 'architecture',
        'architecture_in': 'architecture_in',
        'architecture_not': 'architecture_not',
        'architecture_not_in': 'architecture_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'scos_version': 'scosVersion',
        'scos_version_contains': 'scosVersion_contains',
        'scos_version_ends_with': 'scosVersion_ends_with',
        'scos_version_gt': 'scosVersion_gt',
        'scos_version_gte': 'scosVersion_gte',
        'scos_version_in': 'scosVersion_in',
        'scos_version_lt': 'scosVersion_lt',
        'scos_version_lte': 'scosVersion_lte',
        'scos_version_not': 'scosVersion_not',
        'scos_version_not_contains': 'scosVersion_not_contains',
        'scos_version_not_ends_with': 'scosVersion_not_ends_with',
        'scos_version_not_in': 'scosVersion_not_in',
        'scos_version_not_starts_with': 'scosVersion_not_starts_with',
        'scos_version_starts_with': 'scosVersion_starts_with',
        'version': 'version',
        'version_contains': 'version_contains',
        'version_ends_with': 'version_ends_with',
        'version_gt': 'version_gt',
        'version_gte': 'version_gte',
        'version_in': 'version_in',
        'version_lt': 'version_lt',
        'version_lte': 'version_lte',
        'version_not': 'version_not',
        'version_not_contains': 'version_not_contains',
        'version_not_ends_with': 'version_not_ends_with',
        'version_not_in': 'version_not_in',
        'version_not_starts_with': 'version_not_starts_with',
        'version_starts_with': 'version_starts_with'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """CloudTowerApplicationPackageWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._applications_every = None
        self._applications_none = None
        self._applications_some = None
        self._architecture = None
        self._architecture_in = None
        self._architecture_not = None
        self._architecture_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._scos_version = None
        self._scos_version_contains = None
        self._scos_version_ends_with = None
        self._scos_version_gt = None
        self._scos_version_gte = None
        self._scos_version_in = None
        self._scos_version_lt = None
        self._scos_version_lte = None
        self._scos_version_not = None
        self._scos_version_not_contains = None
        self._scos_version_not_ends_with = None
        self._scos_version_not_in = None
        self._scos_version_not_starts_with = None
        self._scos_version_starts_with = None
        self._version = None
        self._version_contains = None
        self._version_ends_with = None
        self._version_gt = None
        self._version_gte = None
        self._version_in = None
        self._version_lt = None
        self._version_lte = None
        self._version_not = None
        self._version_not_contains = None
        self._version_not_ends_with = None
        self._version_not_in = None
        self._version_not_starts_with = None
        self._version_starts_with = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.applications_every = kwargs.get("applications_every", None)
        self.applications_none = kwargs.get("applications_none", None)
        self.applications_some = kwargs.get("applications_some", None)
        self.architecture = kwargs.get("architecture", None)
        self.architecture_in = kwargs.get("architecture_in", None)
        self.architecture_not = kwargs.get("architecture_not", None)
        self.architecture_not_in = kwargs.get("architecture_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.scos_version = kwargs.get("scos_version", None)
        self.scos_version_contains = kwargs.get("scos_version_contains", None)
        self.scos_version_ends_with = kwargs.get("scos_version_ends_with", None)
        self.scos_version_gt = kwargs.get("scos_version_gt", None)
        self.scos_version_gte = kwargs.get("scos_version_gte", None)
        self.scos_version_in = kwargs.get("scos_version_in", None)
        self.scos_version_lt = kwargs.get("scos_version_lt", None)
        self.scos_version_lte = kwargs.get("scos_version_lte", None)
        self.scos_version_not = kwargs.get("scos_version_not", None)
        self.scos_version_not_contains = kwargs.get("scos_version_not_contains", None)
        self.scos_version_not_ends_with = kwargs.get("scos_version_not_ends_with", None)
        self.scos_version_not_in = kwargs.get("scos_version_not_in", None)
        self.scos_version_not_starts_with = kwargs.get("scos_version_not_starts_with", None)
        self.scos_version_starts_with = kwargs.get("scos_version_starts_with", None)
        self.version = kwargs.get("version", None)
        self.version_contains = kwargs.get("version_contains", None)
        self.version_ends_with = kwargs.get("version_ends_with", None)
        self.version_gt = kwargs.get("version_gt", None)
        self.version_gte = kwargs.get("version_gte", None)
        self.version_in = kwargs.get("version_in", None)
        self.version_lt = kwargs.get("version_lt", None)
        self.version_lte = kwargs.get("version_lte", None)
        self.version_not = kwargs.get("version_not", None)
        self.version_not_contains = kwargs.get("version_not_contains", None)
        self.version_not_ends_with = kwargs.get("version_not_ends_with", None)
        self.version_not_in = kwargs.get("version_not_in", None)
        self.version_not_starts_with = kwargs.get("version_not_starts_with", None)
        self.version_starts_with = kwargs.get("version_starts_with", None)

    @property
    def _and(self):
        """Gets the _and of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The _and of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[CloudTowerApplicationPackageWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this CloudTowerApplicationPackageWhereInput.


        :param _and: The _and of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type _and: list[CloudTowerApplicationPackageWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The _not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[CloudTowerApplicationPackageWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this CloudTowerApplicationPackageWhereInput.


        :param _not: The _not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type _not: list[CloudTowerApplicationPackageWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The _or of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[CloudTowerApplicationPackageWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this CloudTowerApplicationPackageWhereInput.


        :param _or: The _or of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type _or: list[CloudTowerApplicationPackageWhereInput]
        """

        self.__or = _or

    @property
    def applications_every(self):
        """Gets the applications_every of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The applications_every of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: CloudTowerApplicationWhereInput
        """
        return self._applications_every

    @applications_every.setter
    def applications_every(self, applications_every):
        """Sets the applications_every of this CloudTowerApplicationPackageWhereInput.


        :param applications_every: The applications_every of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type applications_every: CloudTowerApplicationWhereInput
        """

        self._applications_every = applications_every

    @property
    def applications_none(self):
        """Gets the applications_none of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The applications_none of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: CloudTowerApplicationWhereInput
        """
        return self._applications_none

    @applications_none.setter
    def applications_none(self, applications_none):
        """Sets the applications_none of this CloudTowerApplicationPackageWhereInput.


        :param applications_none: The applications_none of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type applications_none: CloudTowerApplicationWhereInput
        """

        self._applications_none = applications_none

    @property
    def applications_some(self):
        """Gets the applications_some of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The applications_some of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: CloudTowerApplicationWhereInput
        """
        return self._applications_some

    @applications_some.setter
    def applications_some(self, applications_some):
        """Sets the applications_some of this CloudTowerApplicationPackageWhereInput.


        :param applications_some: The applications_some of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type applications_some: CloudTowerApplicationWhereInput
        """

        self._applications_some = applications_some

    @property
    def architecture(self):
        """Gets the architecture of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The architecture of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: Architecture
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """Sets the architecture of this CloudTowerApplicationPackageWhereInput.


        :param architecture: The architecture of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type architecture: Architecture
        """

        self._architecture = architecture

    @property
    def architecture_in(self):
        """Gets the architecture_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The architecture_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[Architecture]
        """
        return self._architecture_in

    @architecture_in.setter
    def architecture_in(self, architecture_in):
        """Sets the architecture_in of this CloudTowerApplicationPackageWhereInput.


        :param architecture_in: The architecture_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type architecture_in: list[Architecture]
        """

        self._architecture_in = architecture_in

    @property
    def architecture_not(self):
        """Gets the architecture_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The architecture_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: Architecture
        """
        return self._architecture_not

    @architecture_not.setter
    def architecture_not(self, architecture_not):
        """Sets the architecture_not of this CloudTowerApplicationPackageWhereInput.


        :param architecture_not: The architecture_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type architecture_not: Architecture
        """

        self._architecture_not = architecture_not

    @property
    def architecture_not_in(self):
        """Gets the architecture_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The architecture_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[Architecture]
        """
        return self._architecture_not_in

    @architecture_not_in.setter
    def architecture_not_in(self, architecture_not_in):
        """Sets the architecture_not_in of this CloudTowerApplicationPackageWhereInput.


        :param architecture_not_in: The architecture_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type architecture_not_in: list[Architecture]
        """

        self._architecture_not_in = architecture_not_in

    @property
    def id(self):
        """Gets the id of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CloudTowerApplicationPackageWhereInput.


        :param id: The id of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this CloudTowerApplicationPackageWhereInput.


        :param id_contains: The id_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this CloudTowerApplicationPackageWhereInput.


        :param id_ends_with: The id_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this CloudTowerApplicationPackageWhereInput.


        :param id_gt: The id_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this CloudTowerApplicationPackageWhereInput.


        :param id_gte: The id_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this CloudTowerApplicationPackageWhereInput.


        :param id_in: The id_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this CloudTowerApplicationPackageWhereInput.


        :param id_lt: The id_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this CloudTowerApplicationPackageWhereInput.


        :param id_lte: The id_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this CloudTowerApplicationPackageWhereInput.


        :param id_not: The id_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this CloudTowerApplicationPackageWhereInput.


        :param id_not_contains: The id_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this CloudTowerApplicationPackageWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this CloudTowerApplicationPackageWhereInput.


        :param id_not_in: The id_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this CloudTowerApplicationPackageWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The id_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this CloudTowerApplicationPackageWhereInput.


        :param id_starts_with: The id_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def name(self):
        """Gets the name of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CloudTowerApplicationPackageWhereInput.


        :param name: The name of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this CloudTowerApplicationPackageWhereInput.


        :param name_contains: The name_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this CloudTowerApplicationPackageWhereInput.


        :param name_ends_with: The name_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this CloudTowerApplicationPackageWhereInput.


        :param name_gt: The name_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this CloudTowerApplicationPackageWhereInput.


        :param name_gte: The name_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this CloudTowerApplicationPackageWhereInput.


        :param name_in: The name_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this CloudTowerApplicationPackageWhereInput.


        :param name_lt: The name_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this CloudTowerApplicationPackageWhereInput.


        :param name_lte: The name_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this CloudTowerApplicationPackageWhereInput.


        :param name_not: The name_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this CloudTowerApplicationPackageWhereInput.


        :param name_not_contains: The name_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this CloudTowerApplicationPackageWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this CloudTowerApplicationPackageWhereInput.


        :param name_not_in: The name_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this CloudTowerApplicationPackageWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The name_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this CloudTowerApplicationPackageWhereInput.


        :param name_starts_with: The name_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def scos_version(self):
        """Gets the scos_version of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version

    @scos_version.setter
    def scos_version(self, scos_version):
        """Sets the scos_version of this CloudTowerApplicationPackageWhereInput.


        :param scos_version: The scos_version of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version: str
        """

        self._scos_version = scos_version

    @property
    def scos_version_contains(self):
        """Gets the scos_version_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version_contains

    @scos_version_contains.setter
    def scos_version_contains(self, scos_version_contains):
        """Sets the scos_version_contains of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_contains: The scos_version_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_contains: str
        """

        self._scos_version_contains = scos_version_contains

    @property
    def scos_version_ends_with(self):
        """Gets the scos_version_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version_ends_with

    @scos_version_ends_with.setter
    def scos_version_ends_with(self, scos_version_ends_with):
        """Sets the scos_version_ends_with of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_ends_with: The scos_version_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_ends_with: str
        """

        self._scos_version_ends_with = scos_version_ends_with

    @property
    def scos_version_gt(self):
        """Gets the scos_version_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version_gt

    @scos_version_gt.setter
    def scos_version_gt(self, scos_version_gt):
        """Sets the scos_version_gt of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_gt: The scos_version_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_gt: str
        """

        self._scos_version_gt = scos_version_gt

    @property
    def scos_version_gte(self):
        """Gets the scos_version_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version_gte

    @scos_version_gte.setter
    def scos_version_gte(self, scos_version_gte):
        """Sets the scos_version_gte of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_gte: The scos_version_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_gte: str
        """

        self._scos_version_gte = scos_version_gte

    @property
    def scos_version_in(self):
        """Gets the scos_version_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._scos_version_in

    @scos_version_in.setter
    def scos_version_in(self, scos_version_in):
        """Sets the scos_version_in of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_in: The scos_version_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_in: list[str]
        """

        self._scos_version_in = scos_version_in

    @property
    def scos_version_lt(self):
        """Gets the scos_version_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version_lt

    @scos_version_lt.setter
    def scos_version_lt(self, scos_version_lt):
        """Sets the scos_version_lt of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_lt: The scos_version_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_lt: str
        """

        self._scos_version_lt = scos_version_lt

    @property
    def scos_version_lte(self):
        """Gets the scos_version_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version_lte

    @scos_version_lte.setter
    def scos_version_lte(self, scos_version_lte):
        """Sets the scos_version_lte of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_lte: The scos_version_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_lte: str
        """

        self._scos_version_lte = scos_version_lte

    @property
    def scos_version_not(self):
        """Gets the scos_version_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version_not

    @scos_version_not.setter
    def scos_version_not(self, scos_version_not):
        """Sets the scos_version_not of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_not: The scos_version_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_not: str
        """

        self._scos_version_not = scos_version_not

    @property
    def scos_version_not_contains(self):
        """Gets the scos_version_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version_not_contains

    @scos_version_not_contains.setter
    def scos_version_not_contains(self, scos_version_not_contains):
        """Sets the scos_version_not_contains of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_not_contains: The scos_version_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_not_contains: str
        """

        self._scos_version_not_contains = scos_version_not_contains

    @property
    def scos_version_not_ends_with(self):
        """Gets the scos_version_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version_not_ends_with

    @scos_version_not_ends_with.setter
    def scos_version_not_ends_with(self, scos_version_not_ends_with):
        """Sets the scos_version_not_ends_with of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_not_ends_with: The scos_version_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_not_ends_with: str
        """

        self._scos_version_not_ends_with = scos_version_not_ends_with

    @property
    def scos_version_not_in(self):
        """Gets the scos_version_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._scos_version_not_in

    @scos_version_not_in.setter
    def scos_version_not_in(self, scos_version_not_in):
        """Sets the scos_version_not_in of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_not_in: The scos_version_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_not_in: list[str]
        """

        self._scos_version_not_in = scos_version_not_in

    @property
    def scos_version_not_starts_with(self):
        """Gets the scos_version_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version_not_starts_with

    @scos_version_not_starts_with.setter
    def scos_version_not_starts_with(self, scos_version_not_starts_with):
        """Sets the scos_version_not_starts_with of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_not_starts_with: The scos_version_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_not_starts_with: str
        """

        self._scos_version_not_starts_with = scos_version_not_starts_with

    @property
    def scos_version_starts_with(self):
        """Gets the scos_version_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The scos_version_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._scos_version_starts_with

    @scos_version_starts_with.setter
    def scos_version_starts_with(self, scos_version_starts_with):
        """Sets the scos_version_starts_with of this CloudTowerApplicationPackageWhereInput.


        :param scos_version_starts_with: The scos_version_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type scos_version_starts_with: str
        """

        self._scos_version_starts_with = scos_version_starts_with

    @property
    def version(self):
        """Gets the version of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this CloudTowerApplicationPackageWhereInput.


        :param version: The version of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def version_contains(self):
        """Gets the version_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_contains

    @version_contains.setter
    def version_contains(self, version_contains):
        """Sets the version_contains of this CloudTowerApplicationPackageWhereInput.


        :param version_contains: The version_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_contains: str
        """

        self._version_contains = version_contains

    @property
    def version_ends_with(self):
        """Gets the version_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_ends_with

    @version_ends_with.setter
    def version_ends_with(self, version_ends_with):
        """Sets the version_ends_with of this CloudTowerApplicationPackageWhereInput.


        :param version_ends_with: The version_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_ends_with: str
        """

        self._version_ends_with = version_ends_with

    @property
    def version_gt(self):
        """Gets the version_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_gt

    @version_gt.setter
    def version_gt(self, version_gt):
        """Sets the version_gt of this CloudTowerApplicationPackageWhereInput.


        :param version_gt: The version_gt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_gt: str
        """

        self._version_gt = version_gt

    @property
    def version_gte(self):
        """Gets the version_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_gte

    @version_gte.setter
    def version_gte(self, version_gte):
        """Sets the version_gte of this CloudTowerApplicationPackageWhereInput.


        :param version_gte: The version_gte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_gte: str
        """

        self._version_gte = version_gte

    @property
    def version_in(self):
        """Gets the version_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._version_in

    @version_in.setter
    def version_in(self, version_in):
        """Sets the version_in of this CloudTowerApplicationPackageWhereInput.


        :param version_in: The version_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_in: list[str]
        """

        self._version_in = version_in

    @property
    def version_lt(self):
        """Gets the version_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_lt

    @version_lt.setter
    def version_lt(self, version_lt):
        """Sets the version_lt of this CloudTowerApplicationPackageWhereInput.


        :param version_lt: The version_lt of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_lt: str
        """

        self._version_lt = version_lt

    @property
    def version_lte(self):
        """Gets the version_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_lte

    @version_lte.setter
    def version_lte(self, version_lte):
        """Sets the version_lte of this CloudTowerApplicationPackageWhereInput.


        :param version_lte: The version_lte of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_lte: str
        """

        self._version_lte = version_lte

    @property
    def version_not(self):
        """Gets the version_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not

    @version_not.setter
    def version_not(self, version_not):
        """Sets the version_not of this CloudTowerApplicationPackageWhereInput.


        :param version_not: The version_not of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_not: str
        """

        self._version_not = version_not

    @property
    def version_not_contains(self):
        """Gets the version_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not_contains

    @version_not_contains.setter
    def version_not_contains(self, version_not_contains):
        """Sets the version_not_contains of this CloudTowerApplicationPackageWhereInput.


        :param version_not_contains: The version_not_contains of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_not_contains: str
        """

        self._version_not_contains = version_not_contains

    @property
    def version_not_ends_with(self):
        """Gets the version_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not_ends_with

    @version_not_ends_with.setter
    def version_not_ends_with(self, version_not_ends_with):
        """Sets the version_not_ends_with of this CloudTowerApplicationPackageWhereInput.


        :param version_not_ends_with: The version_not_ends_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_not_ends_with: str
        """

        self._version_not_ends_with = version_not_ends_with

    @property
    def version_not_in(self):
        """Gets the version_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._version_not_in

    @version_not_in.setter
    def version_not_in(self, version_not_in):
        """Sets the version_not_in of this CloudTowerApplicationPackageWhereInput.


        :param version_not_in: The version_not_in of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_not_in: list[str]
        """

        self._version_not_in = version_not_in

    @property
    def version_not_starts_with(self):
        """Gets the version_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_not_starts_with

    @version_not_starts_with.setter
    def version_not_starts_with(self, version_not_starts_with):
        """Sets the version_not_starts_with of this CloudTowerApplicationPackageWhereInput.


        :param version_not_starts_with: The version_not_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_not_starts_with: str
        """

        self._version_not_starts_with = version_not_starts_with

    @property
    def version_starts_with(self):
        """Gets the version_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501


        :return: The version_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._version_starts_with

    @version_starts_with.setter
    def version_starts_with(self, version_starts_with):
        """Sets the version_starts_with of this CloudTowerApplicationPackageWhereInput.


        :param version_starts_with: The version_starts_with of this CloudTowerApplicationPackageWhereInput.  # noqa: E501
        :type version_starts_with: str
        """

        self._version_starts_with = version_starts_with

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CloudTowerApplicationPackageWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CloudTowerApplicationPackageWhereInput):
            return True

        return self.to_dict() != other.to_dict()
