# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class CloudTowerApplicationWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[CloudTowerApplicationWhereInput]',
        '_not': 'list[CloudTowerApplicationWhereInput]',
        '_or': 'list[CloudTowerApplicationWhereInput]',
        'entity_async_status': 'EntityAsyncStatus',
        'entity_async_status_in': 'list[EntityAsyncStatus]',
        'entity_async_status_not': 'EntityAsyncStatus',
        'entity_async_status_not_in': 'list[EntityAsyncStatus]',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str',
        'name': 'str',
        'name_contains': 'str',
        'name_ends_with': 'str',
        'name_gt': 'str',
        'name_gte': 'str',
        'name_in': 'list[str]',
        'name_lt': 'str',
        'name_lte': 'str',
        'name_not': 'str',
        'name_not_contains': 'str',
        'name_not_ends_with': 'str',
        'name_not_in': 'list[str]',
        'name_not_starts_with': 'str',
        'name_starts_with': 'str',
        'package': 'CloudTowerApplicationPackageWhereInput',
        'placement_situation': 'str',
        'placement_situation_contains': 'str',
        'placement_situation_ends_with': 'str',
        'placement_situation_gt': 'str',
        'placement_situation_gte': 'str',
        'placement_situation_in': 'list[str]',
        'placement_situation_lt': 'str',
        'placement_situation_lte': 'str',
        'placement_situation_not': 'str',
        'placement_situation_not_contains': 'str',
        'placement_situation_not_ends_with': 'str',
        'placement_situation_not_in': 'list[str]',
        'placement_situation_not_starts_with': 'str',
        'placement_situation_starts_with': 'str',
        'placement_verb': 'str',
        'placement_verb_contains': 'str',
        'placement_verb_ends_with': 'str',
        'placement_verb_gt': 'str',
        'placement_verb_gte': 'str',
        'placement_verb_in': 'list[str]',
        'placement_verb_lt': 'str',
        'placement_verb_lte': 'str',
        'placement_verb_not': 'str',
        'placement_verb_not_contains': 'str',
        'placement_verb_not_ends_with': 'str',
        'placement_verb_not_in': 'list[str]',
        'placement_verb_not_starts_with': 'str',
        'placement_verb_starts_with': 'str',
        'resource_version': 'int',
        'resource_version_gt': 'int',
        'resource_version_gte': 'int',
        'resource_version_in': 'list[int]',
        'resource_version_lt': 'int',
        'resource_version_lte': 'int',
        'resource_version_not': 'int',
        'resource_version_not_in': 'list[int]',
        'state': 'CloudTowerApplicationState',
        'state_in': 'list[CloudTowerApplicationState]',
        'state_not': 'CloudTowerApplicationState',
        'state_not_in': 'list[CloudTowerApplicationState]',
        'target_package': 'str',
        'target_package_contains': 'str',
        'target_package_ends_with': 'str',
        'target_package_gt': 'str',
        'target_package_gte': 'str',
        'target_package_in': 'list[str]',
        'target_package_lt': 'str',
        'target_package_lte': 'str',
        'target_package_not': 'str',
        'target_package_not_contains': 'str',
        'target_package_not_ends_with': 'str',
        'target_package_not_in': 'list[str]',
        'target_package_not_starts_with': 'str',
        'target_package_starts_with': 'str',
        'user': 'UserWhereInput'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'entity_async_status': 'entityAsyncStatus',
        'entity_async_status_in': 'entityAsyncStatus_in',
        'entity_async_status_not': 'entityAsyncStatus_not',
        'entity_async_status_not_in': 'entityAsyncStatus_not_in',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with',
        'name': 'name',
        'name_contains': 'name_contains',
        'name_ends_with': 'name_ends_with',
        'name_gt': 'name_gt',
        'name_gte': 'name_gte',
        'name_in': 'name_in',
        'name_lt': 'name_lt',
        'name_lte': 'name_lte',
        'name_not': 'name_not',
        'name_not_contains': 'name_not_contains',
        'name_not_ends_with': 'name_not_ends_with',
        'name_not_in': 'name_not_in',
        'name_not_starts_with': 'name_not_starts_with',
        'name_starts_with': 'name_starts_with',
        'package': 'package',
        'placement_situation': 'placementSituation',
        'placement_situation_contains': 'placementSituation_contains',
        'placement_situation_ends_with': 'placementSituation_ends_with',
        'placement_situation_gt': 'placementSituation_gt',
        'placement_situation_gte': 'placementSituation_gte',
        'placement_situation_in': 'placementSituation_in',
        'placement_situation_lt': 'placementSituation_lt',
        'placement_situation_lte': 'placementSituation_lte',
        'placement_situation_not': 'placementSituation_not',
        'placement_situation_not_contains': 'placementSituation_not_contains',
        'placement_situation_not_ends_with': 'placementSituation_not_ends_with',
        'placement_situation_not_in': 'placementSituation_not_in',
        'placement_situation_not_starts_with': 'placementSituation_not_starts_with',
        'placement_situation_starts_with': 'placementSituation_starts_with',
        'placement_verb': 'placementVerb',
        'placement_verb_contains': 'placementVerb_contains',
        'placement_verb_ends_with': 'placementVerb_ends_with',
        'placement_verb_gt': 'placementVerb_gt',
        'placement_verb_gte': 'placementVerb_gte',
        'placement_verb_in': 'placementVerb_in',
        'placement_verb_lt': 'placementVerb_lt',
        'placement_verb_lte': 'placementVerb_lte',
        'placement_verb_not': 'placementVerb_not',
        'placement_verb_not_contains': 'placementVerb_not_contains',
        'placement_verb_not_ends_with': 'placementVerb_not_ends_with',
        'placement_verb_not_in': 'placementVerb_not_in',
        'placement_verb_not_starts_with': 'placementVerb_not_starts_with',
        'placement_verb_starts_with': 'placementVerb_starts_with',
        'resource_version': 'resourceVersion',
        'resource_version_gt': 'resourceVersion_gt',
        'resource_version_gte': 'resourceVersion_gte',
        'resource_version_in': 'resourceVersion_in',
        'resource_version_lt': 'resourceVersion_lt',
        'resource_version_lte': 'resourceVersion_lte',
        'resource_version_not': 'resourceVersion_not',
        'resource_version_not_in': 'resourceVersion_not_in',
        'state': 'state',
        'state_in': 'state_in',
        'state_not': 'state_not',
        'state_not_in': 'state_not_in',
        'target_package': 'targetPackage',
        'target_package_contains': 'targetPackage_contains',
        'target_package_ends_with': 'targetPackage_ends_with',
        'target_package_gt': 'targetPackage_gt',
        'target_package_gte': 'targetPackage_gte',
        'target_package_in': 'targetPackage_in',
        'target_package_lt': 'targetPackage_lt',
        'target_package_lte': 'targetPackage_lte',
        'target_package_not': 'targetPackage_not',
        'target_package_not_contains': 'targetPackage_not_contains',
        'target_package_not_ends_with': 'targetPackage_not_ends_with',
        'target_package_not_in': 'targetPackage_not_in',
        'target_package_not_starts_with': 'targetPackage_not_starts_with',
        'target_package_starts_with': 'targetPackage_starts_with',
        'user': 'user'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """CloudTowerApplicationWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._entity_async_status = None
        self._entity_async_status_in = None
        self._entity_async_status_not = None
        self._entity_async_status_not_in = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self._name = None
        self._name_contains = None
        self._name_ends_with = None
        self._name_gt = None
        self._name_gte = None
        self._name_in = None
        self._name_lt = None
        self._name_lte = None
        self._name_not = None
        self._name_not_contains = None
        self._name_not_ends_with = None
        self._name_not_in = None
        self._name_not_starts_with = None
        self._name_starts_with = None
        self._package = None
        self._placement_situation = None
        self._placement_situation_contains = None
        self._placement_situation_ends_with = None
        self._placement_situation_gt = None
        self._placement_situation_gte = None
        self._placement_situation_in = None
        self._placement_situation_lt = None
        self._placement_situation_lte = None
        self._placement_situation_not = None
        self._placement_situation_not_contains = None
        self._placement_situation_not_ends_with = None
        self._placement_situation_not_in = None
        self._placement_situation_not_starts_with = None
        self._placement_situation_starts_with = None
        self._placement_verb = None
        self._placement_verb_contains = None
        self._placement_verb_ends_with = None
        self._placement_verb_gt = None
        self._placement_verb_gte = None
        self._placement_verb_in = None
        self._placement_verb_lt = None
        self._placement_verb_lte = None
        self._placement_verb_not = None
        self._placement_verb_not_contains = None
        self._placement_verb_not_ends_with = None
        self._placement_verb_not_in = None
        self._placement_verb_not_starts_with = None
        self._placement_verb_starts_with = None
        self._resource_version = None
        self._resource_version_gt = None
        self._resource_version_gte = None
        self._resource_version_in = None
        self._resource_version_lt = None
        self._resource_version_lte = None
        self._resource_version_not = None
        self._resource_version_not_in = None
        self._state = None
        self._state_in = None
        self._state_not = None
        self._state_not_in = None
        self._target_package = None
        self._target_package_contains = None
        self._target_package_ends_with = None
        self._target_package_gt = None
        self._target_package_gte = None
        self._target_package_in = None
        self._target_package_lt = None
        self._target_package_lte = None
        self._target_package_not = None
        self._target_package_not_contains = None
        self._target_package_not_ends_with = None
        self._target_package_not_in = None
        self._target_package_not_starts_with = None
        self._target_package_starts_with = None
        self._user = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.entity_async_status_in = kwargs.get("entity_async_status_in", None)
        self.entity_async_status_not = kwargs.get("entity_async_status_not", None)
        self.entity_async_status_not_in = kwargs.get("entity_async_status_not_in", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)
        self.name = kwargs.get("name", None)
        self.name_contains = kwargs.get("name_contains", None)
        self.name_ends_with = kwargs.get("name_ends_with", None)
        self.name_gt = kwargs.get("name_gt", None)
        self.name_gte = kwargs.get("name_gte", None)
        self.name_in = kwargs.get("name_in", None)
        self.name_lt = kwargs.get("name_lt", None)
        self.name_lte = kwargs.get("name_lte", None)
        self.name_not = kwargs.get("name_not", None)
        self.name_not_contains = kwargs.get("name_not_contains", None)
        self.name_not_ends_with = kwargs.get("name_not_ends_with", None)
        self.name_not_in = kwargs.get("name_not_in", None)
        self.name_not_starts_with = kwargs.get("name_not_starts_with", None)
        self.name_starts_with = kwargs.get("name_starts_with", None)
        self.package = kwargs.get("package", None)
        self.placement_situation = kwargs.get("placement_situation", None)
        self.placement_situation_contains = kwargs.get("placement_situation_contains", None)
        self.placement_situation_ends_with = kwargs.get("placement_situation_ends_with", None)
        self.placement_situation_gt = kwargs.get("placement_situation_gt", None)
        self.placement_situation_gte = kwargs.get("placement_situation_gte", None)
        self.placement_situation_in = kwargs.get("placement_situation_in", None)
        self.placement_situation_lt = kwargs.get("placement_situation_lt", None)
        self.placement_situation_lte = kwargs.get("placement_situation_lte", None)
        self.placement_situation_not = kwargs.get("placement_situation_not", None)
        self.placement_situation_not_contains = kwargs.get("placement_situation_not_contains", None)
        self.placement_situation_not_ends_with = kwargs.get("placement_situation_not_ends_with", None)
        self.placement_situation_not_in = kwargs.get("placement_situation_not_in", None)
        self.placement_situation_not_starts_with = kwargs.get("placement_situation_not_starts_with", None)
        self.placement_situation_starts_with = kwargs.get("placement_situation_starts_with", None)
        self.placement_verb = kwargs.get("placement_verb", None)
        self.placement_verb_contains = kwargs.get("placement_verb_contains", None)
        self.placement_verb_ends_with = kwargs.get("placement_verb_ends_with", None)
        self.placement_verb_gt = kwargs.get("placement_verb_gt", None)
        self.placement_verb_gte = kwargs.get("placement_verb_gte", None)
        self.placement_verb_in = kwargs.get("placement_verb_in", None)
        self.placement_verb_lt = kwargs.get("placement_verb_lt", None)
        self.placement_verb_lte = kwargs.get("placement_verb_lte", None)
        self.placement_verb_not = kwargs.get("placement_verb_not", None)
        self.placement_verb_not_contains = kwargs.get("placement_verb_not_contains", None)
        self.placement_verb_not_ends_with = kwargs.get("placement_verb_not_ends_with", None)
        self.placement_verb_not_in = kwargs.get("placement_verb_not_in", None)
        self.placement_verb_not_starts_with = kwargs.get("placement_verb_not_starts_with", None)
        self.placement_verb_starts_with = kwargs.get("placement_verb_starts_with", None)
        self.resource_version = kwargs.get("resource_version", None)
        self.resource_version_gt = kwargs.get("resource_version_gt", None)
        self.resource_version_gte = kwargs.get("resource_version_gte", None)
        self.resource_version_in = kwargs.get("resource_version_in", None)
        self.resource_version_lt = kwargs.get("resource_version_lt", None)
        self.resource_version_lte = kwargs.get("resource_version_lte", None)
        self.resource_version_not = kwargs.get("resource_version_not", None)
        self.resource_version_not_in = kwargs.get("resource_version_not_in", None)
        self.state = kwargs.get("state", None)
        self.state_in = kwargs.get("state_in", None)
        self.state_not = kwargs.get("state_not", None)
        self.state_not_in = kwargs.get("state_not_in", None)
        self.target_package = kwargs.get("target_package", None)
        self.target_package_contains = kwargs.get("target_package_contains", None)
        self.target_package_ends_with = kwargs.get("target_package_ends_with", None)
        self.target_package_gt = kwargs.get("target_package_gt", None)
        self.target_package_gte = kwargs.get("target_package_gte", None)
        self.target_package_in = kwargs.get("target_package_in", None)
        self.target_package_lt = kwargs.get("target_package_lt", None)
        self.target_package_lte = kwargs.get("target_package_lte", None)
        self.target_package_not = kwargs.get("target_package_not", None)
        self.target_package_not_contains = kwargs.get("target_package_not_contains", None)
        self.target_package_not_ends_with = kwargs.get("target_package_not_ends_with", None)
        self.target_package_not_in = kwargs.get("target_package_not_in", None)
        self.target_package_not_starts_with = kwargs.get("target_package_not_starts_with", None)
        self.target_package_starts_with = kwargs.get("target_package_starts_with", None)
        self.user = kwargs.get("user", None)

    @property
    def _and(self):
        """Gets the _and of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The _and of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[CloudTowerApplicationWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this CloudTowerApplicationWhereInput.


        :param _and: The _and of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type _and: list[CloudTowerApplicationWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The _not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[CloudTowerApplicationWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this CloudTowerApplicationWhereInput.


        :param _not: The _not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type _not: list[CloudTowerApplicationWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The _or of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[CloudTowerApplicationWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this CloudTowerApplicationWhereInput.


        :param _or: The _or of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type _or: list[CloudTowerApplicationWhereInput]
        """

        self.__or = _or

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The entity_async_status of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this CloudTowerApplicationWhereInput.


        :param entity_async_status: The entity_async_status of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def entity_async_status_in(self):
        """Gets the entity_async_status_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The entity_async_status_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_in

    @entity_async_status_in.setter
    def entity_async_status_in(self, entity_async_status_in):
        """Sets the entity_async_status_in of this CloudTowerApplicationWhereInput.


        :param entity_async_status_in: The entity_async_status_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type entity_async_status_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_in = entity_async_status_in

    @property
    def entity_async_status_not(self):
        """Gets the entity_async_status_not of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The entity_async_status_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status_not

    @entity_async_status_not.setter
    def entity_async_status_not(self, entity_async_status_not):
        """Sets the entity_async_status_not of this CloudTowerApplicationWhereInput.


        :param entity_async_status_not: The entity_async_status_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type entity_async_status_not: EntityAsyncStatus
        """

        self._entity_async_status_not = entity_async_status_not

    @property
    def entity_async_status_not_in(self):
        """Gets the entity_async_status_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The entity_async_status_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[EntityAsyncStatus]
        """
        return self._entity_async_status_not_in

    @entity_async_status_not_in.setter
    def entity_async_status_not_in(self, entity_async_status_not_in):
        """Sets the entity_async_status_not_in of this CloudTowerApplicationWhereInput.


        :param entity_async_status_not_in: The entity_async_status_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type entity_async_status_not_in: list[EntityAsyncStatus]
        """

        self._entity_async_status_not_in = entity_async_status_not_in

    @property
    def id(self):
        """Gets the id of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CloudTowerApplicationWhereInput.


        :param id: The id of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this CloudTowerApplicationWhereInput.


        :param id_contains: The id_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this CloudTowerApplicationWhereInput.


        :param id_ends_with: The id_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this CloudTowerApplicationWhereInput.


        :param id_gt: The id_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this CloudTowerApplicationWhereInput.


        :param id_gte: The id_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this CloudTowerApplicationWhereInput.


        :param id_in: The id_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this CloudTowerApplicationWhereInput.


        :param id_lt: The id_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this CloudTowerApplicationWhereInput.


        :param id_lte: The id_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this CloudTowerApplicationWhereInput.


        :param id_not: The id_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this CloudTowerApplicationWhereInput.


        :param id_not_contains: The id_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this CloudTowerApplicationWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this CloudTowerApplicationWhereInput.


        :param id_not_in: The id_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this CloudTowerApplicationWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The id_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this CloudTowerApplicationWhereInput.


        :param id_starts_with: The id_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    @property
    def name(self):
        """Gets the name of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CloudTowerApplicationWhereInput.


        :param name: The name of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def name_contains(self):
        """Gets the name_contains of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_contains

    @name_contains.setter
    def name_contains(self, name_contains):
        """Sets the name_contains of this CloudTowerApplicationWhereInput.


        :param name_contains: The name_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_contains: str
        """

        self._name_contains = name_contains

    @property
    def name_ends_with(self):
        """Gets the name_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_ends_with

    @name_ends_with.setter
    def name_ends_with(self, name_ends_with):
        """Sets the name_ends_with of this CloudTowerApplicationWhereInput.


        :param name_ends_with: The name_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_ends_with: str
        """

        self._name_ends_with = name_ends_with

    @property
    def name_gt(self):
        """Gets the name_gt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gt

    @name_gt.setter
    def name_gt(self, name_gt):
        """Sets the name_gt of this CloudTowerApplicationWhereInput.


        :param name_gt: The name_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_gt: str
        """

        self._name_gt = name_gt

    @property
    def name_gte(self):
        """Gets the name_gte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_gte

    @name_gte.setter
    def name_gte(self, name_gte):
        """Sets the name_gte of this CloudTowerApplicationWhereInput.


        :param name_gte: The name_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_gte: str
        """

        self._name_gte = name_gte

    @property
    def name_in(self):
        """Gets the name_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_in

    @name_in.setter
    def name_in(self, name_in):
        """Sets the name_in of this CloudTowerApplicationWhereInput.


        :param name_in: The name_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_in: list[str]
        """

        self._name_in = name_in

    @property
    def name_lt(self):
        """Gets the name_lt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lt

    @name_lt.setter
    def name_lt(self, name_lt):
        """Sets the name_lt of this CloudTowerApplicationWhereInput.


        :param name_lt: The name_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_lt: str
        """

        self._name_lt = name_lt

    @property
    def name_lte(self):
        """Gets the name_lte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_lte

    @name_lte.setter
    def name_lte(self, name_lte):
        """Sets the name_lte of this CloudTowerApplicationWhereInput.


        :param name_lte: The name_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_lte: str
        """

        self._name_lte = name_lte

    @property
    def name_not(self):
        """Gets the name_not of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not

    @name_not.setter
    def name_not(self, name_not):
        """Sets the name_not of this CloudTowerApplicationWhereInput.


        :param name_not: The name_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_not: str
        """

        self._name_not = name_not

    @property
    def name_not_contains(self):
        """Gets the name_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_contains

    @name_not_contains.setter
    def name_not_contains(self, name_not_contains):
        """Sets the name_not_contains of this CloudTowerApplicationWhereInput.


        :param name_not_contains: The name_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_not_contains: str
        """

        self._name_not_contains = name_not_contains

    @property
    def name_not_ends_with(self):
        """Gets the name_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_ends_with

    @name_not_ends_with.setter
    def name_not_ends_with(self, name_not_ends_with):
        """Sets the name_not_ends_with of this CloudTowerApplicationWhereInput.


        :param name_not_ends_with: The name_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_not_ends_with: str
        """

        self._name_not_ends_with = name_not_ends_with

    @property
    def name_not_in(self):
        """Gets the name_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._name_not_in

    @name_not_in.setter
    def name_not_in(self, name_not_in):
        """Sets the name_not_in of this CloudTowerApplicationWhereInput.


        :param name_not_in: The name_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_not_in: list[str]
        """

        self._name_not_in = name_not_in

    @property
    def name_not_starts_with(self):
        """Gets the name_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_not_starts_with

    @name_not_starts_with.setter
    def name_not_starts_with(self, name_not_starts_with):
        """Sets the name_not_starts_with of this CloudTowerApplicationWhereInput.


        :param name_not_starts_with: The name_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_not_starts_with: str
        """

        self._name_not_starts_with = name_not_starts_with

    @property
    def name_starts_with(self):
        """Gets the name_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The name_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._name_starts_with

    @name_starts_with.setter
    def name_starts_with(self, name_starts_with):
        """Sets the name_starts_with of this CloudTowerApplicationWhereInput.


        :param name_starts_with: The name_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type name_starts_with: str
        """

        self._name_starts_with = name_starts_with

    @property
    def package(self):
        """Gets the package of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The package of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: CloudTowerApplicationPackageWhereInput
        """
        return self._package

    @package.setter
    def package(self, package):
        """Sets the package of this CloudTowerApplicationWhereInput.


        :param package: The package of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type package: CloudTowerApplicationPackageWhereInput
        """

        self._package = package

    @property
    def placement_situation(self):
        """Gets the placement_situation of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation

    @placement_situation.setter
    def placement_situation(self, placement_situation):
        """Sets the placement_situation of this CloudTowerApplicationWhereInput.


        :param placement_situation: The placement_situation of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation: str
        """

        self._placement_situation = placement_situation

    @property
    def placement_situation_contains(self):
        """Gets the placement_situation_contains of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation_contains

    @placement_situation_contains.setter
    def placement_situation_contains(self, placement_situation_contains):
        """Sets the placement_situation_contains of this CloudTowerApplicationWhereInput.


        :param placement_situation_contains: The placement_situation_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_contains: str
        """

        self._placement_situation_contains = placement_situation_contains

    @property
    def placement_situation_ends_with(self):
        """Gets the placement_situation_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation_ends_with

    @placement_situation_ends_with.setter
    def placement_situation_ends_with(self, placement_situation_ends_with):
        """Sets the placement_situation_ends_with of this CloudTowerApplicationWhereInput.


        :param placement_situation_ends_with: The placement_situation_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_ends_with: str
        """

        self._placement_situation_ends_with = placement_situation_ends_with

    @property
    def placement_situation_gt(self):
        """Gets the placement_situation_gt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation_gt

    @placement_situation_gt.setter
    def placement_situation_gt(self, placement_situation_gt):
        """Sets the placement_situation_gt of this CloudTowerApplicationWhereInput.


        :param placement_situation_gt: The placement_situation_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_gt: str
        """

        self._placement_situation_gt = placement_situation_gt

    @property
    def placement_situation_gte(self):
        """Gets the placement_situation_gte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation_gte

    @placement_situation_gte.setter
    def placement_situation_gte(self, placement_situation_gte):
        """Sets the placement_situation_gte of this CloudTowerApplicationWhereInput.


        :param placement_situation_gte: The placement_situation_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_gte: str
        """

        self._placement_situation_gte = placement_situation_gte

    @property
    def placement_situation_in(self):
        """Gets the placement_situation_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._placement_situation_in

    @placement_situation_in.setter
    def placement_situation_in(self, placement_situation_in):
        """Sets the placement_situation_in of this CloudTowerApplicationWhereInput.


        :param placement_situation_in: The placement_situation_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_in: list[str]
        """

        self._placement_situation_in = placement_situation_in

    @property
    def placement_situation_lt(self):
        """Gets the placement_situation_lt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation_lt

    @placement_situation_lt.setter
    def placement_situation_lt(self, placement_situation_lt):
        """Sets the placement_situation_lt of this CloudTowerApplicationWhereInput.


        :param placement_situation_lt: The placement_situation_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_lt: str
        """

        self._placement_situation_lt = placement_situation_lt

    @property
    def placement_situation_lte(self):
        """Gets the placement_situation_lte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation_lte

    @placement_situation_lte.setter
    def placement_situation_lte(self, placement_situation_lte):
        """Sets the placement_situation_lte of this CloudTowerApplicationWhereInput.


        :param placement_situation_lte: The placement_situation_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_lte: str
        """

        self._placement_situation_lte = placement_situation_lte

    @property
    def placement_situation_not(self):
        """Gets the placement_situation_not of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation_not

    @placement_situation_not.setter
    def placement_situation_not(self, placement_situation_not):
        """Sets the placement_situation_not of this CloudTowerApplicationWhereInput.


        :param placement_situation_not: The placement_situation_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_not: str
        """

        self._placement_situation_not = placement_situation_not

    @property
    def placement_situation_not_contains(self):
        """Gets the placement_situation_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation_not_contains

    @placement_situation_not_contains.setter
    def placement_situation_not_contains(self, placement_situation_not_contains):
        """Sets the placement_situation_not_contains of this CloudTowerApplicationWhereInput.


        :param placement_situation_not_contains: The placement_situation_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_not_contains: str
        """

        self._placement_situation_not_contains = placement_situation_not_contains

    @property
    def placement_situation_not_ends_with(self):
        """Gets the placement_situation_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation_not_ends_with

    @placement_situation_not_ends_with.setter
    def placement_situation_not_ends_with(self, placement_situation_not_ends_with):
        """Sets the placement_situation_not_ends_with of this CloudTowerApplicationWhereInput.


        :param placement_situation_not_ends_with: The placement_situation_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_not_ends_with: str
        """

        self._placement_situation_not_ends_with = placement_situation_not_ends_with

    @property
    def placement_situation_not_in(self):
        """Gets the placement_situation_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._placement_situation_not_in

    @placement_situation_not_in.setter
    def placement_situation_not_in(self, placement_situation_not_in):
        """Sets the placement_situation_not_in of this CloudTowerApplicationWhereInput.


        :param placement_situation_not_in: The placement_situation_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_not_in: list[str]
        """

        self._placement_situation_not_in = placement_situation_not_in

    @property
    def placement_situation_not_starts_with(self):
        """Gets the placement_situation_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation_not_starts_with

    @placement_situation_not_starts_with.setter
    def placement_situation_not_starts_with(self, placement_situation_not_starts_with):
        """Sets the placement_situation_not_starts_with of this CloudTowerApplicationWhereInput.


        :param placement_situation_not_starts_with: The placement_situation_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_not_starts_with: str
        """

        self._placement_situation_not_starts_with = placement_situation_not_starts_with

    @property
    def placement_situation_starts_with(self):
        """Gets the placement_situation_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_situation_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_situation_starts_with

    @placement_situation_starts_with.setter
    def placement_situation_starts_with(self, placement_situation_starts_with):
        """Sets the placement_situation_starts_with of this CloudTowerApplicationWhereInput.


        :param placement_situation_starts_with: The placement_situation_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_situation_starts_with: str
        """

        self._placement_situation_starts_with = placement_situation_starts_with

    @property
    def placement_verb(self):
        """Gets the placement_verb of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb

    @placement_verb.setter
    def placement_verb(self, placement_verb):
        """Sets the placement_verb of this CloudTowerApplicationWhereInput.


        :param placement_verb: The placement_verb of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb: str
        """

        self._placement_verb = placement_verb

    @property
    def placement_verb_contains(self):
        """Gets the placement_verb_contains of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb_contains

    @placement_verb_contains.setter
    def placement_verb_contains(self, placement_verb_contains):
        """Sets the placement_verb_contains of this CloudTowerApplicationWhereInput.


        :param placement_verb_contains: The placement_verb_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_contains: str
        """

        self._placement_verb_contains = placement_verb_contains

    @property
    def placement_verb_ends_with(self):
        """Gets the placement_verb_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb_ends_with

    @placement_verb_ends_with.setter
    def placement_verb_ends_with(self, placement_verb_ends_with):
        """Sets the placement_verb_ends_with of this CloudTowerApplicationWhereInput.


        :param placement_verb_ends_with: The placement_verb_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_ends_with: str
        """

        self._placement_verb_ends_with = placement_verb_ends_with

    @property
    def placement_verb_gt(self):
        """Gets the placement_verb_gt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb_gt

    @placement_verb_gt.setter
    def placement_verb_gt(self, placement_verb_gt):
        """Sets the placement_verb_gt of this CloudTowerApplicationWhereInput.


        :param placement_verb_gt: The placement_verb_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_gt: str
        """

        self._placement_verb_gt = placement_verb_gt

    @property
    def placement_verb_gte(self):
        """Gets the placement_verb_gte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb_gte

    @placement_verb_gte.setter
    def placement_verb_gte(self, placement_verb_gte):
        """Sets the placement_verb_gte of this CloudTowerApplicationWhereInput.


        :param placement_verb_gte: The placement_verb_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_gte: str
        """

        self._placement_verb_gte = placement_verb_gte

    @property
    def placement_verb_in(self):
        """Gets the placement_verb_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._placement_verb_in

    @placement_verb_in.setter
    def placement_verb_in(self, placement_verb_in):
        """Sets the placement_verb_in of this CloudTowerApplicationWhereInput.


        :param placement_verb_in: The placement_verb_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_in: list[str]
        """

        self._placement_verb_in = placement_verb_in

    @property
    def placement_verb_lt(self):
        """Gets the placement_verb_lt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb_lt

    @placement_verb_lt.setter
    def placement_verb_lt(self, placement_verb_lt):
        """Sets the placement_verb_lt of this CloudTowerApplicationWhereInput.


        :param placement_verb_lt: The placement_verb_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_lt: str
        """

        self._placement_verb_lt = placement_verb_lt

    @property
    def placement_verb_lte(self):
        """Gets the placement_verb_lte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb_lte

    @placement_verb_lte.setter
    def placement_verb_lte(self, placement_verb_lte):
        """Sets the placement_verb_lte of this CloudTowerApplicationWhereInput.


        :param placement_verb_lte: The placement_verb_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_lte: str
        """

        self._placement_verb_lte = placement_verb_lte

    @property
    def placement_verb_not(self):
        """Gets the placement_verb_not of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb_not

    @placement_verb_not.setter
    def placement_verb_not(self, placement_verb_not):
        """Sets the placement_verb_not of this CloudTowerApplicationWhereInput.


        :param placement_verb_not: The placement_verb_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_not: str
        """

        self._placement_verb_not = placement_verb_not

    @property
    def placement_verb_not_contains(self):
        """Gets the placement_verb_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb_not_contains

    @placement_verb_not_contains.setter
    def placement_verb_not_contains(self, placement_verb_not_contains):
        """Sets the placement_verb_not_contains of this CloudTowerApplicationWhereInput.


        :param placement_verb_not_contains: The placement_verb_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_not_contains: str
        """

        self._placement_verb_not_contains = placement_verb_not_contains

    @property
    def placement_verb_not_ends_with(self):
        """Gets the placement_verb_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb_not_ends_with

    @placement_verb_not_ends_with.setter
    def placement_verb_not_ends_with(self, placement_verb_not_ends_with):
        """Sets the placement_verb_not_ends_with of this CloudTowerApplicationWhereInput.


        :param placement_verb_not_ends_with: The placement_verb_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_not_ends_with: str
        """

        self._placement_verb_not_ends_with = placement_verb_not_ends_with

    @property
    def placement_verb_not_in(self):
        """Gets the placement_verb_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._placement_verb_not_in

    @placement_verb_not_in.setter
    def placement_verb_not_in(self, placement_verb_not_in):
        """Sets the placement_verb_not_in of this CloudTowerApplicationWhereInput.


        :param placement_verb_not_in: The placement_verb_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_not_in: list[str]
        """

        self._placement_verb_not_in = placement_verb_not_in

    @property
    def placement_verb_not_starts_with(self):
        """Gets the placement_verb_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb_not_starts_with

    @placement_verb_not_starts_with.setter
    def placement_verb_not_starts_with(self, placement_verb_not_starts_with):
        """Sets the placement_verb_not_starts_with of this CloudTowerApplicationWhereInput.


        :param placement_verb_not_starts_with: The placement_verb_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_not_starts_with: str
        """

        self._placement_verb_not_starts_with = placement_verb_not_starts_with

    @property
    def placement_verb_starts_with(self):
        """Gets the placement_verb_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The placement_verb_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._placement_verb_starts_with

    @placement_verb_starts_with.setter
    def placement_verb_starts_with(self, placement_verb_starts_with):
        """Sets the placement_verb_starts_with of this CloudTowerApplicationWhereInput.


        :param placement_verb_starts_with: The placement_verb_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type placement_verb_starts_with: str
        """

        self._placement_verb_starts_with = placement_verb_starts_with

    @property
    def resource_version(self):
        """Gets the resource_version of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The resource_version of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version

    @resource_version.setter
    def resource_version(self, resource_version):
        """Sets the resource_version of this CloudTowerApplicationWhereInput.


        :param resource_version: The resource_version of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type resource_version: int
        """

        self._resource_version = resource_version

    @property
    def resource_version_gt(self):
        """Gets the resource_version_gt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The resource_version_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_gt

    @resource_version_gt.setter
    def resource_version_gt(self, resource_version_gt):
        """Sets the resource_version_gt of this CloudTowerApplicationWhereInput.


        :param resource_version_gt: The resource_version_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type resource_version_gt: int
        """

        self._resource_version_gt = resource_version_gt

    @property
    def resource_version_gte(self):
        """Gets the resource_version_gte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The resource_version_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_gte

    @resource_version_gte.setter
    def resource_version_gte(self, resource_version_gte):
        """Sets the resource_version_gte of this CloudTowerApplicationWhereInput.


        :param resource_version_gte: The resource_version_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type resource_version_gte: int
        """

        self._resource_version_gte = resource_version_gte

    @property
    def resource_version_in(self):
        """Gets the resource_version_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The resource_version_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._resource_version_in

    @resource_version_in.setter
    def resource_version_in(self, resource_version_in):
        """Sets the resource_version_in of this CloudTowerApplicationWhereInput.


        :param resource_version_in: The resource_version_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type resource_version_in: list[int]
        """

        self._resource_version_in = resource_version_in

    @property
    def resource_version_lt(self):
        """Gets the resource_version_lt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The resource_version_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_lt

    @resource_version_lt.setter
    def resource_version_lt(self, resource_version_lt):
        """Sets the resource_version_lt of this CloudTowerApplicationWhereInput.


        :param resource_version_lt: The resource_version_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type resource_version_lt: int
        """

        self._resource_version_lt = resource_version_lt

    @property
    def resource_version_lte(self):
        """Gets the resource_version_lte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The resource_version_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_lte

    @resource_version_lte.setter
    def resource_version_lte(self, resource_version_lte):
        """Sets the resource_version_lte of this CloudTowerApplicationWhereInput.


        :param resource_version_lte: The resource_version_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type resource_version_lte: int
        """

        self._resource_version_lte = resource_version_lte

    @property
    def resource_version_not(self):
        """Gets the resource_version_not of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The resource_version_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._resource_version_not

    @resource_version_not.setter
    def resource_version_not(self, resource_version_not):
        """Sets the resource_version_not of this CloudTowerApplicationWhereInput.


        :param resource_version_not: The resource_version_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type resource_version_not: int
        """

        self._resource_version_not = resource_version_not

    @property
    def resource_version_not_in(self):
        """Gets the resource_version_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The resource_version_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._resource_version_not_in

    @resource_version_not_in.setter
    def resource_version_not_in(self, resource_version_not_in):
        """Sets the resource_version_not_in of this CloudTowerApplicationWhereInput.


        :param resource_version_not_in: The resource_version_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type resource_version_not_in: list[int]
        """

        self._resource_version_not_in = resource_version_not_in

    @property
    def state(self):
        """Gets the state of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The state of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: CloudTowerApplicationState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this CloudTowerApplicationWhereInput.


        :param state: The state of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type state: CloudTowerApplicationState
        """

        self._state = state

    @property
    def state_in(self):
        """Gets the state_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The state_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[CloudTowerApplicationState]
        """
        return self._state_in

    @state_in.setter
    def state_in(self, state_in):
        """Sets the state_in of this CloudTowerApplicationWhereInput.


        :param state_in: The state_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type state_in: list[CloudTowerApplicationState]
        """

        self._state_in = state_in

    @property
    def state_not(self):
        """Gets the state_not of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The state_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: CloudTowerApplicationState
        """
        return self._state_not

    @state_not.setter
    def state_not(self, state_not):
        """Sets the state_not of this CloudTowerApplicationWhereInput.


        :param state_not: The state_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type state_not: CloudTowerApplicationState
        """

        self._state_not = state_not

    @property
    def state_not_in(self):
        """Gets the state_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The state_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[CloudTowerApplicationState]
        """
        return self._state_not_in

    @state_not_in.setter
    def state_not_in(self, state_not_in):
        """Sets the state_not_in of this CloudTowerApplicationWhereInput.


        :param state_not_in: The state_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type state_not_in: list[CloudTowerApplicationState]
        """

        self._state_not_in = state_not_in

    @property
    def target_package(self):
        """Gets the target_package of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package

    @target_package.setter
    def target_package(self, target_package):
        """Sets the target_package of this CloudTowerApplicationWhereInput.


        :param target_package: The target_package of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package: str
        """

        self._target_package = target_package

    @property
    def target_package_contains(self):
        """Gets the target_package_contains of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package_contains

    @target_package_contains.setter
    def target_package_contains(self, target_package_contains):
        """Sets the target_package_contains of this CloudTowerApplicationWhereInput.


        :param target_package_contains: The target_package_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_contains: str
        """

        self._target_package_contains = target_package_contains

    @property
    def target_package_ends_with(self):
        """Gets the target_package_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package_ends_with

    @target_package_ends_with.setter
    def target_package_ends_with(self, target_package_ends_with):
        """Sets the target_package_ends_with of this CloudTowerApplicationWhereInput.


        :param target_package_ends_with: The target_package_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_ends_with: str
        """

        self._target_package_ends_with = target_package_ends_with

    @property
    def target_package_gt(self):
        """Gets the target_package_gt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package_gt

    @target_package_gt.setter
    def target_package_gt(self, target_package_gt):
        """Sets the target_package_gt of this CloudTowerApplicationWhereInput.


        :param target_package_gt: The target_package_gt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_gt: str
        """

        self._target_package_gt = target_package_gt

    @property
    def target_package_gte(self):
        """Gets the target_package_gte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package_gte

    @target_package_gte.setter
    def target_package_gte(self, target_package_gte):
        """Sets the target_package_gte of this CloudTowerApplicationWhereInput.


        :param target_package_gte: The target_package_gte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_gte: str
        """

        self._target_package_gte = target_package_gte

    @property
    def target_package_in(self):
        """Gets the target_package_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._target_package_in

    @target_package_in.setter
    def target_package_in(self, target_package_in):
        """Sets the target_package_in of this CloudTowerApplicationWhereInput.


        :param target_package_in: The target_package_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_in: list[str]
        """

        self._target_package_in = target_package_in

    @property
    def target_package_lt(self):
        """Gets the target_package_lt of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package_lt

    @target_package_lt.setter
    def target_package_lt(self, target_package_lt):
        """Sets the target_package_lt of this CloudTowerApplicationWhereInput.


        :param target_package_lt: The target_package_lt of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_lt: str
        """

        self._target_package_lt = target_package_lt

    @property
    def target_package_lte(self):
        """Gets the target_package_lte of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package_lte

    @target_package_lte.setter
    def target_package_lte(self, target_package_lte):
        """Sets the target_package_lte of this CloudTowerApplicationWhereInput.


        :param target_package_lte: The target_package_lte of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_lte: str
        """

        self._target_package_lte = target_package_lte

    @property
    def target_package_not(self):
        """Gets the target_package_not of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package_not

    @target_package_not.setter
    def target_package_not(self, target_package_not):
        """Sets the target_package_not of this CloudTowerApplicationWhereInput.


        :param target_package_not: The target_package_not of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_not: str
        """

        self._target_package_not = target_package_not

    @property
    def target_package_not_contains(self):
        """Gets the target_package_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package_not_contains

    @target_package_not_contains.setter
    def target_package_not_contains(self, target_package_not_contains):
        """Sets the target_package_not_contains of this CloudTowerApplicationWhereInput.


        :param target_package_not_contains: The target_package_not_contains of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_not_contains: str
        """

        self._target_package_not_contains = target_package_not_contains

    @property
    def target_package_not_ends_with(self):
        """Gets the target_package_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package_not_ends_with

    @target_package_not_ends_with.setter
    def target_package_not_ends_with(self, target_package_not_ends_with):
        """Sets the target_package_not_ends_with of this CloudTowerApplicationWhereInput.


        :param target_package_not_ends_with: The target_package_not_ends_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_not_ends_with: str
        """

        self._target_package_not_ends_with = target_package_not_ends_with

    @property
    def target_package_not_in(self):
        """Gets the target_package_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._target_package_not_in

    @target_package_not_in.setter
    def target_package_not_in(self, target_package_not_in):
        """Sets the target_package_not_in of this CloudTowerApplicationWhereInput.


        :param target_package_not_in: The target_package_not_in of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_not_in: list[str]
        """

        self._target_package_not_in = target_package_not_in

    @property
    def target_package_not_starts_with(self):
        """Gets the target_package_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package_not_starts_with

    @target_package_not_starts_with.setter
    def target_package_not_starts_with(self, target_package_not_starts_with):
        """Sets the target_package_not_starts_with of this CloudTowerApplicationWhereInput.


        :param target_package_not_starts_with: The target_package_not_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_not_starts_with: str
        """

        self._target_package_not_starts_with = target_package_not_starts_with

    @property
    def target_package_starts_with(self):
        """Gets the target_package_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The target_package_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._target_package_starts_with

    @target_package_starts_with.setter
    def target_package_starts_with(self, target_package_starts_with):
        """Sets the target_package_starts_with of this CloudTowerApplicationWhereInput.


        :param target_package_starts_with: The target_package_starts_with of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type target_package_starts_with: str
        """

        self._target_package_starts_with = target_package_starts_with

    @property
    def user(self):
        """Gets the user of this CloudTowerApplicationWhereInput.  # noqa: E501


        :return: The user of this CloudTowerApplicationWhereInput.  # noqa: E501
        :rtype: UserWhereInput
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this CloudTowerApplicationWhereInput.


        :param user: The user of this CloudTowerApplicationWhereInput.  # noqa: E501
        :type user: UserWhereInput
        """

        self._user = user

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CloudTowerApplicationWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CloudTowerApplicationWhereInput):
            return True

        return self.to_dict() != other.to_dict()
