# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ClusterNetworkSettingUpdationParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'mgt_ip_mapper': 'list[MgtIpMapper]',
        'mgt_netmask': 'str',
        'mgt_gateway': 'str',
        'ntp_mode': 'NtpMode',
        'ntp_servers': 'list[str]',
        'dns': 'list[str]',
        'iscsi_vip': 'str',
        'management_vip': 'str'
    }

    attribute_map = {
        'mgt_ip_mapper': 'mgt_ip_mapper',
        'mgt_netmask': 'mgt_netmask',
        'mgt_gateway': 'mgt_gateway',
        'ntp_mode': 'ntp_mode',
        'ntp_servers': 'ntp_servers',
        'dns': 'dns',
        'iscsi_vip': 'iscsi_vip',
        'management_vip': 'management_vip'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ClusterNetworkSettingUpdationParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._mgt_ip_mapper = None
        self._mgt_netmask = None
        self._mgt_gateway = None
        self._ntp_mode = None
        self._ntp_servers = None
        self._dns = None
        self._iscsi_vip = None
        self._management_vip = None
        self.discriminator = None

        if "mgt_ip_mapper" in kwargs:
            self.mgt_ip_mapper = kwargs["mgt_ip_mapper"]
        if "mgt_netmask" in kwargs:
            self.mgt_netmask = kwargs["mgt_netmask"]
        if "mgt_gateway" in kwargs:
            self.mgt_gateway = kwargs["mgt_gateway"]
        if "ntp_mode" in kwargs:
            self.ntp_mode = kwargs["ntp_mode"]
        if "ntp_servers" in kwargs:
            self.ntp_servers = kwargs["ntp_servers"]
        if "dns" in kwargs:
            self.dns = kwargs["dns"]
        if "iscsi_vip" in kwargs:
            self.iscsi_vip = kwargs["iscsi_vip"]
        if "management_vip" in kwargs:
            self.management_vip = kwargs["management_vip"]

    @property
    def mgt_ip_mapper(self):
        """Gets the mgt_ip_mapper of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501


        :return: The mgt_ip_mapper of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :rtype: list[MgtIpMapper]
        """
        return self._mgt_ip_mapper

    @mgt_ip_mapper.setter
    def mgt_ip_mapper(self, mgt_ip_mapper):
        """Sets the mgt_ip_mapper of this ClusterNetworkSettingUpdationParamsData.


        :param mgt_ip_mapper: The mgt_ip_mapper of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :type mgt_ip_mapper: list[MgtIpMapper]
        """

        self._mgt_ip_mapper = mgt_ip_mapper

    @property
    def mgt_netmask(self):
        """Gets the mgt_netmask of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501


        :return: The mgt_netmask of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._mgt_netmask

    @mgt_netmask.setter
    def mgt_netmask(self, mgt_netmask):
        """Sets the mgt_netmask of this ClusterNetworkSettingUpdationParamsData.


        :param mgt_netmask: The mgt_netmask of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :type mgt_netmask: str
        """

        self._mgt_netmask = mgt_netmask

    @property
    def mgt_gateway(self):
        """Gets the mgt_gateway of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501


        :return: The mgt_gateway of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._mgt_gateway

    @mgt_gateway.setter
    def mgt_gateway(self, mgt_gateway):
        """Sets the mgt_gateway of this ClusterNetworkSettingUpdationParamsData.


        :param mgt_gateway: The mgt_gateway of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :type mgt_gateway: str
        """

        self._mgt_gateway = mgt_gateway

    @property
    def ntp_mode(self):
        """Gets the ntp_mode of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501


        :return: The ntp_mode of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :rtype: NtpMode
        """
        return self._ntp_mode

    @ntp_mode.setter
    def ntp_mode(self, ntp_mode):
        """Sets the ntp_mode of this ClusterNetworkSettingUpdationParamsData.


        :param ntp_mode: The ntp_mode of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :type ntp_mode: NtpMode
        """

        self._ntp_mode = ntp_mode

    @property
    def ntp_servers(self):
        """Gets the ntp_servers of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501


        :return: The ntp_servers of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :rtype: list[str]
        """
        return self._ntp_servers

    @ntp_servers.setter
    def ntp_servers(self, ntp_servers):
        """Sets the ntp_servers of this ClusterNetworkSettingUpdationParamsData.


        :param ntp_servers: The ntp_servers of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :type ntp_servers: list[str]
        """

        self._ntp_servers = ntp_servers

    @property
    def dns(self):
        """Gets the dns of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501


        :return: The dns of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :rtype: list[str]
        """
        return self._dns

    @dns.setter
    def dns(self, dns):
        """Sets the dns of this ClusterNetworkSettingUpdationParamsData.


        :param dns: The dns of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :type dns: list[str]
        """

        self._dns = dns

    @property
    def iscsi_vip(self):
        """Gets the iscsi_vip of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501


        :return: The iscsi_vip of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_vip

    @iscsi_vip.setter
    def iscsi_vip(self, iscsi_vip):
        """Sets the iscsi_vip of this ClusterNetworkSettingUpdationParamsData.


        :param iscsi_vip: The iscsi_vip of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :type iscsi_vip: str
        """

        self._iscsi_vip = iscsi_vip

    @property
    def management_vip(self):
        """Gets the management_vip of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501


        :return: The management_vip of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._management_vip

    @management_vip.setter
    def management_vip(self, management_vip):
        """Sets the management_vip of this ClusterNetworkSettingUpdationParamsData.


        :param management_vip: The management_vip of this ClusterNetworkSettingUpdationParamsData.  # noqa: E501
        :type management_vip: str
        """

        self._management_vip = management_vip

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterNetworkSettingUpdationParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ClusterNetworkSettingUpdationParamsData):
            return True

        return self.to_dict() != other.to_dict()
