# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ClusterPinInPerformanceInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pin_in_performance_enabled': 'bool',
        'hosts': 'list[HostPinInPerformanceInfo]',
        'total_prio_volume_size': 'int',
        'downgraded_prioritized_space': 'int',
        'allocated_prioritized_space': 'int',
        'planned_prioritized_space': 'int',
        'total_prio_volume_size_usage': 'float',
        'allocated_prioritized_space_usage': 'float',
        'prio_space_percentage': 'float',
        'name': 'str',
        'id': 'str'
    }

    attribute_map = {
        'pin_in_performance_enabled': 'pin_in_performance_enabled',
        'hosts': 'hosts',
        'total_prio_volume_size': 'total_prio_volume_size',
        'downgraded_prioritized_space': 'downgraded_prioritized_space',
        'allocated_prioritized_space': 'allocated_prioritized_space',
        'planned_prioritized_space': 'planned_prioritized_space',
        'total_prio_volume_size_usage': 'total_prio_volume_size_usage',
        'allocated_prioritized_space_usage': 'allocated_prioritized_space_usage',
        'prio_space_percentage': 'prio_space_percentage',
        'name': 'name',
        'id': 'id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ClusterPinInPerformanceInfo - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._pin_in_performance_enabled = None
        self._hosts = None
        self._total_prio_volume_size = None
        self._downgraded_prioritized_space = None
        self._allocated_prioritized_space = None
        self._planned_prioritized_space = None
        self._total_prio_volume_size_usage = None
        self._allocated_prioritized_space_usage = None
        self._prio_space_percentage = None
        self._name = None
        self._id = None
        self.discriminator = None

        self.pin_in_performance_enabled = kwargs.get("pin_in_performance_enabled", None)
        self.hosts = kwargs.get("hosts", None)
        self.total_prio_volume_size = kwargs.get("total_prio_volume_size", None)
        self.downgraded_prioritized_space = kwargs.get("downgraded_prioritized_space", None)
        self.allocated_prioritized_space = kwargs.get("allocated_prioritized_space", None)
        self.planned_prioritized_space = kwargs.get("planned_prioritized_space", None)
        self.total_prio_volume_size_usage = kwargs.get("total_prio_volume_size_usage", None)
        self.allocated_prioritized_space_usage = kwargs.get("allocated_prioritized_space_usage", None)
        self.prio_space_percentage = kwargs.get("prio_space_percentage", None)
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "id" in kwargs:
            self.id = kwargs["id"]

    @property
    def pin_in_performance_enabled(self):
        """Gets the pin_in_performance_enabled of this ClusterPinInPerformanceInfo.  # noqa: E501


        :return: The pin_in_performance_enabled of this ClusterPinInPerformanceInfo.  # noqa: E501
        :rtype: bool
        """
        return self._pin_in_performance_enabled

    @pin_in_performance_enabled.setter
    def pin_in_performance_enabled(self, pin_in_performance_enabled):
        """Sets the pin_in_performance_enabled of this ClusterPinInPerformanceInfo.


        :param pin_in_performance_enabled: The pin_in_performance_enabled of this ClusterPinInPerformanceInfo.  # noqa: E501
        :type pin_in_performance_enabled: bool
        """

        self._pin_in_performance_enabled = pin_in_performance_enabled

    @property
    def hosts(self):
        """Gets the hosts of this ClusterPinInPerformanceInfo.  # noqa: E501


        :return: The hosts of this ClusterPinInPerformanceInfo.  # noqa: E501
        :rtype: list[HostPinInPerformanceInfo]
        """
        return self._hosts

    @hosts.setter
    def hosts(self, hosts):
        """Sets the hosts of this ClusterPinInPerformanceInfo.


        :param hosts: The hosts of this ClusterPinInPerformanceInfo.  # noqa: E501
        :type hosts: list[HostPinInPerformanceInfo]
        """

        self._hosts = hosts

    @property
    def total_prio_volume_size(self):
        """Gets the total_prio_volume_size of this ClusterPinInPerformanceInfo.  # noqa: E501


        :return: The total_prio_volume_size of this ClusterPinInPerformanceInfo.  # noqa: E501
        :rtype: int
        """
        return self._total_prio_volume_size

    @total_prio_volume_size.setter
    def total_prio_volume_size(self, total_prio_volume_size):
        """Sets the total_prio_volume_size of this ClusterPinInPerformanceInfo.


        :param total_prio_volume_size: The total_prio_volume_size of this ClusterPinInPerformanceInfo.  # noqa: E501
        :type total_prio_volume_size: int
        """

        self._total_prio_volume_size = total_prio_volume_size

    @property
    def downgraded_prioritized_space(self):
        """Gets the downgraded_prioritized_space of this ClusterPinInPerformanceInfo.  # noqa: E501


        :return: The downgraded_prioritized_space of this ClusterPinInPerformanceInfo.  # noqa: E501
        :rtype: int
        """
        return self._downgraded_prioritized_space

    @downgraded_prioritized_space.setter
    def downgraded_prioritized_space(self, downgraded_prioritized_space):
        """Sets the downgraded_prioritized_space of this ClusterPinInPerformanceInfo.


        :param downgraded_prioritized_space: The downgraded_prioritized_space of this ClusterPinInPerformanceInfo.  # noqa: E501
        :type downgraded_prioritized_space: int
        """

        self._downgraded_prioritized_space = downgraded_prioritized_space

    @property
    def allocated_prioritized_space(self):
        """Gets the allocated_prioritized_space of this ClusterPinInPerformanceInfo.  # noqa: E501


        :return: The allocated_prioritized_space of this ClusterPinInPerformanceInfo.  # noqa: E501
        :rtype: int
        """
        return self._allocated_prioritized_space

    @allocated_prioritized_space.setter
    def allocated_prioritized_space(self, allocated_prioritized_space):
        """Sets the allocated_prioritized_space of this ClusterPinInPerformanceInfo.


        :param allocated_prioritized_space: The allocated_prioritized_space of this ClusterPinInPerformanceInfo.  # noqa: E501
        :type allocated_prioritized_space: int
        """

        self._allocated_prioritized_space = allocated_prioritized_space

    @property
    def planned_prioritized_space(self):
        """Gets the planned_prioritized_space of this ClusterPinInPerformanceInfo.  # noqa: E501


        :return: The planned_prioritized_space of this ClusterPinInPerformanceInfo.  # noqa: E501
        :rtype: int
        """
        return self._planned_prioritized_space

    @planned_prioritized_space.setter
    def planned_prioritized_space(self, planned_prioritized_space):
        """Sets the planned_prioritized_space of this ClusterPinInPerformanceInfo.


        :param planned_prioritized_space: The planned_prioritized_space of this ClusterPinInPerformanceInfo.  # noqa: E501
        :type planned_prioritized_space: int
        """

        self._planned_prioritized_space = planned_prioritized_space

    @property
    def total_prio_volume_size_usage(self):
        """Gets the total_prio_volume_size_usage of this ClusterPinInPerformanceInfo.  # noqa: E501


        :return: The total_prio_volume_size_usage of this ClusterPinInPerformanceInfo.  # noqa: E501
        :rtype: float
        """
        return self._total_prio_volume_size_usage

    @total_prio_volume_size_usage.setter
    def total_prio_volume_size_usage(self, total_prio_volume_size_usage):
        """Sets the total_prio_volume_size_usage of this ClusterPinInPerformanceInfo.


        :param total_prio_volume_size_usage: The total_prio_volume_size_usage of this ClusterPinInPerformanceInfo.  # noqa: E501
        :type total_prio_volume_size_usage: float
        """

        self._total_prio_volume_size_usage = total_prio_volume_size_usage

    @property
    def allocated_prioritized_space_usage(self):
        """Gets the allocated_prioritized_space_usage of this ClusterPinInPerformanceInfo.  # noqa: E501


        :return: The allocated_prioritized_space_usage of this ClusterPinInPerformanceInfo.  # noqa: E501
        :rtype: float
        """
        return self._allocated_prioritized_space_usage

    @allocated_prioritized_space_usage.setter
    def allocated_prioritized_space_usage(self, allocated_prioritized_space_usage):
        """Sets the allocated_prioritized_space_usage of this ClusterPinInPerformanceInfo.


        :param allocated_prioritized_space_usage: The allocated_prioritized_space_usage of this ClusterPinInPerformanceInfo.  # noqa: E501
        :type allocated_prioritized_space_usage: float
        """

        self._allocated_prioritized_space_usage = allocated_prioritized_space_usage

    @property
    def prio_space_percentage(self):
        """Gets the prio_space_percentage of this ClusterPinInPerformanceInfo.  # noqa: E501


        :return: The prio_space_percentage of this ClusterPinInPerformanceInfo.  # noqa: E501
        :rtype: float
        """
        return self._prio_space_percentage

    @prio_space_percentage.setter
    def prio_space_percentage(self, prio_space_percentage):
        """Sets the prio_space_percentage of this ClusterPinInPerformanceInfo.


        :param prio_space_percentage: The prio_space_percentage of this ClusterPinInPerformanceInfo.  # noqa: E501
        :type prio_space_percentage: float
        """

        self._prio_space_percentage = prio_space_percentage

    @property
    def name(self):
        """Gets the name of this ClusterPinInPerformanceInfo.  # noqa: E501


        :return: The name of this ClusterPinInPerformanceInfo.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ClusterPinInPerformanceInfo.


        :param name: The name of this ClusterPinInPerformanceInfo.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def id(self):
        """Gets the id of this ClusterPinInPerformanceInfo.  # noqa: E501


        :return: The id of this ClusterPinInPerformanceInfo.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ClusterPinInPerformanceInfo.


        :param id: The id of this ClusterPinInPerformanceInfo.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterPinInPerformanceInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ClusterPinInPerformanceInfo):
            return True

        return self.to_dict() != other.to_dict()
