# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ClusterSettings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'NestedCluster',
        'default_ha': 'bool',
        'default_storage_policy': 'VmVolumeElfStoragePolicyType',
        'default_storage_policy_ec_k': 'int',
        'default_storage_policy_ec_m': 'int',
        'default_storage_policy_replica_num': 'int',
        'default_storage_policy_thin_provision': 'bool',
        'enabled_iscsi': 'bool',
        'id': 'str',
        'vm_recycle_bin': 'NestedVmRecycleBin'
    }

    attribute_map = {
        'cluster': 'cluster',
        'default_ha': 'default_ha',
        'default_storage_policy': 'default_storage_policy',
        'default_storage_policy_ec_k': 'default_storage_policy_ec_k',
        'default_storage_policy_ec_m': 'default_storage_policy_ec_m',
        'default_storage_policy_replica_num': 'default_storage_policy_replica_num',
        'default_storage_policy_thin_provision': 'default_storage_policy_thin_provision',
        'enabled_iscsi': 'enabled_iscsi',
        'id': 'id',
        'vm_recycle_bin': 'vm_recycle_bin'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ClusterSettings - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster = None
        self._default_ha = None
        self._default_storage_policy = None
        self._default_storage_policy_ec_k = None
        self._default_storage_policy_ec_m = None
        self._default_storage_policy_replica_num = None
        self._default_storage_policy_thin_provision = None
        self._enabled_iscsi = None
        self._id = None
        self._vm_recycle_bin = None
        self.discriminator = None

        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        self.default_ha = kwargs.get("default_ha", None)
        self.default_storage_policy = kwargs.get("default_storage_policy", None)
        self.default_storage_policy_ec_k = kwargs.get("default_storage_policy_ec_k", None)
        self.default_storage_policy_ec_m = kwargs.get("default_storage_policy_ec_m", None)
        self.default_storage_policy_replica_num = kwargs.get("default_storage_policy_replica_num", None)
        self.default_storage_policy_thin_provision = kwargs.get("default_storage_policy_thin_provision", None)
        self.enabled_iscsi = kwargs.get("enabled_iscsi", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.vm_recycle_bin = kwargs.get("vm_recycle_bin", None)

    @property
    def cluster(self):
        """Gets the cluster of this ClusterSettings.  # noqa: E501


        :return: The cluster of this ClusterSettings.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this ClusterSettings.


        :param cluster: The cluster of this ClusterSettings.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def default_ha(self):
        """Gets the default_ha of this ClusterSettings.  # noqa: E501


        :return: The default_ha of this ClusterSettings.  # noqa: E501
        :rtype: bool
        """
        return self._default_ha

    @default_ha.setter
    def default_ha(self, default_ha):
        """Sets the default_ha of this ClusterSettings.


        :param default_ha: The default_ha of this ClusterSettings.  # noqa: E501
        :type default_ha: bool
        """

        self._default_ha = default_ha

    @property
    def default_storage_policy(self):
        """Gets the default_storage_policy of this ClusterSettings.  # noqa: E501


        :return: The default_storage_policy of this ClusterSettings.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._default_storage_policy

    @default_storage_policy.setter
    def default_storage_policy(self, default_storage_policy):
        """Sets the default_storage_policy of this ClusterSettings.


        :param default_storage_policy: The default_storage_policy of this ClusterSettings.  # noqa: E501
        :type default_storage_policy: VmVolumeElfStoragePolicyType
        """

        self._default_storage_policy = default_storage_policy

    @property
    def default_storage_policy_ec_k(self):
        """Gets the default_storage_policy_ec_k of this ClusterSettings.  # noqa: E501


        :return: The default_storage_policy_ec_k of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_k

    @default_storage_policy_ec_k.setter
    def default_storage_policy_ec_k(self, default_storage_policy_ec_k):
        """Sets the default_storage_policy_ec_k of this ClusterSettings.


        :param default_storage_policy_ec_k: The default_storage_policy_ec_k of this ClusterSettings.  # noqa: E501
        :type default_storage_policy_ec_k: int
        """

        self._default_storage_policy_ec_k = default_storage_policy_ec_k

    @property
    def default_storage_policy_ec_m(self):
        """Gets the default_storage_policy_ec_m of this ClusterSettings.  # noqa: E501


        :return: The default_storage_policy_ec_m of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_m

    @default_storage_policy_ec_m.setter
    def default_storage_policy_ec_m(self, default_storage_policy_ec_m):
        """Sets the default_storage_policy_ec_m of this ClusterSettings.


        :param default_storage_policy_ec_m: The default_storage_policy_ec_m of this ClusterSettings.  # noqa: E501
        :type default_storage_policy_ec_m: int
        """

        self._default_storage_policy_ec_m = default_storage_policy_ec_m

    @property
    def default_storage_policy_replica_num(self):
        """Gets the default_storage_policy_replica_num of this ClusterSettings.  # noqa: E501


        :return: The default_storage_policy_replica_num of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_replica_num

    @default_storage_policy_replica_num.setter
    def default_storage_policy_replica_num(self, default_storage_policy_replica_num):
        """Sets the default_storage_policy_replica_num of this ClusterSettings.


        :param default_storage_policy_replica_num: The default_storage_policy_replica_num of this ClusterSettings.  # noqa: E501
        :type default_storage_policy_replica_num: int
        """

        self._default_storage_policy_replica_num = default_storage_policy_replica_num

    @property
    def default_storage_policy_thin_provision(self):
        """Gets the default_storage_policy_thin_provision of this ClusterSettings.  # noqa: E501


        :return: The default_storage_policy_thin_provision of this ClusterSettings.  # noqa: E501
        :rtype: bool
        """
        return self._default_storage_policy_thin_provision

    @default_storage_policy_thin_provision.setter
    def default_storage_policy_thin_provision(self, default_storage_policy_thin_provision):
        """Sets the default_storage_policy_thin_provision of this ClusterSettings.


        :param default_storage_policy_thin_provision: The default_storage_policy_thin_provision of this ClusterSettings.  # noqa: E501
        :type default_storage_policy_thin_provision: bool
        """

        self._default_storage_policy_thin_provision = default_storage_policy_thin_provision

    @property
    def enabled_iscsi(self):
        """Gets the enabled_iscsi of this ClusterSettings.  # noqa: E501


        :return: The enabled_iscsi of this ClusterSettings.  # noqa: E501
        :rtype: bool
        """
        return self._enabled_iscsi

    @enabled_iscsi.setter
    def enabled_iscsi(self, enabled_iscsi):
        """Sets the enabled_iscsi of this ClusterSettings.


        :param enabled_iscsi: The enabled_iscsi of this ClusterSettings.  # noqa: E501
        :type enabled_iscsi: bool
        """

        self._enabled_iscsi = enabled_iscsi

    @property
    def id(self):
        """Gets the id of this ClusterSettings.  # noqa: E501


        :return: The id of this ClusterSettings.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ClusterSettings.


        :param id: The id of this ClusterSettings.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def vm_recycle_bin(self):
        """Gets the vm_recycle_bin of this ClusterSettings.  # noqa: E501


        :return: The vm_recycle_bin of this ClusterSettings.  # noqa: E501
        :rtype: NestedVmRecycleBin
        """
        return self._vm_recycle_bin

    @vm_recycle_bin.setter
    def vm_recycle_bin(self, vm_recycle_bin):
        """Sets the vm_recycle_bin of this ClusterSettings.


        :param vm_recycle_bin: The vm_recycle_bin of this ClusterSettings.  # noqa: E501
        :type vm_recycle_bin: NestedVmRecycleBin
        """

        self._vm_recycle_bin = vm_recycle_bin

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ClusterSettings):
            return True

        return self.to_dict() != other.to_dict()
