# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ClusterSettingsWhereInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        '_and': 'list[ClusterSettingsWhereInput]',
        '_not': 'list[ClusterSettingsWhereInput]',
        '_or': 'list[ClusterSettingsWhereInput]',
        'cluster': 'ClusterWhereInput',
        'default_ha': 'bool',
        'default_ha_not': 'bool',
        'default_storage_policy': 'VmVolumeElfStoragePolicyType',
        'default_storage_policy_ec_k': 'int',
        'default_storage_policy_ec_k_gt': 'int',
        'default_storage_policy_ec_k_gte': 'int',
        'default_storage_policy_ec_k_in': 'list[int]',
        'default_storage_policy_ec_k_lt': 'int',
        'default_storage_policy_ec_k_lte': 'int',
        'default_storage_policy_ec_k_not': 'int',
        'default_storage_policy_ec_k_not_in': 'list[int]',
        'default_storage_policy_ec_m': 'int',
        'default_storage_policy_ec_m_gt': 'int',
        'default_storage_policy_ec_m_gte': 'int',
        'default_storage_policy_ec_m_in': 'list[int]',
        'default_storage_policy_ec_m_lt': 'int',
        'default_storage_policy_ec_m_lte': 'int',
        'default_storage_policy_ec_m_not': 'int',
        'default_storage_policy_ec_m_not_in': 'list[int]',
        'default_storage_policy_in': 'list[VmVolumeElfStoragePolicyType]',
        'default_storage_policy_not': 'VmVolumeElfStoragePolicyType',
        'default_storage_policy_not_in': 'list[VmVolumeElfStoragePolicyType]',
        'default_storage_policy_replica_num': 'int',
        'default_storage_policy_replica_num_gt': 'int',
        'default_storage_policy_replica_num_gte': 'int',
        'default_storage_policy_replica_num_in': 'list[int]',
        'default_storage_policy_replica_num_lt': 'int',
        'default_storage_policy_replica_num_lte': 'int',
        'default_storage_policy_replica_num_not': 'int',
        'default_storage_policy_replica_num_not_in': 'list[int]',
        'default_storage_policy_thin_provision': 'bool',
        'default_storage_policy_thin_provision_not': 'bool',
        'enabled_iscsi': 'bool',
        'enabled_iscsi_not': 'bool',
        'id': 'str',
        'id_contains': 'str',
        'id_ends_with': 'str',
        'id_gt': 'str',
        'id_gte': 'str',
        'id_in': 'list[str]',
        'id_lt': 'str',
        'id_lte': 'str',
        'id_not': 'str',
        'id_not_contains': 'str',
        'id_not_ends_with': 'str',
        'id_not_in': 'list[str]',
        'id_not_starts_with': 'str',
        'id_starts_with': 'str'
    }

    attribute_map = {
        '_and': 'AND',
        '_not': 'NOT',
        '_or': 'OR',
        'cluster': 'cluster',
        'default_ha': 'default_ha',
        'default_ha_not': 'default_ha_not',
        'default_storage_policy': 'default_storage_policy',
        'default_storage_policy_ec_k': 'default_storage_policy_ec_k',
        'default_storage_policy_ec_k_gt': 'default_storage_policy_ec_k_gt',
        'default_storage_policy_ec_k_gte': 'default_storage_policy_ec_k_gte',
        'default_storage_policy_ec_k_in': 'default_storage_policy_ec_k_in',
        'default_storage_policy_ec_k_lt': 'default_storage_policy_ec_k_lt',
        'default_storage_policy_ec_k_lte': 'default_storage_policy_ec_k_lte',
        'default_storage_policy_ec_k_not': 'default_storage_policy_ec_k_not',
        'default_storage_policy_ec_k_not_in': 'default_storage_policy_ec_k_not_in',
        'default_storage_policy_ec_m': 'default_storage_policy_ec_m',
        'default_storage_policy_ec_m_gt': 'default_storage_policy_ec_m_gt',
        'default_storage_policy_ec_m_gte': 'default_storage_policy_ec_m_gte',
        'default_storage_policy_ec_m_in': 'default_storage_policy_ec_m_in',
        'default_storage_policy_ec_m_lt': 'default_storage_policy_ec_m_lt',
        'default_storage_policy_ec_m_lte': 'default_storage_policy_ec_m_lte',
        'default_storage_policy_ec_m_not': 'default_storage_policy_ec_m_not',
        'default_storage_policy_ec_m_not_in': 'default_storage_policy_ec_m_not_in',
        'default_storage_policy_in': 'default_storage_policy_in',
        'default_storage_policy_not': 'default_storage_policy_not',
        'default_storage_policy_not_in': 'default_storage_policy_not_in',
        'default_storage_policy_replica_num': 'default_storage_policy_replica_num',
        'default_storage_policy_replica_num_gt': 'default_storage_policy_replica_num_gt',
        'default_storage_policy_replica_num_gte': 'default_storage_policy_replica_num_gte',
        'default_storage_policy_replica_num_in': 'default_storage_policy_replica_num_in',
        'default_storage_policy_replica_num_lt': 'default_storage_policy_replica_num_lt',
        'default_storage_policy_replica_num_lte': 'default_storage_policy_replica_num_lte',
        'default_storage_policy_replica_num_not': 'default_storage_policy_replica_num_not',
        'default_storage_policy_replica_num_not_in': 'default_storage_policy_replica_num_not_in',
        'default_storage_policy_thin_provision': 'default_storage_policy_thin_provision',
        'default_storage_policy_thin_provision_not': 'default_storage_policy_thin_provision_not',
        'enabled_iscsi': 'enabled_iscsi',
        'enabled_iscsi_not': 'enabled_iscsi_not',
        'id': 'id',
        'id_contains': 'id_contains',
        'id_ends_with': 'id_ends_with',
        'id_gt': 'id_gt',
        'id_gte': 'id_gte',
        'id_in': 'id_in',
        'id_lt': 'id_lt',
        'id_lte': 'id_lte',
        'id_not': 'id_not',
        'id_not_contains': 'id_not_contains',
        'id_not_ends_with': 'id_not_ends_with',
        'id_not_in': 'id_not_in',
        'id_not_starts_with': 'id_not_starts_with',
        'id_starts_with': 'id_starts_with'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ClusterSettingsWhereInput - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self.__and = None
        self.__not = None
        self.__or = None
        self._cluster = None
        self._default_ha = None
        self._default_ha_not = None
        self._default_storage_policy = None
        self._default_storage_policy_ec_k = None
        self._default_storage_policy_ec_k_gt = None
        self._default_storage_policy_ec_k_gte = None
        self._default_storage_policy_ec_k_in = None
        self._default_storage_policy_ec_k_lt = None
        self._default_storage_policy_ec_k_lte = None
        self._default_storage_policy_ec_k_not = None
        self._default_storage_policy_ec_k_not_in = None
        self._default_storage_policy_ec_m = None
        self._default_storage_policy_ec_m_gt = None
        self._default_storage_policy_ec_m_gte = None
        self._default_storage_policy_ec_m_in = None
        self._default_storage_policy_ec_m_lt = None
        self._default_storage_policy_ec_m_lte = None
        self._default_storage_policy_ec_m_not = None
        self._default_storage_policy_ec_m_not_in = None
        self._default_storage_policy_in = None
        self._default_storage_policy_not = None
        self._default_storage_policy_not_in = None
        self._default_storage_policy_replica_num = None
        self._default_storage_policy_replica_num_gt = None
        self._default_storage_policy_replica_num_gte = None
        self._default_storage_policy_replica_num_in = None
        self._default_storage_policy_replica_num_lt = None
        self._default_storage_policy_replica_num_lte = None
        self._default_storage_policy_replica_num_not = None
        self._default_storage_policy_replica_num_not_in = None
        self._default_storage_policy_thin_provision = None
        self._default_storage_policy_thin_provision_not = None
        self._enabled_iscsi = None
        self._enabled_iscsi_not = None
        self._id = None
        self._id_contains = None
        self._id_ends_with = None
        self._id_gt = None
        self._id_gte = None
        self._id_in = None
        self._id_lt = None
        self._id_lte = None
        self._id_not = None
        self._id_not_contains = None
        self._id_not_ends_with = None
        self._id_not_in = None
        self._id_not_starts_with = None
        self._id_starts_with = None
        self.discriminator = None

        self._and = kwargs.get("_and", None)
        self._not = kwargs.get("_not", None)
        self._or = kwargs.get("_or", None)
        self.cluster = kwargs.get("cluster", None)
        self.default_ha = kwargs.get("default_ha", None)
        self.default_ha_not = kwargs.get("default_ha_not", None)
        self.default_storage_policy = kwargs.get("default_storage_policy", None)
        self.default_storage_policy_ec_k = kwargs.get("default_storage_policy_ec_k", None)
        self.default_storage_policy_ec_k_gt = kwargs.get("default_storage_policy_ec_k_gt", None)
        self.default_storage_policy_ec_k_gte = kwargs.get("default_storage_policy_ec_k_gte", None)
        self.default_storage_policy_ec_k_in = kwargs.get("default_storage_policy_ec_k_in", None)
        self.default_storage_policy_ec_k_lt = kwargs.get("default_storage_policy_ec_k_lt", None)
        self.default_storage_policy_ec_k_lte = kwargs.get("default_storage_policy_ec_k_lte", None)
        self.default_storage_policy_ec_k_not = kwargs.get("default_storage_policy_ec_k_not", None)
        self.default_storage_policy_ec_k_not_in = kwargs.get("default_storage_policy_ec_k_not_in", None)
        self.default_storage_policy_ec_m = kwargs.get("default_storage_policy_ec_m", None)
        self.default_storage_policy_ec_m_gt = kwargs.get("default_storage_policy_ec_m_gt", None)
        self.default_storage_policy_ec_m_gte = kwargs.get("default_storage_policy_ec_m_gte", None)
        self.default_storage_policy_ec_m_in = kwargs.get("default_storage_policy_ec_m_in", None)
        self.default_storage_policy_ec_m_lt = kwargs.get("default_storage_policy_ec_m_lt", None)
        self.default_storage_policy_ec_m_lte = kwargs.get("default_storage_policy_ec_m_lte", None)
        self.default_storage_policy_ec_m_not = kwargs.get("default_storage_policy_ec_m_not", None)
        self.default_storage_policy_ec_m_not_in = kwargs.get("default_storage_policy_ec_m_not_in", None)
        self.default_storage_policy_in = kwargs.get("default_storage_policy_in", None)
        self.default_storage_policy_not = kwargs.get("default_storage_policy_not", None)
        self.default_storage_policy_not_in = kwargs.get("default_storage_policy_not_in", None)
        self.default_storage_policy_replica_num = kwargs.get("default_storage_policy_replica_num", None)
        self.default_storage_policy_replica_num_gt = kwargs.get("default_storage_policy_replica_num_gt", None)
        self.default_storage_policy_replica_num_gte = kwargs.get("default_storage_policy_replica_num_gte", None)
        self.default_storage_policy_replica_num_in = kwargs.get("default_storage_policy_replica_num_in", None)
        self.default_storage_policy_replica_num_lt = kwargs.get("default_storage_policy_replica_num_lt", None)
        self.default_storage_policy_replica_num_lte = kwargs.get("default_storage_policy_replica_num_lte", None)
        self.default_storage_policy_replica_num_not = kwargs.get("default_storage_policy_replica_num_not", None)
        self.default_storage_policy_replica_num_not_in = kwargs.get("default_storage_policy_replica_num_not_in", None)
        self.default_storage_policy_thin_provision = kwargs.get("default_storage_policy_thin_provision", None)
        self.default_storage_policy_thin_provision_not = kwargs.get("default_storage_policy_thin_provision_not", None)
        self.enabled_iscsi = kwargs.get("enabled_iscsi", None)
        self.enabled_iscsi_not = kwargs.get("enabled_iscsi_not", None)
        self.id = kwargs.get("id", None)
        self.id_contains = kwargs.get("id_contains", None)
        self.id_ends_with = kwargs.get("id_ends_with", None)
        self.id_gt = kwargs.get("id_gt", None)
        self.id_gte = kwargs.get("id_gte", None)
        self.id_in = kwargs.get("id_in", None)
        self.id_lt = kwargs.get("id_lt", None)
        self.id_lte = kwargs.get("id_lte", None)
        self.id_not = kwargs.get("id_not", None)
        self.id_not_contains = kwargs.get("id_not_contains", None)
        self.id_not_ends_with = kwargs.get("id_not_ends_with", None)
        self.id_not_in = kwargs.get("id_not_in", None)
        self.id_not_starts_with = kwargs.get("id_not_starts_with", None)
        self.id_starts_with = kwargs.get("id_starts_with", None)

    @property
    def _and(self):
        """Gets the _and of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The _and of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[ClusterSettingsWhereInput]
        """
        return self.__and

    @_and.setter
    def _and(self, _and):
        """Sets the _and of this ClusterSettingsWhereInput.


        :param _and: The _and of this ClusterSettingsWhereInput.  # noqa: E501
        :type _and: list[ClusterSettingsWhereInput]
        """

        self.__and = _and

    @property
    def _not(self):
        """Gets the _not of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The _not of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[ClusterSettingsWhereInput]
        """
        return self.__not

    @_not.setter
    def _not(self, _not):
        """Sets the _not of this ClusterSettingsWhereInput.


        :param _not: The _not of this ClusterSettingsWhereInput.  # noqa: E501
        :type _not: list[ClusterSettingsWhereInput]
        """

        self.__not = _not

    @property
    def _or(self):
        """Gets the _or of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The _or of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[ClusterSettingsWhereInput]
        """
        return self.__or

    @_or.setter
    def _or(self, _or):
        """Sets the _or of this ClusterSettingsWhereInput.


        :param _or: The _or of this ClusterSettingsWhereInput.  # noqa: E501
        :type _or: list[ClusterSettingsWhereInput]
        """

        self.__or = _or

    @property
    def cluster(self):
        """Gets the cluster of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The cluster of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this ClusterSettingsWhereInput.


        :param cluster: The cluster of this ClusterSettingsWhereInput.  # noqa: E501
        :type cluster: ClusterWhereInput
        """

        self._cluster = cluster

    @property
    def default_ha(self):
        """Gets the default_ha of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_ha of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._default_ha

    @default_ha.setter
    def default_ha(self, default_ha):
        """Sets the default_ha of this ClusterSettingsWhereInput.


        :param default_ha: The default_ha of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_ha: bool
        """

        self._default_ha = default_ha

    @property
    def default_ha_not(self):
        """Gets the default_ha_not of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_ha_not of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._default_ha_not

    @default_ha_not.setter
    def default_ha_not(self, default_ha_not):
        """Sets the default_ha_not of this ClusterSettingsWhereInput.


        :param default_ha_not: The default_ha_not of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_ha_not: bool
        """

        self._default_ha_not = default_ha_not

    @property
    def default_storage_policy(self):
        """Gets the default_storage_policy of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._default_storage_policy

    @default_storage_policy.setter
    def default_storage_policy(self, default_storage_policy):
        """Sets the default_storage_policy of this ClusterSettingsWhereInput.


        :param default_storage_policy: The default_storage_policy of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy: VmVolumeElfStoragePolicyType
        """

        self._default_storage_policy = default_storage_policy

    @property
    def default_storage_policy_ec_k(self):
        """Gets the default_storage_policy_ec_k of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_k of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_k

    @default_storage_policy_ec_k.setter
    def default_storage_policy_ec_k(self, default_storage_policy_ec_k):
        """Sets the default_storage_policy_ec_k of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_k: The default_storage_policy_ec_k of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_k: int
        """

        self._default_storage_policy_ec_k = default_storage_policy_ec_k

    @property
    def default_storage_policy_ec_k_gt(self):
        """Gets the default_storage_policy_ec_k_gt of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_k_gt of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_k_gt

    @default_storage_policy_ec_k_gt.setter
    def default_storage_policy_ec_k_gt(self, default_storage_policy_ec_k_gt):
        """Sets the default_storage_policy_ec_k_gt of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_k_gt: The default_storage_policy_ec_k_gt of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_k_gt: int
        """

        self._default_storage_policy_ec_k_gt = default_storage_policy_ec_k_gt

    @property
    def default_storage_policy_ec_k_gte(self):
        """Gets the default_storage_policy_ec_k_gte of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_k_gte of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_k_gte

    @default_storage_policy_ec_k_gte.setter
    def default_storage_policy_ec_k_gte(self, default_storage_policy_ec_k_gte):
        """Sets the default_storage_policy_ec_k_gte of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_k_gte: The default_storage_policy_ec_k_gte of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_k_gte: int
        """

        self._default_storage_policy_ec_k_gte = default_storage_policy_ec_k_gte

    @property
    def default_storage_policy_ec_k_in(self):
        """Gets the default_storage_policy_ec_k_in of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_k_in of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._default_storage_policy_ec_k_in

    @default_storage_policy_ec_k_in.setter
    def default_storage_policy_ec_k_in(self, default_storage_policy_ec_k_in):
        """Sets the default_storage_policy_ec_k_in of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_k_in: The default_storage_policy_ec_k_in of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_k_in: list[int]
        """

        self._default_storage_policy_ec_k_in = default_storage_policy_ec_k_in

    @property
    def default_storage_policy_ec_k_lt(self):
        """Gets the default_storage_policy_ec_k_lt of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_k_lt of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_k_lt

    @default_storage_policy_ec_k_lt.setter
    def default_storage_policy_ec_k_lt(self, default_storage_policy_ec_k_lt):
        """Sets the default_storage_policy_ec_k_lt of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_k_lt: The default_storage_policy_ec_k_lt of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_k_lt: int
        """

        self._default_storage_policy_ec_k_lt = default_storage_policy_ec_k_lt

    @property
    def default_storage_policy_ec_k_lte(self):
        """Gets the default_storage_policy_ec_k_lte of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_k_lte of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_k_lte

    @default_storage_policy_ec_k_lte.setter
    def default_storage_policy_ec_k_lte(self, default_storage_policy_ec_k_lte):
        """Sets the default_storage_policy_ec_k_lte of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_k_lte: The default_storage_policy_ec_k_lte of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_k_lte: int
        """

        self._default_storage_policy_ec_k_lte = default_storage_policy_ec_k_lte

    @property
    def default_storage_policy_ec_k_not(self):
        """Gets the default_storage_policy_ec_k_not of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_k_not of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_k_not

    @default_storage_policy_ec_k_not.setter
    def default_storage_policy_ec_k_not(self, default_storage_policy_ec_k_not):
        """Sets the default_storage_policy_ec_k_not of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_k_not: The default_storage_policy_ec_k_not of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_k_not: int
        """

        self._default_storage_policy_ec_k_not = default_storage_policy_ec_k_not

    @property
    def default_storage_policy_ec_k_not_in(self):
        """Gets the default_storage_policy_ec_k_not_in of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_k_not_in of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._default_storage_policy_ec_k_not_in

    @default_storage_policy_ec_k_not_in.setter
    def default_storage_policy_ec_k_not_in(self, default_storage_policy_ec_k_not_in):
        """Sets the default_storage_policy_ec_k_not_in of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_k_not_in: The default_storage_policy_ec_k_not_in of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_k_not_in: list[int]
        """

        self._default_storage_policy_ec_k_not_in = default_storage_policy_ec_k_not_in

    @property
    def default_storage_policy_ec_m(self):
        """Gets the default_storage_policy_ec_m of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_m of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_m

    @default_storage_policy_ec_m.setter
    def default_storage_policy_ec_m(self, default_storage_policy_ec_m):
        """Sets the default_storage_policy_ec_m of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_m: The default_storage_policy_ec_m of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_m: int
        """

        self._default_storage_policy_ec_m = default_storage_policy_ec_m

    @property
    def default_storage_policy_ec_m_gt(self):
        """Gets the default_storage_policy_ec_m_gt of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_m_gt of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_m_gt

    @default_storage_policy_ec_m_gt.setter
    def default_storage_policy_ec_m_gt(self, default_storage_policy_ec_m_gt):
        """Sets the default_storage_policy_ec_m_gt of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_m_gt: The default_storage_policy_ec_m_gt of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_m_gt: int
        """

        self._default_storage_policy_ec_m_gt = default_storage_policy_ec_m_gt

    @property
    def default_storage_policy_ec_m_gte(self):
        """Gets the default_storage_policy_ec_m_gte of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_m_gte of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_m_gte

    @default_storage_policy_ec_m_gte.setter
    def default_storage_policy_ec_m_gte(self, default_storage_policy_ec_m_gte):
        """Sets the default_storage_policy_ec_m_gte of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_m_gte: The default_storage_policy_ec_m_gte of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_m_gte: int
        """

        self._default_storage_policy_ec_m_gte = default_storage_policy_ec_m_gte

    @property
    def default_storage_policy_ec_m_in(self):
        """Gets the default_storage_policy_ec_m_in of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_m_in of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._default_storage_policy_ec_m_in

    @default_storage_policy_ec_m_in.setter
    def default_storage_policy_ec_m_in(self, default_storage_policy_ec_m_in):
        """Sets the default_storage_policy_ec_m_in of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_m_in: The default_storage_policy_ec_m_in of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_m_in: list[int]
        """

        self._default_storage_policy_ec_m_in = default_storage_policy_ec_m_in

    @property
    def default_storage_policy_ec_m_lt(self):
        """Gets the default_storage_policy_ec_m_lt of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_m_lt of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_m_lt

    @default_storage_policy_ec_m_lt.setter
    def default_storage_policy_ec_m_lt(self, default_storage_policy_ec_m_lt):
        """Sets the default_storage_policy_ec_m_lt of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_m_lt: The default_storage_policy_ec_m_lt of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_m_lt: int
        """

        self._default_storage_policy_ec_m_lt = default_storage_policy_ec_m_lt

    @property
    def default_storage_policy_ec_m_lte(self):
        """Gets the default_storage_policy_ec_m_lte of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_m_lte of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_m_lte

    @default_storage_policy_ec_m_lte.setter
    def default_storage_policy_ec_m_lte(self, default_storage_policy_ec_m_lte):
        """Sets the default_storage_policy_ec_m_lte of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_m_lte: The default_storage_policy_ec_m_lte of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_m_lte: int
        """

        self._default_storage_policy_ec_m_lte = default_storage_policy_ec_m_lte

    @property
    def default_storage_policy_ec_m_not(self):
        """Gets the default_storage_policy_ec_m_not of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_m_not of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_ec_m_not

    @default_storage_policy_ec_m_not.setter
    def default_storage_policy_ec_m_not(self, default_storage_policy_ec_m_not):
        """Sets the default_storage_policy_ec_m_not of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_m_not: The default_storage_policy_ec_m_not of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_m_not: int
        """

        self._default_storage_policy_ec_m_not = default_storage_policy_ec_m_not

    @property
    def default_storage_policy_ec_m_not_in(self):
        """Gets the default_storage_policy_ec_m_not_in of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_ec_m_not_in of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._default_storage_policy_ec_m_not_in

    @default_storage_policy_ec_m_not_in.setter
    def default_storage_policy_ec_m_not_in(self, default_storage_policy_ec_m_not_in):
        """Sets the default_storage_policy_ec_m_not_in of this ClusterSettingsWhereInput.


        :param default_storage_policy_ec_m_not_in: The default_storage_policy_ec_m_not_in of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_ec_m_not_in: list[int]
        """

        self._default_storage_policy_ec_m_not_in = default_storage_policy_ec_m_not_in

    @property
    def default_storage_policy_in(self):
        """Gets the default_storage_policy_in of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_in of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[VmVolumeElfStoragePolicyType]
        """
        return self._default_storage_policy_in

    @default_storage_policy_in.setter
    def default_storage_policy_in(self, default_storage_policy_in):
        """Sets the default_storage_policy_in of this ClusterSettingsWhereInput.


        :param default_storage_policy_in: The default_storage_policy_in of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_in: list[VmVolumeElfStoragePolicyType]
        """

        self._default_storage_policy_in = default_storage_policy_in

    @property
    def default_storage_policy_not(self):
        """Gets the default_storage_policy_not of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_not of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: VmVolumeElfStoragePolicyType
        """
        return self._default_storage_policy_not

    @default_storage_policy_not.setter
    def default_storage_policy_not(self, default_storage_policy_not):
        """Sets the default_storage_policy_not of this ClusterSettingsWhereInput.


        :param default_storage_policy_not: The default_storage_policy_not of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_not: VmVolumeElfStoragePolicyType
        """

        self._default_storage_policy_not = default_storage_policy_not

    @property
    def default_storage_policy_not_in(self):
        """Gets the default_storage_policy_not_in of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_not_in of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[VmVolumeElfStoragePolicyType]
        """
        return self._default_storage_policy_not_in

    @default_storage_policy_not_in.setter
    def default_storage_policy_not_in(self, default_storage_policy_not_in):
        """Sets the default_storage_policy_not_in of this ClusterSettingsWhereInput.


        :param default_storage_policy_not_in: The default_storage_policy_not_in of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_not_in: list[VmVolumeElfStoragePolicyType]
        """

        self._default_storage_policy_not_in = default_storage_policy_not_in

    @property
    def default_storage_policy_replica_num(self):
        """Gets the default_storage_policy_replica_num of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_replica_num of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_replica_num

    @default_storage_policy_replica_num.setter
    def default_storage_policy_replica_num(self, default_storage_policy_replica_num):
        """Sets the default_storage_policy_replica_num of this ClusterSettingsWhereInput.


        :param default_storage_policy_replica_num: The default_storage_policy_replica_num of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_replica_num: int
        """

        self._default_storage_policy_replica_num = default_storage_policy_replica_num

    @property
    def default_storage_policy_replica_num_gt(self):
        """Gets the default_storage_policy_replica_num_gt of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_replica_num_gt of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_replica_num_gt

    @default_storage_policy_replica_num_gt.setter
    def default_storage_policy_replica_num_gt(self, default_storage_policy_replica_num_gt):
        """Sets the default_storage_policy_replica_num_gt of this ClusterSettingsWhereInput.


        :param default_storage_policy_replica_num_gt: The default_storage_policy_replica_num_gt of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_replica_num_gt: int
        """

        self._default_storage_policy_replica_num_gt = default_storage_policy_replica_num_gt

    @property
    def default_storage_policy_replica_num_gte(self):
        """Gets the default_storage_policy_replica_num_gte of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_replica_num_gte of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_replica_num_gte

    @default_storage_policy_replica_num_gte.setter
    def default_storage_policy_replica_num_gte(self, default_storage_policy_replica_num_gte):
        """Sets the default_storage_policy_replica_num_gte of this ClusterSettingsWhereInput.


        :param default_storage_policy_replica_num_gte: The default_storage_policy_replica_num_gte of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_replica_num_gte: int
        """

        self._default_storage_policy_replica_num_gte = default_storage_policy_replica_num_gte

    @property
    def default_storage_policy_replica_num_in(self):
        """Gets the default_storage_policy_replica_num_in of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_replica_num_in of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._default_storage_policy_replica_num_in

    @default_storage_policy_replica_num_in.setter
    def default_storage_policy_replica_num_in(self, default_storage_policy_replica_num_in):
        """Sets the default_storage_policy_replica_num_in of this ClusterSettingsWhereInput.


        :param default_storage_policy_replica_num_in: The default_storage_policy_replica_num_in of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_replica_num_in: list[int]
        """

        self._default_storage_policy_replica_num_in = default_storage_policy_replica_num_in

    @property
    def default_storage_policy_replica_num_lt(self):
        """Gets the default_storage_policy_replica_num_lt of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_replica_num_lt of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_replica_num_lt

    @default_storage_policy_replica_num_lt.setter
    def default_storage_policy_replica_num_lt(self, default_storage_policy_replica_num_lt):
        """Sets the default_storage_policy_replica_num_lt of this ClusterSettingsWhereInput.


        :param default_storage_policy_replica_num_lt: The default_storage_policy_replica_num_lt of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_replica_num_lt: int
        """

        self._default_storage_policy_replica_num_lt = default_storage_policy_replica_num_lt

    @property
    def default_storage_policy_replica_num_lte(self):
        """Gets the default_storage_policy_replica_num_lte of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_replica_num_lte of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_replica_num_lte

    @default_storage_policy_replica_num_lte.setter
    def default_storage_policy_replica_num_lte(self, default_storage_policy_replica_num_lte):
        """Sets the default_storage_policy_replica_num_lte of this ClusterSettingsWhereInput.


        :param default_storage_policy_replica_num_lte: The default_storage_policy_replica_num_lte of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_replica_num_lte: int
        """

        self._default_storage_policy_replica_num_lte = default_storage_policy_replica_num_lte

    @property
    def default_storage_policy_replica_num_not(self):
        """Gets the default_storage_policy_replica_num_not of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_replica_num_not of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: int
        """
        return self._default_storage_policy_replica_num_not

    @default_storage_policy_replica_num_not.setter
    def default_storage_policy_replica_num_not(self, default_storage_policy_replica_num_not):
        """Sets the default_storage_policy_replica_num_not of this ClusterSettingsWhereInput.


        :param default_storage_policy_replica_num_not: The default_storage_policy_replica_num_not of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_replica_num_not: int
        """

        self._default_storage_policy_replica_num_not = default_storage_policy_replica_num_not

    @property
    def default_storage_policy_replica_num_not_in(self):
        """Gets the default_storage_policy_replica_num_not_in of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_replica_num_not_in of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[int]
        """
        return self._default_storage_policy_replica_num_not_in

    @default_storage_policy_replica_num_not_in.setter
    def default_storage_policy_replica_num_not_in(self, default_storage_policy_replica_num_not_in):
        """Sets the default_storage_policy_replica_num_not_in of this ClusterSettingsWhereInput.


        :param default_storage_policy_replica_num_not_in: The default_storage_policy_replica_num_not_in of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_replica_num_not_in: list[int]
        """

        self._default_storage_policy_replica_num_not_in = default_storage_policy_replica_num_not_in

    @property
    def default_storage_policy_thin_provision(self):
        """Gets the default_storage_policy_thin_provision of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_thin_provision of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._default_storage_policy_thin_provision

    @default_storage_policy_thin_provision.setter
    def default_storage_policy_thin_provision(self, default_storage_policy_thin_provision):
        """Sets the default_storage_policy_thin_provision of this ClusterSettingsWhereInput.


        :param default_storage_policy_thin_provision: The default_storage_policy_thin_provision of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_thin_provision: bool
        """

        self._default_storage_policy_thin_provision = default_storage_policy_thin_provision

    @property
    def default_storage_policy_thin_provision_not(self):
        """Gets the default_storage_policy_thin_provision_not of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The default_storage_policy_thin_provision_not of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._default_storage_policy_thin_provision_not

    @default_storage_policy_thin_provision_not.setter
    def default_storage_policy_thin_provision_not(self, default_storage_policy_thin_provision_not):
        """Sets the default_storage_policy_thin_provision_not of this ClusterSettingsWhereInput.


        :param default_storage_policy_thin_provision_not: The default_storage_policy_thin_provision_not of this ClusterSettingsWhereInput.  # noqa: E501
        :type default_storage_policy_thin_provision_not: bool
        """

        self._default_storage_policy_thin_provision_not = default_storage_policy_thin_provision_not

    @property
    def enabled_iscsi(self):
        """Gets the enabled_iscsi of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The enabled_iscsi of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._enabled_iscsi

    @enabled_iscsi.setter
    def enabled_iscsi(self, enabled_iscsi):
        """Sets the enabled_iscsi of this ClusterSettingsWhereInput.


        :param enabled_iscsi: The enabled_iscsi of this ClusterSettingsWhereInput.  # noqa: E501
        :type enabled_iscsi: bool
        """

        self._enabled_iscsi = enabled_iscsi

    @property
    def enabled_iscsi_not(self):
        """Gets the enabled_iscsi_not of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The enabled_iscsi_not of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: bool
        """
        return self._enabled_iscsi_not

    @enabled_iscsi_not.setter
    def enabled_iscsi_not(self, enabled_iscsi_not):
        """Sets the enabled_iscsi_not of this ClusterSettingsWhereInput.


        :param enabled_iscsi_not: The enabled_iscsi_not of this ClusterSettingsWhereInput.  # noqa: E501
        :type enabled_iscsi_not: bool
        """

        self._enabled_iscsi_not = enabled_iscsi_not

    @property
    def id(self):
        """Gets the id of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ClusterSettingsWhereInput.


        :param id: The id of this ClusterSettingsWhereInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def id_contains(self):
        """Gets the id_contains of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_contains of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_contains

    @id_contains.setter
    def id_contains(self, id_contains):
        """Sets the id_contains of this ClusterSettingsWhereInput.


        :param id_contains: The id_contains of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_contains: str
        """

        self._id_contains = id_contains

    @property
    def id_ends_with(self):
        """Gets the id_ends_with of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_ends_with of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_ends_with

    @id_ends_with.setter
    def id_ends_with(self, id_ends_with):
        """Sets the id_ends_with of this ClusterSettingsWhereInput.


        :param id_ends_with: The id_ends_with of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_ends_with: str
        """

        self._id_ends_with = id_ends_with

    @property
    def id_gt(self):
        """Gets the id_gt of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_gt of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gt

    @id_gt.setter
    def id_gt(self, id_gt):
        """Sets the id_gt of this ClusterSettingsWhereInput.


        :param id_gt: The id_gt of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_gt: str
        """

        self._id_gt = id_gt

    @property
    def id_gte(self):
        """Gets the id_gte of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_gte of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_gte

    @id_gte.setter
    def id_gte(self, id_gte):
        """Sets the id_gte of this ClusterSettingsWhereInput.


        :param id_gte: The id_gte of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_gte: str
        """

        self._id_gte = id_gte

    @property
    def id_in(self):
        """Gets the id_in of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_in of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this ClusterSettingsWhereInput.


        :param id_in: The id_in of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_in: list[str]
        """

        self._id_in = id_in

    @property
    def id_lt(self):
        """Gets the id_lt of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_lt of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lt

    @id_lt.setter
    def id_lt(self, id_lt):
        """Sets the id_lt of this ClusterSettingsWhereInput.


        :param id_lt: The id_lt of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_lt: str
        """

        self._id_lt = id_lt

    @property
    def id_lte(self):
        """Gets the id_lte of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_lte of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_lte

    @id_lte.setter
    def id_lte(self, id_lte):
        """Sets the id_lte of this ClusterSettingsWhereInput.


        :param id_lte: The id_lte of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_lte: str
        """

        self._id_lte = id_lte

    @property
    def id_not(self):
        """Gets the id_not of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_not of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not

    @id_not.setter
    def id_not(self, id_not):
        """Sets the id_not of this ClusterSettingsWhereInput.


        :param id_not: The id_not of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_not: str
        """

        self._id_not = id_not

    @property
    def id_not_contains(self):
        """Gets the id_not_contains of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_not_contains of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_contains

    @id_not_contains.setter
    def id_not_contains(self, id_not_contains):
        """Sets the id_not_contains of this ClusterSettingsWhereInput.


        :param id_not_contains: The id_not_contains of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_not_contains: str
        """

        self._id_not_contains = id_not_contains

    @property
    def id_not_ends_with(self):
        """Gets the id_not_ends_with of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_not_ends_with of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_ends_with

    @id_not_ends_with.setter
    def id_not_ends_with(self, id_not_ends_with):
        """Sets the id_not_ends_with of this ClusterSettingsWhereInput.


        :param id_not_ends_with: The id_not_ends_with of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_not_ends_with: str
        """

        self._id_not_ends_with = id_not_ends_with

    @property
    def id_not_in(self):
        """Gets the id_not_in of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_not_in of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_not_in

    @id_not_in.setter
    def id_not_in(self, id_not_in):
        """Sets the id_not_in of this ClusterSettingsWhereInput.


        :param id_not_in: The id_not_in of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_not_in: list[str]
        """

        self._id_not_in = id_not_in

    @property
    def id_not_starts_with(self):
        """Gets the id_not_starts_with of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_not_starts_with of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_not_starts_with

    @id_not_starts_with.setter
    def id_not_starts_with(self, id_not_starts_with):
        """Sets the id_not_starts_with of this ClusterSettingsWhereInput.


        :param id_not_starts_with: The id_not_starts_with of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_not_starts_with: str
        """

        self._id_not_starts_with = id_not_starts_with

    @property
    def id_starts_with(self):
        """Gets the id_starts_with of this ClusterSettingsWhereInput.  # noqa: E501


        :return: The id_starts_with of this ClusterSettingsWhereInput.  # noqa: E501
        :rtype: str
        """
        return self._id_starts_with

    @id_starts_with.setter
    def id_starts_with(self, id_starts_with):
        """Sets the id_starts_with of this ClusterSettingsWhereInput.


        :param id_starts_with: The id_starts_with of this ClusterSettingsWhereInput.  # noqa: E501
        :type id_starts_with: str
        """

        self._id_starts_with = id_starts_with

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterSettingsWhereInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ClusterSettingsWhereInput):
            return True

        return self.to_dict() != other.to_dict()
