# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ClusterVirtualizationUpdationParamsData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'auto_converge': 'bool',
        'current_cpu_model': 'str'
    }

    attribute_map = {
        'auto_converge': 'auto_converge',
        'current_cpu_model': 'current_cpu_model'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ClusterVirtualizationUpdationParamsData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._auto_converge = None
        self._current_cpu_model = None
        self.discriminator = None

        if "auto_converge" in kwargs:
            self.auto_converge = kwargs["auto_converge"]
        if "current_cpu_model" in kwargs:
            self.current_cpu_model = kwargs["current_cpu_model"]

    @property
    def auto_converge(self):
        """Gets the auto_converge of this ClusterVirtualizationUpdationParamsData.  # noqa: E501


        :return: The auto_converge of this ClusterVirtualizationUpdationParamsData.  # noqa: E501
        :rtype: bool
        """
        return self._auto_converge

    @auto_converge.setter
    def auto_converge(self, auto_converge):
        """Sets the auto_converge of this ClusterVirtualizationUpdationParamsData.


        :param auto_converge: The auto_converge of this ClusterVirtualizationUpdationParamsData.  # noqa: E501
        :type auto_converge: bool
        """

        self._auto_converge = auto_converge

    @property
    def current_cpu_model(self):
        """Gets the current_cpu_model of this ClusterVirtualizationUpdationParamsData.  # noqa: E501


        :return: The current_cpu_model of this ClusterVirtualizationUpdationParamsData.  # noqa: E501
        :rtype: str
        """
        return self._current_cpu_model

    @current_cpu_model.setter
    def current_cpu_model(self, current_cpu_model):
        """Sets the current_cpu_model of this ClusterVirtualizationUpdationParamsData.


        :param current_cpu_model: The current_cpu_model of this ClusterVirtualizationUpdationParamsData.  # noqa: E501
        :type current_cpu_model: str
        """

        self._current_cpu_model = current_cpu_model

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterVirtualizationUpdationParamsData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ClusterVirtualizationUpdationParamsData):
            return True

        return self.to_dict() != other.to_dict()
