# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ConsistencyGroupSnapshot(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'iscsi_lun_snapshots': 'list[NestedIscsiLunSnapshot]',
        'consistency_group': 'NestedConsistencyGroup',
        'entity_async_status': 'EntityAsyncStatus',
        'id': 'str',
        'labels': 'list[NestedLabel]',
        'local_created_at': 'str',
        'local_id': 'str',
        'name': 'str',
        'nvmf_namespace_snapshots': 'list[NestedNvmfNamespaceSnapshot]',
        'unique_size': 'int'
    }

    attribute_map = {
        'iscsi_lun_snapshots': 'Iscsi_lun_snapshots',
        'consistency_group': 'consistency_group',
        'entity_async_status': 'entityAsyncStatus',
        'id': 'id',
        'labels': 'labels',
        'local_created_at': 'local_created_at',
        'local_id': 'local_id',
        'name': 'name',
        'nvmf_namespace_snapshots': 'nvmf_namespace_snapshots',
        'unique_size': 'unique_size'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ConsistencyGroupSnapshot - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._iscsi_lun_snapshots = None
        self._consistency_group = None
        self._entity_async_status = None
        self._id = None
        self._labels = None
        self._local_created_at = None
        self._local_id = None
        self._name = None
        self._nvmf_namespace_snapshots = None
        self._unique_size = None
        self.discriminator = None

        self.iscsi_lun_snapshots = kwargs.get("iscsi_lun_snapshots", None)
        self.consistency_group = kwargs.get("consistency_group", None)
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.labels = kwargs.get("labels", None)
        if "local_created_at" in kwargs:
            self.local_created_at = kwargs["local_created_at"]
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.nvmf_namespace_snapshots = kwargs.get("nvmf_namespace_snapshots", None)
        if "unique_size" in kwargs:
            self.unique_size = kwargs["unique_size"]

    @property
    def iscsi_lun_snapshots(self):
        """Gets the iscsi_lun_snapshots of this ConsistencyGroupSnapshot.  # noqa: E501


        :return: The iscsi_lun_snapshots of this ConsistencyGroupSnapshot.  # noqa: E501
        :rtype: list[NestedIscsiLunSnapshot]
        """
        return self._iscsi_lun_snapshots

    @iscsi_lun_snapshots.setter
    def iscsi_lun_snapshots(self, iscsi_lun_snapshots):
        """Sets the iscsi_lun_snapshots of this ConsistencyGroupSnapshot.


        :param iscsi_lun_snapshots: The iscsi_lun_snapshots of this ConsistencyGroupSnapshot.  # noqa: E501
        :type iscsi_lun_snapshots: list[NestedIscsiLunSnapshot]
        """

        self._iscsi_lun_snapshots = iscsi_lun_snapshots

    @property
    def consistency_group(self):
        """Gets the consistency_group of this ConsistencyGroupSnapshot.  # noqa: E501


        :return: The consistency_group of this ConsistencyGroupSnapshot.  # noqa: E501
        :rtype: NestedConsistencyGroup
        """
        return self._consistency_group

    @consistency_group.setter
    def consistency_group(self, consistency_group):
        """Sets the consistency_group of this ConsistencyGroupSnapshot.


        :param consistency_group: The consistency_group of this ConsistencyGroupSnapshot.  # noqa: E501
        :type consistency_group: NestedConsistencyGroup
        """

        self._consistency_group = consistency_group

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this ConsistencyGroupSnapshot.  # noqa: E501


        :return: The entity_async_status of this ConsistencyGroupSnapshot.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this ConsistencyGroupSnapshot.


        :param entity_async_status: The entity_async_status of this ConsistencyGroupSnapshot.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def id(self):
        """Gets the id of this ConsistencyGroupSnapshot.  # noqa: E501


        :return: The id of this ConsistencyGroupSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ConsistencyGroupSnapshot.


        :param id: The id of this ConsistencyGroupSnapshot.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def labels(self):
        """Gets the labels of this ConsistencyGroupSnapshot.  # noqa: E501


        :return: The labels of this ConsistencyGroupSnapshot.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this ConsistencyGroupSnapshot.


        :param labels: The labels of this ConsistencyGroupSnapshot.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def local_created_at(self):
        """Gets the local_created_at of this ConsistencyGroupSnapshot.  # noqa: E501


        :return: The local_created_at of this ConsistencyGroupSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._local_created_at

    @local_created_at.setter
    def local_created_at(self, local_created_at):
        """Sets the local_created_at of this ConsistencyGroupSnapshot.


        :param local_created_at: The local_created_at of this ConsistencyGroupSnapshot.  # noqa: E501
        :type local_created_at: str
        """
        if self.local_vars_configuration.client_side_validation and local_created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `local_created_at`, must not be `None`")  # noqa: E501

        self._local_created_at = local_created_at

    @property
    def local_id(self):
        """Gets the local_id of this ConsistencyGroupSnapshot.  # noqa: E501


        :return: The local_id of this ConsistencyGroupSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this ConsistencyGroupSnapshot.


        :param local_id: The local_id of this ConsistencyGroupSnapshot.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def name(self):
        """Gets the name of this ConsistencyGroupSnapshot.  # noqa: E501


        :return: The name of this ConsistencyGroupSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ConsistencyGroupSnapshot.


        :param name: The name of this ConsistencyGroupSnapshot.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def nvmf_namespace_snapshots(self):
        """Gets the nvmf_namespace_snapshots of this ConsistencyGroupSnapshot.  # noqa: E501


        :return: The nvmf_namespace_snapshots of this ConsistencyGroupSnapshot.  # noqa: E501
        :rtype: list[NestedNvmfNamespaceSnapshot]
        """
        return self._nvmf_namespace_snapshots

    @nvmf_namespace_snapshots.setter
    def nvmf_namespace_snapshots(self, nvmf_namespace_snapshots):
        """Sets the nvmf_namespace_snapshots of this ConsistencyGroupSnapshot.


        :param nvmf_namespace_snapshots: The nvmf_namespace_snapshots of this ConsistencyGroupSnapshot.  # noqa: E501
        :type nvmf_namespace_snapshots: list[NestedNvmfNamespaceSnapshot]
        """

        self._nvmf_namespace_snapshots = nvmf_namespace_snapshots

    @property
    def unique_size(self):
        """Gets the unique_size of this ConsistencyGroupSnapshot.  # noqa: E501


        :return: The unique_size of this ConsistencyGroupSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._unique_size

    @unique_size.setter
    def unique_size(self, unique_size):
        """Sets the unique_size of this ConsistencyGroupSnapshot.


        :param unique_size: The unique_size of this ConsistencyGroupSnapshot.  # noqa: E501
        :type unique_size: int
        """
        if self.local_vars_configuration.client_side_validation and unique_size is None:  # noqa: E501
            raise ValueError("Invalid value for `unique_size`, must not be `None`")  # noqa: E501

        self._unique_size = unique_size

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConsistencyGroupSnapshot):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ConsistencyGroupSnapshot):
            return True

        return self.to_dict() != other.to_dict()
