# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ContentLibraryImageImportData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'url': 'str',
        'name': 'str',
        'description': 'str',
        'cluster': 'ClusterWhereInput'
    }

    attribute_map = {
        'url': 'url',
        'name': 'name',
        'description': 'description',
        'cluster': 'cluster'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ContentLibraryImageImportData - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._url = None
        self._name = None
        self._description = None
        self._cluster = None
        self.discriminator = None

        if "url" in kwargs:
            self.url = kwargs["url"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]

    @property
    def url(self):
        """Gets the url of this ContentLibraryImageImportData.  # noqa: E501


        :return: The url of this ContentLibraryImageImportData.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ContentLibraryImageImportData.


        :param url: The url of this ContentLibraryImageImportData.  # noqa: E501
        :type url: str
        """
        if self.local_vars_configuration.client_side_validation and url is None:  # noqa: E501
            raise ValueError("Invalid value for `url`, must not be `None`")  # noqa: E501

        self._url = url

    @property
    def name(self):
        """Gets the name of this ContentLibraryImageImportData.  # noqa: E501


        :return: The name of this ContentLibraryImageImportData.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ContentLibraryImageImportData.


        :param name: The name of this ContentLibraryImageImportData.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this ContentLibraryImageImportData.  # noqa: E501


        :return: The description of this ContentLibraryImageImportData.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ContentLibraryImageImportData.


        :param description: The description of this ContentLibraryImageImportData.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def cluster(self):
        """Gets the cluster of this ContentLibraryImageImportData.  # noqa: E501


        :return: The cluster of this ContentLibraryImageImportData.  # noqa: E501
        :rtype: ClusterWhereInput
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this ContentLibraryImageImportData.


        :param cluster: The cluster of this ContentLibraryImageImportData.  # noqa: E501
        :type cluster: ClusterWhereInput
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContentLibraryImageImportData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContentLibraryImageImportData):
            return True

        return self.to_dict() != other.to_dict()
