# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ContentLibraryImportVmNic(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'mirror': 'bool',
        'model': 'VmNicModel',
        'enabled': 'bool'
    }

    attribute_map = {
        'mirror': 'mirror',
        'model': 'model',
        'enabled': 'enabled'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ContentLibraryImportVmNic - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._mirror = None
        self._model = None
        self._enabled = None
        self.discriminator = None

        if "mirror" in kwargs:
            self.mirror = kwargs["mirror"]
        if "model" in kwargs:
            self.model = kwargs["model"]
        if "enabled" in kwargs:
            self.enabled = kwargs["enabled"]

    @property
    def mirror(self):
        """Gets the mirror of this ContentLibraryImportVmNic.  # noqa: E501


        :return: The mirror of this ContentLibraryImportVmNic.  # noqa: E501
        :rtype: bool
        """
        return self._mirror

    @mirror.setter
    def mirror(self, mirror):
        """Sets the mirror of this ContentLibraryImportVmNic.


        :param mirror: The mirror of this ContentLibraryImportVmNic.  # noqa: E501
        :type mirror: bool
        """

        self._mirror = mirror

    @property
    def model(self):
        """Gets the model of this ContentLibraryImportVmNic.  # noqa: E501


        :return: The model of this ContentLibraryImportVmNic.  # noqa: E501
        :rtype: VmNicModel
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this ContentLibraryImportVmNic.


        :param model: The model of this ContentLibraryImportVmNic.  # noqa: E501
        :type model: VmNicModel
        """
        if self.local_vars_configuration.client_side_validation and model is None:  # noqa: E501
            raise ValueError("Invalid value for `model`, must not be `None`")  # noqa: E501

        self._model = model

    @property
    def enabled(self):
        """Gets the enabled of this ContentLibraryImportVmNic.  # noqa: E501


        :return: The enabled of this ContentLibraryImportVmNic.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this ContentLibraryImportVmNic.


        :param enabled: The enabled of this ContentLibraryImportVmNic.  # noqa: E501
        :type enabled: bool
        """

        self._enabled = enabled

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContentLibraryImportVmNic):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContentLibraryImportVmNic):
            return True

        return self.to_dict() != other.to_dict()
