# coding: utf-8
try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class ContentLibraryVmTemplateImportParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'vm_nics': 'list[ContentLibraryImportVmNic]',
        'disk_operate': 'ContentLibraryVmTemplateOvfDiskOperate',
        'ha': 'bool',
        'memory_unit': 'ByteUnit',
        'memory': 'int',
        'vcpu': 'int',
        'cpu_cores': 'int',
        'cpu_sockets': 'int',
        'description': 'str',
        'name': 'str',
        'upload_tasks': 'list[str]',
        'parsed_ovf': 'ParsedOVF',
        'cluster_id': 'str'
    }

    attribute_map = {
        'vm_nics': 'vm_nics',
        'disk_operate': 'disk_operate',
        'ha': 'ha',
        'memory_unit': 'memory_unit',
        'memory': 'memory',
        'vcpu': 'vcpu',
        'cpu_cores': 'cpu_cores',
        'cpu_sockets': 'cpu_sockets',
        'description': 'description',
        'name': 'name',
        'upload_tasks': 'upload_tasks',
        'parsed_ovf': 'parsed_ovf',
        'cluster_id': 'cluster_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """ContentLibraryVmTemplateImportParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._vm_nics = None
        self._disk_operate = None
        self._ha = None
        self._memory_unit = None
        self._memory = None
        self._vcpu = None
        self._cpu_cores = None
        self._cpu_sockets = None
        self._description = None
        self._name = None
        self._upload_tasks = None
        self._parsed_ovf = None
        self._cluster_id = None
        self.discriminator = None

        if "vm_nics" in kwargs:
            self.vm_nics = kwargs["vm_nics"]
        if "disk_operate" in kwargs:
            self.disk_operate = kwargs["disk_operate"]
        if "ha" in kwargs:
            self.ha = kwargs["ha"]
        if "memory_unit" in kwargs:
            self.memory_unit = kwargs["memory_unit"]
        if "memory" in kwargs:
            self.memory = kwargs["memory"]
        if "vcpu" in kwargs:
            self.vcpu = kwargs["vcpu"]
        if "cpu_cores" in kwargs:
            self.cpu_cores = kwargs["cpu_cores"]
        if "cpu_sockets" in kwargs:
            self.cpu_sockets = kwargs["cpu_sockets"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "upload_tasks" in kwargs:
            self.upload_tasks = kwargs["upload_tasks"]
        if "parsed_ovf" in kwargs:
            self.parsed_ovf = kwargs["parsed_ovf"]
        if "cluster_id" in kwargs:
            self.cluster_id = kwargs["cluster_id"]

    @property
    def vm_nics(self):
        """Gets the vm_nics of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The vm_nics of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: list[ContentLibraryImportVmNic]
        """
        return self._vm_nics

    @vm_nics.setter
    def vm_nics(self, vm_nics):
        """Sets the vm_nics of this ContentLibraryVmTemplateImportParams.


        :param vm_nics: The vm_nics of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type vm_nics: list[ContentLibraryImportVmNic]
        """

        self._vm_nics = vm_nics

    @property
    def disk_operate(self):
        """Gets the disk_operate of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The disk_operate of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: ContentLibraryVmTemplateOvfDiskOperate
        """
        return self._disk_operate

    @disk_operate.setter
    def disk_operate(self, disk_operate):
        """Sets the disk_operate of this ContentLibraryVmTemplateImportParams.


        :param disk_operate: The disk_operate of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type disk_operate: ContentLibraryVmTemplateOvfDiskOperate
        """

        self._disk_operate = disk_operate

    @property
    def ha(self):
        """Gets the ha of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The ha of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: bool
        """
        return self._ha

    @ha.setter
    def ha(self, ha):
        """Sets the ha of this ContentLibraryVmTemplateImportParams.


        :param ha: The ha of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type ha: bool
        """

        self._ha = ha

    @property
    def memory_unit(self):
        """Gets the memory_unit of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The memory_unit of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: ByteUnit
        """
        return self._memory_unit

    @memory_unit.setter
    def memory_unit(self, memory_unit):
        """Sets the memory_unit of this ContentLibraryVmTemplateImportParams.


        :param memory_unit: The memory_unit of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type memory_unit: ByteUnit
        """

        self._memory_unit = memory_unit

    @property
    def memory(self):
        """Gets the memory of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The memory of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: int
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """Sets the memory of this ContentLibraryVmTemplateImportParams.


        :param memory: The memory of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type memory: int
        """

        self._memory = memory

    @property
    def vcpu(self):
        """Gets the vcpu of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The vcpu of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: int
        """
        return self._vcpu

    @vcpu.setter
    def vcpu(self, vcpu):
        """Sets the vcpu of this ContentLibraryVmTemplateImportParams.


        :param vcpu: The vcpu of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type vcpu: int
        """

        self._vcpu = vcpu

    @property
    def cpu_cores(self):
        """Gets the cpu_cores of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The cpu_cores of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: int
        """
        return self._cpu_cores

    @cpu_cores.setter
    def cpu_cores(self, cpu_cores):
        """Sets the cpu_cores of this ContentLibraryVmTemplateImportParams.


        :param cpu_cores: The cpu_cores of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type cpu_cores: int
        """

        self._cpu_cores = cpu_cores

    @property
    def cpu_sockets(self):
        """Gets the cpu_sockets of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The cpu_sockets of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: int
        """
        return self._cpu_sockets

    @cpu_sockets.setter
    def cpu_sockets(self, cpu_sockets):
        """Sets the cpu_sockets of this ContentLibraryVmTemplateImportParams.


        :param cpu_sockets: The cpu_sockets of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type cpu_sockets: int
        """

        self._cpu_sockets = cpu_sockets

    @property
    def description(self):
        """Gets the description of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The description of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ContentLibraryVmTemplateImportParams.


        :param description: The description of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def name(self):
        """Gets the name of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The name of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ContentLibraryVmTemplateImportParams.


        :param name: The name of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def upload_tasks(self):
        """Gets the upload_tasks of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The upload_tasks of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._upload_tasks

    @upload_tasks.setter
    def upload_tasks(self, upload_tasks):
        """Sets the upload_tasks of this ContentLibraryVmTemplateImportParams.


        :param upload_tasks: The upload_tasks of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type upload_tasks: list[str]
        """
        if self.local_vars_configuration.client_side_validation and upload_tasks is None:  # noqa: E501
            raise ValueError("Invalid value for `upload_tasks`, must not be `None`")  # noqa: E501

        self._upload_tasks = upload_tasks

    @property
    def parsed_ovf(self):
        """Gets the parsed_ovf of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The parsed_ovf of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: ParsedOVF
        """
        return self._parsed_ovf

    @parsed_ovf.setter
    def parsed_ovf(self, parsed_ovf):
        """Sets the parsed_ovf of this ContentLibraryVmTemplateImportParams.


        :param parsed_ovf: The parsed_ovf of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type parsed_ovf: ParsedOVF
        """
        if self.local_vars_configuration.client_side_validation and parsed_ovf is None:  # noqa: E501
            raise ValueError("Invalid value for `parsed_ovf`, must not be `None`")  # noqa: E501

        self._parsed_ovf = parsed_ovf

    @property
    def cluster_id(self):
        """Gets the cluster_id of this ContentLibraryVmTemplateImportParams.  # noqa: E501


        :return: The cluster_id of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """Sets the cluster_id of this ContentLibraryVmTemplateImportParams.


        :param cluster_id: The cluster_id of this ContentLibraryVmTemplateImportParams.  # noqa: E501
        :type cluster_id: str
        """
        if self.local_vars_configuration.client_side_validation and cluster_id is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster_id`, must not be `None`")  # noqa: E501

        self._cluster_id = cluster_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContentLibraryVmTemplateImportParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ContentLibraryVmTemplateImportParams):
            return True

        return self.to_dict() != other.to_dict()
